#ifndef _EFL_UI_POPUP_EO_H_
#define _EFL_UI_POPUP_EO_H_

#ifndef _EFL_UI_POPUP_EO_CLASS_TYPE
#define _EFL_UI_POPUP_EO_CLASS_TYPE

typedef Eo Efl_Ui_Popup;

#endif

#ifndef _EFL_UI_POPUP_EO_TYPES
#define _EFL_UI_POPUP_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Popup alignment type
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_POPUP_ALIGN_NONE = 0, /**< Popup not aligned */
  EFL_UI_POPUP_ALIGN_CENTER, /**< Popup aligned to center */
  EFL_UI_POPUP_ALIGN_LEFT, /**< Popup aligned to left */
  EFL_UI_POPUP_ALIGN_RIGHT, /**< Popup aligned to right */
  EFL_UI_POPUP_ALIGN_TOP, /**< Popup aligned to top */
  EFL_UI_POPUP_ALIGN_BOTTOM /**< Popup aligned to bottom */
} Efl_Ui_Popup_Align;
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/** EFL UI popup class
 *
 * @ingroup Efl_Ui_Popup
 */
#define EFL_UI_POPUP_CLASS efl_ui_popup_class_get()

EWAPI const Efl_Class *efl_ui_popup_class_get(void);

/**
 * @brief Set the popup alignment.
 *
 * @param[in] obj The object.
 * @param[in] type Alignment type
 *
 * @ingroup Efl_Ui_Popup
 */
EOAPI void efl_ui_popup_align_set(Eo *obj, Efl_Ui_Popup_Align type);

/**
 * @brief Get the current popup alignment.
 *
 * @param[in] obj The object.
 *
 * @return Alignment type
 *
 * @ingroup Efl_Ui_Popup
 */
EOAPI Efl_Ui_Popup_Align efl_ui_popup_align_get(const Eo *obj);

/**
 * @brief Set the timeout seconds. After timeout seconds, popup will be deleted
 * automatically.
 *
 * @param[in] obj The object.
 * @param[in] time Timeout in seconds
 *
 * @ingroup Efl_Ui_Popup
 */
EOAPI void efl_ui_popup_timeout_set(Eo *obj, double time);

/**
 * @brief Get the currently set timeout seconds.
 *
 * @param[in] obj The object.
 *
 * @return Timeout in seconds
 *
 * @ingroup Efl_Ui_Popup
 */
EOAPI double efl_ui_popup_timeout_get(const Eo *obj);

/**
 * @brief Set the popup size.
 *
 * @param[in] obj The object.
 * @param[in] size
 *
 * @ingroup Efl_Ui_Popup
 */
EOAPI void efl_ui_popup_size_set(Eo *obj, Eina_Size2D size);

/** get the current popup size.
 *
 * @ingroup Efl_Ui_Popup
 */
EOAPI Eina_Size2D efl_ui_popup_size_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_UI_POPUP_EVENT_BACKWALL_CLICKED;

/** This is called whenever the user clicks back wall of popup.
 *
 * @ingroup Efl_Ui_Popup
 */
#define EFL_UI_POPUP_EVENT_BACKWALL_CLICKED (&(_EFL_UI_POPUP_EVENT_BACKWALL_CLICKED))

EWAPI extern const Efl_Event_Description _EFL_UI_POPUP_EVENT_TIMEOUT;

/** This is called when popup times out.
 *
 * @ingroup Efl_Ui_Popup
 */
#define EFL_UI_POPUP_EVENT_TIMEOUT (&(_EFL_UI_POPUP_EVENT_TIMEOUT))
#endif /* EFL_BETA_API_SUPPORT */

#endif
