#ifndef _EFL_UI_SPIN_EO_H_
#define _EFL_UI_SPIN_EO_H_

#ifndef _EFL_UI_SPIN_EO_CLASS_TYPE
#define _EFL_UI_SPIN_EO_CLASS_TYPE

typedef Eo Efl_Ui_Spin;

#endif

#ifndef _EFL_UI_SPIN_EO_TYPES
#define _EFL_UI_SPIN_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Special value
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Spin_Special_Value
{
  double value; /**< Target value */
  const char *label; /**< String to replace */
} Efl_Ui_Spin_Special_Value;
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief A Spin.
 *
 * This is a widget which allows the user to increase or decrease numeric
 * values using user interactions. It's a basic type of widget for choosing and
 * displaying values.
 *
 * @ingroup Efl_Ui_Spin
 */
#define EFL_UI_SPIN_CLASS efl_ui_spin_class_get()

EWAPI const Efl_Class *efl_ui_spin_class_get(void);

/**
 * @brief Control special string to display in the place of the numerical
 * value.
 *
 * It's useful for cases when a user should select an item that is better
 * indicated by a label than a value. For example, weekdays or months.
 *
 * @note If another label was previously set to @c value, it will be replaced
 * by the new label.
 *
 * @param[in] obj The object.
 * @param[in] values The array of special values, or NULL if none
 *
 * @ingroup Efl_Ui_Spin
 */
EOAPI void efl_ui_spin_special_value_set(Eo *obj, const Eina_Array *values);

/**
 * @brief Control special string to display in the place of the numerical
 * value.
 *
 * It's useful for cases when a user should select an item that is better
 * indicated by a label than a value. For example, weekdays or months.
 *
 * @note If another label was previously set to @c value, it will be replaced
 * by the new label.
 *
 * @param[in] obj The object.
 *
 * @return The array of special values, or NULL if none
 *
 * @ingroup Efl_Ui_Spin
 */
EOAPI const Eina_Array *efl_ui_spin_special_value_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_UI_SPIN_EVENT_CHANGED;

/** Called when spin changed
 *
 * @ingroup Efl_Ui_Spin
 */
#define EFL_UI_SPIN_EVENT_CHANGED (&(_EFL_UI_SPIN_EVENT_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_SPIN_EVENT_MIN_REACHED;

/** Called when spin value reached min
 *
 * @ingroup Efl_Ui_Spin
 */
#define EFL_UI_SPIN_EVENT_MIN_REACHED (&(_EFL_UI_SPIN_EVENT_MIN_REACHED))

EWAPI extern const Efl_Event_Description _EFL_UI_SPIN_EVENT_MAX_REACHED;

/** Called when spin value reached max
 *
 * @ingroup Efl_Ui_Spin
 */
#define EFL_UI_SPIN_EVENT_MAX_REACHED (&(_EFL_UI_SPIN_EVENT_MAX_REACHED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
