/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class AllocTableView
extends MemoryView {
    private MemoryTableModel tableModel;
    private ProfilerTable table;
    private int nTrackedItems;
    private ClientUtils.SourceCodeSelection[] classNames;
    private int[] nTotalAllocObjects;
    private long[] totalAllocObjectsSize;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private boolean filterZeroItems = true;
    private HideableBarRenderer[] renderers;

    public AllocTableView(Set<ClientUtils.SourceCodeSelection> set) {
        this.selection = set;
        this.initUI();
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    private void setData(final int n, final String[] stringArray, final int[] nArray, final long[] lArray, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AllocTableView.this.tableModel != null) {
                    AllocTableView.this.nTrackedItems = n;
                    AllocTableView.access$202(AllocTableView.this, new ClientUtils.SourceCodeSelection[stringArray.length]);
                    for (int i = 0; i < AllocTableView.this.classNames.length; ++i) {
                        ((AllocTableView)AllocTableView.this).classNames[i] = new ClientUtils.SourceCodeSelection(stringArray[i], "*", null);
                    }
                    AllocTableView.access$302(AllocTableView.this, nArray);
                    AllocTableView.access$402(AllocTableView.this, lArray);
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    for (int i = 0; i < AllocTableView.this.nTrackedItems; ++i) {
                        if (bl) {
                            l = Math.max(l, (long)AllocTableView.this.nTotalAllocObjects[i]);
                            l2 = Math.min(l2, (long)AllocTableView.this.nTotalAllocObjects[i]);
                            l3 = Math.max(l3, AllocTableView.this.totalAllocObjectsSize[i]);
                            l4 = Math.min(l4, AllocTableView.this.totalAllocObjectsSize[i]);
                            continue;
                        }
                        l += (long)AllocTableView.this.nTotalAllocObjects[i];
                        l3 += AllocTableView.this.totalAllocObjectsSize[i];
                    }
                    if (bl) {
                        AllocTableView.this.renderers[0].setMaxValue(Math.max(Math.abs(l3), Math.abs(l4)));
                        AllocTableView.this.renderers[1].setMaxValue(Math.max(Math.abs(l), Math.abs(l2)));
                    } else {
                        AllocTableView.this.renderers[0].setMaxValue(l3);
                        AllocTableView.this.renderers[1].setMaxValue(l);
                    }
                    AllocTableView.this.renderers[0].setDiffMode(bl);
                    AllocTableView.this.renderers[1].setDiffMode(bl);
                    AllocTableView.this.tableModel.fireTableDataChanged();
                }
            }
        });
    }

    @Override
    public void setData(MemoryResultsSnapshot memoryResultsSnapshot, GenericFilter genericFilter, int n) {
        AllocMemoryResultsSnapshot allocMemoryResultsSnapshot = (AllocMemoryResultsSnapshot)memoryResultsSnapshot;
        boolean bl = allocMemoryResultsSnapshot instanceof AllocMemoryResultsDiff;
        String[] stringArray = allocMemoryResultsSnapshot.getClassNames();
        int[] nArray = allocMemoryResultsSnapshot.getObjectsCounts();
        long[] lArray = allocMemoryResultsSnapshot.getObjectsSizePerClass();
        int n2 = Math.min(allocMemoryResultsSnapshot.getNProfiledClasses(), stringArray.length);
        n2 = Math.min(n2, nArray.length);
        if (genericFilter == null) {
            this.filterZeroItems = !bl;
            this.setData(n2, stringArray, nArray, lArray, bl);
        } else {
            int n3;
            this.filterZeroItems = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            for (n3 = 0; n3 < n2; ++n3) {
                if (!genericFilter.passes(stringArray[n3].replace('.', '/'))) continue;
                arrayList.add(stringArray[n3]);
                arrayList2.add(nArray[n3]);
                arrayList3.add(lArray[n3]);
            }
            n3 = arrayList.size();
            String[] stringArray2 = arrayList.toArray(new String[0]);
            int[] nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = (Integer)arrayList2.get(i);
            }
            long[] lArray2 = new long[n3];
            for (int i = 0; i < n3; ++i) {
                lArray2[i] = (Long)arrayList3.get(i);
            }
            this.setData(n3, stringArray2, nArray2, lArray2, bl);
        }
    }

    @Override
    public void resetData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllocTableView.this.nTrackedItems = 0;
                AllocTableView.access$202(AllocTableView.this, null);
                AllocTableView.access$302(AllocTableView.this, null);
                AllocTableView.access$402(AllocTableView.this, null);
                AllocTableView.this.renderers[0].setMaxValue(0L);
                AllocTableView.this.renderers[1].setMaxValue(0L);
                AllocTableView.this.renderers[0].setDiffMode(false);
                AllocTableView.this.renderers[1].setDiffMode(false);
                AllocTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_ALLOCATED);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_ALLOCATED);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        final int n = this.selection == null ? -1 : 0;
        this.tableModel = new MemoryTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return AllocTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                AllocTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                AllocTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                AllocTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[2] = ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        this.table.setMainColumn(1 + n);
        this.table.setFitWidthColumn(1 + n);
        this.table.setSortColumn(2 + n);
        this.table.setDefaultSortOrder(1 + n, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.table.addRowFilter(new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                return !AllocTableView.this.filterZeroItems || ((Number)entry.getValue(3 + n)).intValue() > 0;
            }
        });
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer());
        }
        this.table.setColumnRenderer(1 + n, new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(2 + n, this.renderers[0]);
        this.table.setColumnRenderer(3 + n, this.renderers[1]);
        if (this.selection != null) {
            int n2 = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, n2 + 15);
        }
        this.table.setDefaultColumnWidth(2 + n, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(3 + n, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        if (this.nTrackedItems == 0 || n == -1) {
            return null;
        }
        if (n >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.classNames[this.table.convertRowIndexToModel(n)];
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$202(AllocTableView allocTableView, ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        allocTableView.classNames = sourceCodeSelectionArray;
        return sourceCodeSelectionArray;
    }

    static /* synthetic */ int[] access$302(AllocTableView allocTableView, int[] nArray) {
        allocTableView.nTotalAllocObjects = nArray;
        return nArray;
    }

    static /* synthetic */ long[] access$402(AllocTableView allocTableView, long[] lArray) {
        allocTableView.totalAllocObjectsSize = lArray;
        return lArray;
    }

    private class MemoryTableModel
    extends AbstractTableModel {
        private MemoryTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (AllocTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (n == 2) {
                return MemoryView.COLUMN_ALLOCATED_BYTES;
            }
            if (n == 3) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (n == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (AllocTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return String.class;
            }
            if (n == 2) {
                return Long.class;
            }
            if (n == 3) {
                return Integer.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return AllocTableView.this.nTrackedItems;
        }

        @Override
        public int getColumnCount() {
            return AllocTableView.this.selection == null ? 3 : 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (AllocTableView.this.nTrackedItems == 0) {
                return null;
            }
            if (AllocTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 1) {
                return AllocTableView.this.classNames[n].getClassName();
            }
            if (n2 == 2) {
                return AllocTableView.this.totalAllocObjectsSize[n];
            }
            if (n2 == 3) {
                return AllocTableView.this.nTotalAllocObjects[n];
            }
            if (n2 == 0) {
                if (AllocTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return AllocTableView.this.selection.contains(AllocTableView.this.classNames[n]);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (AllocTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 0) {
                if (Boolean.FALSE.equals(object)) {
                    AllocTableView.this.selection.remove(AllocTableView.this.classNames[n]);
                } else {
                    AllocTableView.this.selection.add(AllocTableView.this.classNames[n]);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (AllocTableView.this.selection == null) {
                ++n2;
            }
            return n2 == 0;
        }
    }
}

