/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif



#ifndef _BAUM_H
#define _BAUM_H

#include "list.h"

#define TREE_HEAD(name)						\
struct tree_node name = {&name,					\
			 { NULL, NULL},				\
			 {&name.children, &name.children}	\
}

#define INIT_TREE_HEAD(ptr) do {		\
	(ptr)->parent = (ptr);			\
	INIT_LIST_HEAD(&(ptr)->children);	\
} while(0);

struct tree_node{
	struct tree_node *parent;
  	struct list_head node;
	struct list_head children;
};

#define tree_entry(ptr, type, member) \
	((type *)((char *)(ptr)-(unsigned long)(&((type *)0)->member)))

#define child_entry(ptr, type, member) \
	tree_entry(list_entry(ptr, struct tree_node, node), type, member)

#define first_child(root, member) \
	(root)->member.children.next

#if 0
struct tree_node {
	struct tree_node *parent;
	struct tree_node *prev, *next;
	struct tree_node *head_prev, *head_next;
	struct my_funny_data_struct data;
}
#endif

void delete_tree_node(struct tree_node *old);
void insert_tree_node(struct tree_node *parent, struct tree_node *new);

#endif


#ifdef __cplusplus
}
#endif

