/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"tools.h"
#include"matrix.h"
#include"getput.h"
#include"longtools.h"




main (int argc, char *argv[])
{
  matrix_TYP **M, *Trf, *E;
  int Manz, i;

  extern char **FILENAMES;
  extern int FILEANZ;


  read_header(argc, argv);
  if(FILEANZ != 1)
  {
     printf("Usage: %s 'file' [-t]\n",argv[0]);
     printf("\n");
     printf("file:  matrix_TYP  containing a set of matrices\n");
     printf("\n");
     printf("Calculates the Smith normal form of the matrices\n");
     printf("given in file, resp. the isomorphism type of the factor group of\n");
     printf("two lattices, where the matrix is interpreted as the coordinate\n");
     printf("columns of a generating set of the second lattice in terms of a\n");
     printf("basis of the first one.\n");
     printf("\n");
     printf("CAUTION: If the given matrix is rational, the\n");
     printf("         Smith normal form is calculated for the least\n");
     printf("         integral multiple of it.\n");
     printf("\n");
     printf("Options:\n");
     printf("-t   : gives the left tranformation matrix as well.\n");
     printf("\n");
     if (is_option('h')){
        exit(0);
     }
     else{
        exit(31);
     }
  }

  M = mget_mat(FILENAMES[0], &Manz);
  for(i=0;i<Manz;i++)
  {
    if (!M[i]->flags.Integral) rat2kgv(M[i]);

    if(is_option('t'))
      Trf = init_mat(M[i]->rows, M[i]->rows, "1");
    else
      Trf = NULL;
    E = long_elt_mat(Trf, M[i], NULL);
    put_mat(E, NULL, "ELT of matrix", 0);
    free_mat(E);
    if(is_option('t'))
    {
      put_mat(Trf, NULL, "Transformtion matrix", 0);
      free_mat(Trf);
    }
  }


  exit(0);
}
