/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"tools.h"
#include"matrix.h"
#include"getput.h"
#include"longtools.h"



main (int argc, char *argv[])
{
  matrix_TYP **M;

  int Manz,
         i,
         j,
         k,
         n,   /* the numerator */
         d,   /* the denominator */
         ggt;

  extern char **FILENAMES;

  char comment[1000];

  extern int FILEANZ;


  read_header(argc, argv);
  if((FILEANZ < 1) || (is_option('h'))){
     printf("Scalarmul file -n=numerator -d=denominator\n");
     printf("\n");
     printf("Multiplies all matrices in file with numerator/denominator.\n");
     printf("If either of these is ommitted, it is set to 1.\n");
     printf("\n");
     printf("\n");
     if (is_option('h')){
        exit(0);
     }
     else{
        exit(31);
     }
  }

  M = mget_mat(FILENAMES[0], &Manz);

  n = 1;
  if (is_option('n')){
     n = optionnumber('n');
  }

  d = 1;
  if (is_option('d')){
     d = optionnumber('d');
  }

  ggt = GGT(n,d);

  d = d/ggt;
  n = n/ggt;

  printf("#%d\n",Manz);

  for (i=0;i<Manz;i++){
     Check_mat(M[i]);
     rat2kgv(M[i]);
     if (n != 1){
        for (j=0;j<M[i]->rows;j++){
           for (k=0;k<M[i]->rows;k++){
              M[i]->array.SZ[j][k] = M[i]->array.SZ[j][k] * n;
           }
        }
     }
     M[i]->kgv = M[i]->kgv * d;
     Check_mat(M[i]);
     sprintf(comment,"%d-th matrix of %s multiplied by %d/%d",
                      i+1,FILENAMES[0],n,d);
     put_mat(M[i],NULL,comment,2);
     printf("\n");
  }

  exit(0);
}
