/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


#ifndef _HYPERBOLIC_H_
#define _HYPERBOLIC_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__
/*-------------------------------------------------------------*\
| FILE: hyp_isom.c
\*-------------------------------------------------------------*/
extern matrix_TYP *hyperbolic_isometry(matrix_TYP *x1, matrix_TYP *x2,
     matrix_TYP *S);

/*-------------------------------------------------------------*\
| FILE: hyp_stabilizer.c
\*-------------------------------------------------------------*/
extern bravais_TYP *hyperbolic_stabilizer(matrix_TYP *x, matrix_TYP *S);
#else
/*-------------------------------------------------------------*\
| FILE: hyp_isom.c
\*-------------------------------------------------------------*/
extern matrix_TYP *hyperbolic_isometry();

/*-------------------------------------------------------------*\
| FILE: hyp_stabilizer.c
\*-------------------------------------------------------------*/
extern bravais_TYP *hyperbolic_stabilizer();

#endif
#endif


#ifdef __cplusplus
}
#endif

