/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javajs.util.Lst;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jspecview.api.JSVPanel;
import jspecview.application.AboutDialog;
import jspecview.application.MainFrame;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.source.JDXSource;

public class ApplicationMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    protected MainFrame mainFrame;
    protected JSViewer viewer;
    private JMenu processingMenu;
    private JMenu displayMenu;
    private JMenu exportAsMenu;
    private JMenu openRecentMenu;
    private JMenu saveAsMenu;
    private JMenu saveAsJDXMenu;
    private JMenuItem closeMenuItem;
    private JMenuItem closeAllMenuItem;
    private JMenuItem errorLogMenuItem;
    private JMenuItem printMenuItem;
    private JMenuItem sourceMenuItem;
    private JMenuItem integrationMenuItem;
    private JMenuItem overlayKeyMenuItem;
    private JMenuItem transmittanceMenuItem;
    private JMenuItem solutionColorMenuItem;
    private JCheckBoxMenuItem gridCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem coordsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem revPlotCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem scaleXCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem scaleYCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem toolbarCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem sidePanelCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem statusCheckBoxMenuItem = new JCheckBoxMenuItem();

    public ApplicationMenu(MainFrame si) throws Exception {
        this.mainFrame = si;
        this.viewer = si.vwr;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        JMenuItem openFileMenuItem = ApplicationMenu.setMenuItem(null, 'F', "Add File...", 70, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.openFileFromDialog(true, false, null, null);
            }
        });
        JMenuItem openSimulationH1MenuItem = ApplicationMenu.setMenuItem(null, 'H', "Add H1 Simulation...", 72, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.openFileFromDialog(true, false, "H1", null);
            }
        });
        JMenuItem openSimulationC13MenuItem = ApplicationMenu.setMenuItem(null, 'C', "Add C13 Simulation...", 67, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.openFileFromDialog(true, false, "C13", null);
            }
        });
        JMenuItem openURLMenuItem = ApplicationMenu.setMenuItem(null, 'U', "Add URL...", 85, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.openFileFromDialog(true, true, null, null);
            }
        });
        this.printMenuItem = ApplicationMenu.setMenuItem(null, 'P', "Print...", 80, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("print");
            }
        });
        this.closeMenuItem = ApplicationMenu.setMenuItem(null, 'C', "Close", 115, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("CLOSE");
            }
        });
        this.closeAllMenuItem = ApplicationMenu.setMenuItem(null, 'L', "Close All", 0, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("CLOSE ALL");
            }
        });
        JMenuItem scriptMenuItem = ApplicationMenu.setMenuItem(null, 'T', "Script...", 83, 8, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("script INLINE");
            }
        });
        JMenuItem exitMenuItem = ApplicationMenu.setMenuItem(null, 'X', "Exit", 115, 8, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.mainFrame.exitJSpecView(false);
            }
        });
        ApplicationMenu.setMenuItem(this.gridCheckBoxMenuItem, 'G', "Grid", 71, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.setBoolean(ScriptToken.GRIDON, e);
            }
        });
        ApplicationMenu.setMenuItem(this.coordsCheckBoxMenuItem, 'C', "Coordinates", 67, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.setBoolean(ScriptToken.COORDINATESON, e);
            }
        });
        ApplicationMenu.setMenuItem(this.revPlotCheckBoxMenuItem, 'R', "Reverse Plot", 82, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.setBoolean(ScriptToken.REVERSEPLOT, e);
            }
        });
        ApplicationMenu.setMenuItem(this.scaleXCheckBoxMenuItem, 'X', "X Scale", 88, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.setBoolean(ScriptToken.XSCALEON, e);
            }
        });
        ApplicationMenu.setMenuItem(this.scaleYCheckBoxMenuItem, 'Y', "Y Scale", 89, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.setBoolean(ScriptToken.YSCALEON, e);
            }
        });
        JMenuItem nextZoomMenuItem = ApplicationMenu.setMenuItem(null, 'N', "Next View", 78, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("zoom next");
            }
        });
        JMenuItem prevZoomMenuItem = ApplicationMenu.setMenuItem(null, 'P', "Previous View", 80, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("zoom previous");
            }
        });
        JMenuItem fullZoomMenuItem = ApplicationMenu.setMenuItem(null, 'F', "Full View", 70, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("zoom out");
            }
        });
        JMenuItem clearZoomMenuItem = ApplicationMenu.setMenuItem(null, 'C', "Clear Views", 67, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("zoom clear");
            }
        });
        JMenuItem userZoomMenuItem = ApplicationMenu.setMenuItem(null, 'Z', "Set Zoom...", 90, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("zoom ?");
            }
        });
        JMenuItem viewAllMenuItem = ApplicationMenu.setMenuItem(null, 'A', "All Spectra", 65, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("view all");
            }
        });
        JMenuItem spectraMenuItem = ApplicationMenu.setMenuItem(null, 'S', "Selected Spectra...", 83, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("view");
            }
        });
        JMenuItem overlayStackOffsetYMenuItem = ApplicationMenu.setMenuItem(null, 'y', "Overlay Offset...", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("stackOffsetY ?");
            }
        });
        this.sourceMenuItem = ApplicationMenu.setMenuItem(null, 'S', "Source ...", 83, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showSource");
            }
        });
        this.errorLogMenuItem = ApplicationMenu.setMenuItem(null, '\u0000', "Error Log ...", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showErrors");
            }
        });
        JMenuItem propertiesMenuItem = ApplicationMenu.setMenuItem(null, 'P', "Properties", 72, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showProperties");
            }
        });
        this.overlayKeyMenuItem = ApplicationMenu.setMenuItem(null, '\u0000', "Overlay Key", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showKey toggle");
            }
        });
        JMenuItem preferencesMenuItem = ApplicationMenu.setMenuItem(null, 'P', "Preferences...", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.showPreferencesDialog();
            }
        });
        JMenuItem aboutMenuItem = ApplicationMenu.setMenuItem(null, '\u0000', "About", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog(ApplicationMenu.this.mainFrame);
            }
        });
        ApplicationMenu.setMenuItem(this.toolbarCheckBoxMenuItem, 'T', "Toolbar", 84, 9, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.mainFrame.enableToolbar(e.getStateChange() == 1);
            }
        });
        ApplicationMenu.setMenuItem(this.sidePanelCheckBoxMenuItem, 'S', "Side Panel", 83, 9, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.mainFrame.setSplitPane(e.getStateChange() == 1);
            }
        });
        ApplicationMenu.setMenuItem(this.statusCheckBoxMenuItem, 'B', "Status Bar", 66, 9, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ApplicationMenu.this.mainFrame.enableStatus(e.getStateChange() == 1);
            }
        });
        JMenu fileMenu = new JMenu();
        fileMenu.setMnemonic('F');
        fileMenu.setText("File");
        JMenu helpMenu = new JMenu();
        helpMenu.setMnemonic('H');
        helpMenu.setText("Help");
        JMenu optionsMenu = new JMenu();
        optionsMenu.setMnemonic('O');
        optionsMenu.setText("Options");
        this.displayMenu = new JMenu();
        this.displayMenu.setMnemonic('D');
        this.displayMenu.setText("Display");
        this.displayMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ApplicationMenu.this.doMenuSelected();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu zoomMenu = new JMenu();
        zoomMenu.setMnemonic('Z');
        zoomMenu.setText("Zoom");
        this.openRecentMenu = new JMenu();
        this.openRecentMenu.setActionCommand("OpenRecent");
        this.openRecentMenu.setMnemonic('R');
        this.openRecentMenu.setText("Add Recent");
        this.saveAsMenu = new JMenu();
        this.saveAsMenu.setMnemonic('A');
        this.saveAsJDXMenu = new JMenu();
        this.saveAsJDXMenu.setMnemonic('J');
        this.exportAsMenu = new JMenu();
        this.exportAsMenu.setMnemonic('E');
        this.processingMenu = new JMenu();
        this.processingMenu.setMnemonic('P');
        this.processingMenu.setText("Processing");
        this.processingMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.setProcessingMenu(this.processingMenu);
        fileMenu.add(openFileMenuItem);
        fileMenu.add(openSimulationH1MenuItem);
        fileMenu.add(openSimulationC13MenuItem);
        fileMenu.add(openURLMenuItem);
        fileMenu.add(this.openRecentMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.closeMenuItem).setEnabled(false);
        fileMenu.add(this.closeAllMenuItem).setEnabled(false);
        fileMenu.addSeparator();
        fileMenu.add(scriptMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(this.saveAsMenu).setEnabled(false);
        fileMenu.add(this.exportAsMenu).setEnabled(false);
        fileMenu.addSeparator();
        fileMenu.add(this.printMenuItem).setEnabled(false);
        fileMenu.addSeparator();
        fileMenu.add(exitMenuItem);
        this.displayMenu.add(viewAllMenuItem);
        this.displayMenu.add(spectraMenuItem);
        this.displayMenu.add(overlayStackOffsetYMenuItem);
        this.displayMenu.add(this.overlayKeyMenuItem).setEnabled(false);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.gridCheckBoxMenuItem);
        this.displayMenu.add(this.coordsCheckBoxMenuItem);
        this.displayMenu.add(this.scaleXCheckBoxMenuItem);
        this.displayMenu.add(this.scaleYCheckBoxMenuItem);
        this.displayMenu.add(this.revPlotCheckBoxMenuItem);
        this.displayMenu.addSeparator();
        this.displayMenu.add(zoomMenu);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.sourceMenuItem).setEnabled(false);
        this.displayMenu.add(this.errorLogMenuItem).setEnabled(false);
        this.displayMenu.add(propertiesMenuItem);
        zoomMenu.add(nextZoomMenuItem);
        zoomMenu.add(prevZoomMenuItem);
        zoomMenu.add(fullZoomMenuItem);
        zoomMenu.add(clearZoomMenuItem);
        zoomMenu.add(userZoomMenuItem);
        optionsMenu.add(preferencesMenuItem);
        optionsMenu.addSeparator();
        optionsMenu.add(this.toolbarCheckBoxMenuItem);
        optionsMenu.add(this.sidePanelCheckBoxMenuItem);
        optionsMenu.add(this.statusCheckBoxMenuItem);
        helpMenu.add(aboutMenuItem);
        this.add(fileMenu);
        this.add(this.displayMenu).setEnabled(false);
        this.add(optionsMenu);
        this.add(this.processingMenu).setEnabled(false);
        this.add(helpMenu);
        ApplicationMenu.setMenus(this.saveAsMenu, this.saveAsJDXMenu, this.exportAsMenu, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.mainFrame.exportSpectrumViaMenu(e.getActionCommand());
            }
        });
        this.toolbarCheckBoxMenuItem.setSelected(true);
        this.sidePanelCheckBoxMenuItem.setSelected(true);
        this.statusCheckBoxMenuItem.setSelected(true);
    }

    protected void doMenuSelected() {
        PanelData pd = this.mainFrame.vwr.pd();
        this.gridCheckBoxMenuItem.setSelected(pd != null && pd.getBoolean(ScriptToken.GRIDON));
        this.coordsCheckBoxMenuItem.setSelected(pd != null && pd.getBoolean(ScriptToken.COORDINATESON));
        this.revPlotCheckBoxMenuItem.setSelected(pd != null && pd.getBoolean(ScriptToken.REVERSEPLOT));
    }

    public void setProcessingMenu(JComponent menu) {
        this.integrationMenuItem = ApplicationMenu.setMenuItem(null, 'I', "Integration", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showIntegration");
            }
        });
        menu.add(this.integrationMenuItem);
        menu.add(ApplicationMenu.setMenuItem(null, 'M', "Measurements", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showMeasurements");
            }
        }));
        menu.add(ApplicationMenu.setMenuItem(null, 'P', "Peaks", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("showPeakList");
            }
        }));
        this.transmittanceMenuItem = ApplicationMenu.setMenuItem(null, '\u0000', "Transmittance/Absorbance", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("IRMODE IMPLIED");
            }
        });
        menu.add(this.transmittanceMenuItem);
        this.solutionColorMenuItem = ApplicationMenu.setMenuItem(null, 'C', "Predicted Solution Colour", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationMenu.this.viewer.runScript("GETSOLUTIONCOLOR");
            }
        });
        menu.add(this.solutionColorMenuItem);
    }

    protected void setBoolean(ScriptToken st, ItemEvent e) {
        boolean isOn = e.getStateChange() == 1;
        this.viewer.runScript((Object)((Object)st) + " " + isOn);
    }

    public void setSourceEnabled(boolean b) {
        this.closeAllMenuItem.setEnabled(b);
        this.displayMenu.setEnabled(b);
        this.processingMenu.setEnabled(b);
        this.exportAsMenu.setEnabled(b);
        this.saveAsMenu.setEnabled(b);
        this.printMenuItem.setEnabled(b);
        this.sourceMenuItem.setEnabled(b);
        this.errorLogMenuItem.setEnabled(b);
    }

    void setCloseMenuItem(String fileName) {
        this.closeMenuItem.setEnabled(fileName != null);
        this.closeMenuItem.setText(fileName == null ? "Close" : "Close " + fileName);
    }

    void setError(boolean isError, boolean isWarningOnly) {
        this.errorLogMenuItem.setEnabled(isError);
    }

    public void setMenuEnables(PanelNode node) {
        if (node == null) {
            this.setCloseMenuItem(null);
            this.setSourceEnabled(false);
        } else {
            this.setSourceEnabled(true);
            PanelData pd = node.pd();
            Spectrum spec = pd.getSpectrum();
            this.setCheckBoxes(pd);
            this.overlayKeyMenuItem.setEnabled(pd.getNumberOfGraphSets() > 1);
            this.setCloseMenuItem(JSVFileManager.getTagName(node.source.getFilePath()));
            this.exportAsMenu.setEnabled(true);
            this.saveAsMenu.setEnabled(true);
            this.saveAsJDXMenu.setEnabled(spec.canSaveAsJDX());
            this.integrationMenuItem.setEnabled(spec.canIntegrate());
            this.transmittanceMenuItem.setEnabled(spec.isAbsorbance() || spec.isTransmittance());
            this.solutionColorMenuItem.setEnabled(spec.canShowSolutionColor());
        }
    }

    public boolean toggleOverlayKeyMenuItem() {
        this.overlayKeyMenuItem.setSelected(this.overlayKeyMenuItem.isSelected());
        return this.overlayKeyMenuItem.isSelected();
    }

    void showPreferencesDialog() {
        this.mainFrame.showPreferences();
    }

    public void setSelections(boolean sidePanelOn, boolean toolbarOn, boolean statusbarOn, JSVPanel jsvp) {
        this.sidePanelCheckBoxMenuItem.setSelected(sidePanelOn);
        this.toolbarCheckBoxMenuItem.setSelected(toolbarOn);
        this.statusCheckBoxMenuItem.setSelected(statusbarOn);
        if (jsvp != null) {
            this.setCheckBoxes(jsvp.getPanelData());
        }
    }

    private void setCheckBoxes(PanelData pd) {
        this.gridCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.GRIDON));
        this.coordsCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.COORDINATESON));
        this.revPlotCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.REVERSEPLOT));
        this.scaleXCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.XSCALEON));
        this.scaleYCheckBoxMenuItem.setSelected(pd.getBoolean(ScriptToken.YSCALEON));
    }

    public void setRecentMenu(Lst<String> recentFilePaths) {
        this.openRecentMenu.removeAll();
        for (int i = 0; i < recentFilePaths.size(); ++i) {
            String path = (String)recentFilePaths.get(i);
            JMenuItem menuItem = new JMenuItem(path);
            this.openRecentMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationMenu.this.viewer.openFile(((JMenuItem)e.getSource()).getText(), false);
                }
            });
        }
    }

    public void updateRecentMenus(Lst<String> recentFilePaths) {
        this.openRecentMenu.removeAll();
        for (int i = 0; i < recentFilePaths.size(); ++i) {
            String path = (String)recentFilePaths.get(i);
            JMenuItem menuItem = new JMenuItem(path);
            this.openRecentMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationMenu.this.viewer.openFile(((JMenuItem)e.getSource()).getText(), true);
                }
            });
        }
    }

    public void clearSourceMenu(JDXSource source) {
        if (source == null) {
            this.setMenuEnables(null);
        } else {
            this.saveAsJDXMenu.setEnabled(true);
            this.saveAsMenu.setEnabled(true);
        }
    }

    public static void addMenuItem(JMenu m, String key, char keyChar, ActionListener actionListener) {
        JMenuItem jmi = new JMenuItem();
        jmi.setMnemonic(keyChar == '\u0000' ? key.charAt(0) : keyChar);
        jmi.setText(key);
        jmi.addActionListener(actionListener);
        m.add(jmi);
    }

    public static void setMenus(JMenu saveAsMenu, JMenu saveAsJDXMenu, JMenu exportAsMenu, ActionListener actionListener) {
        saveAsMenu.setText("Save As");
        ApplicationMenu.addMenuItem(saveAsMenu, "Original...", '\u0000', actionListener);
        saveAsJDXMenu.setText("JDX");
        ApplicationMenu.addMenuItem(saveAsJDXMenu, "XY", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(saveAsJDXMenu, "DIF", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(saveAsJDXMenu, "DIFDUP", 'U', actionListener);
        ApplicationMenu.addMenuItem(saveAsJDXMenu, "FIX", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(saveAsJDXMenu, "PAC", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(saveAsJDXMenu, "SQZ", '\u0000', actionListener);
        saveAsMenu.add(saveAsJDXMenu);
        ApplicationMenu.addMenuItem(saveAsMenu, "CML", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(saveAsMenu, "XML (AnIML)", '\u0000', actionListener);
        if (exportAsMenu != null) {
            exportAsMenu.setText("Export As");
            ApplicationMenu.addMenuItem(exportAsMenu, "JPG", '\u0000', actionListener);
            ApplicationMenu.addMenuItem(exportAsMenu, "PNG", 'N', actionListener);
            ApplicationMenu.addMenuItem(exportAsMenu, "SVG", '\u0000', actionListener);
            ApplicationMenu.addMenuItem(exportAsMenu, "PDF", '\u0000', actionListener);
        }
    }

    public static JMenuItem setMenuItem(JMenuItem item, char c, String text, int accel, int mask, EventListener el) {
        if (item == null) {
            item = new JMenuItem();
        }
        if (c != '\u0000') {
            item.setMnemonic(c);
        }
        item.setText(text);
        if (accel > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel, mask, false));
        }
        if (el instanceof ActionListener) {
            item.addActionListener((ActionListener)el);
        } else if (el instanceof ItemListener) {
            item.addItemListener((ItemListener)el);
        }
        return item;
    }
}

