/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.app.map;

import java.io.File;
import net.sf.bt747.j2se.app.map.MyTileFactoryInfo;
import net.sf.bt747.j2se.app.map.WMSTileFactoryInfo;
import net.sf.bt747.j2se.app.map.WmsEPSG4326TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.wms.WMSService;

public final class MapFactoryInfos {
    private static final WMSService wms = new WMSService();
    public static final MyTileFactoryInfo tfiOpenStreetMap = new MyTileFactoryInfo("osm", "http://tile.openstreetmap.org", "x", "y", "z", "OpenStreetMap (Mapnik)", "http://www.openstreetmap.org"){

        public final String getTileUrl(int n, int n2, int n3) {
            n3 = this.getTotalMapZoom() - n3;
            return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
        }

        public final String getTileBaseKey(int n, int n2, int n3) {
            n3 = this.getTotalMapZoom() - n3;
            return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
        }
    };
    public static final MyTileFactoryInfo tfiOSM_OSM_CYCLE_CLOUDMADE;
    public static final MyTileFactoryInfo tfiOSM_OSM_CYCLE_THUNDER;
    public static final MyTileFactoryInfo tfiOSM_OSMARENDER;
    public static final MyTileFactoryInfo tfiOpnvStreetMap;
    public static final MyTileFactoryInfo tfiOpenPisteMapContours;
    public static final MyTileFactoryInfo tfiOpenPisteMapNoContours;
    public static final MyTileFactoryInfo tfiDigitalGlobe;

    static {
        new MyTileFactoryInfo("local tiles", "file:///m/pic/slippymap/slippytiles", "x", "y", "z", "Local TMS tiles", "http://www.gdal.org/gdal2tiles.html"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                n2 = (1 << n3) - n2 - 1;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        tfiOSM_OSM_CYCLE_CLOUDMADE = new MyTileFactoryInfo("osmcycle_cloudmade", "http://andy.sandbox.cloudmade.com/tiles/cycle", "x", "y", "z", "OpenCycleMap.org - Creative Commons-by-SA License", "http://www.opencyclemap.org"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        tfiOSM_OSM_CYCLE_THUNDER = new MyTileFactoryInfo("osmcycle_thunder", "http://www.thunderflames.org/tiles/cycle", "x", "y", "z", "OpenCycleMap.org - Creative Commons-by-SA License", "http://www.opencyclemap.org"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        tfiOSM_OSMARENDER = new MyTileFactoryInfo("osmarender", "http://tah.openstreetmap.org/Tiles/tile", "x", "y", "z", "Open Street Map (Osmarender)", "http://www.openstreetmap.org/?layers=0B00FTF"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        tfiOpnvStreetMap = new MyTileFactoryInfo("opnv", "http://tile.xn--pnvkarte-m4a.de/tilegen", "x", "y", "z", "\u00f6pnv karte - public transport", "http://tile.\\u00D6pnvkarte.de"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        tfiOpenPisteMapContours = new MyTileFactoryInfo("rste", "http://tiles.openpistemap.org/contours", "x", "y", "z", "Open Piste Map", "http://openpistemap.org"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        tfiOpenPisteMapNoContours = new MyTileFactoryInfo("openpistenc", "http://tiles.openpistemap.org/nocontours", "x", "y", "z", "Open Piste Map", "http://openpistemap.org"){

            public final String getTileUrl(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return this.baseURL + "/" + n3 + "/" + n + "/" + n2 + ".png";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        new MyTileFactoryInfo("gmaps", "http://mt.google.com/mt?n=404&v=w2.999", "x", "y", "zoom", "Google Maps", "http://www.google.com/maps"){};
        new MyTileFactoryInfo("WMS", "http://wms.jpl.nasa.gov/wms.cgi?", "x", "y", "z", "NASA", "http://wms.jpl.nasa.gov"){

            public final String getTileUrl(int n, int n2, int n3) {
                int n4 = this.getTotalMapZoom() - n3;
                int n5 = (int)Math.pow(2.0, (double)n4 - 1.0);
                return wms.toWMSURL(n - n5, n5 - 1 - n2, n4, this.getTileSize(n3));
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2;
            }
        };
        new WMSTileFactoryInfo("WMS", "http://wms.jpl.nasa.gov/wms.cgi?", "x", "y", "z", "NASA", "http://wms.jpl.nasa.gov"){};
        new WmsEPSG4326TileFactoryInfo("oa256", "http://openaerialmap.org/wms/?", "x", "y", "z", "OpenAerialMap", "http://openaerialmap.org"){

            public final String getLayer() {
                return "world";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
        tfiDigitalGlobe = new WmsEPSG4326TileFactoryInfo("dig256", "http://wms.globexplorer.com/gexservlets/wms?", "x", "y", "z", "Digital Globe", "http://www.digitalglobe.com"){

            public final String getLayer() {
                return "GlobeXplorer%20Image";
            }

            public final String getTileBaseKey(int n, int n2, int n3) {
                n3 = this.getTotalMapZoom() - n3;
                return "" + n3 + File.separatorChar + n + File.separatorChar + n2 + ".png";
            }

            public final String getFormat() {
                return "image/png&BGCOLOR=0xFFFFFF&TRANSPARENT=TRUE";
            }
        };
        new WmsEPSG4326TileFactoryInfo("Topo", "http://terraservice.net/ogcmap6.ashx?version=1.1.1&styles=&bgcolor=0xCCCCCC&exceptions=INIMAGE", "", "", "", "Topo maps by USGS via terraserver-usa.com", "http://terraservice.net"){

            public final String getLayer() {
                return "DRG";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
        new WmsEPSG4326TileFactoryInfo("Aerial", "http://terraservice.net/ogcmap6.ashx?version=1.1.1&styles=&bgcolor=0xCCCCCC&exceptions=INIMAGE", "", "", "", "Imagery by USGS via terraserver-usa.com", "http://terraservice.net"){

            public final String getLayer() {
                return "DOQ";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
        new WmsEPSG4326TileFactoryInfo("NRCan", "http://wms.cits.rncan.gc.ca/cgi-bin/cubeserv.cgi?version=1.1.3&bgcolor=0xFFFFFF&exceptions=application/vnd.ogc.se_inimage", "", "", "", "Maps by NRCan.gc.ca", "http://wms.cits.rncan.gc.ca"){

            public final String getLayer() {
                return "PUB_50K:CARTES_MATRICIELLES/RASTER_MAPS";
            }

            public final String getFormat() {
                return "image/png";
            }
        };
        new WmsEPSG4326TileFactoryInfo("NEXRAD", "http://mesonet.agron.iastate.edu/cgi-bin/wms/nexrad/n0r.cgi?version=1.1.1&service=WMS&transparent=true", "", "", "", "NEXRAD imagery from Iowa Environmental Mesonet", "http://mesonet.agron.iastate.edu"){

            public final String getLayer() {
                return "nexrad-n0r";
            }

            public final String getFormat() {
                return "image/png";
            }
        };
        new WmsEPSG4326TileFactoryInfo("Landsat", "http://onearth.jpl.nasa.gov/wms.cgi?", "", "", "", "Map by NASA", "http://onearth.jpl.nasa.gov"){

            public final String getLayer() {
                return "global_mosaic";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
        new WmsEPSG4326TileFactoryInfo("BlueMarble", "http://onearth.jpl.nasa.gov/wms.cgi?", "", "", "", "Map by NASA", "http://onearth.jpl.nasa.gov"){

            public final String getLayer() {
                return "modis";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
        new WmsEPSG4326TileFactoryInfo("MODIS", "http://onearth.jpl.nasa.gov/wms.cgi?", "", "", "", "Map by NASA", "http://onearth.jpl.nasa.gov"){

            public final String getLayer() {
                return "daily_planet";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
        new WmsEPSG4326TileFactoryInfo("SRTM", "http://onearth.jpl.nasa.gov/wms.cgi?", "", "", "", "SRTM elevation data by NASA", "http://onearth.jpl.nasa.gov"){

            public final String getLayer() {
                return "huemapped_srtm";
            }

            public final String getFormat() {
                return "image/jpeg";
            }
        };
    }
}

