/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import javax.swing.UIManager;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.linux.LinuxLookAndFeelAddons;
import org.jdesktop.swingx.plaf.macosx.MacOSXLookAndFeelAddons;
import org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons;
import org.jdesktop.swingx.plaf.motif.MotifLookAndFeelAddons;
import org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;

public abstract class AbstractComponentAddon
implements ComponentAddon {
    private String name;

    protected AbstractComponentAddon(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void initialize(LookAndFeelAddons addon) {
        addon.loadDefaults(this.getDefaults(addon));
    }

    public void uninitialize(LookAndFeelAddons addon) {
    }

    protected void addBasicDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
    }

    protected void addMacDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addMetalDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addMotifDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addWindowsDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addLinuxDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    protected void addNimbusDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        this.addBasicDefaults(addon, defaults);
    }

    private Object[] getDefaults(LookAndFeelAddons addon) {
        DefaultsList defaults = new DefaultsList();
        if (this.isWindows(addon)) {
            this.addWindowsDefaults(addon, defaults);
        } else if (this.isMetal(addon)) {
            this.addMetalDefaults(addon, defaults);
        } else if (this.isMac(addon)) {
            this.addMacDefaults(addon, defaults);
        } else if (this.isMotif(addon)) {
            this.addMotifDefaults(addon, defaults);
        } else if (this.isLinux(addon)) {
            this.addLinuxDefaults(addon, defaults);
        } else if (this.isNimbus(addon)) {
            this.addNimbusDefaults(addon, defaults);
        } else {
            this.addBasicDefaults(addon, defaults);
        }
        return defaults.toArray();
    }

    protected boolean isWindows(LookAndFeelAddons addon) {
        return addon instanceof WindowsLookAndFeelAddons;
    }

    protected boolean isMetal(LookAndFeelAddons addon) {
        return addon instanceof MetalLookAndFeelAddons;
    }

    protected boolean isMac(LookAndFeelAddons addon) {
        return addon instanceof MacOSXLookAndFeelAddons;
    }

    protected boolean isMotif(LookAndFeelAddons addon) {
        return addon instanceof MotifLookAndFeelAddons;
    }

    protected boolean isLinux(LookAndFeelAddons addon) {
        return addon instanceof LinuxLookAndFeelAddons;
    }

    protected boolean isNimbus(LookAndFeelAddons addon) {
        return addon instanceof NimbusLookAndFeelAddons;
    }

    protected boolean isPlastic() {
        return UIManager.getLookAndFeel().getClass().getName().contains("Plastic");
    }

    protected boolean isSynth() {
        return UIManager.getLookAndFeel().getClass().getName().contains("ynth");
    }
}

