/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalByteMap;
import org.gephi.graph.api.types.IntervalCharMap;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalFloatMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.IntervalShortMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.impl.FormattingAndParsingUtils;
import org.joda.time.DateTimeZone;

public final class IntervalsParser {
    public static IntervalSet parseIntervalSet(String input, DateTimeZone timeZone) throws IllegalArgumentException {
        List intervals;
        if (input == null) {
            return null;
        }
        if (input.equalsIgnoreCase("<empty>")) {
            return new IntervalSet();
        }
        try {
            intervals = IntervalsParser.parseIntervals(null, input, timeZone);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected expection while parsing intervals", ex);
        }
        IntervalSet result = new IntervalSet(intervals.size());
        for (IntervalWithValue interval : intervals) {
            result.add(interval.getInterval());
        }
        return result;
    }

    public static IntervalSet parseIntervalSet(String input) throws IllegalArgumentException {
        return IntervalsParser.parseIntervalSet(input, null);
    }

    public static <T> IntervalMap<T> parseIntervalMap(Class<T> typeClass, String input, DateTimeZone timeZone) throws IllegalArgumentException {
        IntervalMap result;
        List<IntervalWithValue<T>> intervals;
        if (typeClass == null) {
            throw new IllegalArgumentException("typeClass required");
        }
        if (input == null) {
            return null;
        }
        try {
            intervals = IntervalsParser.parseIntervals(typeClass, input, timeZone);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected expection while parsing intervals", ex);
        }
        int capacity = intervals.size();
        typeClass = AttributeUtils.getStandardizedType(typeClass);
        if (typeClass.equals(String.class)) {
            result = new IntervalStringMap(capacity);
        } else if (typeClass.equals(Byte.class)) {
            result = new IntervalByteMap(capacity);
        } else if (typeClass.equals(Short.class)) {
            result = new IntervalShortMap(capacity);
        } else if (typeClass.equals(Integer.class)) {
            result = new IntervalIntegerMap(capacity);
        } else if (typeClass.equals(Long.class)) {
            result = new IntervalLongMap(capacity);
        } else if (typeClass.equals(Float.class)) {
            result = new IntervalFloatMap(capacity);
        } else if (typeClass.equals(Double.class)) {
            result = new IntervalDoubleMap(capacity);
        } else if (typeClass.equals(Boolean.class)) {
            result = new IntervalBooleanMap(capacity);
        } else if (typeClass.equals(Character.class)) {
            result = new IntervalCharMap(capacity);
        } else {
            throw new IllegalArgumentException("Unsupported type " + typeClass.getClass().getCanonicalName());
        }
        for (IntervalWithValue<T> interval : intervals) {
            T value = interval.getValue();
            if (value == null) {
                throw new IllegalArgumentException("A value must be provided for each interval");
            }
            result.put(interval.getInterval(), interval.getValue());
        }
        return result;
    }

    public static <T> IntervalMap<T> parseIntervalMap(Class<T> typeClass, String input) throws IllegalArgumentException {
        return IntervalsParser.parseIntervalMap(typeClass, input, null);
    }

    private static <T> List<IntervalWithValue<T>> parseIntervals(Class<T> typeClass, String input, DateTimeZone timeZone) throws IOException, IllegalArgumentException {
        int r;
        if (input == null) {
            return null;
        }
        input = input.trim();
        ArrayList<IntervalWithValue<T>> intervals = new ArrayList<IntervalWithValue<T>>();
        if (input.equalsIgnoreCase("<empty>")) {
            return intervals;
        }
        StringReader reader = new StringReader(input + ' ');
        block3: while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case '(': 
                case '[': {
                    intervals.add(IntervalsParser.parseInterval(typeClass, reader, timeZone));
                    continue block3;
                }
            }
        }
        if (intervals.isEmpty()) {
            throw new IllegalArgumentException("No dynamic intervals could be parsed");
        }
        return intervals;
    }

    private static <T> IntervalWithValue<T> parseInterval(Class<T> typeClass, StringReader reader, DateTimeZone timeZone) throws IOException {
        int r;
        ArrayList<String> values = new ArrayList<String>();
        block5: while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case ')': 
                case ']': {
                    return IntervalsParser.buildInterval(typeClass, values, timeZone);
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    values.add(FormattingAndParsingUtils.parseLiteral(reader, c));
                    continue block5;
                }
            }
            reader.skip(-1L);
            values.add(FormattingAndParsingUtils.parseValue(reader));
        }
        return IntervalsParser.buildInterval(typeClass, values, timeZone);
    }

    private static <T> IntervalWithValue<T> buildInterval(Class<T> typeClass, ArrayList<String> values, DateTimeZone timeZone) {
        if (typeClass == null && values.size() != 2) {
            throw new IllegalArgumentException("Each interval must have 2 values");
        }
        if (typeClass != null && values.size() != 3) {
            throw new IllegalArgumentException("Each interval must have 3 values");
        }
        double low = FormattingAndParsingUtils.parseDateTimeOrTimestamp(values.get(0), timeZone);
        double high = FormattingAndParsingUtils.parseDateTimeOrTimestamp(values.get(1), timeZone);
        if (typeClass == null) {
            return new IntervalWithValue<Object>(low, high, null);
        }
        String valString = values.get(2);
        T value = FormattingAndParsingUtils.convertValue(typeClass, valString);
        return new IntervalWithValue<T>(low, high, value);
    }

    private static class IntervalWithValue<T> {
        private final Interval interval;
        private final T value;

        public IntervalWithValue(double low, double high, T value) {
            this.interval = new Interval(low, high);
            this.value = value;
        }

        public IntervalWithValue(Interval interval, T value) {
            this.interval = interval;
            this.value = value;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public T getValue() {
            return this.value;
        }
    }
}

