/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import cern.colt.bitvector.BitVector;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.doubles.Double2IntRBTreeMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalByteMap;
import org.gephi.graph.api.types.IntervalCharMap;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalFloatMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.IntervalShortMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.api.types.TimestampBooleanMap;
import org.gephi.graph.api.types.TimestampByteMap;
import org.gephi.graph.api.types.TimestampCharMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampFloatMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.graph.api.types.TimestampLongMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.api.types.TimestampShortMap;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeTypeStore;
import org.gephi.graph.impl.GraphAttributesImpl;
import org.gephi.graph.impl.GraphFactoryImpl;
import org.gephi.graph.impl.GraphModelImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.GraphViewStore;
import org.gephi.graph.impl.Interval2IntTreeMap;
import org.gephi.graph.impl.IntervalIndexStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.TableImpl;
import org.gephi.graph.impl.TextPropertiesImpl;
import org.gephi.graph.impl.TimeStore;
import org.gephi.graph.impl.TimestampIndexStore;
import org.gephi.graph.impl.utils.DataInputOutput;
import org.gephi.graph.impl.utils.LongPacker;
import org.joda.time.DateTimeZone;

public class Serialization {
    static final float VERSION = 0.5f;
    static final int NULL_ID = -1;
    static final int NULL = 0;
    static final int NORMAL = 1;
    static final int BOOLEAN_TRUE = 2;
    static final int BOOLEAN_FALSE = 3;
    static final int INTEGER_MINUS_1 = 4;
    static final int INTEGER_0 = 5;
    static final int INTEGER_1 = 6;
    static final int INTEGER_2 = 7;
    static final int INTEGER_3 = 8;
    static final int INTEGER_4 = 9;
    static final int INTEGER_5 = 10;
    static final int INTEGER_6 = 11;
    static final int INTEGER_7 = 12;
    static final int INTEGER_8 = 13;
    static final int INTEGER_255 = 14;
    static final int INTEGER_PACK_NEG = 15;
    static final int INTEGER_PACK = 16;
    static final int LONG_MINUS_1 = 17;
    static final int LONG_0 = 18;
    static final int LONG_1 = 19;
    static final int LONG_2 = 20;
    static final int LONG_3 = 21;
    static final int LONG_4 = 22;
    static final int LONG_5 = 23;
    static final int LONG_6 = 24;
    static final int LONG_7 = 25;
    static final int LONG_8 = 26;
    static final int LONG_PACK_NEG = 27;
    static final int LONG_PACK = 28;
    static final int LONG_255 = 29;
    static final int LONG_MINUS_MAX = 30;
    static final int SHORT_MINUS_1 = 31;
    static final int SHORT_0 = 32;
    static final int SHORT_1 = 33;
    static final int SHORT_255 = 34;
    static final int SHORT_FULL = 35;
    static final int BYTE_MINUS_1 = 36;
    static final int BYTE_0 = 37;
    static final int BYTE_1 = 38;
    static final int BYTE_FULL = 39;
    static final int CHAR = 40;
    static final int FLOAT_MINUS_1 = 41;
    static final int FLOAT_0 = 42;
    static final int FLOAT_1 = 43;
    static final int FLOAT_255 = 44;
    static final int FLOAT_SHORT = 45;
    static final int FLOAT_FULL = 46;
    static final int DOUBLE_MINUS_1 = 47;
    static final int DOUBLE_0 = 48;
    static final int DOUBLE_1 = 49;
    static final int DOUBLE_255 = 50;
    static final int DOUBLE_SHORT = 51;
    static final int DOUBLE_FULL = 52;
    static final int DOUBLE_ARRAY = 53;
    static final int BIGDECIMAL = 54;
    static final int BIGINTEGER = 55;
    static final int FLOAT_ARRAY = 56;
    static final int INTEGER_MINUS_MAX = 57;
    static final int SHORT_ARRAY = 58;
    static final int BOOLEAN_ARRAY = 59;
    static final int ARRAY_INT_B_255 = 60;
    static final int ARRAY_INT_B_INT = 61;
    static final int ARRAY_INT_S = 62;
    static final int ARRAY_INT_I = 63;
    static final int ARRAY_INT_PACKED = 64;
    static final int ARRAY_LONG_B = 65;
    static final int ARRAY_LONG_S = 66;
    static final int ARRAY_LONG_I = 67;
    static final int ARRAY_LONG_L = 68;
    static final int ARRAY_LONG_PACKED = 69;
    static final int CHAR_ARRAY = 70;
    static final int ARRAY_BYTE_INT = 71;
    static final int NOTUSED_ARRAY_OBJECT_255 = 72;
    static final int ARRAY_OBJECT = 73;
    static final int STRING_ARRAY = 74;
    static final int STRING_EMPTY = 101;
    static final int NOTUSED_STRING_255 = 102;
    static final int STRING = 103;
    static final int LOCALE = 124;
    static final int PROPERTIES = 125;
    static final int CLASS = 126;
    static final int DATE = 127;
    static final String EMPTY_STRING = "";
    static final int NODE = 200;
    static final int EDGE = 201;
    static final int EDGETYPE_STORE = 202;
    static final int COLUMN_ORIGIN = 203;
    static final int TABLE = 204;
    static final int CONFIGURATION = 205;
    static final int GRAPH_STORE = 206;
    static final int GRAPH_FACTORY = 207;
    static final int GRAPH_VIEW_STORE = 208;
    static final int GRAPH_VIEW = 209;
    static final int BIT_VECTOR = 210;
    static final int GRAPH_STORE_CONFIGURATION = 211;
    static final int TIME_REPRESENTATION = 212;
    static final int GRAPH_VERSION = 213;
    static final int NODE_PROPERTIES = 214;
    static final int EDGE_PROPERTIES = 215;
    static final int TEXT_PROPERTIES = 216;
    static final int ESTIMATOR = 217;
    static final int GRAPH_ATTRIBUTES = 218;
    static final int TIMESTAMP_INDEX_STORE = 219;
    static final int INTERVAL_INDEX_STORE = 220;
    static final int TIME_FORMAT = 221;
    static final int TIME_STORE = 222;
    static final int TIMESTAMP_SET = 223;
    static final int INTERVAL_SET = 224;
    static final int TIMESTAMP_MAP = 225;
    static final int INTERVAL_MAP = 226;
    static final int TIME_ZONE = 227;
    static final int INTERVAL = 228;
    static final int LIST = 229;
    static final int SET = 230;
    static final int MAP = 231;
    protected final Int2IntMap idMap;
    protected GraphModelImpl model;
    protected float readVersion = 0.5f;
    protected GraphStoreConfigurationVersion graphStoreConfigurationVersion;

    public Serialization() {
        this(null);
    }

    public Serialization(GraphModelImpl graphModel) {
        this.model = graphModel;
        this.idMap = new Int2IntOpenHashMap();
        this.idMap.defaultReturnValue(-1);
    }

    public void serializeGraphModel(DataOutput out, GraphModelImpl model) throws IOException {
        this.model = model;
        this.serialize(out, Float.valueOf(0.5f));
        this.serialize(out, model.configuration);
        this.serialize(out, model.store);
    }

    public GraphModelImpl deserializeGraphModel(DataInput is) throws IOException, ClassNotFoundException {
        this.readVersion = ((Float)this.deserialize(is)).floatValue();
        Configuration config = (Configuration)this.deserialize(is);
        this.model = new GraphModelImpl(config);
        this.deserialize(is);
        return this.model;
    }

    public GraphModelImpl deserializeGraphModelWithoutVersionPrefix(DataInput is, float version) throws IOException, ClassNotFoundException {
        this.readVersion = version;
        Configuration config = (Configuration)this.deserialize(is);
        this.model = new GraphModelImpl(config);
        this.deserialize(is);
        return this.model;
    }

    public void serializeGraphStore(DataOutput out, GraphStore store) throws IOException {
        this.serializeGraphStoreConfiguration(out);
        this.serialize(out, store.version);
        EdgeTypeStore edgeTypeStore = store.edgeTypeStore;
        this.serialize(out, edgeTypeStore);
        this.serialize(out, store.nodeTable);
        this.serialize(out, store.edgeTable);
        this.serialize(out, store.timeStore);
        this.serialize(out, store.factory);
        this.serialize(out, store.attributes);
        this.serialize(out, (Object)store.timeFormat);
        this.serialize(out, store.timeZone);
        int nodesAndEdges = store.nodeStore.size() + store.edgeStore.size();
        this.serialize(out, nodesAndEdges);
        for (Node node : store.nodeStore) {
            this.serialize(out, node);
        }
        for (Edge edge : store.edgeStore) {
            this.serialize(out, edge);
        }
        this.serialize(out, store.viewStore);
    }

    public GraphStore deserializeGraphStore(DataInput is) throws IOException, ClassNotFoundException {
        if (!this.model.store.nodeStore.isEmpty()) {
            throw new IOException("The store is not empty");
        }
        this.deserialize(is);
        GraphVersion version = (GraphVersion)this.deserialize(is);
        this.model.store.version.nodeVersion = version.nodeVersion;
        this.model.store.version.edgeVersion = version.edgeVersion;
        this.deserialize(is);
        this.deserialize(is);
        this.deserialize(is);
        this.deserialize(is);
        this.deserialize(is);
        GraphAttributesImpl attributes = (GraphAttributesImpl)this.deserialize(is);
        this.model.store.attributes.setGraphAttributes(attributes);
        this.deserialize(is);
        this.deserialize(is);
        int nodesAndEdges = (Integer)this.deserialize(is);
        for (int i = 0; i < nodesAndEdges; ++i) {
            this.deserialize(is);
        }
        this.deserialize(is);
        return this.model.store;
    }

    private void serializeNode(DataOutput out, NodeImpl node) throws IOException {
        this.serialize(out, node.getId());
        this.serialize(out, node.storeId);
        this.serialize(out, node.attributes);
        this.serialize(out, node.properties);
    }

    private void serializeEdge(DataOutput out, EdgeImpl edge) throws IOException {
        this.serialize(out, edge.getId());
        this.serialize(out, edge.source.storeId);
        this.serialize(out, edge.target.storeId);
        this.serialize(out, edge.type);
        if (edge.graphStore != null && edge.hasDynamicWeight()) {
            this.serialize(out, edge.getWeight());
        } else {
            this.serialize(out, GraphStoreConfiguration.DEFAULT_EDGE_WEIGHT);
        }
        this.serialize(out, edge.isDirected());
        this.serialize(out, edge.attributes);
        this.serialize(out, edge.properties);
    }

    private NodeImpl deserializeNode(DataInput is) throws IOException, ClassNotFoundException {
        Object id = this.deserialize(is);
        int storeId = (Integer)this.deserialize(is);
        Object[] attributes = (Object[])this.deserialize(is);
        NodeImpl.NodePropertiesImpl properties = (NodeImpl.NodePropertiesImpl)this.deserialize(is);
        NodeImpl node = (NodeImpl)this.model.store.factory.newNode(id);
        node.attributes = attributes;
        if (node.properties != null) {
            node.setNodeProperties(properties);
        }
        this.model.store.nodeStore.add(node);
        this.idMap.put(storeId, node.storeId);
        return node;
    }

    private EdgeImpl deserializeEdge(DataInput is) throws IOException, ClassNotFoundException {
        Object id = this.deserialize(is);
        int sourceId = (Integer)this.deserialize(is);
        int targetId = (Integer)this.deserialize(is);
        int type = (Integer)this.deserialize(is);
        double weight = (Double)this.deserialize(is);
        boolean directed = (Boolean)this.deserialize(is);
        Object[] attributes = (Object[])this.deserialize(is);
        EdgeImpl.EdgePropertiesImpl properties = (EdgeImpl.EdgePropertiesImpl)this.deserialize(is);
        int sourceNewId = this.idMap.get(sourceId);
        int targetNewId = this.idMap.get(targetId);
        if (sourceId == -1 || targetId == -1) {
            throw new IOException("The edge source of target can't be found");
        }
        NodeImpl source = this.model.store.nodeStore.get(sourceNewId);
        NodeImpl target = this.model.store.nodeStore.get(targetNewId);
        EdgeImpl edge = (EdgeImpl)this.model.store.factory.newEdge(id, source, target, type, weight, directed);
        edge.attributes = attributes;
        if (edge.properties != null) {
            edge.setEdgeProperties(properties);
        }
        this.model.store.edgeStore.add(edge);
        return edge;
    }

    private void serializeEdgeTypeStore(DataOutput out) throws IOException {
        EdgeTypeStore edgeTypeStore = this.model.store.edgeTypeStore;
        int length = edgeTypeStore.length;
        this.serialize(out, length);
        short[] ids = edgeTypeStore.getIds();
        this.serialize(out, ids);
        Object[] labels = edgeTypeStore.getLabels();
        this.serialize(out, labels);
        short[] garbage = edgeTypeStore.getGarbage();
        this.serialize(out, garbage);
    }

    private EdgeTypeStore deserializeEdgeTypeStore(DataInput is) throws IOException, ClassNotFoundException {
        int i;
        int length = (Integer)this.deserialize(is);
        short[] ids = (short[])this.deserialize(is);
        Object[] labels = (Object[])this.deserialize(is);
        short[] garbage = (short[])this.deserialize(is);
        EdgeTypeStore edgeTypeStore = this.model.store.edgeTypeStore;
        edgeTypeStore.length = length;
        for (i = 0; i < ids.length; ++i) {
            short id = ids[i];
            Object label = labels[i];
            edgeTypeStore.idMap.put(id, label);
            edgeTypeStore.labelMap.put(label, id);
        }
        for (i = 0; i < garbage.length; ++i) {
            edgeTypeStore.garbageQueue.add(garbage[i]);
        }
        return edgeTypeStore;
    }

    private void serializeTable(DataOutput out, TableImpl table) throws IOException {
        this.serialize(out, table.store.elementType);
        this.serializeColumnStore(out, table.store);
    }

    private TableImpl deserializeTable(DataInput is) throws IOException, ClassNotFoundException {
        Class elementType = (Class)this.deserialize(is);
        TableImpl<Element> table = null;
        if (elementType.equals(Node.class)) {
            table = this.model.store.nodeTable;
        } else if (elementType.equals(Edge.class)) {
            table = this.model.store.edgeTable;
        } else {
            throw new RuntimeException("Not recognized column store");
        }
        this.deserializeColumnStore(is, table);
        return table;
    }

    private void serializeColumnStore(DataOutput out, ColumnStore columnStore) throws IOException {
        int length = columnStore.length;
        this.serialize(out, length);
        for (int i = 0; i < length; ++i) {
            ColumnImpl col = columnStore.columns[i];
            this.serializeColumn(out, col);
        }
        this.serialize(out, columnStore.garbageQueue.toShortArray());
    }

    private ColumnStore deserializeColumnStore(DataInput is, TableImpl table) throws IOException, ClassNotFoundException {
        int length;
        ColumnStore columnStore = table.store;
        columnStore.length = length = ((Integer)this.deserialize(is)).intValue();
        for (int i = 0; i < length; ++i) {
            ColumnImpl col = this.deserializeColumn(is, table);
            if (col == null) continue;
            columnStore.columns[col.storeId] = col;
            columnStore.idMap.put((Object)col.id, columnStore.intToShort(col.storeId));
            if (columnStore.indexStore == null) continue;
            columnStore.indexStore.addColumn(col);
        }
        short[] garbage = (short[])this.deserialize(is);
        for (int i = 0; i < garbage.length; ++i) {
            columnStore.garbageQueue.add(garbage[i]);
        }
        return columnStore;
    }

    private void serializeColumn(DataOutput out, ColumnImpl column) throws IOException {
        if (column == null) {
            this.serialize(out, null);
            return;
        }
        this.serialize(out, column.id);
        this.serialize(out, column.title);
        this.serialize(out, (Object)column.origin);
        this.serialize(out, column.storeId);
        this.serialize(out, column.typeClass);
        this.serialize(out, column.defaultValue);
        this.serialize(out, column.indexed);
        this.serialize(out, column.readOnly);
        this.serialize(out, (Object)column.estimator);
    }

    private ColumnImpl deserializeColumn(DataInput is, TableImpl table) throws IOException, ClassNotFoundException {
        String id = (String)this.deserialize(is);
        if (id == null) {
            return null;
        }
        String title = (String)this.deserialize(is);
        Origin origin = (Origin)((Object)this.deserialize(is));
        int storeId = (Integer)this.deserialize(is);
        Class typeClass = (Class)this.deserialize(is);
        Object defaultValue = this.deserialize(is);
        boolean indexed = (Boolean)this.deserialize(is);
        boolean readOnly = (Boolean)this.deserialize(is);
        Estimator estimator = (Estimator)((Object)this.deserialize(is));
        ColumnImpl column = new ColumnImpl(table, id, typeClass, title, defaultValue, origin, indexed, readOnly);
        column.storeId = storeId;
        if (estimator != null) {
            column.setEstimator(estimator);
        }
        if (Edge.class.equals((Object)table.getElementClass())) {
            if (id.equals("weight")) {
                table.store.configuration.setEdgeWeightType(typeClass);
            } else if (id.equals("id")) {
                table.store.configuration.setEdgeIdType(typeClass);
            }
        } else if (Node.class.equals((Object)table.getElementClass()) && id.equals("id")) {
            table.store.configuration.setNodeIdType(typeClass);
        }
        return column;
    }

    private void serializeGraphFactory(DataOutput out) throws IOException {
        GraphFactoryImpl factory = this.model.store.factory;
        this.serialize(out, factory.getNodeCounter());
        this.serialize(out, factory.getEdgeCounter());
    }

    private GraphFactoryImpl deserializeGraphFactory(DataInput is) throws IOException, ClassNotFoundException {
        GraphFactoryImpl graphFactory = this.model.store.factory;
        int nodeCounter = (Integer)this.deserialize(is);
        int edgeCounter = (Integer)this.deserialize(is);
        graphFactory.setNodeCounter(nodeCounter);
        graphFactory.setEdgeCounter(edgeCounter);
        return graphFactory;
    }

    private void serializeViewStore(DataOutput out) throws IOException {
        GraphViewStore viewStore = this.model.store.viewStore;
        this.serialize(out, viewStore.length);
        this.serialize(out, viewStore.views);
        this.serialize(out, viewStore.garbageQueue.toIntArray());
    }

    private GraphViewStore deserializeViewStore(DataInput is) throws IOException, ClassNotFoundException {
        GraphViewStore viewStore = this.model.store.viewStore;
        int length = (Integer)this.deserialize(is);
        Object[] views = (Object[])this.deserialize(is);
        int[] garbages = (int[])this.deserialize(is);
        viewStore.length = length;
        viewStore.views = new GraphViewImpl[views.length];
        System.arraycopy(views, 0, viewStore.views, 0, views.length);
        for (int i = 0; i < garbages.length; ++i) {
            viewStore.garbageQueue.add(garbages[i]);
        }
        return viewStore;
    }

    private void serializeGraphView(DataOutput out, GraphViewImpl view) throws IOException {
        this.serialize(out, view.nodeView);
        this.serialize(out, view.edgeView);
        this.serialize(out, view.storeId);
        this.serialize(out, view.nodeCount);
        this.serialize(out, view.edgeCount);
        this.serialize(out, view.nodeBitVector);
        this.serialize(out, view.edgeBitVector);
        this.serialize(out, view.typeCounts);
        this.serialize(out, view.mutualEdgeTypeCounts);
        this.serialize(out, view.mutualEdgesCount);
        this.serialize(out, view.version);
        this.serialize(out, view.attributes);
        this.serialize(out, view.interval);
    }

    private GraphViewImpl deserializeGraphView(DataInput is) throws IOException, ClassNotFoundException {
        boolean nodeView = (Boolean)this.deserialize(is);
        boolean edgeView = (Boolean)this.deserialize(is);
        GraphViewImpl view = new GraphViewImpl(this.model.store, nodeView, edgeView);
        int storeId = (Integer)this.deserialize(is);
        int nodeCount = (Integer)this.deserialize(is);
        int edgeCount = (Integer)this.deserialize(is);
        BitVector nodeCountVector = (BitVector)this.deserialize(is);
        BitVector edgeCountVector = (BitVector)this.deserialize(is);
        int[] typeCounts = (int[])this.deserialize(is);
        int[] mutualEdgeTypeCounts = (int[])this.deserialize(is);
        int mutualEdgesCount = (Integer)this.deserialize(is);
        GraphVersion version = (GraphVersion)this.deserialize(is);
        GraphAttributesImpl atts = (GraphAttributesImpl)this.deserialize(is);
        Interval interval = (Interval)this.deserialize(is);
        view.nodeCount = nodeCount;
        view.edgeCount = edgeCount;
        view.nodeBitVector = nodeCountVector;
        view.edgeBitVector = edgeCountVector;
        view.storeId = storeId;
        view.typeCounts = typeCounts;
        view.mutualEdgesCount = mutualEdgesCount;
        view.mutualEdgeTypeCounts = mutualEdgeTypeCounts;
        view.version.nodeVersion = version.nodeVersion;
        view.version.edgeVersion = version.edgeVersion;
        view.attributes.setGraphAttributes(atts);
        view.interval = interval;
        return view;
    }

    private void serializeBitVector(DataOutput out, BitVector bitVector) throws IOException {
        this.serialize(out, bitVector.size());
        this.serialize(out, bitVector.elements());
    }

    private BitVector deserializeBitVector(DataInput is) throws IOException, ClassNotFoundException {
        int size = (Integer)this.deserialize(is);
        long[] elements = (long[])this.deserialize(is);
        return new BitVector(elements, size);
    }

    private void serializeGraphStoreConfiguration(DataOutput out) throws IOException {
        out.write(211);
        this.serialize(out, true);
        this.serialize(out, true);
        this.serialize(out, true);
        this.serialize(out, true);
    }

    private GraphStoreConfigurationVersion deserializeGraphStoreConfiguration(DataInput is) throws IOException, ClassNotFoundException {
        boolean enableElementLabel = (Boolean)this.deserialize(is);
        boolean enableElementTimestamp = (Boolean)this.deserialize(is);
        boolean enableNodeProperties = (Boolean)this.deserialize(is);
        boolean enableEdgeProperties = (Boolean)this.deserialize(is);
        this.graphStoreConfigurationVersion = new GraphStoreConfigurationVersion(enableElementLabel, enableElementTimestamp, enableNodeProperties, enableEdgeProperties);
        return this.graphStoreConfigurationVersion;
    }

    private void serializeGraphVersion(DataOutput out, GraphVersion graphVersion) throws IOException {
        this.serialize(out, graphVersion.nodeVersion);
        this.serialize(out, graphVersion.edgeVersion);
    }

    private GraphVersion deserializeGraphVersion(DataInput is) throws IOException, ClassNotFoundException {
        GraphVersion graphVersion = new GraphVersion(null);
        int nodeVersion = (Integer)this.deserialize(is);
        int edgeVersion = (Integer)this.deserialize(is);
        graphVersion.nodeVersion = nodeVersion;
        graphVersion.edgeVersion = edgeVersion;
        return graphVersion;
    }

    private void serializeNodeProperties(DataOutput out, NodeImpl.NodePropertiesImpl nodeProperties) throws IOException {
        this.serialize(out, Float.valueOf(nodeProperties.x));
        this.serialize(out, Float.valueOf(nodeProperties.y));
        this.serialize(out, Float.valueOf(nodeProperties.z));
        this.serialize(out, nodeProperties.rgba);
        this.serialize(out, Float.valueOf(nodeProperties.size));
        this.serialize(out, nodeProperties.fixed);
        this.serialize(out, nodeProperties.textProperties);
    }

    private NodeImpl.NodePropertiesImpl deserializeNodeProperties(DataInput is) throws IOException, ClassNotFoundException {
        float x = ((Float)this.deserialize(is)).floatValue();
        float y = ((Float)this.deserialize(is)).floatValue();
        float z = ((Float)this.deserialize(is)).floatValue();
        int rgba = (Integer)this.deserialize(is);
        float size = ((Float)this.deserialize(is)).floatValue();
        boolean fixed = (Boolean)this.deserialize(is);
        TextPropertiesImpl textProperties = (TextPropertiesImpl)this.deserialize(is);
        NodeImpl.NodePropertiesImpl props = new NodeImpl.NodePropertiesImpl();
        props.x = x;
        props.y = y;
        props.z = z;
        props.rgba = rgba;
        props.size = size;
        props.fixed = fixed;
        props.setTextProperties(textProperties);
        return props;
    }

    private void serializeEdgeProperties(DataOutput out, EdgeImpl.EdgePropertiesImpl edgeProperties) throws IOException {
        this.serialize(out, edgeProperties.rgba);
        this.serialize(out, edgeProperties.textProperties);
    }

    private EdgeImpl.EdgePropertiesImpl deserializeEdgeProperties(DataInput is) throws IOException, ClassNotFoundException {
        int rgba = (Integer)this.deserialize(is);
        TextPropertiesImpl textProperties = (TextPropertiesImpl)this.deserialize(is);
        EdgeImpl.EdgePropertiesImpl props = new EdgeImpl.EdgePropertiesImpl();
        props.rgba = rgba;
        props.setTextProperties(textProperties);
        return props;
    }

    private void serializeTextProperties(DataOutput out, TextPropertiesImpl textProperties) throws IOException {
        this.serialize(out, Float.valueOf(textProperties.size));
        this.serialize(out, textProperties.rgba);
        this.serialize(out, textProperties.visible);
        this.serialize(out, textProperties.text);
        this.serialize(out, Float.valueOf(textProperties.width));
        this.serialize(out, Float.valueOf(textProperties.height));
    }

    private TextPropertiesImpl deserializeTextProperties(DataInput is) throws IOException, ClassNotFoundException {
        float size = ((Float)this.deserialize(is)).floatValue();
        int rgba = (Integer)this.deserialize(is);
        boolean visible = (Boolean)this.deserialize(is);
        String text = (String)this.deserialize(is);
        float width = ((Float)this.deserialize(is)).floatValue();
        float height = ((Float)this.deserialize(is)).floatValue();
        TextPropertiesImpl props = new TextPropertiesImpl();
        props.size = size;
        props.rgba = rgba;
        props.visible = visible;
        props.text = text;
        props.width = width;
        props.height = height;
        return props;
    }

    private void serializeTimestampSet(DataOutput out, TimestampSet timestampSet) throws IOException {
        this.serialize(out, timestampSet.toPrimitiveArray());
    }

    private TimestampSet deserializeTimestampSet(DataInput is) throws IOException, ClassNotFoundException {
        double[] r = (double[])this.deserialize(is);
        return new TimestampSet(r);
    }

    private void serializeIntervalSet(DataOutput out, IntervalSet intervalSet) throws IOException {
        this.serialize(out, intervalSet.getIntervals());
    }

    private IntervalSet deserializeIntervalSet(DataInput is) throws IOException, ClassNotFoundException {
        double[] r = (double[])this.deserialize(is);
        return new IntervalSet(r);
    }

    private void serializeTimestampMap(DataOutput out, TimestampMap timestampMap) throws IOException {
        this.serialize(out, timestampMap.getTimestamps());
        Class<?> mapClass = timestampMap.getClass();
        if (mapClass.equals(TimestampBooleanMap.class)) {
            this.serialize(out, ((TimestampBooleanMap)timestampMap).toBooleanArray());
        } else if (mapClass.equals(TimestampByteMap.class)) {
            this.serialize(out, ((TimestampByteMap)timestampMap).toByteArray());
        } else if (mapClass.equals(TimestampCharMap.class)) {
            this.serialize(out, ((TimestampCharMap)timestampMap).toCharacterArray());
        } else if (mapClass.equals(TimestampDoubleMap.class)) {
            this.serialize(out, ((TimestampDoubleMap)timestampMap).toDoubleArray());
        } else if (mapClass.equals(TimestampFloatMap.class)) {
            this.serialize(out, ((TimestampFloatMap)timestampMap).toFloatArray());
        } else if (mapClass.equals(TimestampIntegerMap.class)) {
            this.serialize(out, ((TimestampIntegerMap)timestampMap).toIntegerArray());
        } else if (mapClass.equals(TimestampLongMap.class)) {
            this.serialize(out, ((TimestampLongMap)timestampMap).toLongArray());
        } else if (mapClass.equals(TimestampShortMap.class)) {
            this.serialize(out, ((TimestampShortMap)timestampMap).toShortArray());
        } else if (mapClass.equals(TimestampStringMap.class)) {
            this.serialize(out, timestampMap.toValuesArray());
        } else {
            throw new RuntimeException("Unrecognized timestamp map class");
        }
    }

    private TimestampMap deserializeTimestampMap(DataInput is) throws IOException, ClassNotFoundException {
        TimestampMap valueSet;
        double[] timeStamps = (double[])this.deserialize(is);
        Object values = this.deserialize(is);
        Class<?> mapClass = values.getClass();
        if (mapClass.equals(boolean[].class)) {
            valueSet = new TimestampBooleanMap(timeStamps, (boolean[])values);
        } else if (mapClass.equals(byte[].class)) {
            valueSet = new TimestampByteMap(timeStamps, (byte[])values);
        } else if (mapClass.equals(char[].class)) {
            valueSet = new TimestampCharMap(timeStamps, (char[])values);
        } else if (mapClass.equals(double[].class)) {
            valueSet = new TimestampDoubleMap(timeStamps, (double[])values);
        } else if (mapClass.equals(float[].class)) {
            valueSet = new TimestampFloatMap(timeStamps, (float[])values);
        } else if (mapClass.equals(int[].class)) {
            valueSet = new TimestampIntegerMap(timeStamps, (int[])values);
        } else if (mapClass.equals(long[].class)) {
            valueSet = new TimestampLongMap(timeStamps, (long[])values);
        } else if (mapClass.equals(short[].class)) {
            valueSet = new TimestampShortMap(timeStamps, (short[])values);
        } else if (mapClass.equals(String[].class)) {
            valueSet = new TimestampStringMap(timeStamps, (String[])values);
        } else {
            throw new RuntimeException("Unrecognized timestamp map class");
        }
        return valueSet;
    }

    private void serializeIntervalMap(DataOutput out, IntervalMap intervalMap) throws IOException {
        this.serialize(out, intervalMap.getIntervals());
        Class<?> mapClass = intervalMap.getClass();
        if (mapClass.equals(IntervalBooleanMap.class)) {
            this.serialize(out, ((IntervalBooleanMap)intervalMap).toBooleanArray());
        } else if (mapClass.equals(IntervalByteMap.class)) {
            this.serialize(out, ((IntervalByteMap)intervalMap).toByteArray());
        } else if (mapClass.equals(IntervalCharMap.class)) {
            this.serialize(out, ((IntervalCharMap)intervalMap).toCharacterArray());
        } else if (mapClass.equals(IntervalDoubleMap.class)) {
            this.serialize(out, ((IntervalDoubleMap)intervalMap).toDoubleArray());
        } else if (mapClass.equals(IntervalFloatMap.class)) {
            this.serialize(out, ((IntervalFloatMap)intervalMap).toFloatArray());
        } else if (mapClass.equals(IntervalIntegerMap.class)) {
            this.serialize(out, ((IntervalIntegerMap)intervalMap).toIntegerArray());
        } else if (mapClass.equals(IntervalLongMap.class)) {
            this.serialize(out, ((IntervalLongMap)intervalMap).toLongArray());
        } else if (mapClass.equals(IntervalShortMap.class)) {
            this.serialize(out, ((IntervalShortMap)intervalMap).toShortArray());
        } else if (mapClass.equals(IntervalStringMap.class)) {
            this.serialize(out, intervalMap.toValuesArray());
        } else {
            throw new RuntimeException("Unrecognized interval map class");
        }
    }

    private IntervalMap deserializeIntervalMap(DataInput is) throws IOException, ClassNotFoundException {
        IntervalMap valueSet;
        double[] intervals = (double[])this.deserialize(is);
        Object values = this.deserialize(is);
        Class<?> mapClass = values.getClass();
        if (mapClass.equals(boolean[].class)) {
            valueSet = new IntervalBooleanMap(intervals, (boolean[])values);
        } else if (mapClass.equals(byte[].class)) {
            valueSet = new IntervalByteMap(intervals, (byte[])values);
        } else if (mapClass.equals(char[].class)) {
            valueSet = new IntervalCharMap(intervals, (char[])values);
        } else if (mapClass.equals(double[].class)) {
            valueSet = new IntervalDoubleMap(intervals, (double[])values);
        } else if (mapClass.equals(float[].class)) {
            valueSet = new IntervalFloatMap(intervals, (float[])values);
        } else if (mapClass.equals(int[].class)) {
            valueSet = new IntervalIntegerMap(intervals, (int[])values);
        } else if (mapClass.equals(long[].class)) {
            valueSet = new IntervalLongMap(intervals, (long[])values);
        } else if (mapClass.equals(short[].class)) {
            valueSet = new IntervalShortMap(intervals, (short[])values);
        } else if (mapClass.equals(String[].class)) {
            valueSet = new IntervalStringMap(intervals, (String[])values);
        } else {
            throw new RuntimeException("Unrecognized timestamp map class");
        }
        return valueSet;
    }

    private void serializeTimestampIndexStore(DataOutput out, TimestampIndexStore timestampIndexStore) throws IOException {
        this.serialize(out, timestampIndexStore.elementType);
        this.serialize(out, timestampIndexStore.length);
        this.serialize(out, timestampIndexStore.getMap().keySet().toDoubleArray());
        this.serialize(out, timestampIndexStore.getMap().values().toIntArray());
        this.serialize(out, timestampIndexStore.garbageQueue.toIntArray());
        this.serialize(out, timestampIndexStore.countMap);
    }

    private TimestampIndexStore deserializeTimestampIndexStore(DataInput is) throws IOException, ClassNotFoundException {
        Class cls = (Class)this.deserialize(is);
        TimestampIndexStore timestampIndexStore = cls.equals(Node.class) ? (TimestampIndexStore)this.model.store.timeStore.nodeIndexStore : (TimestampIndexStore)this.model.store.timeStore.edgeIndexStore;
        int length = (Integer)this.deserialize(is);
        double[] doubles = (double[])this.deserialize(is);
        int[] ints = (int[])this.deserialize(is);
        int[] garbage = (int[])this.deserialize(is);
        int[] counts = (int[])this.deserialize(is);
        timestampIndexStore.length = length;
        for (int i : garbage) {
            timestampIndexStore.garbageQueue.add(i);
        }
        Double2IntRBTreeMap m = timestampIndexStore.getMap();
        for (int i = 0; i < ints.length; ++i) {
            m.put(doubles[i], ints[i]);
        }
        timestampIndexStore.countMap = counts;
        return timestampIndexStore;
    }

    private void serializeIntervalIndexStore(DataOutput out, IntervalIndexStore intervalIndexStore) throws IOException {
        this.serialize(out, intervalIndexStore.elementType);
        this.serialize(out, intervalIndexStore.length);
        this.serialize(out, intervalIndexStore.getMap().size());
        for (Map.Entry<Interval, Integer> entry : intervalIndexStore.getMap().entrySet()) {
            this.serialize(out, entry.getKey());
            this.serialize(out, entry.getValue());
        }
        this.serialize(out, intervalIndexStore.garbageQueue.toIntArray());
        this.serialize(out, intervalIndexStore.countMap);
    }

    private IntervalIndexStore deserializeIntervalIndexStore(DataInput is) throws IOException, ClassNotFoundException {
        Class cls = (Class)this.deserialize(is);
        IntervalIndexStore intervalIndexStore = cls.equals(Node.class) ? (IntervalIndexStore)this.model.store.timeStore.nodeIndexStore : (IntervalIndexStore)this.model.store.timeStore.edgeIndexStore;
        int length = (Integer)this.deserialize(is);
        int mapSize = (Integer)this.deserialize(is);
        Interval2IntTreeMap map = intervalIndexStore.getMap();
        for (int i = 0; i < mapSize; ++i) {
            Interval key = (Interval)this.deserialize(is);
            Integer value = (Integer)this.deserialize(is);
            map.put(key, value);
        }
        int[] garbage = (int[])this.deserialize(is);
        int[] counts = (int[])this.deserialize(is);
        intervalIndexStore.length = length;
        for (int i : garbage) {
            intervalIndexStore.garbageQueue.add(i);
        }
        intervalIndexStore.countMap = counts;
        return intervalIndexStore;
    }

    private void serializeGraphAttributes(DataOutput out, GraphAttributesImpl graphAttributes) throws IOException {
        this.serialize(out, graphAttributes.attributes.size());
        for (Map.Entry<String, Object> entry : graphAttributes.attributes.entrySet()) {
            this.serialize(out, entry.getKey());
            this.serialize(out, entry.getValue());
        }
    }

    private GraphAttributesImpl deserializeGraphAttributes(DataInput is) throws IOException, ClassNotFoundException {
        GraphAttributesImpl attributes = new GraphAttributesImpl();
        int size = (Integer)this.deserialize(is);
        for (int i = 0; i < size; ++i) {
            String key = (String)this.deserialize(is);
            Object value = this.deserialize(is);
            attributes.attributes.put(key, value);
        }
        return attributes;
    }

    private void serializeTimeFormat(DataOutput out, TimeFormat timeFormat) throws IOException {
        this.serialize(out, timeFormat.name());
    }

    private TimeFormat deserializeTimeFormat(DataInput is) throws IOException, ClassNotFoundException {
        TimeFormat tf;
        String name = (String)this.deserialize(is);
        this.model.store.timeFormat = tf = TimeFormat.valueOf(name);
        return tf;
    }

    private void serializeTimeZone(DataOutput out, DateTimeZone timeZone) throws IOException {
        this.serialize(out, timeZone.getID());
    }

    private DateTimeZone deserializeTimeZone(DataInput is) throws IOException, ClassNotFoundException {
        DateTimeZone tz;
        String id = (String)this.deserialize(is);
        this.model.store.timeZone = tz = DateTimeZone.forID((String)id);
        return tz;
    }

    private void serializeTimeStore(DataOutput out) throws IOException {
        TimeStore timeStore = this.model.store.timeStore;
        this.serialize(out, timeStore.nodeIndexStore);
        this.serialize(out, timeStore.edgeIndexStore);
    }

    private void serializeInterval(DataOutput out, Interval interval) throws IOException {
        this.serialize(out, interval.getLow());
        this.serialize(out, interval.getHigh());
    }

    private Interval deserializeInterval(DataInput is) throws IOException, ClassNotFoundException {
        double start = (Double)this.deserialize(is);
        double end = (Double)this.deserialize(is);
        return new Interval(start, end);
    }

    private TimeStore deserializeTimeStore(DataInput is) throws IOException, ClassNotFoundException {
        TimeStore timeStore = this.model.store.timeStore;
        this.deserialize(is);
        this.deserialize(is);
        return timeStore;
    }

    private void serializeConfiguration(DataOutput out) throws IOException {
        Configuration config = this.model.store.configuration;
        this.serialize(out, config.getNodeIdType());
        this.serialize(out, config.getEdgeIdType());
        this.serialize(out, config.getEdgeLabelType());
        this.serialize(out, config.getEdgeWeightType());
        this.serialize(out, (Object)config.getTimeRepresentation());
        this.serialize(out, config.getEdgeWeightColumn());
    }

    private Configuration deserializeConfiguration(DataInput is) throws IOException, ClassNotFoundException {
        Configuration config = new Configuration();
        Class nodeIdType = (Class)this.deserialize(is);
        Class edgeIdType = (Class)this.deserialize(is);
        Class edgeLabelType = (Class)this.deserialize(is);
        Class edgeWeightType = (Class)this.deserialize(is);
        TimeRepresentation timeRepresentation = (TimeRepresentation)((Object)this.deserialize(is));
        config.setNodeIdType(nodeIdType);
        config.setEdgeIdType(edgeIdType);
        config.setEdgeLabelType(edgeLabelType);
        config.setEdgeWeightType(edgeWeightType);
        config.setTimeRepresentation(timeRepresentation);
        if ((double)this.readVersion >= 0.5) {
            Boolean edgeColumn = (Boolean)this.deserialize(is);
            config.setEdgeWeightColumn(edgeColumn);
        }
        return config;
    }

    private void serializeList(DataOutput out, List list) throws IOException {
        Class<?> oCls = list.getClass();
        if (oCls.equals(IntArrayList.class)) {
            this.serialize(out, ((IntArrayList)list).toIntArray());
        } else if (oCls.equals(FloatArrayList.class)) {
            this.serialize(out, ((FloatArrayList)list).toFloatArray());
        } else if (oCls.equals(DoubleArrayList.class)) {
            this.serialize(out, ((DoubleArrayList)list).toDoubleArray());
        } else if (oCls.equals(ShortArrayList.class)) {
            this.serialize(out, ((ShortArrayList)list).toShortArray());
        } else if (oCls.equals(ByteArrayList.class)) {
            this.serialize(out, ((ByteArrayList)list).toByteArray());
        } else if (oCls.equals(LongArrayList.class)) {
            this.serialize(out, ((LongArrayList)list).toLongArray());
        } else if (oCls.equals(BooleanArrayList.class)) {
            this.serialize(out, ((BooleanArrayList)list).toBooleanArray());
        } else if (oCls.equals(CharArrayList.class)) {
            this.serialize(out, ((CharArrayList)list).toCharArray());
        } else {
            this.serialize(out, list.size());
            for (Object obj : list) {
                this.serialize(out, obj);
            }
        }
    }

    private List deserializeList(DataInput is) throws IOException, ClassNotFoundException {
        Object h = this.deserialize(is);
        Class<?> oCls = h.getClass();
        if (oCls.equals(Integer.class)) {
            int size = (Integer)h;
            ObjectArrayList list = new ObjectArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.deserialize(is));
            }
            return list;
        }
        if (oCls.equals(int[].class)) {
            return new IntArrayList((int[])h);
        }
        if (oCls.equals(float[].class)) {
            return new FloatArrayList((float[])h);
        }
        if (oCls.equals(double[].class)) {
            return new DoubleArrayList((double[])h);
        }
        if (oCls.equals(short[].class)) {
            return new ShortArrayList((short[])h);
        }
        if (oCls.equals(byte[].class)) {
            return new ByteArrayList((byte[])h);
        }
        if (oCls.equals(long[].class)) {
            return new LongArrayList((long[])h);
        }
        if (oCls.equals(boolean[].class)) {
            return new BooleanArrayList((boolean[])h);
        }
        if (oCls.equals(char[].class)) {
            return new CharArrayList((char[])h);
        }
        throw new EOFException();
    }

    private void serializeSet(DataOutput out, Set set) throws IOException {
        Class<?> oCls = set.getClass();
        if (oCls.equals(IntOpenHashSet.class)) {
            this.serialize(out, ((IntOpenHashSet)set).toIntArray());
        } else if (oCls.equals(FloatOpenHashSet.class)) {
            this.serialize(out, ((FloatOpenHashSet)set).toFloatArray());
        } else if (oCls.equals(DoubleOpenHashSet.class)) {
            this.serialize(out, ((DoubleOpenHashSet)set).toDoubleArray());
        } else if (oCls.equals(ShortOpenHashSet.class)) {
            this.serialize(out, ((ShortOpenHashSet)set).toShortArray());
        } else if (oCls.equals(ByteOpenHashSet.class)) {
            this.serialize(out, ((ByteOpenHashSet)set).toByteArray());
        } else if (oCls.equals(LongOpenHashSet.class)) {
            this.serialize(out, ((LongOpenHashSet)set).toLongArray());
        } else if (oCls.equals(BooleanOpenHashSet.class)) {
            this.serialize(out, ((BooleanOpenHashSet)set).toBooleanArray());
        } else if (oCls.equals(CharOpenHashSet.class)) {
            this.serialize(out, ((CharOpenHashSet)set).toCharArray());
        } else {
            this.serialize(out, set.size());
            for (Object obj : set) {
                this.serialize(out, obj);
            }
        }
    }

    private Set deserializeSet(DataInput is) throws IOException, ClassNotFoundException {
        Object h = this.deserialize(is);
        Class<?> oCls = h.getClass();
        if (oCls.equals(Integer.class)) {
            int size = (Integer)h;
            ObjectOpenHashSet set = new ObjectOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                set.add(this.deserialize(is));
            }
            return set;
        }
        if (oCls.equals(int[].class)) {
            return new IntOpenHashSet((int[])h);
        }
        if (oCls.equals(float[].class)) {
            return new FloatOpenHashSet((float[])h);
        }
        if (oCls.equals(double[].class)) {
            return new DoubleOpenHashSet((double[])h);
        }
        if (oCls.equals(short[].class)) {
            return new ShortOpenHashSet((short[])h);
        }
        if (oCls.equals(byte[].class)) {
            return new ByteOpenHashSet((byte[])h);
        }
        if (oCls.equals(long[].class)) {
            return new LongOpenHashSet((long[])h);
        }
        if (oCls.equals(boolean[].class)) {
            return new BooleanOpenHashSet((boolean[])h);
        }
        if (oCls.equals(char[].class)) {
            return new CharOpenHashSet((char[])h);
        }
        throw new EOFException();
    }

    private void serializeMap(DataOutput out, Map map) throws IOException {
        Class<?> oCls = map.getClass();
        if (oCls.equals(Int2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Int2ObjectOpenHashMap)map).keySet().toIntArray());
            this.serialize(out, map.values().toArray());
        } else if (oCls.equals(Float2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Float2ObjectOpenHashMap)map).keySet().toFloatArray());
            this.serialize(out, map.values().toArray());
        } else if (oCls.equals(Double2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Double2ObjectOpenHashMap)map).keySet().toDoubleArray());
            this.serialize(out, map.values().toArray());
        } else if (oCls.equals(Short2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Short2ObjectOpenHashMap)map).keySet().toShortArray());
            this.serialize(out, map.values().toArray());
        } else if (oCls.equals(Long2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Long2ObjectOpenHashMap)map).keySet().toLongArray());
            this.serialize(out, map.values().toArray());
        } else if (oCls.equals(Byte2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Byte2ObjectOpenHashMap)map).keySet().toByteArray());
            this.serialize(out, map.values().toArray());
        } else if (oCls.equals(Char2ObjectOpenHashMap.class)) {
            this.serialize(out, ((Char2ObjectOpenHashMap)map).keySet().toCharArray());
            this.serialize(out, map.values().toArray());
        } else {
            this.serialize(out, map.size());
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                this.serialize(out, entry.getKey());
                this.serialize(out, entry.getValue());
            }
        }
    }

    private Map deserializeMap(DataInput is) throws IOException, ClassNotFoundException {
        Object h = this.deserialize(is);
        Class<?> oCls = h.getClass();
        if (oCls.equals(Integer.class)) {
            int size = (Integer)h;
            Object2ObjectOpenHashMap set = new Object2ObjectOpenHashMap(size);
            for (int i = 0; i < size; ++i) {
                set.put(this.deserialize(is), this.deserialize(is));
            }
            return set;
        }
        if (oCls.equals(int[].class)) {
            return new Int2ObjectOpenHashMap((int[])h, (Object[])this.deserialize(is));
        }
        if (oCls.equals(float[].class)) {
            return new Float2ObjectOpenHashMap((float[])h, (Object[])this.deserialize(is));
        }
        if (oCls.equals(double[].class)) {
            return new Double2ObjectOpenHashMap((double[])h, (Object[])this.deserialize(is));
        }
        if (oCls.equals(short[].class)) {
            return new Short2ObjectOpenHashMap((short[])h, (Object[])this.deserialize(is));
        }
        if (oCls.equals(byte[].class)) {
            return new Byte2ObjectOpenHashMap((byte[])h, (Object[])this.deserialize(is));
        }
        if (oCls.equals(long[].class)) {
            return new Long2ObjectOpenHashMap((long[])h, (Object[])this.deserialize(is));
        }
        if (oCls.equals(char[].class)) {
            return new Char2ObjectOpenHashMap((char[])h, (Object[])this.deserialize(is));
        }
        throw new EOFException();
    }

    protected byte[] serialize(Object obj) throws IOException {
        DataInputOutput ba = new DataInputOutput();
        this.serialize(ba, obj);
        return ba.toByteArray();
    }

    protected void serialize(DataOutput out, Object obj) throws IOException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = obj != null ? obj.getClass() : null;
        if (obj == null) {
            out.write(0);
        } else if (clazz == Boolean.class) {
            if (((Boolean)obj).booleanValue()) {
                out.write(2);
            } else {
                out.write(3);
            }
        } else if (clazz == Integer.class) {
            int val = (Integer)obj;
            this.writeInteger(out, val);
        } else if (clazz == Double.class) {
            double v = (Double)obj;
            if (v == -1.0) {
                out.write(47);
            } else if (v == 0.0) {
                out.write(48);
            } else if (v == 1.0) {
                out.write(49);
            } else if (v >= 0.0 && v <= 255.0 && (double)((int)v) == v) {
                out.write(50);
                out.write((int)v);
            } else if (v >= -32768.0 && v <= 32767.0 && (double)((short)v) == v) {
                out.write(51);
                out.writeShort((int)v);
            } else {
                out.write(52);
                out.writeDouble(v);
            }
        } else if (clazz == Float.class) {
            float v = ((Float)obj).floatValue();
            if (v == -1.0f) {
                out.write(41);
            } else if (v == 0.0f) {
                out.write(42);
            } else if (v == 1.0f) {
                out.write(43);
            } else if (v >= 0.0f && v <= 255.0f && (float)((int)v) == v) {
                out.write(44);
                out.write((int)v);
            } else if (v >= -32768.0f && v <= 32767.0f && (float)((short)v) == v) {
                out.write(45);
                out.writeShort((int)v);
            } else {
                out.write(46);
                out.writeFloat(v);
            }
        } else if (clazz == Long.class) {
            long val = (Long)obj;
            this.writeLong(out, val);
        } else if (clazz == BigInteger.class) {
            out.write(55);
            byte[] buf = ((BigInteger)obj).toByteArray();
            this.serializeByteArrayInt(out, buf);
        } else if (clazz == BigDecimal.class) {
            out.write(54);
            BigDecimal d = (BigDecimal)obj;
            this.serializeByteArrayInt(out, d.unscaledValue().toByteArray());
            LongPacker.packInt(out, d.scale());
        } else if (clazz == Short.class) {
            short val = (Short)obj;
            if (val == -1) {
                out.write(31);
            } else if (val == 0) {
                out.write(32);
            } else if (val == 1) {
                out.write(33);
            } else if (val > 0 && val < 255) {
                out.write(34);
                out.write(val);
            } else {
                out.write(35);
                out.writeShort(val);
            }
        } else if (clazz == Byte.class) {
            byte val = (Byte)obj;
            if (val == -1) {
                out.write(36);
            } else if (val == 0) {
                out.write(37);
            } else if (val == 1) {
                out.write(38);
            } else {
                out.write(39);
                out.writeByte(val);
            }
        } else if (clazz == Character.class) {
            out.write(40);
            out.writeChar(((Character)obj).charValue());
        } else if (clazz == String.class) {
            String s = (String)obj;
            if (s.length() == 0) {
                out.write(101);
            } else {
                out.write(103);
                Serialization.serializeString(out, s);
            }
        } else if (obj instanceof Class) {
            out.write(126);
            this.serialize(out, ((Class)obj).getName());
        } else if (obj instanceof int[]) {
            this.writeIntArray(out, (int[])obj);
        } else if (obj instanceof long[]) {
            this.writeLongArray(out, (long[])obj);
        } else if (obj instanceof short[]) {
            out.write(58);
            short[] a = (short[])obj;
            LongPacker.packInt(out, a.length);
            for (short s : a) {
                out.writeShort(s);
            }
        } else if (obj instanceof boolean[]) {
            out.write(59);
            boolean[] a = (boolean[])obj;
            LongPacker.packInt(out, a.length);
            for (boolean s : a) {
                out.writeBoolean(s);
            }
        } else if (obj instanceof double[]) {
            out.write(53);
            double[] a = (double[])obj;
            LongPacker.packInt(out, a.length);
            for (double s : a) {
                out.writeDouble(s);
            }
        } else if (obj instanceof float[]) {
            out.write(56);
            float[] a = (float[])obj;
            LongPacker.packInt(out, a.length);
            for (float s : a) {
                out.writeFloat(s);
            }
        } else if (obj instanceof char[]) {
            out.write(70);
            char[] a = (char[])obj;
            LongPacker.packInt(out, a.length);
            for (char s : a) {
                out.writeChar(s);
            }
        } else if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            out.write(71);
            this.serializeByteArrayInt(out, b);
        } else if (clazz == Date.class) {
            out.write(127);
            out.writeLong(((Date)obj).getTime());
        } else if (clazz == Locale.class) {
            out.write(124);
            Locale l = (Locale)obj;
            out.writeUTF(l.getLanguage());
            out.writeUTF(l.getCountry());
            out.writeUTF(l.getVariant());
        } else if (obj instanceof String[]) {
            String[] b = (String[])obj;
            out.write(74);
            LongPacker.packInt(out, b.length);
            for (String s : b) {
                Serialization.serializeString(out, s);
            }
        } else if (obj instanceof Object[]) {
            Object[] b = (Object[])obj;
            out.write(73);
            LongPacker.packInt(out, b.length);
            for (Object o : b) {
                this.serialize(out, o);
            }
        } else if (obj instanceof TimestampSet) {
            TimestampSet b = (TimestampSet)obj;
            out.write(223);
            this.serializeTimestampSet(out, b);
        } else if (obj instanceof IntervalSet) {
            IntervalSet b = (IntervalSet)obj;
            out.write(224);
            this.serializeIntervalSet(out, b);
        } else if (obj instanceof NodeImpl) {
            NodeImpl b = (NodeImpl)obj;
            out.write(200);
            this.serializeNode(out, b);
        } else if (obj instanceof EdgeImpl) {
            EdgeImpl b = (EdgeImpl)obj;
            out.write(201);
            this.serializeEdge(out, b);
        } else if (obj instanceof EdgeTypeStore) {
            EdgeTypeStore b = (EdgeTypeStore)obj;
            out.write(202);
            this.serializeEdgeTypeStore(out);
        } else if (obj instanceof Origin) {
            Origin b = (Origin)((Object)obj);
            out.write(203);
            this.serialize(out, b.name());
        } else if (obj instanceof TableImpl) {
            TableImpl b = (TableImpl)obj;
            out.write(204);
            this.serializeTable(out, b);
        } else if (obj instanceof GraphStore) {
            GraphStore b = (GraphStore)obj;
            out.write(206);
            this.serializeGraphStore(out, b);
        } else if (obj instanceof GraphFactoryImpl) {
            GraphFactoryImpl b = (GraphFactoryImpl)obj;
            out.write(207);
            this.serializeGraphFactory(out);
        } else if (obj instanceof GraphViewStore) {
            GraphViewStore b = (GraphViewStore)obj;
            out.write(208);
            this.serializeViewStore(out);
        } else if (obj instanceof GraphViewImpl) {
            GraphViewImpl b = (GraphViewImpl)obj;
            out.write(209);
            this.serializeGraphView(out, b);
        } else if (obj instanceof BitVector) {
            BitVector bv = (BitVector)obj;
            out.write(210);
            this.serializeBitVector(out, bv);
        } else if (obj instanceof GraphVersion) {
            GraphVersion b = (GraphVersion)obj;
            out.write(213);
            this.serializeGraphVersion(out, b);
        } else if (obj instanceof NodeImpl.NodePropertiesImpl) {
            NodeImpl.NodePropertiesImpl b = (NodeImpl.NodePropertiesImpl)obj;
            out.write(214);
            this.serializeNodeProperties(out, b);
        } else if (obj instanceof EdgeImpl.EdgePropertiesImpl) {
            EdgeImpl.EdgePropertiesImpl b = (EdgeImpl.EdgePropertiesImpl)obj;
            out.write(215);
            this.serializeEdgeProperties(out, b);
        } else if (obj instanceof TextPropertiesImpl) {
            TextPropertiesImpl b = (TextPropertiesImpl)obj;
            out.write(216);
            this.serializeTextProperties(out, b);
        } else if (obj instanceof Estimator) {
            Estimator b = (Estimator)((Object)obj);
            out.write(217);
            Serialization.serializeString(out, b.name());
        } else if (obj instanceof TimeRepresentation) {
            TimeRepresentation b = (TimeRepresentation)((Object)obj);
            out.write(212);
            Serialization.serializeString(out, b.name());
        } else if (obj instanceof TimestampMap) {
            TimestampMap b = (TimestampMap)obj;
            out.write(225);
            this.serializeTimestampMap(out, b);
        } else if (obj instanceof IntervalMap) {
            IntervalMap b = (IntervalMap)obj;
            out.write(226);
            this.serializeIntervalMap(out, b);
        } else if (obj instanceof TimestampIndexStore) {
            TimestampIndexStore b = (TimestampIndexStore)obj;
            out.write(219);
            this.serializeTimestampIndexStore(out, b);
        } else if (obj instanceof IntervalIndexStore) {
            IntervalIndexStore b = (IntervalIndexStore)obj;
            out.write(220);
            this.serializeIntervalIndexStore(out, b);
        } else if (obj instanceof GraphAttributesImpl) {
            GraphAttributesImpl b = (GraphAttributesImpl)obj;
            out.write(218);
            this.serializeGraphAttributes(out, b);
        } else if (obj instanceof TimeFormat) {
            TimeFormat b = (TimeFormat)((Object)obj);
            out.write(221);
            this.serializeTimeFormat(out, b);
        } else if (obj instanceof DateTimeZone) {
            DateTimeZone b = (DateTimeZone)obj;
            out.write(227);
            this.serializeTimeZone(out, b);
        } else if (obj instanceof TimeStore) {
            TimeStore b = (TimeStore)obj;
            out.write(222);
            this.serializeTimeStore(out);
        } else if (obj instanceof Configuration) {
            Configuration b = (Configuration)obj;
            out.write(205);
            this.serializeConfiguration(out);
        } else if (obj instanceof Interval) {
            Interval b = (Interval)obj;
            out.write(228);
            this.serializeInterval(out, b);
        } else if (obj instanceof List) {
            List b = (List)obj;
            out.write(229);
            this.serializeList(out, b);
        } else if (obj instanceof Set) {
            Set b = (Set)obj;
            out.write(230);
            this.serializeSet(out, b);
        } else if (obj instanceof Map) {
            Map b = (Map)obj;
            out.write(231);
            this.serializeMap(out, b);
        } else {
            throw new IOException("No serialization handler for this class: " + clazz.getName());
        }
    }

    public static void serializeString(DataOutput out, String obj) throws IOException {
        int len = obj.length();
        LongPacker.packInt(out, len);
        for (int i = 0; i < len; ++i) {
            char c = obj.charAt(i);
            LongPacker.packInt(out, c);
        }
    }

    private void serializeByteArrayInt(DataOutput out, byte[] b) throws IOException {
        LongPacker.packInt(out, b.length);
        out.write(b);
    }

    private void writeLongArray(DataOutput da, long[] obj) throws IOException {
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (long i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        if (0L <= min && max <= 255L) {
            da.write(65);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.write((int)l);
            }
        } else if (0L <= min && max <= Long.MAX_VALUE) {
            da.write(69);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                LongPacker.packLong(da, l);
            }
        } else if (-32768L <= min && max <= 32767L) {
            da.write(66);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeShort((short)l);
            }
        } else if (Integer.MIN_VALUE <= min && max <= Integer.MAX_VALUE) {
            da.write(67);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeInt((int)l);
            }
        } else {
            da.write(68);
            LongPacker.packInt(da, obj.length);
            for (long l : obj) {
                da.writeLong(l);
            }
        }
    }

    private void writeIntArray(DataOutput da, int[] obj) throws IOException {
        boolean fitsInShort;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i : obj) {
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        boolean fitsInByte = 0 <= min && max <= 255;
        boolean bl = fitsInShort = min >= Short.MIN_VALUE && max <= Short.MAX_VALUE;
        if (obj.length <= 255 && fitsInByte) {
            da.write(60);
            da.write(obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (fitsInByte) {
            da.write(61);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.write(i);
            }
        } else if (0 <= min && max <= Integer.MAX_VALUE) {
            da.write(64);
            LongPacker.packInt(da, obj.length);
            for (int l : obj) {
                LongPacker.packInt(da, l);
            }
        } else if (fitsInShort) {
            da.write(62);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.writeShort(i);
            }
        } else {
            da.write(63);
            LongPacker.packInt(da, obj.length);
            for (int i : obj) {
                da.writeInt(i);
            }
        }
    }

    private void writeInteger(DataOutput da, int val) throws IOException {
        if (val == -1) {
            da.write(4);
        } else if (val == 0) {
            da.write(5);
        } else if (val == 1) {
            da.write(6);
        } else if (val == 2) {
            da.write(7);
        } else if (val == 3) {
            da.write(8);
        } else if (val == 4) {
            da.write(9);
        } else if (val == 5) {
            da.write(10);
        } else if (val == 6) {
            da.write(11);
        } else if (val == 7) {
            da.write(12);
        } else if (val == 8) {
            da.write(13);
        } else if (val == Integer.MIN_VALUE) {
            da.write(57);
        } else if (val > 0 && val < 255) {
            da.write(14);
            da.write(val);
        } else if (val < 0) {
            da.write(15);
            LongPacker.packInt(da, -val);
        } else {
            da.write(16);
            LongPacker.packInt(da, val);
        }
    }

    private void writeLong(DataOutput da, long val) throws IOException {
        if (val == -1L) {
            da.write(17);
        } else if (val == 0L) {
            da.write(18);
        } else if (val == 1L) {
            da.write(19);
        } else if (val == 2L) {
            da.write(20);
        } else if (val == 3L) {
            da.write(21);
        } else if (val == 4L) {
            da.write(22);
        } else if (val == 5L) {
            da.write(23);
        } else if (val == 6L) {
            da.write(24);
        } else if (val == 7L) {
            da.write(25);
        } else if (val == 8L) {
            da.write(26);
        } else if (val == Long.MIN_VALUE) {
            da.write(30);
        } else if (val > 0L && val < 255L) {
            da.write(29);
            da.write((int)val);
        } else if (val < 0L) {
            da.write(27);
            LongPacker.packLong(da, -val);
        } else {
            da.write(28);
            LongPacker.packLong(da, val);
        }
    }

    protected Object deserialize(byte[] buf) throws ClassNotFoundException, IOException {
        DataInputOutput bs = new DataInputOutput(buf);
        Object ret = this.deserialize(bs);
        if (bs.available() != 0) {
            throw new RuntimeException("bytes left: " + bs.available());
        }
        return ret;
    }

    protected Object deserialize(DataInput is) throws IOException, ClassNotFoundException {
        Object ret = null;
        int head = is.readUnsignedByte();
        switch (head) {
            case 0: {
                break;
            }
            case 2: {
                ret = Boolean.TRUE;
                break;
            }
            case 3: {
                ret = Boolean.FALSE;
                break;
            }
            case 4: {
                ret = -1;
                break;
            }
            case 5: {
                ret = 0;
                break;
            }
            case 6: {
                ret = 1;
                break;
            }
            case 7: {
                ret = 2;
                break;
            }
            case 8: {
                ret = 3;
                break;
            }
            case 9: {
                ret = 4;
                break;
            }
            case 10: {
                ret = 5;
                break;
            }
            case 11: {
                ret = 6;
                break;
            }
            case 12: {
                ret = 7;
                break;
            }
            case 13: {
                ret = 8;
                break;
            }
            case 57: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 14: {
                ret = is.readUnsignedByte();
                break;
            }
            case 15: {
                ret = -LongPacker.unpackInt(is);
                break;
            }
            case 16: {
                ret = LongPacker.unpackInt(is);
                break;
            }
            case 17: {
                ret = -1L;
                break;
            }
            case 18: {
                ret = 0L;
                break;
            }
            case 19: {
                ret = 1L;
                break;
            }
            case 20: {
                ret = 2L;
                break;
            }
            case 21: {
                ret = 3L;
                break;
            }
            case 22: {
                ret = 4L;
                break;
            }
            case 23: {
                ret = 5L;
                break;
            }
            case 24: {
                ret = 6L;
                break;
            }
            case 25: {
                ret = 7L;
                break;
            }
            case 26: {
                ret = 8L;
                break;
            }
            case 29: {
                ret = Long.valueOf(is.readUnsignedByte());
                break;
            }
            case 27: {
                ret = -LongPacker.unpackLong(is);
                break;
            }
            case 28: {
                ret = LongPacker.unpackLong(is);
                break;
            }
            case 30: {
                ret = Long.MIN_VALUE;
                break;
            }
            case 31: {
                ret = (short)-1;
                break;
            }
            case 32: {
                ret = (short)0;
                break;
            }
            case 33: {
                ret = (short)1;
                break;
            }
            case 34: {
                ret = (short)is.readUnsignedByte();
                break;
            }
            case 35: {
                ret = is.readShort();
                break;
            }
            case 36: {
                ret = (byte)-1;
                break;
            }
            case 37: {
                ret = (byte)0;
                break;
            }
            case 38: {
                ret = (byte)1;
                break;
            }
            case 39: {
                ret = is.readByte();
                break;
            }
            case 58: {
                int size = LongPacker.unpackInt(is);
                ret = new short[size];
                for (int i = 0; i < size; ++i) {
                    ((short[])ret)[i] = is.readShort();
                }
                break;
            }
            case 59: {
                int size = LongPacker.unpackInt(is);
                ret = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    ((boolean[])ret)[i] = is.readBoolean();
                }
                break;
            }
            case 53: {
                int size = LongPacker.unpackInt(is);
                ret = new double[size];
                for (int i = 0; i < size; ++i) {
                    ((double[])ret)[i] = is.readDouble();
                }
                break;
            }
            case 56: {
                int size = LongPacker.unpackInt(is);
                ret = new float[size];
                for (int i = 0; i < size; ++i) {
                    ((float[])ret)[i] = is.readFloat();
                }
                break;
            }
            case 70: {
                int size = LongPacker.unpackInt(is);
                ret = new char[size];
                for (int i = 0; i < size; ++i) {
                    ((char[])ret)[i] = is.readChar();
                }
                break;
            }
            case 40: {
                ret = Character.valueOf(is.readChar());
                break;
            }
            case 41: {
                ret = Float.valueOf(-1.0f);
                break;
            }
            case 42: {
                ret = Float.valueOf(0.0f);
                break;
            }
            case 43: {
                ret = Float.valueOf(1.0f);
                break;
            }
            case 44: {
                ret = Float.valueOf(is.readUnsignedByte());
                break;
            }
            case 45: {
                ret = Float.valueOf(is.readShort());
                break;
            }
            case 46: {
                ret = Float.valueOf(is.readFloat());
                break;
            }
            case 47: {
                ret = -1.0;
                break;
            }
            case 48: {
                ret = 0.0;
                break;
            }
            case 49: {
                ret = 1.0;
                break;
            }
            case 50: {
                ret = Double.valueOf(is.readUnsignedByte());
                break;
            }
            case 51: {
                ret = Double.valueOf(is.readShort());
                break;
            }
            case 52: {
                ret = is.readDouble();
                break;
            }
            case 55: {
                ret = new BigInteger(this.deserializeArrayByteInt(is));
                break;
            }
            case 54: {
                ret = new BigDecimal(new BigInteger(this.deserializeArrayByteInt(is)), LongPacker.unpackInt(is));
                break;
            }
            case 103: {
                ret = Serialization.deserializeString(is);
                break;
            }
            case 101: {
                ret = EMPTY_STRING;
                break;
            }
            case 126: {
                ret = this.deserializeClass(is);
                break;
            }
            case 127: {
                ret = new Date(is.readLong());
                break;
            }
            case 60: {
                ret = this.deserializeArrayIntB255(is);
                break;
            }
            case 61: {
                ret = this.deserializeArrayIntBInt(is);
                break;
            }
            case 62: {
                ret = this.deserializeArrayIntSInt(is);
                break;
            }
            case 63: {
                ret = this.deserializeArrayIntIInt(is);
                break;
            }
            case 64: {
                ret = this.deserializeArrayIntPack(is);
                break;
            }
            case 65: {
                ret = this.deserializeArrayLongB(is);
                break;
            }
            case 66: {
                ret = this.deserializeArrayLongS(is);
                break;
            }
            case 67: {
                ret = this.deserializeArrayLongI(is);
                break;
            }
            case 68: {
                ret = this.deserializeArrayLongL(is);
                break;
            }
            case 69: {
                ret = this.deserializeArrayLongPack(is);
                break;
            }
            case 71: {
                ret = this.deserializeArrayByteInt(is);
                break;
            }
            case 124: {
                ret = new Locale(is.readUTF(), is.readUTF(), is.readUTF());
                break;
            }
            case 74: {
                ret = this.deserializeStringArray(is);
                break;
            }
            case 73: {
                ret = this.deserializeArrayObject(is);
                break;
            }
            case 223: {
                ret = this.deserializeTimestampSet(is);
                break;
            }
            case 224: {
                ret = this.deserializeIntervalSet(is);
                break;
            }
            case 200: {
                ret = this.deserializeNode(is);
                break;
            }
            case 201: {
                ret = this.deserializeEdge(is);
                break;
            }
            case 202: {
                ret = this.deserializeEdgeTypeStore(is);
                break;
            }
            case 203: {
                ret = Origin.valueOf((String)this.deserialize(is));
                break;
            }
            case 204: {
                ret = this.deserializeTable(is);
                break;
            }
            case 206: {
                ret = this.deserializeGraphStore(is);
                break;
            }
            case 207: {
                ret = this.deserializeGraphFactory(is);
                break;
            }
            case 208: {
                ret = this.deserializeViewStore(is);
                break;
            }
            case 209: {
                ret = this.deserializeGraphView(is);
                break;
            }
            case 210: {
                ret = this.deserializeBitVector(is);
                break;
            }
            case 211: {
                ret = this.deserializeGraphStoreConfiguration(is);
                break;
            }
            case 213: {
                ret = this.deserializeGraphVersion(is);
                break;
            }
            case 214: {
                ret = this.deserializeNodeProperties(is);
                break;
            }
            case 215: {
                ret = this.deserializeEdgeProperties(is);
                break;
            }
            case 216: {
                ret = this.deserializeTextProperties(is);
                break;
            }
            case 217: {
                ret = Estimator.valueOf(Serialization.deserializeString(is));
                break;
            }
            case 212: {
                ret = TimeRepresentation.valueOf(Serialization.deserializeString(is));
                break;
            }
            case 225: {
                ret = this.deserializeTimestampMap(is);
                break;
            }
            case 226: {
                ret = this.deserializeIntervalMap(is);
                break;
            }
            case 219: {
                ret = this.deserializeTimestampIndexStore(is);
                break;
            }
            case 220: {
                ret = this.deserializeIntervalIndexStore(is);
                break;
            }
            case 218: {
                ret = this.deserializeGraphAttributes(is);
                break;
            }
            case 221: {
                ret = this.deserializeTimeFormat(is);
                break;
            }
            case 227: {
                ret = this.deserializeTimeZone(is);
                break;
            }
            case 222: {
                ret = this.deserializeTimeStore(is);
                break;
            }
            case 205: {
                ret = this.deserializeConfiguration(is);
                break;
            }
            case 228: {
                ret = this.deserializeInterval(is);
                break;
            }
            case 229: {
                ret = this.deserializeList(is);
                break;
            }
            case 230: {
                ret = this.deserializeSet(is);
                break;
            }
            case 231: {
                ret = this.deserializeMap(is);
                break;
            }
            case -1: {
                throw new EOFException();
            }
        }
        return ret;
    }

    public static String deserializeString(DataInput buf) throws IOException {
        int len = LongPacker.unpackInt(buf);
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (char)LongPacker.unpackInt(buf);
        }
        return new String(b);
    }

    private Class deserializeClass(DataInput is) throws IOException, ClassNotFoundException {
        String className = (String)this.deserialize(is);
        Class<?> cls = Class.forName(className);
        return cls;
    }

    private byte[] deserializeArrayByteInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        byte[] b = new byte[size];
        is.readFully(b);
        return b;
    }

    private long[] deserializeArrayLongL(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readLong();
        }
        return ret;
    }

    private long[] deserializeArrayLongI(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private long[] deserializeArrayLongS(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private long[] deserializeArrayLongB(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0L) continue;
            throw new EOFException();
        }
        return ret;
    }

    private int[] deserializeArrayIntIInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readInt();
        }
        return ret;
    }

    private int[] deserializeArrayIntSInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readShort();
        }
        return ret;
    }

    private int[] deserializeArrayIntBInt(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private int[] deserializeArrayIntPack(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = LongPacker.unpackInt(is);
        }
        return ret;
    }

    private long[] deserializeArrayLongPack(DataInput is) throws IOException {
        int size = LongPacker.unpackInt(is);
        if (size < 0) {
            throw new EOFException();
        }
        long[] ret = new long[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = LongPacker.unpackLong(is);
        }
        return ret;
    }

    private int[] deserializeArrayIntB255(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        if (size < 0) {
            throw new EOFException();
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = is.readUnsignedByte();
            if (ret[i] >= 0) continue;
            throw new EOFException();
        }
        return ret;
    }

    private String[] deserializeStringArray(DataInput is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        String[] s = (String[])Array.newInstance(String.class, size);
        for (int i = 0; i < size; ++i) {
            s[i] = Serialization.deserializeString(is);
        }
        return s;
    }

    private Object[] deserializeArrayObject(DataInput is) throws IOException, ClassNotFoundException {
        int size = LongPacker.unpackInt(is);
        Object[] s = (Object[])Array.newInstance(Object.class, size);
        for (int i = 0; i < size; ++i) {
            s[i] = this.deserialize(is);
        }
        return s;
    }

    protected static class GraphStoreConfigurationVersion {
        protected final boolean enableElementLabel;
        protected final boolean enableElementTimestamp;
        protected final boolean enableNodeProperties;
        protected final boolean enableEdgeProperties;

        public GraphStoreConfigurationVersion(boolean enableElementLabel, boolean enableElementTimestamp, boolean enableNodeProperties, boolean enableEdgeProperties) {
            this.enableElementLabel = enableElementLabel;
            this.enableElementTimestamp = enableElementTimestamp;
            this.enableNodeProperties = enableNodeProperties;
            this.enableEdgeProperties = enableEdgeProperties;
        }
    }
}

