/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.logging;

import grails.compiler.ast.AllArtefactClassInjector;
import grails.compiler.ast.AstTransformer;
import groovy.lang.GroovyClassLoader;
import groovy.util.logging.Slf4j;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.LogASTTransformation;

@AstTransformer
public class LoggingTransformer
implements AllArtefactClassInjector {
    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, classNode);
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, classNode);
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        AnnotationNode annotationNode2;
        if (classNode.getNodeMetaData(Slf4j.class) != null) {
            return;
        }
        String packageName = Slf4j.class.getPackage().getName();
        for (AnnotationNode annotationNode2 : classNode.getAnnotations()) {
            if (!annotationNode2.getClassNode().getPackageName().equals(packageName)) continue;
            return;
        }
        FieldNode logField = classNode.getField("log");
        if (logField != null && !Modifier.isPrivate(logField.getModifiers())) {
            return;
        }
        annotationNode2 = new AnnotationNode(ClassHelper.make(Slf4j.class));
        LogASTTransformation logASTTransformation = new LogASTTransformation();
        logASTTransformation.setCompilationUnit(new CompilationUnit(new GroovyClassLoader(this.getClass().getClassLoader())));
        logASTTransformation.visit(new ASTNode[]{annotationNode2, classNode}, source);
        classNode.putNodeMetaData(Slf4j.class, (Object)annotationNode2);
    }

    public boolean shouldInject(URL url) {
        return true;
    }
}

