/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BC;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.readers.pymol.PickleReader;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLScene;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.PymolAtomReader;
import org.jmol.c.STR;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;

public class PyMOLReader
extends PdbReader
implements PymolAtomReader {
    private static final int MIN_RESNO = -1000;
    private static String nucleic = " A C G T U ADE THY CYT GUA URI DA DC DG DT DU ";
    private boolean allowSurface = true;
    private boolean doResize;
    private boolean doCache;
    private boolean isStateScript;
    private boolean sourcePNGJ;
    private int ac0;
    private int ac;
    private int stateCount;
    private int structureCount;
    private boolean isHidden;
    private BS bsStructureDefined = new BS();
    private BS bsBytesExcluded;
    private int[] atomMap;
    private Map<String, BS> ssMapSeq;
    private PyMOLScene pymolScene;
    private P3 xyzMin = P3.new3(1000000.0f, 1000000.0f, 1000000.0f);
    private P3 xyzMax = P3.new3(-1000000.0f, -1000000.0f, -1000000.0f);
    private int nModels;
    private boolean logging;
    private BS[] reps = new BS[23];
    private boolean isMovie;
    private int pymolFrame;
    private boolean allStates;
    private int totalAtomCount;
    private int pymolVersion;
    private P3[] trajectoryStep;
    private int trajectoryPtr;
    private String objectName;
    private Map<String, Lst<Object>> volumeData;
    private Lst<Lst<Object>> mapObjects;
    private boolean haveMeasurements;
    private int[] frames;
    private Hashtable<Integer, Lst<Object>> uniqueSettings;
    private Atom[] atoms;
    private boolean haveScenes;
    private int baseModelIndex;
    private Lst<Object> sceneOrder;
    private int bondCount;
    private boolean haveBinaryArrays = true;
    private final P3 ptTemp = new P3();
    byte[] aTemp = new byte[16];

    @Override
    protected void setup(String string, Map<String, Object> map, Object object) {
        this.mustFinalizeModelSet = true;
        this.isBinary = true;
        this.setupASCR(string, map, object);
    }

    @Override
    protected void initializeReader() throws Exception {
        this.baseAtomIndex = (Integer)this.htParams.get("baseAtomIndex");
        this.baseModelIndex = (Integer)this.htParams.get("baseModelIndex");
        this.asc.setInfo("noAutoBond", Boolean.TRUE);
        this.asc.setCurrentModelInfo("pdbNoHydrogens", Boolean.TRUE);
        this.asc.setInfo("isPyMOL", Boolean.TRUE);
        if (this.isTrajectory) {
            this.trajectorySteps = new Lst();
        }
        this.isStateScript = this.htParams.containsKey("isStateScript");
        this.sourcePNGJ = this.htParams.containsKey("sourcePNGJ");
        this.doResize = this.checkFilterKey("DORESIZE");
        this.allowSurface = !this.checkFilterKey("NOSURFACE");
        this.doCache = this.checkFilterKey("DOCACHE");
        if (this.doCache && this.sourcePNGJ) {
            this.doCache = false;
        } else if (this.sourcePNGJ && !this.doCache) {
            this.sourcePNGJ = false;
        }
        if (this.doCache) {
            this.bsBytesExcluded = new BS();
        }
        super.initializeReader();
    }

    @Override
    public void processBinaryDocument() throws Exception {
        String string = this.vwr.getLogFileName();
        this.logging = string.length() > 0;
        Logger.info(this.logging ? "PyMOL (1) file data streaming to " + string : "To view raw PyMOL file data, use 'set logFile \"some_filename\" ");
        PickleReader pickleReader = new PickleReader(this.binaryDoc, this.vwr);
        Map<String, Object> map = pickleReader.getMap(this.logging && Logger.debuggingHigh);
        pickleReader = null;
        this.process(map);
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderPDB();
        this.asc.setTensors();
    }

    @Override
    public void finalizeModelSet() {
        this.pymolScene.setReaderObjects();
        if (this.haveMeasurements) {
            this.appendLoadNote(this.vwr.getMeasurementInfoAsString());
            this.setLoadNote();
        }
        if (this.haveScenes) {
            String[] stringArray = new String[this.sceneOrder.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = PyMOLReader.stringAt(this.sceneOrder, n);
            }
            this.vwr.ms.msInfo.put("scenes", stringArray);
        }
        this.vwr.ms.setTrajectoryBs(BSUtil.newBitSet2(this.baseModelIndex, this.vwr.ms.mc));
        if (!this.isStateScript) {
            this.pymolScene.setFrameObject(0, null);
        }
        if (this.bsBytesExcluded != null) {
            int n = this.bsBytesExcluded.cardinality();
            byte[] byArray = (byte[])this.vwr.fm.getFileAsBytes(this.filePath, null);
            byte[] byArray2 = new byte[byArray.length - n];
            int n2 = this.bsBytesExcluded.nextClearBit(0);
            int n3 = byArray.length;
            int n4 = 0;
            while (n2 < n3) {
                byArray2[n4++] = byArray[n2];
                n2 = this.bsBytesExcluded.nextClearBit(n2 + 1);
            }
            byArray = null;
            String string = this.filePath;
            this.vwr.cachePut(string, byArray2);
        }
    }

    private void process(Map<String, Object> map) {
        int n;
        Lst<Object> lst;
        Object object;
        String string;
        this.pymolVersion = (Integer)map.get("version");
        this.appendLoadNote("PyMOL version: " + this.pymolVersion);
        Lst<Object> lst2 = this.fixSettings(PyMOLReader.getMapList(map, "settings"));
        Lst<Object> lst3 = PyMOLReader.listAt(lst2, 749);
        this.haveBinaryArrays = lst3 != null && PyMOLReader.floatAt(lst3, 2) == 1.0f;
        this.sceneOrder = PyMOLReader.getMapList(map, "scene_order");
        this.haveScenes = this.getFrameScenes(map);
        Lst<Object> lst4 = PyMOLReader.listAt(lst2, 440);
        if (lst4 != null && lst4.size() > 2) {
            Logger.info("PyMOL session file: " + lst4.get(2));
        }
        this.setUniqueSettings(PyMOLReader.getMapList(map, "unique_settings"));
        this.pymolScene = new PyMOLScene(this, this.vwr, lst2, this.uniqueSettings, this.pymolVersion, this.haveScenes, this.baseAtomIndex, this.baseModelIndex, this.doCache, this.filePath);
        String string2 = this.vwr.getLogFileName();
        this.logging = string2.length() > 0;
        Logger.info(this.logging ? "PyMOL file data streaming to " + string2 : "To view raw PyMOL file data, use 'set logFile \"some_filename\" ");
        Lst<Object> lst5 = PyMOLReader.getMapList(map, "names");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            Logger.info(string);
            if (!string.equals("names")) continue;
            int n2 = 1;
            while (n2 < lst5.size()) {
                object = PyMOLReader.listAt(lst5, n2);
                Logger.info("  " + PyMOLReader.stringAt(object, 0));
                ++n2;
            }
        }
        if (this.logging) {
            if (this.logging) {
                this.vwr.log("$CLEAR$");
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                string = entry.getKey();
                if ("names".equals(string)) continue;
                this.vwr.log("\n===" + string + "===");
                this.vwr.log(PT.rep(entry.getValue().toString(), "[", "\n["));
            }
            this.vwr.log("\n===names===");
            int n3 = 1;
            while (n3 < lst5.size()) {
                this.vwr.log("");
                Lst lst6 = (Lst)lst5.get(n3);
                this.vwr.log(" =" + PyMOLReader.bytesToString(lst6.get(0)) + "=");
                try {
                    this.vwr.log(PT.rep(lst6.toString(), "[", "\n["));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n3;
            }
        }
        this.addColors(PyMOLReader.getMapList(map, "colors"), this.pymolScene.globalSetting(214) != 0.0f);
        this.allStates = this.pymolScene.globalSetting(49) != 0.0f;
        this.pymolFrame = (int)this.pymolScene.globalSetting(194);
        this.getAtomAndStateCount(lst5);
        this.pymolScene.setStateCount(this.stateCount);
        int n4 = (int)this.pymolScene.globalSetting(193);
        if (!this.isMovie) {
            this.pymolScene.setFrameObject(4115, this.allStates ? Integer.valueOf(-1) : Integer.valueOf(n4 - 1));
        }
        this.appendLoadNote("frame=" + this.pymolFrame + " state=" + n4 + " all_states=" + this.allStates);
        if (!this.isStateScript && this.doResize) {
            int n5 = 0;
            int n6 = 0;
            Lst<Object> lst7 = PyMOLReader.getMapList(map, "main");
            if (lst7 != null) {
                n5 = PyMOLReader.intAt(lst7, 0);
                n6 = PyMOLReader.intAt(lst7, 1);
            }
            if (n5 > 0 && n6 > 0) {
                object = "PyMOL dimensions width=" + n5 + " height=" + n6;
                this.asc.setInfo("preferredWidthHeight", new int[]{n5, n6});
                this.vwr.resizeInnerPanel(n5, n6);
            } else {
                object = "PyMOL dimensions?";
            }
            this.appendLoadNote((String)object);
        }
        if (!this.isStateScript && !this.allStates && (lst = PyMOLReader.getMapList(map, "movie")) != null && (n = PyMOLReader.intAt(lst, 0)) > 0) {
            this.processMovie(lst, n);
        }
        if (this.totalAtomCount == 0) {
            this.asc.newAtomSet();
        }
        if (!this.allStates || this.desiredModelNumber != Integer.MIN_VALUE) {
            if (this.isMovie) {
                switch (this.desiredModelNumber) {
                    case -2147483648: {
                        break;
                    }
                    default: {
                        this.desiredModelNumber = this.frames[(this.desiredModelNumber > 0 && this.desiredModelNumber <= this.frames.length ? this.desiredModelNumber : this.pymolFrame) - 1];
                        this.pymolScene.setFrameObject(4115, this.desiredModelNumber - 1);
                        break;
                    }
                }
            } else if (this.desiredModelNumber == 0) {
                this.desiredModelNumber = n4;
            }
        }
        int n7 = lst5.size();
        int n8 = 0;
        while (n8 < this.stateCount) {
            if (this.doGetModel(++this.nModels, null)) {
                this.model(this.nModels);
                this.pymolScene.currentAtomSetIndex = this.asc.iSet;
                if (this.isTrajectory) {
                    this.trajectoryStep = new P3[this.totalAtomCount];
                    this.trajectorySteps.addLast(this.trajectoryStep);
                    this.trajectoryPtr = 0;
                }
                int n9 = 1;
                while (n9 < n7) {
                    this.processObject(PyMOLReader.listAt(lst5, n9), true, n8);
                    ++n9;
                }
            }
            ++n8;
        }
        n8 = 1;
        while (n8 < n7) {
            this.processObject(PyMOLReader.listAt(lst5, n8), false, 0);
            ++n8;
        }
        this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
        if (this.mapObjects != null && this.allowSurface) {
            this.processMeshes();
        }
        if (this.isTrajectory) {
            this.appendLoadNote("PyMOL trajectories read: " + this.trajectorySteps.size());
            this.asc.finalizeTrajectoryAs(this.trajectorySteps, null);
        }
        this.processDefinitions();
        this.processSelectionsAndScenes(map);
        this.pymolScene.finalizeVisibility();
        if (!this.isStateScript) {
            this.vwr.initialize(false, true);
            this.addJmolScript(this.pymolScene.getViewScript(PyMOLReader.getMapList(map, "view")).toString());
        }
        if (this.ac == 0) {
            this.asc.setInfo("dataOnly", Boolean.TRUE);
        }
        this.pymolScene.offsetObjects();
    }

    /*
     * Unable to fully structure code
     */
    private Lst<Object> fixSettings(Lst<Object> var1_1) {
        var2_2 = var1_1.size();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            block2: {
                var4_4 = PyMOLReader.intAt((Lst)var1_1.get(var3_3), 0);
                if (var4_4 != -1) ** GOTO lbl13
                Logger.info("PyMOL reader adding null setting #" + var3_3);
                var1_1.set(var3_3, new Lst<V>());
                break block2;
lbl-1000:
                // 1 sources

                {
                    Logger.info("PyMOL reader adding null setting #" + var3_3);
                    var1_1.add(var3_3++, new Lst<V>());
                    ++var2_2;
lbl13:
                    // 2 sources

                    ** while (var3_3 < var4_4)
                }
            }
            ++var3_3;
        }
        return var1_1;
    }

    private boolean getFrameScenes(Map<String, Object> map) {
        if (this.sceneOrder == null) {
            return false;
        }
        Map map2 = (Map)map.get("scene_dict");
        int n = 0;
        while (n < this.sceneOrder.size()) {
            String string = PyMOLReader.stringAt(this.sceneOrder, n);
            Lst<Object> lst = PyMOLReader.getMapList(map2, string);
            if (lst == null || lst.get(2) == null) {
                this.sceneOrder.removeItemAt(n--);
            }
            ++n;
        }
        return this.sceneOrder != null && this.sceneOrder.size() != 0;
    }

    private int setUniqueSettings(Lst<Object> lst) {
        this.uniqueSettings = new Hashtable();
        int n = 0;
        if (lst != null && lst.size() != 0) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                Lst lst2 = (Lst)lst.get(n2);
                int n3 = PyMOLReader.intAt(lst2, 0);
                if (n3 > n) {
                    n = n3;
                }
                Lst lst3 = (Lst)lst2.get(1);
                int n4 = lst3.size();
                while (--n4 >= 0) {
                    Lst lst4 = (Lst)lst3.get(n4);
                    int n5 = (n3 << 10) + PyMOLReader.intAt(lst4, 0);
                    this.uniqueSettings.put(n5, lst4);
                }
            }
        }
        return n;
    }

    private void addColors(Lst<Object> lst, boolean bl) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        int n = lst.size();
        while (--n >= 0) {
            Lst<Object> lst2 = PyMOLReader.listAt(lst, n);
            PyMOL.addColor((Integer)lst2.get(1), bl ? PyMOLReader.colorSettingClamped(lst2, this.ptTemp) : PyMOLReader.getColorPt(lst2.get(2), this.ptTemp));
        }
    }

    private void getAtomAndStateCount(Lst<Object> lst) {
        int n = 0;
        int n2 = 1;
        while (n2 < lst.size()) {
            Lst<Object> lst2 = PyMOLReader.listAt(lst, n2);
            int n3 = PyMOLReader.intAt(lst2, 4);
            if (this.checkObject(lst2) && n3 == 1) {
                int n4;
                int n5;
                Lst<Object> lst3 = PyMOLReader.listAt(lst2, 5);
                Lst<Object> lst4 = PyMOLReader.listAt(lst3, 4);
                int n6 = lst4.size();
                if (n6 > this.stateCount) {
                    this.stateCount = n6;
                }
                if (this.haveBinaryArrays) {
                    n5 = ((byte[])PyMOLReader.listAt(lst3, 6).get(1)).length / 20;
                    n4 = ((byte[])PyMOLReader.listAt(lst3, 7).get(1)).length / 120;
                    n += n4;
                } else {
                    n5 = PyMOLReader.listAt(lst3, 6).size();
                    n4 = PyMOLReader.listAt(lst3, 7).size();
                }
                System.out.println("Object " + this.objectName + " nBonds=" + n5 + ", nAtoms = " + n4);
                int n7 = 0;
                while (n7 < n6) {
                    Lst<Object> lst5 = PyMOLReader.listAt(lst4, n7);
                    Lst<Object> lst6 = PyMOLReader.listAt(lst5, 3);
                    if (lst6 == null) {
                        this.isTrajectory = false;
                    } else {
                        int n8 = lst6.size();
                        n += n8;
                        if (this.isTrajectory && n8 != n4) {
                            this.isTrajectory = false;
                        }
                    }
                    ++n7;
                }
            }
            ++n2;
        }
        this.totalAtomCount = n;
        Logger.info("PyMOL total atom count = " + this.totalAtomCount);
        Logger.info("PyMOL state count = " + this.stateCount);
    }

    private boolean checkObject(Lst<Object> lst) {
        this.objectName = PyMOLReader.stringAt(lst, 0);
        boolean bl = this.isHidden = PyMOLReader.intAt(lst, 2) != 1;
        return this.objectName.indexOf("_") != 0;
    }

    private void processMovie(Lst<Object> lst, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("frameCount", n);
        hashtable.put("currentFrame", this.pymolFrame - 1);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Lst<Object> lst2 = PyMOLReader.listAt(lst, 4);
        int n2 = lst2.size();
        while (--n2 >= 0) {
            if (PyMOLReader.intAt(lst2, n2) == 0) continue;
            this.frames = new int[lst2.size()];
            int n3 = this.frames.length;
            while (--n3 >= 0) {
                this.frames[n3] = PyMOLReader.intAt(lst2, n3) + 1;
            }
            hashtable.put("frames", this.frames);
            bl3 = true;
            break;
        }
        Lst<Object> lst3 = PyMOLReader.listAt(lst, 5);
        int n4 = lst3.size();
        while (--n4 >= 0) {
            String string = PyMOLReader.stringAt(lst3, n4);
            if (string == null || string.length() <= 1 || (lst3 = PyMOLReader.fixMovieCommands(lst3)) == null) continue;
            hashtable.put("commands", lst3);
            bl = true;
            break;
        }
        Lst<Object> lst4 = PyMOLReader.listAt(lst, 6);
        int n5 = lst4.size();
        while (--n5 >= 0) {
            Lst<Object> lst5 = PyMOLReader.listAt(lst4, n5);
            if (lst5 == null || lst5.size() < 12 || lst5.get(1) == null) continue;
            bl2 = true;
            if ((lst4 = PyMOLReader.fixMovieViews(lst4)) == null) continue;
            hashtable.put("views", lst4);
            break;
        }
        this.appendLoadNote("PyMOL movie frameCount = " + n);
        if (bl3 && !bl && !bl2) {
            this.isMovie = true;
            this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
            this.pymolScene.setFrameObject(1073742031, hashtable);
        }
    }

    private static Lst<Object> fixMovieViews(Lst<Object> lst) {
        return lst;
    }

    private static Lst<Object> fixMovieCommands(Lst<Object> lst) {
        return lst;
    }

    private void processObject(Lst<Object> lst, boolean bl, int n) {
        Cloneable cloneable;
        Object object;
        Lst<Object> lst2;
        if (lst == null) {
            return;
        }
        int n2 = PyMOLReader.intAt(lst, 4);
        Lst lst3 = (Lst)lst.get(lst.size() - 1);
        if (n2 == 1 != bl || !this.checkObject(lst)) {
            return;
        }
        Lst<Object> lst4 = PyMOLReader.listAt(lst, 5);
        Lst<Object> lst5 = null;
        if (n2 == 1) {
            lst2 = PyMOLReader.listAt(lst4, 4);
            object = PyMOLReader.listAt(lst2, n);
            cloneable = PyMOLReader.listAt(object, 3);
            if (n > 0 && (cloneable == null || cloneable.size() == 0)) {
                return;
            }
            lst5 = PyMOLReader.listAt(object, 7);
        } else if (n > 0) {
            return;
        }
        Logger.info("PyMOL model " + this.nModels + " Object " + this.objectName + (this.isHidden ? " (hidden)" : " (visible)"));
        if (!(this.isHidden || this.isMovie || this.allStates || this.pymolFrame <= 0 || this.pymolFrame == this.nModels)) {
            this.pymolFrame = this.nModels;
            this.allStates = true;
            this.pymolScene.setFrameObject(4115, -1);
        }
        lst2 = PyMOLReader.listAt(lst4, 0);
        Object object2 = object = lst.size() < 8 ? null : PyMOLReader.stringAt(lst, 6);
        if (" ".equals(object)) {
            object = null;
        }
        this.pymolScene.setReaderObjectInfo(this.objectName, n2, (String)object, this.isHidden, PyMOLReader.listAt(lst2, 8), lst5, bl ? "_" + (n + 1) : "");
        cloneable = null;
        boolean bl2 = this.bsBytesExcluded != null;
        String string = null;
        switch (n2) {
            default: {
                string = "" + n2;
                break;
            }
            case -1: {
                this.pymolScene.processSelection(lst);
                break;
            }
            case 1: {
                bl2 = false;
                cloneable = this.processMolecule(lst4, n);
                break;
            }
            case 4: {
                bl2 = false;
                this.processMeasure(lst4);
                break;
            }
            case 2: 
            case 3: {
                this.processMap(lst4, n2 == 3, false);
                break;
            }
            case 8: {
                this.processGadget(lst4);
                break;
            }
            case 12: {
                if (object != null) break;
                object = "";
                break;
            }
            case 6: {
                string = "CGO";
                this.processCGO(lst4);
                break;
            }
            case 11: {
                string = "ALIGNEMENT";
                break;
            }
            case 9: {
                string = "CALCULATOR";
                break;
            }
            case 5: {
                string = "CALLBACK";
                break;
            }
            case 10: {
                string = "SLICE";
                break;
            }
            case 7: {
                string = "SURFACE";
            }
        }
        if (object != null || cloneable != null) {
            this.pymolScene.addGroup(lst, (String)object, n2, (BS)cloneable);
        }
        if (bl2) {
            int n3 = PyMOLReader.intAt(lst3, 0);
            int n4 = PyMOLReader.intAt(lst3, 1);
            this.bsBytesExcluded.setBits(n3, n3 + n4);
            Logger.info("cached PSE file excludes PyMOL object type " + n2 + " name=" + this.objectName + " len=" + n4);
        }
        if (string != null) {
            Logger.error("Unprocessed object type " + string + " " + this.objectName);
        }
    }

    private void processCGO(Lst<Object> lst) {
        int n;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Lst<Object> lst2 = PyMOLReader.sublistAt(lst, 2, 0);
        String string = this.pymolScene.addCGO(lst2, n = PyMOL.getRGB(PyMOLReader.intAt(PyMOLReader.listAt(lst, 0), 2)));
        if (string != null) {
            this.appendLoadNote("CGO " + string);
        }
    }

    private void processGadget(Lst<Object> lst) {
        if (this.objectName.endsWith("_e_pot")) {
            this.processMap(lst, true, true);
        }
    }

    private void processMap(Lst<Object> lst, boolean bl, boolean bl2) {
        if (bl) {
            if (this.sourcePNGJ) {
                return;
            }
            if (this.isHidden && !bl2) {
                return;
            }
            if (this.mapObjects == null) {
                this.mapObjects = new Lst();
            }
            this.mapObjects.addLast(lst);
        } else {
            if (this.volumeData == null) {
                this.volumeData = new Hashtable<String, Lst<Object>>();
            }
            this.volumeData.put(this.objectName, lst);
            if (!this.isHidden && !this.isStateScript) {
                this.pymolScene.addIsosurface(this.objectName);
            }
        }
        lst.addLast(this.objectName);
    }

    private void processMeasure(Lst<Object> lst) {
        int n;
        int n2;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Logger.info("PyMOL measure " + this.objectName);
        Lst<Object> lst2 = PyMOLReader.sublistAt(lst, 2, 0);
        int n3 = 1;
        if (lst2.get(1) instanceof Lst) {
            n2 = 2;
        } else {
            n3 = 4;
            if (lst2.get(4) instanceof Lst) {
                n2 = 3;
            } else {
                n3 = 6;
                n2 = n = lst2.get(6) instanceof Lst ? 4 : 0;
            }
        }
        if (n == 0) {
            return;
        }
        Lst<Object> lst3 = PyMOLReader.listAt(lst, 0);
        BS bS = PyMOLReader.getBsReps(PyMOLReader.listAt(lst3, 3));
        Lst<Object> lst4 = PyMOLReader.listAt(lst2, n3);
        Lst<Object> lst5 = PyMOLReader.listAt(lst2, 8);
        boolean bl = lst2.size() > 8;
        int n4 = PyMOLReader.intAt(lst3, 2);
        if (this.pymolScene.addMeasurements(null, n, lst4, bS, n4, lst5, bl)) {
            this.haveMeasurements = true;
        }
    }

    private BS processMolecule(Lst<Object> lst, int n) {
        Object object;
        Lst<Object> lst2;
        Lst<Object> lst3;
        Lst<Object> lst4;
        int n2;
        Lst<Object> lst5 = PyMOLReader.listAt(lst, 4);
        Lst<Object> lst6 = PyMOLReader.listAt(lst5, n);
        int[] nArray = null;
        float[] fArray = null;
        float[] fArray2 = null;
        int n3 = PyMOLReader.intAt(lst, 2);
        int n4 = n2 = PyMOLReader.intAt(lst, 3);
        if (this.haveBinaryArrays && AU.isAB(lst6.get(3))) {
            lst4 = null;
            lst3 = null;
            lst2 = null;
            nArray = new int[n2];
            fArray = new float[n2 * 3];
            this.fillFloatArrayFromBytes((byte[])lst6.get(2), fArray);
            this.fillIntArrayFromBytes((byte[])lst6.get(3), nArray);
            object = (byte[])lst6.get(8);
            if (object != null) {
                fArray2 = new float[n2 * 7];
                this.fillFloatArrayFromBytes((byte[])object, fArray2);
            }
        } else {
            lst3 = PyMOLReader.listAt(lst6, 2);
            lst2 = PyMOLReader.listAt(lst6, 3);
            lst4 = PyMOLReader.listAt(lst6, 8);
            if (lst2 != null) {
                n4 = lst2.size();
            }
        }
        if (n4 == 0) {
            return null;
        }
        this.ac = this.ac0 = this.asc.ac;
        if (n2 == 0) {
            return null;
        }
        this.ssMapSeq = new Hashtable<String, BS>();
        if (n == 0) {
            this.processMolCryst(PyMOLReader.listAt(lst, 10));
        }
        object = this.getBondList(PyMOLReader.listAt(lst, 6));
        Lst<Object> lst7 = PyMOLReader.listAt(lst, 7);
        this.atomMap = new int[n2];
        BS bS = this.pymolScene.setAtomMap(this.atomMap, this.ac0);
        int n5 = 0;
        while (n5 < 23) {
            this.reps[n5] = BS.newN(1000);
            ++n5;
        }
        if (n == 0 || !this.isTrajectory) {
            int n6;
            this.pymolScene.ensureCapacity(n4);
            String[] stringArray = null;
            byte[] byArray = null;
            int[] nArray2 = null;
            if (this.haveBinaryArrays) {
                n6 = PyMOLReader.intAt(lst7, 0);
                byArray = (byte[])lst7.get(1);
                stringArray = this.getLexStr((byte[])lst7.get(2));
                System.out.println("PyMOL atom dump version " + n6);
                nArray2 = this.haveBinaryArrays ? PyMOL.getVArray(n6) : null;
            }
            n6 = 0;
            while (n6 < n4) {
                P3 p3 = this.addAtom(lst7, lst2 != null ? PyMOLReader.intAt(lst2, n6) : (nArray != null ? nArray[n6] : n6), byArray, nArray2, stringArray, n6, lst3, fArray, lst4, fArray2, bS, n);
                if (p3 != null) {
                    this.trajectoryStep[this.trajectoryPtr++] = p3;
                }
                ++n6;
            }
        }
        this.addBonds((Lst<Bond>)object);
        this.addMolStructures();
        this.atoms = this.asc.atoms;
        if (!this.isStateScript) {
            this.createShapeObjects();
        }
        this.ssMapSeq = null;
        Logger.info("reading " + (this.ac - this.ac0) + " atoms and " + n3 + " bonds");
        Logger.info("----------");
        return bS;
    }

    private String[] getLexStr(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = BC.bytesToInt(byArray, n2, false);
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = BC.bytesToInt(byArray, n2 += 4, false);
            n = nArray[n5];
            if (n > n4) {
                n4 = n;
            }
            ++n5;
        }
        String[] stringArray = new String[n4 + 1];
        stringArray[0] = " ";
        n2 += 4;
        n = 0;
        while (n < n3) {
            String string = this.getCStr(byArray, n2);
            stringArray[nArray[n]] = string;
            String string2 = string;
            n2 += string2.length() + 1;
            ++n;
        }
        return stringArray;
    }

    private String getCStr(byte[] byArray, int n) {
        try {
            byte[] byArray2 = this.aTemp;
            int n2 = 0;
            byte by = 0;
            while ((by = byArray[n++]) != 0) {
                if (n2 >= byArray2.length) {
                    byArray2 = this.aTemp = AU.doubleLengthByte(byArray2);
                }
                byArray2[n2++] = by;
            }
            return new String(AU.arrayCopyByte(byArray2, n2), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void processMolCryst(Lst<Object> lst) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        Lst<Object> lst2 = PyMOLReader.sublistAt(lst, 0, 0);
        Lst<Object> lst3 = PyMOLReader.sublistAt(lst, 0, 1);
        this.setUnitCell(PyMOLReader.floatAt(lst2, 0), PyMOLReader.floatAt(lst2, 1), PyMOLReader.floatAt(lst2, 2), PyMOLReader.floatAt(lst3, 0), PyMOLReader.floatAt(lst3, 1), PyMOLReader.floatAt(lst3, 2));
        this.setSpaceGroupName(PyMOLReader.stringAt(lst, 1));
    }

    private Lst<Bond> getBondList(Lst<Object> lst) {
        boolean bl = !this.pymolScene.booleanSetting(64);
        byte[] byArray = null;
        int[] nArray = null;
        int n = lst.size();
        int n2 = 0;
        if (this.haveBinaryArrays && n == 2) {
            int n3 = PyMOLReader.intAt(lst, 0);
            System.out.println("PyMOL bond dump version " + n3);
            nArray = PyMOL.getVArrayB(n3);
            byArray = (byte[])lst.get(1);
            n2 = nArray[0];
            n = byArray.length / n2;
        }
        Lst<Bond> lst2 = new Lst<Bond>();
        lst2.ensureCapacity(n);
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            Object object;
            int n7;
            int n8;
            int n9;
            if (this.haveBinaryArrays) {
                n9 = BC.bytesToInt(byArray, n6 + nArray[1], false);
                n8 = BC.bytesToInt(byArray, n6 + nArray[2], false);
                n4 = byArray[n6 + nArray[6]] == 0 ? -1 : BC.bytesToInt(byArray, n6 + nArray[5], false);
                n7 = byArray[n6 + nArray[3]];
                n6 += n2;
            } else {
                object = PyMOLReader.listAt(lst, n5);
                n9 = PyMOLReader.intAt(object, 0);
                n8 = PyMOLReader.intAt(object, 1);
                n7 = PyMOLReader.intAt(object, 2);
                int n10 = n4 = ((ArrayList)object).size() > 6 && PyMOLReader.intAt(object, 6) != 0 ? PyMOLReader.intAt(object, 5) : -1;
            }
            if (n7 < 1 || n7 > 3) {
                n7 = 1;
            }
            object = new Bond(n9, n8, n7 |= bl || n7 == 1 ? 65536 : 98304);
            ((Bond)object).uniqueID = n4;
            lst2.addLast((Bond)object);
            ++n5;
        }
        return lst2;
    }

    private void fillIntArrayFromBytes(byte[] byArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            nArray[n2++] = BC.bytesToInt(byArray, n, false);
            n += 4;
        }
    }

    private void fillFloatArrayFromBytes(byte[] byArray, float[] fArray) {
        try {
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                fArray[n2++] = BC.bytesToFloat(byArray, n, false);
                n += 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private P3 addAtom(Lst<Object> lst, int n, byte[] byArray, int[] nArray, String[] stringArray, int n2, Lst<Object> lst2, float[] fArray, Lst<Object> lst3, float[] fArray2, BS bS, int n3) {
        Object object;
        boolean bl;
        float f;
        float f2;
        float f3;
        boolean bl2;
        boolean bl3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        float f4;
        float f5;
        float f6;
        float f7;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        int n10;
        char c;
        this.atomMap[n] = -1;
        String string9 = null;
        int n11 = -1;
        float[] fArray3 = null;
        BS bS2 = null;
        if (this.haveBinaryArrays) {
            int n12;
            c = n * nArray[0];
            n10 = this.atomInt(byArray, c, nArray[1]);
            string8 = this.atomStr(byArray, c, nArray[34], stringArray);
            string7 = this.atomStr(byArray, c, nArray[38], stringArray);
            string6 = this.atomStr(byArray, c, nArray[41], stringArray);
            if (string6.length() > 3) {
                string6 = string6.substring(0, 3);
            }
            string5 = this.atomStr(byArray, c, nArray[36], stringArray);
            string4 = this.atomStr(byArray, c, nArray[37], stringArray);
            string3 = this.atomStr(byArray, c, nArray[19], stringArray);
            string2 = this.atomStr(byArray, c, nArray[39], null);
            string = this.atomStr(byArray, c, nArray[40], null);
            int n13 = nArray[42];
            if (n13 == 0) {
                string7 = this.atomStr(byArray, c, nArray[38], null);
            } else {
                n12 = byArray[c + n13];
                string9 = n12 == 0 ? " " : "" + (char)n12;
            }
            f7 = this.atomFloat(byArray, c, nArray[4]);
            f6 = this.atomFloat(byArray, c, nArray[5]);
            f5 = this.atomFloat(byArray, c, nArray[6]);
            f4 = this.atomFloat(byArray, c, nArray[7]);
            n9 = byArray[c + nArray[28]];
            if (n9 > 125) {
                n9 -= 512;
            }
            n8 = this.atomInt(byArray, c, nArray[20]);
            n7 = this.atomInt(byArray, c, nArray[9]);
            n6 = this.atomInt(byArray, c, nArray[10]);
            n5 = this.atomInt(byArray, c, nArray[30]);
            n4 = this.atomInt(byArray, c, nArray[11]);
            n11 = this.atomInt(byArray, c, nArray[13]);
            if (n11 == 0) {
                n11 = -1;
            }
            fArray3 = new float[8];
            n13 = nArray[45];
            if (n13 > 0) {
                n12 = 0;
                while (n12 < 6) {
                    fArray3[n12] = BC.bytesToShort(byArray, c + n13 + (n12 << 1), false);
                    ++n12;
                }
            }
            bl3 = this.atomBool(byArray, c, nArray[22], nArray[47]);
            bl2 = this.atomBool(byArray, c, nArray[21], nArray[46]);
        } else {
            Lst<Object> lst4 = PyMOLReader.listAt(lst, n);
            n10 = PyMOLReader.intAt(lst4, 0);
            string8 = PyMOLReader.stringAt(lst4, 1);
            string = PyMOLReader.stringAt(lst4, 2);
            string7 = PyMOLReader.stringAt(lst4, 3);
            string6 = PyMOLReader.stringAt(lst4, 5);
            string5 = PyMOLReader.stringAt(lst4, 6);
            string4 = PyMOLReader.stringAt(lst4, 7);
            string3 = PyMOLReader.stringAt(lst4, 9);
            string2 = PyMOLReader.stringAt(lst4, 10).substring(0, 1);
            f7 = PyMOLReader.floatAt(lst4, 14);
            f6 = PyMOLReader.floatAt(lst4, 15);
            f5 = PyMOLReader.floatAt(lst4, 16);
            f4 = PyMOLReader.floatAt(lst4, 17);
            n9 = PyMOLReader.intAt(lst4, 18);
            bl2 = PyMOLReader.intAt(lst4, 19) != 0;
            bS2 = PyMOLReader.getBsReps(PyMOLReader.listAt(lst4, 20));
            n8 = bS2 == null ? PyMOLReader.intAt(lst4, 20) : 0;
            n7 = PyMOLReader.intAt(lst4, 21);
            n6 = PyMOLReader.intAt(lst4, 22);
            n5 = PyMOLReader.intAt(lst4, 23);
            n4 = PyMOLReader.intAt(lst4, 24);
            bl3 = PyMOLReader.intAt(lst4, 25) != 0;
            int n14 = n11 = lst4.size() > 40 && PyMOLReader.intAt(lst4, 40) == 1 ? PyMOLReader.intAt(lst4, 32) : -1;
            if (lst4.size() > 46) {
                fArray3 = PyMOLReader.floatsAt(lst4, 41, new float[8], 6);
            }
        }
        if (string9 == null) {
            int n15 = string7.length();
            c = n15 > 0 ? string7.charAt(n15 - 1) : (char)' ';
            String string10 = string9 = PT.isDigit(c) ? " " : "" + c;
        }
        if (string6.length() > 3) {
            string6 = string6.substring(0, 3);
        }
        if (string6.equals(" ")) {
            string6 = "UNK";
        }
        if (string4.equals("A")) {
            string4 = "C";
        }
        int n16 = this.vwr.getChainID(string8, true);
        Atom atom = this.processAtom(new Atom(), string5, string.charAt(0), string6, n16, n10, string9.charAt(0), bl2, string4);
        if (!this.filterPDBAtom(atom, this.fileAtomIndex++)) {
            return null;
        }
        n2 *= 3;
        if (this.haveBinaryArrays) {
            f3 = fArray[n2];
            f2 = fArray[++n2];
            f = fArray[++n2];
        } else {
            f3 = PyMOLReader.floatAt(lst2, n2);
            f2 = PyMOLReader.floatAt(lst2, ++n2);
            f = PyMOLReader.floatAt(lst2, ++n2);
        }
        BoxInfo.addPointXYZ(f3, f2, f, this.xyzMin, this.xyzMax, 0.0f);
        if (this.isTrajectory && n3 > 0) {
            return null;
        }
        boolean bl4 = bl = nucleic.indexOf(string6) >= 0;
        if (bS != null) {
            bS.set(this.ac);
        }
        if (n10 >= -1000 && (!string2.equals(" ") || string5.equals("CA") || bl)) {
            object = this.ssMapSeq.get(string2);
            if (object == null) {
                object = new BS();
                this.ssMapSeq.put(string2, (BS)object);
            }
            ((BS)object).set(n10 - -1000);
            string2 = String.valueOf(string2) + n16;
            object = this.ssMapSeq.get(string2);
            if (object == null) {
                object = new BS();
                this.ssMapSeq.put(string2, (BS)object);
            }
            ((BS)object).set(n10 - -1000);
        }
        atom.bfactor = f7;
        atom.foccupancy = f6;
        atom.radius = f5;
        if (atom.radius == 0.0f) {
            atom.radius = 1.0f;
        }
        atom.partialCharge = f4;
        atom.vib = V3.new3(n11, n5, Float.NaN);
        if (fArray3 != null && fArray3[0] != 0.0f) {
            this.asc.setAnisoBorU(atom, fArray3, 12);
        }
        this.pymolScene.setAtomColor(n7);
        this.processAtom2(atom, n6, f3, f2, f, n9);
        if (!bl3) {
            this.pymolScene.bsNonbonded.set(this.ac);
        }
        if (!string3.equals(" ")) {
            this.pymolScene.bsLabeled.set(this.ac);
            object = new float[7];
            if (fArray2 != null) {
                int n17 = 0;
                while (n17 < 7) {
                    object[n17] = fArray2[n * 7 + n17];
                    ++n17;
                }
            } else {
                Lst<Object> lst5 = PyMOLReader.listAt(lst3, n);
                if (lst5 != null) {
                    int n18 = 0;
                    while (n18 < 7) {
                        object[n18] = PyMOLReader.floatAt(lst5, n18);
                        ++n18;
                    }
                }
            }
            this.pymolScene.addLabel(this.ac, n11, n7, (float[])object, string3);
        }
        if (this.isHidden) {
            this.pymolScene.bsHidden.set(this.ac);
        }
        if (bl) {
            this.pymolScene.bsNucleic.set(this.ac);
        }
        int n19 = 0;
        while (n19 < 21) {
            if (bS2 == null ? (n8 & 1 << n19) != 0 : bS2.get(n19)) {
                this.reps[n19].set(this.ac);
            }
            ++n19;
        }
        if (atom.elementSymbol.equals("H")) {
            this.pymolScene.bsHydrogen.set(this.ac);
        }
        if ((n4 & PyMOL.FLAG_NOSURFACE) != 0) {
            this.pymolScene.bsNoSurface.set(this.ac);
        }
        ++this.ac;
        return null;
    }

    private boolean atomBool(byte[] byArray, int n, int n2, int n3) {
        return (byArray[n + n2] & n3) != 0;
    }

    private float atomFloat(byte[] byArray, int n, int n2) {
        try {
            return BC.bytesToFloat(byArray, n + n2, false);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    private String atomStr(byte[] byArray, int n, int n2, String[] stringArray) {
        if (n2 < 0) {
            return stringArray[BC.bytesToInt(byArray, n - n2, false)];
        }
        String string = this.getCStr(byArray, n + n2);
        return string.length() == 0 ? " " : string;
    }

    private int atomInt(byte[] byArray, int n, int n2) {
        return BC.bytesToInt(byArray, n + n2, false);
    }

    private void addBonds(Lst<Bond> lst) {
        int n = lst.size();
        int n2 = 0;
        while (n2 < n) {
            Bond bond = (Bond)lst.get(n2);
            bond.atomIndex1 = this.atomMap[bond.atomIndex1];
            bond.atomIndex2 = this.atomMap[bond.atomIndex2];
            if (bond.atomIndex1 >= 0 && bond.atomIndex2 >= 0) {
                this.pymolScene.setUniqueBond(this.bondCount++, bond.uniqueID);
                this.asc.addBond(bond);
            }
            ++n2;
        }
    }

    private void addMolStructures() {
        this.addMolSS("H", STR.HELIX);
        this.addMolSS("S", STR.SHEET);
        this.addMolSS("L", STR.TURN);
        this.addMolSS(" ", STR.NONE);
    }

    private void addMolSS(String string, STR sTR) {
        if (this.ssMapSeq.get(string) == null) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Atom[] atomArray = this.asc.atoms;
        BS bS = null;
        BS bS2 = this.pymolScene.getSSMapAtom(string);
        int n4 = this.ac + 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = this.ac0;
        while (n9 < n4) {
            block11: {
                block13: {
                    block10: {
                        block12: {
                            block9: {
                                if (n9 == this.ac) {
                                    n6 = 0;
                                } else {
                                    n5 = atomArray[n9].sequenceNumber;
                                    n6 = atomArray[n9].chainID;
                                    n8 = atomArray[n9].atomSetIndex;
                                }
                                if (n6 == n3 && n8 == n7) break block9;
                                n3 = n6;
                                n7 = n8;
                                bS = this.ssMapSeq.get(String.valueOf(string) + n6);
                                --n9;
                                if (n >= 0) break block10;
                                break block11;
                            }
                            if (bS == null || n5 < -1000 || !bS.get(n5 - -1000)) break block12;
                            n2 = n9;
                            if (n < 0) {
                                n = n9;
                            }
                            break block11;
                        }
                        if (n < 0) break block11;
                    }
                    if (sTR == STR.NONE) break block13;
                    int n10 = this.bsStructureDefined.nextSetBit(n);
                    if (n10 >= 0 && n10 <= n2) break block11;
                    this.bsStructureDefined.setBits(n, n2 + 1);
                    Structure structure = new Structure(n7, sTR, sTR, sTR.toString(), ++this.structureCount, sTR == STR.SHEET ? 1 : 0, null);
                    Atom atom = atomArray[n];
                    Atom atom2 = atomArray[n2];
                    int n11 = this.asc.getAtomSetAtomIndex(n8);
                    structure.set(atom.chainID, atom.sequenceNumber, atom.insertionCode, atom2.chainID, atom2.sequenceNumber, atom2.insertionCode, n - n11, n2 - n11);
                    this.asc.addStructure(structure);
                }
                bS2.setBits(n, n2 + 1);
                n = -1;
            }
            ++n9;
        }
    }

    private void createShapeObjects() {
        this.pymolScene.createShapeObjects(this.reps, this.allowSurface && !this.isHidden, this.ac0, this.ac);
    }

    private void processMeshes() {
        String string = this.vwr.fm.getFilePath(this.pymolScene.surfaceInfoName, true, false);
        this.vwr.cachePut(string, this.volumeData);
        int n = this.mapObjects.size();
        while (--n >= 0) {
            String string2;
            Object object;
            int n2;
            Lst lst = (Lst)this.mapObjects.get(n);
            String string3 = lst.get(lst.size() - 1).toString();
            boolean bl = string3.endsWith("_e_pot");
            if (bl) {
                n2 = 0x400000C0;
                object = string3.substring(0, string3.length() - 3);
                string2 = String.valueOf(object) + "map";
                String string4 = this.pymolScene.getObjectID(String.valueOf(object) + "chg");
                if (string4 == null) continue;
                lst.addLast(string4);
                this.pymolScene.mepList = String.valueOf(this.pymolScene.mepList) + ";" + string4 + ";";
            } else {
                n2 = 1073742018;
                string2 = PyMOLReader.stringAt(PyMOLReader.sublistAt(lst, 2, 0), 1);
            }
            object = this.volumeData.get(string2);
            if (object == null) continue;
            lst.addLast(string2);
            this.volumeData.put(string3, lst);
            this.volumeData.put("__pymolSurfaceData__", lst);
            if (!this.isStateScript) {
                this.pymolScene.addMesh(n2, lst, string3, bl);
            }
            this.appendLoadNote("PyMOL object " + string3 + " references map " + string2);
        }
    }

    private void processDefinitions() {
        String string = this.vwr.getAtomDefs(this.pymolScene.setAtomDefs());
        if (string.length() > 2) {
            string = string.substring(0, string.length() - 2);
        }
        this.appendLoadNote(string);
    }

    private void processSelectionsAndScenes(Map<String, Object> map) {
        if (!this.pymolScene.needSelections()) {
            return;
        }
        Map<String, Lst<Object>> map2 = PyMOLReader.listToMap(PyMOLReader.getMapList(map, "names"));
        if (this.haveScenes) {
            Map map3 = (Map)map.get("scene_dict");
            this.finalizeSceneData();
            Map<String, Lst<Object>> map4 = PyMOLReader.listToMap(PyMOLReader.getMapList(map, "selector_secrets"));
            int n = 0;
            while (n < this.sceneOrder.size()) {
                String string = PyMOLReader.stringAt(this.sceneOrder, n);
                Lst<Object> lst = PyMOLReader.getMapList(map3, string);
                if (lst != null) {
                    this.pymolScene.buildScene(string, lst, map2, map4);
                    this.appendLoadNote("scene: " + string);
                }
                ++n;
            }
        }
        this.pymolScene.setCarveSets(map2);
    }

    private void finalizeSceneData() {
        int[] nArray = new int[this.ac];
        int[] nArray2 = new int[this.ac];
        int[] nArray3 = new int[this.ac];
        boolean[] blArray = new boolean[this.ac];
        float[] fArray = new float[this.ac];
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        while (n3 < this.ac) {
            nArray[n3] = this.getCartoonType(n3);
            nArray2[n3] = this.getUniqueID(n3);
            nArray3[n3] = this.getSequenceNumber(n3);
            fArray[n3] = this.getVDW(n3);
            if (n != this.atoms[n3].chainID || n2 != this.atoms[n3].atomSetIndex) {
                blArray[n3] = true;
                n = this.atoms[n3].chainID;
                n2 = this.atoms[n3].atomSetIndex;
            }
            ++n3;
        }
        this.pymolScene.setAtomInfo(nArray2, nArray, nArray3, blArray, fArray);
    }

    static int intAt(Lst<Object> lst, int n) {
        return lst == null ? -1 : ((Number)lst.get(n)).intValue();
    }

    static P3 pointAt(Lst<Object> lst, int n, P3 p3) {
        p3.set(PyMOLReader.floatAt(lst, n++), PyMOLReader.floatAt(lst, n++), PyMOLReader.floatAt(lst, n));
        return p3;
    }

    static float[] floatsAt(Lst<Object> lst, int n, float[] fArray, int n2) {
        if (lst == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = PyMOLReader.floatAt(lst, n++);
            ++n3;
        }
        return fArray;
    }

    static float floatAt(Lst<Object> lst, int n) {
        return lst == null || n >= lst.size() ? 0.0f : ((Number)lst.get(n)).floatValue();
    }

    static Lst<Object> listAt(Lst<Object> lst, int n) {
        if (lst == null || n >= lst.size()) {
            return null;
        }
        Object e = lst.get(n);
        return e instanceof Lst ? (Lst)e : null;
    }

    public static Lst<Object> sublistAt(Lst<Object> lst, int ... nArray) {
        int n = 0;
        while (n < nArray.length) {
            lst = (Lst)lst.get(nArray[n]);
            ++n;
        }
        return lst;
    }

    static Map<String, Lst<Object>> listToMap(Lst<Object> lst) {
        Hashtable<String, Lst<Object>> hashtable = new Hashtable<String, Lst<Object>>();
        int n = lst.size();
        while (--n >= 0) {
            Lst<Object> lst2 = PyMOLReader.listAt(lst, n);
            if (lst2 == null || lst2.size() <= 0) continue;
            hashtable.put(PyMOLReader.stringAt(lst2, 0), lst2);
        }
        return hashtable;
    }

    static String stringAt(Lst<Object> lst, int n) {
        byte[] byArray = (byte[])lst.get(n);
        return byArray.length == 0 ? " " : PyMOLReader.bytesToString(byArray);
    }

    static String bytesToString(Object object) {
        try {
            return new String((byte[])object, "UTF-8");
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    static int colorSettingClamped(Lst<Object> lst, P3 p3) {
        return PyMOLReader.getColorPt(lst.get(lst.size() < 6 || PyMOLReader.intAt(lst, 4) == 0 ? 2 : 5), p3);
    }

    static int getColorPt(Object object, P3 p3) {
        return object == null ? 0 : (object instanceof Integer ? (Integer)object : CU.colorPtToFFRGB(PyMOLReader.pointAt((Lst)object, 0, p3)));
    }

    private static Lst<Object> getMapList(Map<String, Object> map, String string) {
        return (Lst)map.get(string);
    }

    private static BS getBsReps(Lst<Object> lst) {
        if (lst == null) {
            return null;
        }
        BS bS = new BS();
        int n = Math.min(lst.size(), 21);
        int n2 = 0;
        while (n2 < n) {
            if (PyMOLReader.intAt(lst, n2) == 1) {
                bS.set(n2);
            }
            ++n2;
        }
        return bS;
    }

    @Override
    public int getUniqueID(int n) {
        return (int)this.atoms[n].vib.x;
    }

    @Override
    public int getCartoonType(int n) {
        return (int)this.atoms[n].vib.y;
    }

    @Override
    public float getVDW(int n) {
        return this.atoms[n].radius;
    }

    @Override
    public int getSequenceNumber(int n) {
        return this.atoms[n].sequenceNumber;
    }

    @Override
    public boolean compareAtoms(int n, int n2) {
        return this.atoms[n].chainID != this.atoms[n2].chainID;
    }
}

