/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.io.BufferedInputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolPatternMatcher;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.PointIterator;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class MathExt {
    private Viewer vwr;
    private ScriptEval e;
    private Random rand;
    private JmolPatternMatcher pm;

    public MathExt init(Object object) {
        this.e = (ScriptEval)object;
        this.vwr = this.e.vwr;
        return this;
    }

    public boolean evaluate(ScriptMathProcessor scriptMathProcessor, T t, SV[] sVArray, int n) throws ScriptException {
        switch (n) {
            case 134217749: 
            case 0x8000202: 
            case 134218244: 
            case 134218245: 
            case 134218246: 
            case 134218250: {
                return this.evaluateMath(scriptMathProcessor, sVArray, n);
            }
            case 1275068928: 
            case 1275068929: 
            case 1275068930: 
            case 1275068931: 
            case 1275069441: 
            case 1275334681: 
            case 1275335685: {
                return this.evaluateList(scriptMathProcessor, t.intValue, sVArray);
            }
            case 0x10000040: {
                if (sVArray.length == 0) {
                    scriptMathProcessor.wasX = false;
                }
            }
            case 1275068418: {
                return this.evaluateArray(scriptMathProcessor, sVArray, n == 1275068418 && t.tok == 0x100000D1);
            }
            case 0x8000003: 
            case 134221850: {
                return this.evaluateQuaternion(scriptMathProcessor, sVArray, n);
            }
            case 0x4C000004: {
                return this.evaluateBin(scriptMathProcessor, sVArray);
            }
            case 134221829: {
                return this.evaluateCache(scriptMathProcessor, sVArray);
            }
            case 1275068934: 
            case 1275068935: {
                return this.evaluateRowCol(scriptMathProcessor, sVArray, n);
            }
            case 1765808134: {
                return this.evaluateColor(scriptMathProcessor, sVArray);
            }
            case 134221831: {
                return this.evaluateCompare(scriptMathProcessor, sVArray);
            }
            case 0x8000008: 
            case 1228931587: 
            case 1275203608: {
                return this.evaluateConnected(scriptMathProcessor, sVArray, n, t.intValue);
            }
            case 1814695966: {
                return this.evaluateUnitCell(scriptMathProcessor, sVArray, t.tok == 0x100000D1);
            }
            case 134353926: {
                return this.evaluateContact(scriptMathProcessor, sVArray);
            }
            case 134221834: {
                return this.evaluateData(scriptMathProcessor, sVArray);
            }
            case 1275069442: 
            case 0x4C000404: {
                return this.evaluateDotDist(scriptMathProcessor, sVArray, n, t.intValue);
            }
            case 1275069443: {
                if (t.tok == 0x100000D1) {
                    return this.evaluateDotDist(scriptMathProcessor, sVArray, n, t.intValue);
                }
            }
            case 0x8000001: 
            case 1745489939: {
                return this.evaluateMeasure(scriptMathProcessor, sVArray, t.tok);
            }
            case 134222849: 
            case 1228935687: {
                return this.evaluateLoad(scriptMathProcessor, sVArray, n == 1228935687);
            }
            case 1275068427: {
                return this.evaluateFind(scriptMathProcessor, sVArray);
            }
            case 1287653388: 
            case 1825200146: {
                return this.evaluateFormat(scriptMathProcessor, t.intValue, sVArray, n == 1825200146);
            }
            case 134320141: {
                return this.evaluateUserFunction(scriptMathProcessor, (String)t.value, sVArray, t.intValue, t.tok == 0x100000D1);
            }
            case 1275068449: 
            case 1275072526: 
            case 1275082245: {
                return this.evaluateGetProperty(scriptMathProcessor, sVArray, n, t.tok == 0x100000D1);
            }
            case 136314895: {
                return this.evaluateHelix(scriptMathProcessor, sVArray);
            }
            case 134217750: 
            case 134217763: 
            case 134219265: {
                return this.evaluatePlane(scriptMathProcessor, sVArray, n);
            }
            case 134218759: 
            case 134222350: 
            case 134222850: 
            case 134238732: {
                return this.evaluateScript(scriptMathProcessor, sVArray, n);
            }
            case 1275068932: 
            case 1275069446: 
            case 1275069447: {
                return this.evaluateString(scriptMathProcessor, t.intValue, sVArray);
            }
            case 134217751: {
                return this.evaluatePoint(scriptMathProcessor, sVArray);
            }
            case 0x8000022: {
                return this.evaluatePointGroup(scriptMathProcessor, sVArray);
            }
            case 134256131: {
                return this.evaluatePrompt(scriptMathProcessor, sVArray);
            }
            case 134219268: {
                return this.evaluateRandom(scriptMathProcessor, sVArray);
            }
            case 1275068432: {
                return this.evaluateIn(scriptMathProcessor, sVArray);
            }
            case 1275072532: {
                return this.evaluateModulation(scriptMathProcessor, sVArray);
            }
            case 1275068443: {
                return this.evaluateReplace(scriptMathProcessor, sVArray);
            }
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                return this.evaluateSubstructure(scriptMathProcessor, sVArray, n, t.tok == 0x100000D1);
            }
            case 1275068425: 
            case 1275068444: {
                return this.evaluateSort(scriptMathProcessor, sVArray, n);
            }
            case 1296041986: {
                return this.evaluateSymop(scriptMathProcessor, sVArray, t.tok == 0x100000D1);
            }
            case 1275068445: {
                return this.evaluateTensor(scriptMathProcessor, sVArray);
            }
            case 134217759: {
                return this.evaluateWithin(scriptMathProcessor, sVArray);
            }
            case 134221856: {
                return this.evaluateWrite(scriptMathProcessor, sVArray);
            }
        }
        return false;
    }

    private boolean evaluatePointGroup(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        T3[] t3Array = null;
        P3 p3 = null;
        float f = Float.NaN;
        float f2 = Float.NaN;
        block0 : switch (sVArray.length) {
            case 4: {
                f2 = sVArray[3].asFloat();
            }
            case 3: {
                f = sVArray[2].asFloat();
            }
            case 2: {
                int n;
                Lst<P3> lst;
                BS bS;
                switch (sVArray[1].tok) {
                    case 8: {
                        p3 = SV.ptValue(sVArray[1]);
                        break;
                    }
                    case 10: {
                        bS = SV.getBitSet(sVArray[1], false);
                        int n2 = bS.nextSetBit(0);
                        if (n2 < 0 || n2 >= this.vwr.ms.ac || bS.cardinality() != 1) {
                            return false;
                        }
                        if (SV.sValue(sVArray[0]).equalsIgnoreCase("spaceGroup")) {
                            lst = this.vwr.ms.generateCrystalClass(n2, P3.new3(Float.NaN, Float.NaN, Float.NaN));
                            t3Array = new T3[lst.size()];
                            n = t3Array.length;
                            while (--n >= 0) {
                                t3Array[n] = (T3)lst.get(n);
                            }
                            p3 = new P3();
                            if (sVArray.length != 2) break;
                            f = 0.0f;
                            break;
                        }
                        p3 = this.vwr.ms.at[n2];
                    }
                }
                if (t3Array != null) break;
            }
            case 1: {
                int n;
                Lst<P3> lst;
                BS bS;
                switch (sVArray[0].tok) {
                    case 7: {
                        Lst<SV> lst2 = sVArray[0].getList();
                        t3Array = new T3[lst2.size()];
                        int n3 = t3Array.length;
                        while (--n3 >= 0) {
                            t3Array[n3] = SV.ptValue((SV)lst2.get(n3));
                        }
                        break block0;
                    }
                    case 10: {
                        bS = SV.getBitSet(sVArray[0], false);
                        lst = this.vwr.ms.getAtomPointVector(bS);
                        t3Array = new T3[lst.size()];
                        n = t3Array.length;
                        while (--n >= 0) {
                            t3Array[n] = (T3)lst.get(n);
                        }
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            default: {
                return false;
            }
        }
        SymmetryInterface symmetryInterface = this.vwr.getSymTemp().setPointGroup(null, p3, t3Array, null, false, Float.isNaN(f) ? this.vwr.getFloat(0x22000026) : f, Float.isNaN(f2) ? this.vwr.getFloat(0x22000028) : f2, true);
        return scriptMathProcessor.addXMap((Map)symmetryInterface.getPointGroupInfo(-1, null, true, null, 0, 1.0f));
    }

    private boolean evaluateUnitCell(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        String string;
        int n;
        int n2;
        Object object;
        T3[] t3Array;
        float f;
        int n3;
        int n4;
        block39: {
            block40: {
                int n5;
                BS bS = bl ? SV.getBitSet(scriptMathProcessor.getX(), true) : null;
                n4 = (bS == null ? this.vwr.getAllAtoms() : bS).nextSetBit(0);
                n3 = sVArray.length - 1;
                f = 1.0f;
                switch (n3 < 0 ? 0 : sVArray[n3].tok) {
                    case 2: 
                    case 3: {
                        f = sVArray[n3].asFloat();
                        --n3;
                    }
                }
                int n6 = n3 < 0 ? 0 : sVArray[0].tok;
                t3Array = null;
                Lst<SV> lst = null;
                switch (n6) {
                    case 7: {
                        lst = sVArray[0].getList();
                        break;
                    }
                    case 4: {
                        object = sVArray[0].asString();
                        if (((String)object).indexOf("a=") == 0) {
                            t3Array = new P3[4];
                            n5 = 0;
                            while (n5 < 4) {
                                t3Array[n5] = new P3();
                                ++n5;
                            }
                            SimpleUnitCell.setOabc((String)object, null, t3Array);
                            break;
                        }
                        if (((String)object).indexOf(",") < 0) break;
                        return scriptMathProcessor.addXObj(this.vwr.getV0abc(object));
                    }
                }
                object = null;
                int n7 = n5 = lst != null ? 1 : 0;
                if (t3Array == null && n5 != 0 && lst.size() < 4) {
                    return false;
                }
                int n8 = n2 = n5 != 0 ? 1 : 0;
                if (t3Array == null && n5 == 0 && n6 != 8) {
                    T3[] t3Array2;
                    Object object2 = object = n4 < 0 ? null : this.vwr.ms.getUnitCell(this.vwr.ms.at[n4].mi);
                    if (object == null) {
                        P3[] p3Array = new P3[4];
                        p3Array[0] = P3.new3(0.0f, 0.0f, 0.0f);
                        p3Array[1] = P3.new3(1.0f, 0.0f, 0.0f);
                        p3Array[2] = P3.new3(0.0f, 1.0f, 0.0f);
                        t3Array2 = p3Array;
                        p3Array[3] = P3.new3(0.0f, 0.0f, 1.0f);
                    } else {
                        t3Array2 = t3Array = object.getUnitCellVectors();
                    }
                }
                if (t3Array != null) break block39;
                t3Array = new P3[4];
                if (n5 == 0) break block40;
                switch (lst.size()) {
                    case 3: {
                        t3Array[0] = new P3();
                        int n9 = 0;
                        while (n9 < 3) {
                            t3Array[n9 + 1] = P3.newP(SV.ptValue((SV)lst.get(n9)));
                            ++n9;
                        }
                        break block39;
                    }
                    case 4: {
                        int n10 = 0;
                        while (n10 < 4) {
                            t3Array[n10] = P3.newP(SV.ptValue((SV)lst.get(n10)));
                            ++n10;
                        }
                        break block39;
                    }
                    case 6: {
                        float[] fArray = new float[6];
                        n = 0;
                        while (n < 6) {
                            fArray[n] = ((SV)lst.get(n)).asFloat();
                            ++n;
                        }
                        SimpleUnitCell.setOabc(null, fArray, t3Array);
                        break block39;
                    }
                    default: {
                        return false;
                    }
                }
            }
            t3Array[0] = SV.ptValue(sVArray[0]);
            switch (n3) {
                case 3: {
                    int n11 = 1;
                    while (n11 < 4) {
                        t3Array[n11] = P3.newP(SV.ptValue(sVArray[n11]));
                        t3Array[n11].sub(t3Array[0]);
                        ++n11;
                    }
                    break;
                }
                case 1: {
                    Lst<SV> lst = sVArray[1].getList();
                    if (lst != null && lst.size() == 3) {
                        n = 0;
                        while (n < 3) {
                            t3Array[n + 1] = SV.ptValue((SV)lst.get(n));
                            ++n;
                        }
                        break;
                    }
                }
                default: {
                    return false;
                }
            }
        }
        if ((n = "primitive".equalsIgnoreCase(string = n2 <= n3 ? sVArray[n2].asString() : null)) != 0 || "conventional".equalsIgnoreCase(string)) {
            String string2;
            String string3 = string2 = ++n2 > n3 ? "" : sVArray[n2].asString().toUpperCase();
            if (string2.equals("BCC")) {
                string2 = "I";
            } else if (string2.length() == 0) {
                string2 = (String)this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, n4, null, 0, null, null, null, 0x400000AA, 0.0f, -1);
            }
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            if (object == null) {
                object = this.vwr.getSymTemp();
            }
            M3 m3 = (M3)this.vwr.getModelForAtomIndex((int)n4).auxiliaryInfo.get("primitiveToCrystal");
            if (!object.toFromPrimitive(n != 0, string2.charAt(0), t3Array, m3)) {
                return false;
            }
        } else if ("reciprocal".equalsIgnoreCase(string)) {
            t3Array = SimpleUnitCell.getReciprocal(t3Array, null, f);
            f = 1.0f;
        }
        if (f != 1.0f) {
            int n12 = 1;
            while (n12 < 4) {
                t3Array[n12].scale(f);
                ++n12;
            }
        }
        return scriptMathProcessor.addXObj(t3Array);
    }

    private boolean evaluateArray(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        if (bl) {
            SV sV = scriptMathProcessor.getX();
            switch (sVArray.length == 1 ? sV.tok : 0) {
                case 6: {
                    Lst<SV> lst = new Lst<SV>();
                    String string = sVArray[0].asString();
                    Map<String, SV> map = sV.getMap();
                    String[] stringArray = sV.getKeys(false);
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        if (map.get(stringArray[n]).getMap() == null) {
                            return false;
                        }
                        ++n;
                    }
                    n = 0;
                    n2 = stringArray.length;
                    while (n < n2) {
                        SV sV2 = map.get(stringArray[n]);
                        Map<String, SV> map2 = sV2.getMap();
                        Map map3 = (Map)SV.deepCopy(map2, true, false);
                        map3.put(string, SV.newS(stringArray[n]));
                        lst.addLast(SV.newV(6, map3));
                        ++n;
                    }
                    return scriptMathProcessor.addXList(lst);
                }
                case 7: {
                    Map<String, SV> map;
                    Hashtable<String, SV> hashtable = new Hashtable<String, SV>();
                    Lst<SV> lst = sV.getList();
                    String string = sVArray[0].asString();
                    int n = 0;
                    int n3 = lst.size();
                    while (n < n3) {
                        map = ((SV)lst.get(n)).getMap();
                        if (map == null || map.get(string) == null) {
                            return false;
                        }
                        ++n;
                    }
                    n = 0;
                    n3 = lst.size();
                    while (n < n3) {
                        map = (SV)lst.get(n);
                        Map map4 = (Map)SV.deepCopy(((SV)((Object)map)).getMap(), true, false);
                        SV sV3 = (SV)map4.remove(string);
                        hashtable.put(sV3.asString(), SV.newV(6, map4));
                        ++n;
                    }
                    return scriptMathProcessor.addXObj(hashtable);
                }
            }
            return false;
        }
        SV[] sVArray2 = new SV[sVArray.length];
        int n = sVArray2.length;
        while (--n >= 0) {
            sVArray2[n] = SV.newT(sVArray[n]);
        }
        return scriptMathProcessor.addXAV(sVArray2);
    }

    private boolean evaluateBin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        float[] fArray;
        boolean bl;
        int n = sVArray.length;
        if (n < 3 || n > 5) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = bl = sV.tok == 13;
        if (!bl && sV.tok != 7) {
            return scriptMathProcessor.addX(sV);
        }
        float f = SV.fValue(sVArray[0]);
        float f2 = SV.fValue(sVArray[1]);
        float f3 = SV.fValue(sVArray[2]);
        boolean bl3 = n >= 4 && sVArray[n - 1].tok == 1073742335;
        String string = (n == 5 || n == 4 && !bl3) && sVArray[3].tok != 1073742334 ? SV.sValue(sVArray[3]) : null;
        Map<K, V>[] mapArray = null;
        if (bl) {
            fArray = (float[])sV.value;
        } else {
            Lst<SV> lst = sV.getList();
            fArray = new float[lst.size()];
            if (string != null) {
                mapArray = AU.createArrayOfHashtable(lst.size());
            }
            try {
                int n2 = lst.size();
                while (--n2 >= 0) {
                    SV sV2;
                    if (string == null) {
                        sV2 = (SV)lst.get(n2);
                    } else {
                        mapArray[n2] = ((SV)lst.get(n2)).getMap();
                        sV2 = mapArray[n2].get(string);
                    }
                    fArray[n2] = SV.fValue(sV2);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        int n3 = Math.max((int)Math.floor((f2 - f) / f3 + 0.01f), 1);
        int[] nArray = new int[n3];
        int n4 = fArray.length;
        int n5 = 0;
        while (n5 < n4) {
            float f4 = fArray[n5];
            int n6 = (int)Math.floor((f4 - f) / f3);
            if (n6 >= 0 && n6 < n3) {
                Map<String, SV> map;
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                if (string != null && (map = mapArray[n5]) != null) {
                    map.put("_bin", SV.newI(n6));
                    float f5 = f + f3 * (float)n6;
                    float f6 = f5 + f3;
                    map.put("_binMin", SV.newF(n6 == 0 ? -3.4028235E38f : f5));
                    map.put("_binMax", SV.newF(n6 == n3 - 1 ? Float.MAX_VALUE : f6));
                }
            }
            ++n5;
        }
        if (bl3) {
            Lst<float[]> lst = new Lst<float[]>();
            int n8 = 0;
            while (n8 < n3) {
                lst.addLast(new float[]{f + f3 * (float)n8, nArray[n8]});
                ++n8;
            }
            return scriptMathProcessor.addXList(lst);
        }
        return scriptMathProcessor.addXAI(nArray);
    }

    private boolean evaluateCache(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 0) {
            return false;
        }
        return scriptMathProcessor.addXMap(this.vwr.fm.cacheList());
    }

    private boolean evaluateColor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        Map<String, Object> map;
        boolean bl;
        ColorEncoder colorEncoder;
        String string = sVArray.length > 0 ? SV.sValue(sVArray[0]) : "";
        boolean bl2 = string.startsWith("$");
        if (sVArray.length == 2 && string.equalsIgnoreCase("TOHSL")) {
            return scriptMathProcessor.addXPt(CU.rgbToHSL(P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString())), true));
        }
        if (sVArray.length == 2 && string.equalsIgnoreCase("TORGB")) {
            P3 p3 = P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString()));
            return scriptMathProcessor.addXPt(sVArray[1].tok == 8 ? CU.hslToRGB(p3) : p3);
        }
        if (sVArray.length == 4 && (sVArray[3].tok == 1073742335 || sVArray[3].tok == 1073742334)) {
            boolean bl3;
            P3 p3 = P3.newP(sVArray[0].tok == 8 ? SV.ptValue(sVArray[0]) : CU.colorPtFromString(sVArray[0].asString()));
            P3 p32 = P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString()));
            boolean bl4 = bl3 = sVArray[3].tok == 1073742335;
            if (bl3) {
                p3 = CU.rgbToHSL(p3, false);
                p32 = CU.rgbToHSL(p32, false);
            }
            SB sB = new SB();
            V3 v3 = V3.newVsub(p32, p3);
            int n = sVArray[2].asInt();
            if (n < 2) {
                n = 20;
            }
            v3.scale(1.0f / (float)(n - 1));
            int n2 = 0;
            while (n2 < n) {
                sB.append(Escape.escapeColor(CU.colorPtToFFRGB(bl3 ? CU.hslToRGB(p3) : p3)));
                p3.add(v3);
                ++n2;
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        ColorEncoder colorEncoder2 = colorEncoder = bl2 ? null : this.vwr.cm.getColorEncoder(string);
        if (!bl2 && colorEncoder == null) {
            return scriptMathProcessor.addXStr("");
        }
        float f = sVArray.length > 1 ? SV.fValue(sVArray[1]) : Float.MAX_VALUE;
        Object object = sVArray.length > 2 ? SV.fValue(sVArray[2]) : Float.MAX_VALUE;
        float f2 = sVArray.length > 3 ? SV.fValue(sVArray[3]) : Float.MAX_VALUE;
        boolean bl5 = f2 != Float.MAX_VALUE || f != Float.MAX_VALUE && object == Float.MAX_VALUE;
        boolean bl6 = bl = object != Float.MAX_VALUE;
        if (!bl && string.length() == 0) {
            f2 = f;
            map = (Map<String, Object>)this.vwr.getCurrentColorRange();
            f = (float)map[0];
            object = map[1];
        }
        if (bl2) {
            map = string.substring(1);
            Object[] objectArray = new Object[2];
            objectArray[0] = map;
            Object[] objectArray2 = objectArray;
            if (!this.vwr.shm.getShapePropertyData(24, "colorEncoder", objectArray2)) {
                return scriptMathProcessor.addXStr("");
            }
            colorEncoder = (ColorEncoder)objectArray2[1];
        } else {
            colorEncoder.setRange(f, (float)object, f > object);
        }
        map = colorEncoder.getColorKey();
        if (bl5) {
            return scriptMathProcessor.addXPt(CU.colorPtFromInt(colorEncoder.getArgb(object == Float.MAX_VALUE ? f : f2), null));
        }
        return scriptMathProcessor.addX(SV.getVariableMap(map));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean evaluateCompare(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 2 || sVArray.length > 5) {
            return false;
        }
        String string = SV.sValue(sVArray[sVArray.length - 1]);
        boolean bl = string.equalsIgnoreCase("stddev");
        boolean bl2 = string.equalsIgnoreCase("ISOMER");
        boolean bl3 = string.equalsIgnoreCase("BONDS");
        boolean bl4 = !bl2 && sVArray.length > (bl ? 3 : 2);
        BS bS = sVArray[0].tok == 10 ? (BS)sVArray[0].value : null;
        BS bS2 = sVArray[1].tok == 10 ? (BS)sVArray[1].value : null;
        String string2 = bS == null ? SV.sValue(sVArray[0]) : "";
        String string3 = bS2 == null ? SV.sValue(sVArray[1]) : "";
        M4 m4 = new M4();
        float f = Float.NaN;
        try {
            if (bl4 && (bS == null || bS2 == null)) {
                return false;
            }
            if (bl3) {
                if (sVArray.length != 4) {
                    return false;
                }
                string2 = SV.sValue(sVArray[2]);
                bl4 = string2.equalsIgnoreCase("SMILES");
                try {
                    if (bl4) {
                        string2 = this.vwr.getSmiles(bS);
                    }
                }
                catch (Exception exception) {
                    this.e.evalError(exception.getMessage(), null);
                }
                float[] fArray = this.e.getSmilesExt().getFlexFitList(bS, bS2, string2, !bl4);
                return fArray == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXAF(fArray);
            }
            if (bl2) {
                boolean bl5;
                String string4;
                if (sVArray.length != 3) {
                    return false;
                }
                if (bS == null && bS2 == null) {
                    return scriptMathProcessor.addXStr(this.vwr.getSmilesMatcher().getRelationship(string2, string3).toUpperCase());
                }
                String string5 = bS == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string2, false) : JmolMolecule.getMolecularFormulaAtoms(this.vwr.ms.at, bS, null, false);
                String string6 = string4 = bS2 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string3, false) : JmolMolecule.getMolecularFormulaAtoms(this.vwr.ms.at, bS2, null, false);
                if (!string5.equals(string4)) {
                    return scriptMathProcessor.addXStr("NONE");
                }
                if (bS != null) {
                    string2 = (String)this.e.getSmilesExt().getSmilesMatches("/strict///", null, bS, null, 1, true, false);
                }
                if (bS2 == null) {
                    bl5 = this.vwr.getSmilesMatcher().areEqual(string3, string2) > 0;
                } else {
                    string3 = (String)this.e.getSmilesExt().getSmilesMatches("/strict///", null, bS2, null, 1, true, false);
                    boolean bl6 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches("/strict///" + string2, null, bS2, null, 1, true, false)).nextSetBit(0) >= 0;
                }
                if (!bl5) {
                    String string7 = String.valueOf(string2) + string3;
                    if (string7.indexOf("/") >= 0 || string7.indexOf("\\") >= 0 || string7.indexOf("@") >= 0) {
                        if (string2.indexOf("@") >= 0 && (bS2 != null || string3.indexOf("@") >= 0) && string2.indexOf("@SP") < 0) {
                            int n = string2.toLowerCase().indexOf("invertstereo");
                            String string8 = string2 = n >= 0 ? "/strict/" + string2.substring(0, n) + string2.substring(n + 12) : "/invertstereo strict/" + string2;
                            if (bS2 == null) {
                                bl5 = this.vwr.getSmilesMatcher().areEqual(string2, string3) > 0;
                            } else {
                                boolean bl7 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, 1, true, false)).nextSetBit(0) >= 0;
                            }
                            if (bl5) {
                                return scriptMathProcessor.addXStr("ENANTIOMERS");
                            }
                        }
                        if (bS2 == null) {
                            bl5 = this.vwr.getSmilesMatcher().areEqual("/nostereo/" + string3, string2) > 0;
                        } else {
                            Object object = this.e.getSmilesExt().getSmilesMatches("/nostereo/" + string2, null, bS2, null, 1, true, false);
                            boolean bl8 = bl5 = ((BS)object).nextSetBit(0) >= 0;
                        }
                        if (bl5) {
                            return scriptMathProcessor.addXStr("DIASTEREOMERS");
                        }
                    }
                    return scriptMathProcessor.addXStr("CONSTITUTIONAL ISOMERS");
                }
                if (bS == null || bS2 == null) {
                    return scriptMathProcessor.addXStr("IDENTICAL");
                }
                f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string2, null, null, null, null, false, null, null, false, 1);
                return scriptMathProcessor.addXStr(f < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + f + ")");
            }
            if (bl4) {
                boolean bl9;
                boolean bl10;
                Lst<P3> lst = new Lst<P3>();
                Lst<P3> lst2 = new Lst<P3>();
                string = SV.sValue(sVArray[2]);
                boolean bl11 = string.equalsIgnoreCase("MAP");
                bl4 = string.equalsIgnoreCase("SMILES");
                boolean bl12 = bl10 = bl11 || string.equalsIgnoreCase("SMARTS");
                if (bl4 || bl10) {
                    string = sVArray.length > (bl ? 4 : 3) ? SV.sValue(sVArray[3]) : null;
                }
                boolean bl13 = "H".equalsIgnoreCase(string) || "allH".equalsIgnoreCase(string) || "bestH".equalsIgnoreCase(string);
                boolean bl14 = "polyhedra".equalsIgnoreCase(string);
                if (bl14) {
                    string = sVArray.length > (bl ? 5 : 4) ? SV.sValue(sVArray[4]) : null;
                }
                boolean bl15 = "all".equalsIgnoreCase(string) || "allH".equalsIgnoreCase(string);
                boolean bl16 = bl9 = "best".equalsIgnoreCase(string) || "bestH".equalsIgnoreCase(string);
                if ("stddev".equals(string)) {
                    string = null;
                }
                String string9 = string;
                if (string == null || bl13 || bl15 || bl9) {
                    if (!bl11 && !bl4 || bl13 && bl14) {
                        return false;
                    }
                    string9 = "/noaromatic" + (bl15 || bl9 ? "/" : " nostereo/") + this.e.getSmilesExt().getSmilesMatches(bl13 ? "H" : "", null, bS, null, 1, true, false);
                } else {
                    bl15 = true;
                }
                f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string9, lst, lst2, m4, null, bl11, null, null, bl9, (bl4 ? 1 : 2) | (!bl15 && !bl9 ? 8 : 0));
                if (bl11) {
                    int n = lst.size();
                    if (n == 0) {
                        return scriptMathProcessor.addXStr("");
                    }
                    int n2 = lst2.size() / n;
                    Lst<int[][]> lst3 = new Lst<int[][]>();
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < n2) {
                        int[][] nArray = AU.newInt2(n);
                        lst3.addLast(nArray);
                        int n5 = 0;
                        while (n5 < n) {
                            nArray[n5] = new int[]{((Atom)lst.get((int)n5)).i, ((Atom)lst2.get((int)n4)).i};
                            ++n5;
                            ++n4;
                        }
                        ++n3;
                    }
                    return bl15 ? scriptMathProcessor.addXList(lst3) : (lst3.size() > 0 ? scriptMathProcessor.addXAII((int[][])lst3.get(0)) : scriptMathProcessor.addXStr(""));
                }
            } else {
                switch (sVArray.length) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bl) break;
                    }
                    default: {
                        return false;
                    }
                }
                Lst<P3> lst = this.e.getPointVector(sVArray[0], 0);
                Lst<P3> lst4 = this.e.getPointVector(sVArray[1], 0);
                if (lst != null && lst4 != null) {
                    Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
                    f = Measure.getTransformMatrix4(lst, lst4, m4, null);
                }
            }
            return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4.round(1.0E-7f));
        }
        catch (Exception exception) {
            this.e.evalError(exception.getMessage() == null ? exception.toString() : exception.getMessage(), null);
            return false;
        }
    }

    private boolean evaluateConnected(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, int n2) throws ScriptException {
        if (sVArray.length > 5) {
            return false;
        }
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = 0.0f;
        float f4 = Float.MAX_VALUE;
        int n3 = 65535;
        BS bS = null;
        BS bS2 = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 1275203608: {
                Object[] objectArray;
                int n4 = Integer.MIN_VALUE;
                String string = null;
                if (sVArray.length > 0) {
                    switch (sVArray[0].tok) {
                        case 2: {
                            n4 = sVArray[0].intValue;
                            break;
                        }
                        case 4: {
                            string = SV.sValue(sVArray[0]);
                        }
                    }
                }
                if (n2 == 1275203608) {
                    bS = SV.getBitSet(scriptMathProcessor.getX(), true);
                }
                if (!this.vwr.shm.getShapePropertyData(21, "getCenters", objectArray = new Object[]{n4, string, bS})) {
                    objectArray[1] = null;
                }
                return scriptMathProcessor.addXBs(objectArray[1] == null ? new BS() : (BS)objectArray[1]);
            }
            case 1228931587: {
                SV sV = scriptMathProcessor.getX();
                if (sV.tok != 10 || sVArray.length != 1 || sVArray[0].tok != 10) {
                    return false;
                }
                bS = (BS)sV.value;
                bS2 = (BS)sVArray[0].value;
                Lst<Integer> lst = new Lst<Integer>();
                Atom[] atomArray = this.vwr.ms.at;
                int n5 = bS.nextSetBit(0);
                while (n5 >= 0) {
                    int n6 = 0;
                    Bond[] bondArray = atomArray[n5].bonds;
                    int n7 = bondArray.length;
                    while (--n7 >= 0) {
                        if (!bS2.get(bondArray[n7].getOtherAtom((Atom)atomArray[n5]).i)) continue;
                        ++n6;
                    }
                    lst.addLast(n6);
                    n5 = bS.nextSetBit(n5 + 1);
                }
                return scriptMathProcessor.addXList(lst);
            }
        }
        int n8 = 0;
        while (n8 < sVArray.length) {
            SV sV = sVArray[n8];
            switch (sV.tok) {
                case 10: {
                    bl2 = sV.value instanceof BondSet;
                    if (bl2 && bS != null) {
                        return false;
                    }
                    if (bS == null) {
                        bS = (BS)sV.value;
                        break;
                    }
                    if (bS2 == null) {
                        bS2 = (BS)sV.value;
                        break;
                    }
                    return false;
                }
                case 4: {
                    String string = SV.sValue(sV);
                    n3 = string.equalsIgnoreCase("hbond") ? 30720 : ScriptParam.getBondOrderFromString(string);
                    if (n3 != 131071) break;
                    return false;
                }
                case 3: {
                    bl = true;
                }
                default: {
                    int n9 = sV.asInt();
                    float f5 = sV.asFloat();
                    if (f2 != 2.1474836E9f) {
                        return false;
                    }
                    if (f == -2.1474836E9f) {
                        f = Math.max(n9, 0);
                        f3 = f5;
                        break;
                    }
                    f2 = n9;
                    f4 = f5;
                }
            }
            ++n8;
        }
        if (f == -2.1474836E9f) {
            f = 1.0f;
            f2 = 100.0f;
            f3 = 0.1f;
            f4 = 1.0E8f;
        } else if (f2 == 2.1474836E9f) {
            f2 = f;
            f4 = f3;
            f3 = 0.1f;
        }
        if (bS == null) {
            bS = this.vwr.getAllAtoms();
        }
        if (bl && bS2 == null) {
            bS2 = bS;
        }
        if (bS2 != null) {
            BS bS3 = new BS();
            this.vwr.makeConnections(f3, f4, n3, 1086324745, bS, bS2, bS3, bl2, false, 0.0f);
            return scriptMathProcessor.addX(SV.newV(10, BondSet.newBS(bS3, this.vwr.ms.getAtomIndices(this.vwr.ms.getAtoms(1677721602, bS3)))));
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsConnected(f, f2, n3, bS));
    }

    private boolean evaluateContact(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length < 1 || sVArray.length > 3) {
            return false;
        }
        int n = 0;
        float f = 100.0f;
        int n2 = sVArray[0].tok;
        switch (n2) {
            case 2: 
            case 3: {
                f = SV.fValue(sVArray[n++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (n == sVArray.length || !(sVArray[n].value instanceof BS)) {
            return false;
        }
        BS bS = BSUtil.copy((BS)sVArray[n++].value);
        BS bS2 = n < sVArray.length ? BSUtil.copy((BS)sVArray[n].value) : null;
        RadiusData radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        bS2 = this.setContactBitSets(bS, bS2, true, Float.NaN, radiusData, false);
        bS2.or(bS);
        return scriptMathProcessor.addXBs(bS2);
    }

    private boolean evaluateData(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        String string = sVArray.length == 0 ? "" : SV.sValue(sVArray[0]);
        String string2 = "";
        switch (sVArray.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (sVArray[0].tok != 10) break;
                return scriptMathProcessor.addXStr(this.vwr.getModelFileData(string, SV.sValue(sVArray[1]), sVArray.length == 3 && SV.bValue(sVArray[2])));
            }
            case 4: {
                int n = sVArray[1].asInt();
                int n2 = sVArray[2].asInt();
                int n3 = sVArray[3].asInt();
                float[] fArray = Parser.parseFloatArrayFromMatchAndField(SV.sValue(sVArray[0]), null, 0, 0, null, n, n2, null, n3);
                return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray, false));
            }
            default: {
                return false;
            }
        }
        if (string.indexOf("data2d_") == 0) {
            float[][] fArray = (float[][])this.vwr.getDataObj(string, null, 2);
            if (fArray == null) {
                return scriptMathProcessor.addXStr("");
            }
            if (sVArray.length == 2 && sVArray[1].tok == 2) {
                int n = sVArray[1].intValue;
                if (n < 0) {
                    n += fArray.length;
                }
                if (n >= 0 && n < fArray.length) {
                    return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray[n], false));
                }
                return scriptMathProcessor.addXStr("");
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatAA(fArray, false));
        }
        if (string.indexOf("property_") == 0) {
            float[] fArray;
            float[] fArray2 = (float[])this.vwr.getDataObj(string, null, 1);
            if (fArray2 == null) {
                return scriptMathProcessor.addXStr("");
            }
            float[] fArray3 = fArray = string2.indexOf("property_") == 0 ? (float[])this.vwr.getDataObj(string, null, 1) : null;
            if (fArray != null) {
                fArray2 = AU.arrayCopyF(fArray2, -1);
                int n = Math.min(fArray2.length, fArray.length);
                while (--n >= 0) {
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + fArray[n];
                }
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray2, false));
        }
        Object[] objectArray = (Object[])this.vwr.getDataObj(string, null, -1);
        return scriptMathProcessor.addXStr(objectArray == null ? "" : "" + objectArray[1]);
    }

    private boolean evaluateDotDist(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, int n2) throws ScriptException {
        float f;
        block36: {
            SV sV;
            SV sV2;
            boolean bl = n == 1275069443;
            SV sV3 = null;
            switch (sVArray.length) {
                case 2: {
                    if (n2 == Integer.MAX_VALUE) {
                        sV2 = sVArray[0];
                        sV = sVArray[1];
                        break;
                    }
                    sV3 = sVArray[1];
                }
                case 1: {
                    sV2 = scriptMathProcessor.getX();
                    sV = sVArray[0];
                    break;
                }
                default: {
                    return false;
                }
            }
            if (n == 1275069442) {
                P3 p3 = P3.newP(scriptMathProcessor.ptValue(sV2, null));
                p3.cross(p3, scriptMathProcessor.ptValue(sV, null));
                return scriptMathProcessor.addXPt(p3);
            }
            P3 p3 = sV.tok == 7 ? null : scriptMathProcessor.ptValue(sV, null);
            P4 p4 = scriptMathProcessor.planeValue(sV);
            f = Float.NaN;
            try {
                if (bl) {
                    int n3 = n2 == Integer.MIN_VALUE ? 0 : n2 & 0x1E0;
                    boolean bl2 = n3 == 32 || n3 == 64;
                    boolean bl3 = n3 == 480;
                    switch (sV2.tok) {
                        case 7: 
                        case 10: {
                            boolean bl4 = sV2.tok == 10;
                            boolean bl5 = sV.tok == 10;
                            boolean bl6 = sV.tok == 8;
                            BS bS = bl4 ? (BS)sV2.value : null;
                            BS bS2 = bl5 ? (BS)sV.value : null;
                            Lst<SV> lst = bl4 ? null : sV2.getList();
                            Lst<SV> lst2 = bl5 ? null : sV.getList();
                            boolean bl7 = bl2 && sV3 != null && sV3.asBoolean();
                            switch (sV.tok) {
                                case 7: 
                                case 8: 
                                case 10: {
                                    Atom[] atomArray = this.vwr.ms.at;
                                    if (bl7) {
                                        float f2 = Float.NaN;
                                        int n4 = Integer.MAX_VALUE;
                                        if (bl4) {
                                            int n5 = bS.nextSetBit(0);
                                            while (n5 >= 0) {
                                                float f3;
                                                float f4 = f3 = bl6 ? atomArray[n5].distanceSquared(p3) : ((Float)this.e.getBitsetProperty(bS2, (Lst)lst2, n2, (P3)atomArray[n5], p4, sV2.value, (Object)null, false, sV2.index, false)).floatValue();
                                                if (!(n3 == 32 ? f3 >= f2 : f3 <= f2)) {
                                                    f2 = f3;
                                                    n4 = n5;
                                                }
                                                n5 = bS.nextSetBit(n5 + 1);
                                            }
                                            return scriptMathProcessor.addXBs(n4 == Integer.MAX_VALUE ? new BS() : BSUtil.newAndSetBit(n4));
                                        }
                                        int n6 = lst.size();
                                        while (--n6 >= 0) {
                                            float f5;
                                            P3 p32 = SV.ptValue((SV)lst.get(n6));
                                            float f6 = f5 = bl6 ? p32.distanceSquared(p3) : ((Float)this.e.getBitsetProperty(bS2, (Lst)lst2, n2, p32, p4, sV2.value, (Object)null, false, Integer.MAX_VALUE, false)).floatValue();
                                            if (n3 == 32 ? f5 >= f2 : f5 <= f2) continue;
                                            f2 = f5;
                                            n4 = n6;
                                        }
                                        return scriptMathProcessor.addXInt(n4);
                                    }
                                    if (bl3) {
                                        if (bS2 == null) {
                                            float[] fArray = new float[bS.cardinality()];
                                            int n7 = 0;
                                            int n8 = bS.nextSetBit(0);
                                            while (n8 >= 0) {
                                                fArray[n7] = atomArray[n8].distance(p3);
                                                n8 = bS.nextSetBit(n8 + 1);
                                                ++n7;
                                            }
                                            return scriptMathProcessor.addXAF(fArray);
                                        }
                                        float[][] fArray = new float[bS.cardinality()][bS2.cardinality()];
                                        int n9 = 0;
                                        int n10 = bS.nextSetBit(0);
                                        while (n10 >= 0) {
                                            int n11 = 0;
                                            int n12 = bS2.nextSetBit(0);
                                            while (n12 >= 0) {
                                                fArray[n9][n11] = atomArray[n10].distance(atomArray[n12]);
                                                n12 = bS2.nextSetBit(n12 + 1);
                                                ++n11;
                                            }
                                            n10 = bS.nextSetBit(n10 + 1);
                                            ++n9;
                                        }
                                        return scriptMathProcessor.addXAFF(fArray);
                                    }
                                    if (bl2) {
                                        float[] fArray = new float[bl4 ? bS.cardinality() : lst.size()];
                                        if (bl4) {
                                            int n13 = bS.nextSetBit(0);
                                            int n14 = 0;
                                            while (n13 >= 0) {
                                                fArray[n14++] = ((Float)this.e.getBitsetProperty(bS2, (Lst)lst2, n2, (P3)atomArray[n13], p4, sV2.value, (Object)null, false, sV2.index, false)).floatValue();
                                                n13 = bS.nextSetBit(n13 + 1);
                                            }
                                            return scriptMathProcessor.addXAF(fArray);
                                        }
                                        int n15 = fArray.length;
                                        while (--n15 >= 0) {
                                            fArray[n15] = ((Float)this.e.getBitsetProperty(bS2, (Lst)lst2, n2, SV.ptValue((SV)lst.get(n15)), p4, (Object)null, (Object)null, false, Integer.MAX_VALUE, false)).floatValue();
                                        }
                                        return scriptMathProcessor.addXAF(fArray);
                                    }
                                    return scriptMathProcessor.addXObj(this.e.getBitsetProperty(bS, (Lst)lst, n2, p3, p4, sV2.value, (Object)null, false, sV2.index, false));
                                }
                            }
                        }
                    }
                }
                P3 p33 = scriptMathProcessor.ptValue(sV2, null);
                P4 p42 = scriptMathProcessor.planeValue(sV2);
                if (bl) {
                    if (p4 != null && sV3 != null) {
                        f = Measure.directedDistanceToPlane(p33, p4, SV.ptValue(sV3));
                        break block36;
                    }
                    f = p42 == null ? (p4 == null ? p3.distance(p33) : Measure.distanceToPlane(p4, p33)) : Measure.distanceToPlane(p42, p3);
                    break block36;
                }
                if (p42 != null && p4 != null) {
                    f = p42.x * p4.x + p42.y * p4.y + p42.z * p4.z + p42.w * p4.w;
                } else {
                    if (p42 != null) {
                        p33 = P3.new3(p42.x, p42.y, p42.z);
                    } else if (p4 != null) {
                        p3 = P3.new3(p4.x, p4.y, p4.z);
                    }
                    f = p33.dot(p3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return scriptMathProcessor.addXFloat(f);
    }

    private boolean evaluateHelix(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length > 2 ? 3 : 1;
        String string = n >= sVArray.length ? "array" : SV.sValue(sVArray[n]);
        int n2 = T.getTokFromName(string);
        if (sVArray.length > 2) {
            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], null);
            P3 p32 = scriptMathProcessor.ptValue(sVArray[1], null);
            if (n2 == 0 || sVArray[2].tok != 9 || p3 == null || p32 == null) {
                return false;
            }
            Quat quat = Quat.newP4((P4)sVArray[2].value);
            T3[] t3Array = Measure.computeHelicalAxis(p3, p32, quat);
            return t3Array == null ? false : scriptMathProcessor.addXObj(Escape.escapeHelical(string, n2, p3, p32, t3Array));
        }
        BS bS = sVArray[0].value instanceof BS ? (BS)sVArray[0].value : this.vwr.ms.getAtoms(1094715412, new Integer(sVArray[0].asInt()));
        switch (n2) {
            case 134217751: 
            case 1073741854: 
            case 1665140738: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, n2));
            }
            case 0x8000001: {
                return scriptMathProcessor.addXFloat(((Float)this.getHelixData(bS, 0x8000001)).floatValue());
            }
            case 135176: 
            case 1745489939: {
                return scriptMathProcessor.addXObj(this.getHelixData(bS, n2));
            }
            case 1275068418: {
                String[] stringArray = (String[])this.getHelixData(bS, 1073742001);
                if (stringArray == null) {
                    return false;
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return false;
    }

    private Object getHelixData(BS bS, int n) {
        int n2 = bS.nextSetBit(0);
        return n2 < 0 ? "null" : this.vwr.ms.at[n2].group.getHelixData(n, this.vwr.getQuaternionFrame(), this.vwr.getInt(0x21000011));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean evaluateFind(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        boolean bl;
        boolean bl2;
        String string;
        String string2;
        int n;
        boolean bl3;
        SV sV;
        block57: {
            boolean bl4;
            sV = scriptMathProcessor.getX();
            bl3 = sV.tok == 7;
            n = sVArray.length == 0 ? 1 : 0;
            string2 = n != 0 ? "" : SV.sValue(sVArray[0]);
            string = sVArray.length > 1 && sVArray[1].tok != 1073742335 && sVArray[1].tok != 1073742334 && sVArray[1].tok != 10 ? SV.sValue(sVArray[1]) : "";
            bl2 = !bl3 && string2.equalsIgnoreCase("SEQUENCE");
            boolean bl5 = bl4 = !bl3 && string2.equalsIgnoreCase("SEQ");
            if (string2.toUpperCase().startsWith("SMILES/")) {
                String string3;
                if (!string2.endsWith("/")) {
                    string2 = String.valueOf(string2) + "/";
                }
                if (JC.isSmilesCanonical(string3 = String.valueOf(string2.substring(6)) + "//")) {
                    string = "SMILES";
                    string2 = "CHEMICAL";
                } else {
                    string2 = "SMILES";
                    string = String.valueOf(string3) + string;
                }
            } else if (string2.toUpperCase().startsWith("SMARTS/")) {
                if (!string2.endsWith("/")) {
                    string2 = String.valueOf(string2) + "/";
                }
                string = String.valueOf(string2.substring(6)) + (string.length() == 0 ? "//" : string);
                string2 = "SMARTS";
            }
            boolean bl6 = !bl3 && string2.equalsIgnoreCase("SMILES");
            boolean bl7 = !bl3 && string2.equalsIgnoreCase("SMARTS");
            boolean bl8 = !bl3 && string2.equalsIgnoreCase("CHEMICAL");
            boolean bl9 = !bl3 && string2.equalsIgnoreCase("MF");
            boolean bl10 = !bl3 && string2.equalsIgnoreCase("CELLFORMULA");
            SV sV2 = sVArray.length > 0 ? sVArray[sVArray.length - 1] : SV.vF;
            boolean bl11 = !bl3 && sV2.tok == 1073742335;
            try {
                if (bl8) {
                    BS bS = sV.tok == 10 ? (BS)sV.value : null;
                    String string4 = bS == null ? SV.sValue(sV) : this.vwr.getOpenSmiles(bS);
                    if ((string4 = (string4.length() == 0 ? "" : this.vwr.getChemicalInfo(string4, string.toLowerCase(), bS)).trim()).startsWith("InChI")) {
                        string4 = PT.rep(PT.rep(string4, "InChI=", ""), "InChIKey=", "");
                    }
                    return scriptMathProcessor.addXStr(string4);
                }
                if (!bl6 && !bl7 && sV.tok != 10) break block57;
                int n2 = bl6 || bl7 ? 2 : 1;
                BS bS = n2 < sVArray.length && sVArray[n2].tok == 10 ? (BS)sVArray[n2++].value : null;
                boolean bl12 = "bonds".equalsIgnoreCase(SV.sValue(sVArray[sVArray.length - 1]));
                boolean bl13 = bl12 || bl11;
                Lst<BS> lst = null;
                switch (sV.tok) {
                    case 4: {
                        String string5 = SV.sValue(sV);
                        if (bS != null || bl6 && sVArray.length == 1) {
                            return false;
                        }
                        if (string.equalsIgnoreCase("mf")) {
                            lst = this.vwr.getSmilesMatcher().getMolecularFormula(string5, bl7);
                            break;
                        }
                        String string6 = string;
                        boolean bl14 = true;
                        boolean bl15 = false;
                        switch (sVArray.length) {
                            case 4: {
                                bl14 = SV.bValue(sVArray[3]);
                            }
                            case 3: {
                                bl15 = SV.bValue(sVArray[2]);
                            }
                        }
                        boolean bl16 = !bl15 && (!bl14 || !bl7 && !string6.equals("chirality"));
                        try {
                            lst = this.e.getSmilesExt().getSmilesMatches(string6, string5, null, null, bl7 ? 2 : 1, !bl15, !bl14);
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getMessage());
                            return scriptMathProcessor.addXInt(-1);
                        }
                        if (!bl16) break;
                        int n3 = ((int[])lst).length;
                        return scriptMathProcessor.addXInt(!bl14 && n3 > 0 ? 1 : n3);
                    }
                    case 10: {
                        BS bS2 = (BS)sV.value;
                        if (bl9 && string.length() != 0) {
                            return scriptMathProcessor.addXBs(JmolMolecule.getBitSetForMF(this.vwr.ms.at, bS2, string));
                        }
                        if (bl9 || bl10) {
                            return scriptMathProcessor.addXStr(JmolMolecule.getMolecularFormulaAtoms(this.vwr.ms.at, bS2, bl9 ? null : this.vwr.ms.getCellWeights(bS2), bl11));
                        }
                        if (bl2 || bl4) {
                            boolean bl17 = sV2.asString().equalsIgnoreCase("H");
                            return scriptMathProcessor.addXStr(this.vwr.getSmilesOpt(bS2, -1, -1, ((bl13 |= bl17) ? 0x700000 | (bl17 ? 0x900000 : 0) : 0) | (bl4 ? 0x2100000 : 0x100000), null));
                        }
                        if (bl6 || bl7) {
                            string2 = sVArray.length > 1 && sVArray[1].tok == 10 ? this.vwr.getSmilesOpt((BS)sVArray[1].value, 0, 0, 0, string) : string;
                        }
                        string = string.toUpperCase();
                        BS bS3 = bS;
                        if (bl12) {
                            int[][] nArray = this.vwr.getSmilesMatcher().getCorrelationMaps(string2, this.vwr.ms.at, this.vwr.ms.ac, bS2, (bl6 ? 1 : 2) | 8);
                            lst = (Lst<BS>)(nArray.length > 0 ? (Object)this.vwr.ms.getDihedralMap(nArray[0]) : new int[]{});
                            break;
                        }
                        if (string.equalsIgnoreCase("map")) {
                            int[][] nArray = this.vwr.getSmilesMatcher().getCorrelationMaps(string2, this.vwr.ms.at, this.vwr.ms.ac, bS2, (bl6 ? 1 : 2) | 0x80);
                            lst = (Lst<BS>)nArray;
                            break;
                        }
                        if (string2.equalsIgnoreCase("crystalClass")) {
                            lst = this.vwr.ms.generateCrystalClass(bS2.nextSetBit(0), sVArray.length != 2 ? null : (sV2.tok == 10 ? this.vwr.ms.getAtomSetCenter((BS)sV2.value) : SV.ptValue(sV2)));
                            break;
                        }
                        int n4 = (bl6 ? (string.indexOf("OPEN") >= 0 ? 5 : 1) : 2) | (bl11 && string2.length() == 0 ? 0x1500000 : 0);
                        if (string.indexOf("/MOLECULE/") >= 0) {
                            JmolMolecule[] jmolMoleculeArray = this.vwr.ms.getMolecules();
                            Lst<BS> lst2 = new Lst<BS>();
                            int n5 = 0;
                            while (n5 < jmolMoleculeArray.length) {
                                BS bS4;
                                if (jmolMoleculeArray[n5].atomList.intersects(bS2) && !(bS4 = (BS)this.e.getSmilesExt().getSmilesMatches(string2, null, jmolMoleculeArray[n5].atomList, bS3, n4, !bl11, false)).isEmpty()) {
                                    lst2.addLast(bS4);
                                }
                                ++n5;
                            }
                            lst = lst2;
                            break;
                        }
                        lst = this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, bS3, n4, !bl11, false);
                    }
                }
                if (lst == null) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(lst);
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
        }
        boolean bl18 = string.indexOf("v") >= 0;
        boolean bl19 = string.indexOf("i") >= 0;
        boolean bl20 = string.indexOf("m") >= 0;
        boolean bl21 = string2.length() == 0;
        boolean bl22 = bl = !bl21 && sVArray.length == 2;
        if (bl3 || bl) {
            int n6;
            int n7;
            Lst<SV> lst;
            JmolPatternMatcher jmolPatternMatcher = bl ? this.getPatternMatcher() : null;
            Pattern pattern = null;
            Lst<SV> lst3 = lst = bl3 ? sV.getList() : null;
            if (bl) {
                try {
                    pattern = jmolPatternMatcher.compile(string2, bl19);
                }
                catch (Exception exception) {
                    this.e.evalError(exception.toString(), null);
                }
            }
            String[] stringArray = bl21 ? null : SV.strListValue(sV);
            int n8 = n7 = bl21 ? lst.size() : stringArray.length;
            if (Logger.debugging) {
                Logger.debug("finding " + string2);
            }
            BS bS = new BS();
            int n9 = 0;
            Matcher matcher = null;
            Lst<String> lst4 = bl20 ? new Lst<String>() : null;
            String string7 = "";
            int n10 = 0;
            while (n10 < n7) {
                if (bl21) {
                    SV sV3 = (SV)lst.get(n10);
                    switch (sV3.tok) {
                        case 6: {
                            n6 = sV3.getMap().isEmpty() ^ n;
                            break;
                        }
                        case 7: {
                            n6 = (sV3.getList().size() == 0 ? 1 : 0) ^ n;
                            break;
                        }
                        case 4: {
                            n6 = (sV3.asString().length() == 0 ? 1 : 0) ^ n;
                            break;
                        }
                        default: {
                            n6 = 1;
                            break;
                        }
                    }
                } else if (bl) {
                    string7 = stringArray[n10];
                    matcher = pattern.matcher(string7);
                    n6 = matcher.find() ? 1 : 0;
                } else {
                    int n11 = n6 = SV.sValue((T)lst.get(n10)).indexOf(string2) >= 0 ? 1 : 0;
                }
                if (bl20 && n6 != 0 || !bl20 && n6 == (bl18 ? 0 : 1)) {
                    ++n9;
                    bS.set(n10);
                    if (bl20) {
                        lst4.addLast(bl18 ? String.valueOf(string7.substring(0, matcher.start())) + string7.substring(matcher.end()) : matcher.group());
                    }
                }
                ++n10;
            }
            if (!bl3) {
                return bl20 ? scriptMathProcessor.addXStr(lst4.size() == 1 ? (String)lst4.get(0) : "") : (bl18 ? scriptMathProcessor.addXBool(n9 == 1) : (bl20 ? scriptMathProcessor.addXStr(n9 == 0 ? "" : matcher.group()) : scriptMathProcessor.addXInt(n9 == 0 ? 0 : matcher.start() + 1)));
            }
            if (bl20) {
                String[] stringArray2 = new String[n9];
                if (n9 > 0) {
                    n6 = stringArray.length;
                    while (--n6 >= 0) {
                        if (!bS.get(n6)) continue;
                        String string8 = stringArray2[n9] = bl20 ? (String)lst4.get(--n9) : stringArray[n6];
                    }
                }
                return scriptMathProcessor.addXAS(stringArray2);
            }
            Lst<SV> lst5 = new Lst<SV>();
            n6 = bS.nextSetBit(0);
            while (n6 >= 0) {
                lst5.addLast((SV)lst.get(n6));
                n6 = bS.nextSetBit(n6 + 1);
            }
            return scriptMathProcessor.addXList(lst5);
        }
        if (bl2) {
            return scriptMathProcessor.addXStr(this.vwr.getJBR().toStdAmino3(SV.sValue(sV)));
        }
        return scriptMathProcessor.addXInt(SV.sValue(sV).indexOf(string2) + 1);
    }

    private boolean evaluateGetProperty(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, boolean bl) throws ScriptException {
        int n2;
        Object object;
        String string;
        int n3;
        boolean bl2 = bl && n == 1275082245;
        boolean bl3 = n == 1275068449;
        int n4 = 0;
        int n5 = n3 = sVArray.length == 0 ? 0 : sVArray[0].tok;
        if (sVArray.length == 2 && (n3 == 7 || n3 == 6 || n3 == 14)) {
            return scriptMathProcessor.addXObj(this.vwr.extractProperty(sVArray[0].value, sVArray[1].value.toString(), -1));
        }
        BS bS = bl && sVArray.length == 1 && sVArray[0].tok == 10 ? (BS)sVArray[0].value : null;
        String string2 = string = bS == null && sVArray.length > 0 ? SV.sValue(sVArray[n4++]) : "";
        String string3 = string2.toLowerCase();
        if (!bl2 && string3.indexOf("[select ") < 0) {
            string2 = string3;
        }
        boolean bl4 = false;
        if (string2.equals("json") && sVArray.length > n4) {
            bl4 = true;
            string2 = SV.sValue(sVArray[n4++]);
        }
        SV sV = null;
        if (bl) {
            sV = scriptMathProcessor.getX();
            switch (sV.tok) {
                case 10: {
                    break;
                }
                case 4: {
                    String string4 = (String)sV.value;
                    Object[] objectArray = new Object[3];
                    if (string4.startsWith("$")) {
                        int n6 = this.vwr.shm.getShapeIdFromObjectName(string4 = string4.substring(1));
                        if (n6 >= 0) {
                            objectArray[0] = string4;
                            this.vwr.shm.getShapePropertyData(n6, "index", objectArray);
                            if (objectArray[1] != null && !string.equals("index")) {
                                int n7 = (Integer)objectArray[1];
                                objectArray[1] = this.vwr.shm.getShapePropertyIndex(n6, string.intern(), n7);
                            }
                        }
                    } else {
                        int n8 = JC.shapeTokenIndex(T.getTokFromName(string4));
                        if (n8 >= 0) {
                            objectArray[0] = string;
                            objectArray[1] = -1;
                            this.vwr.shm.getShapePropertyData(n8, string.intern(), objectArray);
                        }
                    }
                    return objectArray[1] == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXObj(objectArray[1]);
                }
                case 7: {
                    if (bS != null) {
                        Lst<SV> lst = sV.getList();
                        Lst<SV> lst2 = new Lst<SV>();
                        int n9 = bS.nextSetBit(0);
                        while (n9 >= 0) {
                            lst2.addLast((SV)lst.get(n9));
                            n9 = bS.nextSetBit(n9 + 1);
                        }
                        return scriptMathProcessor.addXList(lst2);
                    }
                }
                default: {
                    if (bl2) {
                        string2 = "[SELECT " + string2 + "]";
                    }
                    return scriptMathProcessor.addXObj(this.vwr.extractProperty(sV, string2, -1));
                }
            }
            if (!string3.startsWith("bondinfo") && !string3.startsWith("atominfo")) {
                string2 = "atomInfo." + string2;
            }
        }
        BS[] bSArray = "";
        if (string2.equalsIgnoreCase("fileContents") && sVArray.length > 2) {
            object = SV.sValue(sVArray[1]);
            n2 = 2;
            while (n2 < sVArray.length) {
                object = String.valueOf(object) + "|" + SV.sValue(sVArray[n2]);
                ++n2;
            }
            bSArray = object;
            n4 = sVArray.length;
        } else if (sVArray.length > n4) {
            switch (sVArray[n4].tok) {
                case 10: {
                    bSArray = sVArray[n4++].value;
                    if (!string2.equalsIgnoreCase("bondInfo") || sVArray.length <= n4 || sVArray[n4].tok != 10) break;
                    bSArray = new BS[]{(BS)bSArray, (BS)sVArray[n4].value};
                    break;
                }
                case 4: 
                case 6: {
                    if (!this.vwr.checkPropertyParameter(string2)) break;
                    bSArray = sVArray[n4++].value;
                }
            }
        }
        if (bl) {
            object = (BS)sV.value;
            n2 = ((BS)object).nextSetBit(0);
            if (n2 < 0) {
                return scriptMathProcessor.addXStr("");
            }
            bSArray = object;
        }
        if (bl3 && !bl) {
            string2 = "auxiliaryInfo.models." + string2;
        }
        string2 = PT.rep(string2, ".[", "[");
        object = this.vwr.getProperty(null, string2, bSArray);
        if (n4 < sVArray.length) {
            object = this.vwr.extractProperty(object, sVArray, n4);
        }
        return scriptMathProcessor.addXObj(bl4 ? SV.safeJSON("value", object) : (SV.isVariableType(object) ? object : Escape.toReadable(string2, object)));
    }

    private boolean evaluateFormat(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray, boolean bl) throws ScriptException {
        Lst<SV> lst;
        Lst<SV> lst2;
        String string;
        SV sV;
        SV sV2 = sV = sVArray.length < 2 || n == 1287653388 ? scriptMathProcessor.getX() : null;
        String string2 = sVArray.length == 0 ? "%U" : (string = sVArray[0].tok == 7 ? null : SV.sValue(sVArray[0]));
        if (!bl && sVArray.length > 0 && sV != null && sV.tok != 10 && string != null) {
            if (sVArray.length == 2) {
                lst2 = sV.getList();
                lst = sVArray[1].getList();
                if (lst2 == null || lst == null) {
                    return false;
                }
                sV = SV.getVariableList(this.getSublist(lst2, lst));
            }
            sVArray = new SV[]{sVArray[0], sV};
            sV = null;
        }
        if (sV == null) {
            int n2;
            int n3 = n2 = bl ? -1 : SV.getFormatType(string);
            if (n2 >= 0 && sVArray.length != 2) {
                return false;
            }
            if (n2 >= 0 || sVArray.length < 2 || sVArray[1].tok != 7) {
                lst = SV.format(sVArray, n2);
                return string.equalsIgnoreCase("json") ? scriptMathProcessor.addXStr((String)((Object)lst)) : scriptMathProcessor.addXObj(lst);
            }
            lst = sVArray[1].getList();
            SV[] sVArray2 = new SV[2];
            sVArray2[0] = sVArray[0];
            SV[] sVArray3 = sVArray2;
            String[] stringArray = new String[lst.size()];
            int n4 = stringArray.length;
            while (--n4 >= 0) {
                sVArray3[1] = (SV)lst.get(n4);
                stringArray[n4] = SV.format(sVArray3, n2).toString();
            }
            return scriptMathProcessor.addXAS(stringArray);
        }
        if (sV.tok == 7 && string == null) {
            lst2 = sV.getList();
            lst = sVArray[0].getList();
            Lst<SV> lst3 = this.getSublist(lst2, lst);
            return scriptMathProcessor.addXList(lst3);
        }
        lst2 = sV.tok == 10 ? (BS)sV.value : null;
        boolean bl2 = T.tokAttr(n, 480);
        return scriptMathProcessor.addXObj(string == null ? "" : (lst2 == null ? SV.sprintf(PT.formatCheck(string), sV) : this.e.getCmdExt().getBitsetIdent((BS)((Object)lst2), string, sV.value, true, sV.index, bl2)));
    }

    private Lst<SV> getSublist(Lst<SV> lst, Lst<SV> lst2) {
        Lst<SV> lst3 = new Lst<SV>();
        int n = 0;
        int n2 = lst.size();
        while (n < n2) {
            SV sV = (SV)lst.get(n);
            switch (sV.tok) {
                case 6: {
                    Map<String, SV> map = sV.getMap();
                    Lst<Object> lst4 = new Lst();
                    int n3 = 0;
                    int n4 = lst2.size();
                    while (n3 < n4) {
                        SV sV2 = map.get(SV.sValue((T)lst2.get(n3)));
                        lst4.addLast(sV2 == null ? SV.newS("") : sV2);
                        ++n3;
                    }
                    lst3.addLast(SV.getVariableList(lst4));
                    break;
                }
                case 7: {
                    Map<String, SV> map = new Hashtable<String, SV>();
                    Lst<Object> lst4 = sV.getList();
                    int n3 = 0;
                    int n4 = Math.min(lst4.size(), lst2.size());
                    while (n3 < n4) {
                        map.put(SV.sValue((T)lst2.get(n3)), (SV)lst4.get(n3));
                        ++n3;
                    }
                    lst3.addLast(SV.getVariable(map));
                }
            }
            ++n;
        }
        return lst3;
    }

    private boolean evaluateList(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        boolean bl;
        int n2 = sVArray.length;
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = sV.tok == 7;
        switch (n) {
            case 1275335685: {
                return n2 == 2 && scriptMathProcessor.addX(sV.pushPop(sVArray[0], sVArray[1])) || n2 == 1 && scriptMathProcessor.addX(sV.pushPop(null, sVArray[0]));
            }
            case 1275334681: {
                return n2 == 1 && scriptMathProcessor.addX(sV.pushPop(sVArray[0], null)) || n2 == 0 && scriptMathProcessor.addX(sV.pushPop(null, null));
            }
            case 1275069441: {
                if (n2 == 1 || n2 == 2) break;
                return false;
            }
            case 1275069446: 
            case 1275069447: {
                break;
            }
            default: {
                if (n2 == 1) break;
                return false;
            }
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (n2 == 2) {
            boolean bl3;
            String string = SV.sValue(sVArray[0]);
            SV sV2 = sVArray[1];
            if (n == 1275069441) {
                stringArray = bl2 ? SV.strListValue(sV) : PT.split(SV.sValue(sV), "\n");
                stringArray2 = sV2.tok == 7 ? SV.strListValue(sV2) : PT.split(SV.sValue(sV2), "\n");
                n2 = Math.max(stringArray.length, stringArray2.length);
                stringArray3 = new String[n2];
                int n3 = 0;
                while (n3 < n2) {
                    stringArray3[n3] = String.valueOf(n3 >= stringArray.length ? "" : stringArray[n3]) + string + (n3 >= stringArray2.length ? "" : stringArray2[n3]);
                    ++n3;
                }
                return scriptMathProcessor.addXAS(stringArray3);
            }
            if (sV2.tok != 1073742335) {
                return false;
            }
            Lst<SV> lst = sV.getList();
            boolean bl4 = bl3 = string.length() == 0;
            if (bl3) {
                string = ",";
            }
            if (n == 1275069446) {
                SV[] sVArray2 = new SV[lst.size()];
                int n4 = lst.size();
                while (--n4 >= 0) {
                    Lst<SV> lst2 = ((SV)lst.get(n4)).getList();
                    if (lst2 == null) {
                        sVArray2[n4] = (SV)lst.get(n4);
                        continue;
                    }
                    SB sB = new SB();
                    int n5 = 0;
                    int n6 = lst2.size();
                    while (n5 < n6) {
                        if (n5 > 0) {
                            sB.append(string);
                        }
                        SV sV3 = (SV)lst2.get(n5);
                        sB.append(bl3 && sV3.tok == 4 ? "\"" + PT.rep((String)sV3.value, "\"", "\"\"") + "\"" : sV3.asString());
                        ++n5;
                    }
                    sVArray2[n4] = SV.newS(sB.toString());
                }
                return scriptMathProcessor.addXAV(sVArray2);
            }
            Lst<SV> lst3 = new Lst<SV>();
            if (bl3) {
                string = "\u0000";
            }
            int[] nArray = new int[2];
            int n7 = 0;
            int n8 = lst.size();
            while (n7 < n8) {
                Object object;
                String string2 = ((SV)lst.get(n7)).asString();
                if (bl3) {
                    nArray[1] = 0;
                    nArray[0] = 0;
                    int n9 = 0;
                    while (true) {
                        if ((object = PT.getCSVString(string2, nArray)) == null) {
                            if (nArray[1] == -1) {
                                string2 = String.valueOf(string2) + (++n7 < n8 ? "\n" + ((SV)lst.get(n7)).asString() : "\"");
                                nArray[1] = n9;
                                continue;
                            }
                            string2 = String.valueOf(string2.substring(0, n9)) + string2.substring(n9).replace(',', '\u0000');
                            break;
                        }
                        string2 = String.valueOf(string2.substring(0, n9)) + string2.substring(n9, nArray[0]).replace(',', '\u0000') + (String)object + string2.substring(nArray[1]);
                        nArray[1] = n9 = nArray[0] + ((String)object).length();
                    }
                }
                String[] stringArray4 = string2.split(string);
                object = new Lst();
                int n10 = 0;
                int n11 = stringArray4.length;
                while (n10 < n11) {
                    block52: {
                        String string3;
                        block53: {
                            string3 = stringArray4[n10];
                            if (string3.indexOf(".") < 0) {
                                try {
                                    ((Lst)object).addLast(SV.newI(Integer.parseInt(string3)));
                                    break block52;
                                }
                                catch (Exception exception) {
                                    break block53;
                                }
                            }
                            try {
                                ((Lst)object).addLast(SV.getVariable(Float.valueOf(Float.parseFloat(string3))));
                                break block52;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ((Lst)object).addLast(SV.newS(string3));
                    }
                    ++n10;
                }
                lst3.addLast(SV.getVariableList(object));
                ++n7;
            }
            return scriptMathProcessor.addXObj(SV.getVariableList(lst3));
        }
        SV sV4 = n2 == 0 ? SV.newV(1073742327, "all") : sVArray[0];
        boolean bl5 = bl = sV4.tok == 1073742327;
        if (!bl2 && sV.tok != 4) {
            return scriptMathProcessor.binaryOp(this.opTokenFor(n), sV, sV4);
        }
        boolean bl6 = SV.isScalar(sV);
        boolean bl7 = SV.isScalar(sV4);
        float[] fArray = null;
        float[] fArray2 = null;
        Lst<SV> lst = sV.getList();
        Lst<SV> lst4 = sV4.getList();
        if (bl2) {
            n2 = lst.size();
        } else if (bl6) {
            n2 = Integer.MAX_VALUE;
        } else {
            stringArray = PT.split(SV.sValue(sV), "\n");
            n2 = stringArray.length;
            fArray = new float[n2];
            PT.parseFloatArrayData(stringArray, fArray);
        }
        if (bl && n != 1275069446) {
            float f = 0.0f;
            if (bl2) {
                int n12 = n2;
                while (--n12 >= 0) {
                    f += SV.fValue((T)lst.get(n12));
                }
            } else if (!bl6) {
                int n13 = n2;
                while (--n13 >= 0) {
                    f += fArray[n13];
                }
            }
            return scriptMathProcessor.addXFloat(f);
        }
        if (n == 1275069446 && sV4.tok == 4) {
            SB sB = new SB();
            if (bl6) {
                sB.append(SV.sValue(sV));
            } else {
                String string = bl ? "" : sV4.value.toString();
                int n14 = 0;
                while (n14 < n2) {
                    sB.append(n14 > 0 ? string : "").append(SV.sValue((T)lst.get(n14)));
                    ++n14;
                }
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        SV sV5 = null;
        if (bl7) {
            sV5 = sV4;
        } else if (sV4.tok == 7) {
            n2 = Math.min(n2, lst4.size());
        } else {
            stringArray2 = PT.split(SV.sValue(sV4), "\n");
            fArray2 = new float[stringArray2.length];
            PT.parseFloatArrayData(stringArray2, fArray2);
            n2 = Math.min(n2, fArray2.length);
        }
        T t = this.opTokenFor(n);
        SV[] sVArray3 = new SV[n2];
        if (bl2 && bl) {
            Lst<SV> lst5 = new Lst<SV>();
            return scriptMathProcessor.addXList(this.addAllLists(sV.getList(), lst5));
        }
        SV sV6 = bl6 ? sV : null;
        int n15 = 0;
        while (n15 < n2) {
            SV sV7 = bl7 ? sV5 : (sV4.tok == 7 ? (SV)lst4.get(n15) : (Float.isNaN(fArray2[n15]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(stringArray2[n15])) : SV.newF(fArray2[n15])));
            if (!bl6) {
                sV6 = bl2 ? (SV)lst.get(n15) : (Float.isNaN(fArray[n15]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(stringArray[n15])) : SV.newF(fArray[n15]));
            }
            if (n == 1275069446 && sV6.tok != 7) {
                Lst<SV> lst6 = new Lst<SV>();
                lst6.addLast(sV6);
                sV6 = SV.getVariableList(lst6);
            }
            if (!scriptMathProcessor.binaryOp(t, sV6, sV7)) {
                return false;
            }
            sVArray3[n15] = scriptMathProcessor.getX();
            ++n15;
        }
        return scriptMathProcessor.addXAV(sVArray3);
    }

    private Lst<SV> addAllLists(Lst<SV> lst, Lst<SV> lst2) {
        int n = lst.size();
        int n2 = 0;
        while (n2 < n) {
            SV sV = (SV)lst.get(n2);
            if (sV.tok == 7) {
                this.addAllLists(sV.getList(), lst2);
            } else {
                lst2.addLast(sV);
            }
            ++n2;
        }
        return lst2;
    }

    private boolean evaluateLoad(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        boolean bl2;
        if (sVArray.length < 1 || sVArray.length > 3) {
            return false;
        }
        String string = FileManager.fixDOSName(SV.sValue(sVArray[0]));
        boolean bl3 = sVArray.length > 1 && sVArray[1].tok == 1073742335;
        boolean bl4 = this.vwr.async || sVArray.length > 2 && sVArray[sVArray.length - 1].tok == 1073742335;
        int n = sVArray.length > 1 && sVArray[1].tok == 2 ? sVArray[1].asInt() : -1;
        boolean bl5 = bl2 = sVArray.length > 1 && sVArray[1].asString().equalsIgnoreCase("JSON");
        if (bl3) {
            return scriptMathProcessor.addXMap(this.vwr.fm.getFileAsMap(string, null));
        }
        boolean bl6 = string.startsWith("?");
        if (Viewer.isJS && (bl6 || bl4)) {
            if (bl && bl6) {
                return scriptMathProcessor.addXStr("");
            }
            string = this.e.loadFileAsync("load()_", string, scriptMathProcessor.oPt, true);
        }
        String string2 = bl ? this.vwr.fm.getFilePath(string, false, false) : this.vwr.getFileAsString4(string, n, false, false, true, "script");
        try {
            return bl2 ? scriptMathProcessor.addXObj(this.vwr.parseJSON(string2)) : scriptMathProcessor.addXStr(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean evaluateMath(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) {
        if (n == 134217749) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return scriptMathProcessor.addXStr(new Date() + "\t" + SV.sValue(sVArray[0]));
            }
            return scriptMathProcessor.addXInt(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (sVArray.length == 0 ? 0 : sVArray[0].asInt()));
        }
        if (sVArray.length != 1) {
            return false;
        }
        if (n == 134218250) {
            if (sVArray[0].tok == 2) {
                return scriptMathProcessor.addXInt(Math.abs(sVArray[0].asInt()));
            }
            return scriptMathProcessor.addXFloat(Math.abs(sVArray[0].asFloat()));
        }
        double d = SV.fValue(sVArray[0]);
        switch (n) {
            case 0x8000202: {
                return scriptMathProcessor.addXFloat((float)(Math.acos(d) * 180.0 / Math.PI));
            }
            case 134218245: {
                return scriptMathProcessor.addXFloat((float)Math.cos(d * Math.PI / 180.0));
            }
            case 134218244: {
                return scriptMathProcessor.addXFloat((float)Math.sin(d * Math.PI / 180.0));
            }
            case 134218246: {
                return scriptMathProcessor.addXFloat((float)Math.sqrt(d));
            }
        }
        return false;
    }

    private boolean evaluateMeasure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1745489939: {
                Lst<Object> lst = new Lst<Object>();
                float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                boolean bl3 = false;
                RadiusData radiusData = null;
                int n4 = 0;
                float f = Float.MAX_VALUE;
                boolean bl4 = false;
                boolean bl5 = false;
                int n5 = 0;
                while (n5 < sVArray.length) {
                    switch (sVArray[n5].tok) {
                        case 10: {
                            BS bS = (BS)sVArray[n5].value;
                            if (bS.length() == 0) {
                                bl3 = true;
                            }
                            lst.addLast(bS);
                            ++n2;
                            ++n4;
                            break;
                        }
                        case 8: {
                            Point3fi point3fi = new Point3fi();
                            point3fi.setT((P3)sVArray[n5].value);
                            lst.addLast(point3fi);
                            ++n2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            fArray[n3++ % 2] = SV.fValue(sVArray[n5]);
                            break;
                        }
                        case 4: {
                            String string3 = SV.sValue(sVArray[n5]);
                            if (string3.equalsIgnoreCase("vdw") || string3.equalsIgnoreCase("vanderwaals")) {
                                f = (float)(n5 + 1 < sVArray.length && sVArray[n5 + 1].tok == 2 ? sVArray[++n5].asInt() : 100) / 100.0f;
                                break;
                            }
                            if (string3.equalsIgnoreCase("notConnected")) {
                                bl2 = true;
                                break;
                            }
                            if (string3.equalsIgnoreCase("connected")) {
                                bl = true;
                                break;
                            }
                            if (string3.equalsIgnoreCase("minArray")) {
                                bl4 = n4 >= 1;
                                break;
                            }
                            if (string3.equalsIgnoreCase("asArray")) {
                                bl5 = n4 >= 1;
                                break;
                            }
                            if (PT.isOneOf(string3.toLowerCase(), ";nm;nanometers;pm;picometers;angstroms;ang;au;") || string3.endsWith("hz")) {
                                string2 = string3.toLowerCase();
                                break;
                            }
                            string = String.valueOf(n2) + ":" + string3;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++n5;
                }
                if (n2 < 2 || n2 > 4 || n3 > 2 || bl2 && bl) {
                    return false;
                }
                if (bl3) {
                    return scriptMathProcessor.addXStr("");
                }
                if (f != Float.MAX_VALUE && (n4 != 2 || n2 != 2)) {
                    return scriptMathProcessor.addXStr("");
                }
                radiusData = f == Float.MAX_VALUE ? new RadiusData(fArray, 0.0f, null, null) : new RadiusData(null, f, RadiusData.EnumType.FACTOR, VDW.AUTO);
                return scriptMathProcessor.addXObj(this.vwr.newMeasurementData(null, lst).set(0, null, radiusData, string, string2, null, bl, bl2, null, true, 0, (short)0, null).getMeasurements(bl5, bl4));
            }
            case 0x8000001: {
                n2 = sVArray.length;
                if (n2 == 3 || n2 == 4) break;
                return false;
            }
            default: {
                n2 = sVArray.length;
                if (n2 == 2) break;
                return false;
            }
        }
        P3[] p3Array = new P3[n2];
        int n6 = 0;
        while (n6 < n2) {
            p3Array[n6] = scriptMathProcessor.ptValue(sVArray[n6], null);
            if (p3Array[n6] == null) {
                return false;
            }
            ++n6;
        }
        switch (n2) {
            case 2: {
                return scriptMathProcessor.addXFloat(p3Array[0].distance(p3Array[1]));
            }
            case 3: {
                return scriptMathProcessor.addXFloat(Measure.computeAngleABC(p3Array[0], p3Array[1], p3Array[2], true));
            }
            case 4: {
                return scriptMathProcessor.addXFloat(Measure.computeTorsion(p3Array[0], p3Array[1], p3Array[2], p3Array[3], true));
            }
        }
        return false;
    }

    private boolean evaluateModulation(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string = "";
        float f = Float.NaN;
        P3 p3 = null;
        block0 : switch (sVArray.length) {
            case 0: {
                break;
            }
            case 1: {
                switch (sVArray[0].tok) {
                    case 8: {
                        p3 = (P3)sVArray[0].value;
                        break block0;
                    }
                    case 4: {
                        string = sVArray[0].asString();
                        break block0;
                    }
                }
                f = SV.fValue(sVArray[0]);
                break;
            }
            case 2: {
                string = SV.sValue(sVArray[0]);
                f = SV.fValue(sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        if (p3 == null && (double)f < 1000000.0) {
            p3 = P3.new3(f, f, f);
        }
        SV sV = scriptMathProcessor.getX();
        BS bS = sV.tok == 10 ? (BS)sV.value : new BS();
        return scriptMathProcessor.addXList(this.vwr.ms.getModulationList(bS, (String.valueOf(string) + "D").toUpperCase().charAt(0), p3));
    }

    private boolean evaluatePlane(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        block37: {
            if (n == 134219265 && sVArray.length != 3 || n == 134217763 && sVArray.length != 2 && sVArray.length != 3 && sVArray.length != 4 || sVArray.length == 0 || sVArray.length > 4) {
                return false;
            }
            switch (sVArray.length) {
                case 1: {
                    Object object;
                    if (sVArray[0].tok == 10 && ((BS)(object = (BS)sVArray[0].value)).cardinality() == 3) {
                        Lst<P3> lst = this.vwr.ms.getAtomPointVector((BS)object);
                        return scriptMathProcessor.addXPt4(Measure.getPlaneThroughPoints((T3)lst.get(0), (T3)lst.get(1), (T3)lst.get(2), new V3(), new V3(), new P4()));
                    }
                    object = Escape.uP(SV.sValue(sVArray[0]));
                    if (object instanceof P4) {
                        return scriptMathProcessor.addXPt4((P4)object);
                    }
                    return scriptMathProcessor.addXStr("" + object);
                }
                case 2: {
                    if (n == 134217763) {
                        if (sVArray[1].tok != 9) {
                            return false;
                        }
                        P3 p3 = new P3();
                        V3 v3 = new V3();
                        V3 v32 = new V3();
                        P4 p4 = (P4)sVArray[1].value;
                        if (sVArray[0].tok == 9) {
                            Lst<Object> lst = Measure.getIntersectionPP((P4)sVArray[0].value, p4);
                            if (lst == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            return scriptMathProcessor.addXList(lst);
                        }
                        P3 p32 = scriptMathProcessor.ptValue(sVArray[0], null);
                        if (p32 == null) {
                            return scriptMathProcessor.addXStr("");
                        }
                        return scriptMathProcessor.addXPt(Measure.getIntersection(p32, null, p4, p3, v3, v32));
                    }
                }
                case 3: 
                case 4: {
                    switch (n) {
                        case 134219265: {
                            return scriptMathProcessor.addXPt4(this.e.getHklPlane(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2]))));
                        }
                        case 134217763: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], null);
                            P3 p33 = scriptMathProcessor.ptValue(sVArray[1], null);
                            if (p3 == null || p33 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v3 = V3.newV(p33);
                            v3.normalize();
                            if (sVArray[2].tok == 9) {
                                P3 p34 = new P3();
                                V3 v33 = new V3();
                                V3 v34 = new V3();
                                if ((p3 = Measure.getIntersection(p3, v3, (P4)sVArray[2].value, p34, v33, v34)) == null) {
                                    return scriptMathProcessor.addXStr("");
                                }
                                return scriptMathProcessor.addXPt(p3);
                            }
                            P3 p35 = scriptMathProcessor.ptValue(sVArray[2], null);
                            if (p35 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v35 = new V3();
                            p35 = P3.newP(p35);
                            if (sVArray.length == 3) {
                                Measure.projectOntoAxis(p35, p3, v3, v35);
                                return scriptMathProcessor.addXPt(p35);
                            }
                            float f = SV.fValue(sVArray[3]);
                            P3 p36 = P3.newP(p35);
                            Measure.projectOntoAxis(p35, p3, v3, v35);
                            float f2 = p36.distance(p35);
                            Lst<P3> lst = new Lst<P3>();
                            if (f2 == f) {
                                lst.addLast(p35);
                            } else if (f2 < f) {
                                f2 = (float)Math.sqrt(f * f - f2 * f2);
                                v35.scaleAdd2(f2, v3, p35);
                                lst.addLast(P3.newP(v35));
                                v35.scaleAdd2(-f2, v3, p35);
                                lst.addLast(P3.newP(v35));
                            }
                            return scriptMathProcessor.addXList(lst);
                        }
                    }
                    switch (sVArray[0].tok) {
                        case 2: 
                        case 3: {
                            if (sVArray.length == 3) {
                                float f = SV.fValue(sVArray[0]);
                                float f3 = SV.fValue(sVArray[1]);
                                float f4 = SV.fValue(sVArray[2]);
                                V3 v3 = V3.new3(0.0f, 0.0f, 1.0f);
                                P3 p3 = P3.new3(0.0f, 1.0f, 0.0f);
                                Quat quat = Quat.newVA(p3, f4);
                                quat.getMatrix().rotate(v3);
                                p3.set(0.0f, 0.0f, 1.0f);
                                quat = Quat.newVA(p3, f3);
                                quat.getMatrix().rotate(v3);
                                p3.setT(v3);
                                p3.scale(f);
                                P4 p4 = new P4();
                                Measure.getPlaneThroughPoint(p3, v3, p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            break block37;
                        }
                        case 8: 
                        case 10: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], null);
                            P3 p37 = scriptMathProcessor.ptValue(sVArray[1], null);
                            if (p37 == null) {
                                return false;
                            }
                            P3 p38 = sVArray.length > 2 && (sVArray[2].tok == 10 || sVArray[2].tok == 8) ? scriptMathProcessor.ptValue(sVArray[2], null) : null;
                            V3 v3 = V3.newV(p37);
                            if (p38 == null) {
                                P4 p4 = new P4();
                                if (sVArray.length == 2 || sVArray[2].tok != 2 && sVArray[2].tok != 3 && !sVArray[2].asBoolean()) {
                                    p38 = P3.newP(p3);
                                    p38.add(p37);
                                    p38.scale(0.5f);
                                    v3.sub(p3);
                                    v3.normalize();
                                } else if (sVArray[2].tok == 1073742335) {
                                    p38 = p3;
                                } else {
                                    v3.sub(p3);
                                    p38 = new P3();
                                    p38.scaleAdd2(sVArray[2].asFloat(), v3, p3);
                                }
                                Measure.getPlaneThroughPoint(p38, v3, p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            V3 v36 = new V3();
                            P3 p39 = sVArray.length == 4 ? scriptMathProcessor.ptValue(sVArray[3], null) : null;
                            float f = Measure.getDirectedNormalThroughPoints(p3, p37, p38, p39, v3, v36);
                            return scriptMathProcessor.addXPt4(P4.new4(v3.x, v3.y, v3.z, f));
                        }
                    }
                }
            }
        }
        if (sVArray.length != 4) {
            return false;
        }
        float f = SV.fValue(sVArray[0]);
        float f5 = SV.fValue(sVArray[1]);
        float f6 = SV.fValue(sVArray[2]);
        float f7 = SV.fValue(sVArray[3]);
        return scriptMathProcessor.addXPt4(P4.new4(f, f5, f6, f7));
    }

    private boolean evaluatePoint(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        switch (sVArray.length) {
            default: {
                return false;
            }
            case 1: {
                Object object;
                if (sVArray[0].tok == 3 || sVArray[0].tok == 2) {
                    return scriptMathProcessor.addXInt(sVArray[0].asInt());
                }
                String string = SV.sValue(sVArray[0]);
                if (sVArray[0].tok == 7) {
                    string = "{" + string + "}";
                }
                return (object = Escape.uP(string)) instanceof P3 ? scriptMathProcessor.addXPt((P3)object) : scriptMathProcessor.addXStr("" + object);
            }
            case 2: {
                P3 p3;
                switch (sVArray[1].tok) {
                    case 1073742334: 
                    case 1073742335: {
                        switch (sVArray[0].tok) {
                            case 8: {
                                p3 = P3.newP((T3)sVArray[0].value);
                                break;
                            }
                            case 10: {
                                p3 = this.vwr.ms.getAtomSetCenter((BS)sVArray[0].value);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                        if (sVArray[1].tok == 1073742335) {
                            this.vwr.tm.transformPt3f(p3, p3);
                            p3.y = (float)this.vwr.tm.height - p3.y;
                            if (!this.vwr.antialiased) break;
                            p3.scale(0.5f);
                            break;
                        }
                        if (this.vwr.antialiased) {
                            p3.scale(2.0f);
                        }
                        p3.y = (float)this.vwr.tm.height - p3.y;
                        this.vwr.tm.unTransformPoint(p3, p3);
                        break;
                    }
                    case 8: {
                        Lst<SV> lst = sVArray[0].getList();
                        if (lst == null || lst.size() != 4) {
                            return false;
                        }
                        P3 p32 = SV.ptValue(sVArray[1]);
                        p3 = P3.newP(SV.ptValue((SV)lst.get(0)));
                        p3.scaleAdd2(p32.x, SV.ptValue((SV)lst.get(1)), p3);
                        p3.scaleAdd2(p32.y, SV.ptValue((SV)lst.get(2)), p3);
                        p3.scaleAdd2(p32.z, SV.ptValue((SV)lst.get(3)), p3);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return scriptMathProcessor.addXPt(p3);
            }
            case 3: {
                return scriptMathProcessor.addXPt(P3.new3(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat()));
            }
            case 4: 
        }
        return scriptMathProcessor.addXPt4(P4.new4(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat(), sVArray[3].asFloat()));
    }

    private boolean evaluatePrompt(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        boolean bl;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 3) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        String[] stringArray = sVArray.length > 1 && sVArray[1].tok == 7 ? SV.strListValue(sVArray[1]) : null;
        boolean bl2 = bl = stringArray != null || sVArray.length == 1 || sVArray.length == 3 && sVArray[2].asBoolean();
        String string2 = stringArray != null ? null : (sVArray.length >= 2 ? SV.sValue(sVArray[1]) : "OK");
        String string3 = this.vwr.prompt(string, string2, stringArray, bl);
        return bl && stringArray != null ? scriptMathProcessor.addXInt(Integer.parseInt(string3) + 1) : scriptMathProcessor.addXStr(string3);
    }

    private boolean evaluateQuaternion(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        Object object;
        P3 p3 = null;
        int n2 = sVArray.length;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (n == 134221850) {
            if (n2 > 1 && sVArray[n2 - 1].tok == 4 && ((String)sVArray[n2 - 1].value).equalsIgnoreCase("relative")) {
                --n2;
                bl = true;
            }
            if (n2 > 1 && sVArray[n2 - 1].tok == 2 && sVArray[0].tok == 10) {
                n3 = sVArray[n2 - 1].asInt();
                if (n3 <= 0) {
                    n3 = 0x7FFFFFFE;
                }
                --n2;
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (n == 134221850 && (sVArray[0].tok == 7 && (sVArray[1].tok == 7 || sVArray[1].tok == 1073742335) || sVArray[0].tok == 10 && (sVArray[1].tok == 2 || sVArray[1].tok == 10)) || (p3 = scriptMathProcessor.ptValue(sVArray[0], null)) != null && (n == 134221850 || sVArray[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (n != 134221850) {
                    return false;
                }
                if (sVArray[0].tok == 9) {
                    if (sVArray[2].tok == 8 || sVArray[2].tok == 10) break;
                    return false;
                }
                int n4 = 0;
                while (n4 < 3) {
                    if (sVArray[n4].tok != 8 && sVArray[n4].tok != 10) {
                        return false;
                    }
                    ++n4;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quat quat = null;
        Quat[] quatArray = null;
        P4 p4 = null;
        switch (n2) {
            case 0: {
                return scriptMathProcessor.addXPt4(this.vwr.tm.getRotationQ().toPoint4f());
            }
            default: {
                Object object2;
                if (n == 134221850 && sVArray[0].tok == 7) {
                    object = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                    object2 = Quat.sphereMean((Quat[])object, null, 1.0E-4f);
                    quat = object2 instanceof Quat ? (Quat)object2 : null;
                    break;
                }
                if (n == 134221850 && sVArray[0].tok == 10) {
                    quatArray = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, n3);
                } else if (sVArray[0].tok == 11) {
                    quat = Quat.newM((M3)sVArray[0].value);
                } else if (sVArray[0].tok == 9) {
                    p4 = (P4)sVArray[0].value;
                } else {
                    object = SV.sValue(sVArray[0]);
                    object2 = Escape.uP((String)(((String)object).equalsIgnoreCase("best") ? this.vwr.getOrientationText(1073741864, "best", null).toString() : object));
                    if (!(object2 instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)object2;
                }
                if (n != 0x8000003) break;
                quat = Quat.newVA(P3.new3(p4.x, p4.y, p4.z), p4.w);
                break;
            }
            case 2: {
                Object object2;
                if (n == 134221850) {
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 7) {
                        object = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        object2 = this.e.getQuaternionArray(sVArray[1].getList(), 1073742001);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, n3, bl);
                        break;
                    }
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 1073742335) {
                        Quat[] quatArray2 = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        float[] fArray = new float[1];
                        Quat.sphereMean(quatArray2, fArray, 1.0E-4f);
                        return scriptMathProcessor.addXFloat(fArray[0]);
                    }
                    if (sVArray[0].tok == 10 && sVArray[1].tok == 10) {
                        object = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, Integer.MAX_VALUE);
                        object2 = this.vwr.getAtomGroupQuaternions((BS)sVArray[1].value, Integer.MAX_VALUE);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, n3, bl);
                        break;
                    }
                }
                object = scriptMathProcessor.ptValue(sVArray[1], null);
                p4 = scriptMathProcessor.planeValue(sVArray[0]);
                if (object != null) {
                    quat = Quat.getQuaternionFrame(P3.new3(0.0f, 0.0f, 0.0f), p3, (T3)object);
                    break;
                }
                quat = Quat.newVA(p3, SV.fValue(sVArray[1]));
                break;
            }
            case 3: {
                if (sVArray[0].tok == 9) {
                    P3 p32 = sVArray[2].tok == 8 ? (P3)sVArray[2].value : this.vwr.ms.getAtomSetCenter((BS)sVArray[2].value);
                    return scriptMathProcessor.addXStr(Escape.drawQuat(Quat.newP4((P4)sVArray[0].value), "q", SV.sValue(sVArray[1]), p32, 1.0f));
                }
                Object object2 = new P3[3];
                int n5 = 0;
                while (n5 < 3) {
                    object2[n5] = sVArray[n5].tok == 8 ? (P3)sVArray[n5].value : this.vwr.ms.getAtomSetCenter((BS)sVArray[n5].value);
                    ++n5;
                }
                quat = Quat.getQuaternionFrame(object2[0], object2[1], object2[2]);
                break;
            }
            case 4: {
                if (n == 134221850) {
                    p4 = P4.new4(SV.fValue(sVArray[1]), SV.fValue(sVArray[2]), SV.fValue(sVArray[3]), SV.fValue(sVArray[0]));
                    break;
                }
                quat = Quat.newVA(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2])), SV.fValue(sVArray[3]));
            }
        }
        if (quatArray != null) {
            if (n3 != Integer.MAX_VALUE) {
                object = new Lst();
                int n6 = 0;
                while (n6 < quatArray.length) {
                    ((Lst)object).addLast(quatArray[n6].toPoint4f());
                    ++n6;
                }
                return scriptMathProcessor.addXList((Lst<?>)object);
            }
            quat = quatArray.length > 0 ? quatArray[0] : null;
        }
        return scriptMathProcessor.addXPt4((quat == null ? Quat.newP4(p4) : quat).toPoint4f());
    }

    private boolean evaluateRandom(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 3) {
            return false;
        }
        if (this.rand == null) {
            this.rand = new Random();
        }
        float f = 0.0f;
        float f2 = 1.0f;
        switch (sVArray.length) {
            case 3: {
                this.rand.setSeed((int)SV.fValue(sVArray[2]));
            }
            case 2: {
                f2 = SV.fValue(sVArray[1]);
            }
            case 1: {
                f = SV.fValue(sVArray[0]);
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        return scriptMathProcessor.addXFloat(this.rand.nextFloat() * (f2 - f) + f);
    }

    private boolean evaluateRowCol(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length != 1) {
            return false;
        }
        int n2 = sVArray[0].asInt() - 1;
        SV sV = scriptMathProcessor.getX();
        switch (sV.tok) {
            case 11: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M3 m3 = (M3)sV.value;
                switch (n) {
                    case 1275068935: {
                        float[] fArray = new float[3];
                        m3.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[3];
                m3.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 12: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M4 m4 = (M4)sV.value;
                switch (n) {
                    case 1275068935: {
                        float[] fArray = new float[4];
                        m4.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[4];
                m4.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 7: {
                Lst<SV> lst = sV.getList();
                Lst<SV> lst2 = new Lst<SV>();
                int n3 = 0;
                int n4 = lst.size();
                while (n3 < n4) {
                    Lst<SV> lst3 = ((SV)lst.get(n3)).getList();
                    if (lst3 == null) {
                        return scriptMathProcessor.addXStr("");
                    }
                    lst2.addLast(n2 < lst3.size() ? (SV)lst3.get(n2) : SV.newS(""));
                    ++n3;
                }
                return scriptMathProcessor.addXList(lst2);
            }
        }
        return false;
    }

    private boolean evaluateIn(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        switch (sVArray.length) {
            case 1: {
                Lst<SV> lst = sVArray[0].getList();
                if (lst == null) break;
                int n = 0;
                int n2 = lst.size();
                while (n < n2) {
                    if (SV.areEqual(sV, (SV)lst.get(n))) {
                        return scriptMathProcessor.addXInt(n + 1);
                    }
                    ++n;
                }
                break;
            }
            default: {
                int n = 0;
                while (n < sVArray.length) {
                    if (SV.areEqual(sV, sVArray[n])) {
                        return scriptMathProcessor.addXInt(n + 1);
                    }
                    ++n;
                }
                break block0;
            }
        }
        return scriptMathProcessor.addXInt(0);
    }

    private boolean evaluateReplace(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string;
        String string2;
        boolean bl = false;
        switch (sVArray.length) {
            case 0: {
                bl = true;
                string2 = null;
                string = null;
                break;
            }
            case 3: {
                bl = SV.bValue(sVArray[2]);
            }
            case 2: {
                string = SV.sValue(sVArray[0]);
                string2 = SV.sValue(sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        SV sV = scriptMathProcessor.getX();
        if (sV.tok == 7) {
            String[] stringArray = SV.strListValue(sV);
            String[] stringArray2 = new String[stringArray.length];
            int n = stringArray.length;
            while (--n >= 0) {
                String string3 = string == null ? PT.clean(stringArray[n]) : (stringArray2[n] = bl ? PT.replaceAllCharacters(stringArray[n], string, string2) : PT.rep(stringArray[n], string, string2));
            }
            return scriptMathProcessor.addXAS(stringArray2);
        }
        String string4 = SV.sValue(sV);
        return scriptMathProcessor.addXStr(string == null ? PT.clean(string4) : (bl ? PT.replaceAllCharacters(string4, string, string2) : PT.rep(string4, string, string2)));
    }

    private boolean evaluateScript(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if ((n == 134222350 || n == 134238732) && sVArray.length != 1 || sVArray.length == 0) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        SB sB = new SB();
        switch (n) {
            case 134218759: {
                return sVArray.length == 2 ? string.equalsIgnoreCase("JSON") && scriptMathProcessor.addXObj(this.vwr.parseJSONMap(SV.sValue(sVArray[1]))) : scriptMathProcessor.addXObj(this.vwr.evaluateExpressionAsVariable(string));
            }
            case 134222850: {
                String string2;
                String string3 = string2 = sVArray.length == 2 ? SV.sValue(sVArray[1]) : ".";
                if (!string2.equals(".")) {
                    sB.append(this.vwr.jsEval(String.valueOf(string2) + "\u0001" + string));
                }
                if (!string2.equals(".") && !string2.equals("*")) break;
                this.e.runScriptBuffer(string, sB, true);
                break;
            }
            case 134222350: {
                this.e.runScriptBuffer("show " + string, sB, true);
                break;
            }
            case 134238732: {
                return scriptMathProcessor.addX(this.vwr.jsEvalSV(string));
            }
        }
        string = sB.toString();
        float f = PT.parseFloatStrict(string);
        return Float.isNaN(f) ? scriptMathProcessor.addXStr(string) : (string.indexOf(".") >= 0 ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXInt(PT.parseInt(string)));
    }

    private boolean evaluateSort(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        SV sV;
        if (sVArray.length > 1) {
            return false;
        }
        if (n == 1275068444) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return scriptMathProcessor.addX(scriptMathProcessor.getX().sortMapArray(sVArray[0].asString()));
            }
            int n2 = sVArray.length == 0 ? 0 : sVArray[0].asInt();
            return scriptMathProcessor.addX(scriptMathProcessor.getX().sortOrReverse(n2));
        }
        SV sV2 = scriptMathProcessor.getX();
        SV sV3 = sV = sVArray.length == 0 ? null : sVArray[0];
        if (sV2.tok == 4) {
            int n3 = 0;
            String string = SV.sValue(sV2);
            if (sV == null) {
                return scriptMathProcessor.addXInt(0);
            }
            String string2 = SV.sValue(sV);
            int n4 = 0;
            while (n4 < string.length()) {
                int n5 = string.indexOf(string2, n4);
                if (n5 < 0) break;
                ++n3;
                n4 = n5;
                ++n4;
            }
            return scriptMathProcessor.addXInt(n3);
        }
        Lst<SV> lst = new Lst<SV>();
        SV sV4 = null;
        SV sV5 = null;
        Lst<SV> lst2 = SV.getVariable(sV2.value).sortOrReverse(0).getList();
        if (lst2 == null) {
            return sV == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXInt(0);
        }
        int n6 = 0;
        int n7 = lst2.size();
        while (n6 <= n7) {
            SV sV6;
            SV sV7 = sV6 = n6 == n7 ? null : (SV)lst2.get(n6);
            if (sV == null || sV6 == null || SV.areEqual(sV6, sV)) {
                if (SV.areEqual(sV6, sV4)) {
                    sV5.intValue = sV5.intValue + 1;
                } else {
                    if (sV4 != null) {
                        Lst<SV> lst3 = new Lst<SV>();
                        lst3.addLast(sV4);
                        lst3.addLast(sV5);
                        lst.addLast(SV.getVariableList(lst3));
                    }
                    sV5 = SV.newI(1);
                    sV4 = sV6;
                }
            }
            ++n6;
        }
        if (sV == null) {
            return scriptMathProcessor.addX(SV.getVariableList(lst));
        }
        if (lst.isEmpty()) {
            return scriptMathProcessor.addXInt(0);
        }
        return scriptMathProcessor.addX((SV)((SV)lst.get(0)).getList().get(1));
    }

    private boolean evaluateString(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        String string = sVArray.length > 0 ? SV.sValue(sVArray[0]) : (n == 1275068932 ? "" : "\n");
        switch (sVArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (sVArray[0].tok != 1073742335) break;
                return scriptMathProcessor.addX(SV.getVariable(PT.getTokens(sV.asString())));
            }
            case 2: {
                if (sV.tok == 7) break;
                if (n == 1275069447) {
                    sV = SV.getVariable(PT.split(PT.rep((String)sV.value, "\n\r", "\n").replace('\r', '\n'), "\n"));
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (sV.tok == 7 && n != 1275068932 && (n != 1275069447 || sVArray.length == 2)) {
            scriptMathProcessor.addX(sV);
            return this.evaluateList(scriptMathProcessor, n, sVArray);
        }
        String string2 = n == 1275069447 && sV.tok == 10 || n == 1275068932 && sV.tok == 7 ? null : SV.sValue(sV);
        switch (n) {
            case 1275069447: {
                if (sV.tok == 10) {
                    BS bS = (BS)sV.value;
                    int n2 = this.vwr.ms.mc;
                    Lst<SV> lst = new Lst<SV>();
                    int n3 = 0;
                    while (n3 < n2) {
                        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n3);
                        bS2.and(bS);
                        lst.addLast(SV.getVariable(bS2));
                        ++n3;
                    }
                    return scriptMathProcessor.addXList(lst);
                }
                return scriptMathProcessor.addXAS(PT.split(string2, string));
            }
            case 1275069446: {
                if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\n') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                return scriptMathProcessor.addXStr(PT.rep(string2, "\n", string));
            }
            case 1275068932: {
                if (string2 != null) {
                    return scriptMathProcessor.addXStr(PT.trim(string2, string));
                }
                String[] stringArray = SV.strListValue(sV);
                int n4 = stringArray.length;
                while (--n4 >= 0) {
                    stringArray[n4] = PT.trim(stringArray[n4], string);
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return scriptMathProcessor.addXStr("");
    }

    private boolean evaluateSubstructure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, boolean bl) throws ScriptException {
        if (sVArray.length == 0 || bl && sVArray.length > 1) {
            return false;
        }
        BS bS = new BS();
        String string = SV.sValue(sVArray[0]);
        if (string.length() > 0) {
            try {
                BS bS2 = bl ? (BS)scriptMathProcessor.getX().value : (sVArray.length == 2 && sVArray[1].tok == 10 ? (BS)sVArray[1].value : null);
                bS = this.vwr.getSmilesMatcher().getSubstructureSet(string, this.vwr.ms.at, this.vwr.ms.ac, bS2, n == 134218757 ? 1 : 2);
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
        }
        return scriptMathProcessor.addXBs(bS);
    }

    private boolean evaluateSymop(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        String string;
        int n;
        int n2;
        BS bS;
        SV sV;
        SV sV2 = sV = bl ? scriptMathProcessor.getX() : null;
        if (sV != null && sV.tok != 10) {
            return false;
        }
        BS bS2 = bS = sV == null ? null : (BS)sV.value;
        if (bS == null && this.vwr.ms.mc == 1) {
            bS = this.vwr.getModelUndeletedAtomsBitSet(0);
        }
        if ((n2 = sVArray.length) == 0) {
            if (bS.isEmpty()) {
                return false;
            }
            String[] stringArray = PT.split(PT.trim((String)this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, this.vwr.ms.at[bS.nextSetBit((int)0)].mi, false).get("symmetryInfo"), "\n"), "\n");
            Lst<String[]> lst = new Lst<String[]>();
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                lst.addLast(PT.split(stringArray[n3], "\t"));
                ++n3;
            }
            return scriptMathProcessor.addXList(lst);
        }
        String string2 = null;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        switch (sVArray[0].tok) {
            case 4: {
                string2 = SV.sValue(sVArray[0]);
                ++n6;
                break;
            }
            case 12: {
                string2 = sVArray[0].escape();
                ++n6;
                break;
            }
            case 2: {
                n5 = sVArray[0].asInt();
                ++n6;
            }
        }
        if (bS == null) {
            if (n6 < n2 && sVArray[n6].tok == 10) {
                bS = new BS();
                bS.or((BS)sVArray[n6].value);
            }
            if (n6 + 1 < n2 && sVArray[n6 + 1].tok == 10) {
                (bS == null ? (bS = new BS()) : bS).or((BS)sVArray[n6 + 1].value);
            }
        }
        P3 p3 = null;
        P3 p32 = null;
        p3 = n2 > n6 ? scriptMathProcessor.ptValue(sVArray[n6], bS) : null;
        if (p3 != null) {
            ++n6;
        }
        if ((p32 = n2 > n6 ? scriptMathProcessor.ptValue(sVArray[n6], bS) : null) != null) {
            ++n6;
        }
        int n7 = n = p32 != null && sVArray.length > n6 && n5 == Integer.MIN_VALUE && sVArray[n6].tok == 2 ? sVArray[n6].intValue : 0;
        if (n > 0) {
            ++n6;
        }
        if (n5 == Integer.MIN_VALUE) {
            n5 = 0;
        }
        String string3 = n2 == n6 ? (p32 != null ? "all" : (p3 != null ? "point" : "matrix")) : (string = SV.sValue(sVArray[n6++]).toLowerCase());
        return bS != null && !bS.isEmpty() && n6 == sVArray.length && scriptMathProcessor.addXObj(this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, bS.nextSetBit(0), string2, n5, p3, p32, string, 0, 0.0f, n));
    }

    private boolean evaluateTensor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        SV sV = scriptMathProcessor.getX();
        if (sVArray.length > 2 || sV.tok != 10) {
            return false;
        }
        BS bS = (BS)sV.value;
        String string = sVArray.length == 0 ? null : SV.sValue(sVArray[0]).toLowerCase();
        JmolNMRInterface jmolNMRInterface = this.vwr.getNMRCalculation();
        if ("unique".equals(string)) {
            return scriptMathProcessor.addXBs(jmolNMRInterface.getUniqueTensorSet(bS));
        }
        String string2 = sVArray.length < 2 ? null : SV.sValue(sVArray[1]).toLowerCase();
        return scriptMathProcessor.addXList(jmolNMRInterface.getTensorInfo(string, string2, bS));
    }

    private boolean evaluateUserFunction(ScriptMathProcessor scriptMathProcessor, String string, SV[] sVArray, int n, boolean bl) throws ScriptException {
        SV sV = null;
        if (bl) {
            sV = scriptMathProcessor.getX();
            switch (sV.tok) {
                case 10: {
                    break;
                }
                case 6: {
                    if (sVArray.length > 0) {
                        return false;
                    }
                    return (sV = sV.getMap().get(string)) == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addX(sV);
                }
                default: {
                    return false;
                }
            }
        }
        string = string.toLowerCase();
        scriptMathProcessor.wasX = false;
        Lst<SV> lst = new Lst<SV>();
        int n2 = 0;
        while (n2 < sVArray.length) {
            lst.addLast(sVArray[n2]);
            ++n2;
        }
        if (bl) {
            return scriptMathProcessor.addXObj(this.e.getBitsetProperty((BS)sV.value, (Lst)null, n, (P3)null, (P4)null, sV.value, (Object)new Object[]{string, lst}, false, sV.index, false));
        }
        SV sV2 = this.e.getUserFunctionResult(string, lst, null);
        return sV2 == null ? false : scriptMathProcessor.addX(sV2);
    }

    private boolean evaluateWithin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        BS bS;
        Object object;
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length;
        if (n == 1 && sVArray[0].tok == 10) {
            return scriptMathProcessor.addX(sVArray[0]);
        }
        float f = 0.0f;
        Object object2 = sVArray[0].value;
        String string = "" + object2;
        int n2 = sVArray[0].tok;
        if (n2 == 4) {
            n2 = T.getTokFromName(string);
        }
        ModelSet modelSet = this.vwr.ms;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        RadiusData radiusData = null;
        block0 : switch (n2) {
            case 1648363544: {
                bl = true;
                object2 = null;
            }
            case 2: 
            case 3: {
                bl4 = true;
                if (n < 2 || n == 3 && sVArray[1].tok == 7 && sVArray[2].tok != 7) {
                    return false;
                }
                f = bl ? 100.0f : SV.fValue(sVArray[0]);
                n2 = sVArray[1].tok;
                switch (n2) {
                    case 1073742334: 
                    case 1073742335: {
                        bl2 = sVArray[1].asBoolean();
                        if (n > 2 && SV.sValue(sVArray[2]).equalsIgnoreCase("unitcell")) {
                            n2 = 1814695966;
                        }
                        n = 0;
                        break block0;
                    }
                    case 4: {
                        object = SV.sValue(sVArray[1]);
                        if (((String)object).startsWith("$")) {
                            return scriptMathProcessor.addXBs(this.getAtomsNearSurface(f, ((String)object).substring(1)));
                        }
                        if (((String)object).equalsIgnoreCase("group")) {
                            bl3 = true;
                            n2 = 1086324742;
                            break block0;
                        }
                        if (((String)object).equalsIgnoreCase("vanderwaals") || ((String)object).equalsIgnoreCase("vdw")) {
                            object2 = null;
                            bl = true;
                            n2 = 1648363544;
                            break block0;
                        }
                        if (((String)object).equalsIgnoreCase("unitcell")) {
                            n2 = 1814695966;
                            break block0;
                        }
                        return false;
                    }
                }
                break;
            }
            case 7: {
                if (n != 1) break;
                object2 = sVArray[0].asString();
                n2 = 0;
                break;
            }
            case 1073742328: {
                return n == 3 && sVArray[1].value instanceof BS && sVArray[2].value instanceof BS && scriptMathProcessor.addXBs(this.vwr.getBranchBitSet(((BS)sVArray[2].value).nextSetBit(0), ((BS)sVArray[1].value).nextSetBit(0), true));
            }
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                BS bS2 = null;
                boolean bl5 = true;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl6 = bl5 = sVArray[2].tok == 10;
                        if (!bl5) break;
                        bS2 = (BS)sVArray[2].value;
                        break;
                    }
                    default: {
                        bl5 = false;
                    }
                }
                if (!bl5) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(this.e.getSmilesExt().getSmilesMatches(SV.sValue(sVArray[1]), null, bS2, null, n2 == 0x8000404 ? 2 : 1, scriptMathProcessor.asBitSet, false));
            }
        }
        if (object2 instanceof String) {
            if (n2 == 0) {
                n2 = 1073742362;
                if (n > 2) {
                    return false;
                }
                n = 2;
            }
        } else if (!bl4) {
            return false;
        }
        block15 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0x200020: 
                    case 136314895: 
                    case 1678381065: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(n2, null));
                    }
                    case 1073741863: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(n2, ""));
                    }
                    case 1073742362: {
                        return scriptMathProcessor.addXBs(modelSet.getAtoms(1086324744, string));
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1073742362: {
                        n2 = 1086324744;
                        break block15;
                    }
                    case 0x40000000: 
                    case 1073741863: 
                    case 1073741925: 
                    case 1073742128: 
                    case 1073742189: 
                    case 1086324744: 
                    case 1086326785: 
                    case 1086326786: 
                    case 1111490587: {
                        return scriptMathProcessor.addXBs(this.vwr.ms.getAtoms(n2, SV.sValue(sVArray[sVArray.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 7: 
                    case 8: 
                    case 134217750: 
                    case 134219265: 
                    case 1073742329: 
                    case 1073742334: 
                    case 1073742335: 
                    case 1086324742: 
                    case 1648363544: 
                    case 1814695966: {
                        break block15;
                    }
                    case 1086324744: {
                        string = SV.sValue(sVArray[2]);
                        break block15;
                    }
                }
                return false;
            }
        }
        object = null;
        P3 p3 = null;
        Lst<SV> lst = null;
        int n3 = sVArray.length - 1;
        switch (sVArray[n3].tok) {
            case 9: {
                object = (P4)sVArray[n3].value;
                break;
            }
            case 8: {
                p3 = (P3)sVArray[n3].value;
                if (!SV.sValue(sVArray[1]).equalsIgnoreCase("hkl")) break;
                object = this.e.getHklPlane(p3);
                break;
            }
            case 7: {
                Lst<SV> lst2 = lst = n3 == 2 && sVArray[1].tok == 7 ? sVArray[1].getList() : null;
                P3 p32 = n3 == 2 ? SV.ptValue(sVArray[1]) : (p3 = n3 == 1 ? P3.new3(Float.NaN, 0.0f, 0.0f) : null);
            }
        }
        if (object != null) {
            return scriptMathProcessor.addXBs(modelSet.getAtomsNearPlane(f, (P4)object));
        }
        BS bS3 = bS = sVArray[n3].tok == 10 ? (BS)sVArray[n3].value : null;
        if (n3 > 0 && p3 == null && lst == null && bS == null) {
            return false;
        }
        if (n2 == 1814695966) {
            boolean bl7 = bl2;
            return (bS != null || p3 != null) && scriptMathProcessor.addXObj(this.vwr.ms.getUnitCellPointsWithin(f, bS, p3, bl7));
        }
        if (p3 != null || lst != null) {
            if (sVArray[n3].tok == 7) {
                Lst<SV> lst3 = sVArray[n3].getList();
                P3[] p3Array = new P3[lst3.size()];
                int n4 = p3Array.length;
                while (--n4 >= 0) {
                    p3Array[n4] = SV.ptValue((SV)lst3.get(n4));
                }
                P3[] p3Array2 = null;
                if (lst != null) {
                    p3Array2 = new P3[lst.size()];
                    int n5 = p3Array2.length;
                    while (--n5 >= 0) {
                        p3Array2[n5] = SV.ptValue((SV)lst.get(n5));
                    }
                }
                Object[] objectArray = new Object[1];
                switch (PointIterator.withinDistPoints(f, p3, p3Array, p3Array2, objectArray)) {
                    case 134217751: {
                        return scriptMathProcessor.addXPt((P3)objectArray[0]);
                    }
                    case 1073742001: {
                        return scriptMathProcessor.addXList((Lst)objectArray[0]);
                    }
                    case 1275068418: {
                        return scriptMathProcessor.addXAI((int[])objectArray[0]);
                    }
                    case 4: {
                        return scriptMathProcessor.addXStr((String)objectArray[0]);
                    }
                }
                return false;
            }
            return scriptMathProcessor.addXBs(this.vwr.getAtomsNearPt(f, p3));
        }
        if (n2 == 1086324744) {
            return scriptMathProcessor.addXBs(this.vwr.ms.getSequenceBits(string, bS, new BS()));
        }
        if (bS == null) {
            bS = new BS();
        }
        if (!bl4) {
            return scriptMathProcessor.addXBs(this.vwr.ms.getAtoms(n2, bS));
        }
        if (bl3) {
            return scriptMathProcessor.addXBs(this.vwr.getGroupsWithin((int)f, bS));
        }
        if (bl) {
            radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsWithinRadius(f, bS, bl2, radiusData));
    }

    private boolean evaluateWrite(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        switch (sVArray.length) {
            case 0: {
                return false;
            }
            case 1: {
                String string = sVArray[0].asString().toUpperCase();
                if (string.equals("PNGJ")) {
                    return scriptMathProcessor.addXMap(this.vwr.fm.getFileAsMap(null, "PNGJ"));
                }
                if (!PT.isOneOf(string, ";ZIP;ZIPALL;JMOL;")) break;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                OC oC = new OC();
                hashtable.put("outputChannel", oC);
                this.vwr.createZip(null, string, hashtable);
                BufferedInputStream bufferedInputStream = Rdr.getBIS(oC.toByteArray());
                hashtable = new Hashtable();
                this.vwr.getJzt().readFileAsMap(bufferedInputStream, hashtable, null);
                return scriptMathProcessor.addXMap(hashtable);
            }
        }
        return scriptMathProcessor.addXStr(this.e.getCmdExt().dispatch(134221856, true, sVArray));
    }

    private BS getAtomsNearSurface(float f, String string) {
        Object[] objectArray = new Object[3];
        objectArray[0] = string;
        Object[] objectArray2 = objectArray;
        if (this.e.getShapePropertyData(24, "getVertices", objectArray2)) {
            return this.getAtomsNearPts(f, (T3[])objectArray2[1], (BS)objectArray2[2]);
        }
        objectArray2[1] = 0;
        objectArray2[2] = -1;
        if (this.e.getShapePropertyData(22, "getCenter", objectArray2)) {
            return this.vwr.getAtomsNearPt(f, (P3)objectArray2[2]);
        }
        objectArray2[1] = Float.valueOf(f);
        if (this.e.getShapePropertyData(21, "getAtomsWithin", objectArray2)) {
            return (BS)objectArray2[2];
        }
        return new BS();
    }

    private BS getAtomsNearPts(float f, T3[] t3Array, BS bS) {
        BS bS2 = new BS();
        if (t3Array.length == 0 || bS != null && bS.isEmpty()) {
            return bS2;
        }
        if (bS == null) {
            bS = BSUtil.setAll(t3Array.length);
        }
        Atom[] atomArray = this.vwr.ms.at;
        int n = this.vwr.ms.ac;
        block0: while (--n >= 0) {
            Atom atom = atomArray[n];
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (atom.distance(t3Array[n2]) < f) {
                    bS2.set(n);
                    continue block0;
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        return bS2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMinMax(Object object, int n) {
        double d;
        int n2;
        float[] fArray = null;
        Lst lst = null;
        int n3 = 0;
        Hashtable<String, Integer> hashtable = null;
        if (AU.isAF(object)) {
            if (n == 1140850707) {
                return "NaN";
            }
            fArray = (float[])object;
            n3 = fArray.length;
            if (n3 == 0) {
                return "NaN";
            }
        } else {
            if (!(object instanceof Lst)) return "NaN";
            lst = (Lst)object;
            n3 = lst.size();
            if (n3 == 0) {
                if (n != 1140850707) {
                    return "NaN";
                }
            } else {
                SV sV = (SV)lst.get(0);
                if (sV.tok == 8) {
                    return this.getMinMaxPoint(lst, n);
                }
                if (sV.tok == 4 && ((String)sV.value).startsWith("{")) {
                    P3 p3 = SV.ptValue(sV);
                    if (p3 instanceof P3) {
                        return this.getMinMaxPoint(lst, n);
                    }
                    if (!(p3 instanceof P4)) return "NaN";
                    return this.getMinMaxQuaternion(lst, n);
                }
            }
        }
        boolean bl = false;
        switch (n) {
            case 1140850707: {
                hashtable = new Hashtable<String, Integer>();
                n2 = 0;
                d = 0;
                break;
            }
            case 32: {
                bl = true;
                d = 3.4028234663852886E38;
                n2 = Integer.MAX_VALUE;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                n2 = -2147483647;
                break;
            }
            default: {
                n2 = 0;
                d = 0;
            }
        }
        double d2 = 0.0;
        int n4 = 0;
        boolean bl2 = true;
        boolean bl3 = n == 1140850707;
        int n5 = n3;
        while (--n5 >= 0) {
            float f;
            SV sV;
            SV sV2 = sV = lst == null ? SV.vF : (SV)lst.get(n5);
            float f2 = bl3 ? 1.0f : (f = fArray == null ? SV.fValue(sV) : fArray[n5]);
            if (Float.isNaN(f)) continue;
            ++n4;
            switch (n) {
                case 160: 
                case 192: {
                    d2 += (double)f * (double)f;
                }
                case 96: 
                case 128: {
                    d += (double)f;
                    break;
                }
                case 1140850707: {
                    bl2 &= sV.tok == 2;
                    String string = sV.asString();
                    Integer n6 = (Integer)hashtable.get(string);
                    hashtable.put(string, n6 == null ? new Integer(1) : new Integer(n6 + 1));
                    break;
                }
                case 32: 
                case 64: {
                    bl2 &= sV.tok == 2;
                    if (bl != (double)f < d) break;
                    d = f;
                    if (!bl2) break;
                    n2 = sV.intValue;
                }
            }
        }
        if (n == 1140850707) {
            return hashtable;
        }
        if (n4 == 0) return "NaN";
        switch (n) {
            case 96: {
                d /= (double)n4;
                return Float.valueOf((float)d);
            }
            case 192: {
                if (n4 == 1) return Float.valueOf((float)d);
                d = Math.sqrt((d2 - d * d / (double)n4) / (double)(n4 - 1));
                return Float.valueOf((float)d);
            }
            case 32: 
            case 64: {
                if (!bl2) return Float.valueOf((float)d);
                return n2;
            }
            case 128: {
                return Float.valueOf((float)d);
            }
            case 160: {
                d = d2;
            }
        }
        return Float.valueOf((float)d);
    }

    private Object getMinMaxPoint(Object object, int n) {
        P3[] p3Array = null;
        Lst lst = null;
        int n2 = 0;
        if (object instanceof Quat[]) {
            p3Array = (P3[])object;
            n2 = p3Array.length;
        } else if (object instanceof Lst) {
            lst = (Lst)object;
            n2 = lst.size();
        }
        if (lst == null && p3Array == null) {
            return "NaN";
        }
        P3 p3 = new P3();
        float[] fArray = new float[n2];
        int n3 = 0;
        while (n3 < 3) {
            int n4 = 0;
            while (n4 < n2) {
                P3 p32;
                P3 p33 = p32 = p3Array == null ? SV.ptValue((SV)lst.get(n4)) : p3Array[n4];
                if (p32 == null) {
                    return "NaN";
                }
                switch (n3) {
                    case 0: {
                        fArray[n4] = p32.x;
                        break;
                    }
                    case 1: {
                        fArray[n4] = p32.y;
                        break;
                    }
                    case 2: {
                        fArray[n4] = p32.z;
                    }
                }
                ++n4;
            }
            Object object2 = this.getMinMax(fArray, n);
            if (!(object2 instanceof Number)) {
                return "NaN";
            }
            float f = ((Number)object2).floatValue();
            switch (n3) {
                case 0: {
                    p3.x = f;
                    break;
                }
                case 1: {
                    p3.y = f;
                    break;
                }
                case 2: {
                    p3.z = f;
                }
            }
            ++n3;
        }
        return p3;
    }

    private Object getMinMaxQuaternion(Lst<SV> lst, int n) {
        switch (n) {
            case 32: 
            case 64: 
            case 128: 
            case 160: {
                return "NaN";
            }
        }
        Quat[] quatArray = this.e.getQuaternionArray(lst, 1073742001);
        if (quatArray != null) {
            float[] fArray = new float[1];
            Quat quat = Quat.sphereMean(quatArray, fArray, 1.0E-4f);
            switch (n) {
                case 96: {
                    return quat;
                }
                case 192: {
                    return Float.valueOf(fArray[0]);
                }
            }
        }
        return "NaN";
    }

    private JmolPatternMatcher getPatternMatcher() {
        return this.pm == null ? (this.pm = (JmolPatternMatcher)Interface.getUtil("PatternMatcher", this.e.vwr, "script")) : this.pm;
    }

    private T opTokenFor(int n) {
        switch (n) {
            case 1275069441: 
            case 1275069446: {
                return T.tokenPlus;
            }
            case 1275068931: {
                return T.tokenMinus;
            }
            case 1275068929: {
                return T.tokenTimes;
            }
            case 1275068930: {
                return T.tokenMul3;
            }
            case 1275068928: {
                return T.tokenDivide;
            }
        }
        return null;
    }

    public BS setContactBitSets(BS bS, BS bS2, boolean bl, float f, RadiusData radiusData, boolean bl2) {
        int n;
        BS bS3;
        boolean bl3;
        if (bS2 == null) {
            bS2 = BSUtil.setAll(this.vwr.ms.ac);
            BSUtil.andNot(bS2, this.vwr.slm.bsDeleted);
            bS2.andNot(bS);
            bl3 = false;
        } else {
            bS3 = BSUtil.copy(bS);
            bS3.or(bS2);
            n = this.vwr.ms.getModelBS(bS3, false).cardinality();
            boolean bl4 = bl3 = n > 1;
            if (bl2 && n > 1 && !this.e.tQuiet) {
                this.e.showString(GT.$("Note: More than one model is involved in this contact!"));
            }
        }
        if (!bS.equals(bS2)) {
            int n2 = n = bl && bS.cardinality() >= bS2.cardinality() ? 0 : 1;
            if (n != 0) {
                bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                bS2.and(bS3);
            }
            if (bl) {
                bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS2, bl3, Float.isNaN(f) ? radiusData : null);
                bS.and(bS3);
                if (n == 0) {
                    bS3 = this.vwr.ms.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                    bS2.and(bS3);
                }
                bS3 = BSUtil.copy(bS2);
                bS3.and(bS);
                if (bS3.equals(bS)) {
                    bS2.andNot(bS);
                } else if (bS3.equals(bS2)) {
                    bS.andNot(bS2);
                }
            }
        }
        return bS2;
    }
}

