/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;

class UFFVDWCalc
extends Calculation {
    UFFVDWCalc() {
    }

    @Override
    void setData(Lst<Object[]> calc, int ia, int ib, double dd) {
        this.a = this.calcs.minAtoms[ia];
        this.b = this.calcs.minAtoms[ib];
        FFParam parA = (FFParam)this.calcs.getParameter(this.a.sType);
        FFParam parB = (FFParam)this.calcs.getParameter(this.b.sType);
        double Xa = parA.dVal[2];
        double Da = parA.dVal[3];
        if (parB == null || parB.dVal == null) {
            System.out.println("OHOH");
        }
        double Xb = parB.dVal[2];
        double Db = parB.dVal[3];
        double Dab = 4.1868 * Math.sqrt(Da * Db);
        double Xab = Math.sqrt(Xa * Xb);
        calc.addLast(new Object[]{new int[]{ia, ib}, new double[]{Xab, Dab}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        double Xab = this.dData[0];
        double Dab = this.dData[1];
        this.calcs.setPairVariables(this);
        double term = Xab / this.rab;
        double term6 = term * term * term;
        term6 *= term6;
        this.energy = Dab * term6 * (term6 - 2.0);
        if (this.calcs.gradients) {
            this.dE = Dab * 12.0 * (1.0 - term6) * term6 * term / Xab;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(5, this));
        }
        return this.energy;
    }
}

