/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.Map;

public class MessageData {
    private String caller = "";
    private String callee = "";
    private int level = 0;
    private int thread = -1;
    private boolean spawnMessage = false;
    private String answer = "";
    private String message = "";
    private String[] callees = new String[0];
    private boolean returnsInstantly;
    private int noteNumber = 0;
    private int answerNoteNumber = 0;
    private int broadcastType = 0;
    private boolean isStatic = false;
    private boolean isBold = false;
    private Map<String, String> userData;

    public String toString() {
        String string = this.caller;
        if (this.level > 0 || this.thread != -1) {
            string = string + "[";
        }
        if (this.level > 0) {
            string = string + this.level;
        }
        if (this.thread != -1) {
            string = string + "," + this.thread;
        }
        if (this.level > 0 || this.thread != -1) {
            string = string + "]";
        }
        string = string + ":";
        if (this.spawnMessage) {
            string = string + ">";
        }
        if (this.answer.length() > 0) {
            string = string + this.answer + "=";
        }
        if (this.callee.length() > 0) {
            string = string + this.callee + ".";
        }
        string = string + this.message;
        if (this.returnsInstantly) {
            string = string + "&";
        }
        return string;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isNewMessage() {
        if (this.message == null) {
            throw new IllegalStateException("no message present");
        }
        return this.message.startsWith("new(") || this.message.equals("new");
    }

    public boolean isDestroyMessage() {
        if (this.message == null) {
            throw new IllegalStateException("no message present");
        }
        return !this.callee.equals("") && (this.message.equals("destroy") || this.message.startsWith("destroy("));
    }

    public boolean isReturning() {
        return this.callee.equals("") && this.message.equals("-") && this.answer.equals("") && this.level == 0;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getCallee() {
        return this.callee;
    }

    public void setCallee(String callee) {
        this.callee = callee;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setNoteNumber(int number) {
        this.noteNumber = number;
    }

    public int getNoteNumber() {
        return this.noteNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSpawnMessage() {
        return this.spawnMessage;
    }

    public void setSpawnMessage(boolean spawnMessage) {
        this.spawnMessage = spawnMessage;
    }

    public int getThread() {
        return this.thread;
    }

    public void setThread(int thread) {
        this.thread = thread;
    }

    public void setReturnsInstantly(boolean on) {
        this.returnsInstantly = on;
    }

    public boolean returnsInstantly() {
        return this.returnsInstantly;
    }

    public int getAnswerNoteNumber() {
        return this.answerNoteNumber;
    }

    public void setAnswerNoteNumber(int answerNoteNumber) {
        this.answerNoteNumber = answerNoteNumber;
    }

    public String[] getCallees() {
        return this.callees;
    }

    public void setCallees(String[] callees) {
        this.callees = callees;
    }

    public int getBroadcastType() {
        return this.broadcastType;
    }

    public void setBroadcastType(int broadcastType) {
        this.broadcastType = broadcastType;
    }

    public void setUserData(Map<String, String> userData) {
        this.userData = userData;
    }

    public String getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

