/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class BroadcastArrow
extends Arrow {
    public BroadcastArrow(Message message, Direction align, int y) {
        super(message, ArrowStroke.SOLID, align, y);
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        int sgn;
        ArrowStroke stroke = this.getStroke();
        Point[] pts = this.getPoints();
        if (this.getMessage().getData().getBroadcastType() == 1) {
            this.drawText(g2d);
        }
        g2d.setColor(Color.BLACK);
        int n = sgn = this.getAlign() == Direction.LEFT ? 1 : -1;
        if (stroke != ArrowStroke.NONE) {
            g2d.setStroke(stroke == ArrowStroke.DASHED ? this.dashed() : this.solid());
            g2d.drawLine(pts[0].x, pts[0].y, pts[1].x, pts[1].y);
            g2d.setStroke(this.solid());
            this.drawArrowHead(g2d, pts[1].x, pts[1].y, sgn);
        }
        if (this.getMessage().getData().getBroadcastType() == 1) {
            int w = this.getMessage().getCaller().getRoot() == this.getMessage().getCaller() ? this.diagram().mainLifelineWidth : this.diagram().subLifelineWidth;
            int cx = pts[0].x + sgn * w / 2;
            int cy = pts[0].y;
            g2d.drawArc(cx - 6, cy - 4, 12, 6, 0, 180);
            g2d.drawArc(cx - 8, cy - 9, 16, 6, 0, 180);
            g2d.drawArc(cx - 10, cy - 14, 20, 6, 0, 180);
        }
    }
}

