/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class Ellipse
extends EMFTag {
    private Rectangle bounds;

    public Ellipse(Rectangle bounds) {
        this();
        this.bounds = bounds;
    }

    public Ellipse() {
        super(42, 1);
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new Ellipse(emf.readRECTL());
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds;
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.fillAndDrawOrAppend(new Ellipse2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight()));
    }
}

