/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.accel;

import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Vector3;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;
import org.sunflow.util.IntArray;

public final class UniformGrid
implements AccelerationStructure {
    private int nx = 0;
    private int ny = 0;
    private int nz = 0;
    private PrimitiveList primitives;
    private BoundingBox bounds = null;
    private int[][] cells = null;
    private float voxelwx = 0.0f;
    private float voxelwy = 0.0f;
    private float voxelwz = 0.0f;
    private float invVoxelwx = 0.0f;
    private float invVoxelwy = 0.0f;
    private float invVoxelwz = 0.0f;

    public void build(PrimitiveList primitiveList) {
        int n;
        int n2;
        int n3;
        Timer timer = new Timer();
        timer.start();
        this.primitives = primitiveList;
        int n4 = primitiveList.getNumPrimitives();
        this.bounds = primitiveList.getWorldBounds(null);
        this.bounds.enlargeUlps();
        Vector3 vector3 = this.bounds.getExtents();
        double d = Math.pow(vector3.x * vector3.y * vector3.z / (float)n4, 0.3333333333333333);
        this.nx = MathUtils.clamp((int)((double)vector3.x / d + 0.5), 1, 128);
        this.ny = MathUtils.clamp((int)((double)vector3.y / d + 0.5), 1, 128);
        this.nz = MathUtils.clamp((int)((double)vector3.z / d + 0.5), 1, 128);
        this.voxelwx = vector3.x / (float)this.nx;
        this.voxelwy = vector3.y / (float)this.ny;
        this.voxelwz = vector3.z / (float)this.nz;
        this.invVoxelwx = 1.0f / this.voxelwx;
        this.invVoxelwy = 1.0f / this.voxelwy;
        this.invVoxelwz = 1.0f / this.voxelwz;
        UI.printDetailed(UI.Module.ACCEL, "Creating grid: %dx%dx%d ...", this.nx, this.ny, this.nz);
        IntArray[] intArrayArray = new IntArray[this.nx * this.ny * this.nz];
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            this.getGridIndex(primitiveList.getPrimitiveBound(n3, 0), primitiveList.getPrimitiveBound(n3, 2), primitiveList.getPrimitiveBound(n3, 4), nArray);
            this.getGridIndex(primitiveList.getPrimitiveBound(n3, 1), primitiveList.getPrimitiveBound(n3, 3), primitiveList.getPrimitiveBound(n3, 5), nArray2);
            for (n2 = nArray[0]; n2 <= nArray2[0]; ++n2) {
                for (n = nArray[1]; n <= nArray2[1]; ++n) {
                    for (int i = nArray[2]; i <= nArray2[2]; ++i) {
                        int n6 = n2 + this.nx * n + this.nx * this.ny * i;
                        if (intArrayArray[n6] == null) {
                            intArrayArray[n6] = new IntArray();
                        }
                        intArrayArray[n6].add(n3);
                        ++n5;
                    }
                }
            }
        }
        UI.printDetailed(UI.Module.ACCEL, "Building cells ...", new Object[0]);
        n3 = 0;
        n2 = 0;
        this.cells = new int[this.nx * this.ny * this.nz][];
        n = 0;
        for (IntArray intArray : intArrayArray) {
            if (intArray != null) {
                if (intArray.getSize() == 0) {
                    ++n3;
                    intArray = null;
                } else {
                    this.cells[n] = intArray.trim();
                    n2 += intArray.getSize();
                }
            } else {
                ++n3;
            }
            ++n;
        }
        timer.end();
        UI.printDetailed(UI.Module.ACCEL, "Uniform grid statistics:", new Object[0]);
        UI.printDetailed(UI.Module.ACCEL, "  * Grid cells:          %d", this.cells.length);
        UI.printDetailed(UI.Module.ACCEL, "  * Used cells:          %d", this.cells.length - n3);
        UI.printDetailed(UI.Module.ACCEL, "  * Empty cells:         %d", n3);
        UI.printDetailed(UI.Module.ACCEL, "  * Occupancy:           %.2f%%", 100.0 * (double)(this.cells.length - n3) / (double)this.cells.length);
        UI.printDetailed(UI.Module.ACCEL, "  * Objects/Cell:        %.2f", (double)n2 / (double)this.cells.length);
        UI.printDetailed(UI.Module.ACCEL, "  * Objects/Used Cell:   %.2f", (double)n2 / (double)(this.cells.length - n3));
        UI.printDetailed(UI.Module.ACCEL, "  * Cells/Object:        %.2f", (double)n5 / (double)n4);
        UI.printDetailed(UI.Module.ACCEL, "  * Build time:          %s", timer.toString());
    }

    public void intersect(Ray ray, IntersectionState intersectionState) {
        float f;
        float f2;
        int n;
        int n2;
        float f3;
        float f4;
        int n3;
        int n4;
        float f5;
        float f6;
        int n5;
        int n6;
        float f7 = ray.getMin();
        float f8 = ray.getMax();
        float f9 = ray.ox;
        float f10 = ray.dx;
        float f11 = 1.0f / f10;
        float f12 = (this.bounds.getMinimum().x - f9) * f11;
        float f13 = (this.bounds.getMaximum().x - f9) * f11;
        if (f11 > 0.0f) {
            if (f12 > f7) {
                f7 = f12;
            }
            if (f13 < f8) {
                f8 = f13;
            }
        } else {
            if (f13 > f7) {
                f7 = f13;
            }
            if (f12 < f8) {
                f8 = f12;
            }
        }
        if (f7 > f8) {
            return;
        }
        float f14 = ray.oy;
        float f15 = ray.dy;
        float f16 = 1.0f / f15;
        f12 = (this.bounds.getMinimum().y - f14) * f16;
        f13 = (this.bounds.getMaximum().y - f14) * f16;
        if (f16 > 0.0f) {
            if (f12 > f7) {
                f7 = f12;
            }
            if (f13 < f8) {
                f8 = f13;
            }
        } else {
            if (f13 > f7) {
                f7 = f13;
            }
            if (f12 < f8) {
                f8 = f12;
            }
        }
        if (f7 > f8) {
            return;
        }
        float f17 = ray.oz;
        float f18 = ray.dz;
        float f19 = 1.0f / f18;
        f12 = (this.bounds.getMinimum().z - f17) * f19;
        f13 = (this.bounds.getMaximum().z - f17) * f19;
        if (f19 > 0.0f) {
            if (f12 > f7) {
                f7 = f12;
            }
            if (f13 < f8) {
                f8 = f13;
            }
        } else {
            if (f13 > f7) {
                f7 = f13;
            }
            if (f12 < f8) {
                f8 = f12;
            }
        }
        if (f7 > f8) {
            return;
        }
        f14 += f7 * f15;
        f17 += f7 * f18;
        int n7 = (int)(((f9 += f7 * f10) - this.bounds.getMinimum().x) * this.invVoxelwx);
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 >= this.nx) {
            n7 = this.nx - 1;
        }
        if (Math.abs(f10) < 1.0E-6f) {
            n6 = 0;
            n5 = n7;
            f6 = 0.0f;
            f5 = Float.POSITIVE_INFINITY;
        } else if (f10 > 0.0f) {
            n6 = 1;
            n5 = this.nx;
            f6 = this.voxelwx * f11;
            f5 = f7 + ((float)(n7 + 1) * this.voxelwx + this.bounds.getMinimum().x - f9) * f11;
        } else {
            n6 = -1;
            n5 = -1;
            f6 = -this.voxelwx * f11;
            f5 = f7 + ((float)n7 * this.voxelwx + this.bounds.getMinimum().x - f9) * f11;
        }
        int n8 = (int)((f14 - this.bounds.getMinimum().y) * this.invVoxelwy);
        if (n8 < 0) {
            n8 = 0;
        } else if (n8 >= this.ny) {
            n8 = this.ny - 1;
        }
        if (Math.abs(f15) < 1.0E-6f) {
            n4 = 0;
            n3 = n8;
            f4 = 0.0f;
            f3 = Float.POSITIVE_INFINITY;
        } else if (f15 > 0.0f) {
            n4 = 1;
            n3 = this.ny;
            f4 = this.voxelwy * f16;
            f3 = f7 + ((float)(n8 + 1) * this.voxelwy + this.bounds.getMinimum().y - f14) * f16;
        } else {
            n4 = -1;
            n3 = -1;
            f4 = -this.voxelwy * f16;
            f3 = f7 + ((float)n8 * this.voxelwy + this.bounds.getMinimum().y - f14) * f16;
        }
        int n9 = (int)((f17 - this.bounds.getMinimum().z) * this.invVoxelwz);
        if (n9 < 0) {
            n9 = 0;
        } else if (n9 >= this.nz) {
            n9 = this.nz - 1;
        }
        if (Math.abs(f18) < 1.0E-6f) {
            n2 = 0;
            n = n9;
            f2 = 0.0f;
            f = Float.POSITIVE_INFINITY;
        } else if (f18 > 0.0f) {
            n2 = 1;
            n = this.nz;
            f2 = this.voxelwz * f19;
            f = f7 + ((float)(n9 + 1) * this.voxelwz + this.bounds.getMinimum().z - f17) * f19;
        } else {
            n2 = -1;
            n = -1;
            f2 = -this.voxelwz * f19;
            f = f7 + ((float)n9 * this.voxelwz + this.bounds.getMinimum().z - f17) * f19;
        }
        int n10 = n6;
        int n11 = n4 * this.nx;
        int n12 = n2 * this.ny * this.nx;
        int n13 = n7 + n8 * this.nx + n9 * this.ny * this.nx;
        while (true) {
            if (f5 < f3 && f5 < f) {
                if (this.cells[n13] != null) {
                    for (int n14 : this.cells[n13]) {
                        this.primitives.intersectPrimitive(ray, n14, intersectionState);
                    }
                    if (intersectionState.hit() && ray.getMax() < f5 && ray.getMax() < f8) {
                        return;
                    }
                }
                if ((f7 = f5) > f8) {
                    return;
                }
                if ((n7 += n6) == n5) {
                    return;
                }
                f5 += f6;
                n13 += n10;
                continue;
            }
            if (f3 < f) {
                if (this.cells[n13] != null) {
                    for (int n14 : this.cells[n13]) {
                        this.primitives.intersectPrimitive(ray, n14, intersectionState);
                    }
                    if (intersectionState.hit() && ray.getMax() < f3 && ray.getMax() < f8) {
                        return;
                    }
                }
                if ((f7 = f3) > f8) {
                    return;
                }
                if ((n8 += n4) == n3) {
                    return;
                }
                f3 += f4;
                n13 += n11;
                continue;
            }
            if (this.cells[n13] != null) {
                for (int n14 : this.cells[n13]) {
                    this.primitives.intersectPrimitive(ray, n14, intersectionState);
                }
                if (intersectionState.hit() && ray.getMax() < f && ray.getMax() < f8) {
                    return;
                }
            }
            if ((f7 = f) > f8) {
                return;
            }
            if ((n9 += n2) == n) {
                return;
            }
            f += f2;
            n13 += n12;
        }
    }

    private void getGridIndex(float f, float f2, float f3, int[] nArray) {
        nArray[0] = MathUtils.clamp((int)((f - this.bounds.getMinimum().x) * this.invVoxelwx), 0, this.nx - 1);
        nArray[1] = MathUtils.clamp((int)((f2 - this.bounds.getMinimum().y) * this.invVoxelwy), 0, this.ny - 1);
        nArray[2] = MathUtils.clamp((int)((f3 - this.bounds.getMinimum().z) * this.invVoxelwz), 0, this.nz - 1);
    }
}

