/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryRetained;
import com.sun.j3d.utils.geometry.compression.GeometryDecompressorShape3D;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;

public class CompressedGeometryData {
    private Header cgHeader;
    private CompressedGeometryRetained retained;

    public CompressedGeometryData(Header header, byte[] byArray) {
        this(header, byArray, false);
    }

    public CompressedGeometryData(Header header, byte[] byArray, boolean bl) {
        if (header.size + header.start > byArray.length) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("CompressedGeometry0"));
        }
        this.cgHeader = new Header();
        header.copy(this.cgHeader);
        this.retained = new CompressedGeometryRetained();
        this.retained.createCompressedGeometry(this.cgHeader, byArray, bl);
        if (!bl) {
            this.cgHeader.start = 0;
        }
    }

    public CompressedGeometryData(Header header, J3DBuffer j3DBuffer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getByteCount() {
        return this.cgHeader.size;
    }

    public void getCompressedGeometryHeader(Header header) {
        this.cgHeader.copy(header);
    }

    public void getCompressedGeometry(byte[] byArray) {
        if (this.isByReference()) {
            throw new IllegalStateException(J3dUtilsI18N.getString("CompressedGeometry7"));
        }
        if (this.cgHeader.size > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(J3dUtilsI18N.getString("CompressedGeometry4"));
        }
        this.retained.copy(byArray);
    }

    public Shape3D[] decompress() {
        CompressedGeometryRetained compressedGeometryRetained = this.retained;
        GeometryDecompressorShape3D geometryDecompressorShape3D = new GeometryDecompressorShape3D();
        return geometryDecompressorShape3D.toTriangleStripArrays(compressedGeometryRetained);
    }

    public boolean isByReference() {
        return this.retained.isByReference();
    }

    public byte[] getCompressedGeometryRef() {
        if (!this.isByReference()) {
            throw new IllegalStateException(J3dUtilsI18N.getString("CompressedGeometry8"));
        }
        return this.retained.getReference();
    }

    public J3DBuffer getCompressedGeometryBuffer() {
        return null;
    }

    public static class Header {
        public static final int POINT_BUFFER = 0;
        public static final int LINE_BUFFER = 1;
        public static final int TRIANGLE_BUFFER = 2;
        public static final int NORMAL_IN_BUFFER = 1;
        public static final int COLOR_IN_BUFFER = 2;
        public static final int ALPHA_IN_BUFFER = 4;
        public int majorVersionNumber;
        public int minorVersionNumber;
        public int minorMinorVersionNumber;
        public int bufferType;
        public int bufferDataPresent;
        public int size;
        public int start;
        public Point3d lowerBound = null;
        public Point3d upperBound = null;

        void copy(Header header) {
            header.majorVersionNumber = this.majorVersionNumber;
            header.minorVersionNumber = this.minorVersionNumber;
            header.minorMinorVersionNumber = this.minorMinorVersionNumber;
            header.bufferType = this.bufferType;
            header.bufferDataPresent = this.bufferDataPresent;
            header.size = this.size;
            header.start = this.start;
            header.lowerBound = this.lowerBound;
            header.upperBound = this.upperBound;
        }

        public String toString() {
            String string = "UNKNOWN";
            switch (this.bufferType) {
                case 0: {
                    string = "POINT_BUFFER";
                    break;
                }
                case 1: {
                    string = "LINE_BUFFER";
                    break;
                }
                case 2: {
                    string = "TRIANGLE_BUFFER";
                }
            }
            String string2 = "";
            if ((this.bufferDataPresent & 1) != 0) {
                string2 = string2 + "NORMALS ";
            }
            if ((this.bufferDataPresent & 2) != 0) {
                string2 = string2 + "COLORS ";
            }
            if ((this.bufferDataPresent & 4) != 0) {
                string2 = string2 + "ALPHA ";
            }
            String string3 = "null";
            if (this.lowerBound != null) {
                string3 = this.lowerBound.toString();
            }
            String string4 = "null";
            if (this.upperBound != null) {
                string4 = this.upperBound.toString();
            }
            return "majorVersionNumber: " + this.majorVersionNumber + "  " + "minorVersionNumber: " + this.minorVersionNumber + "  " + "minorMinorVersionNumber: " + this.minorMinorVersionNumber + "\n" + "bufferType: " + string + "  " + "bufferDataPresent: " + string2 + "\n" + "size: " + this.size + "  " + "start: " + this.start + "\n" + "lower bound: " + string3 + "\n" + "upper bound: " + string4 + "  ";
        }
    }
}

