/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.rtp;

import com.sun.media.datasink.BasicDataSink;
import com.sun.media.rtp.RTPMediaLocator;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPManager;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;

public class Handler
extends BasicDataSink {
    private RTPMediaLocator rtpmrl = null;
    RTPManager rtpmanager = null;
    PushBufferDataSource source = null;
    SendStream rtpsendstream = null;

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Component getControlComponent() {
        return null;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("Only supports PushBufferDataSource");
        }
        this.source = (PushBufferDataSource)source;
        PushBufferStream[] streams = this.source.getStreams();
        int numStreams = streams.length;
        System.out.println("streams is " + streams + " : " + numStreams);
        if (streams == null || numStreams <= 0) {
            throw new IOException("source " + source + " doesn't have any streams");
        }
    }

    public void setOutputLocator(MediaLocator output) {
        if (this.rtpmrl == null) {
            System.out.println("sink: setOutputLocator " + output);
            try {
                this.rtpmrl = new RTPMediaLocator(output.toString());
            }
            catch (MalformedURLException e) {
                this.rtpmrl = null;
            }
        } else {
            throw new Error("setOutputLocator cannot be called more than once");
        }
    }

    public MediaLocator getOutputLocator() {
        return this.rtpmrl;
    }

    public void start() throws IOException {
        this.rtpsendstream.start();
    }

    public void stop() throws IOException {
        this.rtpsendstream.stop();
    }

    public void open() throws IOException, SecurityException {
        if (this.rtpmrl == null) {
            throw new IOException("No Valid RTP MediaLocator");
        }
        try {
            String address = this.rtpmrl.getSessionAddress();
            int port = this.rtpmrl.getSessionPort();
            int ttl = this.rtpmrl.getTTL();
            this.rtpmanager = RTPManager.newInstance();
            SessionAddress localaddr = new SessionAddress();
            InetAddress destaddr = InetAddress.getByName(address);
            SessionAddress sessaddr = new SessionAddress(destaddr, port, ttl);
            this.rtpmanager.initialize(localaddr);
            this.rtpmanager.addTarget(sessaddr);
            this.rtpsendstream = this.rtpmanager.createSendStream(this.source, 0);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void close() {
        if (this.rtpmanager != null) {
            this.rtpmanager.removeTargets("DataSink closed");
            this.rtpmanager.dispose();
        }
    }

    public String getContentType() {
        return "RTP";
    }
}

