/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.keyboard.KeyboardMapping;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcutTableModel;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class DialogEditShortcut
extends StandardFieldsDialog {
    private static final String FIELD_ACTION = "keyboard.dialog.label.action";
    private static final String FIELD_KEY = "keyboard.dialog.label.key";
    private static final String FIELD_CONTROL = "keyboard.dialog.label.control";
    private static final String FIELD_ALT = "keyboard.dialog.label.alt";
    private static final String FIELD_SHIFT = "keyboard.dialog.label.shift";
    private static final String FIELD_INFO = "keyboard.dialog.label.info";
    private static final long serialVersionUID = 1L;
    private KeyboardShortcut shortcut;
    private KeyboardShortcutTableModel model;

    public DialogEditShortcut(Window owner) {
        super(owner, "keyboard.dialog.title", new Dimension(300, 200), true);
    }

    public DialogEditShortcut(Frame owner) {
        super(owner, "keyboard.dialog.title", new Dimension(300, 200));
    }

    public void init(KeyboardShortcut shortcut, KeyboardShortcutTableModel model) {
        this.shortcut = shortcut;
        this.model = model;
        this.removeAllFields();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditShortcut.this.checkDuplicate();
            }
        };
        this.addReadOnlyField(FIELD_ACTION, shortcut.getName(), false);
        this.addComboField(FIELD_KEY, this.getKeyList(), this.getKey(shortcut.getKeyStroke()));
        this.addFieldListener(FIELD_KEY, listener);
        this.addCheckBoxField(FIELD_CONTROL, this.isModifier(shortcut.getKeyStroke(), 128));
        this.addFieldListener(FIELD_CONTROL, listener);
        this.addCheckBoxField(FIELD_ALT, this.isModifier(shortcut.getKeyStroke(), 512));
        this.addFieldListener(FIELD_ALT, listener);
        this.addCheckBoxField(FIELD_SHIFT, this.isModifier(shortcut.getKeyStroke(), 64));
        this.addFieldListener(FIELD_SHIFT, listener);
        this.addReadOnlyField(FIELD_INFO, "", true);
        this.getField(FIELD_INFO).setForeground(Color.RED);
    }

    @Override
    public String getSaveButtonText() {
        return Constant.messages.getString("keyboard.dialog.button.save");
    }

    private void checkDuplicate() {
        KeyboardShortcut ks = this.getDuplicate();
        if (ks != null) {
            this.setFieldValue(FIELD_INFO, Constant.messages.getString("keyboard.dialog.warning.dup", ks.getName()));
        } else {
            this.setFieldValue(FIELD_INFO, "");
        }
    }

    private KeyboardShortcut getDuplicate() {
        KeyStroke chosenKs = this.getKeyStroke();
        if (chosenKs != null) {
            for (KeyboardShortcut ks : this.model.getElements()) {
                KeyStroke testKs;
                if (ks.equals(this.shortcut) || (testKs = ks.getKeyStroke()) == null || chosenKs.getKeyCode() != testKs.getKeyCode() || chosenKs.getModifiers() != testKs.getModifiers()) continue;
                return ks;
            }
        }
        return null;
    }

    private List<String> getKeyList() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            list.add(String.valueOf(c));
        }
        for (i = 0; i <= 9; ++i) {
            list.add(String.valueOf(i));
        }
        list.add("-");
        list.add("=");
        list.add("[");
        list.add("]");
        list.add(";");
        list.add("'");
        list.add("#");
        list.add(",");
        list.add(".");
        list.add("/");
        for (i = 1; i <= 12; ++i) {
            list.add("F" + i);
        }
        list.add(Constant.messages.getString("keyboard.key.up"));
        list.add(Constant.messages.getString("keyboard.key.down"));
        list.add(Constant.messages.getString("keyboard.key.left"));
        list.add(Constant.messages.getString("keyboard.key.right"));
        return list;
    }

    private String getKey(KeyStroke ks) {
        if (ks != null) {
            return KeyboardMapping.keyString(ks.getKeyCode());
        }
        return "";
    }

    private char selectedKey() {
        return KeyboardMapping.keyCode(this.getStringValue(FIELD_KEY));
    }

    private boolean isModifier(KeyStroke ks, int modifier) {
        if (ks != null) {
            return (ks.getModifiers() & modifier) != 0;
        }
        return false;
    }

    public KeyStroke getKeyStroke() {
        KeyStroke ks = null;
        char keyCode = this.selectedKey();
        int modifiers = 0;
        if (keyCode != '\u0000') {
            if (this.getBoolValue(FIELD_CONTROL).booleanValue()) {
                modifiers |= 0x80;
            }
            if (this.getBoolValue(FIELD_ALT).booleanValue()) {
                modifiers |= 0x200;
            }
            if (this.getBoolValue(FIELD_SHIFT).booleanValue()) {
                modifiers |= 0x40;
            }
            ks = KeyStroke.getKeyStroke(keyCode, modifiers, false);
        }
        return ks;
    }

    @Override
    public void save() {
        KeyboardShortcut ksDup = this.getDuplicate();
        if (ksDup != null) {
            ksDup.setKeyStroke(null);
        }
        KeyStroke ks = this.getKeyStroke();
        this.shortcut.setKeyStroke(ks);
    }

    @Override
    public String validateFields() {
        return null;
    }
}

