/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        @NotNull
        public URL resolvePath(@NotNull String relativePath, @Nullable String base) {
            URL uRL;
            block6: {
                block4: {
                    URL uRL2;
                    block5: {
                        if (relativePath == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            if (base == null) break block4;
                            uRL2 = new URL(new URL(base), relativePath);
                            if (uRL2 != null) break block5;
                        }
                        catch (MalformedURLException ex) {
                            throw new XIncludeException(ex);
                        }
                        1.$$$reportNull$$$0(1);
                    }
                    return uRL2;
                }
                uRL = new URL(relativePath);
                if (uRL != null) break block6;
                1.$$$reportNull$$$0(2);
            }
            return uRL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xmlb/JDOMXIncluder$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xmlb/JDOMXIncluder$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolvePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolvePath";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    private final boolean myIgnoreMissing;
    private final PathResolver myPathResolver;
    @NonNls
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");

    private JDOMXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver) {
        if (pathResolver == null) {
            JDOMXIncluder.$$$reportNull$$$0(0);
        }
        this.myIgnoreMissing = ignoreMissing;
        this.myPathResolver = pathResolver;
    }

    public static void resolveNonXIncludeElement(@NotNull Element original, @Nullable String base, boolean ignoreMissing, @NotNull PathResolver pathResolver) throws XIncludeException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(6);
        }
        if (pathResolver == null) {
            JDOMXIncluder.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!JDOMXIncluder.isIncludeElement(original));
        Stack<String> bases = new Stack<String>();
        if (base != null) {
            bases.push(base);
        }
        new InplaceJdomXIncluder(ignoreMissing, pathResolver).resolveNonXIncludeElement(original, bases);
    }

    protected static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Content> resolve(@NotNull Element original, @NotNull Stack<String> bases) throws XIncludeException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(12);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(13);
        }
        if (JDOMXIncluder.isIncludeElement(original)) {
            List<Content> list2 = this.resolveXIncludeElement(original, bases);
            if (list2 == null) {
                JDOMXIncluder.$$$reportNull$$$0(14);
            }
            return list2;
        }
        Element resolvedElement = this.resolveNonXIncludeElement(original, bases);
        List<Content> list3 = Collections.singletonList(resolvedElement);
        if (list3 == null) {
            JDOMXIncluder.$$$reportNull$$$0(15);
        }
        return list3;
    }

    @NotNull
    protected List<Content> resolveXIncludeElement(@NotNull Element element, @NotNull Stack<String> bases) throws XIncludeException {
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(16);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(17);
        }
        String base = "";
        if (!bases.isEmpty()) {
            base = bases.peek();
        }
        String href = element.getAttributeValue("href");
        assert (href != null) : "Missing href attribute";
        Attribute baseAttribute = element.getAttribute("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = baseAttribute.getValue();
        }
        URL remote = this.myPathResolver.resolvePath(href, base);
        String parseAttribute = element.getAttributeValue("parse");
        if (parseAttribute != null) {
            LOG.assertTrue(parseAttribute.equals("xml"), parseAttribute + " is not a legal value for the parse attribute");
        }
        assert (!bases.contains(remote.toExternalForm())) : "Circular XInclude Reference to " + remote.toExternalForm();
        Element fallbackElement = element.getChild("fallback", element.getNamespace());
        List<Content> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
        if (!remoteParsed.isEmpty()) {
            remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
        }
        for (int i = 0; i < remoteParsed.size(); ++i) {
            Content o = remoteParsed.get(i);
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            List<Content> nodes = this.resolve(e, bases);
            remoteParsed.addAll(i, nodes);
            remoteParsed.remove(i += nodes.size());
            --i;
            e.detach();
        }
        for (Content content : remoteParsed) {
            content.detach();
        }
        List<Content> list2 = remoteParsed;
        if (list2 == null) {
            JDOMXIncluder.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    private static List<Content> extractNeededChildren(@NotNull Element element, @NotNull List<Content> remoteElements) {
        String xpointer;
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(19);
        }
        if (remoteElements == null) {
            JDOMXIncluder.$$$reportNull$$$0(20);
        }
        if ((xpointer = element.getAttributeValue("xpointer")) == null) {
            List<Content> list2 = remoteElements;
            if (list2 == null) {
                JDOMXIncluder.$$$reportNull$$$0(21);
            }
            return list2;
        }
        Matcher matcher = XPOINTER_PATTERN.matcher(xpointer);
        boolean b = matcher.matches();
        assert (b) : "Unsupported XPointer: " + xpointer;
        String pointer = matcher.group(1);
        matcher = CHILDREN_PATTERN.matcher(pointer);
        b = matcher.matches();
        assert (b) : "Unsupported pointer: " + pointer;
        String rootTagName = matcher.group(1);
        assert (remoteElements.size() == 1);
        assert (remoteElements.get(0) instanceof Element);
        Element e = (Element)remoteElements.get(0);
        if (!e.getName().equals(rootTagName)) {
            List<Content> list3 = Collections.emptyList();
            if (list3 == null) {
                JDOMXIncluder.$$$reportNull$$$0(22);
            }
            return list3;
        }
        String subTagName = matcher.group(2);
        if (subTagName != null) {
            e = e.getChild(subTagName.substring(1));
        }
        assert (e != null);
        ArrayList<Content> arrayList = new ArrayList<Content>(e.getContent());
        if (arrayList == null) {
            JDOMXIncluder.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private List<Content> parseRemote(@NotNull Stack<String> bases, @NotNull URL remote, @Nullable Element fallbackElement) {
        List<Content> list2;
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(24);
        }
        if (remote == null) {
            JDOMXIncluder.$$$reportNull$$$0(25);
        }
        try {
            bases.push(remote.toExternalForm());
            Element root2 = JDOMUtil.loadResource(remote);
            List<Content> list3 = this.resolve(root2, bases);
            bases.pop();
            list2 = list3;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                List<Content> list4 = Collections.emptyList();
                if (list4 == null) {
                    JDOMXIncluder.$$$reportNull$$$0(27);
                }
                return list4;
            }
            if (this.myIgnoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                List<Content> list5 = Collections.emptyList();
                if (list5 == null) {
                    JDOMXIncluder.$$$reportNull$$$0(28);
                }
                return list5;
            }
            throw new XIncludeException(e);
        }
        if (list2 == null) {
            JDOMXIncluder.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    protected Element resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<String> bases) throws XIncludeException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(29);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(30);
        }
        Element result2 = new Element(original.getName(), original.getNamespace());
        if (original.hasAttributes()) {
            for (Attribute a : original.getAttributes()) {
                result2.setAttribute(a.clone());
            }
        }
        for (Content o : original.getContent()) {
            if (o instanceof Element) {
                Element element = (Element)o;
                if (JDOMXIncluder.isIncludeElement(element)) {
                    result2.addContent(this.resolveXIncludeElement(element, bases));
                    continue;
                }
                result2.addContent(this.resolveNonXIncludeElement(element, bases));
                continue;
            }
            result2.addContent(o.clone());
        }
        Element element = result2;
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(31);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/JDOMXIncluder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 13: 
            case 17: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteElements";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/JDOMXIncluder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveXIncludeElement";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNeededChildren";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemote";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNonXIncludeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonXIncludeElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveXIncludeElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractNeededChildren";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PathResolver {
        @NotNull
        public URL resolvePath(@NotNull String var1, @Nullable String var2);
    }

    private static final class InplaceJdomXIncluder
    extends JDOMXIncluder {
        private InplaceJdomXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver) {
            if (pathResolver == null) {
                InplaceJdomXIncluder.$$$reportNull$$$0(0);
            }
            super(ignoreMissing, pathResolver);
        }

        @Override
        @NotNull
        protected Element resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<String> bases) throws XIncludeException {
            if (original == null) {
                InplaceJdomXIncluder.$$$reportNull$$$0(1);
            }
            if (bases == null) {
                InplaceJdomXIncluder.$$$reportNull$$$0(2);
            }
            List<Content> contentList = original.getContent();
            for (int i = contentList.size() - 1; i >= 0; --i) {
                Content content = contentList.get(i);
                if (!(content instanceof Element)) continue;
                Element element = (Element)content;
                if (InplaceJdomXIncluder.isIncludeElement(element)) {
                    original.setContent(i, this.resolveXIncludeElement(element, bases));
                    continue;
                }
                this.resolveNonXIncludeElement(element, bases);
            }
            Element element = original;
            if (element == null) {
                InplaceJdomXIncluder.$$$reportNull$$$0(3);
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathResolver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bases";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xmlb/JDOMXIncluder$InplaceJdomXIncluder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xmlb/JDOMXIncluder$InplaceJdomXIncluder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveNonXIncludeElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveNonXIncludeElement";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

