/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "nameSuggestion", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "(Lorg/jetbrains/kotlin/js/naming/NameSuggestion;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Companion", "js.frontend"})
public final class JsBuiltinNameClashChecker
implements DeclarationChecker {
    private final NameSuggestion nameSuggestion;
    @JvmField
    @NotNull
    public static final Set<String> PROHIBITED_STATIC_NAMES;
    @JvmField
    @NotNull
    public static final Set<String> PROHIBITED_MEMBER_NAMES;
    public static final Companion Companion;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        SuggestedName suggestedName;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return;
        }
        SuggestedName suggestedName2 = this.nameSuggestion.suggest(descriptor2);
        if (suggestedName2 == null) {
            Intrinsics.throwNpe();
        }
        if (!(suggestedName = suggestedName2).getStable()) {
            return;
        }
        String simpleName = CollectionsKt.single(suggestedName.getNames());
        if (descriptor2 instanceof ClassDescriptor) {
            if (PROHIBITED_STATIC_NAMES.contains(simpleName)) {
                context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Function." + simpleName));
            }
        } else if (descriptor2 instanceof CallableMemberDescriptor && PROHIBITED_MEMBER_NAMES.contains(simpleName)) {
            context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Object.prototype." + simpleName));
        }
    }

    public JsBuiltinNameClashChecker(@NotNull NameSuggestion nameSuggestion) {
        Intrinsics.checkParameterIsNotNull(nameSuggestion, "nameSuggestion");
        this.nameSuggestion = nameSuggestion;
    }

    static {
        Companion = new Companion(null);
        PROHIBITED_STATIC_NAMES = SetsKt.setOf("prototype", "length", "$metadata$");
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker$Companion;", "", "()V", "PROHIBITED_MEMBER_NAMES", "", "", "PROHIBITED_STATIC_NAMES", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

