/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;

public class KtFunctionElementType
extends KtStubElementType<KotlinFunctionStub, KtNamedFunction> {
    public KtFunctionElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtFunctionElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtNamedFunction.class, KotlinFunctionStub.class);
    }

    @Override
    @NotNull
    public KotlinFunctionStub createStub(@NotNull KtNamedFunction psi, @NotNull StubElement parentStub) {
        if (psi == null) {
            KtFunctionElementType.$$$reportNull$$$0(1);
        }
        if (parentStub == null) {
            KtFunctionElementType.$$$reportNull$$$0(2);
        }
        boolean isTopLevel = psi.getParent() instanceof KtFile;
        boolean isExtension = psi.getReceiverTypeReference() != null;
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        boolean hasBlockBody = psi.hasBlockBody();
        boolean hasBody = psi.hasBody();
        KotlinFunctionStubImpl kotlinFunctionStubImpl = new KotlinFunctionStubImpl(parentStub, StringRef.fromString(psi.getName()), isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, psi.hasTypeParameterListBeforeFunctionName(), psi.mayHaveContract());
        if (kotlinFunctionStubImpl == null) {
            KtFunctionElementType.$$$reportNull$$$0(3);
        }
        return kotlinFunctionStubImpl;
    }

    @Override
    public void serialize(@NotNull KotlinFunctionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtFunctionElementType.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            KtFunctionElementType.$$$reportNull$$$0(5);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isTopLevel());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        dataStream.writeBoolean(stub.isExtension());
        dataStream.writeBoolean(stub.hasBlockBody());
        dataStream.writeBoolean(stub.hasBody());
        dataStream.writeBoolean(stub.hasTypeParameterListBeforeFunctionName());
        dataStream.writeBoolean(stub.mayHaveContract());
    }

    @Override
    @NotNull
    public KotlinFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtFunctionElementType.$$$reportNull$$$0(6);
        }
        StringRef name = dataStream.readName();
        boolean isTopLevel = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        boolean isExtension = dataStream.readBoolean();
        boolean hasBlockBody = dataStream.readBoolean();
        boolean hasBody = dataStream.readBoolean();
        boolean hasTypeParameterListBeforeFunctionName = dataStream.readBoolean();
        boolean mayHaveContract = dataStream.readBoolean();
        KotlinFunctionStubImpl kotlinFunctionStubImpl = new KotlinFunctionStubImpl(parentStub, name, isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, hasTypeParameterListBeforeFunctionName, mayHaveContract);
        if (kotlinFunctionStubImpl == null) {
            KtFunctionElementType.$$$reportNull$$$0(7);
        }
        return kotlinFunctionStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinFunctionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtFunctionElementType.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            KtFunctionElementType.$$$reportNull$$$0(9);
        }
        StubIndexService.getInstance().indexFunction(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/stubs/elements/KtFunctionElementType";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtFunctionElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

