/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;

public class CharSetUtils {
    public static String squeeze(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return str2;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        StringBuilder buffer = new StringBuilder(str2.length());
        char[] chrs = str2.toCharArray();
        int sz = chrs.length;
        char lastChar = chrs[0];
        char ch = ' ';
        Character inChars = null;
        Character notInChars = null;
        buffer.append(lastChar);
        for (int i = 1; i < sz; ++i) {
            ch = chrs[i];
            if (ch == lastChar) {
                if (inChars != null && ch == inChars.charValue()) continue;
                if (notInChars == null || ch != notInChars.charValue()) {
                    if (chars2.contains(ch)) {
                        inChars = Character.valueOf(ch);
                        continue;
                    }
                    notInChars = Character.valueOf(ch);
                }
            }
            buffer.append(ch);
            lastChar = ch;
        }
        return buffer.toString();
    }

    public static boolean containsAny(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return false;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        for (char c : str2.toCharArray()) {
            if (!chars2.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static int count(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return 0;
        }
        CharSet chars2 = CharSet.getInstance(set2);
        int count2 = 0;
        for (char c : str2.toCharArray()) {
            if (!chars2.contains(c)) continue;
            ++count2;
        }
        return count2;
    }

    public static String keep(String str2, String ... set2) {
        if (str2 == null) {
            return null;
        }
        if (str2.isEmpty() || CharSetUtils.deepEmpty(set2)) {
            return "";
        }
        return CharSetUtils.modify(str2, set2, true);
    }

    public static String delete(String str2, String ... set2) {
        if (StringUtils.isEmpty(str2) || CharSetUtils.deepEmpty(set2)) {
            return str2;
        }
        return CharSetUtils.modify(str2, set2, false);
    }

    private static String modify(String str2, String[] set2, boolean expect) {
        CharSet chars2 = CharSet.getInstance(set2);
        StringBuilder buffer = new StringBuilder(str2.length());
        char[] chrs = str2.toCharArray();
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (chars2.contains(chrs[i]) != expect) continue;
            buffer.append(chrs[i]);
        }
        return buffer.toString();
    }

    private static boolean deepEmpty(String[] strings) {
        if (strings != null) {
            for (String s : strings) {
                if (!StringUtils.isNotEmpty(s)) continue;
                return false;
            }
        }
        return true;
    }
}

