/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.provider.HostnameUtil;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.SSLEngineUtil;
import org.bouncycastle.jsse.provider.SSLSocketUtil;
import org.bouncycastle.jsse.provider.X509TrustManagerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509TrustManager
extends BCX509ExtendedTrustManager {
    private static final Logger LOG = Logger.getLogger(ProvX509TrustManager.class.getName());
    private final Provider pkixProvider;
    private final Set<X509Certificate> trustedCerts;
    private final PKIXParameters baseParameters;
    private final X509TrustManager exportX509TrustManager;

    private static Set<X509Certificate> getTrustedCerts(Set<TrustAnchor> set) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>(set.size());
        for (TrustAnchor trustAnchor : set) {
            X509Certificate x509Certificate;
            if (trustAnchor == null || (x509Certificate = trustAnchor.getTrustedCert()) == null) continue;
            hashSet.add(x509Certificate);
        }
        return hashSet;
    }

    ProvX509TrustManager(Provider provider, Set<TrustAnchor> set) throws InvalidAlgorithmParameterException {
        this.pkixProvider = provider;
        this.trustedCerts = ProvX509TrustManager.getTrustedCerts(set);
        this.baseParameters = new PKIXBuilderParameters(set, (CertSelector)new X509CertSelector());
        this.baseParameters.setRevocationEnabled(false);
        this.exportX509TrustManager = X509TrustManagerUtil.exportX509TrustManager(this);
    }

    ProvX509TrustManager(Provider provider, PKIXParameters pKIXParameters) throws InvalidAlgorithmParameterException {
        this.pkixProvider = provider;
        this.trustedCerts = ProvX509TrustManager.getTrustedCerts(pKIXParameters.getTrustAnchors());
        if (pKIXParameters instanceof PKIXBuilderParameters) {
            this.baseParameters = pKIXParameters;
        } else {
            this.baseParameters = new PKIXBuilderParameters(pKIXParameters.getTrustAnchors(), pKIXParameters.getTargetCertConstraints());
            this.baseParameters.setCertStores(pKIXParameters.getCertStores());
            this.baseParameters.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
            this.baseParameters.setCertPathCheckers(pKIXParameters.getCertPathCheckers());
            this.baseParameters.setDate(pKIXParameters.getDate());
            this.baseParameters.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
            this.baseParameters.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
            this.baseParameters.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
        }
        this.exportX509TrustManager = X509TrustManagerUtil.exportX509TrustManager(this);
    }

    X509TrustManager getExportX509TrustManager() {
        return this.exportX509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustedCerts.toArray(new X509Certificate[this.trustedCerts.size()]);
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        this.validatePath(x509CertificateArray, string, bl);
        ProvX509TrustManager.checkExtendedTrust(x509CertificateArray, string, socket, bl);
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        this.validatePath(x509CertificateArray, string, bl);
        ProvX509TrustManager.checkExtendedTrust(x509CertificateArray, string, sSLEngine, bl);
    }

    private void validatePath(X509Certificate[] x509CertificateArray, String string, boolean bl) throws CertificateException {
        if (null == x509CertificateArray || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("'chain' must be a chain of at least one certificate");
        }
        if (null == string || string.length() < 1) {
            throw new IllegalArgumentException("'authType' must be a non-null, non-empty string");
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        if (this.trustedCerts.contains(x509Certificate)) {
            return;
        }
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(x509CertificateArray)), this.pkixProvider);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", this.pkixProvider);
            X509CertSelector x509CertSelector = (X509CertSelector)this.baseParameters.getTargetCertConstraints().clone();
            x509CertSelector.setCertificate(x509Certificate);
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.baseParameters.clone();
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("unable to process certificates: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    static void checkExtendedTrust(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        if (socket instanceof SSLSocket && socket.isConnected()) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            BCExtendedSSLSession bCExtendedSSLSession = ProvX509TrustManager.getHandshakeSession(sSLSocket);
            BCSSLParameters bCSSLParameters = ProvX509TrustManager.getSSLParameters(sSLSocket);
            ProvX509TrustManager.checkExtendedTrust(x509CertificateArray, string, bl, bCExtendedSSLSession, bCSSLParameters);
        }
    }

    static void checkExtendedTrust(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        if (null != sSLEngine) {
            BCExtendedSSLSession bCExtendedSSLSession = ProvX509TrustManager.getHandshakeSession(sSLEngine);
            BCSSLParameters bCSSLParameters = ProvX509TrustManager.getSSLParameters(sSLEngine);
            ProvX509TrustManager.checkExtendedTrust(x509CertificateArray, string, bl, bCExtendedSSLSession, bCSSLParameters);
        }
    }

    private static void checkExtendedTrust(X509Certificate[] x509CertificateArray, String string, boolean bl, BCExtendedSSLSession bCExtendedSSLSession, BCSSLParameters bCSSLParameters) throws CertificateException {
        String string2 = bCSSLParameters.getEndpointIdentificationAlgorithm();
        if (null != string2 && string2.length() > 0) {
            ProvX509TrustManager.checkEndpointID(x509CertificateArray[0], string2, bl, bCExtendedSSLSession);
        }
    }

    private static void checkEndpointID(X509Certificate x509Certificate, String string, boolean bl, BCExtendedSSLSession bCExtendedSSLSession) throws CertificateException {
        String string2;
        BCSNIHostName bCSNIHostName;
        String string3 = bCExtendedSSLSession.getPeerHost();
        if (bl && null != (bCSNIHostName = ProvX509TrustManager.getSNIHostName(bCExtendedSSLSession)) && !(string2 = bCSNIHostName.getAsciiName()).equalsIgnoreCase(string3)) {
            try {
                ProvX509TrustManager.checkEndpointID(string2, x509Certificate, string);
                return;
            }
            catch (CertificateException certificateException) {
                LOG.log(Level.FINE, "Server's endpoint ID did not match the SNI host_name: " + string2, certificateException);
            }
        }
        ProvX509TrustManager.checkEndpointID(string3, x509Certificate, string);
    }

    private static void checkEndpointID(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        string = JsseUtils.stripSquareBrackets(string);
        if (string2.equalsIgnoreCase("HTTPS")) {
            HostnameUtil.checkHostname(string, x509Certificate, true);
        } else if (string2.equalsIgnoreCase("LDAP") || string2.equalsIgnoreCase("LDAPS")) {
            HostnameUtil.checkHostname(string, x509Certificate, false);
        } else {
            throw new CertificateException("Unknown endpoint ID algorithm: " + string2);
        }
    }

    private static BCSNIHostName getSNIHostName(BCExtendedSSLSession bCExtendedSSLSession) {
        List<BCSNIServerName> list = bCExtendedSSLSession.getRequestedServerNames();
        if (null != list) {
            for (BCSNIServerName bCSNIServerName : list) {
                if (null == bCSNIServerName || 0 != bCSNIServerName.getType()) continue;
                if (bCSNIServerName instanceof BCSNIHostName) {
                    return (BCSNIHostName)bCSNIServerName;
                }
                try {
                    return new BCSNIHostName(bCSNIServerName.getEncoded());
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
        }
        return null;
    }

    private static BCExtendedSSLSession getHandshakeSession(SSLEngine sSLEngine) throws CertificateException {
        BCExtendedSSLSession bCExtendedSSLSession = SSLEngineUtil.importHandshakeSession(sSLEngine);
        if (null == bCExtendedSSLSession) {
            throw new CertificateException("No handshake session for engine");
        }
        return bCExtendedSSLSession;
    }

    private static BCExtendedSSLSession getHandshakeSession(SSLSocket sSLSocket) throws CertificateException {
        BCExtendedSSLSession bCExtendedSSLSession = SSLSocketUtil.importHandshakeSession(sSLSocket);
        if (null == bCExtendedSSLSession) {
            throw new CertificateException("No handshake session for socket");
        }
        return bCExtendedSSLSession;
    }

    private static BCSSLParameters getSSLParameters(SSLEngine sSLEngine) throws CertificateException {
        BCSSLParameters bCSSLParameters = SSLEngineUtil.importSSLParameters(sSLEngine);
        if (null == bCSSLParameters) {
            throw new CertificateException("No SSL parameters for engine");
        }
        return bCSSLParameters;
    }

    private static BCSSLParameters getSSLParameters(SSLSocket sSLSocket) throws CertificateException {
        BCSSLParameters bCSSLParameters = SSLSocketUtil.importSSLParameters(sSLSocket);
        if (null == bCSSLParameters) {
            throw new CertificateException("No SSL parameters for socket");
        }
        return bCSSLParameters;
    }
}

