/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerColonyTile;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;
import org.w3c.dom.Element;

public class Game
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Game.class.getName());
    private static final java.util.Map<Class<? extends FreeColObject>, Class<? extends FreeColObject>> serverClasses = new HashMap<Class<? extends FreeColObject>, Class<? extends FreeColObject>>();
    private static final java.util.Map<String, Class<? extends FreeColGameObject>> locationClasses;
    protected int nextId = 1;
    private UUID uuid = UUID.randomUUID();
    private final String clientUserName;
    protected final List<Player> players = new ArrayList<Player>();
    private Player unknownEnemy;
    private Map map = null;
    private NationOptions nationOptions = null;
    protected Player currentPlayer = null;
    private Turn turn = new Turn(1);
    private boolean spanishSuccession = false;
    private Specification specification = null;
    protected final HashMap<String, WeakReference<FreeColGameObject>> freeColGameObjects = new HashMap(10000);
    protected CombatModel combatModel = null;
    private static final int REMOVE_GC_THRESHOLD = 64;
    private int removeCount = 0;
    protected FreeColGameObjectListener freeColGameObjectListener = null;
    private static final String CIBOLA_TAG = "cibola";
    private static final String CURRENT_PLAYER_TAG = "currentPlayer";
    private static final String NEXT_ID_TAG = "nextId";
    private static final String SPANISH_SUCCESSION_TAG = "spanishSuccession";
    private static final String TURN_TAG = "turn";
    private static final String UUID_TAG = "UUID";
    private static final String OLD_NEXT_ID_TAG = "nextID";

    protected Game(Specification specification) {
        super(null);
        this.specification = specification;
        this.clientUserName = null;
    }

    public Game(Element element, String clientUserName) {
        super(null);
        this.clientUserName = clientUserName;
        this.combatModel = new SimpleCombatModel();
        this.readFromXMLElement(element);
        this.setFreeColGameObject(this.getId(), this);
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    public final OptionGroup getDifficultyOptionGroup() {
        return this.specification.getDifficultyOptionGroup();
    }

    public OptionGroup getGameOptions() {
        return this.specification.getGameOptions();
    }

    public void setGameOptions(OptionGroup go) {
        this.specification.setGameOptions(go);
    }

    public OptionGroup getMapGeneratorOptions() {
        return this.specification.getMapGeneratorOptions();
    }

    public void setMapGeneratorOptions(OptionGroup mgo) {
        this.specification.setMapGeneratorOptions(mgo);
    }

    public String getNextId() {
        throw new IllegalStateException("game.getNextId not implemented");
    }

    public FreeColGameObject getFreeColGameObject(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        WeakReference<FreeColGameObject> ro = this.freeColGameObjects.get(id);
        if (ro == null) {
            return null;
        }
        FreeColGameObject o = (FreeColGameObject)ro.get();
        if (o == null) {
            this.removeFreeColGameObject(id, "missed");
            return null;
        }
        return o;
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(String id, Class<T> returnClass) {
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        try {
            return (T)((FreeColGameObject)returnClass.cast(fcgo));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void setFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Null/empty id.");
        }
        if (fcgo == null) {
            throw new IllegalArgumentException("Null FreeColGameObject.");
        }
        FreeColGameObject old = this.getFreeColGameObject(id);
        if (old != null) {
            throw new IllegalArgumentException("Tried to replace FCGO " + id + " : " + old.getClass() + " with " + fcgo.getId() + " : " + fcgo.getClass());
        }
        WeakReference<FreeColGameObject> wr = new WeakReference<FreeColGameObject>(fcgo);
        this.freeColGameObjects.put(id, wr);
        this.notifySetFreeColGameObject(id, fcgo);
    }

    public void removeFreeColGameObject(String id, String reason) {
        if (id == null) {
            throw new IllegalArgumentException("Null identifier.");
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Empty identifier.");
        }
        logger.finest("removeFCGO/" + reason + ": " + id);
        this.freeColGameObjects.remove(id);
        this.notifyRemoveFreeColGameObject(id);
        if (++this.removeCount > 64) {
            for (FreeColGameObject freeColGameObject : this.getFreeColGameObjects()) {
            }
            this.removeCount = 0;
            System.gc();
        }
    }

    public Location findFreeColLocation(String id) {
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        return fcgo instanceof Location ? (Location)((Object)fcgo) : null;
    }

    public Iterator<FreeColGameObject> getFreeColGameObjectIterator() {
        return new Iterator<FreeColGameObject>(){
            private final Iterator<Map.Entry<String, WeakReference<FreeColGameObject>>> it;
            private Map.Entry<String, WeakReference<FreeColGameObject>> readAhead;
            private FcgoState fcgoState;
            {
                this.it = Game.this.freeColGameObjects.entrySet().iterator();
                this.readAhead = null;
                this.fcgoState = FcgoState.INVALID;
            }

            @Override
            public boolean hasNext() {
                if (this.fcgoState == FcgoState.VALID) {
                    return true;
                }
                while (this.it.hasNext()) {
                    this.readAhead = this.it.next();
                    if (this.readAhead.getValue().get() != null) {
                        this.fcgoState = FcgoState.VALID;
                        return true;
                    }
                    this.fcgoState = FcgoState.CONSUMED;
                    this.remove();
                }
                return false;
            }

            @Override
            public FreeColGameObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                FreeColGameObject fcgo = (FreeColGameObject)this.readAhead.getValue().get();
                this.fcgoState = FcgoState.CONSUMED;
                return fcgo;
            }

            @Override
            public void remove() {
                if (this.fcgoState == FcgoState.INVALID) {
                    throw new IllegalStateException("No current entry");
                }
                String key = this.readAhead.getKey();
                this.fcgoState = FcgoState.INVALID;
                this.it.remove();
                logger.finest("removeFCGO/expire: " + key);
                Game.this.notifyRemoveFreeColGameObject(key);
            }
        };
    }

    public Iterable<FreeColGameObject> getFreeColGameObjects() {
        return new Iterable<FreeColGameObject>(){

            @Override
            public Iterator<FreeColGameObject> iterator() {
                return Game.this.getFreeColGameObjectIterator();
            }
        };
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public Player getPlayerByNation(Nation nation) {
        return this.getPlayerByNationId(nation.getId());
    }

    public Player getPlayerByNationId(String nationId) {
        return CollectionUtils.find(this.players, p -> p.getNationId().equals(nationId));
    }

    public List<Player> getLivePlayers(Player other) {
        return this.players.stream().filter(p -> !p.isUnknownEnemy() && !p.isDead() && p != other).collect(Collectors.toList());
    }

    public List<Player> getOtherLivePlayers(Player ... players) {
        List<Player> result = this.getLivePlayers(null);
        for (Player other : players) {
            result.remove(other);
        }
        return result;
    }

    public List<Player> getLiveEuropeanPlayers(Player other) {
        return this.players.stream().filter(p -> !p.isUnknownEnemy() && !p.isDead() && p != other && p.isEuropean()).collect(Collectors.toList());
    }

    public List<Player> getLiveNativePlayers(Player other) {
        return this.players.stream().filter(p -> !p.isUnknownEnemy() && !p.isDead() && p != other && p.isIndian()).collect(Collectors.toList());
    }

    public Player getNextPlayer() {
        return this.getPlayerAfter(this.currentPlayer);
    }

    public Player getPlayerAfter(Player beforePlayer) {
        int start;
        if (this.players.isEmpty()) {
            return null;
        }
        int index = start = this.players.indexOf(beforePlayer);
        do {
            Player player;
            if (++index >= this.players.size()) {
                index = 0;
            }
            if ((player = this.players.get(index)).isUnknownEnemy() || player.isDead()) continue;
            return player;
        } while (index != start);
        return null;
    }

    public Player getFirstPlayer() {
        return this.players.isEmpty() ? null : this.players.get(0);
    }

    public Player getPlayerByName(String name) {
        return CollectionUtils.find(this.players, p -> p.getName().equals(name));
    }

    public boolean playerNameInUse(String name) {
        return this.getPlayerByName(name) != null;
    }

    public boolean addPlayer(Player player) {
        if (player.isAI() || this.canAddNewPlayer()) {
            this.players.add(player);
            Nation nation = this.getSpecification().getNation(player.getNationId());
            this.nationOptions.getNations().put(nation, NationOptions.NationState.NOT_AVAILABLE);
            if (this.currentPlayer == null) {
                this.currentPlayer = player;
            }
            return true;
        }
        logger.warning("Game already full, but tried to add: " + player.getName());
        return false;
    }

    public boolean removePlayer(Player player) {
        Player newCurrent;
        Player player2 = newCurrent = this.currentPlayer != player ? null : this.getPlayerAfter(this.currentPlayer);
        if (!this.players.remove(player)) {
            return false;
        }
        Nation nation = this.getSpecification().getNation(player.getNationId());
        this.nationOptions.getNations().put(nation, NationOptions.NationState.AVAILABLE);
        player.dispose();
        if (newCurrent != null) {
            this.currentPlayer = newCurrent;
        }
        return true;
    }

    public Player getUnknownEnemy() {
        return this.unknownEnemy;
    }

    public void setUnknownEnemy(Player player) {
        this.unknownEnemy = player;
    }

    public Player getClientPlayer() {
        return this.clientUserName == null ? null : this.getPlayerByName(this.clientUserName);
    }

    public boolean isInClient() {
        return this.clientUserName != null;
    }

    public boolean isInServer() {
        return this.clientUserName == null;
    }

    public boolean isInRevengeMode() {
        return CollectionUtils.contains(this.getPlayers(), Player::isUndead);
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(Player newCurrentPlayer) {
        this.currentPlayer = newCurrentPlayer;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map newMap) {
        if (this.map != newMap) {
            for (Player player : this.getLivePlayers(null)) {
                if (player.getHighSeas() == null) continue;
                player.getHighSeas().removeDestination(this.map);
                player.getHighSeas().addDestination(newMap);
            }
        }
        this.map = newMap;
    }

    public final NationOptions getNationOptions() {
        return this.nationOptions;
    }

    public final void setNationOptions(NationOptions newNationOptions) {
        this.nationOptions = newNationOptions;
    }

    public Nation getVacantNation() {
        Map.Entry entry = CollectionUtils.find(this.nationOptions.getNations().entrySet(), e -> e.getValue() == NationOptions.NationState.AVAILABLE, null);
        return entry == null ? null : (Nation)entry.getKey();
    }

    public final List<Nation> getVacantNations() {
        ArrayList<Nation> result = new ArrayList<Nation>();
        for (Map.Entry<Nation, NationOptions.NationState> entry : this.nationOptions.getNations().entrySet()) {
            if (entry.getValue() != NationOptions.NationState.AVAILABLE) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public boolean canAddNewPlayer() {
        return this.getVacantNation() != null;
    }

    public Turn getTurn() {
        return this.turn;
    }

    public void setTurn(Turn newTurn) {
        this.turn = newTurn;
    }

    public int getAge() {
        return this.getSpecification().getAge(this.turn);
    }

    public final CombatModel getCombatModel() {
        return this.combatModel;
    }

    public final void setCombatModel(CombatModel newCombatModel) {
        this.combatModel = newCombatModel;
    }

    public final boolean getSpanishSuccession() {
        return this.spanishSuccession;
    }

    public final void setSpanishSuccession(boolean spanishSuccession) {
        this.spanishSuccession = spanishSuccession;
    }

    public void setFreeColGameObjectListener(FreeColGameObjectListener fcgol) {
        this.freeColGameObjectListener = fcgol;
    }

    public void notifySetFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.setFreeColGameObject(id, fcgo);
        }
    }

    public void notifyRemoveFreeColGameObject(String id) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.removeFreeColGameObject(id);
        }
    }

    public void notifyOwnerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.ownerChanged(source, oldOwner, newOwner);
        }
    }

    public void checkOwners(Ownable o, Player oldOwner) {
        Player newOwner = o.getOwner();
        if (oldOwner == newOwner) {
            return;
        }
        if (oldOwner != null && oldOwner.removeOwnable(o)) {
            oldOwner.invalidateCanSeeTiles();
        }
        if (newOwner != null && newOwner.addOwnable(o)) {
            newOwner.invalidateCanSeeTiles();
        }
    }

    public boolean allPlayersReadyToLaunch() {
        return CollectionUtils.all(this.getLivePlayers(null), Player::isReady);
    }

    public Settlement getSettlementByName(String name) {
        for (Player p : this.getLivePlayers(null)) {
            for (Settlement s : p.getSettlements()) {
                if (!name.equals(s.getName())) continue;
                return s;
            }
        }
        return null;
    }

    public FreeColGameObject getMessageSource(ModelMessage message) {
        return this.getFreeColGameObject(message.getSourceId());
    }

    public FreeColObject getMessageDisplay(ModelMessage message) {
        FreeColObject o;
        String id = message.getDisplayId();
        if (id == null) {
            id = message.getSourceId();
        }
        if ((o = this.getFreeColGameObject(id)) == null) {
            try {
                o = this.getSpecification().findType(id);
            }
            catch (Exception e) {
                o = null;
            }
        }
        return o;
    }

    public java.util.Map<String, String> getStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        System.gc();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        stats.put("freeMemory", Long.toString(free));
        stats.put("totalMemory", Long.toString(total));
        stats.put("maxMemory", Long.toString(max));
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        long disposed = 0L;
        for (FreeColGameObject freeColGameObject : this.getFreeColGameObjects()) {
            Long count;
            String className = freeColGameObject.getClass().getSimpleName();
            if (objStats.containsKey(className)) {
                Long l = count = (Long)objStats.get(className);
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
            } else {
                count = 1L;
                objStats.put(className, count);
            }
            if (!freeColGameObject.isDisposed()) continue;
            ++disposed;
        }
        stats.put("disposed", Long.toString(disposed));
        for (Map.Entry entry : objStats.entrySet()) {
            stats.put((String)entry.getKey(), Long.toString((Long)entry.getValue()));
        }
        return stats;
    }

    public static Class<? extends FreeColGameObject> getLocationClass(String id) {
        String tag = FreeColObject.getIdType(id);
        tag = Character.toUpperCase(tag.charAt(0)) + tag.substring(1);
        return locationClasses.get(tag);
    }

    private static <T extends FreeColObject> Class<T> serverClass(Class<T> c) {
        Class<? extends FreeColObject> rc = serverClasses.get(c);
        return rc == null ? c : rc;
    }

    public <T extends FreeColObject> T newInstance(Class<T> returnClass, boolean server) throws IOException {
        Class<T> rc = server ? Game.serverClass(returnClass) : returnClass;
        try {
            Constructor<T> c = rc.getConstructor(Game.class, String.class);
            return (T)((FreeColObject)c.newInstance(this, null));
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException(nsme);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T extends FreeColObject> T unserialize(String xml, Class<T> returnClass) throws XMLStreamException {
        try {
            FreeColXMLReader xr = new FreeColXMLReader(new StringReader(xml));
            xr.nextTag();
            T ret = this.newInstance(returnClass, false);
            ((FreeColObject)ret).readFromXML(xr);
            return ret;
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    @Override
    public int checkIntegrity(boolean fix) {
        Map map;
        int result = super.checkIntegrity(fix);
        LogBuilder lb = new LogBuilder(512);
        lb.add("Uninitialized game ids: ");
        lb.mark();
        Iterator<FreeColGameObject> iterator = this.getFreeColGameObjectIterator();
        while (iterator.hasNext()) {
            FreeColGameObject fcgo = iterator.next();
            if (fcgo == null) {
                lb.add(" null-fcgo");
            } else {
                if (!fcgo.isUninitialized()) continue;
                lb.add(" ", fcgo.getId(), "(", StringUtils.lastPart(fcgo.getClass().getName(), "."), ")");
            }
            if (fix) {
                iterator.remove();
                result = Math.min(result, 0);
                continue;
            }
            result = -1;
        }
        if (lb.grew(new Object[0])) {
            if (fix) {
                lb.add(" (dropped)");
            }
            lb.log(logger, Level.WARNING);
        }
        if ((map = this.getMap()) != null) {
            result = Math.min(result, this.getMap().checkIntegrity(fix));
        }
        for (Player player : this.getPlayers()) {
            result = Math.min(result, player.checkIntegrity(fix));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.getId());
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (xw.validForSave()) {
            xw.writeAttribute(NEXT_ID_TAG, this.nextId);
        }
        xw.writeAttribute(UUID_TAG, this.getUUID());
        xw.writeAttribute(TURN_TAG, this.getTurn().getNumber());
        xw.writeAttribute(SPANISH_SUCCESSION_TAG, this.spanishSuccession);
        if (this.currentPlayer != null) {
            xw.writeAttribute(CURRENT_PLAYER_TAG, this.currentPlayer);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.specification.toXML(xw);
        for (String cityName : NameCache.getCitiesOfCibola()) {
            xw.writeStartElement(CIBOLA_TAG);
            xw.writeAttribute("id", cityName);
            xw.writeEndElement();
        }
        this.nationOptions.toXML(xw);
        List<Player> players = Game.getSortedCopy(this.getPlayers());
        Player unknown = this.getUnknownEnemy();
        if (unknown != null) {
            players.add(unknown);
        }
        for (Player p : players) {
            p.toXML(xw);
        }
        if (this.map != null) {
            this.map.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        String str;
        super.readAttributes(xr);
        this.nextId = xr.getAttribute(NEXT_ID_TAG, -1);
        if (this.nextId < 0) {
            this.nextId = xr.getAttribute(OLD_NEXT_ID_TAG, 0);
        }
        if ((str = xr.getAttribute(UUID_TAG, null)) != null) {
            try {
                UUID u;
                this.uuid = u = UUID.fromString(str);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.turn = new Turn(xr.getAttribute(TURN_TAG, 1));
        this.spanishSuccession = xr.getAttribute(SPANISH_SUCCESSION_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        NameCache.clearCitiesOfCibola();
        this.players.clear();
        this.unknownEnemy = null;
        String current = xr.getAttribute(CURRENT_PLAYER_TAG, null);
        super.readChildren(xr);
        for (Player player : this.getLiveEuropeanPlayers(null)) {
            for (Unit unit : player.getUnits()) {
                if (!unit.isInColony()) continue;
                unit.getWorkLocation().updateProductionType();
            }
        }
        this.currentPlayer = current == null ? null : this.getFreeColGameObject(current, Player.class);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (CIBOLA_TAG.equals(tag)) {
            String cibola = xr.readId();
            String oldPrefix = "lostCityRumour.cityName";
            if (cibola.startsWith("lostCityRumour.cityName")) {
                cibola = "nameCache." + cibola;
            }
            NameCache.addCityOfCibola(cibola);
            xr.closeTag(CIBOLA_TAG);
        } else if (Map.getXMLElementTagName().equals(tag)) {
            this.map = xr.readFreeColGameObject(game, Map.class);
        } else if (NationOptions.getXMLElementTagName().equals(tag)) {
            this.nationOptions = new NationOptions(xr, this.specification);
        } else if (Player.getXMLElementTagName().equals(tag)) {
            Player player = xr.readFreeColGameObject(game, Player.class);
            if (player.isUnknownEnemy()) {
                this.setUnknownEnemy(player);
            } else {
                this.players.add(player);
            }
        } else if (Specification.getXMLElementTagName().equals(tag)) {
            logger.info((this.specification == null ? "Loading" : "Reloading") + " specification.");
            this.specification = new Specification(xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return Game.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "game";
    }

    static {
        serverClasses.put(Building.class, ServerBuilding.class);
        serverClasses.put(Colony.class, ServerColony.class);
        serverClasses.put(ColonyTile.class, ServerColonyTile.class);
        serverClasses.put(Europe.class, ServerEurope.class);
        serverClasses.put(Game.class, ServerGame.class);
        serverClasses.put(IndianSettlement.class, ServerIndianSettlement.class);
        serverClasses.put(Region.class, ServerRegion.class);
        serverClasses.put(Player.class, ServerPlayer.class);
        serverClasses.put(Unit.class, ServerUnit.class);
        locationClasses = new HashMap<String, Class<? extends FreeColGameObject>>();
        locationClasses.put("Building", Building.class);
        locationClasses.put("Colony", Colony.class);
        locationClasses.put("ColonyTile", ColonyTile.class);
        locationClasses.put("Europe", Europe.class);
        locationClasses.put("HighSeas", HighSeas.class);
        locationClasses.put("IndianSettlement", IndianSettlement.class);
        locationClasses.put("Map", Map.class);
        locationClasses.put("Tile", Tile.class);
        locationClasses.put("Unit", Unit.class);
    }

    private static enum FcgoState {
        INVALID,
        VALID,
        CONSUMED;

    }
}

