
#pragma once


#include <glbinding/nogl.h>

#include <glbinding/glbinding_features.h>


namespace gl
{


enum class GLenum : unsigned int
{
    // AccumOp

    GL_ACCUM                                                      = 0x0100, // decimal value: 256
    GL_LOAD                                                       = 0x0101, // decimal value: 257
    GL_RETURN                                                     = 0x0102, // decimal value: 258
    GL_MULT                                                       = 0x0103, // decimal value: 259
    GL_ADD                                                        = 0x0104, // decimal value: 260

    // AlphaFunction

    GL_NEVER                                                      = 0x0200, // decimal value: 512
    GL_LESS                                                       = 0x0201, // decimal value: 513
    GL_EQUAL                                                      = 0x0202, // decimal value: 514
    GL_LEQUAL                                                     = 0x0203, // decimal value: 515
    GL_GREATER                                                    = 0x0204, // decimal value: 516
    GL_NOTEQUAL                                                   = 0x0205, // decimal value: 517
    GL_GEQUAL                                                     = 0x0206, // decimal value: 518
    GL_ALWAYS                                                     = 0x0207, // decimal value: 519

    // AtomicCounterBufferPName

    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER         = 0x90ED, // decimal value: 37101
    GL_ATOMIC_COUNTER_BUFFER_BINDING                              = 0x92C1, // decimal value: 37569
    GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE                            = 0x92C4, // decimal value: 37572
    GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS               = 0x92C5, // decimal value: 37573
    GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES        = 0x92C6, // decimal value: 37574
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER          = 0x92C7, // decimal value: 37575
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER    = 0x92C8, // decimal value: 37576
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9, // decimal value: 37577
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER        = 0x92CA, // decimal value: 37578
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER        = 0x92CB, // decimal value: 37579

    // AttributeType

    GL_FLOAT_VEC2                                                 = 0x8B50, // decimal value: 35664
    GL_FLOAT_VEC2_ARB                                             = 0x8B50, // decimal value: 35664
    GL_FLOAT_VEC3                                                 = 0x8B51, // decimal value: 35665
    GL_FLOAT_VEC3_ARB                                             = 0x8B51, // decimal value: 35665
    GL_FLOAT_VEC4                                                 = 0x8B52, // decimal value: 35666
    GL_FLOAT_VEC4_ARB                                             = 0x8B52, // decimal value: 35666
    GL_INT_VEC2                                                   = 0x8B53, // decimal value: 35667
    GL_INT_VEC2_ARB                                               = 0x8B53, // decimal value: 35667
    GL_INT_VEC3                                                   = 0x8B54, // decimal value: 35668
    GL_INT_VEC3_ARB                                               = 0x8B54, // decimal value: 35668
    GL_INT_VEC4                                                   = 0x8B55, // decimal value: 35669
    GL_INT_VEC4_ARB                                               = 0x8B55, // decimal value: 35669
    GL_BOOL                                                       = 0x8B56, // decimal value: 35670
    GL_BOOL_ARB                                                   = 0x8B56, // decimal value: 35670
    GL_BOOL_VEC2                                                  = 0x8B57, // decimal value: 35671
    GL_BOOL_VEC2_ARB                                              = 0x8B57, // decimal value: 35671
    GL_BOOL_VEC3                                                  = 0x8B58, // decimal value: 35672
    GL_BOOL_VEC3_ARB                                              = 0x8B58, // decimal value: 35672
    GL_BOOL_VEC4                                                  = 0x8B59, // decimal value: 35673
    GL_BOOL_VEC4_ARB                                              = 0x8B59, // decimal value: 35673
    GL_FLOAT_MAT2                                                 = 0x8B5A, // decimal value: 35674
    GL_FLOAT_MAT2_ARB                                             = 0x8B5A, // decimal value: 35674
    GL_FLOAT_MAT3                                                 = 0x8B5B, // decimal value: 35675
    GL_FLOAT_MAT3_ARB                                             = 0x8B5B, // decimal value: 35675
    GL_FLOAT_MAT4                                                 = 0x8B5C, // decimal value: 35676
    GL_FLOAT_MAT4_ARB                                             = 0x8B5C, // decimal value: 35676
    GL_SAMPLER_1D                                                 = 0x8B5D, // decimal value: 35677
    GL_SAMPLER_1D_ARB                                             = 0x8B5D, // decimal value: 35677
    GL_SAMPLER_2D                                                 = 0x8B5E, // decimal value: 35678
    GL_SAMPLER_2D_ARB                                             = 0x8B5E, // decimal value: 35678
    GL_SAMPLER_3D                                                 = 0x8B5F, // decimal value: 35679
    GL_SAMPLER_3D_ARB                                             = 0x8B5F, // decimal value: 35679
    GL_SAMPLER_3D_OES                                             = 0x8B5F, // decimal value: 35679
    GL_SAMPLER_CUBE                                               = 0x8B60, // decimal value: 35680
    GL_SAMPLER_CUBE_ARB                                           = 0x8B60, // decimal value: 35680
    GL_SAMPLER_1D_SHADOW                                          = 0x8B61, // decimal value: 35681
    GL_SAMPLER_1D_SHADOW_ARB                                      = 0x8B61, // decimal value: 35681
    GL_SAMPLER_2D_SHADOW                                          = 0x8B62, // decimal value: 35682
    GL_SAMPLER_2D_SHADOW_ARB                                      = 0x8B62, // decimal value: 35682
    GL_SAMPLER_2D_SHADOW_EXT                                      = 0x8B62, // decimal value: 35682
    GL_SAMPLER_2D_RECT                                            = 0x8B63, // decimal value: 35683
    GL_SAMPLER_2D_RECT_ARB                                        = 0x8B63, // decimal value: 35683
    GL_SAMPLER_2D_RECT_SHADOW                                     = 0x8B64, // decimal value: 35684
    GL_SAMPLER_2D_RECT_SHADOW_ARB                                 = 0x8B64, // decimal value: 35684
    GL_FLOAT_MAT2x3                                               = 0x8B65, // decimal value: 35685
    GL_FLOAT_MAT2x3_NV                                            = 0x8B65, // decimal value: 35685
    GL_FLOAT_MAT2x4                                               = 0x8B66, // decimal value: 35686
    GL_FLOAT_MAT2x4_NV                                            = 0x8B66, // decimal value: 35686
    GL_FLOAT_MAT3x2                                               = 0x8B67, // decimal value: 35687
    GL_FLOAT_MAT3x2_NV                                            = 0x8B67, // decimal value: 35687
    GL_FLOAT_MAT3x4                                               = 0x8B68, // decimal value: 35688
    GL_FLOAT_MAT3x4_NV                                            = 0x8B68, // decimal value: 35688
    GL_FLOAT_MAT4x2                                               = 0x8B69, // decimal value: 35689
    GL_FLOAT_MAT4x2_NV                                            = 0x8B69, // decimal value: 35689
    GL_FLOAT_MAT4x3                                               = 0x8B6A, // decimal value: 35690
    GL_FLOAT_MAT4x3_NV                                            = 0x8B6A, // decimal value: 35690

    // BindTransformFeedbackTarget

    GL_TRANSFORM_FEEDBACK                                         = 0x8E22, // decimal value: 36386

    // BlendEquationModeEXT

    GL_LOGIC_OP                                                   = 0x0BF1, // decimal value: 3057
    GL_FUNC_ADD                                                   = 0x8006, // decimal value: 32774
    GL_FUNC_ADD_EXT                                               = 0x8006, // decimal value: 32774
    GL_MIN_EXT                                                    = 0x8007, // decimal value: 32775
    GL_MAX_EXT                                                    = 0x8008, // decimal value: 32776
    GL_FUNC_SUBTRACT                                              = 0x800A, // decimal value: 32778
    GL_FUNC_SUBTRACT_EXT                                          = 0x800A, // decimal value: 32778
    GL_FUNC_REVERSE_SUBTRACT                                      = 0x800B, // decimal value: 32779
    GL_FUNC_REVERSE_SUBTRACT_EXT                                  = 0x800B, // decimal value: 32779
    GL_ALPHA_MIN_SGIX                                             = 0x8320, // decimal value: 33568
    GL_ALPHA_MAX_SGIX                                             = 0x8321, // decimal value: 33569

    // BlendingFactor

    GL_ZERO                                                       = 0,
    GL_SRC_COLOR                                                  = 0x0300, // decimal value: 768
    GL_ONE_MINUS_SRC_COLOR                                        = 0x0301, // decimal value: 769
    GL_SRC_ALPHA                                                  = 0x0302, // decimal value: 770
    GL_ONE_MINUS_SRC_ALPHA                                        = 0x0303, // decimal value: 771
    GL_DST_ALPHA                                                  = 0x0304, // decimal value: 772
    GL_ONE_MINUS_DST_ALPHA                                        = 0x0305, // decimal value: 773
    GL_DST_COLOR                                                  = 0x0306, // decimal value: 774
    GL_ONE_MINUS_DST_COLOR                                        = 0x0307, // decimal value: 775
    GL_SRC_ALPHA_SATURATE                                         = 0x0308, // decimal value: 776
    GL_CONSTANT_COLOR                                             = 0x8001, // decimal value: 32769
    GL_ONE_MINUS_CONSTANT_COLOR                                   = 0x8002, // decimal value: 32770
    GL_CONSTANT_ALPHA                                             = 0x8003, // decimal value: 32771
    GL_ONE_MINUS_CONSTANT_ALPHA                                   = 0x8004, // decimal value: 32772
    GL_SRC1_ALPHA                                                 = 0x8589, // decimal value: 34185
    GL_SRC1_COLOR                                                 = 0x88F9, // decimal value: 35065
    GL_ONE_MINUS_SRC1_COLOR                                       = 0x88FA, // decimal value: 35066
    GL_ONE_MINUS_SRC1_ALPHA                                       = 0x88FB, // decimal value: 35067
    GL_ONE                                                        = 1,

    // BlitFramebufferFilter

    GL_NEAREST                                                    = 0x2600, // decimal value: 9728
    GL_LINEAR                                                     = 0x2601, // decimal value: 9729

    // Buffer

    GL_COLOR                                                      = 0x1800, // decimal value: 6144
    GL_DEPTH                                                      = 0x1801, // decimal value: 6145
    GL_STENCIL                                                    = 0x1802, // decimal value: 6146

    // BufferAccessARB

    GL_READ_ONLY                                                  = 0x88B8, // decimal value: 35000
    GL_WRITE_ONLY                                                 = 0x88B9, // decimal value: 35001
    GL_READ_WRITE                                                 = 0x88BA, // decimal value: 35002

    // BufferStorageTarget

    GL_ARRAY_BUFFER                                               = 0x8892, // decimal value: 34962
    GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893, // decimal value: 34963
    GL_PIXEL_PACK_BUFFER                                          = 0x88EB, // decimal value: 35051
    GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC, // decimal value: 35052
    GL_UNIFORM_BUFFER                                             = 0x8A11, // decimal value: 35345
    GL_TEXTURE_BUFFER                                             = 0x8C2A, // decimal value: 35882
    GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // decimal value: 35982
    GL_COPY_READ_BUFFER                                           = 0x8F36, // decimal value: 36662
    GL_COPY_WRITE_BUFFER                                          = 0x8F37, // decimal value: 36663
    GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F, // decimal value: 36671
    GL_SHADER_STORAGE_BUFFER                                      = 0x90D2, // decimal value: 37074
    GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE, // decimal value: 37102
    GL_QUERY_BUFFER                                               = 0x9192, // decimal value: 37266
    GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0, // decimal value: 37568

    // BufferTargetARB

//  GL_ARRAY_BUFFER                                               = 0x8892, // reuse BufferStorageTarget, decimal value: 34962
//  GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893, // reuse BufferStorageTarget, decimal value: 34963
//  GL_PIXEL_PACK_BUFFER                                          = 0x88EB, // reuse BufferStorageTarget, decimal value: 35051
//  GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC, // reuse BufferStorageTarget, decimal value: 35052
//  GL_UNIFORM_BUFFER                                             = 0x8A11, // reuse BufferStorageTarget, decimal value: 35345
//  GL_TEXTURE_BUFFER                                             = 0x8C2A, // reuse BufferStorageTarget, decimal value: 35882
//  GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // reuse BufferStorageTarget, decimal value: 35982
//  GL_COPY_READ_BUFFER                                           = 0x8F36, // reuse BufferStorageTarget, decimal value: 36662
//  GL_COPY_WRITE_BUFFER                                          = 0x8F37, // reuse BufferStorageTarget, decimal value: 36663
//  GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F, // reuse BufferStorageTarget, decimal value: 36671
//  GL_SHADER_STORAGE_BUFFER                                      = 0x90D2, // reuse BufferStorageTarget, decimal value: 37074
//  GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE, // reuse BufferStorageTarget, decimal value: 37102
//  GL_QUERY_BUFFER                                               = 0x9192, // reuse BufferStorageTarget, decimal value: 37266
//  GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0, // reuse BufferStorageTarget, decimal value: 37568

    // BufferUsageARB

    GL_STREAM_DRAW                                                = 0x88E0, // decimal value: 35040
    GL_STREAM_READ                                                = 0x88E1, // decimal value: 35041
    GL_STREAM_COPY                                                = 0x88E2, // decimal value: 35042
    GL_STATIC_DRAW                                                = 0x88E4, // decimal value: 35044
    GL_STATIC_READ                                                = 0x88E5, // decimal value: 35045
    GL_STATIC_COPY                                                = 0x88E6, // decimal value: 35046
    GL_DYNAMIC_DRAW                                               = 0x88E8, // decimal value: 35048
    GL_DYNAMIC_READ                                               = 0x88E9, // decimal value: 35049
    GL_DYNAMIC_COPY                                               = 0x88EA, // decimal value: 35050

    // CheckFramebufferStatusTarget

    GL_READ_FRAMEBUFFER                                           = 0x8CA8, // decimal value: 36008
    GL_DRAW_FRAMEBUFFER                                           = 0x8CA9, // decimal value: 36009
    GL_FRAMEBUFFER                                                = 0x8D40, // decimal value: 36160

    // ClipControlDepth

    GL_NEGATIVE_ONE_TO_ONE                                        = 0x935E, // decimal value: 37726
    GL_ZERO_TO_ONE                                                = 0x935F, // decimal value: 37727

    // ClipControlOrigin

    GL_LOWER_LEFT                                                 = 0x8CA1, // decimal value: 36001
    GL_UPPER_LEFT                                                 = 0x8CA2, // decimal value: 36002

    // ClipPlaneName

    GL_CLIP_DISTANCE0                                             = 0x3000, // decimal value: 12288
    GL_CLIP_PLANE0                                                = 0x3000, // decimal value: 12288
    GL_CLIP_DISTANCE1                                             = 0x3001, // decimal value: 12289
    GL_CLIP_PLANE1                                                = 0x3001, // decimal value: 12289
    GL_CLIP_DISTANCE2                                             = 0x3002, // decimal value: 12290
    GL_CLIP_PLANE2                                                = 0x3002, // decimal value: 12290
    GL_CLIP_DISTANCE3                                             = 0x3003, // decimal value: 12291
    GL_CLIP_PLANE3                                                = 0x3003, // decimal value: 12291
    GL_CLIP_DISTANCE4                                             = 0x3004, // decimal value: 12292
    GL_CLIP_PLANE4                                                = 0x3004, // decimal value: 12292
    GL_CLIP_DISTANCE5                                             = 0x3005, // decimal value: 12293
    GL_CLIP_PLANE5                                                = 0x3005, // decimal value: 12293
    GL_CLIP_DISTANCE6                                             = 0x3006, // decimal value: 12294
    GL_CLIP_DISTANCE7                                             = 0x3007, // decimal value: 12295

    // ColorBuffer

    GL_NONE                                                       = 0,
    GL_FRONT_LEFT                                                 = 0x0400, // decimal value: 1024
    GL_FRONT_RIGHT                                                = 0x0401, // decimal value: 1025
    GL_BACK_LEFT                                                  = 0x0402, // decimal value: 1026
    GL_BACK_RIGHT                                                 = 0x0403, // decimal value: 1027
    GL_FRONT                                                      = 0x0404, // decimal value: 1028
    GL_BACK                                                       = 0x0405, // decimal value: 1029
    GL_LEFT                                                       = 0x0406, // decimal value: 1030
    GL_RIGHT                                                      = 0x0407, // decimal value: 1031
    GL_FRONT_AND_BACK                                             = 0x0408, // decimal value: 1032
    GL_COLOR_ATTACHMENT0                                          = 0x8CE0, // decimal value: 36064
    GL_COLOR_ATTACHMENT1                                          = 0x8CE1, // decimal value: 36065
    GL_COLOR_ATTACHMENT2                                          = 0x8CE2, // decimal value: 36066
    GL_COLOR_ATTACHMENT3                                          = 0x8CE3, // decimal value: 36067
    GL_COLOR_ATTACHMENT4                                          = 0x8CE4, // decimal value: 36068
    GL_COLOR_ATTACHMENT5                                          = 0x8CE5, // decimal value: 36069
    GL_COLOR_ATTACHMENT6                                          = 0x8CE6, // decimal value: 36070
    GL_COLOR_ATTACHMENT7                                          = 0x8CE7, // decimal value: 36071
    GL_COLOR_ATTACHMENT8                                          = 0x8CE8, // decimal value: 36072
    GL_COLOR_ATTACHMENT9                                          = 0x8CE9, // decimal value: 36073
    GL_COLOR_ATTACHMENT10                                         = 0x8CEA, // decimal value: 36074
    GL_COLOR_ATTACHMENT11                                         = 0x8CEB, // decimal value: 36075
    GL_COLOR_ATTACHMENT12                                         = 0x8CEC, // decimal value: 36076
    GL_COLOR_ATTACHMENT13                                         = 0x8CED, // decimal value: 36077
    GL_COLOR_ATTACHMENT14                                         = 0x8CEE, // decimal value: 36078
    GL_COLOR_ATTACHMENT15                                         = 0x8CEF, // decimal value: 36079
    GL_COLOR_ATTACHMENT16                                         = 0x8CF0, // decimal value: 36080
    GL_COLOR_ATTACHMENT17                                         = 0x8CF1, // decimal value: 36081
    GL_COLOR_ATTACHMENT18                                         = 0x8CF2, // decimal value: 36082
    GL_COLOR_ATTACHMENT19                                         = 0x8CF3, // decimal value: 36083
    GL_COLOR_ATTACHMENT20                                         = 0x8CF4, // decimal value: 36084
    GL_COLOR_ATTACHMENT21                                         = 0x8CF5, // decimal value: 36085
    GL_COLOR_ATTACHMENT22                                         = 0x8CF6, // decimal value: 36086
    GL_COLOR_ATTACHMENT23                                         = 0x8CF7, // decimal value: 36087
    GL_COLOR_ATTACHMENT24                                         = 0x8CF8, // decimal value: 36088
    GL_COLOR_ATTACHMENT25                                         = 0x8CF9, // decimal value: 36089
    GL_COLOR_ATTACHMENT26                                         = 0x8CFA, // decimal value: 36090
    GL_COLOR_ATTACHMENT27                                         = 0x8CFB, // decimal value: 36091
    GL_COLOR_ATTACHMENT28                                         = 0x8CFC, // decimal value: 36092
    GL_COLOR_ATTACHMENT29                                         = 0x8CFD, // decimal value: 36093
    GL_COLOR_ATTACHMENT30                                         = 0x8CFE, // decimal value: 36094
    GL_COLOR_ATTACHMENT31                                         = 0x8CFF, // decimal value: 36095

    // ColorMaterialFace

//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer, decimal value: 1028
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer, decimal value: 1029
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer, decimal value: 1032

    // ColorMaterialParameter

    GL_AMBIENT                                                    = 0x1200, // decimal value: 4608
    GL_DIFFUSE                                                    = 0x1201, // decimal value: 4609
    GL_SPECULAR                                                   = 0x1202, // decimal value: 4610
    GL_EMISSION                                                   = 0x1600, // decimal value: 5632
    GL_AMBIENT_AND_DIFFUSE                                        = 0x1602, // decimal value: 5634

    // ColorPointerType

    GL_BYTE                                                       = 0x1400, // decimal value: 5120
    GL_UNSIGNED_BYTE                                              = 0x1401, // decimal value: 5121
    GL_SHORT                                                      = 0x1402, // decimal value: 5122
    GL_UNSIGNED_SHORT                                             = 0x1403, // decimal value: 5123
    GL_INT                                                        = 0x1404, // decimal value: 5124
    GL_UNSIGNED_INT                                               = 0x1405, // decimal value: 5125
    GL_FLOAT                                                      = 0x1406, // decimal value: 5126
    GL_DOUBLE                                                     = 0x140A, // decimal value: 5130

    // ColorTableParameterPNameSGI

    GL_COLOR_TABLE_SCALE                                          = 0x80D6, // decimal value: 32982
    GL_COLOR_TABLE_SCALE_SGI                                      = 0x80D6, // decimal value: 32982
    GL_COLOR_TABLE_BIAS                                           = 0x80D7, // decimal value: 32983
    GL_COLOR_TABLE_BIAS_SGI                                       = 0x80D7, // decimal value: 32983

    // ColorTableTarget

    GL_COLOR_TABLE                                                = 0x80D0, // decimal value: 32976
    GL_POST_CONVOLUTION_COLOR_TABLE                               = 0x80D1, // decimal value: 32977
    GL_POST_COLOR_MATRIX_COLOR_TABLE                              = 0x80D2, // decimal value: 32978

    // ColorTableTargetSGI

    GL_TEXTURE_COLOR_TABLE_SGI                                    = 0x80BC, // decimal value: 32956
    GL_PROXY_TEXTURE_COLOR_TABLE_SGI                              = 0x80BD, // decimal value: 32957
//  GL_COLOR_TABLE                                                = 0x80D0, // reuse ColorTableTarget, decimal value: 32976
    GL_COLOR_TABLE_SGI                                            = 0x80D0, // decimal value: 32976
//  GL_POST_CONVOLUTION_COLOR_TABLE                               = 0x80D1, // reuse ColorTableTarget, decimal value: 32977
    GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           = 0x80D1, // decimal value: 32977
//  GL_POST_COLOR_MATRIX_COLOR_TABLE                              = 0x80D2, // reuse ColorTableTarget, decimal value: 32978
    GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          = 0x80D2, // decimal value: 32978
    GL_PROXY_COLOR_TABLE                                          = 0x80D3, // decimal value: 32979
    GL_PROXY_COLOR_TABLE_SGI                                      = 0x80D3, // decimal value: 32979
    GL_PROXY_POST_CONVOLUTION_COLOR_TABLE                         = 0x80D4, // decimal value: 32980
    GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI                     = 0x80D4, // decimal value: 32980
    GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE                        = 0x80D5, // decimal value: 32981
    GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI                    = 0x80D5, // decimal value: 32981

    // ConvolutionBorderModeEXT

    GL_REDUCE                                                     = 0x8016, // decimal value: 32790
    GL_REDUCE_EXT                                                 = 0x8016, // decimal value: 32790

    // ConvolutionParameterEXT

    GL_CONVOLUTION_BORDER_MODE                                    = 0x8013, // decimal value: 32787
    GL_CONVOLUTION_BORDER_MODE_EXT                                = 0x8013, // decimal value: 32787
    GL_CONVOLUTION_FILTER_SCALE                                   = 0x8014, // decimal value: 32788
    GL_CONVOLUTION_FILTER_SCALE_EXT                               = 0x8014, // decimal value: 32788
    GL_CONVOLUTION_FILTER_BIAS                                    = 0x8015, // decimal value: 32789
    GL_CONVOLUTION_FILTER_BIAS_EXT                                = 0x8015, // decimal value: 32789

    // ConvolutionTarget

    GL_CONVOLUTION_1D                                             = 0x8010, // decimal value: 32784
    GL_CONVOLUTION_2D                                             = 0x8011, // decimal value: 32785

    // ConvolutionTargetEXT

//  GL_CONVOLUTION_1D                                             = 0x8010, // reuse ConvolutionTarget, decimal value: 32784
    GL_CONVOLUTION_1D_EXT                                         = 0x8010, // decimal value: 32784
//  GL_CONVOLUTION_2D                                             = 0x8011, // reuse ConvolutionTarget, decimal value: 32785
    GL_CONVOLUTION_2D_EXT                                         = 0x8011, // decimal value: 32785

    // CopyBufferSubDataTarget

//  GL_ARRAY_BUFFER                                               = 0x8892, // reuse BufferStorageTarget, decimal value: 34962
//  GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893, // reuse BufferStorageTarget, decimal value: 34963
//  GL_PIXEL_PACK_BUFFER                                          = 0x88EB, // reuse BufferStorageTarget, decimal value: 35051
//  GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC, // reuse BufferStorageTarget, decimal value: 35052
//  GL_UNIFORM_BUFFER                                             = 0x8A11, // reuse BufferStorageTarget, decimal value: 35345
//  GL_TEXTURE_BUFFER                                             = 0x8C2A, // reuse BufferStorageTarget, decimal value: 35882
//  GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // reuse BufferStorageTarget, decimal value: 35982
//  GL_COPY_READ_BUFFER                                           = 0x8F36, // reuse BufferStorageTarget, decimal value: 36662
//  GL_COPY_WRITE_BUFFER                                          = 0x8F37, // reuse BufferStorageTarget, decimal value: 36663
//  GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F, // reuse BufferStorageTarget, decimal value: 36671
//  GL_SHADER_STORAGE_BUFFER                                      = 0x90D2, // reuse BufferStorageTarget, decimal value: 37074
//  GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE, // reuse BufferStorageTarget, decimal value: 37102
//  GL_QUERY_BUFFER                                               = 0x9192, // reuse BufferStorageTarget, decimal value: 37266
//  GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0, // reuse BufferStorageTarget, decimal value: 37568

    // CullFaceMode

//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer, decimal value: 1028
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer, decimal value: 1029
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer, decimal value: 1032

    // DebugSeverity

    GL_DONT_CARE                                                  = 0x1100, // decimal value: 4352
    GL_DEBUG_SEVERITY_HIGH                                        = 0x9146, // decimal value: 37190
    GL_DEBUG_SEVERITY_MEDIUM                                      = 0x9147, // decimal value: 37191
    GL_DEBUG_SEVERITY_LOW                                         = 0x9148, // decimal value: 37192

    // DebugSource

//  GL_DONT_CARE                                                  = 0x1100, // reuse DebugSeverity, decimal value: 4352
    GL_DEBUG_SOURCE_API                                           = 0x8246, // decimal value: 33350
    GL_DEBUG_SOURCE_WINDOW_SYSTEM                                 = 0x8247, // decimal value: 33351
    GL_DEBUG_SOURCE_SHADER_COMPILER                               = 0x8248, // decimal value: 33352
    GL_DEBUG_SOURCE_THIRD_PARTY                                   = 0x8249, // decimal value: 33353
    GL_DEBUG_SOURCE_APPLICATION                                   = 0x824A, // decimal value: 33354
    GL_DEBUG_SOURCE_OTHER                                         = 0x824B, // decimal value: 33355

    // DebugType

//  GL_DONT_CARE                                                  = 0x1100, // reuse DebugSeverity, decimal value: 4352
    GL_DEBUG_TYPE_ERROR                                           = 0x824C, // decimal value: 33356
    GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR                             = 0x824D, // decimal value: 33357
    GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR                              = 0x824E, // decimal value: 33358
    GL_DEBUG_TYPE_PORTABILITY                                     = 0x824F, // decimal value: 33359
    GL_DEBUG_TYPE_PERFORMANCE                                     = 0x8250, // decimal value: 33360
    GL_DEBUG_TYPE_OTHER                                           = 0x8251, // decimal value: 33361
    GL_DEBUG_TYPE_MARKER                                          = 0x8268, // decimal value: 33384
    GL_DEBUG_TYPE_PUSH_GROUP                                      = 0x8269, // decimal value: 33385
    GL_DEBUG_TYPE_POP_GROUP                                       = 0x826A, // decimal value: 33386

    // DepthFunction

//  GL_NEVER                                                      = 0x0200, // reuse AlphaFunction, decimal value: 512
//  GL_LESS                                                       = 0x0201, // reuse AlphaFunction, decimal value: 513
//  GL_EQUAL                                                      = 0x0202, // reuse AlphaFunction, decimal value: 514
//  GL_LEQUAL                                                     = 0x0203, // reuse AlphaFunction, decimal value: 515
//  GL_GREATER                                                    = 0x0204, // reuse AlphaFunction, decimal value: 516
//  GL_NOTEQUAL                                                   = 0x0205, // reuse AlphaFunction, decimal value: 517
//  GL_GEQUAL                                                     = 0x0206, // reuse AlphaFunction, decimal value: 518
//  GL_ALWAYS                                                     = 0x0207, // reuse AlphaFunction, decimal value: 519

    // DrawBufferMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
//  GL_FRONT_LEFT                                                 = 0x0400, // reuse ColorBuffer, decimal value: 1024
//  GL_FRONT_RIGHT                                                = 0x0401, // reuse ColorBuffer, decimal value: 1025
//  GL_BACK_LEFT                                                  = 0x0402, // reuse ColorBuffer, decimal value: 1026
//  GL_BACK_RIGHT                                                 = 0x0403, // reuse ColorBuffer, decimal value: 1027
//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer, decimal value: 1028
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer, decimal value: 1029
//  GL_LEFT                                                       = 0x0406, // reuse ColorBuffer, decimal value: 1030
//  GL_RIGHT                                                      = 0x0407, // reuse ColorBuffer, decimal value: 1031
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer, decimal value: 1032
    GL_AUX0                                                       = 0x0409, // decimal value: 1033
    GL_AUX1                                                       = 0x040A, // decimal value: 1034
    GL_AUX2                                                       = 0x040B, // decimal value: 1035
    GL_AUX3                                                       = 0x040C, // decimal value: 1036

    // DrawElementsType

//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType, decimal value: 5121
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType, decimal value: 5123
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse ColorPointerType, decimal value: 5125

    // EnableCap

    GL_POINT_SMOOTH                                               = 0x0B10, // decimal value: 2832
    GL_LINE_SMOOTH                                                = 0x0B20, // decimal value: 2848
    GL_LINE_STIPPLE                                               = 0x0B24, // decimal value: 2852
    GL_POLYGON_SMOOTH                                             = 0x0B41, // decimal value: 2881
    GL_POLYGON_STIPPLE                                            = 0x0B42, // decimal value: 2882
    GL_CULL_FACE                                                  = 0x0B44, // decimal value: 2884
    GL_LIGHTING                                                   = 0x0B50, // decimal value: 2896
    GL_COLOR_MATERIAL                                             = 0x0B57, // decimal value: 2903
    GL_FOG                                                        = 0x0B60, // decimal value: 2912
    GL_DEPTH_TEST                                                 = 0x0B71, // decimal value: 2929
    GL_STENCIL_TEST                                               = 0x0B90, // decimal value: 2960
    GL_NORMALIZE                                                  = 0x0BA1, // decimal value: 2977
    GL_ALPHA_TEST                                                 = 0x0BC0, // decimal value: 3008
    GL_DITHER                                                     = 0x0BD0, // decimal value: 3024
    GL_BLEND                                                      = 0x0BE2, // decimal value: 3042
    GL_INDEX_LOGIC_OP                                             = 0x0BF1, // decimal value: 3057
    GL_COLOR_LOGIC_OP                                             = 0x0BF2, // decimal value: 3058
    GL_SCISSOR_TEST                                               = 0x0C11, // decimal value: 3089
    GL_TEXTURE_GEN_S                                              = 0x0C60, // decimal value: 3168
    GL_TEXTURE_GEN_T                                              = 0x0C61, // decimal value: 3169
    GL_TEXTURE_GEN_R                                              = 0x0C62, // decimal value: 3170
    GL_TEXTURE_GEN_Q                                              = 0x0C63, // decimal value: 3171
    GL_AUTO_NORMAL                                                = 0x0D80, // decimal value: 3456
    GL_MAP1_COLOR_4                                               = 0x0D90, // decimal value: 3472
    GL_MAP1_INDEX                                                 = 0x0D91, // decimal value: 3473
    GL_MAP1_NORMAL                                                = 0x0D92, // decimal value: 3474
    GL_MAP1_TEXTURE_COORD_1                                       = 0x0D93, // decimal value: 3475
    GL_MAP1_TEXTURE_COORD_2                                       = 0x0D94, // decimal value: 3476
    GL_MAP1_TEXTURE_COORD_3                                       = 0x0D95, // decimal value: 3477
    GL_MAP1_TEXTURE_COORD_4                                       = 0x0D96, // decimal value: 3478
    GL_MAP1_VERTEX_3                                              = 0x0D97, // decimal value: 3479
    GL_MAP1_VERTEX_4                                              = 0x0D98, // decimal value: 3480
    GL_MAP2_COLOR_4                                               = 0x0DB0, // decimal value: 3504
    GL_MAP2_INDEX                                                 = 0x0DB1, // decimal value: 3505
    GL_MAP2_NORMAL                                                = 0x0DB2, // decimal value: 3506
    GL_MAP2_TEXTURE_COORD_1                                       = 0x0DB3, // decimal value: 3507
    GL_MAP2_TEXTURE_COORD_2                                       = 0x0DB4, // decimal value: 3508
    GL_MAP2_TEXTURE_COORD_3                                       = 0x0DB5, // decimal value: 3509
    GL_MAP2_TEXTURE_COORD_4                                       = 0x0DB6, // decimal value: 3510
    GL_MAP2_VERTEX_3                                              = 0x0DB7, // decimal value: 3511
    GL_MAP2_VERTEX_4                                              = 0x0DB8, // decimal value: 3512
    GL_TEXTURE_1D                                                 = 0x0DE0, // decimal value: 3552
    GL_TEXTURE_2D                                                 = 0x0DE1, // decimal value: 3553
    GL_POLYGON_OFFSET_POINT                                       = 0x2A01, // decimal value: 10753
    GL_POLYGON_OFFSET_LINE                                        = 0x2A02, // decimal value: 10754
//  GL_CLIP_PLANE0                                                = 0x3000, // reuse ClipPlaneName, decimal value: 12288
//  GL_CLIP_PLANE1                                                = 0x3001, // reuse ClipPlaneName, decimal value: 12289
//  GL_CLIP_PLANE2                                                = 0x3002, // reuse ClipPlaneName, decimal value: 12290
//  GL_CLIP_PLANE3                                                = 0x3003, // reuse ClipPlaneName, decimal value: 12291
//  GL_CLIP_PLANE4                                                = 0x3004, // reuse ClipPlaneName, decimal value: 12292
//  GL_CLIP_PLANE5                                                = 0x3005, // reuse ClipPlaneName, decimal value: 12293
    GL_LIGHT0                                                     = 0x4000, // decimal value: 16384
    GL_LIGHT1                                                     = 0x4001, // decimal value: 16385
    GL_LIGHT2                                                     = 0x4002, // decimal value: 16386
    GL_LIGHT3                                                     = 0x4003, // decimal value: 16387
    GL_LIGHT4                                                     = 0x4004, // decimal value: 16388
    GL_LIGHT5                                                     = 0x4005, // decimal value: 16389
    GL_LIGHT6                                                     = 0x4006, // decimal value: 16390
    GL_LIGHT7                                                     = 0x4007, // decimal value: 16391
//  GL_CONVOLUTION_1D_EXT                                         = 0x8010, // reuse ConvolutionTargetEXT, decimal value: 32784
//  GL_CONVOLUTION_2D_EXT                                         = 0x8011, // reuse ConvolutionTargetEXT, decimal value: 32785
    GL_SEPARABLE_2D_EXT                                           = 0x8012, // decimal value: 32786
    GL_HISTOGRAM_EXT                                              = 0x8024, // decimal value: 32804
    GL_MINMAX_EXT                                                 = 0x802E, // decimal value: 32814
    GL_POLYGON_OFFSET_FILL                                        = 0x8037, // decimal value: 32823
    GL_RESCALE_NORMAL_EXT                                         = 0x803A, // decimal value: 32826
    GL_TEXTURE_3D_EXT                                             = 0x806F, // decimal value: 32879
    GL_VERTEX_ARRAY                                               = 0x8074, // decimal value: 32884
    GL_NORMAL_ARRAY                                               = 0x8075, // decimal value: 32885
    GL_COLOR_ARRAY                                                = 0x8076, // decimal value: 32886
    GL_INDEX_ARRAY                                                = 0x8077, // decimal value: 32887
    GL_TEXTURE_COORD_ARRAY                                        = 0x8078, // decimal value: 32888
    GL_EDGE_FLAG_ARRAY                                            = 0x8079, // decimal value: 32889
    GL_INTERLACE_SGIX                                             = 0x8094, // decimal value: 32916
    GL_MULTISAMPLE_SGIS                                           = 0x809D, // decimal value: 32925
    GL_SAMPLE_ALPHA_TO_MASK_SGIS                                  = 0x809E, // decimal value: 32926
    GL_SAMPLE_ALPHA_TO_ONE_SGIS                                   = 0x809F, // decimal value: 32927
    GL_SAMPLE_MASK_SGIS                                           = 0x80A0, // decimal value: 32928
//  GL_TEXTURE_COLOR_TABLE_SGI                                    = 0x80BC, // reuse ColorTableTargetSGI, decimal value: 32956
//  GL_COLOR_TABLE_SGI                                            = 0x80D0, // reuse ColorTableTargetSGI, decimal value: 32976
//  GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           = 0x80D1, // reuse ColorTableTargetSGI, decimal value: 32977
//  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          = 0x80D2, // reuse ColorTableTargetSGI, decimal value: 32978
    GL_TEXTURE_4D_SGIS                                            = 0x8134, // decimal value: 33076
    GL_PIXEL_TEX_GEN_SGIX                                         = 0x8139, // decimal value: 33081
    GL_SPRITE_SGIX                                                = 0x8148, // decimal value: 33096
    GL_REFERENCE_PLANE_SGIX                                       = 0x817D, // decimal value: 33149
    GL_IR_INSTRUMENT1_SGIX                                        = 0x817F, // decimal value: 33151
    GL_CALLIGRAPHIC_FRAGMENT_SGIX                                 = 0x8183, // decimal value: 33155
    GL_FRAMEZOOM_SGIX                                             = 0x818B, // decimal value: 33163
    GL_FOG_OFFSET_SGIX                                            = 0x8198, // decimal value: 33176
    GL_SHARED_TEXTURE_PALETTE_EXT                                 = 0x81FB, // decimal value: 33275
    GL_ASYNC_HISTOGRAM_SGIX                                       = 0x832C, // decimal value: 33580
    GL_PIXEL_TEXTURE_SGIS                                         = 0x8353, // decimal value: 33619
    GL_ASYNC_TEX_IMAGE_SGIX                                       = 0x835C, // decimal value: 33628
    GL_ASYNC_DRAW_PIXELS_SGIX                                     = 0x835D, // decimal value: 33629
    GL_ASYNC_READ_PIXELS_SGIX                                     = 0x835E, // decimal value: 33630
    GL_FRAGMENT_LIGHTING_SGIX                                     = 0x8400, // decimal value: 33792
    GL_FRAGMENT_COLOR_MATERIAL_SGIX                               = 0x8401, // decimal value: 33793
    GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C, // decimal value: 33804
    GL_FRAGMENT_LIGHT1_SGIX                                       = 0x840D, // decimal value: 33805
    GL_FRAGMENT_LIGHT2_SGIX                                       = 0x840E, // decimal value: 33806
    GL_FRAGMENT_LIGHT3_SGIX                                       = 0x840F, // decimal value: 33807
    GL_FRAGMENT_LIGHT4_SGIX                                       = 0x8410, // decimal value: 33808
    GL_FRAGMENT_LIGHT5_SGIX                                       = 0x8411, // decimal value: 33809
    GL_FRAGMENT_LIGHT6_SGIX                                       = 0x8412, // decimal value: 33810
    GL_FRAGMENT_LIGHT7_SGIX                                       = 0x8413, // decimal value: 33811

    // ErrorCode

    GL_NO_ERROR                                                   = 0,
    GL_INVALID_ENUM                                               = 0x0500, // decimal value: 1280
    GL_INVALID_VALUE                                              = 0x0501, // decimal value: 1281
    GL_INVALID_OPERATION                                          = 0x0502, // decimal value: 1282
    GL_STACK_OVERFLOW                                             = 0x0503, // decimal value: 1283
    GL_STACK_UNDERFLOW                                            = 0x0504, // decimal value: 1284
    GL_OUT_OF_MEMORY                                              = 0x0505, // decimal value: 1285
    GL_INVALID_FRAMEBUFFER_OPERATION                              = 0x0506, // decimal value: 1286
    GL_INVALID_FRAMEBUFFER_OPERATION_EXT                          = 0x0506, // decimal value: 1286
    GL_TABLE_TOO_LARGE                                            = 0x8031, // decimal value: 32817
    GL_TABLE_TOO_LARGE_EXT                                        = 0x8031, // decimal value: 32817
    GL_TEXTURE_TOO_LARGE_EXT                                      = 0x8065, // decimal value: 32869

    // ExternalHandleType

    GL_HANDLE_TYPE_OPAQUE_FD_EXT                                  = 0x9586, // decimal value: 38278
    GL_HANDLE_TYPE_OPAQUE_WIN32_EXT                               = 0x9587, // decimal value: 38279
    GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT                           = 0x9588, // decimal value: 38280
    GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT                             = 0x9589, // decimal value: 38281
    GL_HANDLE_TYPE_D3D12_RESOURCE_EXT                             = 0x958A, // decimal value: 38282
    GL_HANDLE_TYPE_D3D11_IMAGE_EXT                                = 0x958B, // decimal value: 38283
    GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT                            = 0x958C, // decimal value: 38284
    GL_HANDLE_TYPE_D3D12_FENCE_EXT                                = 0x9594, // decimal value: 38292

    // FeedBackToken

    GL_PASS_THROUGH_TOKEN                                         = 0x0700, // decimal value: 1792
    GL_POINT_TOKEN                                                = 0x0701, // decimal value: 1793
    GL_LINE_TOKEN                                                 = 0x0702, // decimal value: 1794
    GL_POLYGON_TOKEN                                              = 0x0703, // decimal value: 1795
    GL_BITMAP_TOKEN                                               = 0x0704, // decimal value: 1796
    GL_DRAW_PIXEL_TOKEN                                           = 0x0705, // decimal value: 1797
    GL_COPY_PIXEL_TOKEN                                           = 0x0706, // decimal value: 1798
    GL_LINE_RESET_TOKEN                                           = 0x0707, // decimal value: 1799

    // FeedbackType

    GL_2D                                                         = 0x0600, // decimal value: 1536
    GL_3D                                                         = 0x0601, // decimal value: 1537
    GL_3D_COLOR                                                   = 0x0602, // decimal value: 1538
    GL_3D_COLOR_TEXTURE                                           = 0x0603, // decimal value: 1539
    GL_4D_COLOR_TEXTURE                                           = 0x0604, // decimal value: 1540

    // FfdTargetSGIX

    GL_GEOMETRY_DEFORMATION_SGIX                                  = 0x8194, // decimal value: 33172
    GL_TEXTURE_DEFORMATION_SGIX                                   = 0x8195, // decimal value: 33173

    // FogCoordinatePointerType

//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // FogMode

    GL_EXP                                                        = 0x0800, // decimal value: 2048
    GL_EXP2                                                       = 0x0801, // decimal value: 2049
//  GL_LINEAR                                                     = 0x2601, // reuse BlitFramebufferFilter, decimal value: 9729
    GL_FOG_FUNC_SGIS                                              = 0x812A, // decimal value: 33066

    // FogPName

    GL_FOG_INDEX                                                  = 0x0B61, // decimal value: 2913
    GL_FOG_DENSITY                                                = 0x0B62, // decimal value: 2914
    GL_FOG_START                                                  = 0x0B63, // decimal value: 2915
    GL_FOG_END                                                    = 0x0B64, // decimal value: 2916
    GL_FOG_MODE                                                   = 0x0B65, // decimal value: 2917
    GL_FOG_COORD_SRC                                              = 0x8450, // decimal value: 33872

    // FogParameter

//  GL_FOG_INDEX                                                  = 0x0B61, // reuse FogPName, decimal value: 2913
//  GL_FOG_DENSITY                                                = 0x0B62, // reuse FogPName, decimal value: 2914
//  GL_FOG_START                                                  = 0x0B63, // reuse FogPName, decimal value: 2915
//  GL_FOG_END                                                    = 0x0B64, // reuse FogPName, decimal value: 2916
//  GL_FOG_MODE                                                   = 0x0B65, // reuse FogPName, decimal value: 2917
    GL_FOG_COLOR                                                  = 0x0B66, // decimal value: 2918
    GL_FOG_OFFSET_VALUE_SGIX                                      = 0x8199, // decimal value: 33177

    // FogPointerTypeEXT

//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // FogPointerTypeIBM

//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // FragmentLightModelParameterSGIX

    GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX                     = 0x8408, // decimal value: 33800
    GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX                         = 0x8409, // decimal value: 33801
    GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX                          = 0x840A, // decimal value: 33802
    GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX             = 0x840B, // decimal value: 33803

    // FragmentOpATI

    GL_MOV_ATI                                                    = 0x8961, // decimal value: 35169
    GL_ADD_ATI                                                    = 0x8963, // decimal value: 35171
    GL_MUL_ATI                                                    = 0x8964, // decimal value: 35172
    GL_SUB_ATI                                                    = 0x8965, // decimal value: 35173
    GL_DOT3_ATI                                                   = 0x8966, // decimal value: 35174
    GL_DOT4_ATI                                                   = 0x8967, // decimal value: 35175
    GL_MAD_ATI                                                    = 0x8968, // decimal value: 35176
    GL_LERP_ATI                                                   = 0x8969, // decimal value: 35177
    GL_CND_ATI                                                    = 0x896A, // decimal value: 35178
    GL_CND0_ATI                                                   = 0x896B, // decimal value: 35179
    GL_DOT2_ADD_ATI                                               = 0x896C, // decimal value: 35180

    // FramebufferAttachment

    GL_MAX_COLOR_ATTACHMENTS                                      = 0x8CDF, // decimal value: 36063
    GL_MAX_COLOR_ATTACHMENTS_EXT                                  = 0x8CDF, // decimal value: 36063
//  GL_COLOR_ATTACHMENT0                                          = 0x8CE0, // reuse ColorBuffer, decimal value: 36064
    GL_COLOR_ATTACHMENT0_EXT                                      = 0x8CE0, // decimal value: 36064
//  GL_COLOR_ATTACHMENT1                                          = 0x8CE1, // reuse ColorBuffer, decimal value: 36065
    GL_COLOR_ATTACHMENT1_EXT                                      = 0x8CE1, // decimal value: 36065
//  GL_COLOR_ATTACHMENT2                                          = 0x8CE2, // reuse ColorBuffer, decimal value: 36066
    GL_COLOR_ATTACHMENT2_EXT                                      = 0x8CE2, // decimal value: 36066
//  GL_COLOR_ATTACHMENT3                                          = 0x8CE3, // reuse ColorBuffer, decimal value: 36067
    GL_COLOR_ATTACHMENT3_EXT                                      = 0x8CE3, // decimal value: 36067
//  GL_COLOR_ATTACHMENT4                                          = 0x8CE4, // reuse ColorBuffer, decimal value: 36068
    GL_COLOR_ATTACHMENT4_EXT                                      = 0x8CE4, // decimal value: 36068
//  GL_COLOR_ATTACHMENT5                                          = 0x8CE5, // reuse ColorBuffer, decimal value: 36069
    GL_COLOR_ATTACHMENT5_EXT                                      = 0x8CE5, // decimal value: 36069
//  GL_COLOR_ATTACHMENT6                                          = 0x8CE6, // reuse ColorBuffer, decimal value: 36070
    GL_COLOR_ATTACHMENT6_EXT                                      = 0x8CE6, // decimal value: 36070
//  GL_COLOR_ATTACHMENT7                                          = 0x8CE7, // reuse ColorBuffer, decimal value: 36071
    GL_COLOR_ATTACHMENT7_EXT                                      = 0x8CE7, // decimal value: 36071
//  GL_COLOR_ATTACHMENT8                                          = 0x8CE8, // reuse ColorBuffer, decimal value: 36072
    GL_COLOR_ATTACHMENT8_EXT                                      = 0x8CE8, // decimal value: 36072
//  GL_COLOR_ATTACHMENT9                                          = 0x8CE9, // reuse ColorBuffer, decimal value: 36073
    GL_COLOR_ATTACHMENT9_EXT                                      = 0x8CE9, // decimal value: 36073
//  GL_COLOR_ATTACHMENT10                                         = 0x8CEA, // reuse ColorBuffer, decimal value: 36074
    GL_COLOR_ATTACHMENT10_EXT                                     = 0x8CEA, // decimal value: 36074
//  GL_COLOR_ATTACHMENT11                                         = 0x8CEB, // reuse ColorBuffer, decimal value: 36075
    GL_COLOR_ATTACHMENT11_EXT                                     = 0x8CEB, // decimal value: 36075
//  GL_COLOR_ATTACHMENT12                                         = 0x8CEC, // reuse ColorBuffer, decimal value: 36076
    GL_COLOR_ATTACHMENT12_EXT                                     = 0x8CEC, // decimal value: 36076
//  GL_COLOR_ATTACHMENT13                                         = 0x8CED, // reuse ColorBuffer, decimal value: 36077
    GL_COLOR_ATTACHMENT13_EXT                                     = 0x8CED, // decimal value: 36077
//  GL_COLOR_ATTACHMENT14                                         = 0x8CEE, // reuse ColorBuffer, decimal value: 36078
    GL_COLOR_ATTACHMENT14_EXT                                     = 0x8CEE, // decimal value: 36078
//  GL_COLOR_ATTACHMENT15                                         = 0x8CEF, // reuse ColorBuffer, decimal value: 36079
    GL_COLOR_ATTACHMENT15_EXT                                     = 0x8CEF, // decimal value: 36079
//  GL_COLOR_ATTACHMENT16                                         = 0x8CF0, // reuse ColorBuffer, decimal value: 36080
//  GL_COLOR_ATTACHMENT17                                         = 0x8CF1, // reuse ColorBuffer, decimal value: 36081
//  GL_COLOR_ATTACHMENT18                                         = 0x8CF2, // reuse ColorBuffer, decimal value: 36082
//  GL_COLOR_ATTACHMENT19                                         = 0x8CF3, // reuse ColorBuffer, decimal value: 36083
//  GL_COLOR_ATTACHMENT20                                         = 0x8CF4, // reuse ColorBuffer, decimal value: 36084
//  GL_COLOR_ATTACHMENT21                                         = 0x8CF5, // reuse ColorBuffer, decimal value: 36085
//  GL_COLOR_ATTACHMENT22                                         = 0x8CF6, // reuse ColorBuffer, decimal value: 36086
//  GL_COLOR_ATTACHMENT23                                         = 0x8CF7, // reuse ColorBuffer, decimal value: 36087
//  GL_COLOR_ATTACHMENT24                                         = 0x8CF8, // reuse ColorBuffer, decimal value: 36088
//  GL_COLOR_ATTACHMENT25                                         = 0x8CF9, // reuse ColorBuffer, decimal value: 36089
//  GL_COLOR_ATTACHMENT26                                         = 0x8CFA, // reuse ColorBuffer, decimal value: 36090
//  GL_COLOR_ATTACHMENT27                                         = 0x8CFB, // reuse ColorBuffer, decimal value: 36091
//  GL_COLOR_ATTACHMENT28                                         = 0x8CFC, // reuse ColorBuffer, decimal value: 36092
//  GL_COLOR_ATTACHMENT29                                         = 0x8CFD, // reuse ColorBuffer, decimal value: 36093
//  GL_COLOR_ATTACHMENT30                                         = 0x8CFE, // reuse ColorBuffer, decimal value: 36094
//  GL_COLOR_ATTACHMENT31                                         = 0x8CFF, // reuse ColorBuffer, decimal value: 36095
    GL_DEPTH_ATTACHMENT                                           = 0x8D00, // decimal value: 36096
    GL_DEPTH_ATTACHMENT_EXT                                       = 0x8D00, // decimal value: 36096

    // FramebufferAttachmentParameterName

    GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING                      = 0x8210, // decimal value: 33296
    GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE                      = 0x8211, // decimal value: 33297
    GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE                            = 0x8212, // decimal value: 33298
    GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE                          = 0x8213, // decimal value: 33299
    GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE                           = 0x8214, // decimal value: 33300
    GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE                          = 0x8215, // decimal value: 33301
    GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE                          = 0x8216, // decimal value: 33302
    GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE                        = 0x8217, // decimal value: 33303
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME                         = 0x8CD1, // decimal value: 36049
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL                       = 0x8CD2, // decimal value: 36050
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE               = 0x8CD3, // decimal value: 36051
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER                       = 0x8CD4, // decimal value: 36052
    GL_FRAMEBUFFER_ATTACHMENT_LAYERED                             = 0x8DA7, // decimal value: 36263

    // FramebufferParameterName

    GL_FRAMEBUFFER_DEFAULT_WIDTH                                  = 0x9310, // decimal value: 37648
    GL_FRAMEBUFFER_DEFAULT_HEIGHT                                 = 0x9311, // decimal value: 37649
    GL_FRAMEBUFFER_DEFAULT_LAYERS                                 = 0x9312, // decimal value: 37650
    GL_FRAMEBUFFER_DEFAULT_SAMPLES                                = 0x9313, // decimal value: 37651
    GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS                 = 0x9314, // decimal value: 37652

    // FramebufferStatus

    GL_FRAMEBUFFER_UNDEFINED                                      = 0x8219, // decimal value: 33305
    GL_FRAMEBUFFER_COMPLETE                                       = 0x8CD5, // decimal value: 36053
    GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT                          = 0x8CD6, // decimal value: 36054
    GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT                  = 0x8CD7, // decimal value: 36055
    GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER                         = 0x8CDB, // decimal value: 36059
    GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER                         = 0x8CDC, // decimal value: 36060
    GL_FRAMEBUFFER_UNSUPPORTED                                    = 0x8CDD, // decimal value: 36061
    GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE                         = 0x8D56, // decimal value: 36182
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS                       = 0x8DA8, // decimal value: 36264

    // FramebufferTarget

//  GL_READ_FRAMEBUFFER                                           = 0x8CA8, // reuse CheckFramebufferStatusTarget, decimal value: 36008
//  GL_DRAW_FRAMEBUFFER                                           = 0x8CA9, // reuse CheckFramebufferStatusTarget, decimal value: 36009
//  GL_FRAMEBUFFER                                                = 0x8D40, // reuse CheckFramebufferStatusTarget, decimal value: 36160

    // FrontFaceDirection

    GL_CW                                                         = 0x0900, // decimal value: 2304
    GL_CCW                                                        = 0x0901, // decimal value: 2305

    // GetColorTableParameterPNameSGI

//  GL_COLOR_TABLE_SCALE                                          = 0x80D6, // reuse ColorTableParameterPNameSGI, decimal value: 32982
//  GL_COLOR_TABLE_SCALE_SGI                                      = 0x80D6, // reuse ColorTableParameterPNameSGI, decimal value: 32982
//  GL_COLOR_TABLE_BIAS                                           = 0x80D7, // reuse ColorTableParameterPNameSGI, decimal value: 32983
//  GL_COLOR_TABLE_BIAS_SGI                                       = 0x80D7, // reuse ColorTableParameterPNameSGI, decimal value: 32983
    GL_COLOR_TABLE_FORMAT                                         = 0x80D8, // decimal value: 32984
    GL_COLOR_TABLE_FORMAT_SGI                                     = 0x80D8, // decimal value: 32984
    GL_COLOR_TABLE_WIDTH                                          = 0x80D9, // decimal value: 32985
    GL_COLOR_TABLE_WIDTH_SGI                                      = 0x80D9, // decimal value: 32985
    GL_COLOR_TABLE_RED_SIZE                                       = 0x80DA, // decimal value: 32986
    GL_COLOR_TABLE_RED_SIZE_SGI                                   = 0x80DA, // decimal value: 32986
    GL_COLOR_TABLE_GREEN_SIZE                                     = 0x80DB, // decimal value: 32987
    GL_COLOR_TABLE_GREEN_SIZE_SGI                                 = 0x80DB, // decimal value: 32987
    GL_COLOR_TABLE_BLUE_SIZE                                      = 0x80DC, // decimal value: 32988
    GL_COLOR_TABLE_BLUE_SIZE_SGI                                  = 0x80DC, // decimal value: 32988
    GL_COLOR_TABLE_ALPHA_SIZE                                     = 0x80DD, // decimal value: 32989
    GL_COLOR_TABLE_ALPHA_SIZE_SGI                                 = 0x80DD, // decimal value: 32989
    GL_COLOR_TABLE_LUMINANCE_SIZE                                 = 0x80DE, // decimal value: 32990
    GL_COLOR_TABLE_LUMINANCE_SIZE_SGI                             = 0x80DE, // decimal value: 32990
    GL_COLOR_TABLE_INTENSITY_SIZE                                 = 0x80DF, // decimal value: 32991
    GL_COLOR_TABLE_INTENSITY_SIZE_SGI                             = 0x80DF, // decimal value: 32991

    // GetConvolutionParameter

//  GL_CONVOLUTION_BORDER_MODE                                    = 0x8013, // reuse ConvolutionParameterEXT, decimal value: 32787
//  GL_CONVOLUTION_BORDER_MODE_EXT                                = 0x8013, // reuse ConvolutionParameterEXT, decimal value: 32787
//  GL_CONVOLUTION_FILTER_SCALE                                   = 0x8014, // reuse ConvolutionParameterEXT, decimal value: 32788
//  GL_CONVOLUTION_FILTER_SCALE_EXT                               = 0x8014, // reuse ConvolutionParameterEXT, decimal value: 32788
//  GL_CONVOLUTION_FILTER_BIAS                                    = 0x8015, // reuse ConvolutionParameterEXT, decimal value: 32789
//  GL_CONVOLUTION_FILTER_BIAS_EXT                                = 0x8015, // reuse ConvolutionParameterEXT, decimal value: 32789
    GL_CONVOLUTION_FORMAT                                         = 0x8017, // decimal value: 32791
    GL_CONVOLUTION_FORMAT_EXT                                     = 0x8017, // decimal value: 32791
    GL_CONVOLUTION_WIDTH                                          = 0x8018, // decimal value: 32792
    GL_CONVOLUTION_WIDTH_EXT                                      = 0x8018, // decimal value: 32792
    GL_CONVOLUTION_HEIGHT                                         = 0x8019, // decimal value: 32793
    GL_CONVOLUTION_HEIGHT_EXT                                     = 0x8019, // decimal value: 32793
    GL_MAX_CONVOLUTION_WIDTH                                      = 0x801A, // decimal value: 32794
    GL_MAX_CONVOLUTION_WIDTH_EXT                                  = 0x801A, // decimal value: 32794
    GL_MAX_CONVOLUTION_HEIGHT                                     = 0x801B, // decimal value: 32795
    GL_MAX_CONVOLUTION_HEIGHT_EXT                                 = 0x801B, // decimal value: 32795
    GL_CONVOLUTION_BORDER_COLOR                                   = 0x8154, // decimal value: 33108

    // GetFramebufferParameter

    GL_DOUBLEBUFFER                                               = 0x0C32, // decimal value: 3122
    GL_STEREO                                                     = 0x0C33, // decimal value: 3123
    GL_SAMPLE_BUFFERS                                             = 0x80A8, // decimal value: 32936
    GL_SAMPLES                                                    = 0x80A9, // decimal value: 32937
    GL_IMPLEMENTATION_COLOR_READ_TYPE                             = 0x8B9A, // decimal value: 35738
    GL_IMPLEMENTATION_COLOR_READ_FORMAT                           = 0x8B9B, // decimal value: 35739
//  GL_FRAMEBUFFER_DEFAULT_WIDTH                                  = 0x9310, // reuse FramebufferParameterName, decimal value: 37648
//  GL_FRAMEBUFFER_DEFAULT_HEIGHT                                 = 0x9311, // reuse FramebufferParameterName, decimal value: 37649
//  GL_FRAMEBUFFER_DEFAULT_LAYERS                                 = 0x9312, // reuse FramebufferParameterName, decimal value: 37650
//  GL_FRAMEBUFFER_DEFAULT_SAMPLES                                = 0x9313, // reuse FramebufferParameterName, decimal value: 37651
//  GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS                 = 0x9314, // reuse FramebufferParameterName, decimal value: 37652

    // GetHistogramParameterPNameEXT

    GL_HISTOGRAM_WIDTH                                            = 0x8026, // decimal value: 32806
    GL_HISTOGRAM_WIDTH_EXT                                        = 0x8026, // decimal value: 32806
    GL_HISTOGRAM_FORMAT                                           = 0x8027, // decimal value: 32807
    GL_HISTOGRAM_FORMAT_EXT                                       = 0x8027, // decimal value: 32807
    GL_HISTOGRAM_RED_SIZE                                         = 0x8028, // decimal value: 32808
    GL_HISTOGRAM_RED_SIZE_EXT                                     = 0x8028, // decimal value: 32808
    GL_HISTOGRAM_GREEN_SIZE                                       = 0x8029, // decimal value: 32809
    GL_HISTOGRAM_GREEN_SIZE_EXT                                   = 0x8029, // decimal value: 32809
    GL_HISTOGRAM_BLUE_SIZE                                        = 0x802A, // decimal value: 32810
    GL_HISTOGRAM_BLUE_SIZE_EXT                                    = 0x802A, // decimal value: 32810
    GL_HISTOGRAM_ALPHA_SIZE                                       = 0x802B, // decimal value: 32811
    GL_HISTOGRAM_ALPHA_SIZE_EXT                                   = 0x802B, // decimal value: 32811
    GL_HISTOGRAM_LUMINANCE_SIZE                                   = 0x802C, // decimal value: 32812
    GL_HISTOGRAM_LUMINANCE_SIZE_EXT                               = 0x802C, // decimal value: 32812
    GL_HISTOGRAM_SINK                                             = 0x802D, // decimal value: 32813
    GL_HISTOGRAM_SINK_EXT                                         = 0x802D, // decimal value: 32813

    // GetMapQuery

    GL_COEFF                                                      = 0x0A00, // decimal value: 2560
    GL_ORDER                                                      = 0x0A01, // decimal value: 2561
    GL_DOMAIN                                                     = 0x0A02, // decimal value: 2562

    // GetMinmaxParameterPNameEXT

    GL_MINMAX_FORMAT                                              = 0x802F, // decimal value: 32815
    GL_MINMAX_FORMAT_EXT                                          = 0x802F, // decimal value: 32815
    GL_MINMAX_SINK                                                = 0x8030, // decimal value: 32816
    GL_MINMAX_SINK_EXT                                            = 0x8030, // decimal value: 32816

    // GetPName

    GL_CURRENT_COLOR                                              = 0x0B00, // decimal value: 2816
    GL_CURRENT_INDEX                                              = 0x0B01, // decimal value: 2817
    GL_CURRENT_NORMAL                                             = 0x0B02, // decimal value: 2818
    GL_CURRENT_TEXTURE_COORDS                                     = 0x0B03, // decimal value: 2819
    GL_CURRENT_RASTER_COLOR                                       = 0x0B04, // decimal value: 2820
    GL_CURRENT_RASTER_INDEX                                       = 0x0B05, // decimal value: 2821
    GL_CURRENT_RASTER_TEXTURE_COORDS                              = 0x0B06, // decimal value: 2822
    GL_CURRENT_RASTER_POSITION                                    = 0x0B07, // decimal value: 2823
    GL_CURRENT_RASTER_POSITION_VALID                              = 0x0B08, // decimal value: 2824
    GL_CURRENT_RASTER_DISTANCE                                    = 0x0B09, // decimal value: 2825
//  GL_POINT_SMOOTH                                               = 0x0B10, // reuse EnableCap, decimal value: 2832
    GL_POINT_SIZE                                                 = 0x0B11, // decimal value: 2833
    GL_POINT_SIZE_RANGE                                           = 0x0B12, // decimal value: 2834
    GL_SMOOTH_POINT_SIZE_RANGE                                    = 0x0B12, // decimal value: 2834
    GL_POINT_SIZE_GRANULARITY                                     = 0x0B13, // decimal value: 2835
    GL_SMOOTH_POINT_SIZE_GRANULARITY                              = 0x0B13, // decimal value: 2835
//  GL_LINE_SMOOTH                                                = 0x0B20, // reuse EnableCap, decimal value: 2848
    GL_LINE_WIDTH                                                 = 0x0B21, // decimal value: 2849
    GL_LINE_WIDTH_RANGE                                           = 0x0B22, // decimal value: 2850
    GL_SMOOTH_LINE_WIDTH_RANGE                                    = 0x0B22, // decimal value: 2850
    GL_LINE_WIDTH_GRANULARITY                                     = 0x0B23, // decimal value: 2851
    GL_SMOOTH_LINE_WIDTH_GRANULARITY                              = 0x0B23, // decimal value: 2851
//  GL_LINE_STIPPLE                                               = 0x0B24, // reuse EnableCap, decimal value: 2852
    GL_LINE_STIPPLE_PATTERN                                       = 0x0B25, // decimal value: 2853
    GL_LINE_STIPPLE_REPEAT                                        = 0x0B26, // decimal value: 2854
    GL_LIST_MODE                                                  = 0x0B30, // decimal value: 2864
    GL_MAX_LIST_NESTING                                           = 0x0B31, // decimal value: 2865
    GL_LIST_BASE                                                  = 0x0B32, // decimal value: 2866
    GL_LIST_INDEX                                                 = 0x0B33, // decimal value: 2867
    GL_POLYGON_MODE                                               = 0x0B40, // decimal value: 2880
//  GL_POLYGON_SMOOTH                                             = 0x0B41, // reuse EnableCap, decimal value: 2881
//  GL_POLYGON_STIPPLE                                            = 0x0B42, // reuse EnableCap, decimal value: 2882
    GL_EDGE_FLAG                                                  = 0x0B43, // decimal value: 2883
//  GL_CULL_FACE                                                  = 0x0B44, // reuse EnableCap, decimal value: 2884
    GL_CULL_FACE_MODE                                             = 0x0B45, // decimal value: 2885
    GL_FRONT_FACE                                                 = 0x0B46, // decimal value: 2886
//  GL_LIGHTING                                                   = 0x0B50, // reuse EnableCap, decimal value: 2896
    GL_LIGHT_MODEL_LOCAL_VIEWER                                   = 0x0B51, // decimal value: 2897
    GL_LIGHT_MODEL_TWO_SIDE                                       = 0x0B52, // decimal value: 2898
    GL_LIGHT_MODEL_AMBIENT                                        = 0x0B53, // decimal value: 2899
    GL_SHADE_MODEL                                                = 0x0B54, // decimal value: 2900
    GL_COLOR_MATERIAL_FACE                                        = 0x0B55, // decimal value: 2901
    GL_COLOR_MATERIAL_PARAMETER                                   = 0x0B56, // decimal value: 2902
//  GL_COLOR_MATERIAL                                             = 0x0B57, // reuse EnableCap, decimal value: 2903
//  GL_FOG                                                        = 0x0B60, // reuse EnableCap, decimal value: 2912
//  GL_FOG_INDEX                                                  = 0x0B61, // reuse FogPName, decimal value: 2913
//  GL_FOG_DENSITY                                                = 0x0B62, // reuse FogPName, decimal value: 2914
//  GL_FOG_START                                                  = 0x0B63, // reuse FogPName, decimal value: 2915
//  GL_FOG_END                                                    = 0x0B64, // reuse FogPName, decimal value: 2916
//  GL_FOG_MODE                                                   = 0x0B65, // reuse FogPName, decimal value: 2917
//  GL_FOG_COLOR                                                  = 0x0B66, // reuse FogParameter, decimal value: 2918
    GL_DEPTH_RANGE                                                = 0x0B70, // decimal value: 2928
//  GL_DEPTH_TEST                                                 = 0x0B71, // reuse EnableCap, decimal value: 2929
    GL_DEPTH_WRITEMASK                                            = 0x0B72, // decimal value: 2930
    GL_DEPTH_CLEAR_VALUE                                          = 0x0B73, // decimal value: 2931
    GL_DEPTH_FUNC                                                 = 0x0B74, // decimal value: 2932
    GL_ACCUM_CLEAR_VALUE                                          = 0x0B80, // decimal value: 2944
//  GL_STENCIL_TEST                                               = 0x0B90, // reuse EnableCap, decimal value: 2960
    GL_STENCIL_CLEAR_VALUE                                        = 0x0B91, // decimal value: 2961
    GL_STENCIL_FUNC                                               = 0x0B92, // decimal value: 2962
    GL_STENCIL_VALUE_MASK                                         = 0x0B93, // decimal value: 2963
    GL_STENCIL_FAIL                                               = 0x0B94, // decimal value: 2964
    GL_STENCIL_PASS_DEPTH_FAIL                                    = 0x0B95, // decimal value: 2965
    GL_STENCIL_PASS_DEPTH_PASS                                    = 0x0B96, // decimal value: 2966
    GL_STENCIL_REF                                                = 0x0B97, // decimal value: 2967
    GL_STENCIL_WRITEMASK                                          = 0x0B98, // decimal value: 2968
    GL_MATRIX_MODE                                                = 0x0BA0, // decimal value: 2976
//  GL_NORMALIZE                                                  = 0x0BA1, // reuse EnableCap, decimal value: 2977
    GL_VIEWPORT                                                   = 0x0BA2, // decimal value: 2978
    GL_MODELVIEW0_STACK_DEPTH_EXT                                 = 0x0BA3, // decimal value: 2979
    GL_MODELVIEW_STACK_DEPTH                                      = 0x0BA3, // decimal value: 2979
    GL_PROJECTION_STACK_DEPTH                                     = 0x0BA4, // decimal value: 2980
    GL_TEXTURE_STACK_DEPTH                                        = 0x0BA5, // decimal value: 2981
    GL_MODELVIEW0_MATRIX_EXT                                      = 0x0BA6, // decimal value: 2982
    GL_MODELVIEW_MATRIX                                           = 0x0BA6, // decimal value: 2982
    GL_PROJECTION_MATRIX                                          = 0x0BA7, // decimal value: 2983
    GL_TEXTURE_MATRIX                                             = 0x0BA8, // decimal value: 2984
    GL_ATTRIB_STACK_DEPTH                                         = 0x0BB0, // decimal value: 2992
    GL_CLIENT_ATTRIB_STACK_DEPTH                                  = 0x0BB1, // decimal value: 2993
//  GL_ALPHA_TEST                                                 = 0x0BC0, // reuse EnableCap, decimal value: 3008
    GL_ALPHA_TEST_FUNC                                            = 0x0BC1, // decimal value: 3009
    GL_ALPHA_TEST_REF                                             = 0x0BC2, // decimal value: 3010
//  GL_DITHER                                                     = 0x0BD0, // reuse EnableCap, decimal value: 3024
    GL_BLEND_DST                                                  = 0x0BE0, // decimal value: 3040
    GL_BLEND_SRC                                                  = 0x0BE1, // decimal value: 3041
//  GL_BLEND                                                      = 0x0BE2, // reuse EnableCap, decimal value: 3042
    GL_LOGIC_OP_MODE                                              = 0x0BF0, // decimal value: 3056
//  GL_INDEX_LOGIC_OP                                             = 0x0BF1, // reuse EnableCap, decimal value: 3057
//  GL_LOGIC_OP                                                   = 0x0BF1, // reuse BlendEquationModeEXT, decimal value: 3057
//  GL_COLOR_LOGIC_OP                                             = 0x0BF2, // reuse EnableCap, decimal value: 3058
    GL_AUX_BUFFERS                                                = 0x0C00, // decimal value: 3072
    GL_DRAW_BUFFER                                                = 0x0C01, // decimal value: 3073
    GL_READ_BUFFER                                                = 0x0C02, // decimal value: 3074
    GL_SCISSOR_BOX                                                = 0x0C10, // decimal value: 3088
//  GL_SCISSOR_TEST                                               = 0x0C11, // reuse EnableCap, decimal value: 3089
    GL_INDEX_CLEAR_VALUE                                          = 0x0C20, // decimal value: 3104
    GL_INDEX_WRITEMASK                                            = 0x0C21, // decimal value: 3105
    GL_COLOR_CLEAR_VALUE                                          = 0x0C22, // decimal value: 3106
    GL_COLOR_WRITEMASK                                            = 0x0C23, // decimal value: 3107
    GL_INDEX_MODE                                                 = 0x0C30, // decimal value: 3120
    GL_RGBA_MODE                                                  = 0x0C31, // decimal value: 3121
//  GL_DOUBLEBUFFER                                               = 0x0C32, // reuse GetFramebufferParameter, decimal value: 3122
//  GL_STEREO                                                     = 0x0C33, // reuse GetFramebufferParameter, decimal value: 3123
    GL_RENDER_MODE                                                = 0x0C40, // decimal value: 3136
    GL_PERSPECTIVE_CORRECTION_HINT                                = 0x0C50, // decimal value: 3152
    GL_POINT_SMOOTH_HINT                                          = 0x0C51, // decimal value: 3153
    GL_LINE_SMOOTH_HINT                                           = 0x0C52, // decimal value: 3154
    GL_POLYGON_SMOOTH_HINT                                        = 0x0C53, // decimal value: 3155
    GL_FOG_HINT                                                   = 0x0C54, // decimal value: 3156
//  GL_TEXTURE_GEN_S                                              = 0x0C60, // reuse EnableCap, decimal value: 3168
//  GL_TEXTURE_GEN_T                                              = 0x0C61, // reuse EnableCap, decimal value: 3169
//  GL_TEXTURE_GEN_R                                              = 0x0C62, // reuse EnableCap, decimal value: 3170
//  GL_TEXTURE_GEN_Q                                              = 0x0C63, // reuse EnableCap, decimal value: 3171
    GL_PIXEL_MAP_I_TO_I_SIZE                                      = 0x0CB0, // decimal value: 3248
    GL_PIXEL_MAP_S_TO_S_SIZE                                      = 0x0CB1, // decimal value: 3249
    GL_PIXEL_MAP_I_TO_R_SIZE                                      = 0x0CB2, // decimal value: 3250
    GL_PIXEL_MAP_I_TO_G_SIZE                                      = 0x0CB3, // decimal value: 3251
    GL_PIXEL_MAP_I_TO_B_SIZE                                      = 0x0CB4, // decimal value: 3252
    GL_PIXEL_MAP_I_TO_A_SIZE                                      = 0x0CB5, // decimal value: 3253
    GL_PIXEL_MAP_R_TO_R_SIZE                                      = 0x0CB6, // decimal value: 3254
    GL_PIXEL_MAP_G_TO_G_SIZE                                      = 0x0CB7, // decimal value: 3255
    GL_PIXEL_MAP_B_TO_B_SIZE                                      = 0x0CB8, // decimal value: 3256
    GL_PIXEL_MAP_A_TO_A_SIZE                                      = 0x0CB9, // decimal value: 3257
    GL_UNPACK_SWAP_BYTES                                          = 0x0CF0, // decimal value: 3312
    GL_UNPACK_LSB_FIRST                                           = 0x0CF1, // decimal value: 3313
    GL_UNPACK_ROW_LENGTH                                          = 0x0CF2, // decimal value: 3314
    GL_UNPACK_SKIP_ROWS                                           = 0x0CF3, // decimal value: 3315
    GL_UNPACK_SKIP_PIXELS                                         = 0x0CF4, // decimal value: 3316
    GL_UNPACK_ALIGNMENT                                           = 0x0CF5, // decimal value: 3317
    GL_PACK_SWAP_BYTES                                            = 0x0D00, // decimal value: 3328
    GL_PACK_LSB_FIRST                                             = 0x0D01, // decimal value: 3329
    GL_PACK_ROW_LENGTH                                            = 0x0D02, // decimal value: 3330
    GL_PACK_SKIP_ROWS                                             = 0x0D03, // decimal value: 3331
    GL_PACK_SKIP_PIXELS                                           = 0x0D04, // decimal value: 3332
    GL_PACK_ALIGNMENT                                             = 0x0D05, // decimal value: 3333
    GL_MAP_COLOR                                                  = 0x0D10, // decimal value: 3344
    GL_MAP_STENCIL                                                = 0x0D11, // decimal value: 3345
    GL_INDEX_SHIFT                                                = 0x0D12, // decimal value: 3346
    GL_INDEX_OFFSET                                               = 0x0D13, // decimal value: 3347
    GL_RED_SCALE                                                  = 0x0D14, // decimal value: 3348
    GL_RED_BIAS                                                   = 0x0D15, // decimal value: 3349
    GL_ZOOM_X                                                     = 0x0D16, // decimal value: 3350
    GL_ZOOM_Y                                                     = 0x0D17, // decimal value: 3351
    GL_GREEN_SCALE                                                = 0x0D18, // decimal value: 3352
    GL_GREEN_BIAS                                                 = 0x0D19, // decimal value: 3353
    GL_BLUE_SCALE                                                 = 0x0D1A, // decimal value: 3354
    GL_BLUE_BIAS                                                  = 0x0D1B, // decimal value: 3355
    GL_ALPHA_SCALE                                                = 0x0D1C, // decimal value: 3356
    GL_ALPHA_BIAS                                                 = 0x0D1D, // decimal value: 3357
    GL_DEPTH_SCALE                                                = 0x0D1E, // decimal value: 3358
    GL_DEPTH_BIAS                                                 = 0x0D1F, // decimal value: 3359
    GL_MAX_EVAL_ORDER                                             = 0x0D30, // decimal value: 3376
    GL_MAX_LIGHTS                                                 = 0x0D31, // decimal value: 3377
    GL_MAX_CLIP_DISTANCES                                         = 0x0D32, // decimal value: 3378
    GL_MAX_CLIP_PLANES                                            = 0x0D32, // decimal value: 3378
    GL_MAX_TEXTURE_SIZE                                           = 0x0D33, // decimal value: 3379
    GL_MAX_PIXEL_MAP_TABLE                                        = 0x0D34, // decimal value: 3380
    GL_MAX_ATTRIB_STACK_DEPTH                                     = 0x0D35, // decimal value: 3381
    GL_MAX_MODELVIEW_STACK_DEPTH                                  = 0x0D36, // decimal value: 3382
    GL_MAX_NAME_STACK_DEPTH                                       = 0x0D37, // decimal value: 3383
    GL_MAX_PROJECTION_STACK_DEPTH                                 = 0x0D38, // decimal value: 3384
    GL_MAX_TEXTURE_STACK_DEPTH                                    = 0x0D39, // decimal value: 3385
    GL_MAX_VIEWPORT_DIMS                                          = 0x0D3A, // decimal value: 3386
    GL_MAX_CLIENT_ATTRIB_STACK_DEPTH                              = 0x0D3B, // decimal value: 3387
    GL_SUBPIXEL_BITS                                              = 0x0D50, // decimal value: 3408
    GL_INDEX_BITS                                                 = 0x0D51, // decimal value: 3409
    GL_RED_BITS                                                   = 0x0D52, // decimal value: 3410
    GL_GREEN_BITS                                                 = 0x0D53, // decimal value: 3411
    GL_BLUE_BITS                                                  = 0x0D54, // decimal value: 3412
    GL_ALPHA_BITS                                                 = 0x0D55, // decimal value: 3413
    GL_DEPTH_BITS                                                 = 0x0D56, // decimal value: 3414
    GL_STENCIL_BITS                                               = 0x0D57, // decimal value: 3415
    GL_ACCUM_RED_BITS                                             = 0x0D58, // decimal value: 3416
    GL_ACCUM_GREEN_BITS                                           = 0x0D59, // decimal value: 3417
    GL_ACCUM_BLUE_BITS                                            = 0x0D5A, // decimal value: 3418
    GL_ACCUM_ALPHA_BITS                                           = 0x0D5B, // decimal value: 3419
    GL_NAME_STACK_DEPTH                                           = 0x0D70, // decimal value: 3440
//  GL_AUTO_NORMAL                                                = 0x0D80, // reuse EnableCap, decimal value: 3456
//  GL_MAP1_COLOR_4                                               = 0x0D90, // reuse EnableCap, decimal value: 3472
//  GL_MAP1_INDEX                                                 = 0x0D91, // reuse EnableCap, decimal value: 3473
//  GL_MAP1_NORMAL                                                = 0x0D92, // reuse EnableCap, decimal value: 3474
//  GL_MAP1_TEXTURE_COORD_1                                       = 0x0D93, // reuse EnableCap, decimal value: 3475
//  GL_MAP1_TEXTURE_COORD_2                                       = 0x0D94, // reuse EnableCap, decimal value: 3476
//  GL_MAP1_TEXTURE_COORD_3                                       = 0x0D95, // reuse EnableCap, decimal value: 3477
//  GL_MAP1_TEXTURE_COORD_4                                       = 0x0D96, // reuse EnableCap, decimal value: 3478
//  GL_MAP1_VERTEX_3                                              = 0x0D97, // reuse EnableCap, decimal value: 3479
//  GL_MAP1_VERTEX_4                                              = 0x0D98, // reuse EnableCap, decimal value: 3480
//  GL_MAP2_COLOR_4                                               = 0x0DB0, // reuse EnableCap, decimal value: 3504
//  GL_MAP2_INDEX                                                 = 0x0DB1, // reuse EnableCap, decimal value: 3505
//  GL_MAP2_NORMAL                                                = 0x0DB2, // reuse EnableCap, decimal value: 3506
//  GL_MAP2_TEXTURE_COORD_1                                       = 0x0DB3, // reuse EnableCap, decimal value: 3507
//  GL_MAP2_TEXTURE_COORD_2                                       = 0x0DB4, // reuse EnableCap, decimal value: 3508
//  GL_MAP2_TEXTURE_COORD_3                                       = 0x0DB5, // reuse EnableCap, decimal value: 3509
//  GL_MAP2_TEXTURE_COORD_4                                       = 0x0DB6, // reuse EnableCap, decimal value: 3510
//  GL_MAP2_VERTEX_3                                              = 0x0DB7, // reuse EnableCap, decimal value: 3511
//  GL_MAP2_VERTEX_4                                              = 0x0DB8, // reuse EnableCap, decimal value: 3512
    GL_MAP1_GRID_DOMAIN                                           = 0x0DD0, // decimal value: 3536
    GL_MAP1_GRID_SEGMENTS                                         = 0x0DD1, // decimal value: 3537
    GL_MAP2_GRID_DOMAIN                                           = 0x0DD2, // decimal value: 3538
    GL_MAP2_GRID_SEGMENTS                                         = 0x0DD3, // decimal value: 3539
//  GL_TEXTURE_1D                                                 = 0x0DE0, // reuse EnableCap, decimal value: 3552
//  GL_TEXTURE_2D                                                 = 0x0DE1, // reuse EnableCap, decimal value: 3553
    GL_FEEDBACK_BUFFER_SIZE                                       = 0x0DF1, // decimal value: 3569
    GL_FEEDBACK_BUFFER_TYPE                                       = 0x0DF2, // decimal value: 3570
    GL_SELECTION_BUFFER_SIZE                                      = 0x0DF4, // decimal value: 3572
    GL_POLYGON_OFFSET_UNITS                                       = 0x2A00, // decimal value: 10752
//  GL_POLYGON_OFFSET_POINT                                       = 0x2A01, // reuse EnableCap, decimal value: 10753
//  GL_POLYGON_OFFSET_LINE                                        = 0x2A02, // reuse EnableCap, decimal value: 10754
//  GL_CLIP_PLANE0                                                = 0x3000, // reuse ClipPlaneName, decimal value: 12288
//  GL_CLIP_PLANE1                                                = 0x3001, // reuse ClipPlaneName, decimal value: 12289
//  GL_CLIP_PLANE2                                                = 0x3002, // reuse ClipPlaneName, decimal value: 12290
//  GL_CLIP_PLANE3                                                = 0x3003, // reuse ClipPlaneName, decimal value: 12291
//  GL_CLIP_PLANE4                                                = 0x3004, // reuse ClipPlaneName, decimal value: 12292
//  GL_CLIP_PLANE5                                                = 0x3005, // reuse ClipPlaneName, decimal value: 12293
//  GL_LIGHT0                                                     = 0x4000, // reuse EnableCap, decimal value: 16384
//  GL_LIGHT1                                                     = 0x4001, // reuse EnableCap, decimal value: 16385
//  GL_LIGHT2                                                     = 0x4002, // reuse EnableCap, decimal value: 16386
//  GL_LIGHT3                                                     = 0x4003, // reuse EnableCap, decimal value: 16387
//  GL_LIGHT4                                                     = 0x4004, // reuse EnableCap, decimal value: 16388
//  GL_LIGHT5                                                     = 0x4005, // reuse EnableCap, decimal value: 16389
//  GL_LIGHT6                                                     = 0x4006, // reuse EnableCap, decimal value: 16390
//  GL_LIGHT7                                                     = 0x4007, // reuse EnableCap, decimal value: 16391
    GL_BLEND_COLOR_EXT                                            = 0x8005, // decimal value: 32773
    GL_BLEND_EQUATION_EXT                                         = 0x8009, // decimal value: 32777
    GL_PACK_CMYK_HINT_EXT                                         = 0x800E, // decimal value: 32782
    GL_UNPACK_CMYK_HINT_EXT                                       = 0x800F, // decimal value: 32783
//  GL_CONVOLUTION_1D_EXT                                         = 0x8010, // reuse ConvolutionTargetEXT, decimal value: 32784
//  GL_CONVOLUTION_2D_EXT                                         = 0x8011, // reuse ConvolutionTargetEXT, decimal value: 32785
//  GL_SEPARABLE_2D_EXT                                           = 0x8012, // reuse EnableCap, decimal value: 32786
    GL_POST_CONVOLUTION_RED_SCALE_EXT                             = 0x801C, // decimal value: 32796
    GL_POST_CONVOLUTION_GREEN_SCALE_EXT                           = 0x801D, // decimal value: 32797
    GL_POST_CONVOLUTION_BLUE_SCALE_EXT                            = 0x801E, // decimal value: 32798
    GL_POST_CONVOLUTION_ALPHA_SCALE_EXT                           = 0x801F, // decimal value: 32799
    GL_POST_CONVOLUTION_RED_BIAS_EXT                              = 0x8020, // decimal value: 32800
    GL_POST_CONVOLUTION_GREEN_BIAS_EXT                            = 0x8021, // decimal value: 32801
    GL_POST_CONVOLUTION_BLUE_BIAS_EXT                             = 0x8022, // decimal value: 32802
    GL_POST_CONVOLUTION_ALPHA_BIAS_EXT                            = 0x8023, // decimal value: 32803
//  GL_HISTOGRAM_EXT                                              = 0x8024, // reuse EnableCap, decimal value: 32804
//  GL_MINMAX_EXT                                                 = 0x802E, // reuse EnableCap, decimal value: 32814
//  GL_POLYGON_OFFSET_FILL                                        = 0x8037, // reuse EnableCap, decimal value: 32823
    GL_POLYGON_OFFSET_FACTOR                                      = 0x8038, // decimal value: 32824
    GL_POLYGON_OFFSET_BIAS_EXT                                    = 0x8039, // decimal value: 32825
//  GL_RESCALE_NORMAL_EXT                                         = 0x803A, // reuse EnableCap, decimal value: 32826
    GL_TEXTURE_BINDING_1D                                         = 0x8068, // decimal value: 32872
    GL_TEXTURE_BINDING_2D                                         = 0x8069, // decimal value: 32873
    GL_TEXTURE_3D_BINDING_EXT                                     = 0x806A, // decimal value: 32874
    GL_TEXTURE_BINDING_3D                                         = 0x806A, // decimal value: 32874
    GL_PACK_SKIP_IMAGES_EXT                                       = 0x806B, // decimal value: 32875
    GL_PACK_IMAGE_HEIGHT_EXT                                      = 0x806C, // decimal value: 32876
    GL_UNPACK_SKIP_IMAGES_EXT                                     = 0x806D, // decimal value: 32877
    GL_UNPACK_IMAGE_HEIGHT_EXT                                    = 0x806E, // decimal value: 32878
//  GL_TEXTURE_3D_EXT                                             = 0x806F, // reuse EnableCap, decimal value: 32879
    GL_MAX_3D_TEXTURE_SIZE_EXT                                    = 0x8073, // decimal value: 32883
//  GL_VERTEX_ARRAY                                               = 0x8074, // reuse EnableCap, decimal value: 32884
//  GL_NORMAL_ARRAY                                               = 0x8075, // reuse EnableCap, decimal value: 32885
//  GL_COLOR_ARRAY                                                = 0x8076, // reuse EnableCap, decimal value: 32886
//  GL_INDEX_ARRAY                                                = 0x8077, // reuse EnableCap, decimal value: 32887
//  GL_TEXTURE_COORD_ARRAY                                        = 0x8078, // reuse EnableCap, decimal value: 32888
//  GL_EDGE_FLAG_ARRAY                                            = 0x8079, // reuse EnableCap, decimal value: 32889
    GL_VERTEX_ARRAY_SIZE                                          = 0x807A, // decimal value: 32890
    GL_VERTEX_ARRAY_TYPE                                          = 0x807B, // decimal value: 32891
    GL_VERTEX_ARRAY_STRIDE                                        = 0x807C, // decimal value: 32892
    GL_VERTEX_ARRAY_COUNT_EXT                                     = 0x807D, // decimal value: 32893
    GL_NORMAL_ARRAY_TYPE                                          = 0x807E, // decimal value: 32894
    GL_NORMAL_ARRAY_STRIDE                                        = 0x807F, // decimal value: 32895
    GL_NORMAL_ARRAY_COUNT_EXT                                     = 0x8080, // decimal value: 32896
    GL_COLOR_ARRAY_SIZE                                           = 0x8081, // decimal value: 32897
    GL_COLOR_ARRAY_TYPE                                           = 0x8082, // decimal value: 32898
    GL_COLOR_ARRAY_STRIDE                                         = 0x8083, // decimal value: 32899
    GL_COLOR_ARRAY_COUNT_EXT                                      = 0x8084, // decimal value: 32900
    GL_INDEX_ARRAY_TYPE                                           = 0x8085, // decimal value: 32901
    GL_INDEX_ARRAY_STRIDE                                         = 0x8086, // decimal value: 32902
    GL_INDEX_ARRAY_COUNT_EXT                                      = 0x8087, // decimal value: 32903
    GL_TEXTURE_COORD_ARRAY_SIZE                                   = 0x8088, // decimal value: 32904
    GL_TEXTURE_COORD_ARRAY_TYPE                                   = 0x8089, // decimal value: 32905
    GL_TEXTURE_COORD_ARRAY_STRIDE                                 = 0x808A, // decimal value: 32906
    GL_TEXTURE_COORD_ARRAY_COUNT_EXT                              = 0x808B, // decimal value: 32907
    GL_EDGE_FLAG_ARRAY_STRIDE                                     = 0x808C, // decimal value: 32908
    GL_EDGE_FLAG_ARRAY_COUNT_EXT                                  = 0x808D, // decimal value: 32909
//  GL_INTERLACE_SGIX                                             = 0x8094, // reuse EnableCap, decimal value: 32916
    GL_DETAIL_TEXTURE_2D_BINDING_SGIS                             = 0x8096, // decimal value: 32918
//  GL_MULTISAMPLE_SGIS                                           = 0x809D, // reuse EnableCap, decimal value: 32925
//  GL_SAMPLE_ALPHA_TO_MASK_SGIS                                  = 0x809E, // reuse EnableCap, decimal value: 32926
//  GL_SAMPLE_ALPHA_TO_ONE_SGIS                                   = 0x809F, // reuse EnableCap, decimal value: 32927
//  GL_SAMPLE_MASK_SGIS                                           = 0x80A0, // reuse EnableCap, decimal value: 32928
    GL_SAMPLE_BUFFERS_SGIS                                        = 0x80A8, // decimal value: 32936
    GL_SAMPLES_SGIS                                               = 0x80A9, // decimal value: 32937
    GL_SAMPLE_MASK_VALUE_SGIS                                     = 0x80AA, // decimal value: 32938
    GL_SAMPLE_MASK_INVERT_SGIS                                    = 0x80AB, // decimal value: 32939
    GL_SAMPLE_PATTERN_SGIS                                        = 0x80AC, // decimal value: 32940
    GL_COLOR_MATRIX_SGI                                           = 0x80B1, // decimal value: 32945
    GL_COLOR_MATRIX_STACK_DEPTH_SGI                               = 0x80B2, // decimal value: 32946
    GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI                           = 0x80B3, // decimal value: 32947
    GL_POST_COLOR_MATRIX_RED_SCALE_SGI                            = 0x80B4, // decimal value: 32948
    GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI                          = 0x80B5, // decimal value: 32949
    GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI                           = 0x80B6, // decimal value: 32950
    GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI                          = 0x80B7, // decimal value: 32951
    GL_POST_COLOR_MATRIX_RED_BIAS_SGI                             = 0x80B8, // decimal value: 32952
    GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI                           = 0x80B9, // decimal value: 32953
    GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI                            = 0x80BA, // decimal value: 32954
    GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI                           = 0x80BB, // decimal value: 32955
//  GL_TEXTURE_COLOR_TABLE_SGI                                    = 0x80BC, // reuse ColorTableTargetSGI, decimal value: 32956
//  GL_COLOR_TABLE_SGI                                            = 0x80D0, // reuse ColorTableTargetSGI, decimal value: 32976
//  GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           = 0x80D1, // reuse ColorTableTargetSGI, decimal value: 32977
//  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          = 0x80D2, // reuse ColorTableTargetSGI, decimal value: 32978
    GL_POINT_SIZE_MIN_SGIS                                        = 0x8126, // decimal value: 33062
    GL_POINT_SIZE_MAX_SGIS                                        = 0x8127, // decimal value: 33063
    GL_POINT_FADE_THRESHOLD_SIZE_SGIS                             = 0x8128, // decimal value: 33064
    GL_DISTANCE_ATTENUATION_SGIS                                  = 0x8129, // decimal value: 33065
    GL_FOG_FUNC_POINTS_SGIS                                       = 0x812B, // decimal value: 33067
    GL_MAX_FOG_FUNC_POINTS_SGIS                                   = 0x812C, // decimal value: 33068
    GL_PACK_SKIP_VOLUMES_SGIS                                     = 0x8130, // decimal value: 33072
    GL_PACK_IMAGE_DEPTH_SGIS                                      = 0x8131, // decimal value: 33073
    GL_UNPACK_SKIP_VOLUMES_SGIS                                   = 0x8132, // decimal value: 33074
    GL_UNPACK_IMAGE_DEPTH_SGIS                                    = 0x8133, // decimal value: 33075
//  GL_TEXTURE_4D_SGIS                                            = 0x8134, // reuse EnableCap, decimal value: 33076
    GL_MAX_4D_TEXTURE_SIZE_SGIS                                   = 0x8138, // decimal value: 33080
//  GL_PIXEL_TEX_GEN_SGIX                                         = 0x8139, // reuse EnableCap, decimal value: 33081
    GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX                             = 0x813E, // decimal value: 33086
    GL_PIXEL_TILE_CACHE_INCREMENT_SGIX                            = 0x813F, // decimal value: 33087
    GL_PIXEL_TILE_WIDTH_SGIX                                      = 0x8140, // decimal value: 33088
    GL_PIXEL_TILE_HEIGHT_SGIX                                     = 0x8141, // decimal value: 33089
    GL_PIXEL_TILE_GRID_WIDTH_SGIX                                 = 0x8142, // decimal value: 33090
    GL_PIXEL_TILE_GRID_HEIGHT_SGIX                                = 0x8143, // decimal value: 33091
    GL_PIXEL_TILE_GRID_DEPTH_SGIX                                 = 0x8144, // decimal value: 33092
    GL_PIXEL_TILE_CACHE_SIZE_SGIX                                 = 0x8145, // decimal value: 33093
//  GL_SPRITE_SGIX                                                = 0x8148, // reuse EnableCap, decimal value: 33096
    GL_SPRITE_MODE_SGIX                                           = 0x8149, // decimal value: 33097
    GL_SPRITE_AXIS_SGIX                                           = 0x814A, // decimal value: 33098
    GL_SPRITE_TRANSLATION_SGIX                                    = 0x814B, // decimal value: 33099
    GL_TEXTURE_4D_BINDING_SGIS                                    = 0x814F, // decimal value: 33103
    GL_MAX_CLIPMAP_DEPTH_SGIX                                     = 0x8177, // decimal value: 33143
    GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX                             = 0x8178, // decimal value: 33144
    GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX                        = 0x817B, // decimal value: 33147
    GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX                       = 0x817C, // decimal value: 33148
//  GL_REFERENCE_PLANE_SGIX                                       = 0x817D, // reuse EnableCap, decimal value: 33149
    GL_REFERENCE_PLANE_EQUATION_SGIX                              = 0x817E, // decimal value: 33150
//  GL_IR_INSTRUMENT1_SGIX                                        = 0x817F, // reuse EnableCap, decimal value: 33151
    GL_INSTRUMENT_MEASUREMENTS_SGIX                               = 0x8181, // decimal value: 33153
//  GL_CALLIGRAPHIC_FRAGMENT_SGIX                                 = 0x8183, // reuse EnableCap, decimal value: 33155
//  GL_FRAMEZOOM_SGIX                                             = 0x818B, // reuse EnableCap, decimal value: 33163
    GL_FRAMEZOOM_FACTOR_SGIX                                      = 0x818C, // decimal value: 33164
    GL_MAX_FRAMEZOOM_FACTOR_SGIX                                  = 0x818D, // decimal value: 33165
    GL_GENERATE_MIPMAP_HINT_SGIS                                  = 0x8192, // decimal value: 33170
    GL_DEFORMATIONS_MASK_SGIX                                     = 0x8196, // decimal value: 33174
//  GL_FOG_OFFSET_SGIX                                            = 0x8198, // reuse EnableCap, decimal value: 33176
//  GL_FOG_OFFSET_VALUE_SGIX                                      = 0x8199, // reuse FogParameter, decimal value: 33177
    GL_LIGHT_MODEL_COLOR_CONTROL                                  = 0x81F8, // decimal value: 33272
//  GL_SHARED_TEXTURE_PALETTE_EXT                                 = 0x81FB, // reuse EnableCap, decimal value: 33275
    GL_CONVOLUTION_HINT_SGIX                                      = 0x8316, // decimal value: 33558
    GL_ASYNC_MARKER_SGIX                                          = 0x8329, // decimal value: 33577
    GL_PIXEL_TEX_GEN_MODE_SGIX                                    = 0x832B, // decimal value: 33579
//  GL_ASYNC_HISTOGRAM_SGIX                                       = 0x832C, // reuse EnableCap, decimal value: 33580
    GL_MAX_ASYNC_HISTOGRAM_SGIX                                   = 0x832D, // decimal value: 33581
//  GL_PIXEL_TEXTURE_SGIS                                         = 0x8353, // reuse EnableCap, decimal value: 33619
//  GL_ASYNC_TEX_IMAGE_SGIX                                       = 0x835C, // reuse EnableCap, decimal value: 33628
//  GL_ASYNC_DRAW_PIXELS_SGIX                                     = 0x835D, // reuse EnableCap, decimal value: 33629
//  GL_ASYNC_READ_PIXELS_SGIX                                     = 0x835E, // reuse EnableCap, decimal value: 33630
    GL_MAX_ASYNC_TEX_IMAGE_SGIX                                   = 0x835F, // decimal value: 33631
    GL_MAX_ASYNC_DRAW_PIXELS_SGIX                                 = 0x8360, // decimal value: 33632
    GL_MAX_ASYNC_READ_PIXELS_SGIX                                 = 0x8361, // decimal value: 33633
    GL_VERTEX_PRECLIP_SGIX                                        = 0x83EE, // decimal value: 33774
    GL_VERTEX_PRECLIP_HINT_SGIX                                   = 0x83EF, // decimal value: 33775
//  GL_FRAGMENT_LIGHTING_SGIX                                     = 0x8400, // reuse EnableCap, decimal value: 33792
//  GL_FRAGMENT_COLOR_MATERIAL_SGIX                               = 0x8401, // reuse EnableCap, decimal value: 33793
    GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX                          = 0x8402, // decimal value: 33794
    GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX                     = 0x8403, // decimal value: 33795
    GL_MAX_FRAGMENT_LIGHTS_SGIX                                   = 0x8404, // decimal value: 33796
    GL_MAX_ACTIVE_LIGHTS_SGIX                                     = 0x8405, // decimal value: 33797
    GL_LIGHT_ENV_MODE_SGIX                                        = 0x8407, // decimal value: 33799
//  GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX                     = 0x8408, // reuse FragmentLightModelParameterSGIX, decimal value: 33800
//  GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX                         = 0x8409, // reuse FragmentLightModelParameterSGIX, decimal value: 33801
//  GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX                          = 0x840A, // reuse FragmentLightModelParameterSGIX, decimal value: 33802
//  GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX             = 0x840B, // reuse FragmentLightModelParameterSGIX, decimal value: 33803
//  GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C, // reuse EnableCap, decimal value: 33804
    GL_PACK_RESAMPLE_SGIX                                         = 0x842E, // decimal value: 33838
    GL_UNPACK_RESAMPLE_SGIX                                       = 0x842F, // decimal value: 33839
    GL_ALIASED_POINT_SIZE_RANGE                                   = 0x846D, // decimal value: 33901
    GL_ALIASED_LINE_WIDTH_RANGE                                   = 0x846E, // decimal value: 33902
    GL_PACK_SUBSAMPLE_RATE_SGIX                                   = 0x85A0, // decimal value: 34208
    GL_UNPACK_SUBSAMPLE_RATE_SGIX                                 = 0x85A1, // decimal value: 34209
    GL_NUM_DEVICE_UUIDS_EXT                                       = 0x9596, // decimal value: 38294
    GL_DEVICE_UUID_EXT                                            = 0x9597, // decimal value: 38295
    GL_DRIVER_UUID_EXT                                            = 0x9598, // decimal value: 38296
    GL_DEVICE_LUID_EXT                                            = 0x9599, // decimal value: 38297
    GL_DEVICE_NODE_MASK_EXT                                       = 0x959A, // decimal value: 38298

    // GetPixelMap

    GL_PIXEL_MAP_I_TO_I                                           = 0x0C70, // decimal value: 3184
    GL_PIXEL_MAP_S_TO_S                                           = 0x0C71, // decimal value: 3185
    GL_PIXEL_MAP_I_TO_R                                           = 0x0C72, // decimal value: 3186
    GL_PIXEL_MAP_I_TO_G                                           = 0x0C73, // decimal value: 3187
    GL_PIXEL_MAP_I_TO_B                                           = 0x0C74, // decimal value: 3188
    GL_PIXEL_MAP_I_TO_A                                           = 0x0C75, // decimal value: 3189
    GL_PIXEL_MAP_R_TO_R                                           = 0x0C76, // decimal value: 3190
    GL_PIXEL_MAP_G_TO_G                                           = 0x0C77, // decimal value: 3191
    GL_PIXEL_MAP_B_TO_B                                           = 0x0C78, // decimal value: 3192
    GL_PIXEL_MAP_A_TO_A                                           = 0x0C79, // decimal value: 3193

    // GetPointervPName

    GL_FEEDBACK_BUFFER_POINTER                                    = 0x0DF0, // decimal value: 3568
    GL_SELECTION_BUFFER_POINTER                                   = 0x0DF3, // decimal value: 3571
    GL_VERTEX_ARRAY_POINTER                                       = 0x808E, // decimal value: 32910
    GL_VERTEX_ARRAY_POINTER_EXT                                   = 0x808E, // decimal value: 32910
    GL_NORMAL_ARRAY_POINTER                                       = 0x808F, // decimal value: 32911
    GL_NORMAL_ARRAY_POINTER_EXT                                   = 0x808F, // decimal value: 32911
    GL_COLOR_ARRAY_POINTER                                        = 0x8090, // decimal value: 32912
    GL_COLOR_ARRAY_POINTER_EXT                                    = 0x8090, // decimal value: 32912
    GL_INDEX_ARRAY_POINTER                                        = 0x8091, // decimal value: 32913
    GL_INDEX_ARRAY_POINTER_EXT                                    = 0x8091, // decimal value: 32913
    GL_TEXTURE_COORD_ARRAY_POINTER                                = 0x8092, // decimal value: 32914
    GL_TEXTURE_COORD_ARRAY_POINTER_EXT                            = 0x8092, // decimal value: 32914
    GL_EDGE_FLAG_ARRAY_POINTER                                    = 0x8093, // decimal value: 32915
    GL_EDGE_FLAG_ARRAY_POINTER_EXT                                = 0x8093, // decimal value: 32915
    GL_INSTRUMENT_BUFFER_POINTER_SGIX                             = 0x8180, // decimal value: 33152
    GL_DEBUG_CALLBACK_FUNCTION                                    = 0x8244, // decimal value: 33348
    GL_DEBUG_CALLBACK_USER_PARAM                                  = 0x8245, // decimal value: 33349

    // GetTextureParameter

    GL_TEXTURE_WIDTH                                              = 0x1000, // decimal value: 4096
    GL_TEXTURE_HEIGHT                                             = 0x1001, // decimal value: 4097
    GL_TEXTURE_COMPONENTS                                         = 0x1003, // decimal value: 4099
    GL_TEXTURE_INTERNAL_FORMAT                                    = 0x1003, // decimal value: 4099
    GL_TEXTURE_BORDER_COLOR                                       = 0x1004, // decimal value: 4100
    GL_TEXTURE_BORDER                                             = 0x1005, // decimal value: 4101
    GL_TEXTURE_MAG_FILTER                                         = 0x2800, // decimal value: 10240
    GL_TEXTURE_MIN_FILTER                                         = 0x2801, // decimal value: 10241
    GL_TEXTURE_WRAP_S                                             = 0x2802, // decimal value: 10242
    GL_TEXTURE_WRAP_T                                             = 0x2803, // decimal value: 10243
    GL_TEXTURE_RED_SIZE                                           = 0x805C, // decimal value: 32860
    GL_TEXTURE_GREEN_SIZE                                         = 0x805D, // decimal value: 32861
    GL_TEXTURE_BLUE_SIZE                                          = 0x805E, // decimal value: 32862
    GL_TEXTURE_ALPHA_SIZE                                         = 0x805F, // decimal value: 32863
    GL_TEXTURE_LUMINANCE_SIZE                                     = 0x8060, // decimal value: 32864
    GL_TEXTURE_INTENSITY_SIZE                                     = 0x8061, // decimal value: 32865
    GL_TEXTURE_PRIORITY                                           = 0x8066, // decimal value: 32870
    GL_TEXTURE_RESIDENT                                           = 0x8067, // decimal value: 32871
    GL_TEXTURE_DEPTH_EXT                                          = 0x8071, // decimal value: 32881
    GL_TEXTURE_WRAP_R_EXT                                         = 0x8072, // decimal value: 32882
    GL_DETAIL_TEXTURE_LEVEL_SGIS                                  = 0x809A, // decimal value: 32922
    GL_DETAIL_TEXTURE_MODE_SGIS                                   = 0x809B, // decimal value: 32923
    GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS                            = 0x809C, // decimal value: 32924
    GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS                           = 0x80B0, // decimal value: 32944
    GL_SHADOW_AMBIENT_SGIX                                        = 0x80BF, // decimal value: 32959
    GL_DUAL_TEXTURE_SELECT_SGIS                                   = 0x8124, // decimal value: 33060
    GL_QUAD_TEXTURE_SELECT_SGIS                                   = 0x8125, // decimal value: 33061
    GL_TEXTURE_4DSIZE_SGIS                                        = 0x8136, // decimal value: 33078
    GL_TEXTURE_WRAP_Q_SGIS                                        = 0x8137, // decimal value: 33079
    GL_TEXTURE_MIN_LOD_SGIS                                       = 0x813A, // decimal value: 33082
    GL_TEXTURE_MAX_LOD_SGIS                                       = 0x813B, // decimal value: 33083
    GL_TEXTURE_BASE_LEVEL_SGIS                                    = 0x813C, // decimal value: 33084
    GL_TEXTURE_MAX_LEVEL_SGIS                                     = 0x813D, // decimal value: 33085
    GL_TEXTURE_FILTER4_SIZE_SGIS                                  = 0x8147, // decimal value: 33095
    GL_TEXTURE_CLIPMAP_CENTER_SGIX                                = 0x8171, // decimal value: 33137
    GL_TEXTURE_CLIPMAP_FRAME_SGIX                                 = 0x8172, // decimal value: 33138
    GL_TEXTURE_CLIPMAP_OFFSET_SGIX                                = 0x8173, // decimal value: 33139
    GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX                         = 0x8174, // decimal value: 33140
    GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX                            = 0x8175, // decimal value: 33141
    GL_TEXTURE_CLIPMAP_DEPTH_SGIX                                 = 0x8176, // decimal value: 33142
    GL_POST_TEXTURE_FILTER_BIAS_SGIX                              = 0x8179, // decimal value: 33145
    GL_POST_TEXTURE_FILTER_SCALE_SGIX                             = 0x817A, // decimal value: 33146
    GL_TEXTURE_LOD_BIAS_S_SGIX                                    = 0x818E, // decimal value: 33166
    GL_TEXTURE_LOD_BIAS_T_SGIX                                    = 0x818F, // decimal value: 33167
    GL_TEXTURE_LOD_BIAS_R_SGIX                                    = 0x8190, // decimal value: 33168
    GL_GENERATE_MIPMAP_SGIS                                       = 0x8191, // decimal value: 33169
    GL_TEXTURE_COMPARE_SGIX                                       = 0x819A, // decimal value: 33178
    GL_TEXTURE_COMPARE_OPERATOR_SGIX                              = 0x819B, // decimal value: 33179
    GL_TEXTURE_LEQUAL_R_SGIX                                      = 0x819C, // decimal value: 33180
    GL_TEXTURE_GEQUAL_R_SGIX                                      = 0x819D, // decimal value: 33181
    GL_TEXTURE_MAX_CLAMP_S_SGIX                                   = 0x8369, // decimal value: 33641
    GL_TEXTURE_MAX_CLAMP_T_SGIX                                   = 0x836A, // decimal value: 33642
    GL_TEXTURE_MAX_CLAMP_R_SGIX                                   = 0x836B, // decimal value: 33643

    // GraphicsResetStatus

//  GL_NO_ERROR                                                   = 0, // reuse ErrorCode
    GL_GUILTY_CONTEXT_RESET                                       = 0x8253, // decimal value: 33363
    GL_INNOCENT_CONTEXT_RESET                                     = 0x8254, // decimal value: 33364
    GL_UNKNOWN_CONTEXT_RESET                                      = 0x8255, // decimal value: 33365

    // HintMode

//  GL_DONT_CARE                                                  = 0x1100, // reuse DebugSeverity, decimal value: 4352
    GL_FASTEST                                                    = 0x1101, // decimal value: 4353
    GL_NICEST                                                     = 0x1102, // decimal value: 4354

    // HintTarget

//  GL_PERSPECTIVE_CORRECTION_HINT                                = 0x0C50, // reuse GetPName, decimal value: 3152
//  GL_POINT_SMOOTH_HINT                                          = 0x0C51, // reuse GetPName, decimal value: 3153
//  GL_LINE_SMOOTH_HINT                                           = 0x0C52, // reuse GetPName, decimal value: 3154
//  GL_POLYGON_SMOOTH_HINT                                        = 0x0C53, // reuse GetPName, decimal value: 3155
//  GL_FOG_HINT                                                   = 0x0C54, // reuse GetPName, decimal value: 3156
    GL_PREFER_DOUBLEBUFFER_HINT_PGI                               = 0x1A1F8, // decimal value: 107000
    GL_CONSERVE_MEMORY_HINT_PGI                                   = 0x1A1FD, // decimal value: 107005
    GL_RECLAIM_MEMORY_HINT_PGI                                    = 0x1A1FE, // decimal value: 107006
    GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI                             = 0x1A203, // decimal value: 107011
    GL_NATIVE_GRAPHICS_END_HINT_PGI                               = 0x1A204, // decimal value: 107012
    GL_ALWAYS_FAST_HINT_PGI                                       = 0x1A20C, // decimal value: 107020
    GL_ALWAYS_SOFT_HINT_PGI                                       = 0x1A20D, // decimal value: 107021
    GL_ALLOW_DRAW_OBJ_HINT_PGI                                    = 0x1A20E, // decimal value: 107022
    GL_ALLOW_DRAW_WIN_HINT_PGI                                    = 0x1A20F, // decimal value: 107023
    GL_ALLOW_DRAW_FRG_HINT_PGI                                    = 0x1A210, // decimal value: 107024
    GL_ALLOW_DRAW_MEM_HINT_PGI                                    = 0x1A211, // decimal value: 107025
    GL_STRICT_DEPTHFUNC_HINT_PGI                                  = 0x1A216, // decimal value: 107030
    GL_STRICT_LIGHTING_HINT_PGI                                   = 0x1A217, // decimal value: 107031
    GL_STRICT_SCISSOR_HINT_PGI                                    = 0x1A218, // decimal value: 107032
    GL_FULL_STIPPLE_HINT_PGI                                      = 0x1A219, // decimal value: 107033
    GL_CLIP_NEAR_HINT_PGI                                         = 0x1A220, // decimal value: 107040
    GL_CLIP_FAR_HINT_PGI                                          = 0x1A221, // decimal value: 107041
    GL_WIDE_LINE_HINT_PGI                                         = 0x1A222, // decimal value: 107042
    GL_BACK_NORMALS_HINT_PGI                                      = 0x1A223, // decimal value: 107043
    GL_VERTEX_DATA_HINT_PGI                                       = 0x1A22A, // decimal value: 107050
    GL_VERTEX_CONSISTENT_HINT_PGI                                 = 0x1A22B, // decimal value: 107051
    GL_MATERIAL_SIDE_HINT_PGI                                     = 0x1A22C, // decimal value: 107052
    GL_MAX_VERTEX_HINT_PGI                                        = 0x1A22D, // decimal value: 107053
//  GL_PACK_CMYK_HINT_EXT                                         = 0x800E, // reuse GetPName, decimal value: 32782
//  GL_UNPACK_CMYK_HINT_EXT                                       = 0x800F, // reuse GetPName, decimal value: 32783
    GL_PHONG_HINT_WIN                                             = 0x80EB, // decimal value: 33003
    GL_CLIP_VOLUME_CLIPPING_HINT_EXT                              = 0x80F0, // decimal value: 33008
    GL_TEXTURE_MULTI_BUFFER_HINT_SGIX                             = 0x812E, // decimal value: 33070
    GL_GENERATE_MIPMAP_HINT                                       = 0x8192, // decimal value: 33170
//  GL_GENERATE_MIPMAP_HINT_SGIS                                  = 0x8192, // reuse GetPName, decimal value: 33170
    GL_PROGRAM_BINARY_RETRIEVABLE_HINT                            = 0x8257, // decimal value: 33367
//  GL_CONVOLUTION_HINT_SGIX                                      = 0x8316, // reuse GetPName, decimal value: 33558
    GL_SCALEBIAS_HINT_SGIX                                        = 0x8322, // decimal value: 33570
//  GL_VERTEX_PRECLIP_SGIX                                        = 0x83EE, // reuse GetPName, decimal value: 33774
//  GL_VERTEX_PRECLIP_HINT_SGIX                                   = 0x83EF, // reuse GetPName, decimal value: 33775
    GL_TEXTURE_COMPRESSION_HINT                                   = 0x84EF, // decimal value: 34031
    GL_TEXTURE_COMPRESSION_HINT_ARB                               = 0x84EF, // decimal value: 34031
    GL_VERTEX_ARRAY_STORAGE_HINT_APPLE                            = 0x851F, // decimal value: 34079
    GL_MULTISAMPLE_FILTER_HINT_NV                                 = 0x8534, // decimal value: 34100
    GL_TRANSFORM_HINT_APPLE                                       = 0x85B1, // decimal value: 34225
    GL_TEXTURE_STORAGE_HINT_APPLE                                 = 0x85BC, // decimal value: 34236
    GL_FRAGMENT_SHADER_DERIVATIVE_HINT                            = 0x8B8B, // decimal value: 35723
    GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB                        = 0x8B8B, // decimal value: 35723

    // HistogramTargetEXT

    GL_HISTOGRAM                                                  = 0x8024, // decimal value: 32804
//  GL_HISTOGRAM_EXT                                              = 0x8024, // reuse EnableCap, decimal value: 32804
    GL_PROXY_HISTOGRAM                                            = 0x8025, // decimal value: 32805
    GL_PROXY_HISTOGRAM_EXT                                        = 0x8025, // decimal value: 32805

    // IndexPointerType

//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // InterleavedArrayFormat

    GL_V2F                                                        = 0x2A20, // decimal value: 10784
    GL_V3F                                                        = 0x2A21, // decimal value: 10785
    GL_C4UB_V2F                                                   = 0x2A22, // decimal value: 10786
    GL_C4UB_V3F                                                   = 0x2A23, // decimal value: 10787
    GL_C3F_V3F                                                    = 0x2A24, // decimal value: 10788
    GL_N3F_V3F                                                    = 0x2A25, // decimal value: 10789
    GL_C4F_N3F_V3F                                                = 0x2A26, // decimal value: 10790
    GL_T2F_V3F                                                    = 0x2A27, // decimal value: 10791
    GL_T4F_V4F                                                    = 0x2A28, // decimal value: 10792
    GL_T2F_C4UB_V3F                                               = 0x2A29, // decimal value: 10793
    GL_T2F_C3F_V3F                                                = 0x2A2A, // decimal value: 10794
    GL_T2F_N3F_V3F                                                = 0x2A2B, // decimal value: 10795
    GL_T2F_C4F_N3F_V3F                                            = 0x2A2C, // decimal value: 10796
    GL_T4F_C4F_N3F_V4F                                            = 0x2A2D, // decimal value: 10797

    // InternalFormat

    GL_DEPTH_COMPONENT                                            = 0x1902, // decimal value: 6402
    GL_RED                                                        = 0x1903, // decimal value: 6403
    GL_RGB                                                        = 0x1907, // decimal value: 6407
    GL_RGBA                                                       = 0x1908, // decimal value: 6408
    GL_R3_G3_B2                                                   = 0x2A10, // decimal value: 10768
    GL_ALPHA4                                                     = 0x803B, // decimal value: 32827
    GL_ALPHA8                                                     = 0x803C, // decimal value: 32828
    GL_ALPHA12                                                    = 0x803D, // decimal value: 32829
    GL_ALPHA16                                                    = 0x803E, // decimal value: 32830
    GL_LUMINANCE4                                                 = 0x803F, // decimal value: 32831
    GL_LUMINANCE8                                                 = 0x8040, // decimal value: 32832
    GL_LUMINANCE12                                                = 0x8041, // decimal value: 32833
    GL_LUMINANCE16                                                = 0x8042, // decimal value: 32834
    GL_LUMINANCE4_ALPHA4                                          = 0x8043, // decimal value: 32835
    GL_LUMINANCE6_ALPHA2                                          = 0x8044, // decimal value: 32836
    GL_LUMINANCE8_ALPHA8                                          = 0x8045, // decimal value: 32837
    GL_LUMINANCE12_ALPHA4                                         = 0x8046, // decimal value: 32838
    GL_LUMINANCE12_ALPHA12                                        = 0x8047, // decimal value: 32839
    GL_LUMINANCE16_ALPHA16                                        = 0x8048, // decimal value: 32840
    GL_INTENSITY                                                  = 0x8049, // decimal value: 32841
    GL_INTENSITY4                                                 = 0x804A, // decimal value: 32842
    GL_INTENSITY8                                                 = 0x804B, // decimal value: 32843
    GL_INTENSITY12                                                = 0x804C, // decimal value: 32844
    GL_INTENSITY16                                                = 0x804D, // decimal value: 32845
    GL_RGB2_EXT                                                   = 0x804E, // decimal value: 32846
    GL_RGB4                                                       = 0x804F, // decimal value: 32847
    GL_RGB4_EXT                                                   = 0x804F, // decimal value: 32847
    GL_RGB5                                                       = 0x8050, // decimal value: 32848
    GL_RGB5_EXT                                                   = 0x8050, // decimal value: 32848
    GL_RGB8                                                       = 0x8051, // decimal value: 32849
    GL_RGB8_EXT                                                   = 0x8051, // decimal value: 32849
    GL_RGB10                                                      = 0x8052, // decimal value: 32850
    GL_RGB10_EXT                                                  = 0x8052, // decimal value: 32850
    GL_RGB12                                                      = 0x8053, // decimal value: 32851
    GL_RGB12_EXT                                                  = 0x8053, // decimal value: 32851
    GL_RGB16                                                      = 0x8054, // decimal value: 32852
    GL_RGB16_EXT                                                  = 0x8054, // decimal value: 32852
    GL_RGBA4                                                      = 0x8056, // decimal value: 32854
    GL_RGBA4_EXT                                                  = 0x8056, // decimal value: 32854
    GL_RGB5_A1                                                    = 0x8057, // decimal value: 32855
    GL_RGB5_A1_EXT                                                = 0x8057, // decimal value: 32855
    GL_RGBA8                                                      = 0x8058, // decimal value: 32856
    GL_RGBA8_EXT                                                  = 0x8058, // decimal value: 32856
    GL_RGB10_A2                                                   = 0x8059, // decimal value: 32857
    GL_RGB10_A2_EXT                                               = 0x8059, // decimal value: 32857
    GL_RGBA12                                                     = 0x805A, // decimal value: 32858
    GL_RGBA12_EXT                                                 = 0x805A, // decimal value: 32858
    GL_RGBA16                                                     = 0x805B, // decimal value: 32859
    GL_RGBA16_EXT                                                 = 0x805B, // decimal value: 32859
    GL_DUAL_ALPHA4_SGIS                                           = 0x8110, // decimal value: 33040
    GL_DUAL_ALPHA8_SGIS                                           = 0x8111, // decimal value: 33041
    GL_DUAL_ALPHA12_SGIS                                          = 0x8112, // decimal value: 33042
    GL_DUAL_ALPHA16_SGIS                                          = 0x8113, // decimal value: 33043
    GL_DUAL_LUMINANCE4_SGIS                                       = 0x8114, // decimal value: 33044
    GL_DUAL_LUMINANCE8_SGIS                                       = 0x8115, // decimal value: 33045
    GL_DUAL_LUMINANCE12_SGIS                                      = 0x8116, // decimal value: 33046
    GL_DUAL_LUMINANCE16_SGIS                                      = 0x8117, // decimal value: 33047
    GL_DUAL_INTENSITY4_SGIS                                       = 0x8118, // decimal value: 33048
    GL_DUAL_INTENSITY8_SGIS                                       = 0x8119, // decimal value: 33049
    GL_DUAL_INTENSITY12_SGIS                                      = 0x811A, // decimal value: 33050
    GL_DUAL_INTENSITY16_SGIS                                      = 0x811B, // decimal value: 33051
    GL_DUAL_LUMINANCE_ALPHA4_SGIS                                 = 0x811C, // decimal value: 33052
    GL_DUAL_LUMINANCE_ALPHA8_SGIS                                 = 0x811D, // decimal value: 33053
    GL_QUAD_ALPHA4_SGIS                                           = 0x811E, // decimal value: 33054
    GL_QUAD_ALPHA8_SGIS                                           = 0x811F, // decimal value: 33055
    GL_QUAD_LUMINANCE4_SGIS                                       = 0x8120, // decimal value: 33056
    GL_QUAD_LUMINANCE8_SGIS                                       = 0x8121, // decimal value: 33057
    GL_QUAD_INTENSITY4_SGIS                                       = 0x8122, // decimal value: 33058
    GL_QUAD_INTENSITY8_SGIS                                       = 0x8123, // decimal value: 33059
    GL_DEPTH_COMPONENT16                                          = 0x81A5, // decimal value: 33189
    GL_DEPTH_COMPONENT16_ARB                                      = 0x81A5, // decimal value: 33189
    GL_DEPTH_COMPONENT16_SGIX                                     = 0x81A5, // decimal value: 33189
    GL_DEPTH_COMPONENT24_ARB                                      = 0x81A6, // decimal value: 33190
    GL_DEPTH_COMPONENT24_SGIX                                     = 0x81A6, // decimal value: 33190
    GL_DEPTH_COMPONENT32_ARB                                      = 0x81A7, // decimal value: 33191
    GL_DEPTH_COMPONENT32_SGIX                                     = 0x81A7, // decimal value: 33191
    GL_COMPRESSED_RED                                             = 0x8225, // decimal value: 33317
    GL_COMPRESSED_RG                                              = 0x8226, // decimal value: 33318
    GL_RG                                                         = 0x8227, // decimal value: 33319
    GL_R8                                                         = 0x8229, // decimal value: 33321
    GL_R16                                                        = 0x822A, // decimal value: 33322
    GL_RG8                                                        = 0x822B, // decimal value: 33323
    GL_RG16                                                       = 0x822C, // decimal value: 33324
    GL_R16F                                                       = 0x822D, // decimal value: 33325
    GL_R32F                                                       = 0x822E, // decimal value: 33326
    GL_RG16F                                                      = 0x822F, // decimal value: 33327
    GL_RG32F                                                      = 0x8230, // decimal value: 33328
    GL_R8I                                                        = 0x8231, // decimal value: 33329
    GL_R8UI                                                       = 0x8232, // decimal value: 33330
    GL_R16I                                                       = 0x8233, // decimal value: 33331
    GL_R16UI                                                      = 0x8234, // decimal value: 33332
    GL_R32I                                                       = 0x8235, // decimal value: 33333
    GL_R32UI                                                      = 0x8236, // decimal value: 33334
    GL_RG8I                                                       = 0x8237, // decimal value: 33335
    GL_RG8UI                                                      = 0x8238, // decimal value: 33336
    GL_RG16I                                                      = 0x8239, // decimal value: 33337
    GL_RG16UI                                                     = 0x823A, // decimal value: 33338
    GL_RG32I                                                      = 0x823B, // decimal value: 33339
    GL_RG32UI                                                     = 0x823C, // decimal value: 33340
    GL_COMPRESSED_RGB_S3TC_DXT1_EXT                               = 0x83F0, // decimal value: 33776
    GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                              = 0x83F1, // decimal value: 33777
    GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                              = 0x83F2, // decimal value: 33778
    GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                              = 0x83F3, // decimal value: 33779
    GL_COMPRESSED_RGB                                             = 0x84ED, // decimal value: 34029
    GL_COMPRESSED_RGBA                                            = 0x84EE, // decimal value: 34030
    GL_DEPTH_STENCIL                                              = 0x84F9, // decimal value: 34041
    GL_DEPTH_STENCIL_EXT                                          = 0x84F9, // decimal value: 34041
    GL_DEPTH_STENCIL_NV                                           = 0x84F9, // decimal value: 34041
    GL_RGBA32F                                                    = 0x8814, // decimal value: 34836
    GL_RGBA32F_ARB                                                = 0x8814, // decimal value: 34836
    GL_RGBA16F                                                    = 0x881A, // decimal value: 34842
    GL_RGBA16F_ARB                                                = 0x881A, // decimal value: 34842
    GL_RGB16F                                                     = 0x881B, // decimal value: 34843
    GL_RGB16F_ARB                                                 = 0x881B, // decimal value: 34843
    GL_DEPTH24_STENCIL8                                           = 0x88F0, // decimal value: 35056
    GL_DEPTH24_STENCIL8_EXT                                       = 0x88F0, // decimal value: 35056
    GL_R11F_G11F_B10F                                             = 0x8C3A, // decimal value: 35898
    GL_R11F_G11F_B10F_EXT                                         = 0x8C3A, // decimal value: 35898
    GL_RGB9_E5                                                    = 0x8C3D, // decimal value: 35901
    GL_RGB9_E5_EXT                                                = 0x8C3D, // decimal value: 35901
    GL_SRGB                                                       = 0x8C40, // decimal value: 35904
    GL_SRGB_EXT                                                   = 0x8C40, // decimal value: 35904
    GL_SRGB8                                                      = 0x8C41, // decimal value: 35905
    GL_SRGB8_EXT                                                  = 0x8C41, // decimal value: 35905
    GL_SRGB_ALPHA                                                 = 0x8C42, // decimal value: 35906
    GL_SRGB_ALPHA_EXT                                             = 0x8C42, // decimal value: 35906
    GL_SRGB8_ALPHA8                                               = 0x8C43, // decimal value: 35907
    GL_SRGB8_ALPHA8_EXT                                           = 0x8C43, // decimal value: 35907
    GL_COMPRESSED_SRGB                                            = 0x8C48, // decimal value: 35912
    GL_COMPRESSED_SRGB_ALPHA                                      = 0x8C49, // decimal value: 35913
    GL_COMPRESSED_SRGB_S3TC_DXT1_EXT                              = 0x8C4C, // decimal value: 35916
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT                        = 0x8C4D, // decimal value: 35917
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT                        = 0x8C4E, // decimal value: 35918
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT                        = 0x8C4F, // decimal value: 35919
    GL_DEPTH_COMPONENT32F                                         = 0x8CAC, // decimal value: 36012
    GL_DEPTH32F_STENCIL8                                          = 0x8CAD, // decimal value: 36013
    GL_RGBA32UI                                                   = 0x8D70, // decimal value: 36208
    GL_RGB32UI                                                    = 0x8D71, // decimal value: 36209
    GL_RGBA16UI                                                   = 0x8D76, // decimal value: 36214
    GL_RGB16UI                                                    = 0x8D77, // decimal value: 36215
    GL_RGBA8UI                                                    = 0x8D7C, // decimal value: 36220
    GL_RGB8UI                                                     = 0x8D7D, // decimal value: 36221
    GL_RGBA32I                                                    = 0x8D82, // decimal value: 36226
    GL_RGB32I                                                     = 0x8D83, // decimal value: 36227
    GL_RGBA16I                                                    = 0x8D88, // decimal value: 36232
    GL_RGB16I                                                     = 0x8D89, // decimal value: 36233
    GL_RGBA8I                                                     = 0x8D8E, // decimal value: 36238
    GL_RGB8I                                                      = 0x8D8F, // decimal value: 36239
    GL_DEPTH_COMPONENT32F_NV                                      = 0x8DAB, // decimal value: 36267
    GL_DEPTH32F_STENCIL8_NV                                       = 0x8DAC, // decimal value: 36268
    GL_COMPRESSED_RED_RGTC1                                       = 0x8DBB, // decimal value: 36283
    GL_COMPRESSED_RED_RGTC1_EXT                                   = 0x8DBB, // decimal value: 36283
    GL_COMPRESSED_SIGNED_RED_RGTC1                                = 0x8DBC, // decimal value: 36284
    GL_COMPRESSED_SIGNED_RED_RGTC1_EXT                            = 0x8DBC, // decimal value: 36284
    GL_COMPRESSED_RG_RGTC2                                        = 0x8DBD, // decimal value: 36285
    GL_COMPRESSED_SIGNED_RG_RGTC2                                 = 0x8DBE, // decimal value: 36286
    GL_COMPRESSED_RGBA_BPTC_UNORM                                 = 0x8E8C, // decimal value: 36492
    GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM                           = 0x8E8D, // decimal value: 36493
    GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT                           = 0x8E8E, // decimal value: 36494
    GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT                         = 0x8E8F, // decimal value: 36495
    GL_R8_SNORM                                                   = 0x8F94, // decimal value: 36756
    GL_RG8_SNORM                                                  = 0x8F95, // decimal value: 36757
    GL_RGB8_SNORM                                                 = 0x8F96, // decimal value: 36758
    GL_RGBA8_SNORM                                                = 0x8F97, // decimal value: 36759
    GL_R16_SNORM                                                  = 0x8F98, // decimal value: 36760
    GL_RG16_SNORM                                                 = 0x8F99, // decimal value: 36761
    GL_RGB16_SNORM                                                = 0x8F9A, // decimal value: 36762
    GL_RGB10_A2UI                                                 = 0x906F, // decimal value: 36975
    GL_COMPRESSED_R11_EAC                                         = 0x9270, // decimal value: 37488
    GL_COMPRESSED_SIGNED_R11_EAC                                  = 0x9271, // decimal value: 37489
    GL_COMPRESSED_RG11_EAC                                        = 0x9272, // decimal value: 37490
    GL_COMPRESSED_SIGNED_RG11_EAC                                 = 0x9273, // decimal value: 37491
    GL_COMPRESSED_RGB8_ETC2                                       = 0x9274, // decimal value: 37492
    GL_COMPRESSED_SRGB8_ETC2                                      = 0x9275, // decimal value: 37493
    GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2                   = 0x9276, // decimal value: 37494
    GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2                  = 0x9277, // decimal value: 37495
    GL_COMPRESSED_RGBA8_ETC2_EAC                                  = 0x9278, // decimal value: 37496
    GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC                           = 0x9279, // decimal value: 37497

    // InternalFormatPName

//  GL_SAMPLES                                                    = 0x80A9, // reuse GetFramebufferParameter, decimal value: 32937
    GL_GENERATE_MIPMAP                                            = 0x8191, // decimal value: 33169
    GL_INTERNALFORMAT_SUPPORTED                                   = 0x826F, // decimal value: 33391
    GL_INTERNALFORMAT_PREFERRED                                   = 0x8270, // decimal value: 33392
    GL_INTERNALFORMAT_RED_SIZE                                    = 0x8271, // decimal value: 33393
    GL_INTERNALFORMAT_GREEN_SIZE                                  = 0x8272, // decimal value: 33394
    GL_INTERNALFORMAT_BLUE_SIZE                                   = 0x8273, // decimal value: 33395
    GL_INTERNALFORMAT_ALPHA_SIZE                                  = 0x8274, // decimal value: 33396
    GL_INTERNALFORMAT_DEPTH_SIZE                                  = 0x8275, // decimal value: 33397
    GL_INTERNALFORMAT_STENCIL_SIZE                                = 0x8276, // decimal value: 33398
    GL_INTERNALFORMAT_SHARED_SIZE                                 = 0x8277, // decimal value: 33399
    GL_INTERNALFORMAT_RED_TYPE                                    = 0x8278, // decimal value: 33400
    GL_INTERNALFORMAT_GREEN_TYPE                                  = 0x8279, // decimal value: 33401
    GL_INTERNALFORMAT_BLUE_TYPE                                   = 0x827A, // decimal value: 33402
    GL_INTERNALFORMAT_ALPHA_TYPE                                  = 0x827B, // decimal value: 33403
    GL_INTERNALFORMAT_DEPTH_TYPE                                  = 0x827C, // decimal value: 33404
    GL_INTERNALFORMAT_STENCIL_TYPE                                = 0x827D, // decimal value: 33405
    GL_MAX_WIDTH                                                  = 0x827E, // decimal value: 33406
    GL_MAX_HEIGHT                                                 = 0x827F, // decimal value: 33407
    GL_MAX_DEPTH                                                  = 0x8280, // decimal value: 33408
    GL_MAX_LAYERS                                                 = 0x8281, // decimal value: 33409
    GL_COLOR_COMPONENTS                                           = 0x8283, // decimal value: 33411
    GL_COLOR_RENDERABLE                                           = 0x8286, // decimal value: 33414
    GL_DEPTH_RENDERABLE                                           = 0x8287, // decimal value: 33415
    GL_STENCIL_RENDERABLE                                         = 0x8288, // decimal value: 33416
    GL_FRAMEBUFFER_RENDERABLE                                     = 0x8289, // decimal value: 33417
    GL_FRAMEBUFFER_RENDERABLE_LAYERED                             = 0x828A, // decimal value: 33418
    GL_FRAMEBUFFER_BLEND                                          = 0x828B, // decimal value: 33419
    GL_READ_PIXELS                                                = 0x828C, // decimal value: 33420
    GL_READ_PIXELS_FORMAT                                         = 0x828D, // decimal value: 33421
    GL_READ_PIXELS_TYPE                                           = 0x828E, // decimal value: 33422
    GL_TEXTURE_IMAGE_FORMAT                                       = 0x828F, // decimal value: 33423
    GL_TEXTURE_IMAGE_TYPE                                         = 0x8290, // decimal value: 33424
    GL_GET_TEXTURE_IMAGE_FORMAT                                   = 0x8291, // decimal value: 33425
    GL_GET_TEXTURE_IMAGE_TYPE                                     = 0x8292, // decimal value: 33426
    GL_MIPMAP                                                     = 0x8293, // decimal value: 33427
    GL_AUTO_GENERATE_MIPMAP                                       = 0x8295, // decimal value: 33429
    GL_COLOR_ENCODING                                             = 0x8296, // decimal value: 33430
    GL_SRGB_READ                                                  = 0x8297, // decimal value: 33431
    GL_SRGB_WRITE                                                 = 0x8298, // decimal value: 33432
    GL_FILTER                                                     = 0x829A, // decimal value: 33434
    GL_VERTEX_TEXTURE                                             = 0x829B, // decimal value: 33435
    GL_TESS_CONTROL_TEXTURE                                       = 0x829C, // decimal value: 33436
    GL_TESS_EVALUATION_TEXTURE                                    = 0x829D, // decimal value: 33437
    GL_GEOMETRY_TEXTURE                                           = 0x829E, // decimal value: 33438
    GL_FRAGMENT_TEXTURE                                           = 0x829F, // decimal value: 33439
    GL_COMPUTE_TEXTURE                                            = 0x82A0, // decimal value: 33440
    GL_TEXTURE_SHADOW                                             = 0x82A1, // decimal value: 33441
    GL_TEXTURE_GATHER                                             = 0x82A2, // decimal value: 33442
    GL_TEXTURE_GATHER_SHADOW                                      = 0x82A3, // decimal value: 33443
    GL_SHADER_IMAGE_LOAD                                          = 0x82A4, // decimal value: 33444
    GL_SHADER_IMAGE_STORE                                         = 0x82A5, // decimal value: 33445
    GL_SHADER_IMAGE_ATOMIC                                        = 0x82A6, // decimal value: 33446
    GL_IMAGE_TEXEL_SIZE                                           = 0x82A7, // decimal value: 33447
    GL_IMAGE_COMPATIBILITY_CLASS                                  = 0x82A8, // decimal value: 33448
    GL_IMAGE_PIXEL_FORMAT                                         = 0x82A9, // decimal value: 33449
    GL_IMAGE_PIXEL_TYPE                                           = 0x82AA, // decimal value: 33450
    GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST                        = 0x82AC, // decimal value: 33452
    GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST                      = 0x82AD, // decimal value: 33453
    GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE                       = 0x82AE, // decimal value: 33454
    GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE                     = 0x82AF, // decimal value: 33455
    GL_TEXTURE_COMPRESSED_BLOCK_WIDTH                             = 0x82B1, // decimal value: 33457
    GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT                            = 0x82B2, // decimal value: 33458
    GL_TEXTURE_COMPRESSED_BLOCK_SIZE                              = 0x82B3, // decimal value: 33459
    GL_CLEAR_BUFFER                                               = 0x82B4, // decimal value: 33460
    GL_TEXTURE_VIEW                                               = 0x82B5, // decimal value: 33461
    GL_VIEW_COMPATIBILITY_CLASS                                   = 0x82B6, // decimal value: 33462
    GL_TEXTURE_COMPRESSED                                         = 0x86A1, // decimal value: 34465
    GL_IMAGE_FORMAT_COMPATIBILITY_TYPE                            = 0x90C7, // decimal value: 37063
    GL_CLEAR_TEXTURE                                              = 0x9365, // decimal value: 37733
    GL_NUM_SAMPLE_COUNTS                                          = 0x9380, // decimal value: 37760

    // LightEnvModeSGIX

//  GL_ADD                                                        = 0x0104, // reuse AccumOp, decimal value: 260
    GL_REPLACE                                                    = 0x1E01, // decimal value: 7681
    GL_MODULATE                                                   = 0x2100, // decimal value: 8448

    // LightEnvParameterSGIX

//  GL_LIGHT_ENV_MODE_SGIX                                        = 0x8407, // reuse GetPName, decimal value: 33799

    // LightModelColorControl

    GL_SINGLE_COLOR                                               = 0x81F9, // decimal value: 33273
    GL_SINGLE_COLOR_EXT                                           = 0x81F9, // decimal value: 33273
    GL_SEPARATE_SPECULAR_COLOR                                    = 0x81FA, // decimal value: 33274
    GL_SEPARATE_SPECULAR_COLOR_EXT                                = 0x81FA, // decimal value: 33274

    // LightModelParameter

//  GL_LIGHT_MODEL_LOCAL_VIEWER                                   = 0x0B51, // reuse GetPName, decimal value: 2897
//  GL_LIGHT_MODEL_TWO_SIDE                                       = 0x0B52, // reuse GetPName, decimal value: 2898
//  GL_LIGHT_MODEL_AMBIENT                                        = 0x0B53, // reuse GetPName, decimal value: 2899
//  GL_LIGHT_MODEL_COLOR_CONTROL                                  = 0x81F8, // reuse GetPName, decimal value: 33272
    GL_LIGHT_MODEL_COLOR_CONTROL_EXT                              = 0x81F8, // decimal value: 33272

    // LightName

//  GL_LIGHT0                                                     = 0x4000, // reuse EnableCap, decimal value: 16384
//  GL_LIGHT1                                                     = 0x4001, // reuse EnableCap, decimal value: 16385
//  GL_LIGHT2                                                     = 0x4002, // reuse EnableCap, decimal value: 16386
//  GL_LIGHT3                                                     = 0x4003, // reuse EnableCap, decimal value: 16387
//  GL_LIGHT4                                                     = 0x4004, // reuse EnableCap, decimal value: 16388
//  GL_LIGHT5                                                     = 0x4005, // reuse EnableCap, decimal value: 16389
//  GL_LIGHT6                                                     = 0x4006, // reuse EnableCap, decimal value: 16390
//  GL_LIGHT7                                                     = 0x4007, // reuse EnableCap, decimal value: 16391
//  GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C, // reuse EnableCap, decimal value: 33804
//  GL_FRAGMENT_LIGHT1_SGIX                                       = 0x840D, // reuse EnableCap, decimal value: 33805
//  GL_FRAGMENT_LIGHT2_SGIX                                       = 0x840E, // reuse EnableCap, decimal value: 33806
//  GL_FRAGMENT_LIGHT3_SGIX                                       = 0x840F, // reuse EnableCap, decimal value: 33807
//  GL_FRAGMENT_LIGHT4_SGIX                                       = 0x8410, // reuse EnableCap, decimal value: 33808
//  GL_FRAGMENT_LIGHT5_SGIX                                       = 0x8411, // reuse EnableCap, decimal value: 33809
//  GL_FRAGMENT_LIGHT6_SGIX                                       = 0x8412, // reuse EnableCap, decimal value: 33810
//  GL_FRAGMENT_LIGHT7_SGIX                                       = 0x8413, // reuse EnableCap, decimal value: 33811

    // LightParameter

//  GL_AMBIENT                                                    = 0x1200, // reuse ColorMaterialParameter, decimal value: 4608
//  GL_DIFFUSE                                                    = 0x1201, // reuse ColorMaterialParameter, decimal value: 4609
//  GL_SPECULAR                                                   = 0x1202, // reuse ColorMaterialParameter, decimal value: 4610
    GL_POSITION                                                   = 0x1203, // decimal value: 4611
    GL_SPOT_DIRECTION                                             = 0x1204, // decimal value: 4612
    GL_SPOT_EXPONENT                                              = 0x1205, // decimal value: 4613
    GL_SPOT_CUTOFF                                                = 0x1206, // decimal value: 4614
    GL_CONSTANT_ATTENUATION                                       = 0x1207, // decimal value: 4615
    GL_LINEAR_ATTENUATION                                         = 0x1208, // decimal value: 4616
    GL_QUADRATIC_ATTENUATION                                      = 0x1209, // decimal value: 4617

    // ListMode

    GL_COMPILE                                                    = 0x1300, // decimal value: 4864
    GL_COMPILE_AND_EXECUTE                                        = 0x1301, // decimal value: 4865

    // ListNameType

//  GL_BYTE                                                       = 0x1400, // reuse ColorPointerType, decimal value: 5120
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType, decimal value: 5121
//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType, decimal value: 5123
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse ColorPointerType, decimal value: 5125
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
    GL_2_BYTES                                                    = 0x1407, // decimal value: 5127
    GL_3_BYTES                                                    = 0x1408, // decimal value: 5128
    GL_4_BYTES                                                    = 0x1409, // decimal value: 5129

    // ListParameterName

    GL_LIST_PRIORITY_SGIX                                         = 0x8182, // decimal value: 33154

    // LogicOp

    GL_CLEAR                                                      = 0x1500, // decimal value: 5376
    GL_AND                                                        = 0x1501, // decimal value: 5377
    GL_AND_REVERSE                                                = 0x1502, // decimal value: 5378
    GL_COPY                                                       = 0x1503, // decimal value: 5379
    GL_AND_INVERTED                                               = 0x1504, // decimal value: 5380
    GL_NOOP                                                       = 0x1505, // decimal value: 5381
    GL_XOR                                                        = 0x1506, // decimal value: 5382
    GL_OR                                                         = 0x1507, // decimal value: 5383
    GL_NOR                                                        = 0x1508, // decimal value: 5384
    GL_EQUIV                                                      = 0x1509, // decimal value: 5385
    GL_INVERT                                                     = 0x150A, // decimal value: 5386
    GL_OR_REVERSE                                                 = 0x150B, // decimal value: 5387
    GL_COPY_INVERTED                                              = 0x150C, // decimal value: 5388
    GL_OR_INVERTED                                                = 0x150D, // decimal value: 5389
    GL_NAND                                                       = 0x150E, // decimal value: 5390
    GL_SET                                                        = 0x150F, // decimal value: 5391

    // MapQuery

//  GL_COEFF                                                      = 0x0A00, // reuse GetMapQuery, decimal value: 2560
//  GL_ORDER                                                      = 0x0A01, // reuse GetMapQuery, decimal value: 2561
//  GL_DOMAIN                                                     = 0x0A02, // reuse GetMapQuery, decimal value: 2562

    // MapTarget

//  GL_MAP1_COLOR_4                                               = 0x0D90, // reuse EnableCap, decimal value: 3472
//  GL_MAP1_INDEX                                                 = 0x0D91, // reuse EnableCap, decimal value: 3473
//  GL_MAP1_NORMAL                                                = 0x0D92, // reuse EnableCap, decimal value: 3474
//  GL_MAP1_TEXTURE_COORD_1                                       = 0x0D93, // reuse EnableCap, decimal value: 3475
//  GL_MAP1_TEXTURE_COORD_2                                       = 0x0D94, // reuse EnableCap, decimal value: 3476
//  GL_MAP1_TEXTURE_COORD_3                                       = 0x0D95, // reuse EnableCap, decimal value: 3477
//  GL_MAP1_TEXTURE_COORD_4                                       = 0x0D96, // reuse EnableCap, decimal value: 3478
//  GL_MAP1_VERTEX_3                                              = 0x0D97, // reuse EnableCap, decimal value: 3479
//  GL_MAP1_VERTEX_4                                              = 0x0D98, // reuse EnableCap, decimal value: 3480
//  GL_MAP2_COLOR_4                                               = 0x0DB0, // reuse EnableCap, decimal value: 3504
//  GL_MAP2_INDEX                                                 = 0x0DB1, // reuse EnableCap, decimal value: 3505
//  GL_MAP2_NORMAL                                                = 0x0DB2, // reuse EnableCap, decimal value: 3506
//  GL_MAP2_TEXTURE_COORD_1                                       = 0x0DB3, // reuse EnableCap, decimal value: 3507
//  GL_MAP2_TEXTURE_COORD_2                                       = 0x0DB4, // reuse EnableCap, decimal value: 3508
//  GL_MAP2_TEXTURE_COORD_3                                       = 0x0DB5, // reuse EnableCap, decimal value: 3509
//  GL_MAP2_TEXTURE_COORD_4                                       = 0x0DB6, // reuse EnableCap, decimal value: 3510
//  GL_MAP2_VERTEX_3                                              = 0x0DB7, // reuse EnableCap, decimal value: 3511
//  GL_MAP2_VERTEX_4                                              = 0x0DB8, // reuse EnableCap, decimal value: 3512
//  GL_GEOMETRY_DEFORMATION_SGIX                                  = 0x8194, // reuse FfdTargetSGIX, decimal value: 33172
//  GL_TEXTURE_DEFORMATION_SGIX                                   = 0x8195, // reuse FfdTargetSGIX, decimal value: 33173

    // MapTextureFormatINTEL

    GL_LAYOUT_DEFAULT_INTEL                                       = 0,
    GL_LAYOUT_LINEAR_INTEL                                        = 1,
    GL_LAYOUT_LINEAR_CPU_CACHED_INTEL                             = 2,

    // MaterialFace

//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer, decimal value: 1028
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer, decimal value: 1029
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer, decimal value: 1032

    // MaterialParameter

//  GL_AMBIENT                                                    = 0x1200, // reuse ColorMaterialParameter, decimal value: 4608
//  GL_DIFFUSE                                                    = 0x1201, // reuse ColorMaterialParameter, decimal value: 4609
//  GL_SPECULAR                                                   = 0x1202, // reuse ColorMaterialParameter, decimal value: 4610
//  GL_EMISSION                                                   = 0x1600, // reuse ColorMaterialParameter, decimal value: 5632
    GL_SHININESS                                                  = 0x1601, // decimal value: 5633
//  GL_AMBIENT_AND_DIFFUSE                                        = 0x1602, // reuse ColorMaterialParameter, decimal value: 5634
    GL_COLOR_INDEXES                                              = 0x1603, // decimal value: 5635

    // MatrixMode

    GL_MODELVIEW                                                  = 0x1700, // decimal value: 5888
    GL_MODELVIEW0_EXT                                             = 0x1700, // decimal value: 5888
    GL_PROJECTION                                                 = 0x1701, // decimal value: 5889
    GL_TEXTURE                                                    = 0x1702, // decimal value: 5890

    // MemoryObjectParameterName

    GL_DEDICATED_MEMORY_OBJECT_EXT                                = 0x9581, // decimal value: 38273
    GL_PROTECTED_MEMORY_OBJECT_EXT                                = 0x959B, // decimal value: 38299

    // MeshMode1

    GL_POINT                                                      = 0x1B00, // decimal value: 6912
    GL_LINE                                                       = 0x1B01, // decimal value: 6913

    // MeshMode2

//  GL_POINT                                                      = 0x1B00, // reuse MeshMode1, decimal value: 6912
//  GL_LINE                                                       = 0x1B01, // reuse MeshMode1, decimal value: 6913
    GL_FILL                                                       = 0x1B02, // decimal value: 6914

    // MinmaxTargetEXT

    GL_MINMAX                                                     = 0x802E, // decimal value: 32814
//  GL_MINMAX_EXT                                                 = 0x802E, // reuse EnableCap, decimal value: 32814

    // NormalPointerType

//  GL_BYTE                                                       = 0x1400, // reuse ColorPointerType, decimal value: 5120
//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // ObjectIdentifier

//  GL_TEXTURE                                                    = 0x1702, // reuse MatrixMode, decimal value: 5890
//  GL_VERTEX_ARRAY                                               = 0x8074, // reuse EnableCap, decimal value: 32884
    GL_BUFFER                                                     = 0x82E0, // decimal value: 33504
    GL_SHADER                                                     = 0x82E1, // decimal value: 33505
    GL_PROGRAM                                                    = 0x82E2, // decimal value: 33506
    GL_QUERY                                                      = 0x82E3, // decimal value: 33507
    GL_PROGRAM_PIPELINE                                           = 0x82E4, // decimal value: 33508
    GL_SAMPLER                                                    = 0x82E6, // decimal value: 33510
//  GL_FRAMEBUFFER                                                = 0x8D40, // reuse CheckFramebufferStatusTarget, decimal value: 36160
    GL_RENDERBUFFER                                               = 0x8D41, // decimal value: 36161
//  GL_TRANSFORM_FEEDBACK                                         = 0x8E22, // reuse BindTransformFeedbackTarget, decimal value: 36386

    // PatchParameterName

    GL_PATCH_VERTICES                                             = 0x8E72, // decimal value: 36466
    GL_PATCH_DEFAULT_INNER_LEVEL                                  = 0x8E73, // decimal value: 36467
    GL_PATCH_DEFAULT_OUTER_LEVEL                                  = 0x8E74, // decimal value: 36468

    // PathColor

    GL_PRIMARY_COLOR_NV                                           = 0x852C, // decimal value: 34092
    GL_SECONDARY_COLOR_NV                                         = 0x852D, // decimal value: 34093
    GL_PRIMARY_COLOR                                              = 0x8577, // decimal value: 34167

    // PathCoverMode

    GL_PATH_FILL_COVER_MODE_NV                                    = 0x9082, // decimal value: 36994
    GL_CONVEX_HULL_NV                                             = 0x908B, // decimal value: 37003
    GL_BOUNDING_BOX_NV                                            = 0x908D, // decimal value: 37005
    GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV                          = 0x909C, // decimal value: 37020

    // PathElementType

    GL_UTF8_NV                                                    = 0x909A, // decimal value: 37018
    GL_UTF16_NV                                                   = 0x909B, // decimal value: 37019

    // PathFillMode

//  GL_INVERT                                                     = 0x150A, // reuse LogicOp, decimal value: 5386
    GL_PATH_FILL_MODE_NV                                          = 0x9080, // decimal value: 36992
    GL_COUNT_UP_NV                                                = 0x9088, // decimal value: 37000
    GL_COUNT_DOWN_NV                                              = 0x9089, // decimal value: 37001

    // PathFontStyle

//  GL_NONE                                                       = 0, // reuse ColorBuffer

    // PathFontTarget

    GL_STANDARD_FONT_NAME_NV                                      = 0x9072, // decimal value: 36978
    GL_SYSTEM_FONT_NAME_NV                                        = 0x9073, // decimal value: 36979
    GL_FILE_NAME_NV                                               = 0x9074, // decimal value: 36980

    // PathGenMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_EYE_LINEAR                                                 = 0x2400, // decimal value: 9216
    GL_OBJECT_LINEAR                                              = 0x2401, // decimal value: 9217
    GL_CONSTANT                                                   = 0x8576, // decimal value: 34166
    GL_PATH_OBJECT_BOUNDING_BOX_NV                                = 0x908A, // decimal value: 37002

    // PathHandleMissingGlyphs

    GL_SKIP_MISSING_GLYPH_NV                                      = 0x90A9, // decimal value: 37033
    GL_USE_MISSING_GLYPH_NV                                       = 0x90AA, // decimal value: 37034

    // PathListMode

    GL_ACCUM_ADJACENT_PAIRS_NV                                    = 0x90AD, // decimal value: 37037
    GL_ADJACENT_PAIRS_NV                                          = 0x90AE, // decimal value: 37038
    GL_FIRST_TO_REST_NV                                           = 0x90AF, // decimal value: 37039

    // PathParameter

    GL_PATH_STROKE_WIDTH_NV                                       = 0x9075, // decimal value: 36981
    GL_PATH_END_CAPS_NV                                           = 0x9076, // decimal value: 36982
    GL_PATH_INITIAL_END_CAP_NV                                    = 0x9077, // decimal value: 36983
    GL_PATH_TERMINAL_END_CAP_NV                                   = 0x9078, // decimal value: 36984
    GL_PATH_JOIN_STYLE_NV                                         = 0x9079, // decimal value: 36985
    GL_PATH_MITER_LIMIT_NV                                        = 0x907A, // decimal value: 36986
    GL_PATH_DASH_CAPS_NV                                          = 0x907B, // decimal value: 36987
    GL_PATH_INITIAL_DASH_CAP_NV                                   = 0x907C, // decimal value: 36988
    GL_PATH_TERMINAL_DASH_CAP_NV                                  = 0x907D, // decimal value: 36989
    GL_PATH_DASH_OFFSET_NV                                        = 0x907E, // decimal value: 36990
    GL_PATH_CLIENT_LENGTH_NV                                      = 0x907F, // decimal value: 36991
//  GL_PATH_FILL_MODE_NV                                          = 0x9080, // reuse PathFillMode, decimal value: 36992
    GL_PATH_FILL_MASK_NV                                          = 0x9081, // decimal value: 36993
//  GL_PATH_FILL_COVER_MODE_NV                                    = 0x9082, // reuse PathCoverMode, decimal value: 36994
    GL_PATH_STROKE_COVER_MODE_NV                                  = 0x9083, // decimal value: 36995
    GL_PATH_STROKE_MASK_NV                                        = 0x9084, // decimal value: 36996
//  GL_PATH_OBJECT_BOUNDING_BOX_NV                                = 0x908A, // reuse PathGenMode, decimal value: 37002
    GL_PATH_COMMAND_COUNT_NV                                      = 0x909D, // decimal value: 37021
    GL_PATH_COORD_COUNT_NV                                        = 0x909E, // decimal value: 37022
    GL_PATH_DASH_ARRAY_COUNT_NV                                   = 0x909F, // decimal value: 37023
    GL_PATH_COMPUTED_LENGTH_NV                                    = 0x90A0, // decimal value: 37024
    GL_PATH_FILL_BOUNDING_BOX_NV                                  = 0x90A1, // decimal value: 37025
    GL_PATH_STROKE_BOUNDING_BOX_NV                                = 0x90A2, // decimal value: 37026
    GL_PATH_DASH_OFFSET_RESET_NV                                  = 0x90B4, // decimal value: 37044

    // PathStringFormat

    GL_PATH_FORMAT_SVG_NV                                         = 0x9070, // decimal value: 36976
    GL_PATH_FORMAT_PS_NV                                          = 0x9071, // decimal value: 36977

    // PathTransformType

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_TRANSLATE_X_NV                                             = 0x908E, // decimal value: 37006
    GL_TRANSLATE_Y_NV                                             = 0x908F, // decimal value: 37007
    GL_TRANSLATE_2D_NV                                            = 0x9090, // decimal value: 37008
    GL_TRANSLATE_3D_NV                                            = 0x9091, // decimal value: 37009
    GL_AFFINE_2D_NV                                               = 0x9092, // decimal value: 37010
    GL_AFFINE_3D_NV                                               = 0x9094, // decimal value: 37012
    GL_TRANSPOSE_AFFINE_2D_NV                                     = 0x9096, // decimal value: 37014
    GL_TRANSPOSE_AFFINE_3D_NV                                     = 0x9098, // decimal value: 37016

    // PipelineParameterName

    GL_ACTIVE_PROGRAM                                             = 0x8259, // decimal value: 33369
    GL_FRAGMENT_SHADER                                            = 0x8B30, // decimal value: 35632
    GL_VERTEX_SHADER                                              = 0x8B31, // decimal value: 35633
    GL_INFO_LOG_LENGTH                                            = 0x8B84, // decimal value: 35716
    GL_GEOMETRY_SHADER                                            = 0x8DD9, // decimal value: 36313
    GL_TESS_EVALUATION_SHADER                                     = 0x8E87, // decimal value: 36487
    GL_TESS_CONTROL_SHADER                                        = 0x8E88, // decimal value: 36488

    // PixelCopyType

//  GL_COLOR                                                      = 0x1800, // reuse Buffer, decimal value: 6144
//  GL_DEPTH                                                      = 0x1801, // reuse Buffer, decimal value: 6145
//  GL_STENCIL                                                    = 0x1802, // reuse Buffer, decimal value: 6146

    // PixelFormat

//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType, decimal value: 5123
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse ColorPointerType, decimal value: 5125
    GL_COLOR_INDEX                                                = 0x1900, // decimal value: 6400
    GL_STENCIL_INDEX                                              = 0x1901, // decimal value: 6401
//  GL_DEPTH_COMPONENT                                            = 0x1902, // reuse InternalFormat, decimal value: 6402
//  GL_RED                                                        = 0x1903, // reuse InternalFormat, decimal value: 6403
    GL_GREEN                                                      = 0x1904, // decimal value: 6404
    GL_BLUE                                                       = 0x1905, // decimal value: 6405
    GL_ALPHA                                                      = 0x1906, // decimal value: 6406
//  GL_RGB                                                        = 0x1907, // reuse InternalFormat, decimal value: 6407
//  GL_RGBA                                                       = 0x1908, // reuse InternalFormat, decimal value: 6408
    GL_LUMINANCE                                                  = 0x1909, // decimal value: 6409
    GL_LUMINANCE_ALPHA                                            = 0x190A, // decimal value: 6410
    GL_ABGR_EXT                                                   = 0x8000, // decimal value: 32768
    GL_CMYK_EXT                                                   = 0x800C, // decimal value: 32780
    GL_CMYKA_EXT                                                  = 0x800D, // decimal value: 32781
    GL_YCRCB_422_SGIX                                             = 0x81BB, // decimal value: 33211
    GL_YCRCB_444_SGIX                                             = 0x81BC, // decimal value: 33212

    // PixelMap

//  GL_PIXEL_MAP_I_TO_I                                           = 0x0C70, // reuse GetPixelMap, decimal value: 3184
//  GL_PIXEL_MAP_S_TO_S                                           = 0x0C71, // reuse GetPixelMap, decimal value: 3185
//  GL_PIXEL_MAP_I_TO_R                                           = 0x0C72, // reuse GetPixelMap, decimal value: 3186
//  GL_PIXEL_MAP_I_TO_G                                           = 0x0C73, // reuse GetPixelMap, decimal value: 3187
//  GL_PIXEL_MAP_I_TO_B                                           = 0x0C74, // reuse GetPixelMap, decimal value: 3188
//  GL_PIXEL_MAP_I_TO_A                                           = 0x0C75, // reuse GetPixelMap, decimal value: 3189
//  GL_PIXEL_MAP_R_TO_R                                           = 0x0C76, // reuse GetPixelMap, decimal value: 3190
//  GL_PIXEL_MAP_G_TO_G                                           = 0x0C77, // reuse GetPixelMap, decimal value: 3191
//  GL_PIXEL_MAP_B_TO_B                                           = 0x0C78, // reuse GetPixelMap, decimal value: 3192
//  GL_PIXEL_MAP_A_TO_A                                           = 0x0C79, // reuse GetPixelMap, decimal value: 3193

    // PixelStoreParameter

//  GL_UNPACK_SWAP_BYTES                                          = 0x0CF0, // reuse GetPName, decimal value: 3312
//  GL_UNPACK_LSB_FIRST                                           = 0x0CF1, // reuse GetPName, decimal value: 3313
//  GL_UNPACK_ROW_LENGTH                                          = 0x0CF2, // reuse GetPName, decimal value: 3314
//  GL_UNPACK_SKIP_ROWS                                           = 0x0CF3, // reuse GetPName, decimal value: 3315
//  GL_UNPACK_SKIP_PIXELS                                         = 0x0CF4, // reuse GetPName, decimal value: 3316
//  GL_UNPACK_ALIGNMENT                                           = 0x0CF5, // reuse GetPName, decimal value: 3317
//  GL_PACK_SWAP_BYTES                                            = 0x0D00, // reuse GetPName, decimal value: 3328
//  GL_PACK_LSB_FIRST                                             = 0x0D01, // reuse GetPName, decimal value: 3329
//  GL_PACK_ROW_LENGTH                                            = 0x0D02, // reuse GetPName, decimal value: 3330
//  GL_PACK_SKIP_ROWS                                             = 0x0D03, // reuse GetPName, decimal value: 3331
//  GL_PACK_SKIP_PIXELS                                           = 0x0D04, // reuse GetPName, decimal value: 3332
//  GL_PACK_ALIGNMENT                                             = 0x0D05, // reuse GetPName, decimal value: 3333
    GL_PACK_SKIP_IMAGES                                           = 0x806B, // decimal value: 32875
//  GL_PACK_SKIP_IMAGES_EXT                                       = 0x806B, // reuse GetPName, decimal value: 32875
    GL_PACK_IMAGE_HEIGHT                                          = 0x806C, // decimal value: 32876
//  GL_PACK_IMAGE_HEIGHT_EXT                                      = 0x806C, // reuse GetPName, decimal value: 32876
    GL_UNPACK_SKIP_IMAGES                                         = 0x806D, // decimal value: 32877
//  GL_UNPACK_SKIP_IMAGES_EXT                                     = 0x806D, // reuse GetPName, decimal value: 32877
    GL_UNPACK_IMAGE_HEIGHT                                        = 0x806E, // decimal value: 32878
//  GL_UNPACK_IMAGE_HEIGHT_EXT                                    = 0x806E, // reuse GetPName, decimal value: 32878
//  GL_PACK_SKIP_VOLUMES_SGIS                                     = 0x8130, // reuse GetPName, decimal value: 33072
//  GL_PACK_IMAGE_DEPTH_SGIS                                      = 0x8131, // reuse GetPName, decimal value: 33073
//  GL_UNPACK_SKIP_VOLUMES_SGIS                                   = 0x8132, // reuse GetPName, decimal value: 33074
//  GL_UNPACK_IMAGE_DEPTH_SGIS                                    = 0x8133, // reuse GetPName, decimal value: 33075
//  GL_PIXEL_TILE_WIDTH_SGIX                                      = 0x8140, // reuse GetPName, decimal value: 33088
//  GL_PIXEL_TILE_HEIGHT_SGIX                                     = 0x8141, // reuse GetPName, decimal value: 33089
//  GL_PIXEL_TILE_GRID_WIDTH_SGIX                                 = 0x8142, // reuse GetPName, decimal value: 33090
//  GL_PIXEL_TILE_GRID_HEIGHT_SGIX                                = 0x8143, // reuse GetPName, decimal value: 33091
//  GL_PIXEL_TILE_GRID_DEPTH_SGIX                                 = 0x8144, // reuse GetPName, decimal value: 33092
//  GL_PIXEL_TILE_CACHE_SIZE_SGIX                                 = 0x8145, // reuse GetPName, decimal value: 33093
//  GL_PACK_RESAMPLE_SGIX                                         = 0x842E, // reuse GetPName, decimal value: 33838
//  GL_UNPACK_RESAMPLE_SGIX                                       = 0x842F, // reuse GetPName, decimal value: 33839
//  GL_PACK_SUBSAMPLE_RATE_SGIX                                   = 0x85A0, // reuse GetPName, decimal value: 34208
//  GL_UNPACK_SUBSAMPLE_RATE_SGIX                                 = 0x85A1, // reuse GetPName, decimal value: 34209
    GL_PACK_RESAMPLE_OML                                          = 0x8984, // decimal value: 35204
    GL_UNPACK_RESAMPLE_OML                                        = 0x8985, // decimal value: 35205

    // PixelStoreResampleMode

    GL_RESAMPLE_DECIMATE_SGIX                                     = 0x8430, // decimal value: 33840
    GL_RESAMPLE_REPLICATE_SGIX                                    = 0x8433, // decimal value: 33843
    GL_RESAMPLE_ZERO_FILL_SGIX                                    = 0x8434, // decimal value: 33844

    // PixelStoreSubsampleRate

    GL_PIXEL_SUBSAMPLE_4444_SGIX                                  = 0x85A2, // decimal value: 34210
    GL_PIXEL_SUBSAMPLE_2424_SGIX                                  = 0x85A3, // decimal value: 34211
    GL_PIXEL_SUBSAMPLE_4242_SGIX                                  = 0x85A4, // decimal value: 34212

    // PixelTexGenMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
//  GL_RGB                                                        = 0x1907, // reuse InternalFormat, decimal value: 6407
//  GL_RGBA                                                       = 0x1908, // reuse InternalFormat, decimal value: 6408
//  GL_LUMINANCE                                                  = 0x1909, // reuse PixelFormat, decimal value: 6409
//  GL_LUMINANCE_ALPHA                                            = 0x190A, // reuse PixelFormat, decimal value: 6410

    // PixelTexGenParameterNameSGIS

    GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS                             = 0x8354, // decimal value: 33620
    GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS                           = 0x8355, // decimal value: 33621

    // PixelTransferParameter

//  GL_MAP_COLOR                                                  = 0x0D10, // reuse GetPName, decimal value: 3344
//  GL_MAP_STENCIL                                                = 0x0D11, // reuse GetPName, decimal value: 3345
//  GL_INDEX_SHIFT                                                = 0x0D12, // reuse GetPName, decimal value: 3346
//  GL_INDEX_OFFSET                                               = 0x0D13, // reuse GetPName, decimal value: 3347
//  GL_RED_SCALE                                                  = 0x0D14, // reuse GetPName, decimal value: 3348
//  GL_RED_BIAS                                                   = 0x0D15, // reuse GetPName, decimal value: 3349
//  GL_GREEN_SCALE                                                = 0x0D18, // reuse GetPName, decimal value: 3352
//  GL_GREEN_BIAS                                                 = 0x0D19, // reuse GetPName, decimal value: 3353
//  GL_BLUE_SCALE                                                 = 0x0D1A, // reuse GetPName, decimal value: 3354
//  GL_BLUE_BIAS                                                  = 0x0D1B, // reuse GetPName, decimal value: 3355
//  GL_ALPHA_SCALE                                                = 0x0D1C, // reuse GetPName, decimal value: 3356
//  GL_ALPHA_BIAS                                                 = 0x0D1D, // reuse GetPName, decimal value: 3357
//  GL_DEPTH_SCALE                                                = 0x0D1E, // reuse GetPName, decimal value: 3358
//  GL_DEPTH_BIAS                                                 = 0x0D1F, // reuse GetPName, decimal value: 3359
    GL_POST_CONVOLUTION_RED_SCALE                                 = 0x801C, // decimal value: 32796
//  GL_POST_CONVOLUTION_RED_SCALE_EXT                             = 0x801C, // reuse GetPName, decimal value: 32796
    GL_POST_CONVOLUTION_GREEN_SCALE                               = 0x801D, // decimal value: 32797
//  GL_POST_CONVOLUTION_GREEN_SCALE_EXT                           = 0x801D, // reuse GetPName, decimal value: 32797
    GL_POST_CONVOLUTION_BLUE_SCALE                                = 0x801E, // decimal value: 32798
//  GL_POST_CONVOLUTION_BLUE_SCALE_EXT                            = 0x801E, // reuse GetPName, decimal value: 32798
    GL_POST_CONVOLUTION_ALPHA_SCALE                               = 0x801F, // decimal value: 32799
//  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT                           = 0x801F, // reuse GetPName, decimal value: 32799
    GL_POST_CONVOLUTION_RED_BIAS                                  = 0x8020, // decimal value: 32800
//  GL_POST_CONVOLUTION_RED_BIAS_EXT                              = 0x8020, // reuse GetPName, decimal value: 32800
    GL_POST_CONVOLUTION_GREEN_BIAS                                = 0x8021, // decimal value: 32801
//  GL_POST_CONVOLUTION_GREEN_BIAS_EXT                            = 0x8021, // reuse GetPName, decimal value: 32801
    GL_POST_CONVOLUTION_BLUE_BIAS                                 = 0x8022, // decimal value: 32802
//  GL_POST_CONVOLUTION_BLUE_BIAS_EXT                             = 0x8022, // reuse GetPName, decimal value: 32802
    GL_POST_CONVOLUTION_ALPHA_BIAS                                = 0x8023, // decimal value: 32803
//  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT                            = 0x8023, // reuse GetPName, decimal value: 32803
    GL_POST_COLOR_MATRIX_RED_SCALE                                = 0x80B4, // decimal value: 32948
//  GL_POST_COLOR_MATRIX_RED_SCALE_SGI                            = 0x80B4, // reuse GetPName, decimal value: 32948
    GL_POST_COLOR_MATRIX_GREEN_SCALE                              = 0x80B5, // decimal value: 32949
//  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI                          = 0x80B5, // reuse GetPName, decimal value: 32949
    GL_POST_COLOR_MATRIX_BLUE_SCALE                               = 0x80B6, // decimal value: 32950
//  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI                           = 0x80B6, // reuse GetPName, decimal value: 32950
    GL_POST_COLOR_MATRIX_ALPHA_SCALE                              = 0x80B7, // decimal value: 32951
//  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI                          = 0x80B7, // reuse GetPName, decimal value: 32951
    GL_POST_COLOR_MATRIX_RED_BIAS                                 = 0x80B8, // decimal value: 32952
//  GL_POST_COLOR_MATRIX_RED_BIAS_SGI                             = 0x80B8, // reuse GetPName, decimal value: 32952
    GL_POST_COLOR_MATRIX_GREEN_BIAS                               = 0x80B9, // decimal value: 32953
//  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI                           = 0x80B9, // reuse GetPName, decimal value: 32953
    GL_POST_COLOR_MATRIX_BLUE_BIAS                                = 0x80BA, // decimal value: 32954
//  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI                            = 0x80BA, // reuse GetPName, decimal value: 32954
    GL_POST_COLOR_MATRIX_ALPHA_BIAS                               = 0x80BB, // decimal value: 32955
//  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI                           = 0x80BB, // reuse GetPName, decimal value: 32955

    // PixelType

//  GL_BYTE                                                       = 0x1400, // reuse ColorPointerType, decimal value: 5120
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType, decimal value: 5121
//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType, decimal value: 5123
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse ColorPointerType, decimal value: 5125
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
    GL_BITMAP                                                     = 0x1A00, // decimal value: 6656
    GL_UNSIGNED_BYTE_3_3_2                                        = 0x8032, // decimal value: 32818
    GL_UNSIGNED_BYTE_3_3_2_EXT                                    = 0x8032, // decimal value: 32818
    GL_UNSIGNED_SHORT_4_4_4_4                                     = 0x8033, // decimal value: 32819
    GL_UNSIGNED_SHORT_4_4_4_4_EXT                                 = 0x8033, // decimal value: 32819
    GL_UNSIGNED_SHORT_5_5_5_1                                     = 0x8034, // decimal value: 32820
    GL_UNSIGNED_SHORT_5_5_5_1_EXT                                 = 0x8034, // decimal value: 32820
    GL_UNSIGNED_INT_8_8_8_8                                       = 0x8035, // decimal value: 32821
    GL_UNSIGNED_INT_8_8_8_8_EXT                                   = 0x8035, // decimal value: 32821
    GL_UNSIGNED_INT_10_10_10_2                                    = 0x8036, // decimal value: 32822
    GL_UNSIGNED_INT_10_10_10_2_EXT                                = 0x8036, // decimal value: 32822

    // PointParameterNameSGIS

    GL_POINT_SIZE_MIN                                             = 0x8126, // decimal value: 33062
    GL_POINT_SIZE_MIN_ARB                                         = 0x8126, // decimal value: 33062
    GL_POINT_SIZE_MIN_EXT                                         = 0x8126, // decimal value: 33062
//  GL_POINT_SIZE_MIN_SGIS                                        = 0x8126, // reuse GetPName, decimal value: 33062
    GL_POINT_SIZE_MAX                                             = 0x8127, // decimal value: 33063
    GL_POINT_SIZE_MAX_ARB                                         = 0x8127, // decimal value: 33063
    GL_POINT_SIZE_MAX_EXT                                         = 0x8127, // decimal value: 33063
//  GL_POINT_SIZE_MAX_SGIS                                        = 0x8127, // reuse GetPName, decimal value: 33063
    GL_POINT_FADE_THRESHOLD_SIZE                                  = 0x8128, // decimal value: 33064
    GL_POINT_FADE_THRESHOLD_SIZE_ARB                              = 0x8128, // decimal value: 33064
    GL_POINT_FADE_THRESHOLD_SIZE_EXT                              = 0x8128, // decimal value: 33064
//  GL_POINT_FADE_THRESHOLD_SIZE_SGIS                             = 0x8128, // reuse GetPName, decimal value: 33064
    GL_DISTANCE_ATTENUATION_EXT                                   = 0x8129, // decimal value: 33065
//  GL_DISTANCE_ATTENUATION_SGIS                                  = 0x8129, // reuse GetPName, decimal value: 33065
    GL_POINT_DISTANCE_ATTENUATION                                 = 0x8129, // decimal value: 33065
    GL_POINT_DISTANCE_ATTENUATION_ARB                             = 0x8129, // decimal value: 33065

    // PolygonMode

//  GL_POINT                                                      = 0x1B00, // reuse MeshMode1, decimal value: 6912
//  GL_LINE                                                       = 0x1B01, // reuse MeshMode1, decimal value: 6913
//  GL_FILL                                                       = 0x1B02, // reuse MeshMode2, decimal value: 6914

    // PrecisionType

    GL_LOW_FLOAT                                                  = 0x8DF0, // decimal value: 36336
    GL_MEDIUM_FLOAT                                               = 0x8DF1, // decimal value: 36337
    GL_HIGH_FLOAT                                                 = 0x8DF2, // decimal value: 36338
    GL_LOW_INT                                                    = 0x8DF3, // decimal value: 36339
    GL_MEDIUM_INT                                                 = 0x8DF4, // decimal value: 36340
    GL_HIGH_INT                                                   = 0x8DF5, // decimal value: 36341

    // PrimitiveType

    GL_POINTS                                                     = 0x0000,
    GL_LINES                                                      = 0x0001, // decimal value: 1
    GL_LINE_LOOP                                                  = 0x0002, // decimal value: 2
    GL_LINE_STRIP                                                 = 0x0003, // decimal value: 3
    GL_TRIANGLES                                                  = 0x0004, // decimal value: 4
    GL_TRIANGLE_STRIP                                             = 0x0005, // decimal value: 5
    GL_TRIANGLE_FAN                                               = 0x0006, // decimal value: 6
    GL_QUADS                                                      = 0x0007, // decimal value: 7
    GL_QUAD_STRIP                                                 = 0x0008, // decimal value: 8
    GL_POLYGON                                                    = 0x0009, // decimal value: 9
    GL_LINES_ADJACENCY                                            = 0x000A, // decimal value: 10
    GL_LINES_ADJACENCY_ARB                                        = 0x000A, // decimal value: 10
    GL_LINES_ADJACENCY_EXT                                        = 0x000A, // decimal value: 10
    GL_LINE_STRIP_ADJACENCY                                       = 0x000B, // decimal value: 11
    GL_LINE_STRIP_ADJACENCY_ARB                                   = 0x000B, // decimal value: 11
    GL_LINE_STRIP_ADJACENCY_EXT                                   = 0x000B, // decimal value: 11
    GL_TRIANGLES_ADJACENCY                                        = 0x000C, // decimal value: 12
    GL_TRIANGLES_ADJACENCY_ARB                                    = 0x000C, // decimal value: 12
    GL_TRIANGLES_ADJACENCY_EXT                                    = 0x000C, // decimal value: 12
    GL_TRIANGLE_STRIP_ADJACENCY                                   = 0x000D, // decimal value: 13
    GL_TRIANGLE_STRIP_ADJACENCY_ARB                               = 0x000D, // decimal value: 13
    GL_TRIANGLE_STRIP_ADJACENCY_EXT                               = 0x000D, // decimal value: 13
    GL_PATCHES                                                    = 0x000E, // decimal value: 14

    // ProgramInterface

//  GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // reuse BufferStorageTarget, decimal value: 35982
    GL_UNIFORM                                                    = 0x92E1, // decimal value: 37601
    GL_UNIFORM_BLOCK                                              = 0x92E2, // decimal value: 37602
    GL_PROGRAM_INPUT                                              = 0x92E3, // decimal value: 37603
    GL_PROGRAM_OUTPUT                                             = 0x92E4, // decimal value: 37604
    GL_BUFFER_VARIABLE                                            = 0x92E5, // decimal value: 37605
    GL_SHADER_STORAGE_BLOCK                                       = 0x92E6, // decimal value: 37606
    GL_VERTEX_SUBROUTINE                                          = 0x92E8, // decimal value: 37608
    GL_TESS_CONTROL_SUBROUTINE                                    = 0x92E9, // decimal value: 37609
    GL_TESS_EVALUATION_SUBROUTINE                                 = 0x92EA, // decimal value: 37610
    GL_GEOMETRY_SUBROUTINE                                        = 0x92EB, // decimal value: 37611
    GL_FRAGMENT_SUBROUTINE                                        = 0x92EC, // decimal value: 37612
    GL_COMPUTE_SUBROUTINE                                         = 0x92ED, // decimal value: 37613
    GL_VERTEX_SUBROUTINE_UNIFORM                                  = 0x92EE, // decimal value: 37614
    GL_TESS_CONTROL_SUBROUTINE_UNIFORM                            = 0x92EF, // decimal value: 37615
    GL_TESS_EVALUATION_SUBROUTINE_UNIFORM                         = 0x92F0, // decimal value: 37616
    GL_GEOMETRY_SUBROUTINE_UNIFORM                                = 0x92F1, // decimal value: 37617
    GL_FRAGMENT_SUBROUTINE_UNIFORM                                = 0x92F2, // decimal value: 37618
    GL_COMPUTE_SUBROUTINE_UNIFORM                                 = 0x92F3, // decimal value: 37619
    GL_TRANSFORM_FEEDBACK_VARYING                                 = 0x92F4, // decimal value: 37620

    // ProgramInterfacePName

    GL_ACTIVE_RESOURCES                                           = 0x92F5, // decimal value: 37621
    GL_MAX_NAME_LENGTH                                            = 0x92F6, // decimal value: 37622
    GL_MAX_NUM_ACTIVE_VARIABLES                                   = 0x92F7, // decimal value: 37623
    GL_MAX_NUM_COMPATIBLE_SUBROUTINES                             = 0x92F8, // decimal value: 37624

    // ProgramParameterPName

//  GL_PROGRAM_BINARY_RETRIEVABLE_HINT                            = 0x8257, // reuse HintTarget, decimal value: 33367
    GL_PROGRAM_SEPARABLE                                          = 0x8258, // decimal value: 33368

    // ProgramPropertyARB

    GL_COMPUTE_WORK_GROUP_SIZE                                    = 0x8267, // decimal value: 33383
    GL_PROGRAM_BINARY_LENGTH                                      = 0x8741, // decimal value: 34625
    GL_GEOMETRY_VERTICES_OUT                                      = 0x8916, // decimal value: 35094
    GL_GEOMETRY_INPUT_TYPE                                        = 0x8917, // decimal value: 35095
    GL_GEOMETRY_OUTPUT_TYPE                                       = 0x8918, // decimal value: 35096
    GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH                       = 0x8A35, // decimal value: 35381
    GL_ACTIVE_UNIFORM_BLOCKS                                      = 0x8A36, // decimal value: 35382
    GL_DELETE_STATUS                                              = 0x8B80, // decimal value: 35712
    GL_LINK_STATUS                                                = 0x8B82, // decimal value: 35714
    GL_VALIDATE_STATUS                                            = 0x8B83, // decimal value: 35715
//  GL_INFO_LOG_LENGTH                                            = 0x8B84, // reuse PipelineParameterName, decimal value: 35716
    GL_ATTACHED_SHADERS                                           = 0x8B85, // decimal value: 35717
    GL_ACTIVE_UNIFORMS                                            = 0x8B86, // decimal value: 35718
    GL_ACTIVE_UNIFORM_MAX_LENGTH                                  = 0x8B87, // decimal value: 35719
    GL_ACTIVE_ATTRIBUTES                                          = 0x8B89, // decimal value: 35721
    GL_ACTIVE_ATTRIBUTE_MAX_LENGTH                                = 0x8B8A, // decimal value: 35722
    GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH                      = 0x8C76, // decimal value: 35958
    GL_TRANSFORM_FEEDBACK_BUFFER_MODE                             = 0x8C7F, // decimal value: 35967
    GL_TRANSFORM_FEEDBACK_VARYINGS                                = 0x8C83, // decimal value: 35971
    GL_ACTIVE_ATOMIC_COUNTER_BUFFERS                              = 0x92D9, // decimal value: 37593

    // ProgramStagePName

    GL_ACTIVE_SUBROUTINES                                         = 0x8DE5, // decimal value: 36325
    GL_ACTIVE_SUBROUTINE_UNIFORMS                                 = 0x8DE6, // decimal value: 36326
    GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS                        = 0x8E47, // decimal value: 36423
    GL_ACTIVE_SUBROUTINE_MAX_LENGTH                               = 0x8E48, // decimal value: 36424
    GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH                       = 0x8E49, // decimal value: 36425

    // QueryObjectParameterName

    GL_QUERY_TARGET                                               = 0x82EA, // decimal value: 33514
    GL_QUERY_RESULT                                               = 0x8866, // decimal value: 34918
    GL_QUERY_RESULT_AVAILABLE                                     = 0x8867, // decimal value: 34919
    GL_QUERY_RESULT_NO_WAIT                                       = 0x9194, // decimal value: 37268

    // QueryParameterName

    GL_QUERY_COUNTER_BITS                                         = 0x8864, // decimal value: 34916
    GL_CURRENT_QUERY                                              = 0x8865, // decimal value: 34917

    // QueryTarget

    GL_TIME_ELAPSED                                               = 0x88BF, // decimal value: 35007
    GL_SAMPLES_PASSED                                             = 0x8914, // decimal value: 35092
    GL_ANY_SAMPLES_PASSED                                         = 0x8C2F, // decimal value: 35887
    GL_PRIMITIVES_GENERATED                                       = 0x8C87, // decimal value: 35975
    GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN                      = 0x8C88, // decimal value: 35976
    GL_ANY_SAMPLES_PASSED_CONSERVATIVE                            = 0x8D6A, // decimal value: 36202

    // ReadBufferMode

//  GL_FRONT_LEFT                                                 = 0x0400, // reuse ColorBuffer, decimal value: 1024
//  GL_FRONT_RIGHT                                                = 0x0401, // reuse ColorBuffer, decimal value: 1025
//  GL_BACK_LEFT                                                  = 0x0402, // reuse ColorBuffer, decimal value: 1026
//  GL_BACK_RIGHT                                                 = 0x0403, // reuse ColorBuffer, decimal value: 1027
//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer, decimal value: 1028
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer, decimal value: 1029
//  GL_LEFT                                                       = 0x0406, // reuse ColorBuffer, decimal value: 1030
//  GL_RIGHT                                                      = 0x0407, // reuse ColorBuffer, decimal value: 1031
//  GL_AUX0                                                       = 0x0409, // reuse DrawBufferMode, decimal value: 1033
//  GL_AUX1                                                       = 0x040A, // reuse DrawBufferMode, decimal value: 1034
//  GL_AUX2                                                       = 0x040B, // reuse DrawBufferMode, decimal value: 1035
//  GL_AUX3                                                       = 0x040C, // reuse DrawBufferMode, decimal value: 1036

    // RenderbufferParameterName

    GL_RENDERBUFFER_SAMPLES                                       = 0x8CAB, // decimal value: 36011
    GL_RENDERBUFFER_WIDTH                                         = 0x8D42, // decimal value: 36162
    GL_RENDERBUFFER_HEIGHT                                        = 0x8D43, // decimal value: 36163
    GL_RENDERBUFFER_INTERNAL_FORMAT                               = 0x8D44, // decimal value: 36164
    GL_RENDERBUFFER_RED_SIZE                                      = 0x8D50, // decimal value: 36176
    GL_RENDERBUFFER_GREEN_SIZE                                    = 0x8D51, // decimal value: 36177
    GL_RENDERBUFFER_BLUE_SIZE                                     = 0x8D52, // decimal value: 36178
    GL_RENDERBUFFER_ALPHA_SIZE                                    = 0x8D53, // decimal value: 36179
    GL_RENDERBUFFER_DEPTH_SIZE                                    = 0x8D54, // decimal value: 36180
    GL_RENDERBUFFER_STENCIL_SIZE                                  = 0x8D55, // decimal value: 36181

    // RenderbufferTarget

//  GL_RENDERBUFFER                                               = 0x8D41, // reuse ObjectIdentifier, decimal value: 36161

    // RenderingMode

    GL_RENDER                                                     = 0x1C00, // decimal value: 7168
    GL_FEEDBACK                                                   = 0x1C01, // decimal value: 7169
    GL_SELECT                                                     = 0x1C02, // decimal value: 7170

    // SamplePatternSGIS

    GL_1PASS_EXT                                                  = 0x80A1, // decimal value: 32929
    GL_1PASS_SGIS                                                 = 0x80A1, // decimal value: 32929
    GL_2PASS_0_EXT                                                = 0x80A2, // decimal value: 32930
    GL_2PASS_0_SGIS                                               = 0x80A2, // decimal value: 32930
    GL_2PASS_1_EXT                                                = 0x80A3, // decimal value: 32931
    GL_2PASS_1_SGIS                                               = 0x80A3, // decimal value: 32931
    GL_4PASS_0_EXT                                                = 0x80A4, // decimal value: 32932
    GL_4PASS_0_SGIS                                               = 0x80A4, // decimal value: 32932
    GL_4PASS_1_EXT                                                = 0x80A5, // decimal value: 32933
    GL_4PASS_1_SGIS                                               = 0x80A5, // decimal value: 32933
    GL_4PASS_2_EXT                                                = 0x80A6, // decimal value: 32934
    GL_4PASS_2_SGIS                                               = 0x80A6, // decimal value: 32934
    GL_4PASS_3_EXT                                                = 0x80A7, // decimal value: 32935
    GL_4PASS_3_SGIS                                               = 0x80A7, // decimal value: 32935

    // SamplerParameterName

//  GL_TEXTURE_BORDER_COLOR                                       = 0x1004, // reuse GetTextureParameter, decimal value: 4100
//  GL_TEXTURE_MAG_FILTER                                         = 0x2800, // reuse GetTextureParameter, decimal value: 10240
//  GL_TEXTURE_MIN_FILTER                                         = 0x2801, // reuse GetTextureParameter, decimal value: 10241
//  GL_TEXTURE_WRAP_S                                             = 0x2802, // reuse GetTextureParameter, decimal value: 10242
//  GL_TEXTURE_WRAP_T                                             = 0x2803, // reuse GetTextureParameter, decimal value: 10243
    GL_TEXTURE_WRAP_R                                             = 0x8072, // decimal value: 32882
    GL_TEXTURE_MIN_LOD                                            = 0x813A, // decimal value: 33082
    GL_TEXTURE_MAX_LOD                                            = 0x813B, // decimal value: 33083
    GL_TEXTURE_COMPARE_MODE                                       = 0x884C, // decimal value: 34892
    GL_TEXTURE_COMPARE_FUNC                                       = 0x884D, // decimal value: 34893

    // SemaphoreParameterName

    GL_D3D12_FENCE_VALUE_EXT                                      = 0x9595, // decimal value: 38293

    // SeparableTargetEXT

    GL_SEPARABLE_2D                                               = 0x8012, // decimal value: 32786
//  GL_SEPARABLE_2D_EXT                                           = 0x8012, // reuse EnableCap, decimal value: 32786

    // ShaderParameterName

    GL_SHADER_TYPE                                                = 0x8B4F, // decimal value: 35663
//  GL_DELETE_STATUS                                              = 0x8B80, // reuse ProgramPropertyARB, decimal value: 35712
    GL_COMPILE_STATUS                                             = 0x8B81, // decimal value: 35713
//  GL_INFO_LOG_LENGTH                                            = 0x8B84, // reuse PipelineParameterName, decimal value: 35716
    GL_SHADER_SOURCE_LENGTH                                       = 0x8B88, // decimal value: 35720

    // ShaderType

//  GL_FRAGMENT_SHADER                                            = 0x8B30, // reuse PipelineParameterName, decimal value: 35632
    GL_FRAGMENT_SHADER_ARB                                        = 0x8B30, // decimal value: 35632
//  GL_VERTEX_SHADER                                              = 0x8B31, // reuse PipelineParameterName, decimal value: 35633
    GL_VERTEX_SHADER_ARB                                          = 0x8B31, // decimal value: 35633
//  GL_GEOMETRY_SHADER                                            = 0x8DD9, // reuse PipelineParameterName, decimal value: 36313
//  GL_TESS_EVALUATION_SHADER                                     = 0x8E87, // reuse PipelineParameterName, decimal value: 36487
//  GL_TESS_CONTROL_SHADER                                        = 0x8E88, // reuse PipelineParameterName, decimal value: 36488
    GL_COMPUTE_SHADER                                             = 0x91B9, // decimal value: 37305

    // ShadingModel

    GL_FLAT                                                       = 0x1D00, // decimal value: 7424
    GL_SMOOTH                                                     = 0x1D01, // decimal value: 7425

    // StencilFaceDirection

//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer, decimal value: 1028
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer, decimal value: 1029
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer, decimal value: 1032

    // StencilFunction

//  GL_NEVER                                                      = 0x0200, // reuse AlphaFunction, decimal value: 512
//  GL_LESS                                                       = 0x0201, // reuse AlphaFunction, decimal value: 513
//  GL_EQUAL                                                      = 0x0202, // reuse AlphaFunction, decimal value: 514
//  GL_LEQUAL                                                     = 0x0203, // reuse AlphaFunction, decimal value: 515
//  GL_GREATER                                                    = 0x0204, // reuse AlphaFunction, decimal value: 516
//  GL_NOTEQUAL                                                   = 0x0205, // reuse AlphaFunction, decimal value: 517
//  GL_GEQUAL                                                     = 0x0206, // reuse AlphaFunction, decimal value: 518
//  GL_ALWAYS                                                     = 0x0207, // reuse AlphaFunction, decimal value: 519

    // StencilOp

//  GL_ZERO                                                       = 0, // reuse BlendingFactor
//  GL_INVERT                                                     = 0x150A, // reuse LogicOp, decimal value: 5386
    GL_KEEP                                                       = 0x1E00, // decimal value: 7680
//  GL_REPLACE                                                    = 0x1E01, // reuse LightEnvModeSGIX, decimal value: 7681
    GL_INCR                                                       = 0x1E02, // decimal value: 7682
    GL_DECR                                                       = 0x1E03, // decimal value: 7683

    // StringName

    GL_VENDOR                                                     = 0x1F00, // decimal value: 7936
    GL_RENDERER                                                   = 0x1F01, // decimal value: 7937
    GL_VERSION                                                    = 0x1F02, // decimal value: 7938
    GL_EXTENSIONS                                                 = 0x1F03, // decimal value: 7939
    GL_SHADING_LANGUAGE_VERSION                                   = 0x8B8C, // decimal value: 35724

    // SubroutineParameterName

    GL_UNIFORM_SIZE                                               = 0x8A38, // decimal value: 35384
    GL_UNIFORM_NAME_LENGTH                                        = 0x8A39, // decimal value: 35385
    GL_NUM_COMPATIBLE_SUBROUTINES                                 = 0x8E4A, // decimal value: 36426
    GL_COMPATIBLE_SUBROUTINES                                     = 0x8E4B, // decimal value: 36427

    // SyncCondition

    GL_SYNC_GPU_COMMANDS_COMPLETE                                 = 0x9117, // decimal value: 37143

    // SyncParameterName

    GL_OBJECT_TYPE                                                = 0x9112, // decimal value: 37138
    GL_SYNC_CONDITION                                             = 0x9113, // decimal value: 37139
    GL_SYNC_STATUS                                                = 0x9114, // decimal value: 37140
    GL_SYNC_FLAGS                                                 = 0x9115, // decimal value: 37141

    // SyncStatus

    GL_ALREADY_SIGNALED                                           = 0x911A, // decimal value: 37146
    GL_TIMEOUT_EXPIRED                                            = 0x911B, // decimal value: 37147
    GL_CONDITION_SATISFIED                                        = 0x911C, // decimal value: 37148
    GL_WAIT_FAILED                                                = 0x911D, // decimal value: 37149

    // TexCoordPointerType

//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // TextureCoordName

    GL_S                                                          = 0x2000, // decimal value: 8192
    GL_T                                                          = 0x2001, // decimal value: 8193
    GL_R                                                          = 0x2002, // decimal value: 8194
    GL_Q                                                          = 0x2003, // decimal value: 8195

    // TextureEnvMode

//  GL_ADD                                                        = 0x0104, // reuse AccumOp, decimal value: 260
//  GL_BLEND                                                      = 0x0BE2, // reuse EnableCap, decimal value: 3042
//  GL_MODULATE                                                   = 0x2100, // reuse LightEnvModeSGIX, decimal value: 8448
    GL_DECAL                                                      = 0x2101, // decimal value: 8449
    GL_REPLACE_EXT                                                = 0x8062, // decimal value: 32866
    GL_TEXTURE_ENV_BIAS_SGIX                                      = 0x80BE, // decimal value: 32958

    // TextureEnvParameter

    GL_TEXTURE_ENV_MODE                                           = 0x2200, // decimal value: 8704
    GL_TEXTURE_ENV_COLOR                                          = 0x2201, // decimal value: 8705

    // TextureEnvTarget

    GL_TEXTURE_ENV                                                = 0x2300, // decimal value: 8960

    // TextureFilterFuncSGIS

    GL_FILTER4_SGIS                                               = 0x8146, // decimal value: 33094

    // TextureGenMode

//  GL_EYE_LINEAR                                                 = 0x2400, // reuse PathGenMode, decimal value: 9216
//  GL_OBJECT_LINEAR                                              = 0x2401, // reuse PathGenMode, decimal value: 9217
    GL_SPHERE_MAP                                                 = 0x2402, // decimal value: 9218
    GL_EYE_DISTANCE_TO_POINT_SGIS                                 = 0x81F0, // decimal value: 33264
    GL_OBJECT_DISTANCE_TO_POINT_SGIS                              = 0x81F1, // decimal value: 33265
    GL_EYE_DISTANCE_TO_LINE_SGIS                                  = 0x81F2, // decimal value: 33266
    GL_OBJECT_DISTANCE_TO_LINE_SGIS                               = 0x81F3, // decimal value: 33267

    // TextureGenParameter

    GL_TEXTURE_GEN_MODE                                           = 0x2500, // decimal value: 9472
    GL_OBJECT_PLANE                                               = 0x2501, // decimal value: 9473
    GL_EYE_PLANE                                                  = 0x2502, // decimal value: 9474
    GL_EYE_POINT_SGIS                                             = 0x81F4, // decimal value: 33268
    GL_OBJECT_POINT_SGIS                                          = 0x81F5, // decimal value: 33269
    GL_EYE_LINE_SGIS                                              = 0x81F6, // decimal value: 33270
    GL_OBJECT_LINE_SGIS                                           = 0x81F7, // decimal value: 33271

    // TextureLayout

    GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT              = 0x9530, // decimal value: 38192
    GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT              = 0x9531, // decimal value: 38193
    GL_LAYOUT_GENERAL_EXT                                         = 0x958D, // decimal value: 38285
    GL_LAYOUT_COLOR_ATTACHMENT_EXT                                = 0x958E, // decimal value: 38286
    GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT                        = 0x958F, // decimal value: 38287
    GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT                         = 0x9590, // decimal value: 38288
    GL_LAYOUT_SHADER_READ_ONLY_EXT                                = 0x9591, // decimal value: 38289
    GL_LAYOUT_TRANSFER_SRC_EXT                                    = 0x9592, // decimal value: 38290
    GL_LAYOUT_TRANSFER_DST_EXT                                    = 0x9593, // decimal value: 38291

    // TextureMagFilter

//  GL_NEAREST                                                    = 0x2600, // reuse BlitFramebufferFilter, decimal value: 9728
//  GL_LINEAR                                                     = 0x2601, // reuse BlitFramebufferFilter, decimal value: 9729
    GL_LINEAR_DETAIL_SGIS                                         = 0x8097, // decimal value: 32919
    GL_LINEAR_DETAIL_ALPHA_SGIS                                   = 0x8098, // decimal value: 32920
    GL_LINEAR_DETAIL_COLOR_SGIS                                   = 0x8099, // decimal value: 32921
    GL_LINEAR_SHARPEN_SGIS                                        = 0x80AD, // decimal value: 32941
    GL_LINEAR_SHARPEN_ALPHA_SGIS                                  = 0x80AE, // decimal value: 32942
    GL_LINEAR_SHARPEN_COLOR_SGIS                                  = 0x80AF, // decimal value: 32943
//  GL_FILTER4_SGIS                                               = 0x8146, // reuse TextureFilterFuncSGIS, decimal value: 33094

    // TextureMinFilter

//  GL_NEAREST                                                    = 0x2600, // reuse BlitFramebufferFilter, decimal value: 9728
//  GL_LINEAR                                                     = 0x2601, // reuse BlitFramebufferFilter, decimal value: 9729
    GL_NEAREST_MIPMAP_NEAREST                                     = 0x2700, // decimal value: 9984
    GL_LINEAR_MIPMAP_NEAREST                                      = 0x2701, // decimal value: 9985
    GL_NEAREST_MIPMAP_LINEAR                                      = 0x2702, // decimal value: 9986
    GL_LINEAR_MIPMAP_LINEAR                                       = 0x2703, // decimal value: 9987
//  GL_FILTER4_SGIS                                               = 0x8146, // reuse TextureFilterFuncSGIS, decimal value: 33094
    GL_LINEAR_CLIPMAP_LINEAR_SGIX                                 = 0x8170, // decimal value: 33136
    GL_NEAREST_CLIPMAP_NEAREST_SGIX                               = 0x844D, // decimal value: 33869
    GL_NEAREST_CLIPMAP_LINEAR_SGIX                                = 0x844E, // decimal value: 33870
    GL_LINEAR_CLIPMAP_NEAREST_SGIX                                = 0x844F, // decimal value: 33871

    // TextureParameterName

//  GL_TEXTURE_WIDTH                                              = 0x1000, // reuse GetTextureParameter, decimal value: 4096
//  GL_TEXTURE_HEIGHT                                             = 0x1001, // reuse GetTextureParameter, decimal value: 4097
//  GL_TEXTURE_COMPONENTS                                         = 0x1003, // reuse GetTextureParameter, decimal value: 4099
//  GL_TEXTURE_INTERNAL_FORMAT                                    = 0x1003, // reuse GetTextureParameter, decimal value: 4099
//  GL_TEXTURE_BORDER_COLOR                                       = 0x1004, // reuse GetTextureParameter, decimal value: 4100
//  GL_TEXTURE_BORDER                                             = 0x1005, // reuse GetTextureParameter, decimal value: 4101
//  GL_TEXTURE_MAG_FILTER                                         = 0x2800, // reuse GetTextureParameter, decimal value: 10240
//  GL_TEXTURE_MIN_FILTER                                         = 0x2801, // reuse GetTextureParameter, decimal value: 10241
//  GL_TEXTURE_WRAP_S                                             = 0x2802, // reuse GetTextureParameter, decimal value: 10242
//  GL_TEXTURE_WRAP_T                                             = 0x2803, // reuse GetTextureParameter, decimal value: 10243
//  GL_TEXTURE_RED_SIZE                                           = 0x805C, // reuse GetTextureParameter, decimal value: 32860
//  GL_TEXTURE_GREEN_SIZE                                         = 0x805D, // reuse GetTextureParameter, decimal value: 32861
//  GL_TEXTURE_BLUE_SIZE                                          = 0x805E, // reuse GetTextureParameter, decimal value: 32862
//  GL_TEXTURE_ALPHA_SIZE                                         = 0x805F, // reuse GetTextureParameter, decimal value: 32863
//  GL_TEXTURE_LUMINANCE_SIZE                                     = 0x8060, // reuse GetTextureParameter, decimal value: 32864
//  GL_TEXTURE_INTENSITY_SIZE                                     = 0x8061, // reuse GetTextureParameter, decimal value: 32865
//  GL_TEXTURE_PRIORITY                                           = 0x8066, // reuse GetTextureParameter, decimal value: 32870
    GL_TEXTURE_PRIORITY_EXT                                       = 0x8066, // decimal value: 32870
//  GL_TEXTURE_RESIDENT                                           = 0x8067, // reuse GetTextureParameter, decimal value: 32871
//  GL_TEXTURE_DEPTH_EXT                                          = 0x8071, // reuse GetTextureParameter, decimal value: 32881
//  GL_TEXTURE_WRAP_R                                             = 0x8072, // reuse SamplerParameterName, decimal value: 32882
//  GL_TEXTURE_WRAP_R_EXT                                         = 0x8072, // reuse GetTextureParameter, decimal value: 32882
//  GL_DETAIL_TEXTURE_LEVEL_SGIS                                  = 0x809A, // reuse GetTextureParameter, decimal value: 32922
//  GL_DETAIL_TEXTURE_MODE_SGIS                                   = 0x809B, // reuse GetTextureParameter, decimal value: 32923
//  GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS                            = 0x809C, // reuse GetTextureParameter, decimal value: 32924
//  GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS                           = 0x80B0, // reuse GetTextureParameter, decimal value: 32944
//  GL_SHADOW_AMBIENT_SGIX                                        = 0x80BF, // reuse GetTextureParameter, decimal value: 32959
//  GL_DUAL_TEXTURE_SELECT_SGIS                                   = 0x8124, // reuse GetTextureParameter, decimal value: 33060
//  GL_QUAD_TEXTURE_SELECT_SGIS                                   = 0x8125, // reuse GetTextureParameter, decimal value: 33061
//  GL_TEXTURE_4DSIZE_SGIS                                        = 0x8136, // reuse GetTextureParameter, decimal value: 33078
//  GL_TEXTURE_WRAP_Q_SGIS                                        = 0x8137, // reuse GetTextureParameter, decimal value: 33079
//  GL_TEXTURE_MIN_LOD                                            = 0x813A, // reuse SamplerParameterName, decimal value: 33082
//  GL_TEXTURE_MIN_LOD_SGIS                                       = 0x813A, // reuse GetTextureParameter, decimal value: 33082
//  GL_TEXTURE_MAX_LOD                                            = 0x813B, // reuse SamplerParameterName, decimal value: 33083
//  GL_TEXTURE_MAX_LOD_SGIS                                       = 0x813B, // reuse GetTextureParameter, decimal value: 33083
    GL_TEXTURE_BASE_LEVEL                                         = 0x813C, // decimal value: 33084
//  GL_TEXTURE_BASE_LEVEL_SGIS                                    = 0x813C, // reuse GetTextureParameter, decimal value: 33084
    GL_TEXTURE_MAX_LEVEL                                          = 0x813D, // decimal value: 33085
//  GL_TEXTURE_MAX_LEVEL_SGIS                                     = 0x813D, // reuse GetTextureParameter, decimal value: 33085
//  GL_TEXTURE_FILTER4_SIZE_SGIS                                  = 0x8147, // reuse GetTextureParameter, decimal value: 33095
//  GL_TEXTURE_CLIPMAP_CENTER_SGIX                                = 0x8171, // reuse GetTextureParameter, decimal value: 33137
//  GL_TEXTURE_CLIPMAP_FRAME_SGIX                                 = 0x8172, // reuse GetTextureParameter, decimal value: 33138
//  GL_TEXTURE_CLIPMAP_OFFSET_SGIX                                = 0x8173, // reuse GetTextureParameter, decimal value: 33139
//  GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX                         = 0x8174, // reuse GetTextureParameter, decimal value: 33140
//  GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX                            = 0x8175, // reuse GetTextureParameter, decimal value: 33141
//  GL_TEXTURE_CLIPMAP_DEPTH_SGIX                                 = 0x8176, // reuse GetTextureParameter, decimal value: 33142
//  GL_POST_TEXTURE_FILTER_BIAS_SGIX                              = 0x8179, // reuse GetTextureParameter, decimal value: 33145
//  GL_POST_TEXTURE_FILTER_SCALE_SGIX                             = 0x817A, // reuse GetTextureParameter, decimal value: 33146
//  GL_TEXTURE_LOD_BIAS_S_SGIX                                    = 0x818E, // reuse GetTextureParameter, decimal value: 33166
//  GL_TEXTURE_LOD_BIAS_T_SGIX                                    = 0x818F, // reuse GetTextureParameter, decimal value: 33167
//  GL_TEXTURE_LOD_BIAS_R_SGIX                                    = 0x8190, // reuse GetTextureParameter, decimal value: 33168
//  GL_GENERATE_MIPMAP                                            = 0x8191, // reuse InternalFormatPName, decimal value: 33169
//  GL_GENERATE_MIPMAP_SGIS                                       = 0x8191, // reuse GetTextureParameter, decimal value: 33169
//  GL_TEXTURE_COMPARE_SGIX                                       = 0x819A, // reuse GetTextureParameter, decimal value: 33178
//  GL_TEXTURE_COMPARE_OPERATOR_SGIX                              = 0x819B, // reuse GetTextureParameter, decimal value: 33179
//  GL_TEXTURE_LEQUAL_R_SGIX                                      = 0x819C, // reuse GetTextureParameter, decimal value: 33180
//  GL_TEXTURE_GEQUAL_R_SGIX                                      = 0x819D, // reuse GetTextureParameter, decimal value: 33181
//  GL_TEXTURE_MAX_CLAMP_S_SGIX                                   = 0x8369, // reuse GetTextureParameter, decimal value: 33641
//  GL_TEXTURE_MAX_CLAMP_T_SGIX                                   = 0x836A, // reuse GetTextureParameter, decimal value: 33642
//  GL_TEXTURE_MAX_CLAMP_R_SGIX                                   = 0x836B, // reuse GetTextureParameter, decimal value: 33643
    GL_TEXTURE_LOD_BIAS                                           = 0x8501, // decimal value: 34049
//  GL_TEXTURE_COMPARE_MODE                                       = 0x884C, // reuse SamplerParameterName, decimal value: 34892
//  GL_TEXTURE_COMPARE_FUNC                                       = 0x884D, // reuse SamplerParameterName, decimal value: 34893
    GL_TEXTURE_SWIZZLE_R                                          = 0x8E42, // decimal value: 36418
    GL_TEXTURE_SWIZZLE_G                                          = 0x8E43, // decimal value: 36419
    GL_TEXTURE_SWIZZLE_B                                          = 0x8E44, // decimal value: 36420
    GL_TEXTURE_SWIZZLE_A                                          = 0x8E45, // decimal value: 36421
    GL_TEXTURE_SWIZZLE_RGBA                                       = 0x8E46, // decimal value: 36422
    GL_DEPTH_STENCIL_TEXTURE_MODE                                 = 0x90EA, // decimal value: 37098
    GL_TEXTURE_TILING_EXT                                         = 0x9580, // decimal value: 38272

    // TextureTarget

//  GL_TEXTURE_1D                                                 = 0x0DE0, // reuse EnableCap, decimal value: 3552
//  GL_TEXTURE_2D                                                 = 0x0DE1, // reuse EnableCap, decimal value: 3553
    GL_PROXY_TEXTURE_1D                                           = 0x8063, // decimal value: 32867
    GL_PROXY_TEXTURE_1D_EXT                                       = 0x8063, // decimal value: 32867
    GL_PROXY_TEXTURE_2D                                           = 0x8064, // decimal value: 32868
    GL_PROXY_TEXTURE_2D_EXT                                       = 0x8064, // decimal value: 32868
    GL_TEXTURE_3D                                                 = 0x806F, // decimal value: 32879
//  GL_TEXTURE_3D_EXT                                             = 0x806F, // reuse EnableCap, decimal value: 32879
    GL_PROXY_TEXTURE_3D                                           = 0x8070, // decimal value: 32880
    GL_PROXY_TEXTURE_3D_EXT                                       = 0x8070, // decimal value: 32880
    GL_DETAIL_TEXTURE_2D_SGIS                                     = 0x8095, // decimal value: 32917
//  GL_TEXTURE_4D_SGIS                                            = 0x8134, // reuse EnableCap, decimal value: 33076
    GL_PROXY_TEXTURE_4D_SGIS                                      = 0x8135, // decimal value: 33077
    GL_TEXTURE_RECTANGLE                                          = 0x84F5, // decimal value: 34037
    GL_PROXY_TEXTURE_RECTANGLE                                    = 0x84F7, // decimal value: 34039
    GL_PROXY_TEXTURE_RECTANGLE_ARB                                = 0x84F7, // decimal value: 34039
    GL_PROXY_TEXTURE_RECTANGLE_NV                                 = 0x84F7, // decimal value: 34039
    GL_TEXTURE_CUBE_MAP                                           = 0x8513, // decimal value: 34067
    GL_TEXTURE_CUBE_MAP_POSITIVE_X                                = 0x8515, // decimal value: 34069
    GL_TEXTURE_CUBE_MAP_NEGATIVE_X                                = 0x8516, // decimal value: 34070
    GL_TEXTURE_CUBE_MAP_POSITIVE_Y                                = 0x8517, // decimal value: 34071
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Y                                = 0x8518, // decimal value: 34072
    GL_TEXTURE_CUBE_MAP_POSITIVE_Z                                = 0x8519, // decimal value: 34073
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Z                                = 0x851A, // decimal value: 34074
    GL_PROXY_TEXTURE_CUBE_MAP                                     = 0x851B, // decimal value: 34075
    GL_PROXY_TEXTURE_CUBE_MAP_ARB                                 = 0x851B, // decimal value: 34075
    GL_PROXY_TEXTURE_CUBE_MAP_EXT                                 = 0x851B, // decimal value: 34075
    GL_TEXTURE_1D_ARRAY                                           = 0x8C18, // decimal value: 35864
    GL_PROXY_TEXTURE_1D_ARRAY                                     = 0x8C19, // decimal value: 35865
    GL_PROXY_TEXTURE_1D_ARRAY_EXT                                 = 0x8C19, // decimal value: 35865
    GL_TEXTURE_2D_ARRAY                                           = 0x8C1A, // decimal value: 35866
    GL_PROXY_TEXTURE_2D_ARRAY                                     = 0x8C1B, // decimal value: 35867
    GL_PROXY_TEXTURE_2D_ARRAY_EXT                                 = 0x8C1B, // decimal value: 35867
    GL_TEXTURE_CUBE_MAP_ARRAY                                     = 0x9009, // decimal value: 36873
    GL_TEXTURE_CUBE_MAP_ARRAY_ARB                                 = 0x9009, // decimal value: 36873
    GL_PROXY_TEXTURE_CUBE_MAP_ARRAY                               = 0x900B, // decimal value: 36875
    GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB                           = 0x900B, // decimal value: 36875
    GL_TEXTURE_2D_MULTISAMPLE                                     = 0x9100, // decimal value: 37120
    GL_PROXY_TEXTURE_2D_MULTISAMPLE                               = 0x9101, // decimal value: 37121
    GL_TEXTURE_2D_MULTISAMPLE_ARRAY                               = 0x9102, // decimal value: 37122
    GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY                         = 0x9103, // decimal value: 37123

    // TextureUnit

    GL_TEXTURE0                                                   = 0x84C0, // decimal value: 33984
    GL_TEXTURE1                                                   = 0x84C1, // decimal value: 33985
    GL_TEXTURE2                                                   = 0x84C2, // decimal value: 33986
    GL_TEXTURE3                                                   = 0x84C3, // decimal value: 33987
    GL_TEXTURE4                                                   = 0x84C4, // decimal value: 33988
    GL_TEXTURE5                                                   = 0x84C5, // decimal value: 33989
    GL_TEXTURE6                                                   = 0x84C6, // decimal value: 33990
    GL_TEXTURE7                                                   = 0x84C7, // decimal value: 33991
    GL_TEXTURE8                                                   = 0x84C8, // decimal value: 33992
    GL_TEXTURE9                                                   = 0x84C9, // decimal value: 33993
    GL_TEXTURE10                                                  = 0x84CA, // decimal value: 33994
    GL_TEXTURE11                                                  = 0x84CB, // decimal value: 33995
    GL_TEXTURE12                                                  = 0x84CC, // decimal value: 33996
    GL_TEXTURE13                                                  = 0x84CD, // decimal value: 33997
    GL_TEXTURE14                                                  = 0x84CE, // decimal value: 33998
    GL_TEXTURE15                                                  = 0x84CF, // decimal value: 33999
    GL_TEXTURE16                                                  = 0x84D0, // decimal value: 34000
    GL_TEXTURE17                                                  = 0x84D1, // decimal value: 34001
    GL_TEXTURE18                                                  = 0x84D2, // decimal value: 34002
    GL_TEXTURE19                                                  = 0x84D3, // decimal value: 34003
    GL_TEXTURE20                                                  = 0x84D4, // decimal value: 34004
    GL_TEXTURE21                                                  = 0x84D5, // decimal value: 34005
    GL_TEXTURE22                                                  = 0x84D6, // decimal value: 34006
    GL_TEXTURE23                                                  = 0x84D7, // decimal value: 34007
    GL_TEXTURE24                                                  = 0x84D8, // decimal value: 34008
    GL_TEXTURE25                                                  = 0x84D9, // decimal value: 34009
    GL_TEXTURE26                                                  = 0x84DA, // decimal value: 34010
    GL_TEXTURE27                                                  = 0x84DB, // decimal value: 34011
    GL_TEXTURE28                                                  = 0x84DC, // decimal value: 34012
    GL_TEXTURE29                                                  = 0x84DD, // decimal value: 34013
    GL_TEXTURE30                                                  = 0x84DE, // decimal value: 34014
    GL_TEXTURE31                                                  = 0x84DF, // decimal value: 34015

    // TextureWrapMode

    GL_CLAMP                                                      = 0x2900, // decimal value: 10496
    GL_REPEAT                                                     = 0x2901, // decimal value: 10497
    GL_CLAMP_TO_BORDER                                            = 0x812D, // decimal value: 33069
    GL_CLAMP_TO_BORDER_ARB                                        = 0x812D, // decimal value: 33069
    GL_CLAMP_TO_BORDER_SGIS                                       = 0x812D, // decimal value: 33069
    GL_CLAMP_TO_EDGE                                              = 0x812F, // decimal value: 33071
    GL_CLAMP_TO_EDGE_SGIS                                         = 0x812F, // decimal value: 33071

    // TransformFeedbackPName

    GL_TRANSFORM_FEEDBACK_BUFFER_START                            = 0x8C84, // decimal value: 35972
    GL_TRANSFORM_FEEDBACK_BUFFER_SIZE                             = 0x8C85, // decimal value: 35973
    GL_TRANSFORM_FEEDBACK_BUFFER_BINDING                          = 0x8C8F, // decimal value: 35983
    GL_TRANSFORM_FEEDBACK_PAUSED                                  = 0x8E23, // decimal value: 36387
    GL_TRANSFORM_FEEDBACK_ACTIVE                                  = 0x8E24, // decimal value: 36388

    // TypeEnum

    GL_QUERY_WAIT                                                 = 0x8E13, // decimal value: 36371
    GL_QUERY_NO_WAIT                                              = 0x8E14, // decimal value: 36372
    GL_QUERY_BY_REGION_WAIT                                       = 0x8E15, // decimal value: 36373
    GL_QUERY_BY_REGION_NO_WAIT                                    = 0x8E16, // decimal value: 36374

    // UniformBlockPName

    GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER            = 0x84F0, // decimal value: 34032
    GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER         = 0x84F1, // decimal value: 34033
    GL_UNIFORM_BLOCK_BINDING                                      = 0x8A3F, // decimal value: 35391
    GL_UNIFORM_BLOCK_DATA_SIZE                                    = 0x8A40, // decimal value: 35392
    GL_UNIFORM_BLOCK_NAME_LENGTH                                  = 0x8A41, // decimal value: 35393
    GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS                              = 0x8A42, // decimal value: 35394
    GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES                       = 0x8A43, // decimal value: 35395
    GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER                  = 0x8A44, // decimal value: 35396
    GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER                = 0x8A45, // decimal value: 35397
    GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER                = 0x8A46, // decimal value: 35398
    GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER                 = 0x90EC, // decimal value: 37100

    // UniformPName

    GL_UNIFORM_TYPE                                               = 0x8A37, // decimal value: 35383
//  GL_UNIFORM_SIZE                                               = 0x8A38, // reuse SubroutineParameterName, decimal value: 35384
//  GL_UNIFORM_NAME_LENGTH                                        = 0x8A39, // reuse SubroutineParameterName, decimal value: 35385
    GL_UNIFORM_BLOCK_INDEX                                        = 0x8A3A, // decimal value: 35386
    GL_UNIFORM_OFFSET                                             = 0x8A3B, // decimal value: 35387
    GL_UNIFORM_ARRAY_STRIDE                                       = 0x8A3C, // decimal value: 35388
    GL_UNIFORM_MATRIX_STRIDE                                      = 0x8A3D, // decimal value: 35389
    GL_UNIFORM_IS_ROW_MAJOR                                       = 0x8A3E, // decimal value: 35390
    GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX                        = 0x92DA, // decimal value: 37594

    // VertexArrayPName

    GL_VERTEX_ATTRIB_RELATIVE_OFFSET                              = 0x82D5, // decimal value: 33493
    GL_VERTEX_ATTRIB_ARRAY_ENABLED                                = 0x8622, // decimal value: 34338
    GL_VERTEX_ATTRIB_ARRAY_SIZE                                   = 0x8623, // decimal value: 34339
    GL_VERTEX_ATTRIB_ARRAY_STRIDE                                 = 0x8624, // decimal value: 34340
    GL_VERTEX_ATTRIB_ARRAY_TYPE                                   = 0x8625, // decimal value: 34341
    GL_VERTEX_ATTRIB_ARRAY_LONG                                   = 0x874E, // decimal value: 34638
    GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                             = 0x886A, // decimal value: 34922
    GL_VERTEX_ATTRIB_ARRAY_INTEGER                                = 0x88FD, // decimal value: 35069
    GL_VERTEX_ATTRIB_ARRAY_DIVISOR                                = 0x88FE, // decimal value: 35070

    // VertexAttribEnum

//  GL_VERTEX_ATTRIB_ARRAY_ENABLED                                = 0x8622, // reuse VertexArrayPName, decimal value: 34338
//  GL_VERTEX_ATTRIB_ARRAY_SIZE                                   = 0x8623, // reuse VertexArrayPName, decimal value: 34339
//  GL_VERTEX_ATTRIB_ARRAY_STRIDE                                 = 0x8624, // reuse VertexArrayPName, decimal value: 34340
//  GL_VERTEX_ATTRIB_ARRAY_TYPE                                   = 0x8625, // reuse VertexArrayPName, decimal value: 34341
    GL_CURRENT_VERTEX_ATTRIB                                      = 0x8626, // decimal value: 34342
//  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                             = 0x886A, // reuse VertexArrayPName, decimal value: 34922
    GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING                         = 0x889F, // decimal value: 34975
//  GL_VERTEX_ATTRIB_ARRAY_INTEGER                                = 0x88FD, // reuse VertexArrayPName, decimal value: 35069
//  GL_VERTEX_ATTRIB_ARRAY_DIVISOR                                = 0x88FE, // reuse VertexArrayPName, decimal value: 35070

    // VertexAttribPointerType

//  GL_BYTE                                                       = 0x1400, // reuse ColorPointerType, decimal value: 5120
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType, decimal value: 5121
//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType, decimal value: 5123
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse ColorPointerType, decimal value: 5125
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130
    GL_HALF_FLOAT                                                 = 0x140B, // decimal value: 5131
    GL_FIXED                                                      = 0x140C, // decimal value: 5132
    GL_UNSIGNED_INT_2_10_10_10_REV                                = 0x8368, // decimal value: 33640
    GL_UNSIGNED_INT_10F_11F_11F_REV                               = 0x8C3B, // decimal value: 35899
    GL_INT_2_10_10_10_REV                                         = 0x8D9F, // decimal value: 36255

    // VertexAttribType

//  GL_BYTE                                                       = 0x1400, // reuse ColorPointerType, decimal value: 5120
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType, decimal value: 5121
//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType, decimal value: 5123
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse ColorPointerType, decimal value: 5125
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130
//  GL_HALF_FLOAT                                                 = 0x140B, // reuse VertexAttribPointerType, decimal value: 5131
//  GL_FIXED                                                      = 0x140C, // reuse VertexAttribPointerType, decimal value: 5132
//  GL_UNSIGNED_INT_2_10_10_10_REV                                = 0x8368, // reuse VertexAttribPointerType, decimal value: 33640
//  GL_UNSIGNED_INT_10F_11F_11F_REV                               = 0x8C3B, // reuse VertexAttribPointerType, decimal value: 35899
//  GL_INT_2_10_10_10_REV                                         = 0x8D9F, // reuse VertexAttribPointerType, decimal value: 36255

    // VertexBufferObjectParameter

    GL_BUFFER_IMMUTABLE_STORAGE                                   = 0x821F, // decimal value: 33311
    GL_BUFFER_STORAGE_FLAGS                                       = 0x8220, // decimal value: 33312
    GL_BUFFER_SIZE                                                = 0x8764, // decimal value: 34660
    GL_BUFFER_USAGE                                               = 0x8765, // decimal value: 34661
    GL_BUFFER_ACCESS                                              = 0x88BB, // decimal value: 35003
    GL_BUFFER_MAPPED                                              = 0x88BC, // decimal value: 35004
    GL_BUFFER_ACCESS_FLAGS                                        = 0x911F, // decimal value: 37151
    GL_BUFFER_MAP_LENGTH                                          = 0x9120, // decimal value: 37152
    GL_BUFFER_MAP_OFFSET                                          = 0x9121, // decimal value: 37153

    // VertexBufferObjectUsage

//  GL_STREAM_DRAW                                                = 0x88E0, // reuse BufferUsageARB, decimal value: 35040
//  GL_STREAM_READ                                                = 0x88E1, // reuse BufferUsageARB, decimal value: 35041
//  GL_STREAM_COPY                                                = 0x88E2, // reuse BufferUsageARB, decimal value: 35042
//  GL_STATIC_DRAW                                                = 0x88E4, // reuse BufferUsageARB, decimal value: 35044
//  GL_STATIC_READ                                                = 0x88E5, // reuse BufferUsageARB, decimal value: 35045
//  GL_STATIC_COPY                                                = 0x88E6, // reuse BufferUsageARB, decimal value: 35046
//  GL_DYNAMIC_DRAW                                               = 0x88E8, // reuse BufferUsageARB, decimal value: 35048
//  GL_DYNAMIC_READ                                               = 0x88E9, // reuse BufferUsageARB, decimal value: 35049
//  GL_DYNAMIC_COPY                                               = 0x88EA, // reuse BufferUsageARB, decimal value: 35050

    // VertexPointerType

//  GL_SHORT                                                      = 0x1402, // reuse ColorPointerType, decimal value: 5122
//  GL_INT                                                        = 0x1404, // reuse ColorPointerType, decimal value: 5124
//  GL_FLOAT                                                      = 0x1406, // reuse ColorPointerType, decimal value: 5126
//  GL_DOUBLE                                                     = 0x140A, // reuse ColorPointerType, decimal value: 5130

    // VertexProvokingMode

    GL_FIRST_VERTEX_CONVENTION                                    = 0x8E4D, // decimal value: 36429
    GL_LAST_VERTEX_CONVENTION                                     = 0x8E4E, // decimal value: 36430

    // __UNGROUPED__

    GL_NEXT_BUFFER_NV                                             = static_cast<unsigned int>(-2),
    GL_SKIP_COMPONENTS4_NV                                        = static_cast<unsigned int>(-3),
    GL_SKIP_COMPONENTS3_NV                                        = static_cast<unsigned int>(-4),
    GL_SKIP_COMPONENTS2_NV                                        = static_cast<unsigned int>(-5),
    GL_SKIP_COMPONENTS1_NV                                        = static_cast<unsigned int>(-6),
    GL_CLOSE_PATH_NV                                              = 0x00,
    GL_TERMINATE_SEQUENCE_COMMAND_NV                              = 0x0000,
    GL_NOP_COMMAND_NV                                             = 0x0001, // decimal value: 1
    GL_RESTART_SUN                                                = 0x0001, // decimal value: 1
    GL_DRAW_ELEMENTS_COMMAND_NV                                   = 0x0002, // decimal value: 2
    GL_REPLACE_MIDDLE_SUN                                         = 0x0002, // decimal value: 2
    GL_DRAW_ARRAYS_COMMAND_NV                                     = 0x0003, // decimal value: 3
    GL_REPLACE_OLDEST_SUN                                         = 0x0003, // decimal value: 3
    GL_DRAW_ELEMENTS_STRIP_COMMAND_NV                             = 0x0004, // decimal value: 4
    GL_DRAW_ARRAYS_STRIP_COMMAND_NV                               = 0x0005, // decimal value: 5
    GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV                         = 0x0006, // decimal value: 6
    GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV                           = 0x0007, // decimal value: 7
    GL_ELEMENT_ADDRESS_COMMAND_NV                                 = 0x0008, // decimal value: 8
    GL_ATTRIBUTE_ADDRESS_COMMAND_NV                               = 0x0009, // decimal value: 9
    GL_UNIFORM_ADDRESS_COMMAND_NV                                 = 0x000A, // decimal value: 10
    GL_BLEND_COLOR_COMMAND_NV                                     = 0x000B, // decimal value: 11
    GL_STENCIL_REF_COMMAND_NV                                     = 0x000C, // decimal value: 12
    GL_LINE_WIDTH_COMMAND_NV                                      = 0x000D, // decimal value: 13
    GL_POLYGON_OFFSET_COMMAND_NV                                  = 0x000E, // decimal value: 14
    GL_ALPHA_REF_COMMAND_NV                                       = 0x000F, // decimal value: 15
    GL_VIEWPORT_COMMAND_NV                                        = 0x0010, // decimal value: 16
    GL_SCISSOR_COMMAND_NV                                         = 0x0011, // decimal value: 17
    GL_FRONT_FACE_COMMAND_NV                                      = 0x0012, // decimal value: 18
    GL_MOVE_TO_NV                                                 = 0x02, // decimal value: 2
    GL_RELATIVE_MOVE_TO_NV                                        = 0x03, // decimal value: 3
    GL_LINE_TO_NV                                                 = 0x04, // decimal value: 4
    GL_RELATIVE_LINE_TO_NV                                        = 0x05, // decimal value: 5
    GL_CONTEXT_LOST                                               = 0x0507, // decimal value: 1287
    GL_HORIZONTAL_LINE_TO_NV                                      = 0x06, // decimal value: 6
    GL_RELATIVE_HORIZONTAL_LINE_TO_NV                             = 0x07, // decimal value: 7
    GL_VERTICAL_LINE_TO_NV                                        = 0x08, // decimal value: 8
    GL_RELATIVE_VERTICAL_LINE_TO_NV                               = 0x09, // decimal value: 9
    GL_QUADRATIC_CURVE_TO_NV                                      = 0x0A, // decimal value: 10
    GL_RELATIVE_QUADRATIC_CURVE_TO_NV                             = 0x0B, // decimal value: 11
    GL_PATH_MODELVIEW_STACK_DEPTH_NV                              = 0x0BA3, // decimal value: 2979
    GL_PATH_PROJECTION_STACK_DEPTH_NV                             = 0x0BA4, // decimal value: 2980
    GL_PATH_MODELVIEW_MATRIX_NV                                   = 0x0BA6, // decimal value: 2982
    GL_PATH_PROJECTION_MATRIX_NV                                  = 0x0BA7, // decimal value: 2983
    GL_CUBIC_CURVE_TO_NV                                          = 0x0C, // decimal value: 12
    GL_RELATIVE_CUBIC_CURVE_TO_NV                                 = 0x0D, // decimal value: 13
    GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV                          = 0x0D36, // decimal value: 3382
    GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV                         = 0x0D38, // decimal value: 3384
    GL_SMOOTH_QUADRATIC_CURVE_TO_NV                               = 0x0E, // decimal value: 14
    GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV                      = 0x0F, // decimal value: 15
    GL_SMOOTH_CUBIC_CURVE_TO_NV                                   = 0x10, // decimal value: 16
    GL_TEXTURE_TARGET                                             = 0x1006, // decimal value: 4102
    GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV                          = 0x11, // decimal value: 17
    GL_SMALL_CCW_ARC_TO_NV                                        = 0x12, // decimal value: 18
    GL_RELATIVE_SMALL_CCW_ARC_TO_NV                               = 0x13, // decimal value: 19
    GL_SMALL_CW_ARC_TO_NV                                         = 0x14, // decimal value: 20
    GL_2_BYTES_NV                                                 = 0x1407, // decimal value: 5127
    GL_3_BYTES_NV                                                 = 0x1408, // decimal value: 5128
    GL_4_BYTES_NV                                                 = 0x1409, // decimal value: 5129
    GL_HALF_APPLE                                                 = 0x140B, // decimal value: 5131
    GL_HALF_FLOAT_ARB                                             = 0x140B, // decimal value: 5131
    GL_HALF_FLOAT_NV                                              = 0x140B, // decimal value: 5131
    GL_FIXED_OES                                                  = 0x140C, // decimal value: 5132
    GL_INT64_ARB                                                  = 0x140E, // decimal value: 5134
    GL_INT64_NV                                                   = 0x140E, // decimal value: 5134
    GL_UNSIGNED_INT64_ARB                                         = 0x140F, // decimal value: 5135
    GL_UNSIGNED_INT64_NV                                          = 0x140F, // decimal value: 5135
    GL_RELATIVE_SMALL_CW_ARC_TO_NV                                = 0x15, // decimal value: 21
    GL_XOR_NV                                                     = 0x1506, // decimal value: 5382
    GL_LARGE_CCW_ARC_TO_NV                                        = 0x16, // decimal value: 22
    GL_RELATIVE_LARGE_CCW_ARC_TO_NV                               = 0x17, // decimal value: 23
    GL_MODELVIEW0_ARB                                             = 0x1700, // decimal value: 5888
    GL_PATH_MODELVIEW_NV                                          = 0x1700, // decimal value: 5888
    GL_PATH_PROJECTION_NV                                         = 0x1701, // decimal value: 5889
    GL_LARGE_CW_ARC_TO_NV                                         = 0x18, // decimal value: 24
    GL_RELATIVE_LARGE_CW_ARC_TO_NV                                = 0x19, // decimal value: 25
    GL_RED_NV                                                     = 0x1903, // decimal value: 6403
    GL_GREEN_NV                                                   = 0x1904, // decimal value: 6404
    GL_BLUE_NV                                                    = 0x1905, // decimal value: 6405
    GL_RASTER_POSITION_UNCLIPPED_IBM                              = 0x19262, // decimal value: 103010
    GL_CONIC_CURVE_TO_NV                                          = 0x1A, // decimal value: 26
    GL_NATIVE_GRAPHICS_HANDLE_PGI                                 = 0x1A202, // decimal value: 107010
    GL_RELATIVE_CONIC_CURVE_TO_NV                                 = 0x1B, // decimal value: 27
    GL_EYE_LINEAR_NV                                              = 0x2400, // decimal value: 9216
    GL_OBJECT_LINEAR_NV                                           = 0x2401, // decimal value: 9217
    GL_CONSTANT_COLOR_EXT                                         = 0x8001, // decimal value: 32769
    GL_ONE_MINUS_CONSTANT_COLOR_EXT                               = 0x8002, // decimal value: 32770
    GL_CONSTANT_ALPHA_EXT                                         = 0x8003, // decimal value: 32771
    GL_ONE_MINUS_CONSTANT_ALPHA_EXT                               = 0x8004, // decimal value: 32772
    GL_BLEND_COLOR                                                = 0x8005, // decimal value: 32773
    GL_MIN                                                        = 0x8007, // decimal value: 32775
    GL_MAX                                                        = 0x8008, // decimal value: 32776
    GL_BLEND_EQUATION                                             = 0x8009, // decimal value: 32777
    GL_BLEND_EQUATION_RGB                                         = 0x8009, // decimal value: 32777
    GL_BLEND_EQUATION_RGB_EXT                                     = 0x8009, // decimal value: 32777
    GL_POLYGON_OFFSET_EXT                                         = 0x8037, // decimal value: 32823
    GL_POLYGON_OFFSET_FACTOR_EXT                                  = 0x8038, // decimal value: 32824
    GL_RESCALE_NORMAL                                             = 0x803A, // decimal value: 32826
    GL_ALPHA4_EXT                                                 = 0x803B, // decimal value: 32827
    GL_ALPHA8_EXT                                                 = 0x803C, // decimal value: 32828
    GL_ALPHA12_EXT                                                = 0x803D, // decimal value: 32829
    GL_ALPHA16_EXT                                                = 0x803E, // decimal value: 32830
    GL_LUMINANCE4_EXT                                             = 0x803F, // decimal value: 32831
    GL_LUMINANCE8_EXT                                             = 0x8040, // decimal value: 32832
    GL_LUMINANCE12_EXT                                            = 0x8041, // decimal value: 32833
    GL_LUMINANCE16_EXT                                            = 0x8042, // decimal value: 32834
    GL_LUMINANCE4_ALPHA4_EXT                                      = 0x8043, // decimal value: 32835
    GL_LUMINANCE6_ALPHA2_EXT                                      = 0x8044, // decimal value: 32836
    GL_LUMINANCE8_ALPHA8_EXT                                      = 0x8045, // decimal value: 32837
    GL_LUMINANCE12_ALPHA4_EXT                                     = 0x8046, // decimal value: 32838
    GL_LUMINANCE12_ALPHA12_EXT                                    = 0x8047, // decimal value: 32839
    GL_LUMINANCE16_ALPHA16_EXT                                    = 0x8048, // decimal value: 32840
    GL_INTENSITY_EXT                                              = 0x8049, // decimal value: 32841
    GL_INTENSITY4_EXT                                             = 0x804A, // decimal value: 32842
    GL_INTENSITY8_EXT                                             = 0x804B, // decimal value: 32843
    GL_INTENSITY12_EXT                                            = 0x804C, // decimal value: 32844
    GL_INTENSITY16_EXT                                            = 0x804D, // decimal value: 32845
    GL_RGBA2                                                      = 0x8055, // decimal value: 32853
    GL_RGBA2_EXT                                                  = 0x8055, // decimal value: 32853
    GL_TEXTURE_RED_SIZE_EXT                                       = 0x805C, // decimal value: 32860
    GL_TEXTURE_GREEN_SIZE_EXT                                     = 0x805D, // decimal value: 32861
    GL_TEXTURE_BLUE_SIZE_EXT                                      = 0x805E, // decimal value: 32862
    GL_TEXTURE_ALPHA_SIZE_EXT                                     = 0x805F, // decimal value: 32863
    GL_TEXTURE_LUMINANCE_SIZE_EXT                                 = 0x8060, // decimal value: 32864
    GL_TEXTURE_INTENSITY_SIZE_EXT                                 = 0x8061, // decimal value: 32865
    GL_TEXTURE_RESIDENT_EXT                                       = 0x8067, // decimal value: 32871
    GL_TEXTURE_1D_BINDING_EXT                                     = 0x8068, // decimal value: 32872
    GL_TEXTURE_2D_BINDING_EXT                                     = 0x8069, // decimal value: 32873
    GL_TEXTURE_DEPTH                                              = 0x8071, // decimal value: 32881
    GL_MAX_3D_TEXTURE_SIZE                                        = 0x8073, // decimal value: 32883
    GL_VERTEX_ARRAY_EXT                                           = 0x8074, // decimal value: 32884
    GL_NORMAL_ARRAY_EXT                                           = 0x8075, // decimal value: 32885
    GL_COLOR_ARRAY_EXT                                            = 0x8076, // decimal value: 32886
    GL_INDEX_ARRAY_EXT                                            = 0x8077, // decimal value: 32887
    GL_TEXTURE_COORD_ARRAY_EXT                                    = 0x8078, // decimal value: 32888
    GL_EDGE_FLAG_ARRAY_EXT                                        = 0x8079, // decimal value: 32889
    GL_VERTEX_ARRAY_SIZE_EXT                                      = 0x807A, // decimal value: 32890
    GL_VERTEX_ARRAY_TYPE_EXT                                      = 0x807B, // decimal value: 32891
    GL_VERTEX_ARRAY_STRIDE_EXT                                    = 0x807C, // decimal value: 32892
    GL_NORMAL_ARRAY_TYPE_EXT                                      = 0x807E, // decimal value: 32894
    GL_NORMAL_ARRAY_STRIDE_EXT                                    = 0x807F, // decimal value: 32895
    GL_COLOR_ARRAY_SIZE_EXT                                       = 0x8081, // decimal value: 32897
    GL_COLOR_ARRAY_TYPE_EXT                                       = 0x8082, // decimal value: 32898
    GL_COLOR_ARRAY_STRIDE_EXT                                     = 0x8083, // decimal value: 32899
    GL_INDEX_ARRAY_TYPE_EXT                                       = 0x8085, // decimal value: 32901
    GL_INDEX_ARRAY_STRIDE_EXT                                     = 0x8086, // decimal value: 32902
    GL_TEXTURE_COORD_ARRAY_SIZE_EXT                               = 0x8088, // decimal value: 32904
    GL_TEXTURE_COORD_ARRAY_TYPE_EXT                               = 0x8089, // decimal value: 32905
    GL_TEXTURE_COORD_ARRAY_STRIDE_EXT                             = 0x808A, // decimal value: 32906
    GL_EDGE_FLAG_ARRAY_STRIDE_EXT                                 = 0x808C, // decimal value: 32908
    GL_MULTISAMPLE                                                = 0x809D, // decimal value: 32925
    GL_MULTISAMPLE_ARB                                            = 0x809D, // decimal value: 32925
    GL_MULTISAMPLE_EXT                                            = 0x809D, // decimal value: 32925
    GL_SAMPLE_ALPHA_TO_COVERAGE                                   = 0x809E, // decimal value: 32926
    GL_SAMPLE_ALPHA_TO_COVERAGE_ARB                               = 0x809E, // decimal value: 32926
    GL_SAMPLE_ALPHA_TO_MASK_EXT                                   = 0x809E, // decimal value: 32926
    GL_SAMPLE_ALPHA_TO_ONE                                        = 0x809F, // decimal value: 32927
    GL_SAMPLE_ALPHA_TO_ONE_ARB                                    = 0x809F, // decimal value: 32927
    GL_SAMPLE_ALPHA_TO_ONE_EXT                                    = 0x809F, // decimal value: 32927
    GL_SAMPLE_COVERAGE                                            = 0x80A0, // decimal value: 32928
    GL_SAMPLE_COVERAGE_ARB                                        = 0x80A0, // decimal value: 32928
    GL_SAMPLE_MASK_EXT                                            = 0x80A0, // decimal value: 32928
    GL_SAMPLE_BUFFERS_ARB                                         = 0x80A8, // decimal value: 32936
    GL_SAMPLE_BUFFERS_EXT                                         = 0x80A8, // decimal value: 32936
    GL_SAMPLES_ARB                                                = 0x80A9, // decimal value: 32937
    GL_SAMPLES_EXT                                                = 0x80A9, // decimal value: 32937
    GL_SAMPLE_COVERAGE_VALUE                                      = 0x80AA, // decimal value: 32938
    GL_SAMPLE_COVERAGE_VALUE_ARB                                  = 0x80AA, // decimal value: 32938
    GL_SAMPLE_MASK_VALUE_EXT                                      = 0x80AA, // decimal value: 32938
    GL_SAMPLE_COVERAGE_INVERT                                     = 0x80AB, // decimal value: 32939
    GL_SAMPLE_COVERAGE_INVERT_ARB                                 = 0x80AB, // decimal value: 32939
    GL_SAMPLE_MASK_INVERT_EXT                                     = 0x80AB, // decimal value: 32939
    GL_SAMPLE_PATTERN_EXT                                         = 0x80AC, // decimal value: 32940
    GL_COLOR_MATRIX                                               = 0x80B1, // decimal value: 32945
    GL_COLOR_MATRIX_STACK_DEPTH                                   = 0x80B2, // decimal value: 32946
    GL_MAX_COLOR_MATRIX_STACK_DEPTH                               = 0x80B3, // decimal value: 32947
    GL_TEXTURE_COMPARE_FAIL_VALUE_ARB                             = 0x80BF, // decimal value: 32959
    GL_BLEND_DST_RGB                                              = 0x80C8, // decimal value: 32968
    GL_BLEND_DST_RGB_EXT                                          = 0x80C8, // decimal value: 32968
    GL_BLEND_SRC_RGB                                              = 0x80C9, // decimal value: 32969
    GL_BLEND_SRC_RGB_EXT                                          = 0x80C9, // decimal value: 32969
    GL_BLEND_DST_ALPHA                                            = 0x80CA, // decimal value: 32970
    GL_BLEND_DST_ALPHA_EXT                                        = 0x80CA, // decimal value: 32970
    GL_BLEND_SRC_ALPHA                                            = 0x80CB, // decimal value: 32971
    GL_BLEND_SRC_ALPHA_EXT                                        = 0x80CB, // decimal value: 32971
    GL_422_EXT                                                    = 0x80CC, // decimal value: 32972
    GL_422_REV_EXT                                                = 0x80CD, // decimal value: 32973
    GL_422_AVERAGE_EXT                                            = 0x80CE, // decimal value: 32974
    GL_422_REV_AVERAGE_EXT                                        = 0x80CF, // decimal value: 32975
    GL_BGR                                                        = 0x80E0, // decimal value: 32992
    GL_BGR_EXT                                                    = 0x80E0, // decimal value: 32992
    GL_BGRA                                                       = 0x80E1, // decimal value: 32993
    GL_BGRA_EXT                                                   = 0x80E1, // decimal value: 32993
    GL_COLOR_INDEX1_EXT                                           = 0x80E2, // decimal value: 32994
    GL_COLOR_INDEX2_EXT                                           = 0x80E3, // decimal value: 32995
    GL_COLOR_INDEX4_EXT                                           = 0x80E4, // decimal value: 32996
    GL_COLOR_INDEX8_EXT                                           = 0x80E5, // decimal value: 32997
    GL_COLOR_INDEX12_EXT                                          = 0x80E6, // decimal value: 32998
    GL_COLOR_INDEX16_EXT                                          = 0x80E7, // decimal value: 32999
    GL_MAX_ELEMENTS_VERTICES                                      = 0x80E8, // decimal value: 33000
    GL_MAX_ELEMENTS_VERTICES_EXT                                  = 0x80E8, // decimal value: 33000
    GL_MAX_ELEMENTS_INDICES                                       = 0x80E9, // decimal value: 33001
    GL_MAX_ELEMENTS_INDICES_EXT                                   = 0x80E9, // decimal value: 33001
    GL_PHONG_WIN                                                  = 0x80EA, // decimal value: 33002
    GL_FOG_SPECULAR_TEXTURE_WIN                                   = 0x80EC, // decimal value: 33004
    GL_TEXTURE_INDEX_SIZE_EXT                                     = 0x80ED, // decimal value: 33005
    GL_PARAMETER_BUFFER                                           = 0x80EE, // decimal value: 33006
    GL_PARAMETER_BUFFER_ARB                                       = 0x80EE, // decimal value: 33006
    GL_PARAMETER_BUFFER_BINDING                                   = 0x80EF, // decimal value: 33007
    GL_PARAMETER_BUFFER_BINDING_ARB                               = 0x80EF, // decimal value: 33007
    GL_SPRITE_AXIAL_SGIX                                          = 0x814C, // decimal value: 33100
    GL_SPRITE_OBJECT_ALIGNED_SGIX                                 = 0x814D, // decimal value: 33101
    GL_SPRITE_EYE_ALIGNED_SGIX                                    = 0x814E, // decimal value: 33102
    GL_IGNORE_BORDER_HP                                           = 0x8150, // decimal value: 33104
    GL_CONSTANT_BORDER                                            = 0x8151, // decimal value: 33105
    GL_CONSTANT_BORDER_HP                                         = 0x8151, // decimal value: 33105
    GL_REPLICATE_BORDER                                           = 0x8153, // decimal value: 33107
    GL_REPLICATE_BORDER_HP                                        = 0x8153, // decimal value: 33107
    GL_CONVOLUTION_BORDER_COLOR_HP                                = 0x8154, // decimal value: 33108
    GL_IMAGE_SCALE_X_HP                                           = 0x8155, // decimal value: 33109
    GL_IMAGE_SCALE_Y_HP                                           = 0x8156, // decimal value: 33110
    GL_IMAGE_TRANSLATE_X_HP                                       = 0x8157, // decimal value: 33111
    GL_IMAGE_TRANSLATE_Y_HP                                       = 0x8158, // decimal value: 33112
    GL_IMAGE_ROTATE_ANGLE_HP                                      = 0x8159, // decimal value: 33113
    GL_IMAGE_ROTATE_ORIGIN_X_HP                                   = 0x815A, // decimal value: 33114
    GL_IMAGE_ROTATE_ORIGIN_Y_HP                                   = 0x815B, // decimal value: 33115
    GL_IMAGE_MAG_FILTER_HP                                        = 0x815C, // decimal value: 33116
    GL_IMAGE_MIN_FILTER_HP                                        = 0x815D, // decimal value: 33117
    GL_IMAGE_CUBIC_WEIGHT_HP                                      = 0x815E, // decimal value: 33118
    GL_CUBIC_HP                                                   = 0x815F, // decimal value: 33119
    GL_AVERAGE_HP                                                 = 0x8160, // decimal value: 33120
    GL_IMAGE_TRANSFORM_2D_HP                                      = 0x8161, // decimal value: 33121
    GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP                        = 0x8162, // decimal value: 33122
    GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP                  = 0x8163, // decimal value: 33123
    GL_OCCLUSION_TEST_HP                                          = 0x8165, // decimal value: 33125
    GL_OCCLUSION_TEST_RESULT_HP                                   = 0x8166, // decimal value: 33126
    GL_TEXTURE_LIGHTING_MODE_HP                                   = 0x8167, // decimal value: 33127
    GL_TEXTURE_POST_SPECULAR_HP                                   = 0x8168, // decimal value: 33128
    GL_TEXTURE_PRE_SPECULAR_HP                                    = 0x8169, // decimal value: 33129
    GL_MAX_DEFORMATION_ORDER_SGIX                                 = 0x8197, // decimal value: 33175
    GL_DEPTH_COMPONENT24                                          = 0x81A6, // decimal value: 33190
    GL_DEPTH_COMPONENT32                                          = 0x81A7, // decimal value: 33191
    GL_ARRAY_ELEMENT_LOCK_FIRST_EXT                               = 0x81A8, // decimal value: 33192
    GL_ARRAY_ELEMENT_LOCK_COUNT_EXT                               = 0x81A9, // decimal value: 33193
    GL_CULL_VERTEX_EXT                                            = 0x81AA, // decimal value: 33194
    GL_CULL_VERTEX_EYE_POSITION_EXT                               = 0x81AB, // decimal value: 33195
    GL_CULL_VERTEX_OBJECT_POSITION_EXT                            = 0x81AC, // decimal value: 33196
    GL_IUI_V2F_EXT                                                = 0x81AD, // decimal value: 33197
    GL_IUI_V3F_EXT                                                = 0x81AE, // decimal value: 33198
    GL_IUI_N3F_V2F_EXT                                            = 0x81AF, // decimal value: 33199
    GL_IUI_N3F_V3F_EXT                                            = 0x81B0, // decimal value: 33200
    GL_T2F_IUI_V2F_EXT                                            = 0x81B1, // decimal value: 33201
    GL_T2F_IUI_V3F_EXT                                            = 0x81B2, // decimal value: 33202
    GL_T2F_IUI_N3F_V2F_EXT                                        = 0x81B3, // decimal value: 33203
    GL_T2F_IUI_N3F_V3F_EXT                                        = 0x81B4, // decimal value: 33204
    GL_INDEX_TEST_EXT                                             = 0x81B5, // decimal value: 33205
    GL_INDEX_TEST_FUNC_EXT                                        = 0x81B6, // decimal value: 33206
    GL_INDEX_TEST_REF_EXT                                         = 0x81B7, // decimal value: 33207
    GL_INDEX_MATERIAL_EXT                                         = 0x81B8, // decimal value: 33208
    GL_INDEX_MATERIAL_PARAMETER_EXT                               = 0x81B9, // decimal value: 33209
    GL_INDEX_MATERIAL_FACE_EXT                                    = 0x81BA, // decimal value: 33210
    GL_WRAP_BORDER_SUN                                            = 0x81D4, // decimal value: 33236
    GL_UNPACK_CONSTANT_DATA_SUNX                                  = 0x81D5, // decimal value: 33237
    GL_TEXTURE_CONSTANT_DATA_SUNX                                 = 0x81D6, // decimal value: 33238
    GL_TRIANGLE_LIST_SUN                                          = 0x81D7, // decimal value: 33239
    GL_REPLACEMENT_CODE_SUN                                       = 0x81D8, // decimal value: 33240
    GL_GLOBAL_ALPHA_SUN                                           = 0x81D9, // decimal value: 33241
    GL_GLOBAL_ALPHA_FACTOR_SUN                                    = 0x81DA, // decimal value: 33242
    GL_TEXTURE_COLOR_WRITEMASK_SGIS                               = 0x81EF, // decimal value: 33263
    GL_TEXT_FRAGMENT_SHADER_ATI                                   = 0x8200, // decimal value: 33280
    GL_FRAMEBUFFER_DEFAULT                                        = 0x8218, // decimal value: 33304
    GL_DEPTH_STENCIL_ATTACHMENT                                   = 0x821A, // decimal value: 33306
    GL_MAJOR_VERSION                                              = 0x821B, // decimal value: 33307
    GL_MINOR_VERSION                                              = 0x821C, // decimal value: 33308
    GL_NUM_EXTENSIONS                                             = 0x821D, // decimal value: 33309
    GL_CONTEXT_FLAGS                                              = 0x821E, // decimal value: 33310
    GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED                    = 0x8221, // decimal value: 33313
    GL_INDEX                                                      = 0x8222, // decimal value: 33314
    GL_RG_INTEGER                                                 = 0x8228, // decimal value: 33320
    GL_SYNC_CL_EVENT_ARB                                          = 0x8240, // decimal value: 33344
    GL_SYNC_CL_EVENT_COMPLETE_ARB                                 = 0x8241, // decimal value: 33345
    GL_DEBUG_OUTPUT_SYNCHRONOUS                                   = 0x8242, // decimal value: 33346
    GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB                               = 0x8242, // decimal value: 33346
    GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH                           = 0x8243, // decimal value: 33347
    GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB                       = 0x8243, // decimal value: 33347
    GL_DEBUG_CALLBACK_FUNCTION_ARB                                = 0x8244, // decimal value: 33348
    GL_DEBUG_CALLBACK_USER_PARAM_ARB                              = 0x8245, // decimal value: 33349
    GL_DEBUG_SOURCE_API_ARB                                       = 0x8246, // decimal value: 33350
    GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB                             = 0x8247, // decimal value: 33351
    GL_DEBUG_SOURCE_SHADER_COMPILER_ARB                           = 0x8248, // decimal value: 33352
    GL_DEBUG_SOURCE_THIRD_PARTY_ARB                               = 0x8249, // decimal value: 33353
    GL_DEBUG_SOURCE_APPLICATION_ARB                               = 0x824A, // decimal value: 33354
    GL_DEBUG_SOURCE_OTHER_ARB                                     = 0x824B, // decimal value: 33355
    GL_DEBUG_TYPE_ERROR_ARB                                       = 0x824C, // decimal value: 33356
    GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB                         = 0x824D, // decimal value: 33357
    GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB                          = 0x824E, // decimal value: 33358
    GL_DEBUG_TYPE_PORTABILITY_ARB                                 = 0x824F, // decimal value: 33359
    GL_DEBUG_TYPE_PERFORMANCE_ARB                                 = 0x8250, // decimal value: 33360
    GL_DEBUG_TYPE_OTHER_ARB                                       = 0x8251, // decimal value: 33361
    GL_LOSE_CONTEXT_ON_RESET                                      = 0x8252, // decimal value: 33362
    GL_LOSE_CONTEXT_ON_RESET_ARB                                  = 0x8252, // decimal value: 33362
    GL_GUILTY_CONTEXT_RESET_ARB                                   = 0x8253, // decimal value: 33363
    GL_INNOCENT_CONTEXT_RESET_ARB                                 = 0x8254, // decimal value: 33364
    GL_UNKNOWN_CONTEXT_RESET_ARB                                  = 0x8255, // decimal value: 33365
    GL_RESET_NOTIFICATION_STRATEGY                                = 0x8256, // decimal value: 33366
    GL_RESET_NOTIFICATION_STRATEGY_ARB                            = 0x8256, // decimal value: 33366
    GL_PROGRAM_PIPELINE_BINDING                                   = 0x825A, // decimal value: 33370
    GL_MAX_VIEWPORTS                                              = 0x825B, // decimal value: 33371
    GL_VIEWPORT_SUBPIXEL_BITS                                     = 0x825C, // decimal value: 33372
    GL_VIEWPORT_BOUNDS_RANGE                                      = 0x825D, // decimal value: 33373
    GL_LAYER_PROVOKING_VERTEX                                     = 0x825E, // decimal value: 33374
    GL_VIEWPORT_INDEX_PROVOKING_VERTEX                            = 0x825F, // decimal value: 33375
    GL_UNDEFINED_VERTEX                                           = 0x8260, // decimal value: 33376
    GL_NO_RESET_NOTIFICATION                                      = 0x8261, // decimal value: 33377
    GL_NO_RESET_NOTIFICATION_ARB                                  = 0x8261, // decimal value: 33377
    GL_MAX_COMPUTE_SHARED_MEMORY_SIZE                             = 0x8262, // decimal value: 33378
    GL_MAX_COMPUTE_UNIFORM_COMPONENTS                             = 0x8263, // decimal value: 33379
    GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS                         = 0x8264, // decimal value: 33380
    GL_MAX_COMPUTE_ATOMIC_COUNTERS                                = 0x8265, // decimal value: 33381
    GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS                    = 0x8266, // decimal value: 33382
    GL_DEBUG_SEVERITY_NOTIFICATION                                = 0x826B, // decimal value: 33387
    GL_MAX_DEBUG_GROUP_STACK_DEPTH                                = 0x826C, // decimal value: 33388
    GL_DEBUG_GROUP_STACK_DEPTH                                    = 0x826D, // decimal value: 33389
    GL_MAX_UNIFORM_LOCATIONS                                      = 0x826E, // decimal value: 33390
    GL_MAX_COMBINED_DIMENSIONS                                    = 0x8282, // decimal value: 33410
    GL_DEPTH_COMPONENTS                                           = 0x8284, // decimal value: 33412
    GL_STENCIL_COMPONENTS                                         = 0x8285, // decimal value: 33413
    GL_MANUAL_GENERATE_MIPMAP                                     = 0x8294, // decimal value: 33428
    GL_SRGB_DECODE_ARB                                            = 0x8299, // decimal value: 33433
    GL_FULL_SUPPORT                                               = 0x82B7, // decimal value: 33463
    GL_CAVEAT_SUPPORT                                             = 0x82B8, // decimal value: 33464
    GL_IMAGE_CLASS_4_X_32                                         = 0x82B9, // decimal value: 33465
    GL_IMAGE_CLASS_2_X_32                                         = 0x82BA, // decimal value: 33466
    GL_IMAGE_CLASS_1_X_32                                         = 0x82BB, // decimal value: 33467
    GL_IMAGE_CLASS_4_X_16                                         = 0x82BC, // decimal value: 33468
    GL_IMAGE_CLASS_2_X_16                                         = 0x82BD, // decimal value: 33469
    GL_IMAGE_CLASS_1_X_16                                         = 0x82BE, // decimal value: 33470
    GL_IMAGE_CLASS_4_X_8                                          = 0x82BF, // decimal value: 33471
    GL_IMAGE_CLASS_2_X_8                                          = 0x82C0, // decimal value: 33472
    GL_IMAGE_CLASS_1_X_8                                          = 0x82C1, // decimal value: 33473
    GL_IMAGE_CLASS_11_11_10                                       = 0x82C2, // decimal value: 33474
    GL_IMAGE_CLASS_10_10_10_2                                     = 0x82C3, // decimal value: 33475
    GL_VIEW_CLASS_128_BITS                                        = 0x82C4, // decimal value: 33476
    GL_VIEW_CLASS_96_BITS                                         = 0x82C5, // decimal value: 33477
    GL_VIEW_CLASS_64_BITS                                         = 0x82C6, // decimal value: 33478
    GL_VIEW_CLASS_48_BITS                                         = 0x82C7, // decimal value: 33479
    GL_VIEW_CLASS_32_BITS                                         = 0x82C8, // decimal value: 33480
    GL_VIEW_CLASS_24_BITS                                         = 0x82C9, // decimal value: 33481
    GL_VIEW_CLASS_16_BITS                                         = 0x82CA, // decimal value: 33482
    GL_VIEW_CLASS_8_BITS                                          = 0x82CB, // decimal value: 33483
    GL_VIEW_CLASS_S3TC_DXT1_RGB                                   = 0x82CC, // decimal value: 33484
    GL_VIEW_CLASS_S3TC_DXT1_RGBA                                  = 0x82CD, // decimal value: 33485
    GL_VIEW_CLASS_S3TC_DXT3_RGBA                                  = 0x82CE, // decimal value: 33486
    GL_VIEW_CLASS_S3TC_DXT5_RGBA                                  = 0x82CF, // decimal value: 33487
    GL_VIEW_CLASS_RGTC1_RED                                       = 0x82D0, // decimal value: 33488
    GL_VIEW_CLASS_RGTC2_RG                                        = 0x82D1, // decimal value: 33489
    GL_VIEW_CLASS_BPTC_UNORM                                      = 0x82D2, // decimal value: 33490
    GL_VIEW_CLASS_BPTC_FLOAT                                      = 0x82D3, // decimal value: 33491
    GL_VERTEX_ATTRIB_BINDING                                      = 0x82D4, // decimal value: 33492
    GL_VERTEX_BINDING_DIVISOR                                     = 0x82D6, // decimal value: 33494
    GL_VERTEX_BINDING_OFFSET                                      = 0x82D7, // decimal value: 33495
    GL_VERTEX_BINDING_STRIDE                                      = 0x82D8, // decimal value: 33496
    GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET                          = 0x82D9, // decimal value: 33497
    GL_MAX_VERTEX_ATTRIB_BINDINGS                                 = 0x82DA, // decimal value: 33498
    GL_TEXTURE_VIEW_MIN_LEVEL                                     = 0x82DB, // decimal value: 33499
    GL_TEXTURE_VIEW_NUM_LEVELS                                    = 0x82DC, // decimal value: 33500
    GL_TEXTURE_VIEW_MIN_LAYER                                     = 0x82DD, // decimal value: 33501
    GL_TEXTURE_VIEW_NUM_LAYERS                                    = 0x82DE, // decimal value: 33502
    GL_TEXTURE_IMMUTABLE_LEVELS                                   = 0x82DF, // decimal value: 33503
    GL_MAX_VERTEX_ATTRIB_STRIDE                                   = 0x82E5, // decimal value: 33509
    GL_DISPLAY_LIST                                               = 0x82E7, // decimal value: 33511
    GL_MAX_LABEL_LENGTH                                           = 0x82E8, // decimal value: 33512
    GL_NUM_SHADING_LANGUAGE_VERSIONS                              = 0x82E9, // decimal value: 33513
    GL_TRANSFORM_FEEDBACK_OVERFLOW                                = 0x82EC, // decimal value: 33516
    GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB                            = 0x82EC, // decimal value: 33516
    GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW                         = 0x82ED, // decimal value: 33517
    GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB                     = 0x82ED, // decimal value: 33517
    GL_VERTICES_SUBMITTED                                         = 0x82EE, // decimal value: 33518
    GL_VERTICES_SUBMITTED_ARB                                     = 0x82EE, // decimal value: 33518
    GL_PRIMITIVES_SUBMITTED                                       = 0x82EF, // decimal value: 33519
    GL_PRIMITIVES_SUBMITTED_ARB                                   = 0x82EF, // decimal value: 33519
    GL_VERTEX_SHADER_INVOCATIONS                                  = 0x82F0, // decimal value: 33520
    GL_VERTEX_SHADER_INVOCATIONS_ARB                              = 0x82F0, // decimal value: 33520
    GL_TESS_CONTROL_SHADER_PATCHES                                = 0x82F1, // decimal value: 33521
    GL_TESS_CONTROL_SHADER_PATCHES_ARB                            = 0x82F1, // decimal value: 33521
    GL_TESS_EVALUATION_SHADER_INVOCATIONS                         = 0x82F2, // decimal value: 33522
    GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB                     = 0x82F2, // decimal value: 33522
    GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED                         = 0x82F3, // decimal value: 33523
    GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB                     = 0x82F3, // decimal value: 33523
    GL_FRAGMENT_SHADER_INVOCATIONS                                = 0x82F4, // decimal value: 33524
    GL_FRAGMENT_SHADER_INVOCATIONS_ARB                            = 0x82F4, // decimal value: 33524
    GL_COMPUTE_SHADER_INVOCATIONS                                 = 0x82F5, // decimal value: 33525
    GL_COMPUTE_SHADER_INVOCATIONS_ARB                             = 0x82F5, // decimal value: 33525
    GL_CLIPPING_INPUT_PRIMITIVES                                  = 0x82F6, // decimal value: 33526
    GL_CLIPPING_INPUT_PRIMITIVES_ARB                              = 0x82F6, // decimal value: 33526
    GL_CLIPPING_OUTPUT_PRIMITIVES                                 = 0x82F7, // decimal value: 33527
    GL_CLIPPING_OUTPUT_PRIMITIVES_ARB                             = 0x82F7, // decimal value: 33527
    GL_SPARSE_BUFFER_PAGE_SIZE_ARB                                = 0x82F8, // decimal value: 33528
    GL_MAX_CULL_DISTANCES                                         = 0x82F9, // decimal value: 33529
    GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES                       = 0x82FA, // decimal value: 33530
    GL_CONTEXT_RELEASE_BEHAVIOR                                   = 0x82FB, // decimal value: 33531
    GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH                             = 0x82FC, // decimal value: 33532
    GL_YCRCB_SGIX                                                 = 0x8318, // decimal value: 33560
    GL_YCRCBA_SGIX                                                = 0x8319, // decimal value: 33561
    GL_PIXEL_TRANSFORM_2D_EXT                                     = 0x8330, // decimal value: 33584
    GL_PIXEL_MAG_FILTER_EXT                                       = 0x8331, // decimal value: 33585
    GL_PIXEL_MIN_FILTER_EXT                                       = 0x8332, // decimal value: 33586
    GL_PIXEL_CUBIC_WEIGHT_EXT                                     = 0x8333, // decimal value: 33587
    GL_CUBIC_EXT                                                  = 0x8334, // decimal value: 33588
    GL_AVERAGE_EXT                                                = 0x8335, // decimal value: 33589
    GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT                         = 0x8336, // decimal value: 33590
    GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT                     = 0x8337, // decimal value: 33591
    GL_PIXEL_TRANSFORM_2D_MATRIX_EXT                              = 0x8338, // decimal value: 33592
    GL_FRAGMENT_MATERIAL_EXT                                      = 0x8349, // decimal value: 33609
    GL_FRAGMENT_NORMAL_EXT                                        = 0x834A, // decimal value: 33610
    GL_FRAGMENT_COLOR_EXT                                         = 0x834C, // decimal value: 33612
    GL_ATTENUATION_EXT                                            = 0x834D, // decimal value: 33613
    GL_SHADOW_ATTENUATION_EXT                                     = 0x834E, // decimal value: 33614
    GL_TEXTURE_APPLICATION_MODE_EXT                               = 0x834F, // decimal value: 33615
    GL_TEXTURE_LIGHT_EXT                                          = 0x8350, // decimal value: 33616
    GL_TEXTURE_MATERIAL_FACE_EXT                                  = 0x8351, // decimal value: 33617
    GL_TEXTURE_MATERIAL_PARAMETER_EXT                             = 0x8352, // decimal value: 33618
    GL_PIXEL_GROUP_COLOR_SGIS                                     = 0x8356, // decimal value: 33622
    GL_UNSIGNED_BYTE_2_3_3_REV                                    = 0x8362, // decimal value: 33634
    GL_UNSIGNED_SHORT_5_6_5                                       = 0x8363, // decimal value: 33635
    GL_UNSIGNED_SHORT_5_6_5_REV                                   = 0x8364, // decimal value: 33636
    GL_UNSIGNED_SHORT_4_4_4_4_REV                                 = 0x8365, // decimal value: 33637
    GL_UNSIGNED_SHORT_1_5_5_5_REV                                 = 0x8366, // decimal value: 33638
    GL_UNSIGNED_INT_8_8_8_8_REV                                   = 0x8367, // decimal value: 33639
    GL_MIRRORED_REPEAT                                            = 0x8370, // decimal value: 33648
    GL_MIRRORED_REPEAT_ARB                                        = 0x8370, // decimal value: 33648
    GL_MIRRORED_REPEAT_IBM                                        = 0x8370, // decimal value: 33648
    GL_RGB_S3TC                                                   = 0x83A0, // decimal value: 33696
    GL_RGB4_S3TC                                                  = 0x83A1, // decimal value: 33697
    GL_RGBA_S3TC                                                  = 0x83A2, // decimal value: 33698
    GL_RGBA4_S3TC                                                 = 0x83A3, // decimal value: 33699
    GL_RGBA_DXT5_S3TC                                             = 0x83A4, // decimal value: 33700
    GL_RGBA4_DXT5_S3TC                                            = 0x83A5, // decimal value: 33701
    GL_PARALLEL_ARRAYS_INTEL                                      = 0x83F4, // decimal value: 33780
    GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL                       = 0x83F5, // decimal value: 33781
    GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL                       = 0x83F6, // decimal value: 33782
    GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL                        = 0x83F7, // decimal value: 33783
    GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL                = 0x83F8, // decimal value: 33784
    GL_PERFQUERY_DONOT_FLUSH_INTEL                                = 0x83F9, // decimal value: 33785
    GL_PERFQUERY_FLUSH_INTEL                                      = 0x83FA, // decimal value: 33786
    GL_PERFQUERY_WAIT_INTEL                                       = 0x83FB, // decimal value: 33787
    GL_BLACKHOLE_RENDER_INTEL                                     = 0x83FC, // decimal value: 33788
    GL_CONSERVATIVE_RASTERIZATION_INTEL                           = 0x83FE, // decimal value: 33790
    GL_TEXTURE_MEMORY_LAYOUT_INTEL                                = 0x83FF, // decimal value: 33791
    GL_CURRENT_RASTER_NORMAL_SGIX                                 = 0x8406, // decimal value: 33798
    GL_TANGENT_ARRAY_EXT                                          = 0x8439, // decimal value: 33849
    GL_BINORMAL_ARRAY_EXT                                         = 0x843A, // decimal value: 33850
    GL_CURRENT_TANGENT_EXT                                        = 0x843B, // decimal value: 33851
    GL_CURRENT_BINORMAL_EXT                                       = 0x843C, // decimal value: 33852
    GL_TANGENT_ARRAY_TYPE_EXT                                     = 0x843E, // decimal value: 33854
    GL_TANGENT_ARRAY_STRIDE_EXT                                   = 0x843F, // decimal value: 33855
    GL_BINORMAL_ARRAY_TYPE_EXT                                    = 0x8440, // decimal value: 33856
    GL_BINORMAL_ARRAY_STRIDE_EXT                                  = 0x8441, // decimal value: 33857
    GL_TANGENT_ARRAY_POINTER_EXT                                  = 0x8442, // decimal value: 33858
    GL_BINORMAL_ARRAY_POINTER_EXT                                 = 0x8443, // decimal value: 33859
    GL_MAP1_TANGENT_EXT                                           = 0x8444, // decimal value: 33860
    GL_MAP2_TANGENT_EXT                                           = 0x8445, // decimal value: 33861
    GL_MAP1_BINORMAL_EXT                                          = 0x8446, // decimal value: 33862
    GL_MAP2_BINORMAL_EXT                                          = 0x8447, // decimal value: 33863
    GL_FOG_COORDINATE_SOURCE                                      = 0x8450, // decimal value: 33872
    GL_FOG_COORDINATE_SOURCE_EXT                                  = 0x8450, // decimal value: 33872
    GL_FOG_COORD                                                  = 0x8451, // decimal value: 33873
    GL_FOG_COORDINATE                                             = 0x8451, // decimal value: 33873
    GL_FOG_COORDINATE_EXT                                         = 0x8451, // decimal value: 33873
    GL_FRAGMENT_DEPTH                                             = 0x8452, // decimal value: 33874
    GL_FRAGMENT_DEPTH_EXT                                         = 0x8452, // decimal value: 33874
    GL_CURRENT_FOG_COORD                                          = 0x8453, // decimal value: 33875
    GL_CURRENT_FOG_COORDINATE                                     = 0x8453, // decimal value: 33875
    GL_CURRENT_FOG_COORDINATE_EXT                                 = 0x8453, // decimal value: 33875
    GL_FOG_COORDINATE_ARRAY_TYPE                                  = 0x8454, // decimal value: 33876
    GL_FOG_COORDINATE_ARRAY_TYPE_EXT                              = 0x8454, // decimal value: 33876
    GL_FOG_COORD_ARRAY_TYPE                                       = 0x8454, // decimal value: 33876
    GL_FOG_COORDINATE_ARRAY_STRIDE                                = 0x8455, // decimal value: 33877
    GL_FOG_COORDINATE_ARRAY_STRIDE_EXT                            = 0x8455, // decimal value: 33877
    GL_FOG_COORD_ARRAY_STRIDE                                     = 0x8455, // decimal value: 33877
    GL_FOG_COORDINATE_ARRAY_POINTER                               = 0x8456, // decimal value: 33878
    GL_FOG_COORDINATE_ARRAY_POINTER_EXT                           = 0x8456, // decimal value: 33878
    GL_FOG_COORD_ARRAY_POINTER                                    = 0x8456, // decimal value: 33878
    GL_FOG_COORDINATE_ARRAY                                       = 0x8457, // decimal value: 33879
    GL_FOG_COORDINATE_ARRAY_EXT                                   = 0x8457, // decimal value: 33879
    GL_FOG_COORD_ARRAY                                            = 0x8457, // decimal value: 33879
    GL_COLOR_SUM                                                  = 0x8458, // decimal value: 33880
    GL_COLOR_SUM_ARB                                              = 0x8458, // decimal value: 33880
    GL_COLOR_SUM_EXT                                              = 0x8458, // decimal value: 33880
    GL_CURRENT_SECONDARY_COLOR                                    = 0x8459, // decimal value: 33881
    GL_CURRENT_SECONDARY_COLOR_EXT                                = 0x8459, // decimal value: 33881
    GL_SECONDARY_COLOR_ARRAY_SIZE                                 = 0x845A, // decimal value: 33882
    GL_SECONDARY_COLOR_ARRAY_SIZE_EXT                             = 0x845A, // decimal value: 33882
    GL_SECONDARY_COLOR_ARRAY_TYPE                                 = 0x845B, // decimal value: 33883
    GL_SECONDARY_COLOR_ARRAY_TYPE_EXT                             = 0x845B, // decimal value: 33883
    GL_SECONDARY_COLOR_ARRAY_STRIDE                               = 0x845C, // decimal value: 33884
    GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT                           = 0x845C, // decimal value: 33884
    GL_SECONDARY_COLOR_ARRAY_POINTER                              = 0x845D, // decimal value: 33885
    GL_SECONDARY_COLOR_ARRAY_POINTER_EXT                          = 0x845D, // decimal value: 33885
    GL_SECONDARY_COLOR_ARRAY                                      = 0x845E, // decimal value: 33886
    GL_SECONDARY_COLOR_ARRAY_EXT                                  = 0x845E, // decimal value: 33886
    GL_CURRENT_RASTER_SECONDARY_COLOR                             = 0x845F, // decimal value: 33887
    GL_SCREEN_COORDINATES_REND                                    = 0x8490, // decimal value: 33936
    GL_INVERTED_SCREEN_W_REND                                     = 0x8491, // decimal value: 33937
    GL_TEXTURE0_ARB                                               = 0x84C0, // decimal value: 33984
    GL_TEXTURE1_ARB                                               = 0x84C1, // decimal value: 33985
    GL_TEXTURE2_ARB                                               = 0x84C2, // decimal value: 33986
    GL_TEXTURE3_ARB                                               = 0x84C3, // decimal value: 33987
    GL_TEXTURE4_ARB                                               = 0x84C4, // decimal value: 33988
    GL_TEXTURE5_ARB                                               = 0x84C5, // decimal value: 33989
    GL_TEXTURE6_ARB                                               = 0x84C6, // decimal value: 33990
    GL_TEXTURE7_ARB                                               = 0x84C7, // decimal value: 33991
    GL_TEXTURE8_ARB                                               = 0x84C8, // decimal value: 33992
    GL_TEXTURE9_ARB                                               = 0x84C9, // decimal value: 33993
    GL_TEXTURE10_ARB                                              = 0x84CA, // decimal value: 33994
    GL_TEXTURE11_ARB                                              = 0x84CB, // decimal value: 33995
    GL_TEXTURE12_ARB                                              = 0x84CC, // decimal value: 33996
    GL_TEXTURE13_ARB                                              = 0x84CD, // decimal value: 33997
    GL_TEXTURE14_ARB                                              = 0x84CE, // decimal value: 33998
    GL_TEXTURE15_ARB                                              = 0x84CF, // decimal value: 33999
    GL_TEXTURE16_ARB                                              = 0x84D0, // decimal value: 34000
    GL_TEXTURE17_ARB                                              = 0x84D1, // decimal value: 34001
    GL_TEXTURE18_ARB                                              = 0x84D2, // decimal value: 34002
    GL_TEXTURE19_ARB                                              = 0x84D3, // decimal value: 34003
    GL_TEXTURE20_ARB                                              = 0x84D4, // decimal value: 34004
    GL_TEXTURE21_ARB                                              = 0x84D5, // decimal value: 34005
    GL_TEXTURE22_ARB                                              = 0x84D6, // decimal value: 34006
    GL_TEXTURE23_ARB                                              = 0x84D7, // decimal value: 34007
    GL_TEXTURE24_ARB                                              = 0x84D8, // decimal value: 34008
    GL_TEXTURE25_ARB                                              = 0x84D9, // decimal value: 34009
    GL_TEXTURE26_ARB                                              = 0x84DA, // decimal value: 34010
    GL_TEXTURE27_ARB                                              = 0x84DB, // decimal value: 34011
    GL_TEXTURE28_ARB                                              = 0x84DC, // decimal value: 34012
    GL_TEXTURE29_ARB                                              = 0x84DD, // decimal value: 34013
    GL_TEXTURE30_ARB                                              = 0x84DE, // decimal value: 34014
    GL_TEXTURE31_ARB                                              = 0x84DF, // decimal value: 34015
    GL_ACTIVE_TEXTURE                                             = 0x84E0, // decimal value: 34016
    GL_ACTIVE_TEXTURE_ARB                                         = 0x84E0, // decimal value: 34016
    GL_CLIENT_ACTIVE_TEXTURE                                      = 0x84E1, // decimal value: 34017
    GL_CLIENT_ACTIVE_TEXTURE_ARB                                  = 0x84E1, // decimal value: 34017
    GL_MAX_TEXTURE_UNITS                                          = 0x84E2, // decimal value: 34018
    GL_MAX_TEXTURE_UNITS_ARB                                      = 0x84E2, // decimal value: 34018
    GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV                         = 0x84E3, // decimal value: 34019
    GL_TRANSPOSE_MODELVIEW_MATRIX                                 = 0x84E3, // decimal value: 34019
    GL_TRANSPOSE_MODELVIEW_MATRIX_ARB                             = 0x84E3, // decimal value: 34019
    GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV                        = 0x84E4, // decimal value: 34020
    GL_TRANSPOSE_PROJECTION_MATRIX                                = 0x84E4, // decimal value: 34020
    GL_TRANSPOSE_PROJECTION_MATRIX_ARB                            = 0x84E4, // decimal value: 34020
    GL_TRANSPOSE_TEXTURE_MATRIX                                   = 0x84E5, // decimal value: 34021
    GL_TRANSPOSE_TEXTURE_MATRIX_ARB                               = 0x84E5, // decimal value: 34021
    GL_TRANSPOSE_COLOR_MATRIX                                     = 0x84E6, // decimal value: 34022
    GL_TRANSPOSE_COLOR_MATRIX_ARB                                 = 0x84E6, // decimal value: 34022
    GL_SUBTRACT                                                   = 0x84E7, // decimal value: 34023
    GL_SUBTRACT_ARB                                               = 0x84E7, // decimal value: 34023
    GL_MAX_RENDERBUFFER_SIZE                                      = 0x84E8, // decimal value: 34024
    GL_MAX_RENDERBUFFER_SIZE_EXT                                  = 0x84E8, // decimal value: 34024
    GL_COMPRESSED_ALPHA                                           = 0x84E9, // decimal value: 34025
    GL_COMPRESSED_ALPHA_ARB                                       = 0x84E9, // decimal value: 34025
    GL_COMPRESSED_LUMINANCE                                       = 0x84EA, // decimal value: 34026
    GL_COMPRESSED_LUMINANCE_ARB                                   = 0x84EA, // decimal value: 34026
    GL_COMPRESSED_LUMINANCE_ALPHA                                 = 0x84EB, // decimal value: 34027
    GL_COMPRESSED_LUMINANCE_ALPHA_ARB                             = 0x84EB, // decimal value: 34027
    GL_COMPRESSED_INTENSITY                                       = 0x84EC, // decimal value: 34028
    GL_COMPRESSED_INTENSITY_ARB                                   = 0x84EC, // decimal value: 34028
    GL_COMPRESSED_RGB_ARB                                         = 0x84ED, // decimal value: 34029
    GL_COMPRESSED_RGBA_ARB                                        = 0x84EE, // decimal value: 34030
    GL_ALL_COMPLETED_NV                                           = 0x84F2, // decimal value: 34034
    GL_FENCE_STATUS_NV                                            = 0x84F3, // decimal value: 34035
    GL_FENCE_CONDITION_NV                                         = 0x84F4, // decimal value: 34036
    GL_TEXTURE_RECTANGLE_ARB                                      = 0x84F5, // decimal value: 34037
    GL_TEXTURE_RECTANGLE_NV                                       = 0x84F5, // decimal value: 34037
    GL_TEXTURE_BINDING_RECTANGLE                                  = 0x84F6, // decimal value: 34038
    GL_TEXTURE_BINDING_RECTANGLE_ARB                              = 0x84F6, // decimal value: 34038
    GL_TEXTURE_BINDING_RECTANGLE_NV                               = 0x84F6, // decimal value: 34038
    GL_MAX_RECTANGLE_TEXTURE_SIZE                                 = 0x84F8, // decimal value: 34040
    GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB                             = 0x84F8, // decimal value: 34040
    GL_MAX_RECTANGLE_TEXTURE_SIZE_NV                              = 0x84F8, // decimal value: 34040
    GL_UNSIGNED_INT_24_8                                          = 0x84FA, // decimal value: 34042
    GL_UNSIGNED_INT_24_8_EXT                                      = 0x84FA, // decimal value: 34042
    GL_UNSIGNED_INT_24_8_NV                                       = 0x84FA, // decimal value: 34042
    GL_MAX_TEXTURE_LOD_BIAS                                       = 0x84FD, // decimal value: 34045
    GL_MAX_TEXTURE_LOD_BIAS_EXT                                   = 0x84FD, // decimal value: 34045
    GL_TEXTURE_MAX_ANISOTROPY                                     = 0x84FE, // decimal value: 34046
    GL_TEXTURE_MAX_ANISOTROPY_EXT                                 = 0x84FE, // decimal value: 34046
    GL_MAX_TEXTURE_MAX_ANISOTROPY                                 = 0x84FF, // decimal value: 34047
    GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT                             = 0x84FF, // decimal value: 34047
    GL_TEXTURE_FILTER_CONTROL                                     = 0x8500, // decimal value: 34048
    GL_TEXTURE_FILTER_CONTROL_EXT                                 = 0x8500, // decimal value: 34048
    GL_TEXTURE_LOD_BIAS_EXT                                       = 0x8501, // decimal value: 34049
    GL_MODELVIEW1_STACK_DEPTH_EXT                                 = 0x8502, // decimal value: 34050
    GL_COMBINE4_NV                                                = 0x8503, // decimal value: 34051
    GL_MAX_SHININESS_NV                                           = 0x8504, // decimal value: 34052
    GL_MAX_SPOT_EXPONENT_NV                                       = 0x8505, // decimal value: 34053
    GL_MODELVIEW1_MATRIX_EXT                                      = 0x8506, // decimal value: 34054
    GL_INCR_WRAP                                                  = 0x8507, // decimal value: 34055
    GL_INCR_WRAP_EXT                                              = 0x8507, // decimal value: 34055
    GL_DECR_WRAP                                                  = 0x8508, // decimal value: 34056
    GL_DECR_WRAP_EXT                                              = 0x8508, // decimal value: 34056
    GL_VERTEX_WEIGHTING_EXT                                       = 0x8509, // decimal value: 34057
    GL_MODELVIEW1_ARB                                             = 0x850A, // decimal value: 34058
    GL_MODELVIEW1_EXT                                             = 0x850A, // decimal value: 34058
    GL_CURRENT_VERTEX_WEIGHT_EXT                                  = 0x850B, // decimal value: 34059
    GL_VERTEX_WEIGHT_ARRAY_EXT                                    = 0x850C, // decimal value: 34060
    GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT                               = 0x850D, // decimal value: 34061
    GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT                               = 0x850E, // decimal value: 34062
    GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT                             = 0x850F, // decimal value: 34063
    GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT                            = 0x8510, // decimal value: 34064
    GL_NORMAL_MAP                                                 = 0x8511, // decimal value: 34065
    GL_NORMAL_MAP_ARB                                             = 0x8511, // decimal value: 34065
    GL_NORMAL_MAP_EXT                                             = 0x8511, // decimal value: 34065
    GL_NORMAL_MAP_NV                                              = 0x8511, // decimal value: 34065
    GL_REFLECTION_MAP                                             = 0x8512, // decimal value: 34066
    GL_REFLECTION_MAP_ARB                                         = 0x8512, // decimal value: 34066
    GL_REFLECTION_MAP_EXT                                         = 0x8512, // decimal value: 34066
    GL_REFLECTION_MAP_NV                                          = 0x8512, // decimal value: 34066
    GL_TEXTURE_CUBE_MAP_ARB                                       = 0x8513, // decimal value: 34067
    GL_TEXTURE_CUBE_MAP_EXT                                       = 0x8513, // decimal value: 34067
    GL_TEXTURE_BINDING_CUBE_MAP                                   = 0x8514, // decimal value: 34068
    GL_TEXTURE_BINDING_CUBE_MAP_ARB                               = 0x8514, // decimal value: 34068
    GL_TEXTURE_BINDING_CUBE_MAP_EXT                               = 0x8514, // decimal value: 34068
    GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                            = 0x8515, // decimal value: 34069
    GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT                            = 0x8515, // decimal value: 34069
    GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                            = 0x8516, // decimal value: 34070
    GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT                            = 0x8516, // decimal value: 34070
    GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                            = 0x8517, // decimal value: 34071
    GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT                            = 0x8517, // decimal value: 34071
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                            = 0x8518, // decimal value: 34072
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT                            = 0x8518, // decimal value: 34072
    GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                            = 0x8519, // decimal value: 34073
    GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT                            = 0x8519, // decimal value: 34073
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                            = 0x851A, // decimal value: 34074
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT                            = 0x851A, // decimal value: 34074
    GL_MAX_CUBE_MAP_TEXTURE_SIZE                                  = 0x851C, // decimal value: 34076
    GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB                              = 0x851C, // decimal value: 34076
    GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT                              = 0x851C, // decimal value: 34076
    GL_VERTEX_ARRAY_RANGE_APPLE                                   = 0x851D, // decimal value: 34077
    GL_VERTEX_ARRAY_RANGE_NV                                      = 0x851D, // decimal value: 34077
    GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE                            = 0x851E, // decimal value: 34078
    GL_VERTEX_ARRAY_RANGE_LENGTH_NV                               = 0x851E, // decimal value: 34078
    GL_VERTEX_ARRAY_RANGE_VALID_NV                                = 0x851F, // decimal value: 34079
    GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV                          = 0x8520, // decimal value: 34080
    GL_VERTEX_ARRAY_RANGE_POINTER_APPLE                           = 0x8521, // decimal value: 34081
    GL_VERTEX_ARRAY_RANGE_POINTER_NV                              = 0x8521, // decimal value: 34081
    GL_REGISTER_COMBINERS_NV                                      = 0x8522, // decimal value: 34082
    GL_VARIABLE_A_NV                                              = 0x8523, // decimal value: 34083
    GL_VARIABLE_B_NV                                              = 0x8524, // decimal value: 34084
    GL_VARIABLE_C_NV                                              = 0x8525, // decimal value: 34085
    GL_VARIABLE_D_NV                                              = 0x8526, // decimal value: 34086
    GL_VARIABLE_E_NV                                              = 0x8527, // decimal value: 34087
    GL_VARIABLE_F_NV                                              = 0x8528, // decimal value: 34088
    GL_VARIABLE_G_NV                                              = 0x8529, // decimal value: 34089
    GL_CONSTANT_COLOR0_NV                                         = 0x852A, // decimal value: 34090
    GL_CONSTANT_COLOR1_NV                                         = 0x852B, // decimal value: 34091
    GL_SPARE0_NV                                                  = 0x852E, // decimal value: 34094
    GL_SPARE1_NV                                                  = 0x852F, // decimal value: 34095
    GL_DISCARD_NV                                                 = 0x8530, // decimal value: 34096
    GL_E_TIMES_F_NV                                               = 0x8531, // decimal value: 34097
    GL_SPARE0_PLUS_SECONDARY_COLOR_NV                             = 0x8532, // decimal value: 34098
    GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV                        = 0x8533, // decimal value: 34099
    GL_PER_STAGE_CONSTANTS_NV                                     = 0x8535, // decimal value: 34101
    GL_UNSIGNED_IDENTITY_NV                                       = 0x8536, // decimal value: 34102
    GL_UNSIGNED_INVERT_NV                                         = 0x8537, // decimal value: 34103
    GL_EXPAND_NORMAL_NV                                           = 0x8538, // decimal value: 34104
    GL_EXPAND_NEGATE_NV                                           = 0x8539, // decimal value: 34105
    GL_HALF_BIAS_NORMAL_NV                                        = 0x853A, // decimal value: 34106
    GL_HALF_BIAS_NEGATE_NV                                        = 0x853B, // decimal value: 34107
    GL_SIGNED_IDENTITY_NV                                         = 0x853C, // decimal value: 34108
    GL_SIGNED_NEGATE_NV                                           = 0x853D, // decimal value: 34109
    GL_SCALE_BY_TWO_NV                                            = 0x853E, // decimal value: 34110
    GL_SCALE_BY_FOUR_NV                                           = 0x853F, // decimal value: 34111
    GL_SCALE_BY_ONE_HALF_NV                                       = 0x8540, // decimal value: 34112
    GL_BIAS_BY_NEGATIVE_ONE_HALF_NV                               = 0x8541, // decimal value: 34113
    GL_COMBINER_INPUT_NV                                          = 0x8542, // decimal value: 34114
    GL_COMBINER_MAPPING_NV                                        = 0x8543, // decimal value: 34115
    GL_COMBINER_COMPONENT_USAGE_NV                                = 0x8544, // decimal value: 34116
    GL_COMBINER_AB_DOT_PRODUCT_NV                                 = 0x8545, // decimal value: 34117
    GL_COMBINER_CD_DOT_PRODUCT_NV                                 = 0x8546, // decimal value: 34118
    GL_COMBINER_MUX_SUM_NV                                        = 0x8547, // decimal value: 34119
    GL_COMBINER_SCALE_NV                                          = 0x8548, // decimal value: 34120
    GL_COMBINER_BIAS_NV                                           = 0x8549, // decimal value: 34121
    GL_COMBINER_AB_OUTPUT_NV                                      = 0x854A, // decimal value: 34122
    GL_COMBINER_CD_OUTPUT_NV                                      = 0x854B, // decimal value: 34123
    GL_COMBINER_SUM_OUTPUT_NV                                     = 0x854C, // decimal value: 34124
    GL_MAX_GENERAL_COMBINERS_NV                                   = 0x854D, // decimal value: 34125
    GL_NUM_GENERAL_COMBINERS_NV                                   = 0x854E, // decimal value: 34126
    GL_COLOR_SUM_CLAMP_NV                                         = 0x854F, // decimal value: 34127
    GL_COMBINER0_NV                                               = 0x8550, // decimal value: 34128
    GL_COMBINER1_NV                                               = 0x8551, // decimal value: 34129
    GL_COMBINER2_NV                                               = 0x8552, // decimal value: 34130
    GL_COMBINER3_NV                                               = 0x8553, // decimal value: 34131
    GL_COMBINER4_NV                                               = 0x8554, // decimal value: 34132
    GL_COMBINER5_NV                                               = 0x8555, // decimal value: 34133
    GL_COMBINER6_NV                                               = 0x8556, // decimal value: 34134
    GL_COMBINER7_NV                                               = 0x8557, // decimal value: 34135
    GL_PRIMITIVE_RESTART_NV                                       = 0x8558, // decimal value: 34136
    GL_PRIMITIVE_RESTART_INDEX_NV                                 = 0x8559, // decimal value: 34137
    GL_FOG_DISTANCE_MODE_NV                                       = 0x855A, // decimal value: 34138
    GL_EYE_RADIAL_NV                                              = 0x855B, // decimal value: 34139
    GL_EYE_PLANE_ABSOLUTE_NV                                      = 0x855C, // decimal value: 34140
    GL_EMBOSS_LIGHT_NV                                            = 0x855D, // decimal value: 34141
    GL_EMBOSS_CONSTANT_NV                                         = 0x855E, // decimal value: 34142
    GL_EMBOSS_MAP_NV                                              = 0x855F, // decimal value: 34143
    GL_RED_MIN_CLAMP_INGR                                         = 0x8560, // decimal value: 34144
    GL_GREEN_MIN_CLAMP_INGR                                       = 0x8561, // decimal value: 34145
    GL_BLUE_MIN_CLAMP_INGR                                        = 0x8562, // decimal value: 34146
    GL_ALPHA_MIN_CLAMP_INGR                                       = 0x8563, // decimal value: 34147
    GL_RED_MAX_CLAMP_INGR                                         = 0x8564, // decimal value: 34148
    GL_GREEN_MAX_CLAMP_INGR                                       = 0x8565, // decimal value: 34149
    GL_BLUE_MAX_CLAMP_INGR                                        = 0x8566, // decimal value: 34150
    GL_ALPHA_MAX_CLAMP_INGR                                       = 0x8567, // decimal value: 34151
    GL_INTERLACE_READ_INGR                                        = 0x8568, // decimal value: 34152
    GL_COMBINE                                                    = 0x8570, // decimal value: 34160
    GL_COMBINE_ARB                                                = 0x8570, // decimal value: 34160
    GL_COMBINE_EXT                                                = 0x8570, // decimal value: 34160
    GL_COMBINE_RGB                                                = 0x8571, // decimal value: 34161
    GL_COMBINE_RGB_ARB                                            = 0x8571, // decimal value: 34161
    GL_COMBINE_RGB_EXT                                            = 0x8571, // decimal value: 34161
    GL_COMBINE_ALPHA                                              = 0x8572, // decimal value: 34162
    GL_COMBINE_ALPHA_ARB                                          = 0x8572, // decimal value: 34162
    GL_COMBINE_ALPHA_EXT                                          = 0x8572, // decimal value: 34162
    GL_RGB_SCALE                                                  = 0x8573, // decimal value: 34163
    GL_RGB_SCALE_ARB                                              = 0x8573, // decimal value: 34163
    GL_RGB_SCALE_EXT                                              = 0x8573, // decimal value: 34163
    GL_ADD_SIGNED                                                 = 0x8574, // decimal value: 34164
    GL_ADD_SIGNED_ARB                                             = 0x8574, // decimal value: 34164
    GL_ADD_SIGNED_EXT                                             = 0x8574, // decimal value: 34164
    GL_INTERPOLATE                                                = 0x8575, // decimal value: 34165
    GL_INTERPOLATE_ARB                                            = 0x8575, // decimal value: 34165
    GL_INTERPOLATE_EXT                                            = 0x8575, // decimal value: 34165
    GL_CONSTANT_ARB                                               = 0x8576, // decimal value: 34166
    GL_CONSTANT_EXT                                               = 0x8576, // decimal value: 34166
    GL_CONSTANT_NV                                                = 0x8576, // decimal value: 34166
    GL_PRIMARY_COLOR_ARB                                          = 0x8577, // decimal value: 34167
    GL_PRIMARY_COLOR_EXT                                          = 0x8577, // decimal value: 34167
    GL_PREVIOUS                                                   = 0x8578, // decimal value: 34168
    GL_PREVIOUS_ARB                                               = 0x8578, // decimal value: 34168
    GL_PREVIOUS_EXT                                               = 0x8578, // decimal value: 34168
    GL_SOURCE0_RGB                                                = 0x8580, // decimal value: 34176
    GL_SOURCE0_RGB_ARB                                            = 0x8580, // decimal value: 34176
    GL_SOURCE0_RGB_EXT                                            = 0x8580, // decimal value: 34176
    GL_SRC0_RGB                                                   = 0x8580, // decimal value: 34176
    GL_SOURCE1_RGB                                                = 0x8581, // decimal value: 34177
    GL_SOURCE1_RGB_ARB                                            = 0x8581, // decimal value: 34177
    GL_SOURCE1_RGB_EXT                                            = 0x8581, // decimal value: 34177
    GL_SRC1_RGB                                                   = 0x8581, // decimal value: 34177
    GL_SOURCE2_RGB                                                = 0x8582, // decimal value: 34178
    GL_SOURCE2_RGB_ARB                                            = 0x8582, // decimal value: 34178
    GL_SOURCE2_RGB_EXT                                            = 0x8582, // decimal value: 34178
    GL_SRC2_RGB                                                   = 0x8582, // decimal value: 34178
    GL_SOURCE3_RGB_NV                                             = 0x8583, // decimal value: 34179
    GL_SOURCE0_ALPHA                                              = 0x8588, // decimal value: 34184
    GL_SOURCE0_ALPHA_ARB                                          = 0x8588, // decimal value: 34184
    GL_SOURCE0_ALPHA_EXT                                          = 0x8588, // decimal value: 34184
    GL_SRC0_ALPHA                                                 = 0x8588, // decimal value: 34184
    GL_SOURCE1_ALPHA                                              = 0x8589, // decimal value: 34185
    GL_SOURCE1_ALPHA_ARB                                          = 0x8589, // decimal value: 34185
    GL_SOURCE1_ALPHA_EXT                                          = 0x8589, // decimal value: 34185
    GL_SOURCE2_ALPHA                                              = 0x858A, // decimal value: 34186
    GL_SOURCE2_ALPHA_ARB                                          = 0x858A, // decimal value: 34186
    GL_SOURCE2_ALPHA_EXT                                          = 0x858A, // decimal value: 34186
    GL_SRC2_ALPHA                                                 = 0x858A, // decimal value: 34186
    GL_SOURCE3_ALPHA_NV                                           = 0x858B, // decimal value: 34187
    GL_OPERAND0_RGB                                               = 0x8590, // decimal value: 34192
    GL_OPERAND0_RGB_ARB                                           = 0x8590, // decimal value: 34192
    GL_OPERAND0_RGB_EXT                                           = 0x8590, // decimal value: 34192
    GL_OPERAND1_RGB                                               = 0x8591, // decimal value: 34193
    GL_OPERAND1_RGB_ARB                                           = 0x8591, // decimal value: 34193
    GL_OPERAND1_RGB_EXT                                           = 0x8591, // decimal value: 34193
    GL_OPERAND2_RGB                                               = 0x8592, // decimal value: 34194
    GL_OPERAND2_RGB_ARB                                           = 0x8592, // decimal value: 34194
    GL_OPERAND2_RGB_EXT                                           = 0x8592, // decimal value: 34194
    GL_OPERAND3_RGB_NV                                            = 0x8593, // decimal value: 34195
    GL_OPERAND0_ALPHA                                             = 0x8598, // decimal value: 34200
    GL_OPERAND0_ALPHA_ARB                                         = 0x8598, // decimal value: 34200
    GL_OPERAND0_ALPHA_EXT                                         = 0x8598, // decimal value: 34200
    GL_OPERAND1_ALPHA                                             = 0x8599, // decimal value: 34201
    GL_OPERAND1_ALPHA_ARB                                         = 0x8599, // decimal value: 34201
    GL_OPERAND1_ALPHA_EXT                                         = 0x8599, // decimal value: 34201
    GL_OPERAND2_ALPHA                                             = 0x859A, // decimal value: 34202
    GL_OPERAND2_ALPHA_ARB                                         = 0x859A, // decimal value: 34202
    GL_OPERAND2_ALPHA_EXT                                         = 0x859A, // decimal value: 34202
    GL_OPERAND3_ALPHA_NV                                          = 0x859B, // decimal value: 34203
    GL_PERTURB_EXT                                                = 0x85AE, // decimal value: 34222
    GL_TEXTURE_NORMAL_EXT                                         = 0x85AF, // decimal value: 34223
    GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE                          = 0x85B0, // decimal value: 34224
    GL_UNPACK_CLIENT_STORAGE_APPLE                                = 0x85B2, // decimal value: 34226
    GL_BUFFER_OBJECT_APPLE                                        = 0x85B3, // decimal value: 34227
    GL_STORAGE_CLIENT_APPLE                                       = 0x85B4, // decimal value: 34228
    GL_VERTEX_ARRAY_BINDING                                       = 0x85B5, // decimal value: 34229
    GL_VERTEX_ARRAY_BINDING_APPLE                                 = 0x85B5, // decimal value: 34229
    GL_TEXTURE_RANGE_LENGTH_APPLE                                 = 0x85B7, // decimal value: 34231
    GL_TEXTURE_RANGE_POINTER_APPLE                                = 0x85B8, // decimal value: 34232
    GL_YCBCR_422_APPLE                                            = 0x85B9, // decimal value: 34233
    GL_UNSIGNED_SHORT_8_8_APPLE                                   = 0x85BA, // decimal value: 34234
    GL_UNSIGNED_SHORT_8_8_MESA                                    = 0x85BA, // decimal value: 34234
    GL_UNSIGNED_SHORT_8_8_REV_APPLE                               = 0x85BB, // decimal value: 34235
    GL_UNSIGNED_SHORT_8_8_REV_MESA                                = 0x85BB, // decimal value: 34235
    GL_STORAGE_PRIVATE_APPLE                                      = 0x85BD, // decimal value: 34237
    GL_STORAGE_CACHED_APPLE                                       = 0x85BE, // decimal value: 34238
    GL_STORAGE_SHARED_APPLE                                       = 0x85BF, // decimal value: 34239
    GL_REPLACEMENT_CODE_ARRAY_SUN                                 = 0x85C0, // decimal value: 34240
    GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN                            = 0x85C1, // decimal value: 34241
    GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN                          = 0x85C2, // decimal value: 34242
    GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN                         = 0x85C3, // decimal value: 34243
    GL_R1UI_V3F_SUN                                               = 0x85C4, // decimal value: 34244
    GL_R1UI_C4UB_V3F_SUN                                          = 0x85C5, // decimal value: 34245
    GL_R1UI_C3F_V3F_SUN                                           = 0x85C6, // decimal value: 34246
    GL_R1UI_N3F_V3F_SUN                                           = 0x85C7, // decimal value: 34247
    GL_R1UI_C4F_N3F_V3F_SUN                                       = 0x85C8, // decimal value: 34248
    GL_R1UI_T2F_V3F_SUN                                           = 0x85C9, // decimal value: 34249
    GL_R1UI_T2F_N3F_V3F_SUN                                       = 0x85CA, // decimal value: 34250
    GL_R1UI_T2F_C4F_N3F_V3F_SUN                                   = 0x85CB, // decimal value: 34251
    GL_SLICE_ACCUM_SUN                                            = 0x85CC, // decimal value: 34252
    GL_QUAD_MESH_SUN                                              = 0x8614, // decimal value: 34324
    GL_TRIANGLE_MESH_SUN                                          = 0x8615, // decimal value: 34325
    GL_VERTEX_PROGRAM_ARB                                         = 0x8620, // decimal value: 34336
    GL_VERTEX_PROGRAM_NV                                          = 0x8620, // decimal value: 34336
    GL_VERTEX_STATE_PROGRAM_NV                                    = 0x8621, // decimal value: 34337
    GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                            = 0x8622, // decimal value: 34338
    GL_ATTRIB_ARRAY_SIZE_NV                                       = 0x8623, // decimal value: 34339
    GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                               = 0x8623, // decimal value: 34339
    GL_ATTRIB_ARRAY_STRIDE_NV                                     = 0x8624, // decimal value: 34340
    GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                             = 0x8624, // decimal value: 34340
    GL_ATTRIB_ARRAY_TYPE_NV                                       = 0x8625, // decimal value: 34341
    GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                               = 0x8625, // decimal value: 34341
    GL_CURRENT_ATTRIB_NV                                          = 0x8626, // decimal value: 34342
    GL_CURRENT_VERTEX_ATTRIB_ARB                                  = 0x8626, // decimal value: 34342
    GL_PROGRAM_LENGTH_ARB                                         = 0x8627, // decimal value: 34343
    GL_PROGRAM_LENGTH_NV                                          = 0x8627, // decimal value: 34343
    GL_PROGRAM_STRING_ARB                                         = 0x8628, // decimal value: 34344
    GL_PROGRAM_STRING_NV                                          = 0x8628, // decimal value: 34344
    GL_MODELVIEW_PROJECTION_NV                                    = 0x8629, // decimal value: 34345
    GL_IDENTITY_NV                                                = 0x862A, // decimal value: 34346
    GL_INVERSE_NV                                                 = 0x862B, // decimal value: 34347
    GL_TRANSPOSE_NV                                               = 0x862C, // decimal value: 34348
    GL_INVERSE_TRANSPOSE_NV                                       = 0x862D, // decimal value: 34349
    GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB                         = 0x862E, // decimal value: 34350
    GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV                            = 0x862E, // decimal value: 34350
    GL_MAX_PROGRAM_MATRICES_ARB                                   = 0x862F, // decimal value: 34351
    GL_MAX_TRACK_MATRICES_NV                                      = 0x862F, // decimal value: 34351
    GL_MATRIX0_NV                                                 = 0x8630, // decimal value: 34352
    GL_MATRIX1_NV                                                 = 0x8631, // decimal value: 34353
    GL_MATRIX2_NV                                                 = 0x8632, // decimal value: 34354
    GL_MATRIX3_NV                                                 = 0x8633, // decimal value: 34355
    GL_MATRIX4_NV                                                 = 0x8634, // decimal value: 34356
    GL_MATRIX5_NV                                                 = 0x8635, // decimal value: 34357
    GL_MATRIX6_NV                                                 = 0x8636, // decimal value: 34358
    GL_MATRIX7_NV                                                 = 0x8637, // decimal value: 34359
    GL_CURRENT_MATRIX_STACK_DEPTH_ARB                             = 0x8640, // decimal value: 34368
    GL_CURRENT_MATRIX_STACK_DEPTH_NV                              = 0x8640, // decimal value: 34368
    GL_CURRENT_MATRIX_ARB                                         = 0x8641, // decimal value: 34369
    GL_CURRENT_MATRIX_NV                                          = 0x8641, // decimal value: 34369
    GL_PROGRAM_POINT_SIZE                                         = 0x8642, // decimal value: 34370
    GL_PROGRAM_POINT_SIZE_ARB                                     = 0x8642, // decimal value: 34370
    GL_PROGRAM_POINT_SIZE_EXT                                     = 0x8642, // decimal value: 34370
    GL_VERTEX_PROGRAM_POINT_SIZE                                  = 0x8642, // decimal value: 34370
    GL_VERTEX_PROGRAM_POINT_SIZE_ARB                              = 0x8642, // decimal value: 34370
    GL_VERTEX_PROGRAM_POINT_SIZE_NV                               = 0x8642, // decimal value: 34370
    GL_VERTEX_PROGRAM_TWO_SIDE                                    = 0x8643, // decimal value: 34371
    GL_VERTEX_PROGRAM_TWO_SIDE_ARB                                = 0x8643, // decimal value: 34371
    GL_VERTEX_PROGRAM_TWO_SIDE_NV                                 = 0x8643, // decimal value: 34371
    GL_PROGRAM_PARAMETER_NV                                       = 0x8644, // decimal value: 34372
    GL_ATTRIB_ARRAY_POINTER_NV                                    = 0x8645, // decimal value: 34373
    GL_VERTEX_ATTRIB_ARRAY_POINTER                                = 0x8645, // decimal value: 34373
    GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                            = 0x8645, // decimal value: 34373
    GL_PROGRAM_TARGET_NV                                          = 0x8646, // decimal value: 34374
    GL_PROGRAM_RESIDENT_NV                                        = 0x8647, // decimal value: 34375
    GL_TRACK_MATRIX_NV                                            = 0x8648, // decimal value: 34376
    GL_TRACK_MATRIX_TRANSFORM_NV                                  = 0x8649, // decimal value: 34377
    GL_VERTEX_PROGRAM_BINDING_NV                                  = 0x864A, // decimal value: 34378
    GL_PROGRAM_ERROR_POSITION_ARB                                 = 0x864B, // decimal value: 34379
    GL_PROGRAM_ERROR_POSITION_NV                                  = 0x864B, // decimal value: 34379
    GL_OFFSET_TEXTURE_RECTANGLE_NV                                = 0x864C, // decimal value: 34380
    GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV                          = 0x864D, // decimal value: 34381
    GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV                           = 0x864E, // decimal value: 34382
    GL_DEPTH_CLAMP                                                = 0x864F, // decimal value: 34383
    GL_DEPTH_CLAMP_NV                                             = 0x864F, // decimal value: 34383
    GL_VERTEX_ATTRIB_ARRAY0_NV                                    = 0x8650, // decimal value: 34384
    GL_VERTEX_ATTRIB_ARRAY1_NV                                    = 0x8651, // decimal value: 34385
    GL_VERTEX_ATTRIB_ARRAY2_NV                                    = 0x8652, // decimal value: 34386
    GL_VERTEX_ATTRIB_ARRAY3_NV                                    = 0x8653, // decimal value: 34387
    GL_VERTEX_ATTRIB_ARRAY4_NV                                    = 0x8654, // decimal value: 34388
    GL_VERTEX_ATTRIB_ARRAY5_NV                                    = 0x8655, // decimal value: 34389
    GL_VERTEX_ATTRIB_ARRAY6_NV                                    = 0x8656, // decimal value: 34390
    GL_VERTEX_ATTRIB_ARRAY7_NV                                    = 0x8657, // decimal value: 34391
    GL_VERTEX_ATTRIB_ARRAY8_NV                                    = 0x8658, // decimal value: 34392
    GL_VERTEX_ATTRIB_ARRAY9_NV                                    = 0x8659, // decimal value: 34393
    GL_VERTEX_ATTRIB_ARRAY10_NV                                   = 0x865A, // decimal value: 34394
    GL_VERTEX_ATTRIB_ARRAY11_NV                                   = 0x865B, // decimal value: 34395
    GL_VERTEX_ATTRIB_ARRAY12_NV                                   = 0x865C, // decimal value: 34396
    GL_VERTEX_ATTRIB_ARRAY13_NV                                   = 0x865D, // decimal value: 34397
    GL_VERTEX_ATTRIB_ARRAY14_NV                                   = 0x865E, // decimal value: 34398
    GL_VERTEX_ATTRIB_ARRAY15_NV                                   = 0x865F, // decimal value: 34399
    GL_MAP1_VERTEX_ATTRIB0_4_NV                                   = 0x8660, // decimal value: 34400
    GL_MAP1_VERTEX_ATTRIB1_4_NV                                   = 0x8661, // decimal value: 34401
    GL_MAP1_VERTEX_ATTRIB2_4_NV                                   = 0x8662, // decimal value: 34402
    GL_MAP1_VERTEX_ATTRIB3_4_NV                                   = 0x8663, // decimal value: 34403
    GL_MAP1_VERTEX_ATTRIB4_4_NV                                   = 0x8664, // decimal value: 34404
    GL_MAP1_VERTEX_ATTRIB5_4_NV                                   = 0x8665, // decimal value: 34405
    GL_MAP1_VERTEX_ATTRIB6_4_NV                                   = 0x8666, // decimal value: 34406
    GL_MAP1_VERTEX_ATTRIB7_4_NV                                   = 0x8667, // decimal value: 34407
    GL_MAP1_VERTEX_ATTRIB8_4_NV                                   = 0x8668, // decimal value: 34408
    GL_MAP1_VERTEX_ATTRIB9_4_NV                                   = 0x8669, // decimal value: 34409
    GL_MAP1_VERTEX_ATTRIB10_4_NV                                  = 0x866A, // decimal value: 34410
    GL_MAP1_VERTEX_ATTRIB11_4_NV                                  = 0x866B, // decimal value: 34411
    GL_MAP1_VERTEX_ATTRIB12_4_NV                                  = 0x866C, // decimal value: 34412
    GL_MAP1_VERTEX_ATTRIB13_4_NV                                  = 0x866D, // decimal value: 34413
    GL_MAP1_VERTEX_ATTRIB14_4_NV                                  = 0x866E, // decimal value: 34414
    GL_MAP1_VERTEX_ATTRIB15_4_NV                                  = 0x866F, // decimal value: 34415
    GL_MAP2_VERTEX_ATTRIB0_4_NV                                   = 0x8670, // decimal value: 34416
    GL_MAP2_VERTEX_ATTRIB1_4_NV                                   = 0x8671, // decimal value: 34417
    GL_MAP2_VERTEX_ATTRIB2_4_NV                                   = 0x8672, // decimal value: 34418
    GL_MAP2_VERTEX_ATTRIB3_4_NV                                   = 0x8673, // decimal value: 34419
    GL_MAP2_VERTEX_ATTRIB4_4_NV                                   = 0x8674, // decimal value: 34420
    GL_MAP2_VERTEX_ATTRIB5_4_NV                                   = 0x8675, // decimal value: 34421
    GL_MAP2_VERTEX_ATTRIB6_4_NV                                   = 0x8676, // decimal value: 34422
    GL_MAP2_VERTEX_ATTRIB7_4_NV                                   = 0x8677, // decimal value: 34423
    GL_PROGRAM_BINDING_ARB                                        = 0x8677, // decimal value: 34423
    GL_MAP2_VERTEX_ATTRIB8_4_NV                                   = 0x8678, // decimal value: 34424
    GL_MAP2_VERTEX_ATTRIB9_4_NV                                   = 0x8679, // decimal value: 34425
    GL_MAP2_VERTEX_ATTRIB10_4_NV                                  = 0x867A, // decimal value: 34426
    GL_MAP2_VERTEX_ATTRIB11_4_NV                                  = 0x867B, // decimal value: 34427
    GL_MAP2_VERTEX_ATTRIB12_4_NV                                  = 0x867C, // decimal value: 34428
    GL_MAP2_VERTEX_ATTRIB13_4_NV                                  = 0x867D, // decimal value: 34429
    GL_MAP2_VERTEX_ATTRIB14_4_NV                                  = 0x867E, // decimal value: 34430
    GL_MAP2_VERTEX_ATTRIB15_4_NV                                  = 0x867F, // decimal value: 34431
    GL_TEXTURE_COMPRESSED_IMAGE_SIZE                              = 0x86A0, // decimal value: 34464
    GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB                          = 0x86A0, // decimal value: 34464
    GL_TEXTURE_COMPRESSED_ARB                                     = 0x86A1, // decimal value: 34465
    GL_NUM_COMPRESSED_TEXTURE_FORMATS                             = 0x86A2, // decimal value: 34466
    GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB                         = 0x86A2, // decimal value: 34466
    GL_COMPRESSED_TEXTURE_FORMATS                                 = 0x86A3, // decimal value: 34467
    GL_COMPRESSED_TEXTURE_FORMATS_ARB                             = 0x86A3, // decimal value: 34467
    GL_MAX_VERTEX_UNITS_ARB                                       = 0x86A4, // decimal value: 34468
    GL_ACTIVE_VERTEX_UNITS_ARB                                    = 0x86A5, // decimal value: 34469
    GL_WEIGHT_SUM_UNITY_ARB                                       = 0x86A6, // decimal value: 34470
    GL_VERTEX_BLEND_ARB                                           = 0x86A7, // decimal value: 34471
    GL_CURRENT_WEIGHT_ARB                                         = 0x86A8, // decimal value: 34472
    GL_WEIGHT_ARRAY_TYPE_ARB                                      = 0x86A9, // decimal value: 34473
    GL_WEIGHT_ARRAY_STRIDE_ARB                                    = 0x86AA, // decimal value: 34474
    GL_WEIGHT_ARRAY_SIZE_ARB                                      = 0x86AB, // decimal value: 34475
    GL_WEIGHT_ARRAY_POINTER_ARB                                   = 0x86AC, // decimal value: 34476
    GL_WEIGHT_ARRAY_ARB                                           = 0x86AD, // decimal value: 34477
    GL_DOT3_RGB                                                   = 0x86AE, // decimal value: 34478
    GL_DOT3_RGB_ARB                                               = 0x86AE, // decimal value: 34478
    GL_DOT3_RGBA                                                  = 0x86AF, // decimal value: 34479
    GL_DOT3_RGBA_ARB                                              = 0x86AF, // decimal value: 34479
    GL_COMPRESSED_RGB_FXT1_3DFX                                   = 0x86B0, // decimal value: 34480
    GL_COMPRESSED_RGBA_FXT1_3DFX                                  = 0x86B1, // decimal value: 34481
    GL_MULTISAMPLE_3DFX                                           = 0x86B2, // decimal value: 34482
    GL_SAMPLE_BUFFERS_3DFX                                        = 0x86B3, // decimal value: 34483
    GL_SAMPLES_3DFX                                               = 0x86B4, // decimal value: 34484
    GL_EVAL_2D_NV                                                 = 0x86C0, // decimal value: 34496
    GL_EVAL_TRIANGULAR_2D_NV                                      = 0x86C1, // decimal value: 34497
    GL_MAP_TESSELLATION_NV                                        = 0x86C2, // decimal value: 34498
    GL_MAP_ATTRIB_U_ORDER_NV                                      = 0x86C3, // decimal value: 34499
    GL_MAP_ATTRIB_V_ORDER_NV                                      = 0x86C4, // decimal value: 34500
    GL_EVAL_FRACTIONAL_TESSELLATION_NV                            = 0x86C5, // decimal value: 34501
    GL_EVAL_VERTEX_ATTRIB0_NV                                     = 0x86C6, // decimal value: 34502
    GL_EVAL_VERTEX_ATTRIB1_NV                                     = 0x86C7, // decimal value: 34503
    GL_EVAL_VERTEX_ATTRIB2_NV                                     = 0x86C8, // decimal value: 34504
    GL_EVAL_VERTEX_ATTRIB3_NV                                     = 0x86C9, // decimal value: 34505
    GL_EVAL_VERTEX_ATTRIB4_NV                                     = 0x86CA, // decimal value: 34506
    GL_EVAL_VERTEX_ATTRIB5_NV                                     = 0x86CB, // decimal value: 34507
    GL_EVAL_VERTEX_ATTRIB6_NV                                     = 0x86CC, // decimal value: 34508
    GL_EVAL_VERTEX_ATTRIB7_NV                                     = 0x86CD, // decimal value: 34509
    GL_EVAL_VERTEX_ATTRIB8_NV                                     = 0x86CE, // decimal value: 34510
    GL_EVAL_VERTEX_ATTRIB9_NV                                     = 0x86CF, // decimal value: 34511
    GL_EVAL_VERTEX_ATTRIB10_NV                                    = 0x86D0, // decimal value: 34512
    GL_EVAL_VERTEX_ATTRIB11_NV                                    = 0x86D1, // decimal value: 34513
    GL_EVAL_VERTEX_ATTRIB12_NV                                    = 0x86D2, // decimal value: 34514
    GL_EVAL_VERTEX_ATTRIB13_NV                                    = 0x86D3, // decimal value: 34515
    GL_EVAL_VERTEX_ATTRIB14_NV                                    = 0x86D4, // decimal value: 34516
    GL_EVAL_VERTEX_ATTRIB15_NV                                    = 0x86D5, // decimal value: 34517
    GL_MAX_MAP_TESSELLATION_NV                                    = 0x86D6, // decimal value: 34518
    GL_MAX_RATIONAL_EVAL_ORDER_NV                                 = 0x86D7, // decimal value: 34519
    GL_MAX_PROGRAM_PATCH_ATTRIBS_NV                               = 0x86D8, // decimal value: 34520
    GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV                       = 0x86D9, // decimal value: 34521
    GL_UNSIGNED_INT_S8_S8_8_8_NV                                  = 0x86DA, // decimal value: 34522
    GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                              = 0x86DB, // decimal value: 34523
    GL_DSDT_MAG_INTENSITY_NV                                      = 0x86DC, // decimal value: 34524
    GL_SHADER_CONSISTENT_NV                                       = 0x86DD, // decimal value: 34525
    GL_TEXTURE_SHADER_NV                                          = 0x86DE, // decimal value: 34526
    GL_SHADER_OPERATION_NV                                        = 0x86DF, // decimal value: 34527
    GL_CULL_MODES_NV                                              = 0x86E0, // decimal value: 34528
    GL_OFFSET_TEXTURE_2D_MATRIX_NV                                = 0x86E1, // decimal value: 34529
    GL_OFFSET_TEXTURE_MATRIX_NV                                   = 0x86E1, // decimal value: 34529
    GL_OFFSET_TEXTURE_2D_SCALE_NV                                 = 0x86E2, // decimal value: 34530
    GL_OFFSET_TEXTURE_SCALE_NV                                    = 0x86E2, // decimal value: 34530
    GL_OFFSET_TEXTURE_2D_BIAS_NV                                  = 0x86E3, // decimal value: 34531
    GL_OFFSET_TEXTURE_BIAS_NV                                     = 0x86E3, // decimal value: 34531
    GL_PREVIOUS_TEXTURE_INPUT_NV                                  = 0x86E4, // decimal value: 34532
    GL_CONST_EYE_NV                                               = 0x86E5, // decimal value: 34533
    GL_PASS_THROUGH_NV                                            = 0x86E6, // decimal value: 34534
    GL_CULL_FRAGMENT_NV                                           = 0x86E7, // decimal value: 34535
    GL_OFFSET_TEXTURE_2D_NV                                       = 0x86E8, // decimal value: 34536
    GL_DEPENDENT_AR_TEXTURE_2D_NV                                 = 0x86E9, // decimal value: 34537
    GL_DEPENDENT_GB_TEXTURE_2D_NV                                 = 0x86EA, // decimal value: 34538
    GL_SURFACE_STATE_NV                                           = 0x86EB, // decimal value: 34539
    GL_DOT_PRODUCT_NV                                             = 0x86EC, // decimal value: 34540
    GL_DOT_PRODUCT_DEPTH_REPLACE_NV                               = 0x86ED, // decimal value: 34541
    GL_DOT_PRODUCT_TEXTURE_2D_NV                                  = 0x86EE, // decimal value: 34542
    GL_DOT_PRODUCT_TEXTURE_3D_NV                                  = 0x86EF, // decimal value: 34543
    GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV                            = 0x86F0, // decimal value: 34544
    GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV                            = 0x86F1, // decimal value: 34545
    GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV                            = 0x86F2, // decimal value: 34546
    GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV                  = 0x86F3, // decimal value: 34547
    GL_HILO_NV                                                    = 0x86F4, // decimal value: 34548
    GL_DSDT_NV                                                    = 0x86F5, // decimal value: 34549
    GL_DSDT_MAG_NV                                                = 0x86F6, // decimal value: 34550
    GL_DSDT_MAG_VIB_NV                                            = 0x86F7, // decimal value: 34551
    GL_HILO16_NV                                                  = 0x86F8, // decimal value: 34552
    GL_SIGNED_HILO_NV                                             = 0x86F9, // decimal value: 34553
    GL_SIGNED_HILO16_NV                                           = 0x86FA, // decimal value: 34554
    GL_SIGNED_RGBA_NV                                             = 0x86FB, // decimal value: 34555
    GL_SIGNED_RGBA8_NV                                            = 0x86FC, // decimal value: 34556
    GL_SURFACE_REGISTERED_NV                                      = 0x86FD, // decimal value: 34557
    GL_SIGNED_RGB_NV                                              = 0x86FE, // decimal value: 34558
    GL_SIGNED_RGB8_NV                                             = 0x86FF, // decimal value: 34559
    GL_SURFACE_MAPPED_NV                                          = 0x8700, // decimal value: 34560
    GL_SIGNED_LUMINANCE_NV                                        = 0x8701, // decimal value: 34561
    GL_SIGNED_LUMINANCE8_NV                                       = 0x8702, // decimal value: 34562
    GL_SIGNED_LUMINANCE_ALPHA_NV                                  = 0x8703, // decimal value: 34563
    GL_SIGNED_LUMINANCE8_ALPHA8_NV                                = 0x8704, // decimal value: 34564
    GL_SIGNED_ALPHA_NV                                            = 0x8705, // decimal value: 34565
    GL_SIGNED_ALPHA8_NV                                           = 0x8706, // decimal value: 34566
    GL_SIGNED_INTENSITY_NV                                        = 0x8707, // decimal value: 34567
    GL_SIGNED_INTENSITY8_NV                                       = 0x8708, // decimal value: 34568
    GL_DSDT8_NV                                                   = 0x8709, // decimal value: 34569
    GL_DSDT8_MAG8_NV                                              = 0x870A, // decimal value: 34570
    GL_DSDT8_MAG8_INTENSITY8_NV                                   = 0x870B, // decimal value: 34571
    GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                               = 0x870C, // decimal value: 34572
    GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                             = 0x870D, // decimal value: 34573
    GL_HI_SCALE_NV                                                = 0x870E, // decimal value: 34574
    GL_LO_SCALE_NV                                                = 0x870F, // decimal value: 34575
    GL_DS_SCALE_NV                                                = 0x8710, // decimal value: 34576
    GL_DT_SCALE_NV                                                = 0x8711, // decimal value: 34577
    GL_MAGNITUDE_SCALE_NV                                         = 0x8712, // decimal value: 34578
    GL_VIBRANCE_SCALE_NV                                          = 0x8713, // decimal value: 34579
    GL_HI_BIAS_NV                                                 = 0x8714, // decimal value: 34580
    GL_LO_BIAS_NV                                                 = 0x8715, // decimal value: 34581
    GL_DS_BIAS_NV                                                 = 0x8716, // decimal value: 34582
    GL_DT_BIAS_NV                                                 = 0x8717, // decimal value: 34583
    GL_MAGNITUDE_BIAS_NV                                          = 0x8718, // decimal value: 34584
    GL_VIBRANCE_BIAS_NV                                           = 0x8719, // decimal value: 34585
    GL_TEXTURE_BORDER_VALUES_NV                                   = 0x871A, // decimal value: 34586
    GL_TEXTURE_HI_SIZE_NV                                         = 0x871B, // decimal value: 34587
    GL_TEXTURE_LO_SIZE_NV                                         = 0x871C, // decimal value: 34588
    GL_TEXTURE_DS_SIZE_NV                                         = 0x871D, // decimal value: 34589
    GL_TEXTURE_DT_SIZE_NV                                         = 0x871E, // decimal value: 34590
    GL_TEXTURE_MAG_SIZE_NV                                        = 0x871F, // decimal value: 34591
    GL_MODELVIEW2_ARB                                             = 0x8722, // decimal value: 34594
    GL_MODELVIEW3_ARB                                             = 0x8723, // decimal value: 34595
    GL_MODELVIEW4_ARB                                             = 0x8724, // decimal value: 34596
    GL_MODELVIEW5_ARB                                             = 0x8725, // decimal value: 34597
    GL_MODELVIEW6_ARB                                             = 0x8726, // decimal value: 34598
    GL_MODELVIEW7_ARB                                             = 0x8727, // decimal value: 34599
    GL_MODELVIEW8_ARB                                             = 0x8728, // decimal value: 34600
    GL_MODELVIEW9_ARB                                             = 0x8729, // decimal value: 34601
    GL_MODELVIEW10_ARB                                            = 0x872A, // decimal value: 34602
    GL_MODELVIEW11_ARB                                            = 0x872B, // decimal value: 34603
    GL_MODELVIEW12_ARB                                            = 0x872C, // decimal value: 34604
    GL_MODELVIEW13_ARB                                            = 0x872D, // decimal value: 34605
    GL_MODELVIEW14_ARB                                            = 0x872E, // decimal value: 34606
    GL_MODELVIEW15_ARB                                            = 0x872F, // decimal value: 34607
    GL_MODELVIEW16_ARB                                            = 0x8730, // decimal value: 34608
    GL_MODELVIEW17_ARB                                            = 0x8731, // decimal value: 34609
    GL_MODELVIEW18_ARB                                            = 0x8732, // decimal value: 34610
    GL_MODELVIEW19_ARB                                            = 0x8733, // decimal value: 34611
    GL_MODELVIEW20_ARB                                            = 0x8734, // decimal value: 34612
    GL_MODELVIEW21_ARB                                            = 0x8735, // decimal value: 34613
    GL_MODELVIEW22_ARB                                            = 0x8736, // decimal value: 34614
    GL_MODELVIEW23_ARB                                            = 0x8737, // decimal value: 34615
    GL_MODELVIEW24_ARB                                            = 0x8738, // decimal value: 34616
    GL_MODELVIEW25_ARB                                            = 0x8739, // decimal value: 34617
    GL_MODELVIEW26_ARB                                            = 0x873A, // decimal value: 34618
    GL_MODELVIEW27_ARB                                            = 0x873B, // decimal value: 34619
    GL_MODELVIEW28_ARB                                            = 0x873C, // decimal value: 34620
    GL_MODELVIEW29_ARB                                            = 0x873D, // decimal value: 34621
    GL_MODELVIEW30_ARB                                            = 0x873E, // decimal value: 34622
    GL_MODELVIEW31_ARB                                            = 0x873F, // decimal value: 34623
    GL_DOT3_RGB_EXT                                               = 0x8740, // decimal value: 34624
    GL_DOT3_RGBA_EXT                                              = 0x8741, // decimal value: 34625
    GL_MIRROR_CLAMP_ATI                                           = 0x8742, // decimal value: 34626
    GL_MIRROR_CLAMP_EXT                                           = 0x8742, // decimal value: 34626
    GL_MIRROR_CLAMP_TO_EDGE                                       = 0x8743, // decimal value: 34627
    GL_MIRROR_CLAMP_TO_EDGE_ATI                                   = 0x8743, // decimal value: 34627
    GL_MIRROR_CLAMP_TO_EDGE_EXT                                   = 0x8743, // decimal value: 34627
    GL_MODULATE_ADD_ATI                                           = 0x8744, // decimal value: 34628
    GL_MODULATE_SIGNED_ADD_ATI                                    = 0x8745, // decimal value: 34629
    GL_MODULATE_SUBTRACT_ATI                                      = 0x8746, // decimal value: 34630
    GL_SET_AMD                                                    = 0x874A, // decimal value: 34634
    GL_REPLACE_VALUE_AMD                                          = 0x874B, // decimal value: 34635
    GL_STENCIL_OP_VALUE_AMD                                       = 0x874C, // decimal value: 34636
    GL_STENCIL_BACK_OP_VALUE_AMD                                  = 0x874D, // decimal value: 34637
    GL_OCCLUSION_QUERY_EVENT_MASK_AMD                             = 0x874F, // decimal value: 34639
    GL_YCBCR_MESA                                                 = 0x8757, // decimal value: 34647
    GL_PACK_INVERT_MESA                                           = 0x8758, // decimal value: 34648
    GL_TEXTURE_1D_STACK_MESAX                                     = 0x8759, // decimal value: 34649
    GL_TEXTURE_2D_STACK_MESAX                                     = 0x875A, // decimal value: 34650
    GL_PROXY_TEXTURE_1D_STACK_MESAX                               = 0x875B, // decimal value: 34651
    GL_PROXY_TEXTURE_2D_STACK_MESAX                               = 0x875C, // decimal value: 34652
    GL_TEXTURE_1D_STACK_BINDING_MESAX                             = 0x875D, // decimal value: 34653
    GL_TEXTURE_2D_STACK_BINDING_MESAX                             = 0x875E, // decimal value: 34654
    GL_PROGRAM_BINARY_FORMAT_MESA                                 = 0x875F, // decimal value: 34655
    GL_STATIC_ATI                                                 = 0x8760, // decimal value: 34656
    GL_DYNAMIC_ATI                                                = 0x8761, // decimal value: 34657
    GL_PRESERVE_ATI                                               = 0x8762, // decimal value: 34658
    GL_DISCARD_ATI                                                = 0x8763, // decimal value: 34659
    GL_BUFFER_SIZE_ARB                                            = 0x8764, // decimal value: 34660
    GL_OBJECT_BUFFER_SIZE_ATI                                     = 0x8764, // decimal value: 34660
    GL_BUFFER_USAGE_ARB                                           = 0x8765, // decimal value: 34661
    GL_OBJECT_BUFFER_USAGE_ATI                                    = 0x8765, // decimal value: 34661
    GL_ARRAY_OBJECT_BUFFER_ATI                                    = 0x8766, // decimal value: 34662
    GL_ARRAY_OBJECT_OFFSET_ATI                                    = 0x8767, // decimal value: 34663
    GL_ELEMENT_ARRAY_ATI                                          = 0x8768, // decimal value: 34664
    GL_ELEMENT_ARRAY_TYPE_ATI                                     = 0x8769, // decimal value: 34665
    GL_ELEMENT_ARRAY_POINTER_ATI                                  = 0x876A, // decimal value: 34666
    GL_MAX_VERTEX_STREAMS_ATI                                     = 0x876B, // decimal value: 34667
    GL_VERTEX_STREAM0_ATI                                         = 0x876C, // decimal value: 34668
    GL_VERTEX_STREAM1_ATI                                         = 0x876D, // decimal value: 34669
    GL_VERTEX_STREAM2_ATI                                         = 0x876E, // decimal value: 34670
    GL_VERTEX_STREAM3_ATI                                         = 0x876F, // decimal value: 34671
    GL_VERTEX_STREAM4_ATI                                         = 0x8770, // decimal value: 34672
    GL_VERTEX_STREAM5_ATI                                         = 0x8771, // decimal value: 34673
    GL_VERTEX_STREAM6_ATI                                         = 0x8772, // decimal value: 34674
    GL_VERTEX_STREAM7_ATI                                         = 0x8773, // decimal value: 34675
    GL_VERTEX_SOURCE_ATI                                          = 0x8774, // decimal value: 34676
    GL_BUMP_ROT_MATRIX_ATI                                        = 0x8775, // decimal value: 34677
    GL_BUMP_ROT_MATRIX_SIZE_ATI                                   = 0x8776, // decimal value: 34678
    GL_BUMP_NUM_TEX_UNITS_ATI                                     = 0x8777, // decimal value: 34679
    GL_BUMP_TEX_UNITS_ATI                                         = 0x8778, // decimal value: 34680
    GL_DUDV_ATI                                                   = 0x8779, // decimal value: 34681
    GL_DU8DV8_ATI                                                 = 0x877A, // decimal value: 34682
    GL_BUMP_ENVMAP_ATI                                            = 0x877B, // decimal value: 34683
    GL_BUMP_TARGET_ATI                                            = 0x877C, // decimal value: 34684
    GL_VERTEX_SHADER_EXT                                          = 0x8780, // decimal value: 34688
    GL_VERTEX_SHADER_BINDING_EXT                                  = 0x8781, // decimal value: 34689
    GL_OP_INDEX_EXT                                               = 0x8782, // decimal value: 34690
    GL_OP_NEGATE_EXT                                              = 0x8783, // decimal value: 34691
    GL_OP_DOT3_EXT                                                = 0x8784, // decimal value: 34692
    GL_OP_DOT4_EXT                                                = 0x8785, // decimal value: 34693
    GL_OP_MUL_EXT                                                 = 0x8786, // decimal value: 34694
    GL_OP_ADD_EXT                                                 = 0x8787, // decimal value: 34695
    GL_OP_MADD_EXT                                                = 0x8788, // decimal value: 34696
    GL_OP_FRAC_EXT                                                = 0x8789, // decimal value: 34697
    GL_OP_MAX_EXT                                                 = 0x878A, // decimal value: 34698
    GL_OP_MIN_EXT                                                 = 0x878B, // decimal value: 34699
    GL_OP_SET_GE_EXT                                              = 0x878C, // decimal value: 34700
    GL_OP_SET_LT_EXT                                              = 0x878D, // decimal value: 34701
    GL_OP_CLAMP_EXT                                               = 0x878E, // decimal value: 34702
    GL_OP_FLOOR_EXT                                               = 0x878F, // decimal value: 34703
    GL_OP_ROUND_EXT                                               = 0x8790, // decimal value: 34704
    GL_OP_EXP_BASE_2_EXT                                          = 0x8791, // decimal value: 34705
    GL_OP_LOG_BASE_2_EXT                                          = 0x8792, // decimal value: 34706
    GL_OP_POWER_EXT                                               = 0x8793, // decimal value: 34707
    GL_OP_RECIP_EXT                                               = 0x8794, // decimal value: 34708
    GL_OP_RECIP_SQRT_EXT                                          = 0x8795, // decimal value: 34709
    GL_OP_SUB_EXT                                                 = 0x8796, // decimal value: 34710
    GL_OP_CROSS_PRODUCT_EXT                                       = 0x8797, // decimal value: 34711
    GL_OP_MULTIPLY_MATRIX_EXT                                     = 0x8798, // decimal value: 34712
    GL_OP_MOV_EXT                                                 = 0x8799, // decimal value: 34713
    GL_OUTPUT_VERTEX_EXT                                          = 0x879A, // decimal value: 34714
    GL_OUTPUT_COLOR0_EXT                                          = 0x879B, // decimal value: 34715
    GL_OUTPUT_COLOR1_EXT                                          = 0x879C, // decimal value: 34716
    GL_OUTPUT_TEXTURE_COORD0_EXT                                  = 0x879D, // decimal value: 34717
    GL_OUTPUT_TEXTURE_COORD1_EXT                                  = 0x879E, // decimal value: 34718
    GL_OUTPUT_TEXTURE_COORD2_EXT                                  = 0x879F, // decimal value: 34719
    GL_OUTPUT_TEXTURE_COORD3_EXT                                  = 0x87A0, // decimal value: 34720
    GL_OUTPUT_TEXTURE_COORD4_EXT                                  = 0x87A1, // decimal value: 34721
    GL_OUTPUT_TEXTURE_COORD5_EXT                                  = 0x87A2, // decimal value: 34722
    GL_OUTPUT_TEXTURE_COORD6_EXT                                  = 0x87A3, // decimal value: 34723
    GL_OUTPUT_TEXTURE_COORD7_EXT                                  = 0x87A4, // decimal value: 34724
    GL_OUTPUT_TEXTURE_COORD8_EXT                                  = 0x87A5, // decimal value: 34725
    GL_OUTPUT_TEXTURE_COORD9_EXT                                  = 0x87A6, // decimal value: 34726
    GL_OUTPUT_TEXTURE_COORD10_EXT                                 = 0x87A7, // decimal value: 34727
    GL_OUTPUT_TEXTURE_COORD11_EXT                                 = 0x87A8, // decimal value: 34728
    GL_OUTPUT_TEXTURE_COORD12_EXT                                 = 0x87A9, // decimal value: 34729
    GL_OUTPUT_TEXTURE_COORD13_EXT                                 = 0x87AA, // decimal value: 34730
    GL_OUTPUT_TEXTURE_COORD14_EXT                                 = 0x87AB, // decimal value: 34731
    GL_OUTPUT_TEXTURE_COORD15_EXT                                 = 0x87AC, // decimal value: 34732
    GL_OUTPUT_TEXTURE_COORD16_EXT                                 = 0x87AD, // decimal value: 34733
    GL_OUTPUT_TEXTURE_COORD17_EXT                                 = 0x87AE, // decimal value: 34734
    GL_OUTPUT_TEXTURE_COORD18_EXT                                 = 0x87AF, // decimal value: 34735
    GL_OUTPUT_TEXTURE_COORD19_EXT                                 = 0x87B0, // decimal value: 34736
    GL_OUTPUT_TEXTURE_COORD20_EXT                                 = 0x87B1, // decimal value: 34737
    GL_OUTPUT_TEXTURE_COORD21_EXT                                 = 0x87B2, // decimal value: 34738
    GL_OUTPUT_TEXTURE_COORD22_EXT                                 = 0x87B3, // decimal value: 34739
    GL_OUTPUT_TEXTURE_COORD23_EXT                                 = 0x87B4, // decimal value: 34740
    GL_OUTPUT_TEXTURE_COORD24_EXT                                 = 0x87B5, // decimal value: 34741
    GL_OUTPUT_TEXTURE_COORD25_EXT                                 = 0x87B6, // decimal value: 34742
    GL_OUTPUT_TEXTURE_COORD26_EXT                                 = 0x87B7, // decimal value: 34743
    GL_OUTPUT_TEXTURE_COORD27_EXT                                 = 0x87B8, // decimal value: 34744
    GL_OUTPUT_TEXTURE_COORD28_EXT                                 = 0x87B9, // decimal value: 34745
    GL_OUTPUT_TEXTURE_COORD29_EXT                                 = 0x87BA, // decimal value: 34746
    GL_OUTPUT_TEXTURE_COORD30_EXT                                 = 0x87BB, // decimal value: 34747
    GL_OUTPUT_TEXTURE_COORD31_EXT                                 = 0x87BC, // decimal value: 34748
    GL_OUTPUT_FOG_EXT                                             = 0x87BD, // decimal value: 34749
    GL_SCALAR_EXT                                                 = 0x87BE, // decimal value: 34750
    GL_VECTOR_EXT                                                 = 0x87BF, // decimal value: 34751
    GL_MATRIX_EXT                                                 = 0x87C0, // decimal value: 34752
    GL_VARIANT_EXT                                                = 0x87C1, // decimal value: 34753
    GL_INVARIANT_EXT                                              = 0x87C2, // decimal value: 34754
    GL_LOCAL_CONSTANT_EXT                                         = 0x87C3, // decimal value: 34755
    GL_LOCAL_EXT                                                  = 0x87C4, // decimal value: 34756
    GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT                         = 0x87C5, // decimal value: 34757
    GL_MAX_VERTEX_SHADER_VARIANTS_EXT                             = 0x87C6, // decimal value: 34758
    GL_MAX_VERTEX_SHADER_INVARIANTS_EXT                           = 0x87C7, // decimal value: 34759
    GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                      = 0x87C8, // decimal value: 34760
    GL_MAX_VERTEX_SHADER_LOCALS_EXT                               = 0x87C9, // decimal value: 34761
    GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT               = 0x87CA, // decimal value: 34762
    GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT                   = 0x87CB, // decimal value: 34763
    GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT            = 0x87CC, // decimal value: 34764
    GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT                 = 0x87CD, // decimal value: 34765
    GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT                     = 0x87CE, // decimal value: 34766
    GL_VERTEX_SHADER_INSTRUCTIONS_EXT                             = 0x87CF, // decimal value: 34767
    GL_VERTEX_SHADER_VARIANTS_EXT                                 = 0x87D0, // decimal value: 34768
    GL_VERTEX_SHADER_INVARIANTS_EXT                               = 0x87D1, // decimal value: 34769
    GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                          = 0x87D2, // decimal value: 34770
    GL_VERTEX_SHADER_LOCALS_EXT                                   = 0x87D3, // decimal value: 34771
    GL_VERTEX_SHADER_OPTIMIZED_EXT                                = 0x87D4, // decimal value: 34772
    GL_X_EXT                                                      = 0x87D5, // decimal value: 34773
    GL_Y_EXT                                                      = 0x87D6, // decimal value: 34774
    GL_Z_EXT                                                      = 0x87D7, // decimal value: 34775
    GL_W_EXT                                                      = 0x87D8, // decimal value: 34776
    GL_NEGATIVE_X_EXT                                             = 0x87D9, // decimal value: 34777
    GL_NEGATIVE_Y_EXT                                             = 0x87DA, // decimal value: 34778
    GL_NEGATIVE_Z_EXT                                             = 0x87DB, // decimal value: 34779
    GL_NEGATIVE_W_EXT                                             = 0x87DC, // decimal value: 34780
    GL_ZERO_EXT                                                   = 0x87DD, // decimal value: 34781
    GL_ONE_EXT                                                    = 0x87DE, // decimal value: 34782
    GL_NEGATIVE_ONE_EXT                                           = 0x87DF, // decimal value: 34783
    GL_NORMALIZED_RANGE_EXT                                       = 0x87E0, // decimal value: 34784
    GL_FULL_RANGE_EXT                                             = 0x87E1, // decimal value: 34785
    GL_CURRENT_VERTEX_EXT                                         = 0x87E2, // decimal value: 34786
    GL_MVP_MATRIX_EXT                                             = 0x87E3, // decimal value: 34787
    GL_VARIANT_VALUE_EXT                                          = 0x87E4, // decimal value: 34788
    GL_VARIANT_DATATYPE_EXT                                       = 0x87E5, // decimal value: 34789
    GL_VARIANT_ARRAY_STRIDE_EXT                                   = 0x87E6, // decimal value: 34790
    GL_VARIANT_ARRAY_TYPE_EXT                                     = 0x87E7, // decimal value: 34791
    GL_VARIANT_ARRAY_EXT                                          = 0x87E8, // decimal value: 34792
    GL_VARIANT_ARRAY_POINTER_EXT                                  = 0x87E9, // decimal value: 34793
    GL_INVARIANT_VALUE_EXT                                        = 0x87EA, // decimal value: 34794
    GL_INVARIANT_DATATYPE_EXT                                     = 0x87EB, // decimal value: 34795
    GL_LOCAL_CONSTANT_VALUE_EXT                                   = 0x87EC, // decimal value: 34796
    GL_LOCAL_CONSTANT_DATATYPE_EXT                                = 0x87ED, // decimal value: 34797
    GL_PN_TRIANGLES_ATI                                           = 0x87F0, // decimal value: 34800
    GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI                     = 0x87F1, // decimal value: 34801
    GL_PN_TRIANGLES_POINT_MODE_ATI                                = 0x87F2, // decimal value: 34802
    GL_PN_TRIANGLES_NORMAL_MODE_ATI                               = 0x87F3, // decimal value: 34803
    GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI                         = 0x87F4, // decimal value: 34804
    GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI                         = 0x87F5, // decimal value: 34805
    GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI                          = 0x87F6, // decimal value: 34806
    GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI                        = 0x87F7, // decimal value: 34807
    GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI                     = 0x87F8, // decimal value: 34808
    GL_VBO_FREE_MEMORY_ATI                                        = 0x87FB, // decimal value: 34811
    GL_TEXTURE_FREE_MEMORY_ATI                                    = 0x87FC, // decimal value: 34812
    GL_RENDERBUFFER_FREE_MEMORY_ATI                               = 0x87FD, // decimal value: 34813
    GL_NUM_PROGRAM_BINARY_FORMATS                                 = 0x87FE, // decimal value: 34814
    GL_PROGRAM_BINARY_FORMATS                                     = 0x87FF, // decimal value: 34815
    GL_STENCIL_BACK_FUNC                                          = 0x8800, // decimal value: 34816
    GL_STENCIL_BACK_FUNC_ATI                                      = 0x8800, // decimal value: 34816
    GL_STENCIL_BACK_FAIL                                          = 0x8801, // decimal value: 34817
    GL_STENCIL_BACK_FAIL_ATI                                      = 0x8801, // decimal value: 34817
    GL_STENCIL_BACK_PASS_DEPTH_FAIL                               = 0x8802, // decimal value: 34818
    GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI                           = 0x8802, // decimal value: 34818
    GL_STENCIL_BACK_PASS_DEPTH_PASS                               = 0x8803, // decimal value: 34819
    GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI                           = 0x8803, // decimal value: 34819
    GL_FRAGMENT_PROGRAM_ARB                                       = 0x8804, // decimal value: 34820
    GL_PROGRAM_ALU_INSTRUCTIONS_ARB                               = 0x8805, // decimal value: 34821
    GL_PROGRAM_TEX_INSTRUCTIONS_ARB                               = 0x8806, // decimal value: 34822
    GL_PROGRAM_TEX_INDIRECTIONS_ARB                               = 0x8807, // decimal value: 34823
    GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                        = 0x8808, // decimal value: 34824
    GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                        = 0x8809, // decimal value: 34825
    GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                        = 0x880A, // decimal value: 34826
    GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB                           = 0x880B, // decimal value: 34827
    GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB                           = 0x880C, // decimal value: 34828
    GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB                           = 0x880D, // decimal value: 34829
    GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                    = 0x880E, // decimal value: 34830
    GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                    = 0x880F, // decimal value: 34831
    GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                    = 0x8810, // decimal value: 34832
    GL_RGBA_FLOAT32_APPLE                                         = 0x8814, // decimal value: 34836
    GL_RGBA_FLOAT32_ATI                                           = 0x8814, // decimal value: 34836
    GL_RGB32F                                                     = 0x8815, // decimal value: 34837
    GL_RGB32F_ARB                                                 = 0x8815, // decimal value: 34837
    GL_RGB_FLOAT32_APPLE                                          = 0x8815, // decimal value: 34837
    GL_RGB_FLOAT32_ATI                                            = 0x8815, // decimal value: 34837
    GL_ALPHA32F_ARB                                               = 0x8816, // decimal value: 34838
    GL_ALPHA_FLOAT32_APPLE                                        = 0x8816, // decimal value: 34838
    GL_ALPHA_FLOAT32_ATI                                          = 0x8816, // decimal value: 34838
    GL_INTENSITY32F_ARB                                           = 0x8817, // decimal value: 34839
    GL_INTENSITY_FLOAT32_APPLE                                    = 0x8817, // decimal value: 34839
    GL_INTENSITY_FLOAT32_ATI                                      = 0x8817, // decimal value: 34839
    GL_LUMINANCE32F_ARB                                           = 0x8818, // decimal value: 34840
    GL_LUMINANCE_FLOAT32_APPLE                                    = 0x8818, // decimal value: 34840
    GL_LUMINANCE_FLOAT32_ATI                                      = 0x8818, // decimal value: 34840
    GL_LUMINANCE_ALPHA32F_ARB                                     = 0x8819, // decimal value: 34841
    GL_LUMINANCE_ALPHA_FLOAT32_APPLE                              = 0x8819, // decimal value: 34841
    GL_LUMINANCE_ALPHA_FLOAT32_ATI                                = 0x8819, // decimal value: 34841
    GL_RGBA_FLOAT16_APPLE                                         = 0x881A, // decimal value: 34842
    GL_RGBA_FLOAT16_ATI                                           = 0x881A, // decimal value: 34842
    GL_RGB_FLOAT16_APPLE                                          = 0x881B, // decimal value: 34843
    GL_RGB_FLOAT16_ATI                                            = 0x881B, // decimal value: 34843
    GL_ALPHA16F_ARB                                               = 0x881C, // decimal value: 34844
    GL_ALPHA_FLOAT16_APPLE                                        = 0x881C, // decimal value: 34844
    GL_ALPHA_FLOAT16_ATI                                          = 0x881C, // decimal value: 34844
    GL_INTENSITY16F_ARB                                           = 0x881D, // decimal value: 34845
    GL_INTENSITY_FLOAT16_APPLE                                    = 0x881D, // decimal value: 34845
    GL_INTENSITY_FLOAT16_ATI                                      = 0x881D, // decimal value: 34845
    GL_LUMINANCE16F_ARB                                           = 0x881E, // decimal value: 34846
    GL_LUMINANCE_FLOAT16_APPLE                                    = 0x881E, // decimal value: 34846
    GL_LUMINANCE_FLOAT16_ATI                                      = 0x881E, // decimal value: 34846
    GL_LUMINANCE_ALPHA16F_ARB                                     = 0x881F, // decimal value: 34847
    GL_LUMINANCE_ALPHA_FLOAT16_APPLE                              = 0x881F, // decimal value: 34847
    GL_LUMINANCE_ALPHA_FLOAT16_ATI                                = 0x881F, // decimal value: 34847
    GL_RGBA_FLOAT_MODE_ARB                                        = 0x8820, // decimal value: 34848
    GL_RGBA_FLOAT_MODE_ATI                                        = 0x8820, // decimal value: 34848
    GL_MAX_DRAW_BUFFERS                                           = 0x8824, // decimal value: 34852
    GL_MAX_DRAW_BUFFERS_ARB                                       = 0x8824, // decimal value: 34852
    GL_MAX_DRAW_BUFFERS_ATI                                       = 0x8824, // decimal value: 34852
    GL_DRAW_BUFFER0                                               = 0x8825, // decimal value: 34853
    GL_DRAW_BUFFER0_ARB                                           = 0x8825, // decimal value: 34853
    GL_DRAW_BUFFER0_ATI                                           = 0x8825, // decimal value: 34853
    GL_DRAW_BUFFER1                                               = 0x8826, // decimal value: 34854
    GL_DRAW_BUFFER1_ARB                                           = 0x8826, // decimal value: 34854
    GL_DRAW_BUFFER1_ATI                                           = 0x8826, // decimal value: 34854
    GL_DRAW_BUFFER2                                               = 0x8827, // decimal value: 34855
    GL_DRAW_BUFFER2_ARB                                           = 0x8827, // decimal value: 34855
    GL_DRAW_BUFFER2_ATI                                           = 0x8827, // decimal value: 34855
    GL_DRAW_BUFFER3                                               = 0x8828, // decimal value: 34856
    GL_DRAW_BUFFER3_ARB                                           = 0x8828, // decimal value: 34856
    GL_DRAW_BUFFER3_ATI                                           = 0x8828, // decimal value: 34856
    GL_DRAW_BUFFER4                                               = 0x8829, // decimal value: 34857
    GL_DRAW_BUFFER4_ARB                                           = 0x8829, // decimal value: 34857
    GL_DRAW_BUFFER4_ATI                                           = 0x8829, // decimal value: 34857
    GL_DRAW_BUFFER5                                               = 0x882A, // decimal value: 34858
    GL_DRAW_BUFFER5_ARB                                           = 0x882A, // decimal value: 34858
    GL_DRAW_BUFFER5_ATI                                           = 0x882A, // decimal value: 34858
    GL_DRAW_BUFFER6                                               = 0x882B, // decimal value: 34859
    GL_DRAW_BUFFER6_ARB                                           = 0x882B, // decimal value: 34859
    GL_DRAW_BUFFER6_ATI                                           = 0x882B, // decimal value: 34859
    GL_DRAW_BUFFER7                                               = 0x882C, // decimal value: 34860
    GL_DRAW_BUFFER7_ARB                                           = 0x882C, // decimal value: 34860
    GL_DRAW_BUFFER7_ATI                                           = 0x882C, // decimal value: 34860
    GL_DRAW_BUFFER8                                               = 0x882D, // decimal value: 34861
    GL_DRAW_BUFFER8_ARB                                           = 0x882D, // decimal value: 34861
    GL_DRAW_BUFFER8_ATI                                           = 0x882D, // decimal value: 34861
    GL_DRAW_BUFFER9                                               = 0x882E, // decimal value: 34862
    GL_DRAW_BUFFER9_ARB                                           = 0x882E, // decimal value: 34862
    GL_DRAW_BUFFER9_ATI                                           = 0x882E, // decimal value: 34862
    GL_DRAW_BUFFER10                                              = 0x882F, // decimal value: 34863
    GL_DRAW_BUFFER10_ARB                                          = 0x882F, // decimal value: 34863
    GL_DRAW_BUFFER10_ATI                                          = 0x882F, // decimal value: 34863
    GL_DRAW_BUFFER11                                              = 0x8830, // decimal value: 34864
    GL_DRAW_BUFFER11_ARB                                          = 0x8830, // decimal value: 34864
    GL_DRAW_BUFFER11_ATI                                          = 0x8830, // decimal value: 34864
    GL_DRAW_BUFFER12                                              = 0x8831, // decimal value: 34865
    GL_DRAW_BUFFER12_ARB                                          = 0x8831, // decimal value: 34865
    GL_DRAW_BUFFER12_ATI                                          = 0x8831, // decimal value: 34865
    GL_DRAW_BUFFER13                                              = 0x8832, // decimal value: 34866
    GL_DRAW_BUFFER13_ARB                                          = 0x8832, // decimal value: 34866
    GL_DRAW_BUFFER13_ATI                                          = 0x8832, // decimal value: 34866
    GL_DRAW_BUFFER14                                              = 0x8833, // decimal value: 34867
    GL_DRAW_BUFFER14_ARB                                          = 0x8833, // decimal value: 34867
    GL_DRAW_BUFFER14_ATI                                          = 0x8833, // decimal value: 34867
    GL_DRAW_BUFFER15                                              = 0x8834, // decimal value: 34868
    GL_DRAW_BUFFER15_ARB                                          = 0x8834, // decimal value: 34868
    GL_DRAW_BUFFER15_ATI                                          = 0x8834, // decimal value: 34868
    GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI                            = 0x8835, // decimal value: 34869
    GL_BLEND_EQUATION_ALPHA                                       = 0x883D, // decimal value: 34877
    GL_BLEND_EQUATION_ALPHA_EXT                                   = 0x883D, // decimal value: 34877
    GL_SUBSAMPLE_DISTANCE_AMD                                     = 0x883F, // decimal value: 34879
    GL_MATRIX_PALETTE_ARB                                         = 0x8840, // decimal value: 34880
    GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB                         = 0x8841, // decimal value: 34881
    GL_MAX_PALETTE_MATRICES_ARB                                   = 0x8842, // decimal value: 34882
    GL_CURRENT_PALETTE_MATRIX_ARB                                 = 0x8843, // decimal value: 34883
    GL_MATRIX_INDEX_ARRAY_ARB                                     = 0x8844, // decimal value: 34884
    GL_CURRENT_MATRIX_INDEX_ARB                                   = 0x8845, // decimal value: 34885
    GL_MATRIX_INDEX_ARRAY_SIZE_ARB                                = 0x8846, // decimal value: 34886
    GL_MATRIX_INDEX_ARRAY_TYPE_ARB                                = 0x8847, // decimal value: 34887
    GL_MATRIX_INDEX_ARRAY_STRIDE_ARB                              = 0x8848, // decimal value: 34888
    GL_MATRIX_INDEX_ARRAY_POINTER_ARB                             = 0x8849, // decimal value: 34889
    GL_TEXTURE_DEPTH_SIZE                                         = 0x884A, // decimal value: 34890
    GL_TEXTURE_DEPTH_SIZE_ARB                                     = 0x884A, // decimal value: 34890
    GL_DEPTH_TEXTURE_MODE                                         = 0x884B, // decimal value: 34891
    GL_DEPTH_TEXTURE_MODE_ARB                                     = 0x884B, // decimal value: 34891
    GL_TEXTURE_COMPARE_MODE_ARB                                   = 0x884C, // decimal value: 34892
    GL_TEXTURE_COMPARE_FUNC_ARB                                   = 0x884D, // decimal value: 34893
    GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT                           = 0x884E, // decimal value: 34894
    GL_COMPARE_REF_TO_TEXTURE                                     = 0x884E, // decimal value: 34894
    GL_COMPARE_R_TO_TEXTURE                                       = 0x884E, // decimal value: 34894
    GL_COMPARE_R_TO_TEXTURE_ARB                                   = 0x884E, // decimal value: 34894
    GL_TEXTURE_CUBE_MAP_SEAMLESS                                  = 0x884F, // decimal value: 34895
    GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV                            = 0x8850, // decimal value: 34896
    GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV                      = 0x8851, // decimal value: 34897
    GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV                     = 0x8852, // decimal value: 34898
    GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV               = 0x8853, // decimal value: 34899
    GL_OFFSET_HILO_TEXTURE_2D_NV                                  = 0x8854, // decimal value: 34900
    GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV                           = 0x8855, // decimal value: 34901
    GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV                       = 0x8856, // decimal value: 34902
    GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV                = 0x8857, // decimal value: 34903
    GL_DEPENDENT_HILO_TEXTURE_2D_NV                               = 0x8858, // decimal value: 34904
    GL_DEPENDENT_RGB_TEXTURE_3D_NV                                = 0x8859, // decimal value: 34905
    GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV                          = 0x885A, // decimal value: 34906
    GL_DOT_PRODUCT_PASS_THROUGH_NV                                = 0x885B, // decimal value: 34907
    GL_DOT_PRODUCT_TEXTURE_1D_NV                                  = 0x885C, // decimal value: 34908
    GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV                        = 0x885D, // decimal value: 34909
    GL_HILO8_NV                                                   = 0x885E, // decimal value: 34910
    GL_SIGNED_HILO8_NV                                            = 0x885F, // decimal value: 34911
    GL_FORCE_BLUE_TO_ONE_NV                                       = 0x8860, // decimal value: 34912
    GL_POINT_SPRITE                                               = 0x8861, // decimal value: 34913
    GL_POINT_SPRITE_ARB                                           = 0x8861, // decimal value: 34913
    GL_POINT_SPRITE_NV                                            = 0x8861, // decimal value: 34913
    GL_COORD_REPLACE                                              = 0x8862, // decimal value: 34914
    GL_COORD_REPLACE_ARB                                          = 0x8862, // decimal value: 34914
    GL_COORD_REPLACE_NV                                           = 0x8862, // decimal value: 34914
    GL_POINT_SPRITE_R_MODE_NV                                     = 0x8863, // decimal value: 34915
    GL_PIXEL_COUNTER_BITS_NV                                      = 0x8864, // decimal value: 34916
    GL_QUERY_COUNTER_BITS_ARB                                     = 0x8864, // decimal value: 34916
    GL_CURRENT_OCCLUSION_QUERY_ID_NV                              = 0x8865, // decimal value: 34917
    GL_CURRENT_QUERY_ARB                                          = 0x8865, // decimal value: 34917
    GL_PIXEL_COUNT_NV                                             = 0x8866, // decimal value: 34918
    GL_QUERY_RESULT_ARB                                           = 0x8866, // decimal value: 34918
    GL_PIXEL_COUNT_AVAILABLE_NV                                   = 0x8867, // decimal value: 34919
    GL_QUERY_RESULT_AVAILABLE_ARB                                 = 0x8867, // decimal value: 34919
    GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV                   = 0x8868, // decimal value: 34920
    GL_MAX_VERTEX_ATTRIBS                                         = 0x8869, // decimal value: 34921
    GL_MAX_VERTEX_ATTRIBS_ARB                                     = 0x8869, // decimal value: 34921
    GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB                         = 0x886A, // decimal value: 34922
    GL_MAX_TESS_CONTROL_INPUT_COMPONENTS                          = 0x886C, // decimal value: 34924
    GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS                       = 0x886D, // decimal value: 34925
    GL_DEPTH_STENCIL_TO_RGBA_NV                                   = 0x886E, // decimal value: 34926
    GL_DEPTH_STENCIL_TO_BGRA_NV                                   = 0x886F, // decimal value: 34927
    GL_FRAGMENT_PROGRAM_NV                                        = 0x8870, // decimal value: 34928
    GL_MAX_TEXTURE_COORDS                                         = 0x8871, // decimal value: 34929
    GL_MAX_TEXTURE_COORDS_ARB                                     = 0x8871, // decimal value: 34929
    GL_MAX_TEXTURE_COORDS_NV                                      = 0x8871, // decimal value: 34929
    GL_MAX_TEXTURE_IMAGE_UNITS                                    = 0x8872, // decimal value: 34930
    GL_MAX_TEXTURE_IMAGE_UNITS_ARB                                = 0x8872, // decimal value: 34930
    GL_MAX_TEXTURE_IMAGE_UNITS_NV                                 = 0x8872, // decimal value: 34930
    GL_FRAGMENT_PROGRAM_BINDING_NV                                = 0x8873, // decimal value: 34931
    GL_PROGRAM_ERROR_STRING_ARB                                   = 0x8874, // decimal value: 34932
    GL_PROGRAM_ERROR_STRING_NV                                    = 0x8874, // decimal value: 34932
    GL_PROGRAM_FORMAT_ASCII_ARB                                   = 0x8875, // decimal value: 34933
    GL_PROGRAM_FORMAT_ARB                                         = 0x8876, // decimal value: 34934
    GL_WRITE_PIXEL_DATA_RANGE_NV                                  = 0x8878, // decimal value: 34936
    GL_READ_PIXEL_DATA_RANGE_NV                                   = 0x8879, // decimal value: 34937
    GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV                           = 0x887A, // decimal value: 34938
    GL_READ_PIXEL_DATA_RANGE_LENGTH_NV                            = 0x887B, // decimal value: 34939
    GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV                          = 0x887C, // decimal value: 34940
    GL_READ_PIXEL_DATA_RANGE_POINTER_NV                           = 0x887D, // decimal value: 34941
    GL_GEOMETRY_SHADER_INVOCATIONS                                = 0x887F, // decimal value: 34943
    GL_FLOAT_R_NV                                                 = 0x8880, // decimal value: 34944
    GL_FLOAT_RG_NV                                                = 0x8881, // decimal value: 34945
    GL_FLOAT_RGB_NV                                               = 0x8882, // decimal value: 34946
    GL_FLOAT_RGBA_NV                                              = 0x8883, // decimal value: 34947
    GL_FLOAT_R16_NV                                               = 0x8884, // decimal value: 34948
    GL_FLOAT_R32_NV                                               = 0x8885, // decimal value: 34949
    GL_FLOAT_RG16_NV                                              = 0x8886, // decimal value: 34950
    GL_FLOAT_RG32_NV                                              = 0x8887, // decimal value: 34951
    GL_FLOAT_RGB16_NV                                             = 0x8888, // decimal value: 34952
    GL_FLOAT_RGB32_NV                                             = 0x8889, // decimal value: 34953
    GL_FLOAT_RGBA16_NV                                            = 0x888A, // decimal value: 34954
    GL_FLOAT_RGBA32_NV                                            = 0x888B, // decimal value: 34955
    GL_TEXTURE_FLOAT_COMPONENTS_NV                                = 0x888C, // decimal value: 34956
    GL_FLOAT_CLEAR_COLOR_VALUE_NV                                 = 0x888D, // decimal value: 34957
    GL_FLOAT_RGBA_MODE_NV                                         = 0x888E, // decimal value: 34958
    GL_TEXTURE_UNSIGNED_REMAP_MODE_NV                             = 0x888F, // decimal value: 34959
    GL_DEPTH_BOUNDS_TEST_EXT                                      = 0x8890, // decimal value: 34960
    GL_DEPTH_BOUNDS_EXT                                           = 0x8891, // decimal value: 34961
    GL_ARRAY_BUFFER_ARB                                           = 0x8892, // decimal value: 34962
    GL_ELEMENT_ARRAY_BUFFER_ARB                                   = 0x8893, // decimal value: 34963
    GL_ARRAY_BUFFER_BINDING                                       = 0x8894, // decimal value: 34964
    GL_ARRAY_BUFFER_BINDING_ARB                                   = 0x8894, // decimal value: 34964
    GL_ELEMENT_ARRAY_BUFFER_BINDING                               = 0x8895, // decimal value: 34965
    GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB                           = 0x8895, // decimal value: 34965
    GL_VERTEX_ARRAY_BUFFER_BINDING                                = 0x8896, // decimal value: 34966
    GL_VERTEX_ARRAY_BUFFER_BINDING_ARB                            = 0x8896, // decimal value: 34966
    GL_NORMAL_ARRAY_BUFFER_BINDING                                = 0x8897, // decimal value: 34967
    GL_NORMAL_ARRAY_BUFFER_BINDING_ARB                            = 0x8897, // decimal value: 34967
    GL_COLOR_ARRAY_BUFFER_BINDING                                 = 0x8898, // decimal value: 34968
    GL_COLOR_ARRAY_BUFFER_BINDING_ARB                             = 0x8898, // decimal value: 34968
    GL_INDEX_ARRAY_BUFFER_BINDING                                 = 0x8899, // decimal value: 34969
    GL_INDEX_ARRAY_BUFFER_BINDING_ARB                             = 0x8899, // decimal value: 34969
    GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING                         = 0x889A, // decimal value: 34970
    GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB                     = 0x889A, // decimal value: 34970
    GL_EDGE_FLAG_ARRAY_BUFFER_BINDING                             = 0x889B, // decimal value: 34971
    GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB                         = 0x889B, // decimal value: 34971
    GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING                       = 0x889C, // decimal value: 34972
    GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB                   = 0x889C, // decimal value: 34972
    GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING                        = 0x889D, // decimal value: 34973
    GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB                    = 0x889D, // decimal value: 34973
    GL_FOG_COORD_ARRAY_BUFFER_BINDING                             = 0x889D, // decimal value: 34973
    GL_WEIGHT_ARRAY_BUFFER_BINDING                                = 0x889E, // decimal value: 34974
    GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB                            = 0x889E, // decimal value: 34974
    GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB                     = 0x889F, // decimal value: 34975
    GL_PROGRAM_INSTRUCTIONS_ARB                                   = 0x88A0, // decimal value: 34976
    GL_MAX_PROGRAM_INSTRUCTIONS_ARB                               = 0x88A1, // decimal value: 34977
    GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                            = 0x88A2, // decimal value: 34978
    GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB                        = 0x88A3, // decimal value: 34979
    GL_PROGRAM_TEMPORARIES_ARB                                    = 0x88A4, // decimal value: 34980
    GL_MAX_PROGRAM_TEMPORARIES_ARB                                = 0x88A5, // decimal value: 34981
    GL_PROGRAM_NATIVE_TEMPORARIES_ARB                             = 0x88A6, // decimal value: 34982
    GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB                         = 0x88A7, // decimal value: 34983
    GL_PROGRAM_PARAMETERS_ARB                                     = 0x88A8, // decimal value: 34984
    GL_MAX_PROGRAM_PARAMETERS_ARB                                 = 0x88A9, // decimal value: 34985
    GL_PROGRAM_NATIVE_PARAMETERS_ARB                              = 0x88AA, // decimal value: 34986
    GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                          = 0x88AB, // decimal value: 34987
    GL_PROGRAM_ATTRIBS_ARB                                        = 0x88AC, // decimal value: 34988
    GL_MAX_PROGRAM_ATTRIBS_ARB                                    = 0x88AD, // decimal value: 34989
    GL_PROGRAM_NATIVE_ATTRIBS_ARB                                 = 0x88AE, // decimal value: 34990
    GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                             = 0x88AF, // decimal value: 34991
    GL_PROGRAM_ADDRESS_REGISTERS_ARB                              = 0x88B0, // decimal value: 34992
    GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB                          = 0x88B1, // decimal value: 34993
    GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                       = 0x88B2, // decimal value: 34994
    GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                   = 0x88B3, // decimal value: 34995
    GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                           = 0x88B4, // decimal value: 34996
    GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                             = 0x88B5, // decimal value: 34997
    GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                            = 0x88B6, // decimal value: 34998
    GL_TRANSPOSE_CURRENT_MATRIX_ARB                               = 0x88B7, // decimal value: 34999
    GL_READ_ONLY_ARB                                              = 0x88B8, // decimal value: 35000
    GL_WRITE_ONLY_ARB                                             = 0x88B9, // decimal value: 35001
    GL_READ_WRITE_ARB                                             = 0x88BA, // decimal value: 35002
    GL_BUFFER_ACCESS_ARB                                          = 0x88BB, // decimal value: 35003
    GL_BUFFER_MAPPED_ARB                                          = 0x88BC, // decimal value: 35004
    GL_BUFFER_MAP_POINTER                                         = 0x88BD, // decimal value: 35005
    GL_BUFFER_MAP_POINTER_ARB                                     = 0x88BD, // decimal value: 35005
    GL_WRITE_DISCARD_NV                                           = 0x88BE, // decimal value: 35006
    GL_TIME_ELAPSED_EXT                                           = 0x88BF, // decimal value: 35007
    GL_MATRIX0_ARB                                                = 0x88C0, // decimal value: 35008
    GL_MATRIX1_ARB                                                = 0x88C1, // decimal value: 35009
    GL_MATRIX2_ARB                                                = 0x88C2, // decimal value: 35010
    GL_MATRIX3_ARB                                                = 0x88C3, // decimal value: 35011
    GL_MATRIX4_ARB                                                = 0x88C4, // decimal value: 35012
    GL_MATRIX5_ARB                                                = 0x88C5, // decimal value: 35013
    GL_MATRIX6_ARB                                                = 0x88C6, // decimal value: 35014
    GL_MATRIX7_ARB                                                = 0x88C7, // decimal value: 35015
    GL_MATRIX8_ARB                                                = 0x88C8, // decimal value: 35016
    GL_MATRIX9_ARB                                                = 0x88C9, // decimal value: 35017
    GL_MATRIX10_ARB                                               = 0x88CA, // decimal value: 35018
    GL_MATRIX11_ARB                                               = 0x88CB, // decimal value: 35019
    GL_MATRIX12_ARB                                               = 0x88CC, // decimal value: 35020
    GL_MATRIX13_ARB                                               = 0x88CD, // decimal value: 35021
    GL_MATRIX14_ARB                                               = 0x88CE, // decimal value: 35022
    GL_MATRIX15_ARB                                               = 0x88CF, // decimal value: 35023
    GL_MATRIX16_ARB                                               = 0x88D0, // decimal value: 35024
    GL_MATRIX17_ARB                                               = 0x88D1, // decimal value: 35025
    GL_MATRIX18_ARB                                               = 0x88D2, // decimal value: 35026
    GL_MATRIX19_ARB                                               = 0x88D3, // decimal value: 35027
    GL_MATRIX20_ARB                                               = 0x88D4, // decimal value: 35028
    GL_MATRIX21_ARB                                               = 0x88D5, // decimal value: 35029
    GL_MATRIX22_ARB                                               = 0x88D6, // decimal value: 35030
    GL_MATRIX23_ARB                                               = 0x88D7, // decimal value: 35031
    GL_MATRIX24_ARB                                               = 0x88D8, // decimal value: 35032
    GL_MATRIX25_ARB                                               = 0x88D9, // decimal value: 35033
    GL_MATRIX26_ARB                                               = 0x88DA, // decimal value: 35034
    GL_MATRIX27_ARB                                               = 0x88DB, // decimal value: 35035
    GL_MATRIX28_ARB                                               = 0x88DC, // decimal value: 35036
    GL_MATRIX29_ARB                                               = 0x88DD, // decimal value: 35037
    GL_MATRIX30_ARB                                               = 0x88DE, // decimal value: 35038
    GL_MATRIX31_ARB                                               = 0x88DF, // decimal value: 35039
    GL_STREAM_DRAW_ARB                                            = 0x88E0, // decimal value: 35040
    GL_STREAM_READ_ARB                                            = 0x88E1, // decimal value: 35041
    GL_STREAM_COPY_ARB                                            = 0x88E2, // decimal value: 35042
    GL_STATIC_DRAW_ARB                                            = 0x88E4, // decimal value: 35044
    GL_STATIC_READ_ARB                                            = 0x88E5, // decimal value: 35045
    GL_STATIC_COPY_ARB                                            = 0x88E6, // decimal value: 35046
    GL_DYNAMIC_DRAW_ARB                                           = 0x88E8, // decimal value: 35048
    GL_DYNAMIC_READ_ARB                                           = 0x88E9, // decimal value: 35049
    GL_DYNAMIC_COPY_ARB                                           = 0x88EA, // decimal value: 35050
    GL_PIXEL_PACK_BUFFER_ARB                                      = 0x88EB, // decimal value: 35051
    GL_PIXEL_PACK_BUFFER_EXT                                      = 0x88EB, // decimal value: 35051
    GL_PIXEL_UNPACK_BUFFER_ARB                                    = 0x88EC, // decimal value: 35052
    GL_PIXEL_UNPACK_BUFFER_EXT                                    = 0x88EC, // decimal value: 35052
    GL_PIXEL_PACK_BUFFER_BINDING                                  = 0x88ED, // decimal value: 35053
    GL_PIXEL_PACK_BUFFER_BINDING_ARB                              = 0x88ED, // decimal value: 35053
    GL_PIXEL_PACK_BUFFER_BINDING_EXT                              = 0x88ED, // decimal value: 35053
    GL_PIXEL_UNPACK_BUFFER_BINDING                                = 0x88EF, // decimal value: 35055
    GL_PIXEL_UNPACK_BUFFER_BINDING_ARB                            = 0x88EF, // decimal value: 35055
    GL_PIXEL_UNPACK_BUFFER_BINDING_EXT                            = 0x88EF, // decimal value: 35055
    GL_TEXTURE_STENCIL_SIZE                                       = 0x88F1, // decimal value: 35057
    GL_TEXTURE_STENCIL_SIZE_EXT                                   = 0x88F1, // decimal value: 35057
    GL_STENCIL_TAG_BITS_EXT                                       = 0x88F2, // decimal value: 35058
    GL_STENCIL_CLEAR_TAG_VALUE_EXT                                = 0x88F3, // decimal value: 35059
    GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV                           = 0x88F4, // decimal value: 35060
    GL_MAX_PROGRAM_CALL_DEPTH_NV                                  = 0x88F5, // decimal value: 35061
    GL_MAX_PROGRAM_IF_DEPTH_NV                                    = 0x88F6, // decimal value: 35062
    GL_MAX_PROGRAM_LOOP_DEPTH_NV                                  = 0x88F7, // decimal value: 35063
    GL_MAX_PROGRAM_LOOP_COUNT_NV                                  = 0x88F8, // decimal value: 35064
    GL_MAX_DUAL_SOURCE_DRAW_BUFFERS                               = 0x88FC, // decimal value: 35068
    GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT                            = 0x88FD, // decimal value: 35069
    GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV                             = 0x88FD, // decimal value: 35069
    GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB                            = 0x88FE, // decimal value: 35070
    GL_MAX_ARRAY_TEXTURE_LAYERS                                   = 0x88FF, // decimal value: 35071
    GL_MAX_ARRAY_TEXTURE_LAYERS_EXT                               = 0x88FF, // decimal value: 35071
    GL_MIN_PROGRAM_TEXEL_OFFSET                                   = 0x8904, // decimal value: 35076
    GL_MIN_PROGRAM_TEXEL_OFFSET_EXT                               = 0x8904, // decimal value: 35076
    GL_MIN_PROGRAM_TEXEL_OFFSET_NV                                = 0x8904, // decimal value: 35076
    GL_MAX_PROGRAM_TEXEL_OFFSET                                   = 0x8905, // decimal value: 35077
    GL_MAX_PROGRAM_TEXEL_OFFSET_EXT                               = 0x8905, // decimal value: 35077
    GL_MAX_PROGRAM_TEXEL_OFFSET_NV                                = 0x8905, // decimal value: 35077
    GL_PROGRAM_ATTRIB_COMPONENTS_NV                               = 0x8906, // decimal value: 35078
    GL_PROGRAM_RESULT_COMPONENTS_NV                               = 0x8907, // decimal value: 35079
    GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV                           = 0x8908, // decimal value: 35080
    GL_MAX_PROGRAM_RESULT_COMPONENTS_NV                           = 0x8909, // decimal value: 35081
    GL_STENCIL_TEST_TWO_SIDE_EXT                                  = 0x8910, // decimal value: 35088
    GL_ACTIVE_STENCIL_FACE_EXT                                    = 0x8911, // decimal value: 35089
    GL_MIRROR_CLAMP_TO_BORDER_EXT                                 = 0x8912, // decimal value: 35090
    GL_SAMPLES_PASSED_ARB                                         = 0x8914, // decimal value: 35092
    GL_SAMPLER_BINDING                                            = 0x8919, // decimal value: 35097
    GL_CLAMP_VERTEX_COLOR                                         = 0x891A, // decimal value: 35098
    GL_CLAMP_VERTEX_COLOR_ARB                                     = 0x891A, // decimal value: 35098
    GL_CLAMP_FRAGMENT_COLOR                                       = 0x891B, // decimal value: 35099
    GL_CLAMP_FRAGMENT_COLOR_ARB                                   = 0x891B, // decimal value: 35099
    GL_CLAMP_READ_COLOR                                           = 0x891C, // decimal value: 35100
    GL_CLAMP_READ_COLOR_ARB                                       = 0x891C, // decimal value: 35100
    GL_FIXED_ONLY                                                 = 0x891D, // decimal value: 35101
    GL_FIXED_ONLY_ARB                                             = 0x891D, // decimal value: 35101
    GL_TESS_CONTROL_PROGRAM_NV                                    = 0x891E, // decimal value: 35102
    GL_TESS_EVALUATION_PROGRAM_NV                                 = 0x891F, // decimal value: 35103
    GL_FRAGMENT_SHADER_ATI                                        = 0x8920, // decimal value: 35104
    GL_REG_0_ATI                                                  = 0x8921, // decimal value: 35105
    GL_REG_1_ATI                                                  = 0x8922, // decimal value: 35106
    GL_REG_2_ATI                                                  = 0x8923, // decimal value: 35107
    GL_REG_3_ATI                                                  = 0x8924, // decimal value: 35108
    GL_REG_4_ATI                                                  = 0x8925, // decimal value: 35109
    GL_REG_5_ATI                                                  = 0x8926, // decimal value: 35110
    GL_REG_6_ATI                                                  = 0x8927, // decimal value: 35111
    GL_REG_7_ATI                                                  = 0x8928, // decimal value: 35112
    GL_REG_8_ATI                                                  = 0x8929, // decimal value: 35113
    GL_REG_9_ATI                                                  = 0x892A, // decimal value: 35114
    GL_REG_10_ATI                                                 = 0x892B, // decimal value: 35115
    GL_REG_11_ATI                                                 = 0x892C, // decimal value: 35116
    GL_REG_12_ATI                                                 = 0x892D, // decimal value: 35117
    GL_REG_13_ATI                                                 = 0x892E, // decimal value: 35118
    GL_REG_14_ATI                                                 = 0x892F, // decimal value: 35119
    GL_REG_15_ATI                                                 = 0x8930, // decimal value: 35120
    GL_REG_16_ATI                                                 = 0x8931, // decimal value: 35121
    GL_REG_17_ATI                                                 = 0x8932, // decimal value: 35122
    GL_REG_18_ATI                                                 = 0x8933, // decimal value: 35123
    GL_REG_19_ATI                                                 = 0x8934, // decimal value: 35124
    GL_REG_20_ATI                                                 = 0x8935, // decimal value: 35125
    GL_REG_21_ATI                                                 = 0x8936, // decimal value: 35126
    GL_REG_22_ATI                                                 = 0x8937, // decimal value: 35127
    GL_REG_23_ATI                                                 = 0x8938, // decimal value: 35128
    GL_REG_24_ATI                                                 = 0x8939, // decimal value: 35129
    GL_REG_25_ATI                                                 = 0x893A, // decimal value: 35130
    GL_REG_26_ATI                                                 = 0x893B, // decimal value: 35131
    GL_REG_27_ATI                                                 = 0x893C, // decimal value: 35132
    GL_REG_28_ATI                                                 = 0x893D, // decimal value: 35133
    GL_REG_29_ATI                                                 = 0x893E, // decimal value: 35134
    GL_REG_30_ATI                                                 = 0x893F, // decimal value: 35135
    GL_REG_31_ATI                                                 = 0x8940, // decimal value: 35136
    GL_CON_0_ATI                                                  = 0x8941, // decimal value: 35137
    GL_CON_1_ATI                                                  = 0x8942, // decimal value: 35138
    GL_CON_2_ATI                                                  = 0x8943, // decimal value: 35139
    GL_CON_3_ATI                                                  = 0x8944, // decimal value: 35140
    GL_CON_4_ATI                                                  = 0x8945, // decimal value: 35141
    GL_CON_5_ATI                                                  = 0x8946, // decimal value: 35142
    GL_CON_6_ATI                                                  = 0x8947, // decimal value: 35143
    GL_CON_7_ATI                                                  = 0x8948, // decimal value: 35144
    GL_CON_8_ATI                                                  = 0x8949, // decimal value: 35145
    GL_CON_9_ATI                                                  = 0x894A, // decimal value: 35146
    GL_CON_10_ATI                                                 = 0x894B, // decimal value: 35147
    GL_CON_11_ATI                                                 = 0x894C, // decimal value: 35148
    GL_CON_12_ATI                                                 = 0x894D, // decimal value: 35149
    GL_CON_13_ATI                                                 = 0x894E, // decimal value: 35150
    GL_CON_14_ATI                                                 = 0x894F, // decimal value: 35151
    GL_CON_15_ATI                                                 = 0x8950, // decimal value: 35152
    GL_CON_16_ATI                                                 = 0x8951, // decimal value: 35153
    GL_CON_17_ATI                                                 = 0x8952, // decimal value: 35154
    GL_CON_18_ATI                                                 = 0x8953, // decimal value: 35155
    GL_CON_19_ATI                                                 = 0x8954, // decimal value: 35156
    GL_CON_20_ATI                                                 = 0x8955, // decimal value: 35157
    GL_CON_21_ATI                                                 = 0x8956, // decimal value: 35158
    GL_CON_22_ATI                                                 = 0x8957, // decimal value: 35159
    GL_CON_23_ATI                                                 = 0x8958, // decimal value: 35160
    GL_CON_24_ATI                                                 = 0x8959, // decimal value: 35161
    GL_CON_25_ATI                                                 = 0x895A, // decimal value: 35162
    GL_CON_26_ATI                                                 = 0x895B, // decimal value: 35163
    GL_CON_27_ATI                                                 = 0x895C, // decimal value: 35164
    GL_CON_28_ATI                                                 = 0x895D, // decimal value: 35165
    GL_CON_29_ATI                                                 = 0x895E, // decimal value: 35166
    GL_CON_30_ATI                                                 = 0x895F, // decimal value: 35167
    GL_CON_31_ATI                                                 = 0x8960, // decimal value: 35168
    GL_SECONDARY_INTERPOLATOR_ATI                                 = 0x896D, // decimal value: 35181
    GL_NUM_FRAGMENT_REGISTERS_ATI                                 = 0x896E, // decimal value: 35182
    GL_NUM_FRAGMENT_CONSTANTS_ATI                                 = 0x896F, // decimal value: 35183
    GL_NUM_PASSES_ATI                                             = 0x8970, // decimal value: 35184
    GL_NUM_INSTRUCTIONS_PER_PASS_ATI                              = 0x8971, // decimal value: 35185
    GL_NUM_INSTRUCTIONS_TOTAL_ATI                                 = 0x8972, // decimal value: 35186
    GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI                      = 0x8973, // decimal value: 35187
    GL_NUM_LOOPBACK_COMPONENTS_ATI                                = 0x8974, // decimal value: 35188
    GL_COLOR_ALPHA_PAIRING_ATI                                    = 0x8975, // decimal value: 35189
    GL_SWIZZLE_STR_ATI                                            = 0x8976, // decimal value: 35190
    GL_SWIZZLE_STQ_ATI                                            = 0x8977, // decimal value: 35191
    GL_SWIZZLE_STR_DR_ATI                                         = 0x8978, // decimal value: 35192
    GL_SWIZZLE_STQ_DQ_ATI                                         = 0x8979, // decimal value: 35193
    GL_SWIZZLE_STRQ_ATI                                           = 0x897A, // decimal value: 35194
    GL_SWIZZLE_STRQ_DQ_ATI                                        = 0x897B, // decimal value: 35195
    GL_INTERLACE_OML                                              = 0x8980, // decimal value: 35200
    GL_INTERLACE_READ_OML                                         = 0x8981, // decimal value: 35201
    GL_FORMAT_SUBSAMPLE_24_24_OML                                 = 0x8982, // decimal value: 35202
    GL_FORMAT_SUBSAMPLE_244_244_OML                               = 0x8983, // decimal value: 35203
    GL_RESAMPLE_REPLICATE_OML                                     = 0x8986, // decimal value: 35206
    GL_RESAMPLE_ZERO_FILL_OML                                     = 0x8987, // decimal value: 35207
    GL_RESAMPLE_AVERAGE_OML                                       = 0x8988, // decimal value: 35208
    GL_RESAMPLE_DECIMATE_OML                                      = 0x8989, // decimal value: 35209
    GL_VERTEX_ATTRIB_MAP1_APPLE                                   = 0x8A00, // decimal value: 35328
    GL_VERTEX_ATTRIB_MAP2_APPLE                                   = 0x8A01, // decimal value: 35329
    GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE                              = 0x8A02, // decimal value: 35330
    GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE                             = 0x8A03, // decimal value: 35331
    GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE                             = 0x8A04, // decimal value: 35332
    GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE                            = 0x8A05, // decimal value: 35333
    GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE                              = 0x8A06, // decimal value: 35334
    GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE                             = 0x8A07, // decimal value: 35335
    GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE                             = 0x8A08, // decimal value: 35336
    GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE                            = 0x8A09, // decimal value: 35337
    GL_DRAW_PIXELS_APPLE                                          = 0x8A0A, // decimal value: 35338
    GL_FENCE_APPLE                                                = 0x8A0B, // decimal value: 35339
    GL_ELEMENT_ARRAY_APPLE                                        = 0x8A0C, // decimal value: 35340
    GL_ELEMENT_ARRAY_TYPE_APPLE                                   = 0x8A0D, // decimal value: 35341
    GL_ELEMENT_ARRAY_POINTER_APPLE                                = 0x8A0E, // decimal value: 35342
    GL_COLOR_FLOAT_APPLE                                          = 0x8A0F, // decimal value: 35343
    GL_BUFFER_SERIALIZED_MODIFY_APPLE                             = 0x8A12, // decimal value: 35346
    GL_BUFFER_FLUSHING_UNMAP_APPLE                                = 0x8A13, // decimal value: 35347
    GL_AUX_DEPTH_STENCIL_APPLE                                    = 0x8A14, // decimal value: 35348
    GL_PACK_ROW_BYTES_APPLE                                       = 0x8A15, // decimal value: 35349
    GL_UNPACK_ROW_BYTES_APPLE                                     = 0x8A16, // decimal value: 35350
    GL_RELEASED_APPLE                                             = 0x8A19, // decimal value: 35353
    GL_VOLATILE_APPLE                                             = 0x8A1A, // decimal value: 35354
    GL_RETAINED_APPLE                                             = 0x8A1B, // decimal value: 35355
    GL_UNDEFINED_APPLE                                            = 0x8A1C, // decimal value: 35356
    GL_PURGEABLE_APPLE                                            = 0x8A1D, // decimal value: 35357
    GL_RGB_422_APPLE                                              = 0x8A1F, // decimal value: 35359
    GL_UNIFORM_BUFFER_BINDING                                     = 0x8A28, // decimal value: 35368
    GL_UNIFORM_BUFFER_START                                       = 0x8A29, // decimal value: 35369
    GL_UNIFORM_BUFFER_SIZE                                        = 0x8A2A, // decimal value: 35370
    GL_MAX_VERTEX_UNIFORM_BLOCKS                                  = 0x8A2B, // decimal value: 35371
    GL_MAX_GEOMETRY_UNIFORM_BLOCKS                                = 0x8A2C, // decimal value: 35372
    GL_MAX_FRAGMENT_UNIFORM_BLOCKS                                = 0x8A2D, // decimal value: 35373
    GL_MAX_COMBINED_UNIFORM_BLOCKS                                = 0x8A2E, // decimal value: 35374
    GL_MAX_UNIFORM_BUFFER_BINDINGS                                = 0x8A2F, // decimal value: 35375
    GL_MAX_UNIFORM_BLOCK_SIZE                                     = 0x8A30, // decimal value: 35376
    GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS                     = 0x8A31, // decimal value: 35377
    GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS                   = 0x8A32, // decimal value: 35378
    GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS                   = 0x8A33, // decimal value: 35379
    GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT                            = 0x8A34, // decimal value: 35380
    GL_TEXTURE_SRGB_DECODE_EXT                                    = 0x8A48, // decimal value: 35400
    GL_DECODE_EXT                                                 = 0x8A49, // decimal value: 35401
    GL_SKIP_DECODE_EXT                                            = 0x8A4A, // decimal value: 35402
    GL_PROGRAM_PIPELINE_OBJECT_EXT                                = 0x8A4F, // decimal value: 35407
    GL_RGB_RAW_422_APPLE                                          = 0x8A51, // decimal value: 35409
    GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT                       = 0x8A52, // decimal value: 35410
    GL_PROGRAM_OBJECT_ARB                                         = 0x8B40, // decimal value: 35648
    GL_PROGRAM_OBJECT_EXT                                         = 0x8B40, // decimal value: 35648
    GL_SHADER_OBJECT_ARB                                          = 0x8B48, // decimal value: 35656
    GL_SHADER_OBJECT_EXT                                          = 0x8B48, // decimal value: 35656
    GL_MAX_FRAGMENT_UNIFORM_COMPONENTS                            = 0x8B49, // decimal value: 35657
    GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB                        = 0x8B49, // decimal value: 35657
    GL_MAX_VERTEX_UNIFORM_COMPONENTS                              = 0x8B4A, // decimal value: 35658
    GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB                          = 0x8B4A, // decimal value: 35658
    GL_MAX_VARYING_COMPONENTS                                     = 0x8B4B, // decimal value: 35659
    GL_MAX_VARYING_COMPONENTS_EXT                                 = 0x8B4B, // decimal value: 35659
    GL_MAX_VARYING_FLOATS                                         = 0x8B4B, // decimal value: 35659
    GL_MAX_VARYING_FLOATS_ARB                                     = 0x8B4B, // decimal value: 35659
    GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS                             = 0x8B4C, // decimal value: 35660
    GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB                         = 0x8B4C, // decimal value: 35660
    GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS                           = 0x8B4D, // decimal value: 35661
    GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB                       = 0x8B4D, // decimal value: 35661
    GL_OBJECT_TYPE_ARB                                            = 0x8B4E, // decimal value: 35662
    GL_OBJECT_SUBTYPE_ARB                                         = 0x8B4F, // decimal value: 35663
    GL_OBJECT_DELETE_STATUS_ARB                                   = 0x8B80, // decimal value: 35712
    GL_OBJECT_COMPILE_STATUS_ARB                                  = 0x8B81, // decimal value: 35713
    GL_OBJECT_LINK_STATUS_ARB                                     = 0x8B82, // decimal value: 35714
    GL_OBJECT_VALIDATE_STATUS_ARB                                 = 0x8B83, // decimal value: 35715
    GL_OBJECT_INFO_LOG_LENGTH_ARB                                 = 0x8B84, // decimal value: 35716
    GL_OBJECT_ATTACHED_OBJECTS_ARB                                = 0x8B85, // decimal value: 35717
    GL_OBJECT_ACTIVE_UNIFORMS_ARB                                 = 0x8B86, // decimal value: 35718
    GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB                       = 0x8B87, // decimal value: 35719
    GL_OBJECT_SHADER_SOURCE_LENGTH_ARB                            = 0x8B88, // decimal value: 35720
    GL_OBJECT_ACTIVE_ATTRIBUTES_ARB                               = 0x8B89, // decimal value: 35721
    GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB                     = 0x8B8A, // decimal value: 35722
    GL_SHADING_LANGUAGE_VERSION_ARB                               = 0x8B8C, // decimal value: 35724
    GL_ACTIVE_PROGRAM_EXT                                         = 0x8B8D, // decimal value: 35725
    GL_CURRENT_PROGRAM                                            = 0x8B8D, // decimal value: 35725
    GL_PALETTE4_RGB8_OES                                          = 0x8B90, // decimal value: 35728
    GL_PALETTE4_RGBA8_OES                                         = 0x8B91, // decimal value: 35729
    GL_PALETTE4_R5_G6_B5_OES                                      = 0x8B92, // decimal value: 35730
    GL_PALETTE4_RGBA4_OES                                         = 0x8B93, // decimal value: 35731
    GL_PALETTE4_RGB5_A1_OES                                       = 0x8B94, // decimal value: 35732
    GL_PALETTE8_RGB8_OES                                          = 0x8B95, // decimal value: 35733
    GL_PALETTE8_RGBA8_OES                                         = 0x8B96, // decimal value: 35734
    GL_PALETTE8_R5_G6_B5_OES                                      = 0x8B97, // decimal value: 35735
    GL_PALETTE8_RGBA4_OES                                         = 0x8B98, // decimal value: 35736
    GL_PALETTE8_RGB5_A1_OES                                       = 0x8B99, // decimal value: 35737
    GL_IMPLEMENTATION_COLOR_READ_TYPE_OES                         = 0x8B9A, // decimal value: 35738
    GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES                       = 0x8B9B, // decimal value: 35739
    GL_TILE_RASTER_ORDER_FIXED_MESA                               = 0x8BB8, // decimal value: 35768
    GL_TILE_RASTER_ORDER_INCREASING_X_MESA                        = 0x8BB9, // decimal value: 35769
    GL_TILE_RASTER_ORDER_INCREASING_Y_MESA                        = 0x8BBA, // decimal value: 35770
    GL_COUNTER_TYPE_AMD                                           = 0x8BC0, // decimal value: 35776
    GL_COUNTER_RANGE_AMD                                          = 0x8BC1, // decimal value: 35777
    GL_UNSIGNED_INT64_AMD                                         = 0x8BC2, // decimal value: 35778
    GL_PERCENTAGE_AMD                                             = 0x8BC3, // decimal value: 35779
    GL_PERFMON_RESULT_AVAILABLE_AMD                               = 0x8BC4, // decimal value: 35780
    GL_PERFMON_RESULT_SIZE_AMD                                    = 0x8BC5, // decimal value: 35781
    GL_PERFMON_RESULT_AMD                                         = 0x8BC6, // decimal value: 35782
    GL_TEXTURE_RED_TYPE                                           = 0x8C10, // decimal value: 35856
    GL_TEXTURE_RED_TYPE_ARB                                       = 0x8C10, // decimal value: 35856
    GL_TEXTURE_GREEN_TYPE                                         = 0x8C11, // decimal value: 35857
    GL_TEXTURE_GREEN_TYPE_ARB                                     = 0x8C11, // decimal value: 35857
    GL_TEXTURE_BLUE_TYPE                                          = 0x8C12, // decimal value: 35858
    GL_TEXTURE_BLUE_TYPE_ARB                                      = 0x8C12, // decimal value: 35858
    GL_TEXTURE_ALPHA_TYPE                                         = 0x8C13, // decimal value: 35859
    GL_TEXTURE_ALPHA_TYPE_ARB                                     = 0x8C13, // decimal value: 35859
    GL_TEXTURE_LUMINANCE_TYPE                                     = 0x8C14, // decimal value: 35860
    GL_TEXTURE_LUMINANCE_TYPE_ARB                                 = 0x8C14, // decimal value: 35860
    GL_TEXTURE_INTENSITY_TYPE                                     = 0x8C15, // decimal value: 35861
    GL_TEXTURE_INTENSITY_TYPE_ARB                                 = 0x8C15, // decimal value: 35861
    GL_TEXTURE_DEPTH_TYPE                                         = 0x8C16, // decimal value: 35862
    GL_TEXTURE_DEPTH_TYPE_ARB                                     = 0x8C16, // decimal value: 35862
    GL_UNSIGNED_NORMALIZED                                        = 0x8C17, // decimal value: 35863
    GL_UNSIGNED_NORMALIZED_ARB                                    = 0x8C17, // decimal value: 35863
    GL_TEXTURE_1D_ARRAY_EXT                                       = 0x8C18, // decimal value: 35864
    GL_TEXTURE_2D_ARRAY_EXT                                       = 0x8C1A, // decimal value: 35866
    GL_TEXTURE_BINDING_1D_ARRAY                                   = 0x8C1C, // decimal value: 35868
    GL_TEXTURE_BINDING_1D_ARRAY_EXT                               = 0x8C1C, // decimal value: 35868
    GL_TEXTURE_BINDING_2D_ARRAY                                   = 0x8C1D, // decimal value: 35869
    GL_TEXTURE_BINDING_2D_ARRAY_EXT                               = 0x8C1D, // decimal value: 35869
    GL_GEOMETRY_PROGRAM_NV                                        = 0x8C26, // decimal value: 35878
    GL_MAX_PROGRAM_OUTPUT_VERTICES_NV                             = 0x8C27, // decimal value: 35879
    GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV                     = 0x8C28, // decimal value: 35880
    GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS                           = 0x8C29, // decimal value: 35881
    GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB                       = 0x8C29, // decimal value: 35881
    GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT                       = 0x8C29, // decimal value: 35881
    GL_TEXTURE_BUFFER_ARB                                         = 0x8C2A, // decimal value: 35882
    GL_TEXTURE_BUFFER_BINDING                                     = 0x8C2A, // decimal value: 35882
    GL_TEXTURE_BUFFER_EXT                                         = 0x8C2A, // decimal value: 35882
    GL_MAX_TEXTURE_BUFFER_SIZE                                    = 0x8C2B, // decimal value: 35883
    GL_MAX_TEXTURE_BUFFER_SIZE_ARB                                = 0x8C2B, // decimal value: 35883
    GL_MAX_TEXTURE_BUFFER_SIZE_EXT                                = 0x8C2B, // decimal value: 35883
    GL_TEXTURE_BINDING_BUFFER                                     = 0x8C2C, // decimal value: 35884
    GL_TEXTURE_BINDING_BUFFER_ARB                                 = 0x8C2C, // decimal value: 35884
    GL_TEXTURE_BINDING_BUFFER_EXT                                 = 0x8C2C, // decimal value: 35884
    GL_TEXTURE_BUFFER_DATA_STORE_BINDING                          = 0x8C2D, // decimal value: 35885
    GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB                      = 0x8C2D, // decimal value: 35885
    GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT                      = 0x8C2D, // decimal value: 35885
    GL_TEXTURE_BUFFER_FORMAT_ARB                                  = 0x8C2E, // decimal value: 35886
    GL_TEXTURE_BUFFER_FORMAT_EXT                                  = 0x8C2E, // decimal value: 35886
    GL_SAMPLE_SHADING                                             = 0x8C36, // decimal value: 35894
    GL_SAMPLE_SHADING_ARB                                         = 0x8C36, // decimal value: 35894
    GL_MIN_SAMPLE_SHADING_VALUE                                   = 0x8C37, // decimal value: 35895
    GL_MIN_SAMPLE_SHADING_VALUE_ARB                               = 0x8C37, // decimal value: 35895
    GL_UNSIGNED_INT_10F_11F_11F_REV_EXT                           = 0x8C3B, // decimal value: 35899
    GL_RGBA_SIGNED_COMPONENTS_EXT                                 = 0x8C3C, // decimal value: 35900
    GL_UNSIGNED_INT_5_9_9_9_REV                                   = 0x8C3E, // decimal value: 35902
    GL_UNSIGNED_INT_5_9_9_9_REV_EXT                               = 0x8C3E, // decimal value: 35902
    GL_TEXTURE_SHARED_SIZE                                        = 0x8C3F, // decimal value: 35903
    GL_TEXTURE_SHARED_SIZE_EXT                                    = 0x8C3F, // decimal value: 35903
    GL_SLUMINANCE_ALPHA                                           = 0x8C44, // decimal value: 35908
    GL_SLUMINANCE_ALPHA_EXT                                       = 0x8C44, // decimal value: 35908
    GL_SLUMINANCE8_ALPHA8                                         = 0x8C45, // decimal value: 35909
    GL_SLUMINANCE8_ALPHA8_EXT                                     = 0x8C45, // decimal value: 35909
    GL_SLUMINANCE                                                 = 0x8C46, // decimal value: 35910
    GL_SLUMINANCE_EXT                                             = 0x8C46, // decimal value: 35910
    GL_SLUMINANCE8                                                = 0x8C47, // decimal value: 35911
    GL_SLUMINANCE8_EXT                                            = 0x8C47, // decimal value: 35911
    GL_COMPRESSED_SRGB_EXT                                        = 0x8C48, // decimal value: 35912
    GL_COMPRESSED_SRGB_ALPHA_EXT                                  = 0x8C49, // decimal value: 35913
    GL_COMPRESSED_SLUMINANCE                                      = 0x8C4A, // decimal value: 35914
    GL_COMPRESSED_SLUMINANCE_EXT                                  = 0x8C4A, // decimal value: 35914
    GL_COMPRESSED_SLUMINANCE_ALPHA                                = 0x8C4B, // decimal value: 35915
    GL_COMPRESSED_SLUMINANCE_ALPHA_EXT                            = 0x8C4B, // decimal value: 35915
    GL_COMPRESSED_LUMINANCE_LATC1_EXT                             = 0x8C70, // decimal value: 35952
    GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT                      = 0x8C71, // decimal value: 35953
    GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT                       = 0x8C72, // decimal value: 35954
    GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT                = 0x8C73, // decimal value: 35955
    GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV                   = 0x8C74, // decimal value: 35956
    GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV                = 0x8C75, // decimal value: 35957
    GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT                  = 0x8C76, // decimal value: 35958
    GL_BACK_PRIMARY_COLOR_NV                                      = 0x8C77, // decimal value: 35959
    GL_BACK_SECONDARY_COLOR_NV                                    = 0x8C78, // decimal value: 35960
    GL_TEXTURE_COORD_NV                                           = 0x8C79, // decimal value: 35961
    GL_CLIP_DISTANCE_NV                                           = 0x8C7A, // decimal value: 35962
    GL_VERTEX_ID_NV                                               = 0x8C7B, // decimal value: 35963
    GL_PRIMITIVE_ID_NV                                            = 0x8C7C, // decimal value: 35964
    GL_GENERIC_ATTRIB_NV                                          = 0x8C7D, // decimal value: 35965
    GL_TRANSFORM_FEEDBACK_ATTRIBS_NV                              = 0x8C7E, // decimal value: 35966
    GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT                         = 0x8C7F, // decimal value: 35967
    GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV                          = 0x8C7F, // decimal value: 35967
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS                 = 0x8C80, // decimal value: 35968
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT             = 0x8C80, // decimal value: 35968
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV              = 0x8C80, // decimal value: 35968
    GL_ACTIVE_VARYINGS_NV                                         = 0x8C81, // decimal value: 35969
    GL_ACTIVE_VARYING_MAX_LENGTH_NV                               = 0x8C82, // decimal value: 35970
    GL_TRANSFORM_FEEDBACK_VARYINGS_EXT                            = 0x8C83, // decimal value: 35971
    GL_TRANSFORM_FEEDBACK_VARYINGS_NV                             = 0x8C83, // decimal value: 35971
    GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT                        = 0x8C84, // decimal value: 35972
    GL_TRANSFORM_FEEDBACK_BUFFER_START_NV                         = 0x8C84, // decimal value: 35972
    GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT                         = 0x8C85, // decimal value: 35973
    GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV                          = 0x8C85, // decimal value: 35973
    GL_TRANSFORM_FEEDBACK_RECORD_NV                               = 0x8C86, // decimal value: 35974
    GL_PRIMITIVES_GENERATED_EXT                                   = 0x8C87, // decimal value: 35975
    GL_PRIMITIVES_GENERATED_NV                                    = 0x8C87, // decimal value: 35975
    GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT                  = 0x8C88, // decimal value: 35976
    GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV                   = 0x8C88, // decimal value: 35976
    GL_RASTERIZER_DISCARD                                         = 0x8C89, // decimal value: 35977
    GL_RASTERIZER_DISCARD_EXT                                     = 0x8C89, // decimal value: 35977
    GL_RASTERIZER_DISCARD_NV                                      = 0x8C89, // decimal value: 35977
    GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS              = 0x8C8A, // decimal value: 35978
    GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT          = 0x8C8A, // decimal value: 35978
    GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV           = 0x8C8A, // decimal value: 35978
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS                    = 0x8C8B, // decimal value: 35979
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT                = 0x8C8B, // decimal value: 35979
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV                 = 0x8C8B, // decimal value: 35979
    GL_INTERLEAVED_ATTRIBS                                        = 0x8C8C, // decimal value: 35980
    GL_INTERLEAVED_ATTRIBS_EXT                                    = 0x8C8C, // decimal value: 35980
    GL_INTERLEAVED_ATTRIBS_NV                                     = 0x8C8C, // decimal value: 35980
    GL_SEPARATE_ATTRIBS                                           = 0x8C8D, // decimal value: 35981
    GL_SEPARATE_ATTRIBS_EXT                                       = 0x8C8D, // decimal value: 35981
    GL_SEPARATE_ATTRIBS_NV                                        = 0x8C8D, // decimal value: 35981
    GL_TRANSFORM_FEEDBACK_BUFFER_EXT                              = 0x8C8E, // decimal value: 35982
    GL_TRANSFORM_FEEDBACK_BUFFER_NV                               = 0x8C8E, // decimal value: 35982
    GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT                      = 0x8C8F, // decimal value: 35983
    GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV                       = 0x8C8F, // decimal value: 35983
    GL_POINT_SPRITE_COORD_ORIGIN                                  = 0x8CA0, // decimal value: 36000
    GL_STENCIL_BACK_REF                                           = 0x8CA3, // decimal value: 36003
    GL_STENCIL_BACK_VALUE_MASK                                    = 0x8CA4, // decimal value: 36004
    GL_STENCIL_BACK_WRITEMASK                                     = 0x8CA5, // decimal value: 36005
    GL_DRAW_FRAMEBUFFER_BINDING                                   = 0x8CA6, // decimal value: 36006
    GL_DRAW_FRAMEBUFFER_BINDING_EXT                               = 0x8CA6, // decimal value: 36006
    GL_FRAMEBUFFER_BINDING                                        = 0x8CA6, // decimal value: 36006
    GL_FRAMEBUFFER_BINDING_EXT                                    = 0x8CA6, // decimal value: 36006
    GL_RENDERBUFFER_BINDING                                       = 0x8CA7, // decimal value: 36007
    GL_RENDERBUFFER_BINDING_EXT                                   = 0x8CA7, // decimal value: 36007
    GL_READ_FRAMEBUFFER_EXT                                       = 0x8CA8, // decimal value: 36008
    GL_DRAW_FRAMEBUFFER_EXT                                       = 0x8CA9, // decimal value: 36009
    GL_READ_FRAMEBUFFER_BINDING                                   = 0x8CAA, // decimal value: 36010
    GL_READ_FRAMEBUFFER_BINDING_EXT                               = 0x8CAA, // decimal value: 36010
    GL_RENDERBUFFER_COVERAGE_SAMPLES_NV                           = 0x8CAB, // decimal value: 36011
    GL_RENDERBUFFER_SAMPLES_EXT                                   = 0x8CAB, // decimal value: 36011
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE                         = 0x8CD0, // decimal value: 36048
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT                     = 0x8CD0, // decimal value: 36048
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT                     = 0x8CD1, // decimal value: 36049
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT                   = 0x8CD2, // decimal value: 36050
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT           = 0x8CD3, // decimal value: 36051
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT              = 0x8CD4, // decimal value: 36052
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT                   = 0x8CD4, // decimal value: 36052
    GL_FRAMEBUFFER_COMPLETE_EXT                                   = 0x8CD5, // decimal value: 36053
    GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT                      = 0x8CD6, // decimal value: 36054
    GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT              = 0x8CD7, // decimal value: 36055
    GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT                      = 0x8CD9, // decimal value: 36057
    GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT                         = 0x8CDA, // decimal value: 36058
    GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT                     = 0x8CDB, // decimal value: 36059
    GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT                     = 0x8CDC, // decimal value: 36060
    GL_FRAMEBUFFER_UNSUPPORTED_EXT                                = 0x8CDD, // decimal value: 36061
    GL_STENCIL_ATTACHMENT                                         = 0x8D20, // decimal value: 36128
    GL_STENCIL_ATTACHMENT_EXT                                     = 0x8D20, // decimal value: 36128
    GL_FRAMEBUFFER_EXT                                            = 0x8D40, // decimal value: 36160
    GL_RENDERBUFFER_EXT                                           = 0x8D41, // decimal value: 36161
    GL_RENDERBUFFER_WIDTH_EXT                                     = 0x8D42, // decimal value: 36162
    GL_RENDERBUFFER_HEIGHT_EXT                                    = 0x8D43, // decimal value: 36163
    GL_RENDERBUFFER_INTERNAL_FORMAT_EXT                           = 0x8D44, // decimal value: 36164
    GL_STENCIL_INDEX1                                             = 0x8D46, // decimal value: 36166
    GL_STENCIL_INDEX1_EXT                                         = 0x8D46, // decimal value: 36166
    GL_STENCIL_INDEX4                                             = 0x8D47, // decimal value: 36167
    GL_STENCIL_INDEX4_EXT                                         = 0x8D47, // decimal value: 36167
    GL_STENCIL_INDEX8                                             = 0x8D48, // decimal value: 36168
    GL_STENCIL_INDEX8_EXT                                         = 0x8D48, // decimal value: 36168
    GL_STENCIL_INDEX16                                            = 0x8D49, // decimal value: 36169
    GL_STENCIL_INDEX16_EXT                                        = 0x8D49, // decimal value: 36169
    GL_RENDERBUFFER_RED_SIZE_EXT                                  = 0x8D50, // decimal value: 36176
    GL_RENDERBUFFER_GREEN_SIZE_EXT                                = 0x8D51, // decimal value: 36177
    GL_RENDERBUFFER_BLUE_SIZE_EXT                                 = 0x8D52, // decimal value: 36178
    GL_RENDERBUFFER_ALPHA_SIZE_EXT                                = 0x8D53, // decimal value: 36179
    GL_RENDERBUFFER_DEPTH_SIZE_EXT                                = 0x8D54, // decimal value: 36180
    GL_RENDERBUFFER_STENCIL_SIZE_EXT                              = 0x8D55, // decimal value: 36181
    GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT                     = 0x8D56, // decimal value: 36182
    GL_MAX_SAMPLES                                                = 0x8D57, // decimal value: 36183
    GL_MAX_SAMPLES_EXT                                            = 0x8D57, // decimal value: 36183
    GL_RGB565                                                     = 0x8D62, // decimal value: 36194
    GL_PRIMITIVE_RESTART_FIXED_INDEX                              = 0x8D69, // decimal value: 36201
    GL_MAX_ELEMENT_INDEX                                          = 0x8D6B, // decimal value: 36203
    GL_RGBA32UI_EXT                                               = 0x8D70, // decimal value: 36208
    GL_RGB32UI_EXT                                                = 0x8D71, // decimal value: 36209
    GL_ALPHA32UI_EXT                                              = 0x8D72, // decimal value: 36210
    GL_INTENSITY32UI_EXT                                          = 0x8D73, // decimal value: 36211
    GL_LUMINANCE32UI_EXT                                          = 0x8D74, // decimal value: 36212
    GL_LUMINANCE_ALPHA32UI_EXT                                    = 0x8D75, // decimal value: 36213
    GL_RGBA16UI_EXT                                               = 0x8D76, // decimal value: 36214
    GL_RGB16UI_EXT                                                = 0x8D77, // decimal value: 36215
    GL_ALPHA16UI_EXT                                              = 0x8D78, // decimal value: 36216
    GL_INTENSITY16UI_EXT                                          = 0x8D79, // decimal value: 36217
    GL_LUMINANCE16UI_EXT                                          = 0x8D7A, // decimal value: 36218
    GL_LUMINANCE_ALPHA16UI_EXT                                    = 0x8D7B, // decimal value: 36219
    GL_RGBA8UI_EXT                                                = 0x8D7C, // decimal value: 36220
    GL_RGB8UI_EXT                                                 = 0x8D7D, // decimal value: 36221
    GL_ALPHA8UI_EXT                                               = 0x8D7E, // decimal value: 36222
    GL_INTENSITY8UI_EXT                                           = 0x8D7F, // decimal value: 36223
    GL_LUMINANCE8UI_EXT                                           = 0x8D80, // decimal value: 36224
    GL_LUMINANCE_ALPHA8UI_EXT                                     = 0x8D81, // decimal value: 36225
    GL_RGBA32I_EXT                                                = 0x8D82, // decimal value: 36226
    GL_RGB32I_EXT                                                 = 0x8D83, // decimal value: 36227
    GL_ALPHA32I_EXT                                               = 0x8D84, // decimal value: 36228
    GL_INTENSITY32I_EXT                                           = 0x8D85, // decimal value: 36229
    GL_LUMINANCE32I_EXT                                           = 0x8D86, // decimal value: 36230
    GL_LUMINANCE_ALPHA32I_EXT                                     = 0x8D87, // decimal value: 36231
    GL_RGBA16I_EXT                                                = 0x8D88, // decimal value: 36232
    GL_RGB16I_EXT                                                 = 0x8D89, // decimal value: 36233
    GL_ALPHA16I_EXT                                               = 0x8D8A, // decimal value: 36234
    GL_INTENSITY16I_EXT                                           = 0x8D8B, // decimal value: 36235
    GL_LUMINANCE16I_EXT                                           = 0x8D8C, // decimal value: 36236
    GL_LUMINANCE_ALPHA16I_EXT                                     = 0x8D8D, // decimal value: 36237
    GL_RGBA8I_EXT                                                 = 0x8D8E, // decimal value: 36238
    GL_RGB8I_EXT                                                  = 0x8D8F, // decimal value: 36239
    GL_ALPHA8I_EXT                                                = 0x8D90, // decimal value: 36240
    GL_INTENSITY8I_EXT                                            = 0x8D91, // decimal value: 36241
    GL_LUMINANCE8I_EXT                                            = 0x8D92, // decimal value: 36242
    GL_LUMINANCE_ALPHA8I_EXT                                      = 0x8D93, // decimal value: 36243
    GL_RED_INTEGER                                                = 0x8D94, // decimal value: 36244
    GL_RED_INTEGER_EXT                                            = 0x8D94, // decimal value: 36244
    GL_GREEN_INTEGER                                              = 0x8D95, // decimal value: 36245
    GL_GREEN_INTEGER_EXT                                          = 0x8D95, // decimal value: 36245
    GL_BLUE_INTEGER                                               = 0x8D96, // decimal value: 36246
    GL_BLUE_INTEGER_EXT                                           = 0x8D96, // decimal value: 36246
    GL_ALPHA_INTEGER                                              = 0x8D97, // decimal value: 36247
    GL_ALPHA_INTEGER_EXT                                          = 0x8D97, // decimal value: 36247
    GL_RGB_INTEGER                                                = 0x8D98, // decimal value: 36248
    GL_RGB_INTEGER_EXT                                            = 0x8D98, // decimal value: 36248
    GL_RGBA_INTEGER                                               = 0x8D99, // decimal value: 36249
    GL_RGBA_INTEGER_EXT                                           = 0x8D99, // decimal value: 36249
    GL_BGR_INTEGER                                                = 0x8D9A, // decimal value: 36250
    GL_BGR_INTEGER_EXT                                            = 0x8D9A, // decimal value: 36250
    GL_BGRA_INTEGER                                               = 0x8D9B, // decimal value: 36251
    GL_BGRA_INTEGER_EXT                                           = 0x8D9B, // decimal value: 36251
    GL_LUMINANCE_INTEGER_EXT                                      = 0x8D9C, // decimal value: 36252
    GL_LUMINANCE_ALPHA_INTEGER_EXT                                = 0x8D9D, // decimal value: 36253
    GL_RGBA_INTEGER_MODE_EXT                                      = 0x8D9E, // decimal value: 36254
    GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV                   = 0x8DA0, // decimal value: 36256
    GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV                       = 0x8DA1, // decimal value: 36257
    GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV                         = 0x8DA2, // decimal value: 36258
    GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV                       = 0x8DA3, // decimal value: 36259
    GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV                       = 0x8DA4, // decimal value: 36260
    GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV                             = 0x8DA5, // decimal value: 36261
    GL_MAX_PROGRAM_GENERIC_RESULTS_NV                             = 0x8DA6, // decimal value: 36262
    GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB                         = 0x8DA7, // decimal value: 36263
    GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT                         = 0x8DA7, // decimal value: 36263
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB                   = 0x8DA8, // decimal value: 36264
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT                   = 0x8DA8, // decimal value: 36264
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB                     = 0x8DA9, // decimal value: 36265
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT                     = 0x8DA9, // decimal value: 36265
    GL_LAYER_NV                                                   = 0x8DAA, // decimal value: 36266
    GL_FLOAT_32_UNSIGNED_INT_24_8_REV                             = 0x8DAD, // decimal value: 36269
    GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV                          = 0x8DAD, // decimal value: 36269
    GL_SHADER_INCLUDE_ARB                                         = 0x8DAE, // decimal value: 36270
    GL_DEPTH_BUFFER_FLOAT_MODE_NV                                 = 0x8DAF, // decimal value: 36271
    GL_FRAMEBUFFER_SRGB                                           = 0x8DB9, // decimal value: 36281
    GL_FRAMEBUFFER_SRGB_EXT                                       = 0x8DB9, // decimal value: 36281
    GL_FRAMEBUFFER_SRGB_CAPABLE_EXT                               = 0x8DBA, // decimal value: 36282
    GL_COMPRESSED_RED_GREEN_RGTC2_EXT                             = 0x8DBD, // decimal value: 36285
    GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT                      = 0x8DBE, // decimal value: 36286
    GL_SAMPLER_1D_ARRAY                                           = 0x8DC0, // decimal value: 36288
    GL_SAMPLER_1D_ARRAY_EXT                                       = 0x8DC0, // decimal value: 36288
    GL_SAMPLER_2D_ARRAY                                           = 0x8DC1, // decimal value: 36289
    GL_SAMPLER_2D_ARRAY_EXT                                       = 0x8DC1, // decimal value: 36289
    GL_SAMPLER_BUFFER                                             = 0x8DC2, // decimal value: 36290
    GL_SAMPLER_BUFFER_EXT                                         = 0x8DC2, // decimal value: 36290
    GL_SAMPLER_1D_ARRAY_SHADOW                                    = 0x8DC3, // decimal value: 36291
    GL_SAMPLER_1D_ARRAY_SHADOW_EXT                                = 0x8DC3, // decimal value: 36291
    GL_SAMPLER_2D_ARRAY_SHADOW                                    = 0x8DC4, // decimal value: 36292
    GL_SAMPLER_2D_ARRAY_SHADOW_EXT                                = 0x8DC4, // decimal value: 36292
    GL_SAMPLER_CUBE_SHADOW                                        = 0x8DC5, // decimal value: 36293
    GL_SAMPLER_CUBE_SHADOW_EXT                                    = 0x8DC5, // decimal value: 36293
    GL_UNSIGNED_INT_VEC2                                          = 0x8DC6, // decimal value: 36294
    GL_UNSIGNED_INT_VEC2_EXT                                      = 0x8DC6, // decimal value: 36294
    GL_UNSIGNED_INT_VEC3                                          = 0x8DC7, // decimal value: 36295
    GL_UNSIGNED_INT_VEC3_EXT                                      = 0x8DC7, // decimal value: 36295
    GL_UNSIGNED_INT_VEC4                                          = 0x8DC8, // decimal value: 36296
    GL_UNSIGNED_INT_VEC4_EXT                                      = 0x8DC8, // decimal value: 36296
    GL_INT_SAMPLER_1D                                             = 0x8DC9, // decimal value: 36297
    GL_INT_SAMPLER_1D_EXT                                         = 0x8DC9, // decimal value: 36297
    GL_INT_SAMPLER_2D                                             = 0x8DCA, // decimal value: 36298
    GL_INT_SAMPLER_2D_EXT                                         = 0x8DCA, // decimal value: 36298
    GL_INT_SAMPLER_3D                                             = 0x8DCB, // decimal value: 36299
    GL_INT_SAMPLER_3D_EXT                                         = 0x8DCB, // decimal value: 36299
    GL_INT_SAMPLER_CUBE                                           = 0x8DCC, // decimal value: 36300
    GL_INT_SAMPLER_CUBE_EXT                                       = 0x8DCC, // decimal value: 36300
    GL_INT_SAMPLER_2D_RECT                                        = 0x8DCD, // decimal value: 36301
    GL_INT_SAMPLER_2D_RECT_EXT                                    = 0x8DCD, // decimal value: 36301
    GL_INT_SAMPLER_1D_ARRAY                                       = 0x8DCE, // decimal value: 36302
    GL_INT_SAMPLER_1D_ARRAY_EXT                                   = 0x8DCE, // decimal value: 36302
    GL_INT_SAMPLER_2D_ARRAY                                       = 0x8DCF, // decimal value: 36303
    GL_INT_SAMPLER_2D_ARRAY_EXT                                   = 0x8DCF, // decimal value: 36303
    GL_INT_SAMPLER_BUFFER                                         = 0x8DD0, // decimal value: 36304
    GL_INT_SAMPLER_BUFFER_EXT                                     = 0x8DD0, // decimal value: 36304
    GL_UNSIGNED_INT_SAMPLER_1D                                    = 0x8DD1, // decimal value: 36305
    GL_UNSIGNED_INT_SAMPLER_1D_EXT                                = 0x8DD1, // decimal value: 36305
    GL_UNSIGNED_INT_SAMPLER_2D                                    = 0x8DD2, // decimal value: 36306
    GL_UNSIGNED_INT_SAMPLER_2D_EXT                                = 0x8DD2, // decimal value: 36306
    GL_UNSIGNED_INT_SAMPLER_3D                                    = 0x8DD3, // decimal value: 36307
    GL_UNSIGNED_INT_SAMPLER_3D_EXT                                = 0x8DD3, // decimal value: 36307
    GL_UNSIGNED_INT_SAMPLER_CUBE                                  = 0x8DD4, // decimal value: 36308
    GL_UNSIGNED_INT_SAMPLER_CUBE_EXT                              = 0x8DD4, // decimal value: 36308
    GL_UNSIGNED_INT_SAMPLER_2D_RECT                               = 0x8DD5, // decimal value: 36309
    GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT                           = 0x8DD5, // decimal value: 36309
    GL_UNSIGNED_INT_SAMPLER_1D_ARRAY                              = 0x8DD6, // decimal value: 36310
    GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT                          = 0x8DD6, // decimal value: 36310
    GL_UNSIGNED_INT_SAMPLER_2D_ARRAY                              = 0x8DD7, // decimal value: 36311
    GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT                          = 0x8DD7, // decimal value: 36311
    GL_UNSIGNED_INT_SAMPLER_BUFFER                                = 0x8DD8, // decimal value: 36312
    GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT                            = 0x8DD8, // decimal value: 36312
    GL_GEOMETRY_SHADER_ARB                                        = 0x8DD9, // decimal value: 36313
    GL_GEOMETRY_SHADER_EXT                                        = 0x8DD9, // decimal value: 36313
    GL_GEOMETRY_VERTICES_OUT_ARB                                  = 0x8DDA, // decimal value: 36314
    GL_GEOMETRY_VERTICES_OUT_EXT                                  = 0x8DDA, // decimal value: 36314
    GL_GEOMETRY_INPUT_TYPE_ARB                                    = 0x8DDB, // decimal value: 36315
    GL_GEOMETRY_INPUT_TYPE_EXT                                    = 0x8DDB, // decimal value: 36315
    GL_GEOMETRY_OUTPUT_TYPE_ARB                                   = 0x8DDC, // decimal value: 36316
    GL_GEOMETRY_OUTPUT_TYPE_EXT                                   = 0x8DDC, // decimal value: 36316
    GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB                        = 0x8DDD, // decimal value: 36317
    GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT                        = 0x8DDD, // decimal value: 36317
    GL_MAX_VERTEX_VARYING_COMPONENTS_ARB                          = 0x8DDE, // decimal value: 36318
    GL_MAX_VERTEX_VARYING_COMPONENTS_EXT                          = 0x8DDE, // decimal value: 36318
    GL_MAX_GEOMETRY_UNIFORM_COMPONENTS                            = 0x8DDF, // decimal value: 36319
    GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB                        = 0x8DDF, // decimal value: 36319
    GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT                        = 0x8DDF, // decimal value: 36319
    GL_MAX_GEOMETRY_OUTPUT_VERTICES                               = 0x8DE0, // decimal value: 36320
    GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB                           = 0x8DE0, // decimal value: 36320
    GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT                           = 0x8DE0, // decimal value: 36320
    GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS                       = 0x8DE1, // decimal value: 36321
    GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB                   = 0x8DE1, // decimal value: 36321
    GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT                   = 0x8DE1, // decimal value: 36321
    GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT                           = 0x8DE2, // decimal value: 36322
    GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT                         = 0x8DE3, // decimal value: 36323
    GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT                         = 0x8DE4, // decimal value: 36324
    GL_MAX_SUBROUTINES                                            = 0x8DE7, // decimal value: 36327
    GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS                           = 0x8DE8, // decimal value: 36328
    GL_NAMED_STRING_LENGTH_ARB                                    = 0x8DE9, // decimal value: 36329
    GL_NAMED_STRING_TYPE_ARB                                      = 0x8DEA, // decimal value: 36330
    GL_MAX_BINDABLE_UNIFORM_SIZE_EXT                              = 0x8DED, // decimal value: 36333
    GL_UNIFORM_BUFFER_EXT                                         = 0x8DEE, // decimal value: 36334
    GL_UNIFORM_BUFFER_BINDING_EXT                                 = 0x8DEF, // decimal value: 36335
    GL_SHADER_BINARY_FORMATS                                      = 0x8DF8, // decimal value: 36344
    GL_NUM_SHADER_BINARY_FORMATS                                  = 0x8DF9, // decimal value: 36345
    GL_SHADER_COMPILER                                            = 0x8DFA, // decimal value: 36346
    GL_MAX_VERTEX_UNIFORM_VECTORS                                 = 0x8DFB, // decimal value: 36347
    GL_MAX_VARYING_VECTORS                                        = 0x8DFC, // decimal value: 36348
    GL_MAX_FRAGMENT_UNIFORM_VECTORS                               = 0x8DFD, // decimal value: 36349
    GL_RENDERBUFFER_COLOR_SAMPLES_NV                              = 0x8E10, // decimal value: 36368
    GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV                          = 0x8E11, // decimal value: 36369
    GL_MULTISAMPLE_COVERAGE_MODES_NV                              = 0x8E12, // decimal value: 36370
    GL_QUERY_WAIT_NV                                              = 0x8E13, // decimal value: 36371
    GL_QUERY_NO_WAIT_NV                                           = 0x8E14, // decimal value: 36372
    GL_QUERY_BY_REGION_WAIT_NV                                    = 0x8E15, // decimal value: 36373
    GL_QUERY_BY_REGION_NO_WAIT_NV                                 = 0x8E16, // decimal value: 36374
    GL_QUERY_WAIT_INVERTED                                        = 0x8E17, // decimal value: 36375
    GL_QUERY_NO_WAIT_INVERTED                                     = 0x8E18, // decimal value: 36376
    GL_QUERY_BY_REGION_WAIT_INVERTED                              = 0x8E19, // decimal value: 36377
    GL_QUERY_BY_REGION_NO_WAIT_INVERTED                           = 0x8E1A, // decimal value: 36378
    GL_POLYGON_OFFSET_CLAMP                                       = 0x8E1B, // decimal value: 36379
    GL_POLYGON_OFFSET_CLAMP_EXT                                   = 0x8E1B, // decimal value: 36379
    GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS               = 0x8E1E, // decimal value: 36382
    GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS            = 0x8E1F, // decimal value: 36383
    GL_COLOR_SAMPLES_NV                                           = 0x8E20, // decimal value: 36384
    GL_TRANSFORM_FEEDBACK_NV                                      = 0x8E22, // decimal value: 36386
    GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED                           = 0x8E23, // decimal value: 36387
    GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV                        = 0x8E23, // decimal value: 36387
    GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE                           = 0x8E24, // decimal value: 36388
    GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV                        = 0x8E24, // decimal value: 36388
    GL_TRANSFORM_FEEDBACK_BINDING                                 = 0x8E25, // decimal value: 36389
    GL_TRANSFORM_FEEDBACK_BINDING_NV                              = 0x8E25, // decimal value: 36389
    GL_FRAME_NV                                                   = 0x8E26, // decimal value: 36390
    GL_FIELDS_NV                                                  = 0x8E27, // decimal value: 36391
    GL_CURRENT_TIME_NV                                            = 0x8E28, // decimal value: 36392
    GL_TIMESTAMP                                                  = 0x8E28, // decimal value: 36392
    GL_NUM_FILL_STREAMS_NV                                        = 0x8E29, // decimal value: 36393
    GL_PRESENT_TIME_NV                                            = 0x8E2A, // decimal value: 36394
    GL_PRESENT_DURATION_NV                                        = 0x8E2B, // decimal value: 36395
    GL_PROGRAM_MATRIX_EXT                                         = 0x8E2D, // decimal value: 36397
    GL_TRANSPOSE_PROGRAM_MATRIX_EXT                               = 0x8E2E, // decimal value: 36398
    GL_PROGRAM_MATRIX_STACK_DEPTH_EXT                             = 0x8E2F, // decimal value: 36399
    GL_TEXTURE_SWIZZLE_R_EXT                                      = 0x8E42, // decimal value: 36418
    GL_TEXTURE_SWIZZLE_G_EXT                                      = 0x8E43, // decimal value: 36419
    GL_TEXTURE_SWIZZLE_B_EXT                                      = 0x8E44, // decimal value: 36420
    GL_TEXTURE_SWIZZLE_A_EXT                                      = 0x8E45, // decimal value: 36421
    GL_TEXTURE_SWIZZLE_RGBA_EXT                                   = 0x8E46, // decimal value: 36422
    GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION                   = 0x8E4C, // decimal value: 36428
    GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT               = 0x8E4C, // decimal value: 36428
    GL_FIRST_VERTEX_CONVENTION_EXT                                = 0x8E4D, // decimal value: 36429
    GL_LAST_VERTEX_CONVENTION_EXT                                 = 0x8E4E, // decimal value: 36430
    GL_PROVOKING_VERTEX                                           = 0x8E4F, // decimal value: 36431
    GL_PROVOKING_VERTEX_EXT                                       = 0x8E4F, // decimal value: 36431
    GL_SAMPLE_LOCATION_ARB                                        = 0x8E50, // decimal value: 36432
    GL_SAMPLE_LOCATION_NV                                         = 0x8E50, // decimal value: 36432
    GL_SAMPLE_POSITION                                            = 0x8E50, // decimal value: 36432
    GL_SAMPLE_POSITION_NV                                         = 0x8E50, // decimal value: 36432
    GL_SAMPLE_MASK                                                = 0x8E51, // decimal value: 36433
    GL_SAMPLE_MASK_NV                                             = 0x8E51, // decimal value: 36433
    GL_SAMPLE_MASK_VALUE                                          = 0x8E52, // decimal value: 36434
    GL_SAMPLE_MASK_VALUE_NV                                       = 0x8E52, // decimal value: 36434
    GL_TEXTURE_BINDING_RENDERBUFFER_NV                            = 0x8E53, // decimal value: 36435
    GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV                 = 0x8E54, // decimal value: 36436
    GL_TEXTURE_RENDERBUFFER_NV                                    = 0x8E55, // decimal value: 36437
    GL_SAMPLER_RENDERBUFFER_NV                                    = 0x8E56, // decimal value: 36438
    GL_INT_SAMPLER_RENDERBUFFER_NV                                = 0x8E57, // decimal value: 36439
    GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV                       = 0x8E58, // decimal value: 36440
    GL_MAX_SAMPLE_MASK_WORDS                                      = 0x8E59, // decimal value: 36441
    GL_MAX_SAMPLE_MASK_WORDS_NV                                   = 0x8E59, // decimal value: 36441
    GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV                        = 0x8E5A, // decimal value: 36442
    GL_MAX_GEOMETRY_SHADER_INVOCATIONS                            = 0x8E5A, // decimal value: 36442
    GL_MIN_FRAGMENT_INTERPOLATION_OFFSET                          = 0x8E5B, // decimal value: 36443
    GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV                       = 0x8E5B, // decimal value: 36443
    GL_MAX_FRAGMENT_INTERPOLATION_OFFSET                          = 0x8E5C, // decimal value: 36444
    GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV                       = 0x8E5C, // decimal value: 36444
    GL_FRAGMENT_INTERPOLATION_OFFSET_BITS                         = 0x8E5D, // decimal value: 36445
    GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV              = 0x8E5D, // decimal value: 36445
    GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET                          = 0x8E5E, // decimal value: 36446
    GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB                      = 0x8E5E, // decimal value: 36446
    GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV                       = 0x8E5E, // decimal value: 36446
    GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET                          = 0x8E5F, // decimal value: 36447
    GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB                      = 0x8E5F, // decimal value: 36447
    GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV                       = 0x8E5F, // decimal value: 36447
    GL_MAX_TRANSFORM_FEEDBACK_BUFFERS                             = 0x8E70, // decimal value: 36464
    GL_MAX_VERTEX_STREAMS                                         = 0x8E71, // decimal value: 36465
    GL_TESS_CONTROL_OUTPUT_VERTICES                               = 0x8E75, // decimal value: 36469
    GL_TESS_GEN_MODE                                              = 0x8E76, // decimal value: 36470
    GL_TESS_GEN_SPACING                                           = 0x8E77, // decimal value: 36471
    GL_TESS_GEN_VERTEX_ORDER                                      = 0x8E78, // decimal value: 36472
    GL_TESS_GEN_POINT_MODE                                        = 0x8E79, // decimal value: 36473
    GL_ISOLINES                                                   = 0x8E7A, // decimal value: 36474
    GL_FRACTIONAL_ODD                                             = 0x8E7B, // decimal value: 36475
    GL_FRACTIONAL_EVEN                                            = 0x8E7C, // decimal value: 36476
    GL_MAX_PATCH_VERTICES                                         = 0x8E7D, // decimal value: 36477
    GL_MAX_TESS_GEN_LEVEL                                         = 0x8E7E, // decimal value: 36478
    GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS                        = 0x8E7F, // decimal value: 36479
    GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS                     = 0x8E80, // decimal value: 36480
    GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS                       = 0x8E81, // decimal value: 36481
    GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS                    = 0x8E82, // decimal value: 36482
    GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS                         = 0x8E83, // decimal value: 36483
    GL_MAX_TESS_PATCH_COMPONENTS                                  = 0x8E84, // decimal value: 36484
    GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS                   = 0x8E85, // decimal value: 36485
    GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS                      = 0x8E86, // decimal value: 36486
    GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS                            = 0x8E89, // decimal value: 36489
    GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS                         = 0x8E8A, // decimal value: 36490
    GL_COMPRESSED_RGBA_BPTC_UNORM_ARB                             = 0x8E8C, // decimal value: 36492
    GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB                       = 0x8E8D, // decimal value: 36493
    GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB                       = 0x8E8E, // decimal value: 36494
    GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB                     = 0x8E8F, // decimal value: 36495
    GL_INCLUSIVE_EXT                                              = 0x8F10, // decimal value: 36624
    GL_EXCLUSIVE_EXT                                              = 0x8F11, // decimal value: 36625
    GL_WINDOW_RECTANGLE_EXT                                       = 0x8F12, // decimal value: 36626
    GL_WINDOW_RECTANGLE_MODE_EXT                                  = 0x8F13, // decimal value: 36627
    GL_MAX_WINDOW_RECTANGLES_EXT                                  = 0x8F14, // decimal value: 36628
    GL_NUM_WINDOW_RECTANGLES_EXT                                  = 0x8F15, // decimal value: 36629
    GL_BUFFER_GPU_ADDRESS_NV                                      = 0x8F1D, // decimal value: 36637
    GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV                             = 0x8F1E, // decimal value: 36638
    GL_ELEMENT_ARRAY_UNIFIED_NV                                   = 0x8F1F, // decimal value: 36639
    GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV                             = 0x8F20, // decimal value: 36640
    GL_VERTEX_ARRAY_ADDRESS_NV                                    = 0x8F21, // decimal value: 36641
    GL_NORMAL_ARRAY_ADDRESS_NV                                    = 0x8F22, // decimal value: 36642
    GL_COLOR_ARRAY_ADDRESS_NV                                     = 0x8F23, // decimal value: 36643
    GL_INDEX_ARRAY_ADDRESS_NV                                     = 0x8F24, // decimal value: 36644
    GL_TEXTURE_COORD_ARRAY_ADDRESS_NV                             = 0x8F25, // decimal value: 36645
    GL_EDGE_FLAG_ARRAY_ADDRESS_NV                                 = 0x8F26, // decimal value: 36646
    GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV                           = 0x8F27, // decimal value: 36647
    GL_FOG_COORD_ARRAY_ADDRESS_NV                                 = 0x8F28, // decimal value: 36648
    GL_ELEMENT_ARRAY_ADDRESS_NV                                   = 0x8F29, // decimal value: 36649
    GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV                              = 0x8F2A, // decimal value: 36650
    GL_VERTEX_ARRAY_LENGTH_NV                                     = 0x8F2B, // decimal value: 36651
    GL_NORMAL_ARRAY_LENGTH_NV                                     = 0x8F2C, // decimal value: 36652
    GL_COLOR_ARRAY_LENGTH_NV                                      = 0x8F2D, // decimal value: 36653
    GL_INDEX_ARRAY_LENGTH_NV                                      = 0x8F2E, // decimal value: 36654
    GL_TEXTURE_COORD_ARRAY_LENGTH_NV                              = 0x8F2F, // decimal value: 36655
    GL_EDGE_FLAG_ARRAY_LENGTH_NV                                  = 0x8F30, // decimal value: 36656
    GL_SECONDARY_COLOR_ARRAY_LENGTH_NV                            = 0x8F31, // decimal value: 36657
    GL_FOG_COORD_ARRAY_LENGTH_NV                                  = 0x8F32, // decimal value: 36658
    GL_ELEMENT_ARRAY_LENGTH_NV                                    = 0x8F33, // decimal value: 36659
    GL_GPU_ADDRESS_NV                                             = 0x8F34, // decimal value: 36660
    GL_MAX_SHADER_BUFFER_ADDRESS_NV                               = 0x8F35, // decimal value: 36661
    GL_COPY_READ_BUFFER_BINDING                                   = 0x8F36, // decimal value: 36662
    GL_COPY_WRITE_BUFFER_BINDING                                  = 0x8F37, // decimal value: 36663
    GL_MAX_IMAGE_UNITS                                            = 0x8F38, // decimal value: 36664
    GL_MAX_IMAGE_UNITS_EXT                                        = 0x8F38, // decimal value: 36664
    GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS              = 0x8F39, // decimal value: 36665
    GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT          = 0x8F39, // decimal value: 36665
    GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES                       = 0x8F39, // decimal value: 36665
    GL_IMAGE_BINDING_NAME                                         = 0x8F3A, // decimal value: 36666
    GL_IMAGE_BINDING_NAME_EXT                                     = 0x8F3A, // decimal value: 36666
    GL_IMAGE_BINDING_LEVEL                                        = 0x8F3B, // decimal value: 36667
    GL_IMAGE_BINDING_LEVEL_EXT                                    = 0x8F3B, // decimal value: 36667
    GL_IMAGE_BINDING_LAYERED                                      = 0x8F3C, // decimal value: 36668
    GL_IMAGE_BINDING_LAYERED_EXT                                  = 0x8F3C, // decimal value: 36668
    GL_IMAGE_BINDING_LAYER                                        = 0x8F3D, // decimal value: 36669
    GL_IMAGE_BINDING_LAYER_EXT                                    = 0x8F3D, // decimal value: 36669
    GL_IMAGE_BINDING_ACCESS                                       = 0x8F3E, // decimal value: 36670
    GL_IMAGE_BINDING_ACCESS_EXT                                   = 0x8F3E, // decimal value: 36670
    GL_DRAW_INDIRECT_UNIFIED_NV                                   = 0x8F40, // decimal value: 36672
    GL_DRAW_INDIRECT_ADDRESS_NV                                   = 0x8F41, // decimal value: 36673
    GL_DRAW_INDIRECT_LENGTH_NV                                    = 0x8F42, // decimal value: 36674
    GL_DRAW_INDIRECT_BUFFER_BINDING                               = 0x8F43, // decimal value: 36675
    GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV                       = 0x8F44, // decimal value: 36676
    GL_MAX_PROGRAM_SUBROUTINE_NUM_NV                              = 0x8F45, // decimal value: 36677
    GL_DOUBLE_MAT2                                                = 0x8F46, // decimal value: 36678
    GL_DOUBLE_MAT2_EXT                                            = 0x8F46, // decimal value: 36678
    GL_DOUBLE_MAT3                                                = 0x8F47, // decimal value: 36679
    GL_DOUBLE_MAT3_EXT                                            = 0x8F47, // decimal value: 36679
    GL_DOUBLE_MAT4                                                = 0x8F48, // decimal value: 36680
    GL_DOUBLE_MAT4_EXT                                            = 0x8F48, // decimal value: 36680
    GL_DOUBLE_MAT2x3                                              = 0x8F49, // decimal value: 36681
    GL_DOUBLE_MAT2x3_EXT                                          = 0x8F49, // decimal value: 36681
    GL_DOUBLE_MAT2x4                                              = 0x8F4A, // decimal value: 36682
    GL_DOUBLE_MAT2x4_EXT                                          = 0x8F4A, // decimal value: 36682
    GL_DOUBLE_MAT3x2                                              = 0x8F4B, // decimal value: 36683
    GL_DOUBLE_MAT3x2_EXT                                          = 0x8F4B, // decimal value: 36683
    GL_DOUBLE_MAT3x4                                              = 0x8F4C, // decimal value: 36684
    GL_DOUBLE_MAT3x4_EXT                                          = 0x8F4C, // decimal value: 36684
    GL_DOUBLE_MAT4x2                                              = 0x8F4D, // decimal value: 36685
    GL_DOUBLE_MAT4x2_EXT                                          = 0x8F4D, // decimal value: 36685
    GL_DOUBLE_MAT4x3                                              = 0x8F4E, // decimal value: 36686
    GL_DOUBLE_MAT4x3_EXT                                          = 0x8F4E, // decimal value: 36686
    GL_VERTEX_BINDING_BUFFER                                      = 0x8F4F, // decimal value: 36687
    GL_RED_SNORM                                                  = 0x8F90, // decimal value: 36752
    GL_RG_SNORM                                                   = 0x8F91, // decimal value: 36753
    GL_RGB_SNORM                                                  = 0x8F92, // decimal value: 36754
    GL_RGBA_SNORM                                                 = 0x8F93, // decimal value: 36755
    GL_RGBA16_SNORM                                               = 0x8F9B, // decimal value: 36763
    GL_SIGNED_NORMALIZED                                          = 0x8F9C, // decimal value: 36764
    GL_PRIMITIVE_RESTART                                          = 0x8F9D, // decimal value: 36765
    GL_PRIMITIVE_RESTART_INDEX                                    = 0x8F9E, // decimal value: 36766
    GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB                  = 0x8F9F, // decimal value: 36767
    GL_INT8_NV                                                    = 0x8FE0, // decimal value: 36832
    GL_INT8_VEC2_NV                                               = 0x8FE1, // decimal value: 36833
    GL_INT8_VEC3_NV                                               = 0x8FE2, // decimal value: 36834
    GL_INT8_VEC4_NV                                               = 0x8FE3, // decimal value: 36835
    GL_INT16_NV                                                   = 0x8FE4, // decimal value: 36836
    GL_INT16_VEC2_NV                                              = 0x8FE5, // decimal value: 36837
    GL_INT16_VEC3_NV                                              = 0x8FE6, // decimal value: 36838
    GL_INT16_VEC4_NV                                              = 0x8FE7, // decimal value: 36839
    GL_INT64_VEC2_ARB                                             = 0x8FE9, // decimal value: 36841
    GL_INT64_VEC2_NV                                              = 0x8FE9, // decimal value: 36841
    GL_INT64_VEC3_ARB                                             = 0x8FEA, // decimal value: 36842
    GL_INT64_VEC3_NV                                              = 0x8FEA, // decimal value: 36842
    GL_INT64_VEC4_ARB                                             = 0x8FEB, // decimal value: 36843
    GL_INT64_VEC4_NV                                              = 0x8FEB, // decimal value: 36843
    GL_UNSIGNED_INT8_NV                                           = 0x8FEC, // decimal value: 36844
    GL_UNSIGNED_INT8_VEC2_NV                                      = 0x8FED, // decimal value: 36845
    GL_UNSIGNED_INT8_VEC3_NV                                      = 0x8FEE, // decimal value: 36846
    GL_UNSIGNED_INT8_VEC4_NV                                      = 0x8FEF, // decimal value: 36847
    GL_UNSIGNED_INT16_NV                                          = 0x8FF0, // decimal value: 36848
    GL_UNSIGNED_INT16_VEC2_NV                                     = 0x8FF1, // decimal value: 36849
    GL_UNSIGNED_INT16_VEC3_NV                                     = 0x8FF2, // decimal value: 36850
    GL_UNSIGNED_INT16_VEC4_NV                                     = 0x8FF3, // decimal value: 36851
    GL_UNSIGNED_INT64_VEC2_ARB                                    = 0x8FF5, // decimal value: 36853
    GL_UNSIGNED_INT64_VEC2_NV                                     = 0x8FF5, // decimal value: 36853
    GL_UNSIGNED_INT64_VEC3_ARB                                    = 0x8FF6, // decimal value: 36854
    GL_UNSIGNED_INT64_VEC3_NV                                     = 0x8FF6, // decimal value: 36854
    GL_UNSIGNED_INT64_VEC4_ARB                                    = 0x8FF7, // decimal value: 36855
    GL_UNSIGNED_INT64_VEC4_NV                                     = 0x8FF7, // decimal value: 36855
    GL_FLOAT16_NV                                                 = 0x8FF8, // decimal value: 36856
    GL_FLOAT16_VEC2_NV                                            = 0x8FF9, // decimal value: 36857
    GL_FLOAT16_VEC3_NV                                            = 0x8FFA, // decimal value: 36858
    GL_FLOAT16_VEC4_NV                                            = 0x8FFB, // decimal value: 36859
    GL_DOUBLE_VEC2                                                = 0x8FFC, // decimal value: 36860
    GL_DOUBLE_VEC2_EXT                                            = 0x8FFC, // decimal value: 36860
    GL_DOUBLE_VEC3                                                = 0x8FFD, // decimal value: 36861
    GL_DOUBLE_VEC3_EXT                                            = 0x8FFD, // decimal value: 36861
    GL_DOUBLE_VEC4                                                = 0x8FFE, // decimal value: 36862
    GL_DOUBLE_VEC4_EXT                                            = 0x8FFE, // decimal value: 36862
    GL_SAMPLER_BUFFER_AMD                                         = 0x9001, // decimal value: 36865
    GL_INT_SAMPLER_BUFFER_AMD                                     = 0x9002, // decimal value: 36866
    GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD                            = 0x9003, // decimal value: 36867
    GL_TESSELLATION_MODE_AMD                                      = 0x9004, // decimal value: 36868
    GL_TESSELLATION_FACTOR_AMD                                    = 0x9005, // decimal value: 36869
    GL_DISCRETE_AMD                                               = 0x9006, // decimal value: 36870
    GL_CONTINUOUS_AMD                                             = 0x9007, // decimal value: 36871
    GL_TEXTURE_BINDING_CUBE_MAP_ARRAY                             = 0x900A, // decimal value: 36874
    GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB                         = 0x900A, // decimal value: 36874
    GL_SAMPLER_CUBE_MAP_ARRAY                                     = 0x900C, // decimal value: 36876
    GL_SAMPLER_CUBE_MAP_ARRAY_ARB                                 = 0x900C, // decimal value: 36876
    GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW                              = 0x900D, // decimal value: 36877
    GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB                          = 0x900D, // decimal value: 36877
    GL_INT_SAMPLER_CUBE_MAP_ARRAY                                 = 0x900E, // decimal value: 36878
    GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB                             = 0x900E, // decimal value: 36878
    GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY                        = 0x900F, // decimal value: 36879
    GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB                    = 0x900F, // decimal value: 36879
    GL_ALPHA_SNORM                                                = 0x9010, // decimal value: 36880
    GL_LUMINANCE_SNORM                                            = 0x9011, // decimal value: 36881
    GL_LUMINANCE_ALPHA_SNORM                                      = 0x9012, // decimal value: 36882
    GL_INTENSITY_SNORM                                            = 0x9013, // decimal value: 36883
    GL_ALPHA8_SNORM                                               = 0x9014, // decimal value: 36884
    GL_LUMINANCE8_SNORM                                           = 0x9015, // decimal value: 36885
    GL_LUMINANCE8_ALPHA8_SNORM                                    = 0x9016, // decimal value: 36886
    GL_INTENSITY8_SNORM                                           = 0x9017, // decimal value: 36887
    GL_ALPHA16_SNORM                                              = 0x9018, // decimal value: 36888
    GL_LUMINANCE16_SNORM                                          = 0x9019, // decimal value: 36889
    GL_LUMINANCE16_ALPHA16_SNORM                                  = 0x901A, // decimal value: 36890
    GL_INTENSITY16_SNORM                                          = 0x901B, // decimal value: 36891
    GL_FACTOR_MIN_AMD                                             = 0x901C, // decimal value: 36892
    GL_FACTOR_MAX_AMD                                             = 0x901D, // decimal value: 36893
    GL_DEPTH_CLAMP_NEAR_AMD                                       = 0x901E, // decimal value: 36894
    GL_DEPTH_CLAMP_FAR_AMD                                        = 0x901F, // decimal value: 36895
    GL_VIDEO_BUFFER_NV                                            = 0x9020, // decimal value: 36896
    GL_VIDEO_BUFFER_BINDING_NV                                    = 0x9021, // decimal value: 36897
    GL_FIELD_UPPER_NV                                             = 0x9022, // decimal value: 36898
    GL_FIELD_LOWER_NV                                             = 0x9023, // decimal value: 36899
    GL_NUM_VIDEO_CAPTURE_STREAMS_NV                               = 0x9024, // decimal value: 36900
    GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV                        = 0x9025, // decimal value: 36901
    GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV                          = 0x9026, // decimal value: 36902
    GL_LAST_VIDEO_CAPTURE_STATUS_NV                               = 0x9027, // decimal value: 36903
    GL_VIDEO_BUFFER_PITCH_NV                                      = 0x9028, // decimal value: 36904
    GL_VIDEO_COLOR_CONVERSION_MATRIX_NV                           = 0x9029, // decimal value: 36905
    GL_VIDEO_COLOR_CONVERSION_MAX_NV                              = 0x902A, // decimal value: 36906
    GL_VIDEO_COLOR_CONVERSION_MIN_NV                              = 0x902B, // decimal value: 36907
    GL_VIDEO_COLOR_CONVERSION_OFFSET_NV                           = 0x902C, // decimal value: 36908
    GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV                            = 0x902D, // decimal value: 36909
    GL_PARTIAL_SUCCESS_NV                                         = 0x902E, // decimal value: 36910
    GL_SUCCESS_NV                                                 = 0x902F, // decimal value: 36911
    GL_FAILURE_NV                                                 = 0x9030, // decimal value: 36912
    GL_YCBYCR8_422_NV                                             = 0x9031, // decimal value: 36913
    GL_YCBAYCR8A_4224_NV                                          = 0x9032, // decimal value: 36914
    GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV                              = 0x9033, // decimal value: 36915
    GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV                   = 0x9034, // decimal value: 36916
    GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV                              = 0x9035, // decimal value: 36917
    GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV                   = 0x9036, // decimal value: 36918
    GL_Z4Y12Z4CB12Z4CR12_444_NV                                   = 0x9037, // decimal value: 36919
    GL_VIDEO_CAPTURE_FRAME_WIDTH_NV                               = 0x9038, // decimal value: 36920
    GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV                              = 0x9039, // decimal value: 36921
    GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV                        = 0x903A, // decimal value: 36922
    GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV                        = 0x903B, // decimal value: 36923
    GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV                            = 0x903C, // decimal value: 36924
    GL_TEXTURE_COVERAGE_SAMPLES_NV                                = 0x9045, // decimal value: 36933
    GL_TEXTURE_COLOR_SAMPLES_NV                                   = 0x9046, // decimal value: 36934
    GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX                       = 0x9047, // decimal value: 36935
    GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX                 = 0x9048, // decimal value: 36936
    GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX               = 0x9049, // decimal value: 36937
    GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX                         = 0x904A, // decimal value: 36938
    GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX                         = 0x904B, // decimal value: 36939
    GL_IMAGE_1D                                                   = 0x904C, // decimal value: 36940
    GL_IMAGE_1D_EXT                                               = 0x904C, // decimal value: 36940
    GL_IMAGE_2D                                                   = 0x904D, // decimal value: 36941
    GL_IMAGE_2D_EXT                                               = 0x904D, // decimal value: 36941
    GL_IMAGE_3D                                                   = 0x904E, // decimal value: 36942
    GL_IMAGE_3D_EXT                                               = 0x904E, // decimal value: 36942
    GL_IMAGE_2D_RECT                                              = 0x904F, // decimal value: 36943
    GL_IMAGE_2D_RECT_EXT                                          = 0x904F, // decimal value: 36943
    GL_IMAGE_CUBE                                                 = 0x9050, // decimal value: 36944
    GL_IMAGE_CUBE_EXT                                             = 0x9050, // decimal value: 36944
    GL_IMAGE_BUFFER                                               = 0x9051, // decimal value: 36945
    GL_IMAGE_BUFFER_EXT                                           = 0x9051, // decimal value: 36945
    GL_IMAGE_1D_ARRAY                                             = 0x9052, // decimal value: 36946
    GL_IMAGE_1D_ARRAY_EXT                                         = 0x9052, // decimal value: 36946
    GL_IMAGE_2D_ARRAY                                             = 0x9053, // decimal value: 36947
    GL_IMAGE_2D_ARRAY_EXT                                         = 0x9053, // decimal value: 36947
    GL_IMAGE_CUBE_MAP_ARRAY                                       = 0x9054, // decimal value: 36948
    GL_IMAGE_CUBE_MAP_ARRAY_EXT                                   = 0x9054, // decimal value: 36948
    GL_IMAGE_2D_MULTISAMPLE                                       = 0x9055, // decimal value: 36949
    GL_IMAGE_2D_MULTISAMPLE_EXT                                   = 0x9055, // decimal value: 36949
    GL_IMAGE_2D_MULTISAMPLE_ARRAY                                 = 0x9056, // decimal value: 36950
    GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT                             = 0x9056, // decimal value: 36950
    GL_INT_IMAGE_1D                                               = 0x9057, // decimal value: 36951
    GL_INT_IMAGE_1D_EXT                                           = 0x9057, // decimal value: 36951
    GL_INT_IMAGE_2D                                               = 0x9058, // decimal value: 36952
    GL_INT_IMAGE_2D_EXT                                           = 0x9058, // decimal value: 36952
    GL_INT_IMAGE_3D                                               = 0x9059, // decimal value: 36953
    GL_INT_IMAGE_3D_EXT                                           = 0x9059, // decimal value: 36953
    GL_INT_IMAGE_2D_RECT                                          = 0x905A, // decimal value: 36954
    GL_INT_IMAGE_2D_RECT_EXT                                      = 0x905A, // decimal value: 36954
    GL_INT_IMAGE_CUBE                                             = 0x905B, // decimal value: 36955
    GL_INT_IMAGE_CUBE_EXT                                         = 0x905B, // decimal value: 36955
    GL_INT_IMAGE_BUFFER                                           = 0x905C, // decimal value: 36956
    GL_INT_IMAGE_BUFFER_EXT                                       = 0x905C, // decimal value: 36956
    GL_INT_IMAGE_1D_ARRAY                                         = 0x905D, // decimal value: 36957
    GL_INT_IMAGE_1D_ARRAY_EXT                                     = 0x905D, // decimal value: 36957
    GL_INT_IMAGE_2D_ARRAY                                         = 0x905E, // decimal value: 36958
    GL_INT_IMAGE_2D_ARRAY_EXT                                     = 0x905E, // decimal value: 36958
    GL_INT_IMAGE_CUBE_MAP_ARRAY                                   = 0x905F, // decimal value: 36959
    GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT                               = 0x905F, // decimal value: 36959
    GL_INT_IMAGE_2D_MULTISAMPLE                                   = 0x9060, // decimal value: 36960
    GL_INT_IMAGE_2D_MULTISAMPLE_EXT                               = 0x9060, // decimal value: 36960
    GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY                             = 0x9061, // decimal value: 36961
    GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT                         = 0x9061, // decimal value: 36961
    GL_UNSIGNED_INT_IMAGE_1D                                      = 0x9062, // decimal value: 36962
    GL_UNSIGNED_INT_IMAGE_1D_EXT                                  = 0x9062, // decimal value: 36962
    GL_UNSIGNED_INT_IMAGE_2D                                      = 0x9063, // decimal value: 36963
    GL_UNSIGNED_INT_IMAGE_2D_EXT                                  = 0x9063, // decimal value: 36963
    GL_UNSIGNED_INT_IMAGE_3D                                      = 0x9064, // decimal value: 36964
    GL_UNSIGNED_INT_IMAGE_3D_EXT                                  = 0x9064, // decimal value: 36964
    GL_UNSIGNED_INT_IMAGE_2D_RECT                                 = 0x9065, // decimal value: 36965
    GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT                             = 0x9065, // decimal value: 36965
    GL_UNSIGNED_INT_IMAGE_CUBE                                    = 0x9066, // decimal value: 36966
    GL_UNSIGNED_INT_IMAGE_CUBE_EXT                                = 0x9066, // decimal value: 36966
    GL_UNSIGNED_INT_IMAGE_BUFFER                                  = 0x9067, // decimal value: 36967
    GL_UNSIGNED_INT_IMAGE_BUFFER_EXT                              = 0x9067, // decimal value: 36967
    GL_UNSIGNED_INT_IMAGE_1D_ARRAY                                = 0x9068, // decimal value: 36968
    GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT                            = 0x9068, // decimal value: 36968
    GL_UNSIGNED_INT_IMAGE_2D_ARRAY                                = 0x9069, // decimal value: 36969
    GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT                            = 0x9069, // decimal value: 36969
    GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY                          = 0x906A, // decimal value: 36970
    GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT                      = 0x906A, // decimal value: 36970
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE                          = 0x906B, // decimal value: 36971
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT                      = 0x906B, // decimal value: 36971
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY                    = 0x906C, // decimal value: 36972
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT                = 0x906C, // decimal value: 36972
    GL_MAX_IMAGE_SAMPLES                                          = 0x906D, // decimal value: 36973
    GL_MAX_IMAGE_SAMPLES_EXT                                      = 0x906D, // decimal value: 36973
    GL_IMAGE_BINDING_FORMAT                                       = 0x906E, // decimal value: 36974
    GL_IMAGE_BINDING_FORMAT_EXT                                   = 0x906E, // decimal value: 36974
    GL_SQUARE_NV                                                  = 0x90A3, // decimal value: 37027
    GL_ROUND_NV                                                   = 0x90A4, // decimal value: 37028
    GL_TRIANGULAR_NV                                              = 0x90A5, // decimal value: 37029
    GL_BEVEL_NV                                                   = 0x90A6, // decimal value: 37030
    GL_MITER_REVERT_NV                                            = 0x90A7, // decimal value: 37031
    GL_MITER_TRUNCATE_NV                                          = 0x90A8, // decimal value: 37032
    GL_PATH_ERROR_POSITION_NV                                     = 0x90AB, // decimal value: 37035
    GL_PATH_FOG_GEN_MODE_NV                                       = 0x90AC, // decimal value: 37036
    GL_PATH_GEN_MODE_NV                                           = 0x90B0, // decimal value: 37040
    GL_PATH_GEN_COEFF_NV                                          = 0x90B1, // decimal value: 37041
    GL_PATH_GEN_COLOR_FORMAT_NV                                   = 0x90B2, // decimal value: 37042
    GL_PATH_GEN_COMPONENTS_NV                                     = 0x90B3, // decimal value: 37043
    GL_MOVE_TO_RESETS_NV                                          = 0x90B5, // decimal value: 37045
    GL_MOVE_TO_CONTINUES_NV                                       = 0x90B6, // decimal value: 37046
    GL_PATH_STENCIL_FUNC_NV                                       = 0x90B7, // decimal value: 37047
    GL_PATH_STENCIL_REF_NV                                        = 0x90B8, // decimal value: 37048
    GL_PATH_STENCIL_VALUE_MASK_NV                                 = 0x90B9, // decimal value: 37049
    GL_SCALED_RESOLVE_FASTEST_EXT                                 = 0x90BA, // decimal value: 37050
    GL_SCALED_RESOLVE_NICEST_EXT                                  = 0x90BB, // decimal value: 37051
    GL_MIN_MAP_BUFFER_ALIGNMENT                                   = 0x90BC, // decimal value: 37052
    GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV                        = 0x90BD, // decimal value: 37053
    GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV                         = 0x90BE, // decimal value: 37054
    GL_PATH_COVER_DEPTH_FUNC_NV                                   = 0x90BF, // decimal value: 37055
    GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE                         = 0x90C8, // decimal value: 37064
    GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS                        = 0x90C9, // decimal value: 37065
    GL_MAX_VERTEX_IMAGE_UNIFORMS                                  = 0x90CA, // decimal value: 37066
    GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS                            = 0x90CB, // decimal value: 37067
    GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS                         = 0x90CC, // decimal value: 37068
    GL_MAX_GEOMETRY_IMAGE_UNIFORMS                                = 0x90CD, // decimal value: 37069
    GL_MAX_FRAGMENT_IMAGE_UNIFORMS                                = 0x90CE, // decimal value: 37070
    GL_MAX_COMBINED_IMAGE_UNIFORMS                                = 0x90CF, // decimal value: 37071
    GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV                        = 0x90D0, // decimal value: 37072
    GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV                               = 0x90D1, // decimal value: 37073
    GL_SHADER_STORAGE_BUFFER_BINDING                              = 0x90D3, // decimal value: 37075
    GL_SHADER_STORAGE_BUFFER_START                                = 0x90D4, // decimal value: 37076
    GL_SHADER_STORAGE_BUFFER_SIZE                                 = 0x90D5, // decimal value: 37077
    GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS                           = 0x90D6, // decimal value: 37078
    GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS                         = 0x90D7, // decimal value: 37079
    GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS                     = 0x90D8, // decimal value: 37080
    GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS                  = 0x90D9, // decimal value: 37081
    GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS                         = 0x90DA, // decimal value: 37082
    GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS                          = 0x90DB, // decimal value: 37083
    GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS                         = 0x90DC, // decimal value: 37084
    GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS                         = 0x90DD, // decimal value: 37085
    GL_MAX_SHADER_STORAGE_BLOCK_SIZE                              = 0x90DE, // decimal value: 37086
    GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT                     = 0x90DF, // decimal value: 37087
    GL_SYNC_X11_FENCE_EXT                                         = 0x90E1, // decimal value: 37089
    GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB                    = 0x90EB, // decimal value: 37099
    GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS                         = 0x90EB, // decimal value: 37099
    GL_DISPATCH_INDIRECT_BUFFER_BINDING                           = 0x90EF, // decimal value: 37103
    GL_CONTEXT_ROBUST_ACCESS                                      = 0x90F3, // decimal value: 37107
    GL_COMPUTE_PROGRAM_NV                                         = 0x90FB, // decimal value: 37115
    GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV                        = 0x90FC, // decimal value: 37116
    GL_TEXTURE_BINDING_2D_MULTISAMPLE                             = 0x9104, // decimal value: 37124
    GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY                       = 0x9105, // decimal value: 37125
    GL_TEXTURE_SAMPLES                                            = 0x9106, // decimal value: 37126
    GL_TEXTURE_FIXED_SAMPLE_LOCATIONS                             = 0x9107, // decimal value: 37127
    GL_SAMPLER_2D_MULTISAMPLE                                     = 0x9108, // decimal value: 37128
    GL_INT_SAMPLER_2D_MULTISAMPLE                                 = 0x9109, // decimal value: 37129
    GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE                        = 0x910A, // decimal value: 37130
    GL_SAMPLER_2D_MULTISAMPLE_ARRAY                               = 0x910B, // decimal value: 37131
    GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                           = 0x910C, // decimal value: 37132
    GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                  = 0x910D, // decimal value: 37133
    GL_MAX_COLOR_TEXTURE_SAMPLES                                  = 0x910E, // decimal value: 37134
    GL_MAX_DEPTH_TEXTURE_SAMPLES                                  = 0x910F, // decimal value: 37135
    GL_MAX_INTEGER_SAMPLES                                        = 0x9110, // decimal value: 37136
    GL_MAX_SERVER_WAIT_TIMEOUT                                    = 0x9111, // decimal value: 37137
    GL_SYNC_FENCE                                                 = 0x9116, // decimal value: 37142
    GL_UNSIGNALED                                                 = 0x9118, // decimal value: 37144
    GL_SIGNALED                                                   = 0x9119, // decimal value: 37145
    GL_MAX_VERTEX_OUTPUT_COMPONENTS                               = 0x9122, // decimal value: 37154
    GL_MAX_GEOMETRY_INPUT_COMPONENTS                              = 0x9123, // decimal value: 37155
    GL_MAX_GEOMETRY_OUTPUT_COMPONENTS                             = 0x9124, // decimal value: 37156
    GL_MAX_FRAGMENT_INPUT_COMPONENTS                              = 0x9125, // decimal value: 37157
    GL_CONTEXT_PROFILE_MASK                                       = 0x9126, // decimal value: 37158
    GL_UNPACK_COMPRESSED_BLOCK_WIDTH                              = 0x9127, // decimal value: 37159
    GL_UNPACK_COMPRESSED_BLOCK_HEIGHT                             = 0x9128, // decimal value: 37160
    GL_UNPACK_COMPRESSED_BLOCK_DEPTH                              = 0x9129, // decimal value: 37161
    GL_UNPACK_COMPRESSED_BLOCK_SIZE                               = 0x912A, // decimal value: 37162
    GL_PACK_COMPRESSED_BLOCK_WIDTH                                = 0x912B, // decimal value: 37163
    GL_PACK_COMPRESSED_BLOCK_HEIGHT                               = 0x912C, // decimal value: 37164
    GL_PACK_COMPRESSED_BLOCK_DEPTH                                = 0x912D, // decimal value: 37165
    GL_PACK_COMPRESSED_BLOCK_SIZE                                 = 0x912E, // decimal value: 37166
    GL_TEXTURE_IMMUTABLE_FORMAT                                   = 0x912F, // decimal value: 37167
    GL_MAX_DEBUG_MESSAGE_LENGTH                                   = 0x9143, // decimal value: 37187
    GL_MAX_DEBUG_MESSAGE_LENGTH_AMD                               = 0x9143, // decimal value: 37187
    GL_MAX_DEBUG_MESSAGE_LENGTH_ARB                               = 0x9143, // decimal value: 37187
    GL_MAX_DEBUG_LOGGED_MESSAGES                                  = 0x9144, // decimal value: 37188
    GL_MAX_DEBUG_LOGGED_MESSAGES_AMD                              = 0x9144, // decimal value: 37188
    GL_MAX_DEBUG_LOGGED_MESSAGES_ARB                              = 0x9144, // decimal value: 37188
    GL_DEBUG_LOGGED_MESSAGES                                      = 0x9145, // decimal value: 37189
    GL_DEBUG_LOGGED_MESSAGES_AMD                                  = 0x9145, // decimal value: 37189
    GL_DEBUG_LOGGED_MESSAGES_ARB                                  = 0x9145, // decimal value: 37189
    GL_DEBUG_SEVERITY_HIGH_AMD                                    = 0x9146, // decimal value: 37190
    GL_DEBUG_SEVERITY_HIGH_ARB                                    = 0x9146, // decimal value: 37190
    GL_DEBUG_SEVERITY_MEDIUM_AMD                                  = 0x9147, // decimal value: 37191
    GL_DEBUG_SEVERITY_MEDIUM_ARB                                  = 0x9147, // decimal value: 37191
    GL_DEBUG_SEVERITY_LOW_AMD                                     = 0x9148, // decimal value: 37192
    GL_DEBUG_SEVERITY_LOW_ARB                                     = 0x9148, // decimal value: 37192
    GL_DEBUG_CATEGORY_API_ERROR_AMD                               = 0x9149, // decimal value: 37193
    GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD                           = 0x914A, // decimal value: 37194
    GL_DEBUG_CATEGORY_DEPRECATION_AMD                             = 0x914B, // decimal value: 37195
    GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD                      = 0x914C, // decimal value: 37196
    GL_DEBUG_CATEGORY_PERFORMANCE_AMD                             = 0x914D, // decimal value: 37197
    GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD                         = 0x914E, // decimal value: 37198
    GL_DEBUG_CATEGORY_APPLICATION_AMD                             = 0x914F, // decimal value: 37199
    GL_DEBUG_CATEGORY_OTHER_AMD                                   = 0x9150, // decimal value: 37200
    GL_BUFFER_OBJECT_EXT                                          = 0x9151, // decimal value: 37201
    GL_DATA_BUFFER_AMD                                            = 0x9151, // decimal value: 37201
    GL_PERFORMANCE_MONITOR_AMD                                    = 0x9152, // decimal value: 37202
    GL_QUERY_OBJECT_AMD                                           = 0x9153, // decimal value: 37203
    GL_QUERY_OBJECT_EXT                                           = 0x9153, // decimal value: 37203
    GL_VERTEX_ARRAY_OBJECT_AMD                                    = 0x9154, // decimal value: 37204
    GL_VERTEX_ARRAY_OBJECT_EXT                                    = 0x9154, // decimal value: 37204
    GL_SAMPLER_OBJECT_AMD                                         = 0x9155, // decimal value: 37205
    GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD                         = 0x9160, // decimal value: 37216
    GL_QUERY_BUFFER_AMD                                           = 0x9192, // decimal value: 37266
    GL_QUERY_BUFFER_BINDING                                       = 0x9193, // decimal value: 37267
    GL_QUERY_BUFFER_BINDING_AMD                                   = 0x9193, // decimal value: 37267
    GL_QUERY_RESULT_NO_WAIT_AMD                                   = 0x9194, // decimal value: 37268
    GL_VIRTUAL_PAGE_SIZE_X_AMD                                    = 0x9195, // decimal value: 37269
    GL_VIRTUAL_PAGE_SIZE_X_ARB                                    = 0x9195, // decimal value: 37269
    GL_VIRTUAL_PAGE_SIZE_Y_AMD                                    = 0x9196, // decimal value: 37270
    GL_VIRTUAL_PAGE_SIZE_Y_ARB                                    = 0x9196, // decimal value: 37270
    GL_VIRTUAL_PAGE_SIZE_Z_AMD                                    = 0x9197, // decimal value: 37271
    GL_VIRTUAL_PAGE_SIZE_Z_ARB                                    = 0x9197, // decimal value: 37271
    GL_MAX_SPARSE_TEXTURE_SIZE_AMD                                = 0x9198, // decimal value: 37272
    GL_MAX_SPARSE_TEXTURE_SIZE_ARB                                = 0x9198, // decimal value: 37272
    GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD                             = 0x9199, // decimal value: 37273
    GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB                             = 0x9199, // decimal value: 37273
    GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS                            = 0x919A, // decimal value: 37274
    GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB                        = 0x919A, // decimal value: 37274
    GL_MIN_SPARSE_LEVEL_AMD                                       = 0x919B, // decimal value: 37275
    GL_MIN_LOD_WARNING_AMD                                        = 0x919C, // decimal value: 37276
    GL_TEXTURE_BUFFER_OFFSET                                      = 0x919D, // decimal value: 37277
    GL_TEXTURE_BUFFER_SIZE                                        = 0x919E, // decimal value: 37278
    GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT                            = 0x919F, // decimal value: 37279
    GL_STREAM_RASTERIZATION_AMD                                   = 0x91A0, // decimal value: 37280
    GL_VERTEX_ELEMENT_SWIZZLE_AMD                                 = 0x91A4, // decimal value: 37284
    GL_VERTEX_ID_SWIZZLE_AMD                                      = 0x91A5, // decimal value: 37285
    GL_TEXTURE_SPARSE_ARB                                         = 0x91A6, // decimal value: 37286
    GL_VIRTUAL_PAGE_SIZE_INDEX_ARB                                = 0x91A7, // decimal value: 37287
    GL_NUM_VIRTUAL_PAGE_SIZES_ARB                                 = 0x91A8, // decimal value: 37288
    GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB                 = 0x91A9, // decimal value: 37289
    GL_NUM_SPARSE_LEVELS_ARB                                      = 0x91AA, // decimal value: 37290
    GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD                            = 0x91AE, // decimal value: 37294
    GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD                            = 0x91AF, // decimal value: 37295
    GL_MAX_SHADER_COMPILER_THREADS_ARB                            = 0x91B0, // decimal value: 37296
    GL_MAX_SHADER_COMPILER_THREADS_KHR                            = 0x91B0, // decimal value: 37296
    GL_COMPLETION_STATUS_ARB                                      = 0x91B1, // decimal value: 37297
    GL_COMPLETION_STATUS_KHR                                      = 0x91B1, // decimal value: 37297
    GL_MAX_COMPUTE_UNIFORM_BLOCKS                                 = 0x91BB, // decimal value: 37307
    GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS                            = 0x91BC, // decimal value: 37308
    GL_MAX_COMPUTE_IMAGE_UNIFORMS                                 = 0x91BD, // decimal value: 37309
    GL_MAX_COMPUTE_WORK_GROUP_COUNT                               = 0x91BE, // decimal value: 37310
    GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB                           = 0x91BF, // decimal value: 37311
    GL_MAX_COMPUTE_WORK_GROUP_SIZE                                = 0x91BF, // decimal value: 37311
    GL_FLOAT16_MAT2_AMD                                           = 0x91C5, // decimal value: 37317
    GL_FLOAT16_MAT3_AMD                                           = 0x91C6, // decimal value: 37318
    GL_FLOAT16_MAT4_AMD                                           = 0x91C7, // decimal value: 37319
    GL_FLOAT16_MAT2x3_AMD                                         = 0x91C8, // decimal value: 37320
    GL_FLOAT16_MAT2x4_AMD                                         = 0x91C9, // decimal value: 37321
    GL_FLOAT16_MAT3x2_AMD                                         = 0x91CA, // decimal value: 37322
    GL_FLOAT16_MAT3x4_AMD                                         = 0x91CB, // decimal value: 37323
    GL_FLOAT16_MAT4x2_AMD                                         = 0x91CC, // decimal value: 37324
    GL_FLOAT16_MAT4x3_AMD                                         = 0x91CD, // decimal value: 37325
    GL_BLEND_PREMULTIPLIED_SRC_NV                                 = 0x9280, // decimal value: 37504
    GL_BLEND_OVERLAP_NV                                           = 0x9281, // decimal value: 37505
    GL_UNCORRELATED_NV                                            = 0x9282, // decimal value: 37506
    GL_DISJOINT_NV                                                = 0x9283, // decimal value: 37507
    GL_CONJOINT_NV                                                = 0x9284, // decimal value: 37508
    GL_BLEND_ADVANCED_COHERENT_KHR                                = 0x9285, // decimal value: 37509
    GL_BLEND_ADVANCED_COHERENT_NV                                 = 0x9285, // decimal value: 37509
    GL_SRC_NV                                                     = 0x9286, // decimal value: 37510
    GL_DST_NV                                                     = 0x9287, // decimal value: 37511
    GL_SRC_OVER_NV                                                = 0x9288, // decimal value: 37512
    GL_DST_OVER_NV                                                = 0x9289, // decimal value: 37513
    GL_SRC_IN_NV                                                  = 0x928A, // decimal value: 37514
    GL_DST_IN_NV                                                  = 0x928B, // decimal value: 37515
    GL_SRC_OUT_NV                                                 = 0x928C, // decimal value: 37516
    GL_DST_OUT_NV                                                 = 0x928D, // decimal value: 37517
    GL_SRC_ATOP_NV                                                = 0x928E, // decimal value: 37518
    GL_DST_ATOP_NV                                                = 0x928F, // decimal value: 37519
    GL_PLUS_NV                                                    = 0x9291, // decimal value: 37521
    GL_PLUS_DARKER_NV                                             = 0x9292, // decimal value: 37522
    GL_MULTIPLY_KHR                                               = 0x9294, // decimal value: 37524
    GL_MULTIPLY_NV                                                = 0x9294, // decimal value: 37524
    GL_SCREEN_KHR                                                 = 0x9295, // decimal value: 37525
    GL_SCREEN_NV                                                  = 0x9295, // decimal value: 37525
    GL_OVERLAY_KHR                                                = 0x9296, // decimal value: 37526
    GL_OVERLAY_NV                                                 = 0x9296, // decimal value: 37526
    GL_DARKEN_KHR                                                 = 0x9297, // decimal value: 37527
    GL_DARKEN_NV                                                  = 0x9297, // decimal value: 37527
    GL_LIGHTEN_KHR                                                = 0x9298, // decimal value: 37528
    GL_LIGHTEN_NV                                                 = 0x9298, // decimal value: 37528
    GL_COLORDODGE_KHR                                             = 0x9299, // decimal value: 37529
    GL_COLORDODGE_NV                                              = 0x9299, // decimal value: 37529
    GL_COLORBURN_KHR                                              = 0x929A, // decimal value: 37530
    GL_COLORBURN_NV                                               = 0x929A, // decimal value: 37530
    GL_HARDLIGHT_KHR                                              = 0x929B, // decimal value: 37531
    GL_HARDLIGHT_NV                                               = 0x929B, // decimal value: 37531
    GL_SOFTLIGHT_KHR                                              = 0x929C, // decimal value: 37532
    GL_SOFTLIGHT_NV                                               = 0x929C, // decimal value: 37532
    GL_DIFFERENCE_KHR                                             = 0x929E, // decimal value: 37534
    GL_DIFFERENCE_NV                                              = 0x929E, // decimal value: 37534
    GL_MINUS_NV                                                   = 0x929F, // decimal value: 37535
    GL_EXCLUSION_KHR                                              = 0x92A0, // decimal value: 37536
    GL_EXCLUSION_NV                                               = 0x92A0, // decimal value: 37536
    GL_CONTRAST_NV                                                = 0x92A1, // decimal value: 37537
    GL_INVERT_RGB_NV                                              = 0x92A3, // decimal value: 37539
    GL_LINEARDODGE_NV                                             = 0x92A4, // decimal value: 37540
    GL_LINEARBURN_NV                                              = 0x92A5, // decimal value: 37541
    GL_VIVIDLIGHT_NV                                              = 0x92A6, // decimal value: 37542
    GL_LINEARLIGHT_NV                                             = 0x92A7, // decimal value: 37543
    GL_PINLIGHT_NV                                                = 0x92A8, // decimal value: 37544
    GL_HARDMIX_NV                                                 = 0x92A9, // decimal value: 37545
    GL_HSL_HUE_KHR                                                = 0x92AD, // decimal value: 37549
    GL_HSL_HUE_NV                                                 = 0x92AD, // decimal value: 37549
    GL_HSL_SATURATION_KHR                                         = 0x92AE, // decimal value: 37550
    GL_HSL_SATURATION_NV                                          = 0x92AE, // decimal value: 37550
    GL_HSL_COLOR_KHR                                              = 0x92AF, // decimal value: 37551
    GL_HSL_COLOR_NV                                               = 0x92AF, // decimal value: 37551
    GL_HSL_LUMINOSITY_KHR                                         = 0x92B0, // decimal value: 37552
    GL_HSL_LUMINOSITY_NV                                          = 0x92B0, // decimal value: 37552
    GL_PLUS_CLAMPED_NV                                            = 0x92B1, // decimal value: 37553
    GL_PLUS_CLAMPED_ALPHA_NV                                      = 0x92B2, // decimal value: 37554
    GL_MINUS_CLAMPED_NV                                           = 0x92B3, // decimal value: 37555
    GL_INVERT_OVG_NV                                              = 0x92B4, // decimal value: 37556
    GL_MAX_LGPU_GPUS_NVX                                          = 0x92BA, // decimal value: 37562
    GL_MULTICAST_GPUS_NV                                          = 0x92BA, // decimal value: 37562
    GL_PURGED_CONTEXT_RESET_NV                                    = 0x92BB, // decimal value: 37563
    GL_PRIMITIVE_BOUNDING_BOX_ARB                                 = 0x92BE, // decimal value: 37566
    GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV                           = 0x92BF, // decimal value: 37567
    GL_ATOMIC_COUNTER_BUFFER_START                                = 0x92C2, // decimal value: 37570
    GL_ATOMIC_COUNTER_BUFFER_SIZE                                 = 0x92C3, // decimal value: 37571
    GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS                          = 0x92CC, // decimal value: 37580
    GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS                    = 0x92CD, // decimal value: 37581
    GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS                 = 0x92CE, // decimal value: 37582
    GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS                        = 0x92CF, // decimal value: 37583
    GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS                        = 0x92D0, // decimal value: 37584
    GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS                        = 0x92D1, // decimal value: 37585
    GL_MAX_VERTEX_ATOMIC_COUNTERS                                 = 0x92D2, // decimal value: 37586
    GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS                           = 0x92D3, // decimal value: 37587
    GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS                        = 0x92D4, // decimal value: 37588
    GL_MAX_GEOMETRY_ATOMIC_COUNTERS                               = 0x92D5, // decimal value: 37589
    GL_MAX_FRAGMENT_ATOMIC_COUNTERS                               = 0x92D6, // decimal value: 37590
    GL_MAX_COMBINED_ATOMIC_COUNTERS                               = 0x92D7, // decimal value: 37591
    GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE                             = 0x92D8, // decimal value: 37592
    GL_UNSIGNED_INT_ATOMIC_COUNTER                                = 0x92DB, // decimal value: 37595
    GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS                         = 0x92DC, // decimal value: 37596
    GL_FRAGMENT_COVERAGE_TO_COLOR_NV                              = 0x92DD, // decimal value: 37597
    GL_FRAGMENT_COVERAGE_COLOR_NV                                 = 0x92DE, // decimal value: 37598
    GL_DEBUG_OUTPUT                                               = 0x92E0, // decimal value: 37600
    GL_IS_PER_PATCH                                               = 0x92E7, // decimal value: 37607
    GL_NAME_LENGTH                                                = 0x92F9, // decimal value: 37625
    GL_TYPE                                                       = 0x92FA, // decimal value: 37626
    GL_ARRAY_SIZE                                                 = 0x92FB, // decimal value: 37627
    GL_OFFSET                                                     = 0x92FC, // decimal value: 37628
    GL_BLOCK_INDEX                                                = 0x92FD, // decimal value: 37629
    GL_ARRAY_STRIDE                                               = 0x92FE, // decimal value: 37630
    GL_MATRIX_STRIDE                                              = 0x92FF, // decimal value: 37631
    GL_IS_ROW_MAJOR                                               = 0x9300, // decimal value: 37632
    GL_ATOMIC_COUNTER_BUFFER_INDEX                                = 0x9301, // decimal value: 37633
    GL_BUFFER_BINDING                                             = 0x9302, // decimal value: 37634
    GL_BUFFER_DATA_SIZE                                           = 0x9303, // decimal value: 37635
    GL_NUM_ACTIVE_VARIABLES                                       = 0x9304, // decimal value: 37636
    GL_ACTIVE_VARIABLES                                           = 0x9305, // decimal value: 37637
    GL_REFERENCED_BY_VERTEX_SHADER                                = 0x9306, // decimal value: 37638
    GL_REFERENCED_BY_TESS_CONTROL_SHADER                          = 0x9307, // decimal value: 37639
    GL_REFERENCED_BY_TESS_EVALUATION_SHADER                       = 0x9308, // decimal value: 37640
    GL_REFERENCED_BY_GEOMETRY_SHADER                              = 0x9309, // decimal value: 37641
    GL_REFERENCED_BY_FRAGMENT_SHADER                              = 0x930A, // decimal value: 37642
    GL_REFERENCED_BY_COMPUTE_SHADER                               = 0x930B, // decimal value: 37643
    GL_TOP_LEVEL_ARRAY_SIZE                                       = 0x930C, // decimal value: 37644
    GL_TOP_LEVEL_ARRAY_STRIDE                                     = 0x930D, // decimal value: 37645
    GL_LOCATION                                                   = 0x930E, // decimal value: 37646
    GL_LOCATION_INDEX                                             = 0x930F, // decimal value: 37647
    GL_MAX_FRAMEBUFFER_WIDTH                                      = 0x9315, // decimal value: 37653
    GL_MAX_FRAMEBUFFER_HEIGHT                                     = 0x9316, // decimal value: 37654
    GL_MAX_FRAMEBUFFER_LAYERS                                     = 0x9317, // decimal value: 37655
    GL_MAX_FRAMEBUFFER_SAMPLES                                    = 0x9318, // decimal value: 37656
    GL_RASTER_MULTISAMPLE_EXT                                     = 0x9327, // decimal value: 37671
    GL_RASTER_SAMPLES_EXT                                         = 0x9328, // decimal value: 37672
    GL_MAX_RASTER_SAMPLES_EXT                                     = 0x9329, // decimal value: 37673
    GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT                          = 0x932A, // decimal value: 37674
    GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT                      = 0x932B, // decimal value: 37675
    GL_EFFECTIVE_RASTER_SAMPLES_EXT                               = 0x932C, // decimal value: 37676
    GL_DEPTH_SAMPLES_NV                                           = 0x932D, // decimal value: 37677
    GL_STENCIL_SAMPLES_NV                                         = 0x932E, // decimal value: 37678
    GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV                           = 0x932F, // decimal value: 37679
    GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV                         = 0x9330, // decimal value: 37680
    GL_COVERAGE_MODULATION_TABLE_NV                               = 0x9331, // decimal value: 37681
    GL_COVERAGE_MODULATION_NV                                     = 0x9332, // decimal value: 37682
    GL_COVERAGE_MODULATION_TABLE_SIZE_NV                          = 0x9333, // decimal value: 37683
    GL_WARP_SIZE_NV                                               = 0x9339, // decimal value: 37689
    GL_WARPS_PER_SM_NV                                            = 0x933A, // decimal value: 37690
    GL_SM_COUNT_NV                                                = 0x933B, // decimal value: 37691
    GL_FILL_RECTANGLE_NV                                          = 0x933C, // decimal value: 37692
    GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB                          = 0x933D, // decimal value: 37693
    GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV                           = 0x933D, // decimal value: 37693
    GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB                       = 0x933E, // decimal value: 37694
    GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV                        = 0x933E, // decimal value: 37694
    GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB                      = 0x933F, // decimal value: 37695
    GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV                       = 0x933F, // decimal value: 37695
    GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB                = 0x9340, // decimal value: 37696
    GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV                 = 0x9340, // decimal value: 37696
    GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB                           = 0x9341, // decimal value: 37697
    GL_PROGRAMMABLE_SAMPLE_LOCATION_NV                            = 0x9341, // decimal value: 37697
    GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB              = 0x9342, // decimal value: 37698
    GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV               = 0x9342, // decimal value: 37698
    GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB                 = 0x9343, // decimal value: 37699
    GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV                  = 0x9343, // decimal value: 37699
    GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB                 = 0x9344, // decimal value: 37700
    GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB                        = 0x9345, // decimal value: 37701
    GL_CONSERVATIVE_RASTERIZATION_NV                              = 0x9346, // decimal value: 37702
    GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV                          = 0x9347, // decimal value: 37703
    GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV                          = 0x9348, // decimal value: 37704
    GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV                        = 0x9349, // decimal value: 37705
    GL_LOCATION_COMPONENT                                         = 0x934A, // decimal value: 37706
    GL_TRANSFORM_FEEDBACK_BUFFER_INDEX                            = 0x934B, // decimal value: 37707
    GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE                           = 0x934C, // decimal value: 37708
    GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV                        = 0x934D, // decimal value: 37709
    GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV                         = 0x934E, // decimal value: 37710
    GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV                        = 0x934F, // decimal value: 37711
    GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV                             = 0x9350, // decimal value: 37712
    GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV                             = 0x9351, // decimal value: 37713
    GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV                             = 0x9352, // decimal value: 37714
    GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV                             = 0x9353, // decimal value: 37715
    GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV                             = 0x9354, // decimal value: 37716
    GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV                             = 0x9355, // decimal value: 37717
    GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV                             = 0x9356, // decimal value: 37718
    GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV                             = 0x9357, // decimal value: 37719
    GL_VIEWPORT_SWIZZLE_X_NV                                      = 0x9358, // decimal value: 37720
    GL_VIEWPORT_SWIZZLE_Y_NV                                      = 0x9359, // decimal value: 37721
    GL_VIEWPORT_SWIZZLE_Z_NV                                      = 0x935A, // decimal value: 37722
    GL_VIEWPORT_SWIZZLE_W_NV                                      = 0x935B, // decimal value: 37723
    GL_CLIP_ORIGIN                                                = 0x935C, // decimal value: 37724
    GL_CLIP_DEPTH_MODE                                            = 0x935D, // decimal value: 37725
    GL_TEXTURE_REDUCTION_MODE_ARB                                 = 0x9366, // decimal value: 37734
    GL_TEXTURE_REDUCTION_MODE_EXT                                 = 0x9366, // decimal value: 37734
    GL_WEIGHTED_AVERAGE_ARB                                       = 0x9367, // decimal value: 37735
    GL_WEIGHTED_AVERAGE_EXT                                       = 0x9367, // decimal value: 37735
    GL_FONT_GLYPHS_AVAILABLE_NV                                   = 0x9368, // decimal value: 37736
    GL_FONT_TARGET_UNAVAILABLE_NV                                 = 0x9369, // decimal value: 37737
    GL_FONT_UNAVAILABLE_NV                                        = 0x936A, // decimal value: 37738
    GL_FONT_UNINTELLIGIBLE_NV                                     = 0x936B, // decimal value: 37739
    GL_STANDARD_FONT_FORMAT_NV                                    = 0x936C, // decimal value: 37740
    GL_FRAGMENT_INPUT_NV                                          = 0x936D, // decimal value: 37741
    GL_UNIFORM_BUFFER_UNIFIED_NV                                  = 0x936E, // decimal value: 37742
    GL_UNIFORM_BUFFER_ADDRESS_NV                                  = 0x936F, // decimal value: 37743
    GL_UNIFORM_BUFFER_LENGTH_NV                                   = 0x9370, // decimal value: 37744
    GL_MULTISAMPLES_NV                                            = 0x9371, // decimal value: 37745
    GL_SUPERSAMPLE_SCALE_X_NV                                     = 0x9372, // decimal value: 37746
    GL_SUPERSAMPLE_SCALE_Y_NV                                     = 0x9373, // decimal value: 37747
    GL_CONFORMANT_NV                                              = 0x9374, // decimal value: 37748
    GL_CONSERVATIVE_RASTER_DILATE_NV                              = 0x9379, // decimal value: 37753
    GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV                        = 0x937A, // decimal value: 37754
    GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV                  = 0x937B, // decimal value: 37755
    GL_VIEWPORT_POSITION_W_SCALE_NV                               = 0x937C, // decimal value: 37756
    GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV                       = 0x937D, // decimal value: 37757
    GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV                       = 0x937E, // decimal value: 37758
    GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB                           = 0x9381, // decimal value: 37761
    GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB                     = 0x9382, // decimal value: 37762
    GL_COMPRESSED_RGBA_ASTC_4x4_KHR                               = 0x93B0, // decimal value: 37808
    GL_COMPRESSED_RGBA_ASTC_5x4_KHR                               = 0x93B1, // decimal value: 37809
    GL_COMPRESSED_RGBA_ASTC_5x5_KHR                               = 0x93B2, // decimal value: 37810
    GL_COMPRESSED_RGBA_ASTC_6x5_KHR                               = 0x93B3, // decimal value: 37811
    GL_COMPRESSED_RGBA_ASTC_6x6_KHR                               = 0x93B4, // decimal value: 37812
    GL_COMPRESSED_RGBA_ASTC_8x5_KHR                               = 0x93B5, // decimal value: 37813
    GL_COMPRESSED_RGBA_ASTC_8x6_KHR                               = 0x93B6, // decimal value: 37814
    GL_COMPRESSED_RGBA_ASTC_8x8_KHR                               = 0x93B7, // decimal value: 37815
    GL_COMPRESSED_RGBA_ASTC_10x5_KHR                              = 0x93B8, // decimal value: 37816
    GL_COMPRESSED_RGBA_ASTC_10x6_KHR                              = 0x93B9, // decimal value: 37817
    GL_COMPRESSED_RGBA_ASTC_10x8_KHR                              = 0x93BA, // decimal value: 37818
    GL_COMPRESSED_RGBA_ASTC_10x10_KHR                             = 0x93BB, // decimal value: 37819
    GL_COMPRESSED_RGBA_ASTC_12x10_KHR                             = 0x93BC, // decimal value: 37820
    GL_COMPRESSED_RGBA_ASTC_12x12_KHR                             = 0x93BD, // decimal value: 37821
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR                       = 0x93D0, // decimal value: 37840
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR                       = 0x93D1, // decimal value: 37841
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR                       = 0x93D2, // decimal value: 37842
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR                       = 0x93D3, // decimal value: 37843
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR                       = 0x93D4, // decimal value: 37844
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR                       = 0x93D5, // decimal value: 37845
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR                       = 0x93D6, // decimal value: 37846
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR                       = 0x93D7, // decimal value: 37847
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR                      = 0x93D8, // decimal value: 37848
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR                      = 0x93D9, // decimal value: 37849
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR                      = 0x93DA, // decimal value: 37850
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR                     = 0x93DB, // decimal value: 37851
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR                     = 0x93DC, // decimal value: 37852
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR                     = 0x93DD, // decimal value: 37853
    GL_PERFQUERY_COUNTER_EVENT_INTEL                              = 0x94F0, // decimal value: 38128
    GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL                      = 0x94F1, // decimal value: 38129
    GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL                       = 0x94F2, // decimal value: 38130
    GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL                         = 0x94F3, // decimal value: 38131
    GL_PERFQUERY_COUNTER_RAW_INTEL                                = 0x94F4, // decimal value: 38132
    GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL                          = 0x94F5, // decimal value: 38133
    GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL                        = 0x94F8, // decimal value: 38136
    GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL                        = 0x94F9, // decimal value: 38137
    GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL                         = 0x94FA, // decimal value: 38138
    GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL                        = 0x94FB, // decimal value: 38139
    GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL                        = 0x94FC, // decimal value: 38140
    GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL                      = 0x94FD, // decimal value: 38141
    GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL                    = 0x94FE, // decimal value: 38142
    GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL                    = 0x94FF, // decimal value: 38143
    GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL                      = 0x9500, // decimal value: 38144
    GL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV                        = 0x9540, // decimal value: 38208
    GL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV                           = 0x9542, // decimal value: 38210
    GL_QUERY_RESOURCE_SYS_RESERVED_NV                             = 0x9544, // decimal value: 38212
    GL_QUERY_RESOURCE_TEXTURE_NV                                  = 0x9545, // decimal value: 38213
    GL_QUERY_RESOURCE_RENDERBUFFER_NV                             = 0x9546, // decimal value: 38214
    GL_QUERY_RESOURCE_BUFFEROBJECT_NV                             = 0x9547, // decimal value: 38215
    GL_PER_GPU_STORAGE_NV                                         = 0x9548, // decimal value: 38216
    GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV                  = 0x9549, // decimal value: 38217
    GL_CONSERVATIVE_RASTER_MODE_NV                                = 0x954D, // decimal value: 38221
    GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV                      = 0x954E, // decimal value: 38222
    GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV             = 0x954F, // decimal value: 38223
    GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV                       = 0x9550, // decimal value: 38224
    GL_SHADER_BINARY_FORMAT_SPIR_V                                = 0x9551, // decimal value: 38225
    GL_SHADER_BINARY_FORMAT_SPIR_V_ARB                            = 0x9551, // decimal value: 38225
    GL_SPIR_V_BINARY                                              = 0x9552, // decimal value: 38226
    GL_SPIR_V_BINARY_ARB                                          = 0x9552, // decimal value: 38226
    GL_SPIR_V_EXTENSIONS                                          = 0x9553, // decimal value: 38227
    GL_NUM_SPIR_V_EXTENSIONS                                      = 0x9554, // decimal value: 38228
    GL_RENDER_GPU_MASK_NV                                         = 0x9558, // decimal value: 38232
    GL_NUM_TILING_TYPES_EXT                                       = 0x9582, // decimal value: 38274
    GL_TILING_TYPES_EXT                                           = 0x9583, // decimal value: 38275
    GL_OPTIMAL_TILING_EXT                                         = 0x9584, // decimal value: 38276
    GL_LINEAR_TILING_EXT                                          = 0x9585, // decimal value: 38277
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR               = 0x9630, // decimal value: 38448
    GL_MAX_VIEWS_OVR                                              = 0x9631, // decimal value: 38449
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR         = 0x9632, // decimal value: 38450
    GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR                    = 0x9633, // decimal value: 38451
    GL_SHARED_EDGE_NV                                             = 0xC0, // decimal value: 192
    GL_ROUNDED_RECT_NV                                            = 0xE8, // decimal value: 232
    GL_RELATIVE_ROUNDED_RECT_NV                                   = 0xE9, // decimal value: 233
    GL_ROUNDED_RECT2_NV                                           = 0xEA, // decimal value: 234
    GL_RELATIVE_ROUNDED_RECT2_NV                                  = 0xEB, // decimal value: 235
    GL_ROUNDED_RECT4_NV                                           = 0xEC, // decimal value: 236
    GL_RELATIVE_ROUNDED_RECT4_NV                                  = 0xED, // decimal value: 237
    GL_ROUNDED_RECT8_NV                                           = 0xEE, // decimal value: 238
    GL_RELATIVE_ROUNDED_RECT8_NV                                  = 0xEF, // decimal value: 239
    GL_RESTART_PATH_NV                                            = 0xF0, // decimal value: 240
    GL_DUP_FIRST_CUBIC_CURVE_TO_NV                                = 0xF2, // decimal value: 242
    GL_DUP_LAST_CUBIC_CURVE_TO_NV                                 = 0xF4, // decimal value: 244
    GL_RECT_NV                                                    = 0xF6, // decimal value: 246
    GL_RELATIVE_RECT_NV                                           = 0xF7, // decimal value: 247
    GL_CIRCULAR_CCW_ARC_TO_NV                                     = 0xF8, // decimal value: 248
    GL_CIRCULAR_CW_ARC_TO_NV                                      = 0xFA, // decimal value: 250
    GL_CIRCULAR_TANGENT_ARC_TO_NV                                 = 0xFC, // decimal value: 252
    GL_ARC_TO_NV                                                  = 0xFE, // decimal value: 254
    GL_RELATIVE_ARC_TO_NV                                         = 0xFF, // decimal value: 255
    GL_ALL_PIXELS_AMD                                             = 0xFFFFFFFF, // decimal value: 4294967295
    GL_CULL_VERTEX_IBM                                            = 103050,
    GL_ALL_STATIC_DATA_IBM                                        = 103060,
    GL_STATIC_VERTEX_ARRAY_IBM                                    = 103061,
    GL_VERTEX_ARRAY_LIST_IBM                                      = 103070,
    GL_NORMAL_ARRAY_LIST_IBM                                      = 103071,
    GL_COLOR_ARRAY_LIST_IBM                                       = 103072,
    GL_INDEX_ARRAY_LIST_IBM                                       = 103073,
    GL_TEXTURE_COORD_ARRAY_LIST_IBM                               = 103074,
    GL_EDGE_FLAG_ARRAY_LIST_IBM                                   = 103075,
    GL_FOG_COORDINATE_ARRAY_LIST_IBM                              = 103076,
    GL_SECONDARY_COLOR_ARRAY_LIST_IBM                             = 103077,
    GL_VERTEX_ARRAY_LIST_STRIDE_IBM                               = 103080,
    GL_NORMAL_ARRAY_LIST_STRIDE_IBM                               = 103081,
    GL_COLOR_ARRAY_LIST_STRIDE_IBM                                = 103082,
    GL_INDEX_ARRAY_LIST_STRIDE_IBM                                = 103083,
    GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM                        = 103084,
    GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM                            = 103085,
    GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM                       = 103086,
    GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM                      = 103087,
    GL_UUID_SIZE_EXT                                              = 16,
    GL_LUID_SIZE_EXT                                              = 8,

};


// import enums to namespace

// AccumOp

GLBINDING_CONSTEXPR static const GLenum GL_ACCUM = GLenum::GL_ACCUM;
GLBINDING_CONSTEXPR static const GLenum GL_LOAD = GLenum::GL_LOAD;
GLBINDING_CONSTEXPR static const GLenum GL_RETURN = GLenum::GL_RETURN;
GLBINDING_CONSTEXPR static const GLenum GL_MULT = GLenum::GL_MULT;
GLBINDING_CONSTEXPR static const GLenum GL_ADD = GLenum::GL_ADD;

// AlphaFunction

GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER;
GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS;
GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER;
GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS;

// AtomicCounterBufferPName

GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_BINDING = GLenum::GL_ATOMIC_COUNTER_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = GLenum::GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = GLenum::GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = GLenum::GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER;

// AttributeType

GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC2 = GLenum::GL_FLOAT_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC2_ARB = GLenum::GL_FLOAT_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC3 = GLenum::GL_FLOAT_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC3_ARB = GLenum::GL_FLOAT_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC4 = GLenum::GL_FLOAT_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC4_ARB = GLenum::GL_FLOAT_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC2 = GLenum::GL_INT_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC2_ARB = GLenum::GL_INT_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC3 = GLenum::GL_INT_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC3_ARB = GLenum::GL_INT_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC4 = GLenum::GL_INT_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC4_ARB = GLenum::GL_INT_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL = GLenum::GL_BOOL;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_ARB = GLenum::GL_BOOL_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC2 = GLenum::GL_BOOL_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC2_ARB = GLenum::GL_BOOL_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC3 = GLenum::GL_BOOL_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC3_ARB = GLenum::GL_BOOL_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC4 = GLenum::GL_BOOL_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC4_ARB = GLenum::GL_BOOL_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2 = GLenum::GL_FLOAT_MAT2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2_ARB = GLenum::GL_FLOAT_MAT2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3 = GLenum::GL_FLOAT_MAT3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3_ARB = GLenum::GL_FLOAT_MAT3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4 = GLenum::GL_FLOAT_MAT4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4_ARB = GLenum::GL_FLOAT_MAT4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D = GLenum::GL_SAMPLER_1D;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARB = GLenum::GL_SAMPLER_1D_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D = GLenum::GL_SAMPLER_2D;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARB = GLenum::GL_SAMPLER_2D_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_3D = GLenum::GL_SAMPLER_3D;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_3D_ARB = GLenum::GL_SAMPLER_3D_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_3D_OES = GLenum::GL_SAMPLER_3D_OES;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE = GLenum::GL_SAMPLER_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_ARB = GLenum::GL_SAMPLER_CUBE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_SHADOW = GLenum::GL_SAMPLER_1D_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_SHADOW_ARB = GLenum::GL_SAMPLER_1D_SHADOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_SHADOW = GLenum::GL_SAMPLER_2D_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_SHADOW_ARB = GLenum::GL_SAMPLER_2D_SHADOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_SHADOW_EXT = GLenum::GL_SAMPLER_2D_SHADOW_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT = GLenum::GL_SAMPLER_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT_ARB = GLenum::GL_SAMPLER_2D_RECT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT_SHADOW = GLenum::GL_SAMPLER_2D_RECT_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT_SHADOW_ARB = GLenum::GL_SAMPLER_2D_RECT_SHADOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2x3 = GLenum::GL_FLOAT_MAT2x3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2x3_NV = GLenum::GL_FLOAT_MAT2x3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2x4 = GLenum::GL_FLOAT_MAT2x4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2x4_NV = GLenum::GL_FLOAT_MAT2x4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3x2 = GLenum::GL_FLOAT_MAT3x2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3x2_NV = GLenum::GL_FLOAT_MAT3x2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3x4 = GLenum::GL_FLOAT_MAT3x4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3x4_NV = GLenum::GL_FLOAT_MAT3x4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4x2 = GLenum::GL_FLOAT_MAT4x2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4x2_NV = GLenum::GL_FLOAT_MAT4x2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4x3 = GLenum::GL_FLOAT_MAT4x3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4x3_NV = GLenum::GL_FLOAT_MAT4x3_NV;

// BindTransformFeedbackTarget

GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK = GLenum::GL_TRANSFORM_FEEDBACK;

// BlendEquationModeEXT

GLBINDING_CONSTEXPR static const GLenum GL_LOGIC_OP = GLenum::GL_LOGIC_OP;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_ADD = GLenum::GL_FUNC_ADD;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_ADD_EXT = GLenum::GL_FUNC_ADD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_EXT = GLenum::GL_MIN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_EXT = GLenum::GL_MAX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_SUBTRACT = GLenum::GL_FUNC_SUBTRACT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_SUBTRACT_EXT = GLenum::GL_FUNC_SUBTRACT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_REVERSE_SUBTRACT = GLenum::GL_FUNC_REVERSE_SUBTRACT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_REVERSE_SUBTRACT_EXT = GLenum::GL_FUNC_REVERSE_SUBTRACT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MIN_SGIX = GLenum::GL_ALPHA_MIN_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MAX_SGIX = GLenum::GL_ALPHA_MAX_SGIX;

// BlendingFactor

GLBINDING_CONSTEXPR static const GLenum GL_ZERO = GLenum::GL_ZERO;
GLBINDING_CONSTEXPR static const GLenum GL_SRC_COLOR = GLenum::GL_SRC_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC_COLOR = GLenum::GL_ONE_MINUS_SRC_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SRC_ALPHA = GLenum::GL_SRC_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC_ALPHA = GLenum::GL_ONE_MINUS_SRC_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_DST_ALPHA = GLenum::GL_DST_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_DST_ALPHA = GLenum::GL_ONE_MINUS_DST_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_DST_COLOR = GLenum::GL_DST_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_DST_COLOR = GLenum::GL_ONE_MINUS_DST_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SRC_ALPHA_SATURATE = GLenum::GL_SRC_ALPHA_SATURATE;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR = GLenum::GL_CONSTANT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_COLOR = GLenum::GL_ONE_MINUS_CONSTANT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ALPHA = GLenum::GL_CONSTANT_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_ALPHA = GLenum::GL_ONE_MINUS_CONSTANT_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SRC1_ALPHA = GLenum::GL_SRC1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SRC1_COLOR = GLenum::GL_SRC1_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC1_COLOR = GLenum::GL_ONE_MINUS_SRC1_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC1_ALPHA = GLenum::GL_ONE_MINUS_SRC1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE = GLenum::GL_ONE;

// BlitFramebufferFilter

GLBINDING_CONSTEXPR static const GLenum GL_NEAREST = GLenum::GL_NEAREST;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR;

// Buffer

GLBINDING_CONSTEXPR static const GLenum GL_COLOR = GLenum::GL_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH = GLenum::GL_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL = GLenum::GL_STENCIL;

// BufferAccessARB

GLBINDING_CONSTEXPR static const GLenum GL_READ_ONLY = GLenum::GL_READ_ONLY;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_ONLY = GLenum::GL_WRITE_ONLY;
GLBINDING_CONSTEXPR static const GLenum GL_READ_WRITE = GLenum::GL_READ_WRITE;

// BufferStorageTarget

GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER = GLenum::GL_ARRAY_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER = GLenum::GL_ELEMENT_ARRAY_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER = GLenum::GL_PIXEL_PACK_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER = GLenum::GL_PIXEL_UNPACK_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER = GLenum::GL_UNIFORM_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_READ_BUFFER = GLenum::GL_COPY_READ_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_WRITE_BUFFER = GLenum::GL_COPY_WRITE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_INDIRECT_BUFFER = GLenum::GL_DRAW_INDIRECT_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER = GLenum::GL_SHADER_STORAGE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER = GLenum::GL_DISPATCH_INDIRECT_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BUFFER = GLenum::GL_QUERY_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER = GLenum::GL_ATOMIC_COUNTER_BUFFER;

// BufferTargetARB

// GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER = GLenum::GL_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER = GLenum::GL_ELEMENT_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER = GLenum::GL_PIXEL_PACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER = GLenum::GL_PIXEL_UNPACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER = GLenum::GL_UNIFORM_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_READ_BUFFER = GLenum::GL_COPY_READ_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_WRITE_BUFFER = GLenum::GL_COPY_WRITE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DRAW_INDIRECT_BUFFER = GLenum::GL_DRAW_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER = GLenum::GL_SHADER_STORAGE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER = GLenum::GL_DISPATCH_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BUFFER = GLenum::GL_QUERY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER = GLenum::GL_ATOMIC_COUNTER_BUFFER; // reuse BufferStorageTarget

// BufferUsageARB

GLBINDING_CONSTEXPR static const GLenum GL_STREAM_DRAW = GLenum::GL_STREAM_DRAW;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_READ = GLenum::GL_STREAM_READ;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_COPY = GLenum::GL_STREAM_COPY;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_DRAW = GLenum::GL_STATIC_DRAW;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_READ = GLenum::GL_STATIC_READ;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_COPY = GLenum::GL_STATIC_COPY;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_DRAW = GLenum::GL_DYNAMIC_DRAW;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_READ = GLenum::GL_DYNAMIC_READ;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_COPY = GLenum::GL_DYNAMIC_COPY;

// CheckFramebufferStatusTarget

GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER = GLenum::GL_READ_FRAMEBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER = GLenum::GL_DRAW_FRAMEBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER = GLenum::GL_FRAMEBUFFER;

// ClipControlDepth

GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_ONE_TO_ONE = GLenum::GL_NEGATIVE_ONE_TO_ONE;
GLBINDING_CONSTEXPR static const GLenum GL_ZERO_TO_ONE = GLenum::GL_ZERO_TO_ONE;

// ClipControlOrigin

GLBINDING_CONSTEXPR static const GLenum GL_LOWER_LEFT = GLenum::GL_LOWER_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_UPPER_LEFT = GLenum::GL_UPPER_LEFT;

// ClipPlaneName

GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE0 = GLenum::GL_CLIP_DISTANCE0;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE0 = GLenum::GL_CLIP_PLANE0;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE1 = GLenum::GL_CLIP_DISTANCE1;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE1 = GLenum::GL_CLIP_PLANE1;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE2 = GLenum::GL_CLIP_DISTANCE2;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE2 = GLenum::GL_CLIP_PLANE2;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE3 = GLenum::GL_CLIP_DISTANCE3;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE3 = GLenum::GL_CLIP_PLANE3;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE4 = GLenum::GL_CLIP_DISTANCE4;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE4 = GLenum::GL_CLIP_PLANE4;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE5 = GLenum::GL_CLIP_DISTANCE5;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE5 = GLenum::GL_CLIP_PLANE5;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE6 = GLenum::GL_CLIP_DISTANCE6;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE7 = GLenum::GL_CLIP_DISTANCE7;

// ColorBuffer

GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_LEFT = GLenum::GL_FRONT_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_RIGHT = GLenum::GL_FRONT_RIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_LEFT = GLenum::GL_BACK_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_RIGHT = GLenum::GL_BACK_RIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK;
GLBINDING_CONSTEXPR static const GLenum GL_LEFT = GLenum::GL_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_RIGHT = GLenum::GL_RIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT16 = GLenum::GL_COLOR_ATTACHMENT16;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT17 = GLenum::GL_COLOR_ATTACHMENT17;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT18 = GLenum::GL_COLOR_ATTACHMENT18;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT19 = GLenum::GL_COLOR_ATTACHMENT19;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT20 = GLenum::GL_COLOR_ATTACHMENT20;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT21 = GLenum::GL_COLOR_ATTACHMENT21;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT22 = GLenum::GL_COLOR_ATTACHMENT22;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT23 = GLenum::GL_COLOR_ATTACHMENT23;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT24 = GLenum::GL_COLOR_ATTACHMENT24;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT25 = GLenum::GL_COLOR_ATTACHMENT25;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT26 = GLenum::GL_COLOR_ATTACHMENT26;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT27 = GLenum::GL_COLOR_ATTACHMENT27;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT28 = GLenum::GL_COLOR_ATTACHMENT28;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT29 = GLenum::GL_COLOR_ATTACHMENT29;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT30 = GLenum::GL_COLOR_ATTACHMENT30;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT31 = GLenum::GL_COLOR_ATTACHMENT31;

// ColorMaterialFace

// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer

// ColorMaterialParameter

GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT;
GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE;
GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR;
GLBINDING_CONSTEXPR static const GLenum GL_EMISSION = GLenum::GL_EMISSION;
GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT_AND_DIFFUSE = GLenum::GL_AMBIENT_AND_DIFFUSE;

// ColorPointerType

GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE;
GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT;
GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE;

// ColorTableParameterPNameSGI

GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SCALE = GLenum::GL_COLOR_TABLE_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SCALE_SGI = GLenum::GL_COLOR_TABLE_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BIAS = GLenum::GL_COLOR_TABLE_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BIAS_SGI = GLenum::GL_COLOR_TABLE_BIAS_SGI;

// ColorTableTarget

GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE = GLenum::GL_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE;

// ColorTableTargetSGI

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_TEXTURE_COLOR_TABLE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_PROXY_TEXTURE_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE = GLenum::GL_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SGI = GLenum::GL_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_COLOR_TABLE = GLenum::GL_PROXY_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_COLOR_TABLE_SGI = GLenum::GL_PROXY_COLOR_TABLE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_PROXY_POST_CONVOLUTION_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI;

// ConvolutionBorderModeEXT

GLBINDING_CONSTEXPR static const GLenum GL_REDUCE = GLenum::GL_REDUCE;
GLBINDING_CONSTEXPR static const GLenum GL_REDUCE_EXT = GLenum::GL_REDUCE_EXT;

// ConvolutionParameterEXT

GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_MODE = GLenum::GL_CONVOLUTION_BORDER_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_MODE_EXT = GLenum::GL_CONVOLUTION_BORDER_MODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_SCALE = GLenum::GL_CONVOLUTION_FILTER_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_SCALE_EXT = GLenum::GL_CONVOLUTION_FILTER_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_BIAS = GLenum::GL_CONVOLUTION_FILTER_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_BIAS_EXT = GLenum::GL_CONVOLUTION_FILTER_BIAS_EXT;

// ConvolutionTarget

GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D = GLenum::GL_CONVOLUTION_1D;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D = GLenum::GL_CONVOLUTION_2D;

// ConvolutionTargetEXT

// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D = GLenum::GL_CONVOLUTION_1D; // reuse ConvolutionTarget
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D_EXT = GLenum::GL_CONVOLUTION_1D_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D = GLenum::GL_CONVOLUTION_2D; // reuse ConvolutionTarget
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D_EXT = GLenum::GL_CONVOLUTION_2D_EXT;

// CopyBufferSubDataTarget

// GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER = GLenum::GL_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER = GLenum::GL_ELEMENT_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER = GLenum::GL_PIXEL_PACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER = GLenum::GL_PIXEL_UNPACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER = GLenum::GL_UNIFORM_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_READ_BUFFER = GLenum::GL_COPY_READ_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_WRITE_BUFFER = GLenum::GL_COPY_WRITE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DRAW_INDIRECT_BUFFER = GLenum::GL_DRAW_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER = GLenum::GL_SHADER_STORAGE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER = GLenum::GL_DISPATCH_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BUFFER = GLenum::GL_QUERY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER = GLenum::GL_ATOMIC_COUNTER_BUFFER; // reuse BufferStorageTarget

// CullFaceMode

// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer

// DebugSeverity

GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_HIGH = GLenum::GL_DEBUG_SEVERITY_HIGH;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_MEDIUM = GLenum::GL_DEBUG_SEVERITY_MEDIUM;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_LOW = GLenum::GL_DEBUG_SEVERITY_LOW;

// DebugSource

// GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE; // reuse DebugSeverity
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_API = GLenum::GL_DEBUG_SOURCE_API;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_WINDOW_SYSTEM = GLenum::GL_DEBUG_SOURCE_WINDOW_SYSTEM;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_SHADER_COMPILER = GLenum::GL_DEBUG_SOURCE_SHADER_COMPILER;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_THIRD_PARTY = GLenum::GL_DEBUG_SOURCE_THIRD_PARTY;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_APPLICATION = GLenum::GL_DEBUG_SOURCE_APPLICATION;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_OTHER = GLenum::GL_DEBUG_SOURCE_OTHER;

// DebugType

// GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE; // reuse DebugSeverity
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_ERROR = GLenum::GL_DEBUG_TYPE_ERROR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = GLenum::GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = GLenum::GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PORTABILITY = GLenum::GL_DEBUG_TYPE_PORTABILITY;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PERFORMANCE = GLenum::GL_DEBUG_TYPE_PERFORMANCE;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_OTHER = GLenum::GL_DEBUG_TYPE_OTHER;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_MARKER = GLenum::GL_DEBUG_TYPE_MARKER;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PUSH_GROUP = GLenum::GL_DEBUG_TYPE_PUSH_GROUP;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_POP_GROUP = GLenum::GL_DEBUG_TYPE_POP_GROUP;

// DepthFunction

// GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS; // reuse AlphaFunction

// DrawBufferMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_LEFT = GLenum::GL_FRONT_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_RIGHT = GLenum::GL_FRONT_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_LEFT = GLenum::GL_BACK_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_RIGHT = GLenum::GL_BACK_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_LEFT = GLenum::GL_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_RIGHT = GLenum::GL_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_AUX0 = GLenum::GL_AUX0;
GLBINDING_CONSTEXPR static const GLenum GL_AUX1 = GLenum::GL_AUX1;
GLBINDING_CONSTEXPR static const GLenum GL_AUX2 = GLenum::GL_AUX2;
GLBINDING_CONSTEXPR static const GLenum GL_AUX3 = GLenum::GL_AUX3;

// DrawElementsType

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse ColorPointerType

// EnableCap

GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH = GLenum::GL_POINT_SMOOTH;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH = GLenum::GL_LINE_SMOOTH;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE = GLenum::GL_LINE_STIPPLE;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH = GLenum::GL_POLYGON_SMOOTH;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_STIPPLE = GLenum::GL_POLYGON_STIPPLE;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_FACE = GLenum::GL_CULL_FACE;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHTING = GLenum::GL_LIGHTING;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL = GLenum::GL_COLOR_MATERIAL;
GLBINDING_CONSTEXPR static const GLenum GL_FOG = GLenum::GL_FOG;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_TEST = GLenum::GL_DEPTH_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_TEST = GLenum::GL_STENCIL_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_NORMALIZE = GLenum::GL_NORMALIZE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST = GLenum::GL_ALPHA_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_DITHER = GLenum::GL_DITHER;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND = GLenum::GL_BLEND;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_LOGIC_OP = GLenum::GL_INDEX_LOGIC_OP;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_LOGIC_OP = GLenum::GL_COLOR_LOGIC_OP;
GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_TEST = GLenum::GL_SCISSOR_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_S = GLenum::GL_TEXTURE_GEN_S;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_T = GLenum::GL_TEXTURE_GEN_T;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_R = GLenum::GL_TEXTURE_GEN_R;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_Q = GLenum::GL_TEXTURE_GEN_Q;
GLBINDING_CONSTEXPR static const GLenum GL_AUTO_NORMAL = GLenum::GL_AUTO_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_COLOR_4 = GLenum::GL_MAP1_COLOR_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_INDEX = GLenum::GL_MAP1_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_NORMAL = GLenum::GL_MAP1_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_1 = GLenum::GL_MAP1_TEXTURE_COORD_1;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_2 = GLenum::GL_MAP1_TEXTURE_COORD_2;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_3 = GLenum::GL_MAP1_TEXTURE_COORD_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_4 = GLenum::GL_MAP1_TEXTURE_COORD_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_3 = GLenum::GL_MAP1_VERTEX_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_4 = GLenum::GL_MAP1_VERTEX_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_COLOR_4 = GLenum::GL_MAP2_COLOR_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_INDEX = GLenum::GL_MAP2_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_NORMAL = GLenum::GL_MAP2_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_1 = GLenum::GL_MAP2_TEXTURE_COORD_1;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_2 = GLenum::GL_MAP2_TEXTURE_COORD_2;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_3 = GLenum::GL_MAP2_TEXTURE_COORD_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_4 = GLenum::GL_MAP2_TEXTURE_COORD_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_3 = GLenum::GL_MAP2_VERTEX_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_4 = GLenum::GL_MAP2_VERTEX_4;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_POINT = GLenum::GL_POLYGON_OFFSET_POINT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_LINE = GLenum::GL_POLYGON_OFFSET_LINE;
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE0 = GLenum::GL_CLIP_PLANE0; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE1 = GLenum::GL_CLIP_PLANE1; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE2 = GLenum::GL_CLIP_PLANE2; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE3 = GLenum::GL_CLIP_PLANE3; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE4 = GLenum::GL_CLIP_PLANE4; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE5 = GLenum::GL_CLIP_PLANE5; // reuse ClipPlaneName
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT0 = GLenum::GL_LIGHT0;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT1 = GLenum::GL_LIGHT1;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT2 = GLenum::GL_LIGHT2;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT3 = GLenum::GL_LIGHT3;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT4 = GLenum::GL_LIGHT4;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT5 = GLenum::GL_LIGHT5;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT6 = GLenum::GL_LIGHT6;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT7 = GLenum::GL_LIGHT7;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D_EXT = GLenum::GL_CONVOLUTION_1D_EXT; // reuse ConvolutionTargetEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D_EXT = GLenum::GL_CONVOLUTION_2D_EXT; // reuse ConvolutionTargetEXT
GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D_EXT = GLenum::GL_SEPARABLE_2D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_EXT = GLenum::GL_HISTOGRAM_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_EXT = GLenum::GL_MINMAX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FILL = GLenum::GL_POLYGON_OFFSET_FILL;
GLBINDING_CONSTEXPR static const GLenum GL_RESCALE_NORMAL_EXT = GLenum::GL_RESCALE_NORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_EXT = GLenum::GL_TEXTURE_3D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY = GLenum::GL_VERTEX_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY = GLenum::GL_NORMAL_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY = GLenum::GL_COLOR_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY = GLenum::GL_INDEX_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY = GLenum::GL_TEXTURE_COORD_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY = GLenum::GL_EDGE_FLAG_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_SGIX = GLenum::GL_INTERLACE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_SGIS = GLenum::GL_MULTISAMPLE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_MASK_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_MASK_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_ONE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_SGIS = GLenum::GL_SAMPLE_MASK_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_TEXTURE_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SGI = GLenum::GL_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_SGIS = GLenum::GL_TEXTURE_4D_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEX_GEN_SGIX = GLenum::GL_PIXEL_TEX_GEN_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_SGIX = GLenum::GL_SPRITE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCE_PLANE_SGIX = GLenum::GL_REFERENCE_PLANE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_IR_INSTRUMENT1_SGIX = GLenum::GL_IR_INSTRUMENT1_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_CALLIGRAPHIC_FRAGMENT_SGIX = GLenum::GL_CALLIGRAPHIC_FRAGMENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEZOOM_SGIX = GLenum::GL_FRAMEZOOM_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_SGIX = GLenum::GL_FOG_OFFSET_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SHARED_TEXTURE_PALETTE_EXT = GLenum::GL_SHARED_TEXTURE_PALETTE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_HISTOGRAM_SGIX = GLenum::GL_ASYNC_HISTOGRAM_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEXTURE_SGIS = GLenum::GL_PIXEL_TEXTURE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_TEX_IMAGE_SGIX = GLenum::GL_ASYNC_TEX_IMAGE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_DRAW_PIXELS_SGIX = GLenum::GL_ASYNC_DRAW_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_READ_PIXELS_SGIX = GLenum::GL_ASYNC_READ_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHTING_SGIX = GLenum::GL_FRAGMENT_LIGHTING_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT1_SGIX = GLenum::GL_FRAGMENT_LIGHT1_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT2_SGIX = GLenum::GL_FRAGMENT_LIGHT2_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT3_SGIX = GLenum::GL_FRAGMENT_LIGHT3_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT4_SGIX = GLenum::GL_FRAGMENT_LIGHT4_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT5_SGIX = GLenum::GL_FRAGMENT_LIGHT5_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT6_SGIX = GLenum::GL_FRAGMENT_LIGHT6_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT7_SGIX = GLenum::GL_FRAGMENT_LIGHT7_SGIX;

// ErrorCode

GLBINDING_CONSTEXPR static const GLenum GL_NO_ERROR = GLenum::GL_NO_ERROR;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_ENUM = GLenum::GL_INVALID_ENUM;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_VALUE = GLenum::GL_INVALID_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_OPERATION = GLenum::GL_INVALID_OPERATION;
GLBINDING_CONSTEXPR static const GLenum GL_STACK_OVERFLOW = GLenum::GL_STACK_OVERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_STACK_UNDERFLOW = GLenum::GL_STACK_UNDERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_OUT_OF_MEMORY = GLenum::GL_OUT_OF_MEMORY;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_FRAMEBUFFER_OPERATION = GLenum::GL_INVALID_FRAMEBUFFER_OPERATION;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_FRAMEBUFFER_OPERATION_EXT = GLenum::GL_INVALID_FRAMEBUFFER_OPERATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TABLE_TOO_LARGE = GLenum::GL_TABLE_TOO_LARGE;
GLBINDING_CONSTEXPR static const GLenum GL_TABLE_TOO_LARGE_EXT = GLenum::GL_TABLE_TOO_LARGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_TOO_LARGE_EXT = GLenum::GL_TEXTURE_TOO_LARGE_EXT;

// ExternalHandleType

GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_OPAQUE_FD_EXT = GLenum::GL_HANDLE_TYPE_OPAQUE_FD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_OPAQUE_WIN32_EXT = GLenum::GL_HANDLE_TYPE_OPAQUE_WIN32_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT = GLenum::GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT = GLenum::GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D12_RESOURCE_EXT = GLenum::GL_HANDLE_TYPE_D3D12_RESOURCE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D11_IMAGE_EXT = GLenum::GL_HANDLE_TYPE_D3D11_IMAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT = GLenum::GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D12_FENCE_EXT = GLenum::GL_HANDLE_TYPE_D3D12_FENCE_EXT;

// FeedBackToken

GLBINDING_CONSTEXPR static const GLenum GL_PASS_THROUGH_TOKEN = GLenum::GL_PASS_THROUGH_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_TOKEN = GLenum::GL_POINT_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_TOKEN = GLenum::GL_LINE_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_TOKEN = GLenum::GL_POLYGON_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_BITMAP_TOKEN = GLenum::GL_BITMAP_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_PIXEL_TOKEN = GLenum::GL_DRAW_PIXEL_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_PIXEL_TOKEN = GLenum::GL_COPY_PIXEL_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_RESET_TOKEN = GLenum::GL_LINE_RESET_TOKEN;

// FeedbackType

GLBINDING_CONSTEXPR static const GLenum GL_2D = GLenum::GL_2D;
GLBINDING_CONSTEXPR static const GLenum GL_3D = GLenum::GL_3D;
GLBINDING_CONSTEXPR static const GLenum GL_3D_COLOR = GLenum::GL_3D_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_3D_COLOR_TEXTURE = GLenum::GL_3D_COLOR_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_4D_COLOR_TEXTURE = GLenum::GL_4D_COLOR_TEXTURE;

// FfdTargetSGIX

GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_DEFORMATION_SGIX = GLenum::GL_GEOMETRY_DEFORMATION_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEFORMATION_SGIX = GLenum::GL_TEXTURE_DEFORMATION_SGIX;

// FogCoordinatePointerType

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// FogMode

GLBINDING_CONSTEXPR static const GLenum GL_EXP = GLenum::GL_EXP;
GLBINDING_CONSTEXPR static const GLenum GL_EXP2 = GLenum::GL_EXP2;
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR; // reuse BlitFramebufferFilter
GLBINDING_CONSTEXPR static const GLenum GL_FOG_FUNC_SGIS = GLenum::GL_FOG_FUNC_SGIS;

// FogPName

GLBINDING_CONSTEXPR static const GLenum GL_FOG_INDEX = GLenum::GL_FOG_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_DENSITY = GLenum::GL_FOG_DENSITY;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_START = GLenum::GL_FOG_START;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_END = GLenum::GL_FOG_END;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_MODE = GLenum::GL_FOG_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_SRC = GLenum::GL_FOG_COORD_SRC;

// FogParameter

// GLBINDING_CONSTEXPR static const GLenum GL_FOG_INDEX = GLenum::GL_FOG_INDEX; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_DENSITY = GLenum::GL_FOG_DENSITY; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_START = GLenum::GL_FOG_START; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_END = GLenum::GL_FOG_END; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_MODE = GLenum::GL_FOG_MODE; // reuse FogPName
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COLOR = GLenum::GL_FOG_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_VALUE_SGIX = GLenum::GL_FOG_OFFSET_VALUE_SGIX;

// FogPointerTypeEXT

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// FogPointerTypeIBM

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// FragmentLightModelParameterSGIX

GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX;

// FragmentOpATI

GLBINDING_CONSTEXPR static const GLenum GL_MOV_ATI = GLenum::GL_MOV_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_ATI = GLenum::GL_ADD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MUL_ATI = GLenum::GL_MUL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SUB_ATI = GLenum::GL_SUB_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_ATI = GLenum::GL_DOT3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DOT4_ATI = GLenum::GL_DOT4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MAD_ATI = GLenum::GL_MAD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_LERP_ATI = GLenum::GL_LERP_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CND_ATI = GLenum::GL_CND_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CND0_ATI = GLenum::GL_CND0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DOT2_ADD_ATI = GLenum::GL_DOT2_ADD_ATI;

// FramebufferAttachment

GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_ATTACHMENTS = GLenum::GL_MAX_COLOR_ATTACHMENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_ATTACHMENTS_EXT = GLenum::GL_MAX_COLOR_ATTACHMENTS_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0_EXT = GLenum::GL_COLOR_ATTACHMENT0_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1_EXT = GLenum::GL_COLOR_ATTACHMENT1_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2_EXT = GLenum::GL_COLOR_ATTACHMENT2_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3_EXT = GLenum::GL_COLOR_ATTACHMENT3_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4_EXT = GLenum::GL_COLOR_ATTACHMENT4_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5_EXT = GLenum::GL_COLOR_ATTACHMENT5_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6_EXT = GLenum::GL_COLOR_ATTACHMENT6_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7_EXT = GLenum::GL_COLOR_ATTACHMENT7_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8_EXT = GLenum::GL_COLOR_ATTACHMENT8_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9_EXT = GLenum::GL_COLOR_ATTACHMENT9_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10_EXT = GLenum::GL_COLOR_ATTACHMENT10_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11_EXT = GLenum::GL_COLOR_ATTACHMENT11_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12_EXT = GLenum::GL_COLOR_ATTACHMENT12_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13_EXT = GLenum::GL_COLOR_ATTACHMENT13_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14_EXT = GLenum::GL_COLOR_ATTACHMENT14_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15_EXT = GLenum::GL_COLOR_ATTACHMENT15_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT16 = GLenum::GL_COLOR_ATTACHMENT16; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT17 = GLenum::GL_COLOR_ATTACHMENT17; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT18 = GLenum::GL_COLOR_ATTACHMENT18; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT19 = GLenum::GL_COLOR_ATTACHMENT19; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT20 = GLenum::GL_COLOR_ATTACHMENT20; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT21 = GLenum::GL_COLOR_ATTACHMENT21; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT22 = GLenum::GL_COLOR_ATTACHMENT22; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT23 = GLenum::GL_COLOR_ATTACHMENT23; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT24 = GLenum::GL_COLOR_ATTACHMENT24; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT25 = GLenum::GL_COLOR_ATTACHMENT25; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT26 = GLenum::GL_COLOR_ATTACHMENT26; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT27 = GLenum::GL_COLOR_ATTACHMENT27; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT28 = GLenum::GL_COLOR_ATTACHMENT28; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT29 = GLenum::GL_COLOR_ATTACHMENT29; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT30 = GLenum::GL_COLOR_ATTACHMENT30; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT31 = GLenum::GL_COLOR_ATTACHMENT31; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_ATTACHMENT = GLenum::GL_DEPTH_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_ATTACHMENT_EXT = GLenum::GL_DEPTH_ATTACHMENT_EXT;

// FramebufferAttachmentParameterName

GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = GLenum::GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_LAYERED = GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED;

// FramebufferParameterName

GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_WIDTH = GLenum::GL_FRAMEBUFFER_DEFAULT_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_HEIGHT = GLenum::GL_FRAMEBUFFER_DEFAULT_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_LAYERS = GLenum::GL_FRAMEBUFFER_DEFAULT_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_SAMPLES = GLenum::GL_FRAMEBUFFER_DEFAULT_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = GLenum::GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS;

// FramebufferStatus

GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_UNDEFINED = GLenum::GL_FRAMEBUFFER_UNDEFINED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_COMPLETE = GLenum::GL_FRAMEBUFFER_COMPLETE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = GLenum::GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = GLenum::GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_UNSUPPORTED = GLenum::GL_FRAMEBUFFER_UNSUPPORTED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = GLenum::GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS;

// FramebufferTarget

// GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER = GLenum::GL_READ_FRAMEBUFFER; // reuse CheckFramebufferStatusTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER = GLenum::GL_DRAW_FRAMEBUFFER; // reuse CheckFramebufferStatusTarget
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER = GLenum::GL_FRAMEBUFFER; // reuse CheckFramebufferStatusTarget

// FrontFaceDirection

GLBINDING_CONSTEXPR static const GLenum GL_CW = GLenum::GL_CW;
GLBINDING_CONSTEXPR static const GLenum GL_CCW = GLenum::GL_CCW;

// GetColorTableParameterPNameSGI

// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SCALE = GLenum::GL_COLOR_TABLE_SCALE; // reuse ColorTableParameterPNameSGI
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SCALE_SGI = GLenum::GL_COLOR_TABLE_SCALE_SGI; // reuse ColorTableParameterPNameSGI
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BIAS = GLenum::GL_COLOR_TABLE_BIAS; // reuse ColorTableParameterPNameSGI
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BIAS_SGI = GLenum::GL_COLOR_TABLE_BIAS_SGI; // reuse ColorTableParameterPNameSGI
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_FORMAT = GLenum::GL_COLOR_TABLE_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_FORMAT_SGI = GLenum::GL_COLOR_TABLE_FORMAT_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_WIDTH = GLenum::GL_COLOR_TABLE_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_WIDTH_SGI = GLenum::GL_COLOR_TABLE_WIDTH_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_RED_SIZE = GLenum::GL_COLOR_TABLE_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_RED_SIZE_SGI = GLenum::GL_COLOR_TABLE_RED_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_GREEN_SIZE = GLenum::GL_COLOR_TABLE_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_GREEN_SIZE_SGI = GLenum::GL_COLOR_TABLE_GREEN_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BLUE_SIZE = GLenum::GL_COLOR_TABLE_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BLUE_SIZE_SGI = GLenum::GL_COLOR_TABLE_BLUE_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_ALPHA_SIZE = GLenum::GL_COLOR_TABLE_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_ALPHA_SIZE_SGI = GLenum::GL_COLOR_TABLE_ALPHA_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_LUMINANCE_SIZE = GLenum::GL_COLOR_TABLE_LUMINANCE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = GLenum::GL_COLOR_TABLE_LUMINANCE_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_INTENSITY_SIZE = GLenum::GL_COLOR_TABLE_INTENSITY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_INTENSITY_SIZE_SGI = GLenum::GL_COLOR_TABLE_INTENSITY_SIZE_SGI;

// GetConvolutionParameter

// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_MODE = GLenum::GL_CONVOLUTION_BORDER_MODE; // reuse ConvolutionParameterEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_MODE_EXT = GLenum::GL_CONVOLUTION_BORDER_MODE_EXT; // reuse ConvolutionParameterEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_SCALE = GLenum::GL_CONVOLUTION_FILTER_SCALE; // reuse ConvolutionParameterEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_SCALE_EXT = GLenum::GL_CONVOLUTION_FILTER_SCALE_EXT; // reuse ConvolutionParameterEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_BIAS = GLenum::GL_CONVOLUTION_FILTER_BIAS; // reuse ConvolutionParameterEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_BIAS_EXT = GLenum::GL_CONVOLUTION_FILTER_BIAS_EXT; // reuse ConvolutionParameterEXT
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FORMAT = GLenum::GL_CONVOLUTION_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FORMAT_EXT = GLenum::GL_CONVOLUTION_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_WIDTH = GLenum::GL_CONVOLUTION_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_WIDTH_EXT = GLenum::GL_CONVOLUTION_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HEIGHT = GLenum::GL_CONVOLUTION_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HEIGHT_EXT = GLenum::GL_CONVOLUTION_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_WIDTH = GLenum::GL_MAX_CONVOLUTION_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_WIDTH_EXT = GLenum::GL_MAX_CONVOLUTION_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_HEIGHT = GLenum::GL_MAX_CONVOLUTION_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_HEIGHT_EXT = GLenum::GL_MAX_CONVOLUTION_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_COLOR = GLenum::GL_CONVOLUTION_BORDER_COLOR;

// GetFramebufferParameter

GLBINDING_CONSTEXPR static const GLenum GL_DOUBLEBUFFER = GLenum::GL_DOUBLEBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_STEREO = GLenum::GL_STEREO;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS = GLenum::GL_SAMPLE_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES = GLenum::GL_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_TYPE = GLenum::GL_IMPLEMENTATION_COLOR_READ_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_FORMAT = GLenum::GL_IMPLEMENTATION_COLOR_READ_FORMAT;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_WIDTH = GLenum::GL_FRAMEBUFFER_DEFAULT_WIDTH; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_HEIGHT = GLenum::GL_FRAMEBUFFER_DEFAULT_HEIGHT; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_LAYERS = GLenum::GL_FRAMEBUFFER_DEFAULT_LAYERS; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_SAMPLES = GLenum::GL_FRAMEBUFFER_DEFAULT_SAMPLES; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = GLenum::GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS; // reuse FramebufferParameterName

// GetHistogramParameterPNameEXT

GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_WIDTH = GLenum::GL_HISTOGRAM_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_WIDTH_EXT = GLenum::GL_HISTOGRAM_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_FORMAT = GLenum::GL_HISTOGRAM_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_FORMAT_EXT = GLenum::GL_HISTOGRAM_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_RED_SIZE = GLenum::GL_HISTOGRAM_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_RED_SIZE_EXT = GLenum::GL_HISTOGRAM_RED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_GREEN_SIZE = GLenum::GL_HISTOGRAM_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_GREEN_SIZE_EXT = GLenum::GL_HISTOGRAM_GREEN_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_BLUE_SIZE = GLenum::GL_HISTOGRAM_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_BLUE_SIZE_EXT = GLenum::GL_HISTOGRAM_BLUE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_ALPHA_SIZE = GLenum::GL_HISTOGRAM_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_ALPHA_SIZE_EXT = GLenum::GL_HISTOGRAM_ALPHA_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_LUMINANCE_SIZE = GLenum::GL_HISTOGRAM_LUMINANCE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_LUMINANCE_SIZE_EXT = GLenum::GL_HISTOGRAM_LUMINANCE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_SINK = GLenum::GL_HISTOGRAM_SINK;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_SINK_EXT = GLenum::GL_HISTOGRAM_SINK_EXT;

// GetMapQuery

GLBINDING_CONSTEXPR static const GLenum GL_COEFF = GLenum::GL_COEFF;
GLBINDING_CONSTEXPR static const GLenum GL_ORDER = GLenum::GL_ORDER;
GLBINDING_CONSTEXPR static const GLenum GL_DOMAIN = GLenum::GL_DOMAIN;

// GetMinmaxParameterPNameEXT

GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_FORMAT = GLenum::GL_MINMAX_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_FORMAT_EXT = GLenum::GL_MINMAX_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_SINK = GLenum::GL_MINMAX_SINK;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_SINK_EXT = GLenum::GL_MINMAX_SINK_EXT;

// GetPName

GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_COLOR = GLenum::GL_CURRENT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_INDEX = GLenum::GL_CURRENT_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_NORMAL = GLenum::GL_CURRENT_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_TEXTURE_COORDS = GLenum::GL_CURRENT_TEXTURE_COORDS;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_COLOR = GLenum::GL_CURRENT_RASTER_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_INDEX = GLenum::GL_CURRENT_RASTER_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_TEXTURE_COORDS = GLenum::GL_CURRENT_RASTER_TEXTURE_COORDS;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_POSITION = GLenum::GL_CURRENT_RASTER_POSITION;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_POSITION_VALID = GLenum::GL_CURRENT_RASTER_POSITION_VALID;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_DISTANCE = GLenum::GL_CURRENT_RASTER_DISTANCE;
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH = GLenum::GL_POINT_SMOOTH; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE = GLenum::GL_POINT_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_RANGE = GLenum::GL_POINT_SIZE_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_POINT_SIZE_RANGE = GLenum::GL_SMOOTH_POINT_SIZE_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_GRANULARITY = GLenum::GL_POINT_SIZE_GRANULARITY;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_POINT_SIZE_GRANULARITY = GLenum::GL_SMOOTH_POINT_SIZE_GRANULARITY;
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH = GLenum::GL_LINE_SMOOTH; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH = GLenum::GL_LINE_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH_RANGE = GLenum::GL_LINE_WIDTH_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_LINE_WIDTH_RANGE = GLenum::GL_SMOOTH_LINE_WIDTH_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH_GRANULARITY = GLenum::GL_LINE_WIDTH_GRANULARITY;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_LINE_WIDTH_GRANULARITY = GLenum::GL_SMOOTH_LINE_WIDTH_GRANULARITY;
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE = GLenum::GL_LINE_STIPPLE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE_PATTERN = GLenum::GL_LINE_STIPPLE_PATTERN;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE_REPEAT = GLenum::GL_LINE_STIPPLE_REPEAT;
GLBINDING_CONSTEXPR static const GLenum GL_LIST_MODE = GLenum::GL_LIST_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LIST_NESTING = GLenum::GL_MAX_LIST_NESTING;
GLBINDING_CONSTEXPR static const GLenum GL_LIST_BASE = GLenum::GL_LIST_BASE;
GLBINDING_CONSTEXPR static const GLenum GL_LIST_INDEX = GLenum::GL_LIST_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_MODE = GLenum::GL_POLYGON_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH = GLenum::GL_POLYGON_SMOOTH; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_STIPPLE = GLenum::GL_POLYGON_STIPPLE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG = GLenum::GL_EDGE_FLAG;
// GLBINDING_CONSTEXPR static const GLenum GL_CULL_FACE = GLenum::GL_CULL_FACE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_CULL_FACE_MODE = GLenum::GL_CULL_FACE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_FACE = GLenum::GL_FRONT_FACE;
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHTING = GLenum::GL_LIGHTING; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_LOCAL_VIEWER = GLenum::GL_LIGHT_MODEL_LOCAL_VIEWER;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_TWO_SIDE = GLenum::GL_LIGHT_MODEL_TWO_SIDE;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_AMBIENT = GLenum::GL_LIGHT_MODEL_AMBIENT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADE_MODEL = GLenum::GL_SHADE_MODEL;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL_FACE = GLenum::GL_COLOR_MATERIAL_FACE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL_PARAMETER = GLenum::GL_COLOR_MATERIAL_PARAMETER;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL = GLenum::GL_COLOR_MATERIAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FOG = GLenum::GL_FOG; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_INDEX = GLenum::GL_FOG_INDEX; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_DENSITY = GLenum::GL_FOG_DENSITY; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_START = GLenum::GL_FOG_START; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_END = GLenum::GL_FOG_END; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_MODE = GLenum::GL_FOG_MODE; // reuse FogPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_COLOR = GLenum::GL_FOG_COLOR; // reuse FogParameter
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_RANGE = GLenum::GL_DEPTH_RANGE;
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_TEST = GLenum::GL_DEPTH_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_WRITEMASK = GLenum::GL_DEPTH_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_CLEAR_VALUE = GLenum::GL_DEPTH_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_FUNC = GLenum::GL_DEPTH_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_CLEAR_VALUE = GLenum::GL_ACCUM_CLEAR_VALUE;
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_TEST = GLenum::GL_STENCIL_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_CLEAR_VALUE = GLenum::GL_STENCIL_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_FUNC = GLenum::GL_STENCIL_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_VALUE_MASK = GLenum::GL_STENCIL_VALUE_MASK;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_FAIL = GLenum::GL_STENCIL_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_PASS_DEPTH_FAIL = GLenum::GL_STENCIL_PASS_DEPTH_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_PASS_DEPTH_PASS = GLenum::GL_STENCIL_PASS_DEPTH_PASS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_REF = GLenum::GL_STENCIL_REF;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_WRITEMASK = GLenum::GL_STENCIL_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_MODE = GLenum::GL_MATRIX_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_NORMALIZE = GLenum::GL_NORMALIZE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT = GLenum::GL_VIEWPORT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_STACK_DEPTH_EXT = GLenum::GL_MODELVIEW0_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW_STACK_DEPTH = GLenum::GL_MODELVIEW_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_PROJECTION_STACK_DEPTH = GLenum::GL_PROJECTION_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_STACK_DEPTH = GLenum::GL_TEXTURE_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_MATRIX_EXT = GLenum::GL_MODELVIEW0_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW_MATRIX = GLenum::GL_MODELVIEW_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_PROJECTION_MATRIX = GLenum::GL_PROJECTION_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MATRIX = GLenum::GL_TEXTURE_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_STACK_DEPTH = GLenum::GL_ATTRIB_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_CLIENT_ATTRIB_STACK_DEPTH = GLenum::GL_CLIENT_ATTRIB_STACK_DEPTH;
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST = GLenum::GL_ALPHA_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST_FUNC = GLenum::GL_ALPHA_TEST_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST_REF = GLenum::GL_ALPHA_TEST_REF;
// GLBINDING_CONSTEXPR static const GLenum GL_DITHER = GLenum::GL_DITHER; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST = GLenum::GL_BLEND_DST;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC = GLenum::GL_BLEND_SRC;
// GLBINDING_CONSTEXPR static const GLenum GL_BLEND = GLenum::GL_BLEND; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LOGIC_OP_MODE = GLenum::GL_LOGIC_OP_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_LOGIC_OP = GLenum::GL_INDEX_LOGIC_OP; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LOGIC_OP = GLenum::GL_LOGIC_OP; // reuse BlendEquationModeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_LOGIC_OP = GLenum::GL_COLOR_LOGIC_OP; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_AUX_BUFFERS = GLenum::GL_AUX_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER = GLenum::GL_DRAW_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_READ_BUFFER = GLenum::GL_READ_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_BOX = GLenum::GL_SCISSOR_BOX;
// GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_TEST = GLenum::GL_SCISSOR_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_CLEAR_VALUE = GLenum::GL_INDEX_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_WRITEMASK = GLenum::GL_INDEX_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_CLEAR_VALUE = GLenum::GL_COLOR_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_WRITEMASK = GLenum::GL_COLOR_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MODE = GLenum::GL_INDEX_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_MODE = GLenum::GL_RGBA_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLEBUFFER = GLenum::GL_DOUBLEBUFFER; // reuse GetFramebufferParameter
// GLBINDING_CONSTEXPR static const GLenum GL_STEREO = GLenum::GL_STEREO; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_RENDER_MODE = GLenum::GL_RENDER_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_PERSPECTIVE_CORRECTION_HINT = GLenum::GL_PERSPECTIVE_CORRECTION_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH_HINT = GLenum::GL_POINT_SMOOTH_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH_HINT = GLenum::GL_LINE_SMOOTH_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH_HINT = GLenum::GL_POLYGON_SMOOTH_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_HINT = GLenum::GL_FOG_HINT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_S = GLenum::GL_TEXTURE_GEN_S; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_T = GLenum::GL_TEXTURE_GEN_T; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_R = GLenum::GL_TEXTURE_GEN_R; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_Q = GLenum::GL_TEXTURE_GEN_Q; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_I_SIZE = GLenum::GL_PIXEL_MAP_I_TO_I_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_S_TO_S_SIZE = GLenum::GL_PIXEL_MAP_S_TO_S_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_R_SIZE = GLenum::GL_PIXEL_MAP_I_TO_R_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_G_SIZE = GLenum::GL_PIXEL_MAP_I_TO_G_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_B_SIZE = GLenum::GL_PIXEL_MAP_I_TO_B_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_A_SIZE = GLenum::GL_PIXEL_MAP_I_TO_A_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_R_TO_R_SIZE = GLenum::GL_PIXEL_MAP_R_TO_R_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_G_TO_G_SIZE = GLenum::GL_PIXEL_MAP_G_TO_G_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_B_TO_B_SIZE = GLenum::GL_PIXEL_MAP_B_TO_B_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_A_TO_A_SIZE = GLenum::GL_PIXEL_MAP_A_TO_A_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SWAP_BYTES = GLenum::GL_UNPACK_SWAP_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_LSB_FIRST = GLenum::GL_UNPACK_LSB_FIRST;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ROW_LENGTH = GLenum::GL_UNPACK_ROW_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_ROWS = GLenum::GL_UNPACK_SKIP_ROWS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_PIXELS = GLenum::GL_UNPACK_SKIP_PIXELS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ALIGNMENT = GLenum::GL_UNPACK_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SWAP_BYTES = GLenum::GL_PACK_SWAP_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_LSB_FIRST = GLenum::GL_PACK_LSB_FIRST;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_ROW_LENGTH = GLenum::GL_PACK_ROW_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_ROWS = GLenum::GL_PACK_SKIP_ROWS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_PIXELS = GLenum::GL_PACK_SKIP_PIXELS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_ALIGNMENT = GLenum::GL_PACK_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_COLOR = GLenum::GL_MAP_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_STENCIL = GLenum::GL_MAP_STENCIL;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_SHIFT = GLenum::GL_INDEX_SHIFT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_OFFSET = GLenum::GL_INDEX_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_RED_SCALE = GLenum::GL_RED_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_RED_BIAS = GLenum::GL_RED_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_ZOOM_X = GLenum::GL_ZOOM_X;
GLBINDING_CONSTEXPR static const GLenum GL_ZOOM_Y = GLenum::GL_ZOOM_Y;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_SCALE = GLenum::GL_GREEN_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_BIAS = GLenum::GL_GREEN_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_SCALE = GLenum::GL_BLUE_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_BIAS = GLenum::GL_BLUE_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_SCALE = GLenum::GL_ALPHA_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_BIAS = GLenum::GL_ALPHA_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_SCALE = GLenum::GL_DEPTH_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BIAS = GLenum::GL_DEPTH_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_EVAL_ORDER = GLenum::GL_MAX_EVAL_ORDER;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LIGHTS = GLenum::GL_MAX_LIGHTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIP_DISTANCES = GLenum::GL_MAX_CLIP_DISTANCES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIP_PLANES = GLenum::GL_MAX_CLIP_PLANES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_SIZE = GLenum::GL_MAX_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PIXEL_MAP_TABLE = GLenum::GL_MAX_PIXEL_MAP_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ATTRIB_STACK_DEPTH = GLenum::GL_MAX_ATTRIB_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_MODELVIEW_STACK_DEPTH = GLenum::GL_MAX_MODELVIEW_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NAME_STACK_DEPTH = GLenum::GL_MAX_NAME_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROJECTION_STACK_DEPTH = GLenum::GL_MAX_PROJECTION_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_STACK_DEPTH = GLenum::GL_MAX_TEXTURE_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VIEWPORT_DIMS = GLenum::GL_MAX_VIEWPORT_DIMS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = GLenum::GL_MAX_CLIENT_ATTRIB_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_SUBPIXEL_BITS = GLenum::GL_SUBPIXEL_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_BITS = GLenum::GL_INDEX_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_RED_BITS = GLenum::GL_RED_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_BITS = GLenum::GL_GREEN_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_BITS = GLenum::GL_BLUE_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_BITS = GLenum::GL_ALPHA_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BITS = GLenum::GL_DEPTH_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BITS = GLenum::GL_STENCIL_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_RED_BITS = GLenum::GL_ACCUM_RED_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_GREEN_BITS = GLenum::GL_ACCUM_GREEN_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_BLUE_BITS = GLenum::GL_ACCUM_BLUE_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_ALPHA_BITS = GLenum::GL_ACCUM_ALPHA_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_NAME_STACK_DEPTH = GLenum::GL_NAME_STACK_DEPTH;
// GLBINDING_CONSTEXPR static const GLenum GL_AUTO_NORMAL = GLenum::GL_AUTO_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_COLOR_4 = GLenum::GL_MAP1_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_INDEX = GLenum::GL_MAP1_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_NORMAL = GLenum::GL_MAP1_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_1 = GLenum::GL_MAP1_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_2 = GLenum::GL_MAP1_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_3 = GLenum::GL_MAP1_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_4 = GLenum::GL_MAP1_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_3 = GLenum::GL_MAP1_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_4 = GLenum::GL_MAP1_VERTEX_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_COLOR_4 = GLenum::GL_MAP2_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_INDEX = GLenum::GL_MAP2_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_NORMAL = GLenum::GL_MAP2_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_1 = GLenum::GL_MAP2_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_2 = GLenum::GL_MAP2_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_3 = GLenum::GL_MAP2_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_4 = GLenum::GL_MAP2_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_3 = GLenum::GL_MAP2_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_4 = GLenum::GL_MAP2_VERTEX_4; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_GRID_DOMAIN = GLenum::GL_MAP1_GRID_DOMAIN;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_GRID_SEGMENTS = GLenum::GL_MAP1_GRID_SEGMENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_GRID_DOMAIN = GLenum::GL_MAP2_GRID_DOMAIN;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_GRID_SEGMENTS = GLenum::GL_MAP2_GRID_SEGMENTS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK_BUFFER_SIZE = GLenum::GL_FEEDBACK_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK_BUFFER_TYPE = GLenum::GL_FEEDBACK_BUFFER_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SELECTION_BUFFER_SIZE = GLenum::GL_SELECTION_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_UNITS = GLenum::GL_POLYGON_OFFSET_UNITS;
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_POINT = GLenum::GL_POLYGON_OFFSET_POINT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_LINE = GLenum::GL_POLYGON_OFFSET_LINE; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE0 = GLenum::GL_CLIP_PLANE0; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE1 = GLenum::GL_CLIP_PLANE1; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE2 = GLenum::GL_CLIP_PLANE2; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE3 = GLenum::GL_CLIP_PLANE3; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE4 = GLenum::GL_CLIP_PLANE4; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE5 = GLenum::GL_CLIP_PLANE5; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT0 = GLenum::GL_LIGHT0; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT1 = GLenum::GL_LIGHT1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT2 = GLenum::GL_LIGHT2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT3 = GLenum::GL_LIGHT3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT4 = GLenum::GL_LIGHT4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT5 = GLenum::GL_LIGHT5; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT6 = GLenum::GL_LIGHT6; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT7 = GLenum::GL_LIGHT7; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_COLOR_EXT = GLenum::GL_BLEND_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_EXT = GLenum::GL_BLEND_EQUATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_CMYK_HINT_EXT = GLenum::GL_PACK_CMYK_HINT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CMYK_HINT_EXT = GLenum::GL_UNPACK_CMYK_HINT_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D_EXT = GLenum::GL_CONVOLUTION_1D_EXT; // reuse ConvolutionTargetEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D_EXT = GLenum::GL_CONVOLUTION_2D_EXT; // reuse ConvolutionTargetEXT
// GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D_EXT = GLenum::GL_SEPARABLE_2D_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_RED_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_RED_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_EXT = GLenum::GL_HISTOGRAM_EXT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_EXT = GLenum::GL_MINMAX_EXT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FILL = GLenum::GL_POLYGON_OFFSET_FILL; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FACTOR = GLenum::GL_POLYGON_OFFSET_FACTOR;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_BIAS_EXT = GLenum::GL_POLYGON_OFFSET_BIAS_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_RESCALE_NORMAL_EXT = GLenum::GL_RESCALE_NORMAL_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_1D = GLenum::GL_TEXTURE_BINDING_1D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D = GLenum::GL_TEXTURE_BINDING_2D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_BINDING_EXT = GLenum::GL_TEXTURE_3D_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_3D = GLenum::GL_TEXTURE_BINDING_3D;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES_EXT = GLenum::GL_PACK_SKIP_IMAGES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT_EXT = GLenum::GL_PACK_IMAGE_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES_EXT = GLenum::GL_UNPACK_SKIP_IMAGES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT_EXT = GLenum::GL_UNPACK_IMAGE_HEIGHT_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_EXT = GLenum::GL_TEXTURE_3D_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_3D_TEXTURE_SIZE_EXT = GLenum::GL_MAX_3D_TEXTURE_SIZE_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY = GLenum::GL_VERTEX_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY = GLenum::GL_NORMAL_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY = GLenum::GL_COLOR_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY = GLenum::GL_INDEX_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY = GLenum::GL_TEXTURE_COORD_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY = GLenum::GL_EDGE_FLAG_ARRAY; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_SIZE = GLenum::GL_VERTEX_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_TYPE = GLenum::GL_VERTEX_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_STRIDE = GLenum::GL_VERTEX_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_COUNT_EXT = GLenum::GL_VERTEX_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_TYPE = GLenum::GL_NORMAL_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_STRIDE = GLenum::GL_NORMAL_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_COUNT_EXT = GLenum::GL_NORMAL_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_SIZE = GLenum::GL_COLOR_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_TYPE = GLenum::GL_COLOR_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_STRIDE = GLenum::GL_COLOR_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_COUNT_EXT = GLenum::GL_COLOR_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_TYPE = GLenum::GL_INDEX_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_STRIDE = GLenum::GL_INDEX_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_COUNT_EXT = GLenum::GL_INDEX_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_SIZE = GLenum::GL_TEXTURE_COORD_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_TYPE = GLenum::GL_TEXTURE_COORD_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_STRIDE = GLenum::GL_TEXTURE_COORD_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_COUNT_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_STRIDE = GLenum::GL_EDGE_FLAG_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_COUNT_EXT = GLenum::GL_EDGE_FLAG_ARRAY_COUNT_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_SGIX = GLenum::GL_INTERLACE_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_2D_BINDING_SGIS = GLenum::GL_DETAIL_TEXTURE_2D_BINDING_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_SGIS = GLenum::GL_MULTISAMPLE_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_MASK_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_MASK_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_ONE_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_SGIS = GLenum::GL_SAMPLE_MASK_SGIS; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_SGIS = GLenum::GL_SAMPLE_BUFFERS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_SGIS = GLenum::GL_SAMPLES_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_VALUE_SGIS = GLenum::GL_SAMPLE_MASK_VALUE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_INVERT_SGIS = GLenum::GL_SAMPLE_MASK_INVERT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_PATTERN_SGIS = GLenum::GL_SAMPLE_PATTERN_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX_SGI = GLenum::GL_COLOR_MATRIX_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX_STACK_DEPTH_SGI = GLenum::GL_COLOR_MATRIX_STACK_DEPTH_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = GLenum::GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_TEXTURE_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SGI = GLenum::GL_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_SGIS = GLenum::GL_POINT_SIZE_MIN_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_SGIS = GLenum::GL_POINT_SIZE_MAX_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_SGIS = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_SGIS = GLenum::GL_DISTANCE_ATTENUATION_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_FUNC_POINTS_SGIS = GLenum::GL_FOG_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FOG_FUNC_POINTS_SGIS = GLenum::GL_MAX_FOG_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_VOLUMES_SGIS = GLenum::GL_PACK_SKIP_VOLUMES_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_DEPTH_SGIS = GLenum::GL_PACK_IMAGE_DEPTH_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_VOLUMES_SGIS = GLenum::GL_UNPACK_SKIP_VOLUMES_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_DEPTH_SGIS = GLenum::GL_UNPACK_IMAGE_DEPTH_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_SGIS = GLenum::GL_TEXTURE_4D_SGIS; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_4D_TEXTURE_SIZE_SGIS = GLenum::GL_MAX_4D_TEXTURE_SIZE_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEX_GEN_SGIX = GLenum::GL_PIXEL_TEX_GEN_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = GLenum::GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_CACHE_INCREMENT_SGIX = GLenum::GL_PIXEL_TILE_CACHE_INCREMENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_WIDTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_HEIGHT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_WIDTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_GRID_HEIGHT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_DEPTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_CACHE_SIZE_SGIX = GLenum::GL_PIXEL_TILE_CACHE_SIZE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_SGIX = GLenum::GL_SPRITE_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_MODE_SGIX = GLenum::GL_SPRITE_MODE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_AXIS_SGIX = GLenum::GL_SPRITE_AXIS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_TRANSLATION_SGIX = GLenum::GL_SPRITE_TRANSLATION_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_BINDING_SGIS = GLenum::GL_TEXTURE_4D_BINDING_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIPMAP_DEPTH_SGIX = GLenum::GL_MAX_CLIPMAP_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = GLenum::GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_REFERENCE_PLANE_SGIX = GLenum::GL_REFERENCE_PLANE_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCE_PLANE_EQUATION_SGIX = GLenum::GL_REFERENCE_PLANE_EQUATION_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_IR_INSTRUMENT1_SGIX = GLenum::GL_IR_INSTRUMENT1_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_INSTRUMENT_MEASUREMENTS_SGIX = GLenum::GL_INSTRUMENT_MEASUREMENTS_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_CALLIGRAPHIC_FRAGMENT_SGIX = GLenum::GL_CALLIGRAPHIC_FRAGMENT_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEZOOM_SGIX = GLenum::GL_FRAMEZOOM_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEZOOM_FACTOR_SGIX = GLenum::GL_FRAMEZOOM_FACTOR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAMEZOOM_FACTOR_SGIX = GLenum::GL_MAX_FRAMEZOOM_FACTOR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_HINT_SGIS = GLenum::GL_GENERATE_MIPMAP_HINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DEFORMATIONS_MASK_SGIX = GLenum::GL_DEFORMATIONS_MASK_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_SGIX = GLenum::GL_FOG_OFFSET_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_VALUE_SGIX = GLenum::GL_FOG_OFFSET_VALUE_SGIX; // reuse FogParameter
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_COLOR_CONTROL = GLenum::GL_LIGHT_MODEL_COLOR_CONTROL;
// GLBINDING_CONSTEXPR static const GLenum GL_SHARED_TEXTURE_PALETTE_EXT = GLenum::GL_SHARED_TEXTURE_PALETTE_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HINT_SGIX = GLenum::GL_CONVOLUTION_HINT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_MARKER_SGIX = GLenum::GL_ASYNC_MARKER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEX_GEN_MODE_SGIX = GLenum::GL_PIXEL_TEX_GEN_MODE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_HISTOGRAM_SGIX = GLenum::GL_ASYNC_HISTOGRAM_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_HISTOGRAM_SGIX = GLenum::GL_MAX_ASYNC_HISTOGRAM_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEXTURE_SGIS = GLenum::GL_PIXEL_TEXTURE_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_TEX_IMAGE_SGIX = GLenum::GL_ASYNC_TEX_IMAGE_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_DRAW_PIXELS_SGIX = GLenum::GL_ASYNC_DRAW_PIXELS_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_READ_PIXELS_SGIX = GLenum::GL_ASYNC_READ_PIXELS_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_TEX_IMAGE_SGIX = GLenum::GL_MAX_ASYNC_TEX_IMAGE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_DRAW_PIXELS_SGIX = GLenum::GL_MAX_ASYNC_DRAW_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_READ_PIXELS_SGIX = GLenum::GL_MAX_ASYNC_READ_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_SGIX = GLenum::GL_VERTEX_PRECLIP_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_HINT_SGIX = GLenum::GL_VERTEX_PRECLIP_HINT_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHTING_SGIX = GLenum::GL_FRAGMENT_LIGHTING_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_LIGHTS_SGIX = GLenum::GL_MAX_FRAGMENT_LIGHTS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ACTIVE_LIGHTS_SGIX = GLenum::GL_MAX_ACTIVE_LIGHTS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_ENV_MODE_SGIX = GLenum::GL_LIGHT_ENV_MODE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PACK_RESAMPLE_SGIX = GLenum::GL_PACK_RESAMPLE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_RESAMPLE_SGIX = GLenum::GL_UNPACK_RESAMPLE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ALIASED_POINT_SIZE_RANGE = GLenum::GL_ALIASED_POINT_SIZE_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_ALIASED_LINE_WIDTH_RANGE = GLenum::GL_ALIASED_LINE_WIDTH_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_PACK_SUBSAMPLE_RATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_UNPACK_SUBSAMPLE_RATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_DEVICE_UUIDS_EXT = GLenum::GL_NUM_DEVICE_UUIDS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEVICE_UUID_EXT = GLenum::GL_DEVICE_UUID_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DRIVER_UUID_EXT = GLenum::GL_DRIVER_UUID_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEVICE_LUID_EXT = GLenum::GL_DEVICE_LUID_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEVICE_NODE_MASK_EXT = GLenum::GL_DEVICE_NODE_MASK_EXT;

// GetPixelMap

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_I = GLenum::GL_PIXEL_MAP_I_TO_I;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_S_TO_S = GLenum::GL_PIXEL_MAP_S_TO_S;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_R = GLenum::GL_PIXEL_MAP_I_TO_R;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_G = GLenum::GL_PIXEL_MAP_I_TO_G;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_B = GLenum::GL_PIXEL_MAP_I_TO_B;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_A = GLenum::GL_PIXEL_MAP_I_TO_A;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_R_TO_R = GLenum::GL_PIXEL_MAP_R_TO_R;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_G_TO_G = GLenum::GL_PIXEL_MAP_G_TO_G;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_B_TO_B = GLenum::GL_PIXEL_MAP_B_TO_B;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_A_TO_A = GLenum::GL_PIXEL_MAP_A_TO_A;

// GetPointervPName

GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK_BUFFER_POINTER = GLenum::GL_FEEDBACK_BUFFER_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_SELECTION_BUFFER_POINTER = GLenum::GL_SELECTION_BUFFER_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_POINTER = GLenum::GL_VERTEX_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_POINTER_EXT = GLenum::GL_VERTEX_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_POINTER = GLenum::GL_NORMAL_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_POINTER_EXT = GLenum::GL_NORMAL_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_POINTER = GLenum::GL_COLOR_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_POINTER_EXT = GLenum::GL_COLOR_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_POINTER = GLenum::GL_INDEX_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_POINTER_EXT = GLenum::GL_INDEX_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_POINTER = GLenum::GL_TEXTURE_COORD_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_POINTER_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_POINTER = GLenum::GL_EDGE_FLAG_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_POINTER_EXT = GLenum::GL_EDGE_FLAG_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INSTRUMENT_BUFFER_POINTER_SGIX = GLenum::GL_INSTRUMENT_BUFFER_POINTER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_FUNCTION = GLenum::GL_DEBUG_CALLBACK_FUNCTION;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_USER_PARAM = GLenum::GL_DEBUG_CALLBACK_USER_PARAM;

// GetTextureParameter

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WIDTH = GLenum::GL_TEXTURE_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_HEIGHT = GLenum::GL_TEXTURE_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPONENTS = GLenum::GL_TEXTURE_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTERNAL_FORMAT = GLenum::GL_TEXTURE_INTERNAL_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_COLOR = GLenum::GL_TEXTURE_BORDER_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER = GLenum::GL_TEXTURE_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_FILTER = GLenum::GL_TEXTURE_MAG_FILTER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_FILTER = GLenum::GL_TEXTURE_MIN_FILTER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_S = GLenum::GL_TEXTURE_WRAP_S;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_T = GLenum::GL_TEXTURE_WRAP_T;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_SIZE = GLenum::GL_TEXTURE_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_SIZE = GLenum::GL_TEXTURE_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_SIZE = GLenum::GL_TEXTURE_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_SIZE = GLenum::GL_TEXTURE_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_SIZE = GLenum::GL_TEXTURE_LUMINANCE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_SIZE = GLenum::GL_TEXTURE_INTENSITY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRIORITY = GLenum::GL_TEXTURE_PRIORITY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RESIDENT = GLenum::GL_TEXTURE_RESIDENT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_EXT = GLenum::GL_TEXTURE_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R_EXT = GLenum::GL_TEXTURE_WRAP_R_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_LEVEL_SGIS = GLenum::GL_DETAIL_TEXTURE_LEVEL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_MODE_SGIS = GLenum::GL_DETAIL_TEXTURE_MODE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADOW_AMBIENT_SGIX = GLenum::GL_SHADOW_AMBIENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_TEXTURE_SELECT_SGIS = GLenum::GL_DUAL_TEXTURE_SELECT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_TEXTURE_SELECT_SGIS = GLenum::GL_QUAD_TEXTURE_SELECT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4DSIZE_SGIS = GLenum::GL_TEXTURE_4DSIZE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_Q_SGIS = GLenum::GL_TEXTURE_WRAP_Q_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD_SGIS = GLenum::GL_TEXTURE_MIN_LOD_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD_SGIS = GLenum::GL_TEXTURE_MAX_LOD_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BASE_LEVEL_SGIS = GLenum::GL_TEXTURE_BASE_LEVEL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LEVEL_SGIS = GLenum::GL_TEXTURE_MAX_LEVEL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER4_SIZE_SGIS = GLenum::GL_TEXTURE_FILTER4_SIZE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_CENTER_SGIX = GLenum::GL_TEXTURE_CLIPMAP_CENTER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_FRAME_SGIX = GLenum::GL_TEXTURE_CLIPMAP_FRAME_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_OFFSET_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_BIAS_SGIX = GLenum::GL_POST_TEXTURE_FILTER_BIAS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_SCALE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_SCALE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_S_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_S_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_T_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_T_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_R_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_SGIS = GLenum::GL_GENERATE_MIPMAP_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_SGIX = GLenum::GL_TEXTURE_COMPARE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_OPERATOR_SGIX = GLenum::GL_TEXTURE_COMPARE_OPERATOR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LEQUAL_R_SGIX = GLenum::GL_TEXTURE_LEQUAL_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEQUAL_R_SGIX = GLenum::GL_TEXTURE_GEQUAL_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_S_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_S_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_T_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_T_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_R_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_R_SGIX;

// GraphicsResetStatus

// GLBINDING_CONSTEXPR static const GLenum GL_NO_ERROR = GLenum::GL_NO_ERROR; // reuse ErrorCode
GLBINDING_CONSTEXPR static const GLenum GL_GUILTY_CONTEXT_RESET = GLenum::GL_GUILTY_CONTEXT_RESET;
GLBINDING_CONSTEXPR static const GLenum GL_INNOCENT_CONTEXT_RESET = GLenum::GL_INNOCENT_CONTEXT_RESET;
GLBINDING_CONSTEXPR static const GLenum GL_UNKNOWN_CONTEXT_RESET = GLenum::GL_UNKNOWN_CONTEXT_RESET;

// HintMode

// GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE; // reuse DebugSeverity
GLBINDING_CONSTEXPR static const GLenum GL_FASTEST = GLenum::GL_FASTEST;
GLBINDING_CONSTEXPR static const GLenum GL_NICEST = GLenum::GL_NICEST;

// HintTarget

// GLBINDING_CONSTEXPR static const GLenum GL_PERSPECTIVE_CORRECTION_HINT = GLenum::GL_PERSPECTIVE_CORRECTION_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH_HINT = GLenum::GL_POINT_SMOOTH_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH_HINT = GLenum::GL_LINE_SMOOTH_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH_HINT = GLenum::GL_POLYGON_SMOOTH_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_HINT = GLenum::GL_FOG_HINT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PREFER_DOUBLEBUFFER_HINT_PGI = GLenum::GL_PREFER_DOUBLEBUFFER_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_CONSERVE_MEMORY_HINT_PGI = GLenum::GL_CONSERVE_MEMORY_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_RECLAIM_MEMORY_HINT_PGI = GLenum::GL_RECLAIM_MEMORY_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = GLenum::GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_NATIVE_GRAPHICS_END_HINT_PGI = GLenum::GL_NATIVE_GRAPHICS_END_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS_FAST_HINT_PGI = GLenum::GL_ALWAYS_FAST_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS_SOFT_HINT_PGI = GLenum::GL_ALWAYS_SOFT_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_OBJ_HINT_PGI = GLenum::GL_ALLOW_DRAW_OBJ_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_WIN_HINT_PGI = GLenum::GL_ALLOW_DRAW_WIN_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_FRG_HINT_PGI = GLenum::GL_ALLOW_DRAW_FRG_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_MEM_HINT_PGI = GLenum::GL_ALLOW_DRAW_MEM_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_STRICT_DEPTHFUNC_HINT_PGI = GLenum::GL_STRICT_DEPTHFUNC_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_STRICT_LIGHTING_HINT_PGI = GLenum::GL_STRICT_LIGHTING_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_STRICT_SCISSOR_HINT_PGI = GLenum::GL_STRICT_SCISSOR_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_FULL_STIPPLE_HINT_PGI = GLenum::GL_FULL_STIPPLE_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_NEAR_HINT_PGI = GLenum::GL_CLIP_NEAR_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_FAR_HINT_PGI = GLenum::GL_CLIP_FAR_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_WIDE_LINE_HINT_PGI = GLenum::GL_WIDE_LINE_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_NORMALS_HINT_PGI = GLenum::GL_BACK_NORMALS_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_DATA_HINT_PGI = GLenum::GL_VERTEX_DATA_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_CONSISTENT_HINT_PGI = GLenum::GL_VERTEX_CONSISTENT_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_MATERIAL_SIDE_HINT_PGI = GLenum::GL_MATERIAL_SIDE_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_HINT_PGI = GLenum::GL_MAX_VERTEX_HINT_PGI;
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_CMYK_HINT_EXT = GLenum::GL_PACK_CMYK_HINT_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CMYK_HINT_EXT = GLenum::GL_UNPACK_CMYK_HINT_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PHONG_HINT_WIN = GLenum::GL_PHONG_HINT_WIN;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_VOLUME_CLIPPING_HINT_EXT = GLenum::GL_CLIP_VOLUME_CLIPPING_HINT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MULTI_BUFFER_HINT_SGIX = GLenum::GL_TEXTURE_MULTI_BUFFER_HINT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_HINT = GLenum::GL_GENERATE_MIPMAP_HINT;
// GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_HINT_SGIS = GLenum::GL_GENERATE_MIPMAP_HINT_SGIS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_RETRIEVABLE_HINT = GLenum::GL_PROGRAM_BINARY_RETRIEVABLE_HINT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HINT_SGIX = GLenum::GL_CONVOLUTION_HINT_SGIX; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_SCALEBIAS_HINT_SGIX = GLenum::GL_SCALEBIAS_HINT_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_SGIX = GLenum::GL_VERTEX_PRECLIP_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_HINT_SGIX = GLenum::GL_VERTEX_PRECLIP_HINT_SGIX; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSION_HINT = GLenum::GL_TEXTURE_COMPRESSION_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSION_HINT_ARB = GLenum::GL_TEXTURE_COMPRESSION_HINT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = GLenum::GL_VERTEX_ARRAY_STORAGE_HINT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_FILTER_HINT_NV = GLenum::GL_MULTISAMPLE_FILTER_HINT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_HINT_APPLE = GLenum::GL_TRANSFORM_HINT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_STORAGE_HINT_APPLE = GLenum::GL_TEXTURE_STORAGE_HINT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_DERIVATIVE_HINT = GLenum::GL_FRAGMENT_SHADER_DERIVATIVE_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = GLenum::GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB;

// HistogramTargetEXT

GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM = GLenum::GL_HISTOGRAM;
// GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_EXT = GLenum::GL_HISTOGRAM_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_HISTOGRAM = GLenum::GL_PROXY_HISTOGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_HISTOGRAM_EXT = GLenum::GL_PROXY_HISTOGRAM_EXT;

// IndexPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// InterleavedArrayFormat

GLBINDING_CONSTEXPR static const GLenum GL_V2F = GLenum::GL_V2F;
GLBINDING_CONSTEXPR static const GLenum GL_V3F = GLenum::GL_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_C4UB_V2F = GLenum::GL_C4UB_V2F;
GLBINDING_CONSTEXPR static const GLenum GL_C4UB_V3F = GLenum::GL_C4UB_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_C3F_V3F = GLenum::GL_C3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_N3F_V3F = GLenum::GL_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_C4F_N3F_V3F = GLenum::GL_C4F_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_V3F = GLenum::GL_T2F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T4F_V4F = GLenum::GL_T4F_V4F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_C4UB_V3F = GLenum::GL_T2F_C4UB_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_C3F_V3F = GLenum::GL_T2F_C3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_N3F_V3F = GLenum::GL_T2F_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_C4F_N3F_V3F = GLenum::GL_T2F_C4F_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T4F_C4F_N3F_V4F = GLenum::GL_T4F_C4F_N3F_V4F;

// InternalFormat

GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT = GLenum::GL_DEPTH_COMPONENT;
GLBINDING_CONSTEXPR static const GLenum GL_RED = GLenum::GL_RED;
GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_R3_G3_B2 = GLenum::GL_R3_G3_B2;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA4 = GLenum::GL_ALPHA4;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8 = GLenum::GL_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA12 = GLenum::GL_ALPHA12;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16 = GLenum::GL_ALPHA16;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4 = GLenum::GL_LUMINANCE4;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8 = GLenum::GL_LUMINANCE8;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12 = GLenum::GL_LUMINANCE12;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16 = GLenum::GL_LUMINANCE16;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_ALPHA4 = GLenum::GL_LUMINANCE4_ALPHA4;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE6_ALPHA2 = GLenum::GL_LUMINANCE6_ALPHA2;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_ALPHA8 = GLenum::GL_LUMINANCE8_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA4 = GLenum::GL_LUMINANCE12_ALPHA4;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA12 = GLenum::GL_LUMINANCE12_ALPHA12;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_ALPHA16 = GLenum::GL_LUMINANCE16_ALPHA16;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY = GLenum::GL_INTENSITY;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY4 = GLenum::GL_INTENSITY4;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8 = GLenum::GL_INTENSITY8;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY12 = GLenum::GL_INTENSITY12;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16 = GLenum::GL_INTENSITY16;
GLBINDING_CONSTEXPR static const GLenum GL_RGB2_EXT = GLenum::GL_RGB2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB4 = GLenum::GL_RGB4;
GLBINDING_CONSTEXPR static const GLenum GL_RGB4_EXT = GLenum::GL_RGB4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5 = GLenum::GL_RGB5;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5_EXT = GLenum::GL_RGB5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8 = GLenum::GL_RGB8;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8_EXT = GLenum::GL_RGB8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10 = GLenum::GL_RGB10;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_EXT = GLenum::GL_RGB10_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB12 = GLenum::GL_RGB12;
GLBINDING_CONSTEXPR static const GLenum GL_RGB12_EXT = GLenum::GL_RGB12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16 = GLenum::GL_RGB16;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16_EXT = GLenum::GL_RGB16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4 = GLenum::GL_RGBA4;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_EXT = GLenum::GL_RGBA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5_A1 = GLenum::GL_RGB5_A1;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5_A1_EXT = GLenum::GL_RGB5_A1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8 = GLenum::GL_RGBA8;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8_EXT = GLenum::GL_RGBA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2 = GLenum::GL_RGB10_A2;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2_EXT = GLenum::GL_RGB10_A2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA12 = GLenum::GL_RGBA12;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA12_EXT = GLenum::GL_RGBA12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16 = GLenum::GL_RGBA16;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16_EXT = GLenum::GL_RGBA16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA4_SGIS = GLenum::GL_DUAL_ALPHA4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA8_SGIS = GLenum::GL_DUAL_ALPHA8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA12_SGIS = GLenum::GL_DUAL_ALPHA12_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA16_SGIS = GLenum::GL_DUAL_ALPHA16_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE4_SGIS = GLenum::GL_DUAL_LUMINANCE4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE8_SGIS = GLenum::GL_DUAL_LUMINANCE8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE12_SGIS = GLenum::GL_DUAL_LUMINANCE12_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE16_SGIS = GLenum::GL_DUAL_LUMINANCE16_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY4_SGIS = GLenum::GL_DUAL_INTENSITY4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY8_SGIS = GLenum::GL_DUAL_INTENSITY8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY12_SGIS = GLenum::GL_DUAL_INTENSITY12_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY16_SGIS = GLenum::GL_DUAL_INTENSITY16_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE_ALPHA4_SGIS = GLenum::GL_DUAL_LUMINANCE_ALPHA4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE_ALPHA8_SGIS = GLenum::GL_DUAL_LUMINANCE_ALPHA8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_ALPHA4_SGIS = GLenum::GL_QUAD_ALPHA4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_ALPHA8_SGIS = GLenum::GL_QUAD_ALPHA8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_LUMINANCE4_SGIS = GLenum::GL_QUAD_LUMINANCE4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_LUMINANCE8_SGIS = GLenum::GL_QUAD_LUMINANCE8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_INTENSITY4_SGIS = GLenum::GL_QUAD_INTENSITY4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_INTENSITY8_SGIS = GLenum::GL_QUAD_INTENSITY8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16 = GLenum::GL_DEPTH_COMPONENT16;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16_ARB = GLenum::GL_DEPTH_COMPONENT16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16_SGIX = GLenum::GL_DEPTH_COMPONENT16_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24_ARB = GLenum::GL_DEPTH_COMPONENT24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24_SGIX = GLenum::GL_DEPTH_COMPONENT24_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32_ARB = GLenum::GL_DEPTH_COMPONENT32_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32_SGIX = GLenum::GL_DEPTH_COMPONENT32_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED = GLenum::GL_COMPRESSED_RED;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG = GLenum::GL_COMPRESSED_RG;
GLBINDING_CONSTEXPR static const GLenum GL_RG = GLenum::GL_RG;
GLBINDING_CONSTEXPR static const GLenum GL_R8 = GLenum::GL_R8;
GLBINDING_CONSTEXPR static const GLenum GL_R16 = GLenum::GL_R16;
GLBINDING_CONSTEXPR static const GLenum GL_RG8 = GLenum::GL_RG8;
GLBINDING_CONSTEXPR static const GLenum GL_RG16 = GLenum::GL_RG16;
GLBINDING_CONSTEXPR static const GLenum GL_R16F = GLenum::GL_R16F;
GLBINDING_CONSTEXPR static const GLenum GL_R32F = GLenum::GL_R32F;
GLBINDING_CONSTEXPR static const GLenum GL_RG16F = GLenum::GL_RG16F;
GLBINDING_CONSTEXPR static const GLenum GL_RG32F = GLenum::GL_RG32F;
GLBINDING_CONSTEXPR static const GLenum GL_R8I = GLenum::GL_R8I;
GLBINDING_CONSTEXPR static const GLenum GL_R8UI = GLenum::GL_R8UI;
GLBINDING_CONSTEXPR static const GLenum GL_R16I = GLenum::GL_R16I;
GLBINDING_CONSTEXPR static const GLenum GL_R16UI = GLenum::GL_R16UI;
GLBINDING_CONSTEXPR static const GLenum GL_R32I = GLenum::GL_R32I;
GLBINDING_CONSTEXPR static const GLenum GL_R32UI = GLenum::GL_R32UI;
GLBINDING_CONSTEXPR static const GLenum GL_RG8I = GLenum::GL_RG8I;
GLBINDING_CONSTEXPR static const GLenum GL_RG8UI = GLenum::GL_RG8UI;
GLBINDING_CONSTEXPR static const GLenum GL_RG16I = GLenum::GL_RG16I;
GLBINDING_CONSTEXPR static const GLenum GL_RG16UI = GLenum::GL_RG16UI;
GLBINDING_CONSTEXPR static const GLenum GL_RG32I = GLenum::GL_RG32I;
GLBINDING_CONSTEXPR static const GLenum GL_RG32UI = GLenum::GL_RG32UI;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_RGB_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB = GLenum::GL_COMPRESSED_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA = GLenum::GL_COMPRESSED_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL = GLenum::GL_DEPTH_STENCIL;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_EXT = GLenum::GL_DEPTH_STENCIL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_NV = GLenum::GL_DEPTH_STENCIL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F = GLenum::GL_RGBA32F;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F_ARB = GLenum::GL_RGBA32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F = GLenum::GL_RGBA16F;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F_ARB = GLenum::GL_RGBA16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16F = GLenum::GL_RGB16F;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16F_ARB = GLenum::GL_RGB16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH24_STENCIL8 = GLenum::GL_DEPTH24_STENCIL8;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH24_STENCIL8_EXT = GLenum::GL_DEPTH24_STENCIL8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_R11F_G11F_B10F = GLenum::GL_R11F_G11F_B10F;
GLBINDING_CONSTEXPR static const GLenum GL_R11F_G11F_B10F_EXT = GLenum::GL_R11F_G11F_B10F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB9_E5 = GLenum::GL_RGB9_E5;
GLBINDING_CONSTEXPR static const GLenum GL_RGB9_E5_EXT = GLenum::GL_RGB9_E5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB = GLenum::GL_SRGB;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_EXT = GLenum::GL_SRGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8 = GLenum::GL_SRGB8;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_EXT = GLenum::GL_SRGB8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_ALPHA = GLenum::GL_SRGB_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_ALPHA_EXT = GLenum::GL_SRGB_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_ALPHA8 = GLenum::GL_SRGB8_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_ALPHA8_EXT = GLenum::GL_SRGB8_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB = GLenum::GL_COMPRESSED_SRGB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA = GLenum::GL_COMPRESSED_SRGB_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_SRGB_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32F = GLenum::GL_DEPTH_COMPONENT32F;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH32F_STENCIL8 = GLenum::GL_DEPTH32F_STENCIL8;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32UI = GLenum::GL_RGBA32UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32UI = GLenum::GL_RGB32UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16UI = GLenum::GL_RGBA16UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16UI = GLenum::GL_RGB16UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8UI = GLenum::GL_RGBA8UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8UI = GLenum::GL_RGB8UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32I = GLenum::GL_RGBA32I;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32I = GLenum::GL_RGB32I;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16I = GLenum::GL_RGBA16I;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16I = GLenum::GL_RGB16I;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8I = GLenum::GL_RGBA8I;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8I = GLenum::GL_RGB8I;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32F_NV = GLenum::GL_DEPTH_COMPONENT32F_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH32F_STENCIL8_NV = GLenum::GL_DEPTH32F_STENCIL8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_RGTC1 = GLenum::GL_COMPRESSED_RED_RGTC1;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_RGTC1_EXT = GLenum::GL_COMPRESSED_RED_RGTC1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_RGTC1 = GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG_RGTC2 = GLenum::GL_COMPRESSED_RG_RGTC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RG_RGTC2 = GLenum::GL_COMPRESSED_SIGNED_RG_RGTC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_BPTC_UNORM = GLenum::GL_COMPRESSED_RGBA_BPTC_UNORM;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = GLenum::GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = GLenum::GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = GLenum::GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_R8_SNORM = GLenum::GL_R8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RG8_SNORM = GLenum::GL_RG8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8_SNORM = GLenum::GL_RGB8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8_SNORM = GLenum::GL_RGBA8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_R16_SNORM = GLenum::GL_R16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RG16_SNORM = GLenum::GL_RG16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16_SNORM = GLenum::GL_RGB16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2UI = GLenum::GL_RGB10_A2UI;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_R11_EAC = GLenum::GL_COMPRESSED_R11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_R11_EAC = GLenum::GL_COMPRESSED_SIGNED_R11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG11_EAC = GLenum::GL_COMPRESSED_RG11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RG11_EAC = GLenum::GL_COMPRESSED_SIGNED_RG11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB8_ETC2 = GLenum::GL_COMPRESSED_RGB8_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ETC2 = GLenum::GL_COMPRESSED_SRGB8_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = GLenum::GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = GLenum::GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA8_ETC2_EAC = GLenum::GL_COMPRESSED_RGBA8_ETC2_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;

// InternalFormatPName

// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES = GLenum::GL_SAMPLES; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP = GLenum::GL_GENERATE_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_SUPPORTED = GLenum::GL_INTERNALFORMAT_SUPPORTED;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_PREFERRED = GLenum::GL_INTERNALFORMAT_PREFERRED;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_RED_SIZE = GLenum::GL_INTERNALFORMAT_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_GREEN_SIZE = GLenum::GL_INTERNALFORMAT_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_BLUE_SIZE = GLenum::GL_INTERNALFORMAT_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_ALPHA_SIZE = GLenum::GL_INTERNALFORMAT_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_DEPTH_SIZE = GLenum::GL_INTERNALFORMAT_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_STENCIL_SIZE = GLenum::GL_INTERNALFORMAT_STENCIL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_SHARED_SIZE = GLenum::GL_INTERNALFORMAT_SHARED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_RED_TYPE = GLenum::GL_INTERNALFORMAT_RED_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_GREEN_TYPE = GLenum::GL_INTERNALFORMAT_GREEN_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_BLUE_TYPE = GLenum::GL_INTERNALFORMAT_BLUE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_ALPHA_TYPE = GLenum::GL_INTERNALFORMAT_ALPHA_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_DEPTH_TYPE = GLenum::GL_INTERNALFORMAT_DEPTH_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_STENCIL_TYPE = GLenum::GL_INTERNALFORMAT_STENCIL_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_WIDTH = GLenum::GL_MAX_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_HEIGHT = GLenum::GL_MAX_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEPTH = GLenum::GL_MAX_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LAYERS = GLenum::GL_MAX_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_COMPONENTS = GLenum::GL_COLOR_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_RENDERABLE = GLenum::GL_COLOR_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_RENDERABLE = GLenum::GL_DEPTH_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_RENDERABLE = GLenum::GL_STENCIL_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_RENDERABLE = GLenum::GL_FRAMEBUFFER_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_RENDERABLE_LAYERED = GLenum::GL_FRAMEBUFFER_RENDERABLE_LAYERED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_BLEND = GLenum::GL_FRAMEBUFFER_BLEND;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXELS = GLenum::GL_READ_PIXELS;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXELS_FORMAT = GLenum::GL_READ_PIXELS_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXELS_TYPE = GLenum::GL_READ_PIXELS_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_IMAGE_FORMAT = GLenum::GL_TEXTURE_IMAGE_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_IMAGE_TYPE = GLenum::GL_TEXTURE_IMAGE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_GET_TEXTURE_IMAGE_FORMAT = GLenum::GL_GET_TEXTURE_IMAGE_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_GET_TEXTURE_IMAGE_TYPE = GLenum::GL_GET_TEXTURE_IMAGE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_MIPMAP = GLenum::GL_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_AUTO_GENERATE_MIPMAP = GLenum::GL_AUTO_GENERATE_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ENCODING = GLenum::GL_COLOR_ENCODING;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_READ = GLenum::GL_SRGB_READ;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_WRITE = GLenum::GL_SRGB_WRITE;
GLBINDING_CONSTEXPR static const GLenum GL_FILTER = GLenum::GL_FILTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_TEXTURE = GLenum::GL_VERTEX_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_TEXTURE = GLenum::GL_TESS_CONTROL_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_TEXTURE = GLenum::GL_TESS_EVALUATION_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_TEXTURE = GLenum::GL_GEOMETRY_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_TEXTURE = GLenum::GL_FRAGMENT_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_TEXTURE = GLenum::GL_COMPUTE_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SHADOW = GLenum::GL_TEXTURE_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GATHER = GLenum::GL_TEXTURE_GATHER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GATHER_SHADOW = GLenum::GL_TEXTURE_GATHER_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_IMAGE_LOAD = GLenum::GL_SHADER_IMAGE_LOAD;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_IMAGE_STORE = GLenum::GL_SHADER_IMAGE_STORE;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_IMAGE_ATOMIC = GLenum::GL_SHADER_IMAGE_ATOMIC;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TEXEL_SIZE = GLenum::GL_IMAGE_TEXEL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_COMPATIBILITY_CLASS = GLenum::GL_IMAGE_COMPATIBILITY_CLASS;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_PIXEL_FORMAT = GLenum::GL_IMAGE_PIXEL_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_PIXEL_TYPE = GLenum::GL_IMAGE_PIXEL_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = GLenum::GL_TEXTURE_COMPRESSED_BLOCK_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = GLenum::GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_BLOCK_SIZE = GLenum::GL_TEXTURE_COMPRESSED_BLOCK_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_CLEAR_BUFFER = GLenum::GL_CLEAR_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW = GLenum::GL_TEXTURE_VIEW;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_COMPATIBILITY_CLASS = GLenum::GL_VIEW_COMPATIBILITY_CLASS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED = GLenum::GL_TEXTURE_COMPRESSED;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = GLenum::GL_IMAGE_FORMAT_COMPATIBILITY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_CLEAR_TEXTURE = GLenum::GL_CLEAR_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_SAMPLE_COUNTS = GLenum::GL_NUM_SAMPLE_COUNTS;

// LightEnvModeSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_ADD = GLenum::GL_ADD; // reuse AccumOp
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE = GLenum::GL_REPLACE;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE = GLenum::GL_MODULATE;

// LightEnvParameterSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_ENV_MODE_SGIX = GLenum::GL_LIGHT_ENV_MODE_SGIX; // reuse GetPName

// LightModelColorControl

GLBINDING_CONSTEXPR static const GLenum GL_SINGLE_COLOR = GLenum::GL_SINGLE_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SINGLE_COLOR_EXT = GLenum::GL_SINGLE_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_SPECULAR_COLOR = GLenum::GL_SEPARATE_SPECULAR_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_SPECULAR_COLOR_EXT = GLenum::GL_SEPARATE_SPECULAR_COLOR_EXT;

// LightModelParameter

// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_LOCAL_VIEWER = GLenum::GL_LIGHT_MODEL_LOCAL_VIEWER; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_TWO_SIDE = GLenum::GL_LIGHT_MODEL_TWO_SIDE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_AMBIENT = GLenum::GL_LIGHT_MODEL_AMBIENT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_COLOR_CONTROL = GLenum::GL_LIGHT_MODEL_COLOR_CONTROL; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_COLOR_CONTROL_EXT = GLenum::GL_LIGHT_MODEL_COLOR_CONTROL_EXT;

// LightName

// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT0 = GLenum::GL_LIGHT0; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT1 = GLenum::GL_LIGHT1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT2 = GLenum::GL_LIGHT2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT3 = GLenum::GL_LIGHT3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT4 = GLenum::GL_LIGHT4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT5 = GLenum::GL_LIGHT5; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT6 = GLenum::GL_LIGHT6; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT7 = GLenum::GL_LIGHT7; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT1_SGIX = GLenum::GL_FRAGMENT_LIGHT1_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT2_SGIX = GLenum::GL_FRAGMENT_LIGHT2_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT3_SGIX = GLenum::GL_FRAGMENT_LIGHT3_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT4_SGIX = GLenum::GL_FRAGMENT_LIGHT4_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT5_SGIX = GLenum::GL_FRAGMENT_LIGHT5_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT6_SGIX = GLenum::GL_FRAGMENT_LIGHT6_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT7_SGIX = GLenum::GL_FRAGMENT_LIGHT7_SGIX; // reuse EnableCap

// LightParameter

// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR; // reuse ColorMaterialParameter
GLBINDING_CONSTEXPR static const GLenum GL_POSITION = GLenum::GL_POSITION;
GLBINDING_CONSTEXPR static const GLenum GL_SPOT_DIRECTION = GLenum::GL_SPOT_DIRECTION;
GLBINDING_CONSTEXPR static const GLenum GL_SPOT_EXPONENT = GLenum::GL_SPOT_EXPONENT;
GLBINDING_CONSTEXPR static const GLenum GL_SPOT_CUTOFF = GLenum::GL_SPOT_CUTOFF;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ATTENUATION = GLenum::GL_CONSTANT_ATTENUATION;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_ATTENUATION = GLenum::GL_LINEAR_ATTENUATION;
GLBINDING_CONSTEXPR static const GLenum GL_QUADRATIC_ATTENUATION = GLenum::GL_QUADRATIC_ATTENUATION;

// ListMode

GLBINDING_CONSTEXPR static const GLenum GL_COMPILE = GLenum::GL_COMPILE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPILE_AND_EXECUTE = GLenum::GL_COMPILE_AND_EXECUTE;

// ListNameType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
GLBINDING_CONSTEXPR static const GLenum GL_2_BYTES = GLenum::GL_2_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_3_BYTES = GLenum::GL_3_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_4_BYTES = GLenum::GL_4_BYTES;

// ListParameterName

GLBINDING_CONSTEXPR static const GLenum GL_LIST_PRIORITY_SGIX = GLenum::GL_LIST_PRIORITY_SGIX;

// LogicOp

GLBINDING_CONSTEXPR static const GLenum GL_CLEAR = GLenum::GL_CLEAR;
GLBINDING_CONSTEXPR static const GLenum GL_AND = GLenum::GL_AND;
GLBINDING_CONSTEXPR static const GLenum GL_AND_REVERSE = GLenum::GL_AND_REVERSE;
GLBINDING_CONSTEXPR static const GLenum GL_COPY = GLenum::GL_COPY;
GLBINDING_CONSTEXPR static const GLenum GL_AND_INVERTED = GLenum::GL_AND_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_NOOP = GLenum::GL_NOOP;
GLBINDING_CONSTEXPR static const GLenum GL_XOR = GLenum::GL_XOR;
GLBINDING_CONSTEXPR static const GLenum GL_OR = GLenum::GL_OR;
GLBINDING_CONSTEXPR static const GLenum GL_NOR = GLenum::GL_NOR;
GLBINDING_CONSTEXPR static const GLenum GL_EQUIV = GLenum::GL_EQUIV;
GLBINDING_CONSTEXPR static const GLenum GL_INVERT = GLenum::GL_INVERT;
GLBINDING_CONSTEXPR static const GLenum GL_OR_REVERSE = GLenum::GL_OR_REVERSE;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_INVERTED = GLenum::GL_COPY_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_OR_INVERTED = GLenum::GL_OR_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_NAND = GLenum::GL_NAND;
GLBINDING_CONSTEXPR static const GLenum GL_SET = GLenum::GL_SET;

// MapQuery

// GLBINDING_CONSTEXPR static const GLenum GL_COEFF = GLenum::GL_COEFF; // reuse GetMapQuery
// GLBINDING_CONSTEXPR static const GLenum GL_ORDER = GLenum::GL_ORDER; // reuse GetMapQuery
// GLBINDING_CONSTEXPR static const GLenum GL_DOMAIN = GLenum::GL_DOMAIN; // reuse GetMapQuery

// MapTarget

// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_COLOR_4 = GLenum::GL_MAP1_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_INDEX = GLenum::GL_MAP1_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_NORMAL = GLenum::GL_MAP1_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_1 = GLenum::GL_MAP1_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_2 = GLenum::GL_MAP1_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_3 = GLenum::GL_MAP1_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_4 = GLenum::GL_MAP1_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_3 = GLenum::GL_MAP1_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_4 = GLenum::GL_MAP1_VERTEX_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_COLOR_4 = GLenum::GL_MAP2_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_INDEX = GLenum::GL_MAP2_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_NORMAL = GLenum::GL_MAP2_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_1 = GLenum::GL_MAP2_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_2 = GLenum::GL_MAP2_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_3 = GLenum::GL_MAP2_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_4 = GLenum::GL_MAP2_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_3 = GLenum::GL_MAP2_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_4 = GLenum::GL_MAP2_VERTEX_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_DEFORMATION_SGIX = GLenum::GL_GEOMETRY_DEFORMATION_SGIX; // reuse FfdTargetSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEFORMATION_SGIX = GLenum::GL_TEXTURE_DEFORMATION_SGIX; // reuse FfdTargetSGIX

// MapTextureFormatINTEL

GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEFAULT_INTEL = GLenum::GL_LAYOUT_DEFAULT_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_LINEAR_INTEL = GLenum::GL_LAYOUT_LINEAR_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = GLenum::GL_LAYOUT_LINEAR_CPU_CACHED_INTEL;

// MaterialFace

// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer

// MaterialParameter

// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_EMISSION = GLenum::GL_EMISSION; // reuse ColorMaterialParameter
GLBINDING_CONSTEXPR static const GLenum GL_SHININESS = GLenum::GL_SHININESS;
// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT_AND_DIFFUSE = GLenum::GL_AMBIENT_AND_DIFFUSE; // reuse ColorMaterialParameter
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEXES = GLenum::GL_COLOR_INDEXES;

// MatrixMode

GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW = GLenum::GL_MODELVIEW;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_EXT = GLenum::GL_MODELVIEW0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROJECTION = GLenum::GL_PROJECTION;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE = GLenum::GL_TEXTURE;

// MemoryObjectParameterName

GLBINDING_CONSTEXPR static const GLenum GL_DEDICATED_MEMORY_OBJECT_EXT = GLenum::GL_DEDICATED_MEMORY_OBJECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROTECTED_MEMORY_OBJECT_EXT = GLenum::GL_PROTECTED_MEMORY_OBJECT_EXT;

// MeshMode1

GLBINDING_CONSTEXPR static const GLenum GL_POINT = GLenum::GL_POINT;
GLBINDING_CONSTEXPR static const GLenum GL_LINE = GLenum::GL_LINE;

// MeshMode2

// GLBINDING_CONSTEXPR static const GLenum GL_POINT = GLenum::GL_POINT; // reuse MeshMode1
// GLBINDING_CONSTEXPR static const GLenum GL_LINE = GLenum::GL_LINE; // reuse MeshMode1
GLBINDING_CONSTEXPR static const GLenum GL_FILL = GLenum::GL_FILL;

// MinmaxTargetEXT

GLBINDING_CONSTEXPR static const GLenum GL_MINMAX = GLenum::GL_MINMAX;
// GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_EXT = GLenum::GL_MINMAX_EXT; // reuse EnableCap

// NormalPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// ObjectIdentifier

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE = GLenum::GL_TEXTURE; // reuse MatrixMode
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY = GLenum::GL_VERTEX_ARRAY; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER = GLenum::GL_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER = GLenum::GL_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM = GLenum::GL_PROGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY = GLenum::GL_QUERY;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE = GLenum::GL_PROGRAM_PIPELINE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER = GLenum::GL_SAMPLER;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER = GLenum::GL_FRAMEBUFFER; // reuse CheckFramebufferStatusTarget
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER = GLenum::GL_RENDERBUFFER;
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK = GLenum::GL_TRANSFORM_FEEDBACK; // reuse BindTransformFeedbackTarget

// PatchParameterName

GLBINDING_CONSTEXPR static const GLenum GL_PATCH_VERTICES = GLenum::GL_PATCH_VERTICES;
GLBINDING_CONSTEXPR static const GLenum GL_PATCH_DEFAULT_INNER_LEVEL = GLenum::GL_PATCH_DEFAULT_INNER_LEVEL;
GLBINDING_CONSTEXPR static const GLenum GL_PATCH_DEFAULT_OUTER_LEVEL = GLenum::GL_PATCH_DEFAULT_OUTER_LEVEL;

// PathColor

GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_NV = GLenum::GL_PRIMARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_NV = GLenum::GL_SECONDARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR = GLenum::GL_PRIMARY_COLOR;

// PathCoverMode

GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_COVER_MODE_NV = GLenum::GL_PATH_FILL_COVER_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONVEX_HULL_NV = GLenum::GL_CONVEX_HULL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BOUNDING_BOX_NV = GLenum::GL_BOUNDING_BOX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = GLenum::GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV;

// PathElementType

GLBINDING_CONSTEXPR static const GLenum GL_UTF8_NV = GLenum::GL_UTF8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UTF16_NV = GLenum::GL_UTF16_NV;

// PathFillMode

// GLBINDING_CONSTEXPR static const GLenum GL_INVERT = GLenum::GL_INVERT; // reuse LogicOp
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_MODE_NV = GLenum::GL_PATH_FILL_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COUNT_UP_NV = GLenum::GL_COUNT_UP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COUNT_DOWN_NV = GLenum::GL_COUNT_DOWN_NV;

// PathFontStyle

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer

// PathFontTarget

GLBINDING_CONSTEXPR static const GLenum GL_STANDARD_FONT_NAME_NV = GLenum::GL_STANDARD_FONT_NAME_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SYSTEM_FONT_NAME_NV = GLenum::GL_SYSTEM_FONT_NAME_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FILE_NAME_NV = GLenum::GL_FILE_NAME_NV;

// PathGenMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINEAR = GLenum::GL_EYE_LINEAR;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINEAR = GLenum::GL_OBJECT_LINEAR;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT = GLenum::GL_CONSTANT;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_OBJECT_BOUNDING_BOX_NV = GLenum::GL_PATH_OBJECT_BOUNDING_BOX_NV;

// PathHandleMissingGlyphs

GLBINDING_CONSTEXPR static const GLenum GL_SKIP_MISSING_GLYPH_NV = GLenum::GL_SKIP_MISSING_GLYPH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_USE_MISSING_GLYPH_NV = GLenum::GL_USE_MISSING_GLYPH_NV;

// PathListMode

GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_ADJACENT_PAIRS_NV = GLenum::GL_ACCUM_ADJACENT_PAIRS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ADJACENT_PAIRS_NV = GLenum::GL_ADJACENT_PAIRS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FIRST_TO_REST_NV = GLenum::GL_FIRST_TO_REST_NV;

// PathParameter

GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_WIDTH_NV = GLenum::GL_PATH_STROKE_WIDTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_END_CAPS_NV = GLenum::GL_PATH_END_CAPS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_INITIAL_END_CAP_NV = GLenum::GL_PATH_INITIAL_END_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TERMINAL_END_CAP_NV = GLenum::GL_PATH_TERMINAL_END_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_JOIN_STYLE_NV = GLenum::GL_PATH_JOIN_STYLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MITER_LIMIT_NV = GLenum::GL_PATH_MITER_LIMIT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_CAPS_NV = GLenum::GL_PATH_DASH_CAPS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_INITIAL_DASH_CAP_NV = GLenum::GL_PATH_INITIAL_DASH_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TERMINAL_DASH_CAP_NV = GLenum::GL_PATH_TERMINAL_DASH_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_OFFSET_NV = GLenum::GL_PATH_DASH_OFFSET_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_CLIENT_LENGTH_NV = GLenum::GL_PATH_CLIENT_LENGTH_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_MODE_NV = GLenum::GL_PATH_FILL_MODE_NV; // reuse PathFillMode
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_MASK_NV = GLenum::GL_PATH_FILL_MASK_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_COVER_MODE_NV = GLenum::GL_PATH_FILL_COVER_MODE_NV; // reuse PathCoverMode
GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_COVER_MODE_NV = GLenum::GL_PATH_STROKE_COVER_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_MASK_NV = GLenum::GL_PATH_STROKE_MASK_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PATH_OBJECT_BOUNDING_BOX_NV = GLenum::GL_PATH_OBJECT_BOUNDING_BOX_NV; // reuse PathGenMode
GLBINDING_CONSTEXPR static const GLenum GL_PATH_COMMAND_COUNT_NV = GLenum::GL_PATH_COMMAND_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_COORD_COUNT_NV = GLenum::GL_PATH_COORD_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_ARRAY_COUNT_NV = GLenum::GL_PATH_DASH_ARRAY_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_COMPUTED_LENGTH_NV = GLenum::GL_PATH_COMPUTED_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_BOUNDING_BOX_NV = GLenum::GL_PATH_FILL_BOUNDING_BOX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_BOUNDING_BOX_NV = GLenum::GL_PATH_STROKE_BOUNDING_BOX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_OFFSET_RESET_NV = GLenum::GL_PATH_DASH_OFFSET_RESET_NV;

// PathStringFormat

GLBINDING_CONSTEXPR static const GLenum GL_PATH_FORMAT_SVG_NV = GLenum::GL_PATH_FORMAT_SVG_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FORMAT_PS_NV = GLenum::GL_PATH_FORMAT_PS_NV;

// PathTransformType

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_X_NV = GLenum::GL_TRANSLATE_X_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_Y_NV = GLenum::GL_TRANSLATE_Y_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_2D_NV = GLenum::GL_TRANSLATE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_3D_NV = GLenum::GL_TRANSLATE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_AFFINE_2D_NV = GLenum::GL_AFFINE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_AFFINE_3D_NV = GLenum::GL_AFFINE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_AFFINE_2D_NV = GLenum::GL_TRANSPOSE_AFFINE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_AFFINE_3D_NV = GLenum::GL_TRANSPOSE_AFFINE_3D_NV;

// PipelineParameterName

GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_PROGRAM = GLenum::GL_ACTIVE_PROGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER = GLenum::GL_FRAGMENT_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER = GLenum::GL_VERTEX_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_INFO_LOG_LENGTH = GLenum::GL_INFO_LOG_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER = GLenum::GL_GEOMETRY_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER = GLenum::GL_TESS_EVALUATION_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER = GLenum::GL_TESS_CONTROL_SHADER;

// PixelCopyType

// GLBINDING_CONSTEXPR static const GLenum GL_COLOR = GLenum::GL_COLOR; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH = GLenum::GL_DEPTH; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL = GLenum::GL_STENCIL; // reuse Buffer

// PixelFormat

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse ColorPointerType
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX = GLenum::GL_COLOR_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX = GLenum::GL_STENCIL_INDEX;
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT = GLenum::GL_DEPTH_COMPONENT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RED = GLenum::GL_RED; // reuse InternalFormat
GLBINDING_CONSTEXPR static const GLenum GL_GREEN = GLenum::GL_GREEN;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE = GLenum::GL_BLUE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA;
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA; // reuse InternalFormat
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE = GLenum::GL_LUMINANCE;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA = GLenum::GL_LUMINANCE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ABGR_EXT = GLenum::GL_ABGR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CMYK_EXT = GLenum::GL_CMYK_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CMYKA_EXT = GLenum::GL_CMYKA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCB_422_SGIX = GLenum::GL_YCRCB_422_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCB_444_SGIX = GLenum::GL_YCRCB_444_SGIX;

// PixelMap

// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_I = GLenum::GL_PIXEL_MAP_I_TO_I; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_S_TO_S = GLenum::GL_PIXEL_MAP_S_TO_S; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_R = GLenum::GL_PIXEL_MAP_I_TO_R; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_G = GLenum::GL_PIXEL_MAP_I_TO_G; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_B = GLenum::GL_PIXEL_MAP_I_TO_B; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_A = GLenum::GL_PIXEL_MAP_I_TO_A; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_R_TO_R = GLenum::GL_PIXEL_MAP_R_TO_R; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_G_TO_G = GLenum::GL_PIXEL_MAP_G_TO_G; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_B_TO_B = GLenum::GL_PIXEL_MAP_B_TO_B; // reuse GetPixelMap
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_A_TO_A = GLenum::GL_PIXEL_MAP_A_TO_A; // reuse GetPixelMap

// PixelStoreParameter

// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SWAP_BYTES = GLenum::GL_UNPACK_SWAP_BYTES; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_LSB_FIRST = GLenum::GL_UNPACK_LSB_FIRST; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ROW_LENGTH = GLenum::GL_UNPACK_ROW_LENGTH; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_ROWS = GLenum::GL_UNPACK_SKIP_ROWS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_PIXELS = GLenum::GL_UNPACK_SKIP_PIXELS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ALIGNMENT = GLenum::GL_UNPACK_ALIGNMENT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SWAP_BYTES = GLenum::GL_PACK_SWAP_BYTES; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_LSB_FIRST = GLenum::GL_PACK_LSB_FIRST; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_ROW_LENGTH = GLenum::GL_PACK_ROW_LENGTH; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_ROWS = GLenum::GL_PACK_SKIP_ROWS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_PIXELS = GLenum::GL_PACK_SKIP_PIXELS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_ALIGNMENT = GLenum::GL_PACK_ALIGNMENT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES = GLenum::GL_PACK_SKIP_IMAGES;
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES_EXT = GLenum::GL_PACK_SKIP_IMAGES_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT = GLenum::GL_PACK_IMAGE_HEIGHT;
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT_EXT = GLenum::GL_PACK_IMAGE_HEIGHT_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES = GLenum::GL_UNPACK_SKIP_IMAGES;
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES_EXT = GLenum::GL_UNPACK_SKIP_IMAGES_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT = GLenum::GL_UNPACK_IMAGE_HEIGHT;
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT_EXT = GLenum::GL_UNPACK_IMAGE_HEIGHT_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_VOLUMES_SGIS = GLenum::GL_PACK_SKIP_VOLUMES_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_DEPTH_SGIS = GLenum::GL_PACK_IMAGE_DEPTH_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_VOLUMES_SGIS = GLenum::GL_UNPACK_SKIP_VOLUMES_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_DEPTH_SGIS = GLenum::GL_UNPACK_IMAGE_DEPTH_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_WIDTH_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_HEIGHT_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_WIDTH_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_GRID_HEIGHT_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_DEPTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_DEPTH_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_CACHE_SIZE_SGIX = GLenum::GL_PIXEL_TILE_CACHE_SIZE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_RESAMPLE_SGIX = GLenum::GL_PACK_RESAMPLE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_RESAMPLE_SGIX = GLenum::GL_UNPACK_RESAMPLE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_PACK_SUBSAMPLE_RATE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_UNPACK_SUBSAMPLE_RATE_SGIX; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PACK_RESAMPLE_OML = GLenum::GL_PACK_RESAMPLE_OML;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_RESAMPLE_OML = GLenum::GL_UNPACK_RESAMPLE_OML;

// PixelStoreResampleMode

GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_DECIMATE_SGIX = GLenum::GL_RESAMPLE_DECIMATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_REPLICATE_SGIX = GLenum::GL_RESAMPLE_REPLICATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_ZERO_FILL_SGIX = GLenum::GL_RESAMPLE_ZERO_FILL_SGIX;

// PixelStoreSubsampleRate

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_SUBSAMPLE_4444_SGIX = GLenum::GL_PIXEL_SUBSAMPLE_4444_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_SUBSAMPLE_2424_SGIX = GLenum::GL_PIXEL_SUBSAMPLE_2424_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_SUBSAMPLE_4242_SGIX = GLenum::GL_PIXEL_SUBSAMPLE_4242_SGIX;

// PixelTexGenMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE = GLenum::GL_LUMINANCE; // reuse PixelFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA = GLenum::GL_LUMINANCE_ALPHA; // reuse PixelFormat

// PixelTexGenParameterNameSGIS

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = GLenum::GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = GLenum::GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS;

// PixelTransferParameter

// GLBINDING_CONSTEXPR static const GLenum GL_MAP_COLOR = GLenum::GL_MAP_COLOR; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_MAP_STENCIL = GLenum::GL_MAP_STENCIL; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_SHIFT = GLenum::GL_INDEX_SHIFT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_OFFSET = GLenum::GL_INDEX_OFFSET; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_RED_SCALE = GLenum::GL_RED_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_RED_BIAS = GLenum::GL_RED_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_GREEN_SCALE = GLenum::GL_GREEN_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_GREEN_BIAS = GLenum::GL_GREEN_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE_SCALE = GLenum::GL_BLUE_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE_BIAS = GLenum::GL_BLUE_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_SCALE = GLenum::GL_ALPHA_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_BIAS = GLenum::GL_ALPHA_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_SCALE = GLenum::GL_DEPTH_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BIAS = GLenum::GL_DEPTH_BIAS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_SCALE = GLenum::GL_POST_CONVOLUTION_RED_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_RED_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_SCALE = GLenum::GL_POST_CONVOLUTION_GREEN_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_SCALE = GLenum::GL_POST_CONVOLUTION_BLUE_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_SCALE = GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_BIAS = GLenum::GL_POST_CONVOLUTION_RED_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_RED_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_BIAS = GLenum::GL_POST_CONVOLUTION_GREEN_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_BIAS = GLenum::GL_POST_CONVOLUTION_BLUE_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_BIAS = GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_SCALE = GLenum::GL_POST_COLOR_MATRIX_RED_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_SCALE = GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_SCALE = GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_SCALE = GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_BIAS = GLenum::GL_POST_COLOR_MATRIX_RED_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_BIAS_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_BIAS = GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_BIAS = GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_BIAS = GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI; // reuse GetPName

// PixelType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
GLBINDING_CONSTEXPR static const GLenum GL_BITMAP = GLenum::GL_BITMAP;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE_3_3_2 = GLenum::GL_UNSIGNED_BYTE_3_3_2;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE_3_3_2_EXT = GLenum::GL_UNSIGNED_BYTE_3_3_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_4_4_4_4 = GLenum::GL_UNSIGNED_SHORT_4_4_4_4;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_4_4_4_4_EXT = GLenum::GL_UNSIGNED_SHORT_4_4_4_4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_5_5_1 = GLenum::GL_UNSIGNED_SHORT_5_5_5_1;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_5_5_1_EXT = GLenum::GL_UNSIGNED_SHORT_5_5_5_1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_8_8 = GLenum::GL_UNSIGNED_INT_8_8_8_8;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_8_8_EXT = GLenum::GL_UNSIGNED_INT_8_8_8_8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10_10_10_2 = GLenum::GL_UNSIGNED_INT_10_10_10_2;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10_10_10_2_EXT = GLenum::GL_UNSIGNED_INT_10_10_10_2_EXT;

// PointParameterNameSGIS

GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN = GLenum::GL_POINT_SIZE_MIN;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_ARB = GLenum::GL_POINT_SIZE_MIN_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_EXT = GLenum::GL_POINT_SIZE_MIN_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_SGIS = GLenum::GL_POINT_SIZE_MIN_SGIS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX = GLenum::GL_POINT_SIZE_MAX;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_ARB = GLenum::GL_POINT_SIZE_MAX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_EXT = GLenum::GL_POINT_SIZE_MAX_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_SGIS = GLenum::GL_POINT_SIZE_MAX_SGIS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE = GLenum::GL_POINT_FADE_THRESHOLD_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_ARB = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_EXT = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_SGIS = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_SGIS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_EXT = GLenum::GL_DISTANCE_ATTENUATION_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_SGIS = GLenum::GL_DISTANCE_ATTENUATION_SGIS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POINT_DISTANCE_ATTENUATION = GLenum::GL_POINT_DISTANCE_ATTENUATION;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_DISTANCE_ATTENUATION_ARB = GLenum::GL_POINT_DISTANCE_ATTENUATION_ARB;

// PolygonMode

// GLBINDING_CONSTEXPR static const GLenum GL_POINT = GLenum::GL_POINT; // reuse MeshMode1
// GLBINDING_CONSTEXPR static const GLenum GL_LINE = GLenum::GL_LINE; // reuse MeshMode1
// GLBINDING_CONSTEXPR static const GLenum GL_FILL = GLenum::GL_FILL; // reuse MeshMode2

// PrecisionType

GLBINDING_CONSTEXPR static const GLenum GL_LOW_FLOAT = GLenum::GL_LOW_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_MEDIUM_FLOAT = GLenum::GL_MEDIUM_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_HIGH_FLOAT = GLenum::GL_HIGH_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_LOW_INT = GLenum::GL_LOW_INT;
GLBINDING_CONSTEXPR static const GLenum GL_MEDIUM_INT = GLenum::GL_MEDIUM_INT;
GLBINDING_CONSTEXPR static const GLenum GL_HIGH_INT = GLenum::GL_HIGH_INT;

// PrimitiveType

GLBINDING_CONSTEXPR static const GLenum GL_POINTS = GLenum::GL_POINTS;
GLBINDING_CONSTEXPR static const GLenum GL_LINES = GLenum::GL_LINES;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_LOOP = GLenum::GL_LINE_LOOP;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP = GLenum::GL_LINE_STRIP;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES = GLenum::GL_TRIANGLES;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP = GLenum::GL_TRIANGLE_STRIP;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_FAN = GLenum::GL_TRIANGLE_FAN;
GLBINDING_CONSTEXPR static const GLenum GL_QUADS = GLenum::GL_QUADS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_STRIP = GLenum::GL_QUAD_STRIP;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON = GLenum::GL_POLYGON;
GLBINDING_CONSTEXPR static const GLenum GL_LINES_ADJACENCY = GLenum::GL_LINES_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_LINES_ADJACENCY_ARB = GLenum::GL_LINES_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LINES_ADJACENCY_EXT = GLenum::GL_LINES_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP_ADJACENCY = GLenum::GL_LINE_STRIP_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP_ADJACENCY_ARB = GLenum::GL_LINE_STRIP_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP_ADJACENCY_EXT = GLenum::GL_LINE_STRIP_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES_ADJACENCY = GLenum::GL_TRIANGLES_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES_ADJACENCY_ARB = GLenum::GL_TRIANGLES_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES_ADJACENCY_EXT = GLenum::GL_TRIANGLES_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP_ADJACENCY = GLenum::GL_TRIANGLE_STRIP_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP_ADJACENCY_ARB = GLenum::GL_TRIANGLE_STRIP_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP_ADJACENCY_EXT = GLenum::GL_TRIANGLE_STRIP_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PATCHES = GLenum::GL_PATCHES;

// ProgramInterface

// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER; // reuse BufferStorageTarget
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM = GLenum::GL_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK = GLenum::GL_UNIFORM_BLOCK;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_INPUT = GLenum::GL_PROGRAM_INPUT;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_OUTPUT = GLenum::GL_PROGRAM_OUTPUT;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_VARIABLE = GLenum::GL_BUFFER_VARIABLE;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BLOCK = GLenum::GL_SHADER_STORAGE_BLOCK;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SUBROUTINE = GLenum::GL_VERTEX_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SUBROUTINE = GLenum::GL_TESS_CONTROL_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SUBROUTINE = GLenum::GL_TESS_EVALUATION_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SUBROUTINE = GLenum::GL_GEOMETRY_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SUBROUTINE = GLenum::GL_FRAGMENT_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SUBROUTINE = GLenum::GL_COMPUTE_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SUBROUTINE_UNIFORM = GLenum::GL_VERTEX_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SUBROUTINE_UNIFORM = GLenum::GL_TESS_CONTROL_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = GLenum::GL_TESS_EVALUATION_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SUBROUTINE_UNIFORM = GLenum::GL_GEOMETRY_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SUBROUTINE_UNIFORM = GLenum::GL_FRAGMENT_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SUBROUTINE_UNIFORM = GLenum::GL_COMPUTE_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYING = GLenum::GL_TRANSFORM_FEEDBACK_VARYING;

// ProgramInterfacePName

GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_RESOURCES = GLenum::GL_ACTIVE_RESOURCES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NAME_LENGTH = GLenum::GL_MAX_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NUM_ACTIVE_VARIABLES = GLenum::GL_MAX_NUM_ACTIVE_VARIABLES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NUM_COMPATIBLE_SUBROUTINES = GLenum::GL_MAX_NUM_COMPATIBLE_SUBROUTINES;

// ProgramParameterPName

// GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_RETRIEVABLE_HINT = GLenum::GL_PROGRAM_BINARY_RETRIEVABLE_HINT; // reuse HintTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_SEPARABLE = GLenum::GL_PROGRAM_SEPARABLE;

// ProgramPropertyARB

GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_WORK_GROUP_SIZE = GLenum::GL_COMPUTE_WORK_GROUP_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_LENGTH = GLenum::GL_PROGRAM_BINARY_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_VERTICES_OUT = GLenum::GL_GEOMETRY_VERTICES_OUT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_INPUT_TYPE = GLenum::GL_GEOMETRY_INPUT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_OUTPUT_TYPE = GLenum::GL_GEOMETRY_OUTPUT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = GLenum::GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORM_BLOCKS = GLenum::GL_ACTIVE_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_DELETE_STATUS = GLenum::GL_DELETE_STATUS;
GLBINDING_CONSTEXPR static const GLenum GL_LINK_STATUS = GLenum::GL_LINK_STATUS;
GLBINDING_CONSTEXPR static const GLenum GL_VALIDATE_STATUS = GLenum::GL_VALIDATE_STATUS;
// GLBINDING_CONSTEXPR static const GLenum GL_INFO_LOG_LENGTH = GLenum::GL_INFO_LOG_LENGTH; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_ATTACHED_SHADERS = GLenum::GL_ATTACHED_SHADERS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORMS = GLenum::GL_ACTIVE_UNIFORMS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORM_MAX_LENGTH = GLenum::GL_ACTIVE_UNIFORM_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_ATTRIBUTES = GLenum::GL_ACTIVE_ATTRIBUTES;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = GLenum::GL_ACTIVE_ATTRIBUTE_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = GLenum::GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_MODE = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYINGS = GLenum::GL_TRANSFORM_FEEDBACK_VARYINGS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = GLenum::GL_ACTIVE_ATOMIC_COUNTER_BUFFERS;

// ProgramStagePName

GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINES = GLenum::GL_ACTIVE_SUBROUTINES;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_UNIFORMS = GLenum::GL_ACTIVE_SUBROUTINE_UNIFORMS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = GLenum::GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_MAX_LENGTH = GLenum::GL_ACTIVE_SUBROUTINE_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = GLenum::GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH;

// QueryObjectParameterName

GLBINDING_CONSTEXPR static const GLenum GL_QUERY_TARGET = GLenum::GL_QUERY_TARGET;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT = GLenum::GL_QUERY_RESULT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT_AVAILABLE = GLenum::GL_QUERY_RESULT_AVAILABLE;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT_NO_WAIT = GLenum::GL_QUERY_RESULT_NO_WAIT;

// QueryParameterName

GLBINDING_CONSTEXPR static const GLenum GL_QUERY_COUNTER_BITS = GLenum::GL_QUERY_COUNTER_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_QUERY = GLenum::GL_CURRENT_QUERY;

// QueryTarget

GLBINDING_CONSTEXPR static const GLenum GL_TIME_ELAPSED = GLenum::GL_TIME_ELAPSED;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_PASSED = GLenum::GL_SAMPLES_PASSED;
GLBINDING_CONSTEXPR static const GLenum GL_ANY_SAMPLES_PASSED = GLenum::GL_ANY_SAMPLES_PASSED;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_GENERATED = GLenum::GL_PRIMITIVES_GENERATED;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = GLenum::GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN;
GLBINDING_CONSTEXPR static const GLenum GL_ANY_SAMPLES_PASSED_CONSERVATIVE = GLenum::GL_ANY_SAMPLES_PASSED_CONSERVATIVE;

// ReadBufferMode

// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_LEFT = GLenum::GL_FRONT_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_RIGHT = GLenum::GL_FRONT_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_LEFT = GLenum::GL_BACK_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_RIGHT = GLenum::GL_BACK_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_LEFT = GLenum::GL_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_RIGHT = GLenum::GL_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_AUX0 = GLenum::GL_AUX0; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_AUX1 = GLenum::GL_AUX1; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_AUX2 = GLenum::GL_AUX2; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_AUX3 = GLenum::GL_AUX3; // reuse DrawBufferMode

// RenderbufferParameterName

GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_SAMPLES = GLenum::GL_RENDERBUFFER_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_WIDTH = GLenum::GL_RENDERBUFFER_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_HEIGHT = GLenum::GL_RENDERBUFFER_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_INTERNAL_FORMAT = GLenum::GL_RENDERBUFFER_INTERNAL_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_RED_SIZE = GLenum::GL_RENDERBUFFER_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_GREEN_SIZE = GLenum::GL_RENDERBUFFER_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BLUE_SIZE = GLenum::GL_RENDERBUFFER_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_ALPHA_SIZE = GLenum::GL_RENDERBUFFER_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_DEPTH_SIZE = GLenum::GL_RENDERBUFFER_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_STENCIL_SIZE = GLenum::GL_RENDERBUFFER_STENCIL_SIZE;

// RenderbufferTarget

// GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER = GLenum::GL_RENDERBUFFER; // reuse ObjectIdentifier

// RenderingMode

GLBINDING_CONSTEXPR static const GLenum GL_RENDER = GLenum::GL_RENDER;
GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK = GLenum::GL_FEEDBACK;
GLBINDING_CONSTEXPR static const GLenum GL_SELECT = GLenum::GL_SELECT;

// SamplePatternSGIS

GLBINDING_CONSTEXPR static const GLenum GL_1PASS_EXT = GLenum::GL_1PASS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_1PASS_SGIS = GLenum::GL_1PASS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_0_EXT = GLenum::GL_2PASS_0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_0_SGIS = GLenum::GL_2PASS_0_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_1_EXT = GLenum::GL_2PASS_1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_1_SGIS = GLenum::GL_2PASS_1_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_0_EXT = GLenum::GL_4PASS_0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_0_SGIS = GLenum::GL_4PASS_0_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_1_EXT = GLenum::GL_4PASS_1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_1_SGIS = GLenum::GL_4PASS_1_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_2_EXT = GLenum::GL_4PASS_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_2_SGIS = GLenum::GL_4PASS_2_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_3_EXT = GLenum::GL_4PASS_3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_3_SGIS = GLenum::GL_4PASS_3_SGIS;

// SamplerParameterName

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_COLOR = GLenum::GL_TEXTURE_BORDER_COLOR; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_FILTER = GLenum::GL_TEXTURE_MAG_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_FILTER = GLenum::GL_TEXTURE_MIN_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_S = GLenum::GL_TEXTURE_WRAP_S; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_T = GLenum::GL_TEXTURE_WRAP_T; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R = GLenum::GL_TEXTURE_WRAP_R;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD = GLenum::GL_TEXTURE_MIN_LOD;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD = GLenum::GL_TEXTURE_MAX_LOD;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_MODE = GLenum::GL_TEXTURE_COMPARE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FUNC = GLenum::GL_TEXTURE_COMPARE_FUNC;

// SemaphoreParameterName

GLBINDING_CONSTEXPR static const GLenum GL_D3D12_FENCE_VALUE_EXT = GLenum::GL_D3D12_FENCE_VALUE_EXT;

// SeparableTargetEXT

GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D = GLenum::GL_SEPARABLE_2D;
// GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D_EXT = GLenum::GL_SEPARABLE_2D_EXT; // reuse EnableCap

// ShaderParameterName

GLBINDING_CONSTEXPR static const GLenum GL_SHADER_TYPE = GLenum::GL_SHADER_TYPE;
// GLBINDING_CONSTEXPR static const GLenum GL_DELETE_STATUS = GLenum::GL_DELETE_STATUS; // reuse ProgramPropertyARB
GLBINDING_CONSTEXPR static const GLenum GL_COMPILE_STATUS = GLenum::GL_COMPILE_STATUS;
// GLBINDING_CONSTEXPR static const GLenum GL_INFO_LOG_LENGTH = GLenum::GL_INFO_LOG_LENGTH; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_SOURCE_LENGTH = GLenum::GL_SHADER_SOURCE_LENGTH;

// ShaderType

// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER = GLenum::GL_FRAGMENT_SHADER; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_ARB = GLenum::GL_FRAGMENT_SHADER_ARB;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER = GLenum::GL_VERTEX_SHADER; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_ARB = GLenum::GL_VERTEX_SHADER_ARB;
// GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER = GLenum::GL_GEOMETRY_SHADER; // reuse PipelineParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER = GLenum::GL_TESS_EVALUATION_SHADER; // reuse PipelineParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER = GLenum::GL_TESS_CONTROL_SHADER; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SHADER = GLenum::GL_COMPUTE_SHADER;

// ShadingModel

GLBINDING_CONSTEXPR static const GLenum GL_FLAT = GLenum::GL_FLAT;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH = GLenum::GL_SMOOTH;

// StencilFaceDirection

// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer

// StencilFunction

// GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS; // reuse AlphaFunction

// StencilOp

// GLBINDING_CONSTEXPR static const GLenum GL_ZERO = GLenum::GL_ZERO; // reuse BlendingFactor
// GLBINDING_CONSTEXPR static const GLenum GL_INVERT = GLenum::GL_INVERT; // reuse LogicOp
GLBINDING_CONSTEXPR static const GLenum GL_KEEP = GLenum::GL_KEEP;
// GLBINDING_CONSTEXPR static const GLenum GL_REPLACE = GLenum::GL_REPLACE; // reuse LightEnvModeSGIX
GLBINDING_CONSTEXPR static const GLenum GL_INCR = GLenum::GL_INCR;
GLBINDING_CONSTEXPR static const GLenum GL_DECR = GLenum::GL_DECR;

// StringName

GLBINDING_CONSTEXPR static const GLenum GL_VENDOR = GLenum::GL_VENDOR;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERER = GLenum::GL_RENDERER;
GLBINDING_CONSTEXPR static const GLenum GL_VERSION = GLenum::GL_VERSION;
GLBINDING_CONSTEXPR static const GLenum GL_EXTENSIONS = GLenum::GL_EXTENSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADING_LANGUAGE_VERSION = GLenum::GL_SHADING_LANGUAGE_VERSION;

// SubroutineParameterName

GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_SIZE = GLenum::GL_UNIFORM_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_NAME_LENGTH = GLenum::GL_UNIFORM_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPATIBLE_SUBROUTINES = GLenum::GL_NUM_COMPATIBLE_SUBROUTINES;
GLBINDING_CONSTEXPR static const GLenum GL_COMPATIBLE_SUBROUTINES = GLenum::GL_COMPATIBLE_SUBROUTINES;

// SyncCondition

GLBINDING_CONSTEXPR static const GLenum GL_SYNC_GPU_COMMANDS_COMPLETE = GLenum::GL_SYNC_GPU_COMMANDS_COMPLETE;

// SyncParameterName

GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_TYPE = GLenum::GL_OBJECT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_CONDITION = GLenum::GL_SYNC_CONDITION;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_STATUS = GLenum::GL_SYNC_STATUS;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_FLAGS = GLenum::GL_SYNC_FLAGS;

// SyncStatus

GLBINDING_CONSTEXPR static const GLenum GL_ALREADY_SIGNALED = GLenum::GL_ALREADY_SIGNALED;
GLBINDING_CONSTEXPR static const GLenum GL_TIMEOUT_EXPIRED = GLenum::GL_TIMEOUT_EXPIRED;
GLBINDING_CONSTEXPR static const GLenum GL_CONDITION_SATISFIED = GLenum::GL_CONDITION_SATISFIED;
GLBINDING_CONSTEXPR static const GLenum GL_WAIT_FAILED = GLenum::GL_WAIT_FAILED;

// TexCoordPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// TextureCoordName

GLBINDING_CONSTEXPR static const GLenum GL_S = GLenum::GL_S;
GLBINDING_CONSTEXPR static const GLenum GL_T = GLenum::GL_T;
GLBINDING_CONSTEXPR static const GLenum GL_R = GLenum::GL_R;
GLBINDING_CONSTEXPR static const GLenum GL_Q = GLenum::GL_Q;

// TextureEnvMode

// GLBINDING_CONSTEXPR static const GLenum GL_ADD = GLenum::GL_ADD; // reuse AccumOp
// GLBINDING_CONSTEXPR static const GLenum GL_BLEND = GLenum::GL_BLEND; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MODULATE = GLenum::GL_MODULATE; // reuse LightEnvModeSGIX
GLBINDING_CONSTEXPR static const GLenum GL_DECAL = GLenum::GL_DECAL;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_EXT = GLenum::GL_REPLACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV_BIAS_SGIX = GLenum::GL_TEXTURE_ENV_BIAS_SGIX;

// TextureEnvParameter

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV_MODE = GLenum::GL_TEXTURE_ENV_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV_COLOR = GLenum::GL_TEXTURE_ENV_COLOR;

// TextureEnvTarget

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV = GLenum::GL_TEXTURE_ENV;

// TextureFilterFuncSGIS

GLBINDING_CONSTEXPR static const GLenum GL_FILTER4_SGIS = GLenum::GL_FILTER4_SGIS;

// TextureGenMode

// GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINEAR = GLenum::GL_EYE_LINEAR; // reuse PathGenMode
// GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINEAR = GLenum::GL_OBJECT_LINEAR; // reuse PathGenMode
GLBINDING_CONSTEXPR static const GLenum GL_SPHERE_MAP = GLenum::GL_SPHERE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_DISTANCE_TO_POINT_SGIS = GLenum::GL_EYE_DISTANCE_TO_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_DISTANCE_TO_POINT_SGIS = GLenum::GL_OBJECT_DISTANCE_TO_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_DISTANCE_TO_LINE_SGIS = GLenum::GL_EYE_DISTANCE_TO_LINE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_DISTANCE_TO_LINE_SGIS = GLenum::GL_OBJECT_DISTANCE_TO_LINE_SGIS;

// TextureGenParameter

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_MODE = GLenum::GL_TEXTURE_GEN_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_PLANE = GLenum::GL_OBJECT_PLANE;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_PLANE = GLenum::GL_EYE_PLANE;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_POINT_SGIS = GLenum::GL_EYE_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_POINT_SGIS = GLenum::GL_OBJECT_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINE_SGIS = GLenum::GL_EYE_LINE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINE_SGIS = GLenum::GL_OBJECT_LINE_SGIS;

// TextureLayout

GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT = GLenum::GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT = GLenum::GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_GENERAL_EXT = GLenum::GL_LAYOUT_GENERAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_COLOR_ATTACHMENT_EXT = GLenum::GL_LAYOUT_COLOR_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT = GLenum::GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT = GLenum::GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_SHADER_READ_ONLY_EXT = GLenum::GL_LAYOUT_SHADER_READ_ONLY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_TRANSFER_SRC_EXT = GLenum::GL_LAYOUT_TRANSFER_SRC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_TRANSFER_DST_EXT = GLenum::GL_LAYOUT_TRANSFER_DST_EXT;

// TextureMagFilter

// GLBINDING_CONSTEXPR static const GLenum GL_NEAREST = GLenum::GL_NEAREST; // reuse BlitFramebufferFilter
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR; // reuse BlitFramebufferFilter
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_DETAIL_SGIS = GLenum::GL_LINEAR_DETAIL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_DETAIL_ALPHA_SGIS = GLenum::GL_LINEAR_DETAIL_ALPHA_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_DETAIL_COLOR_SGIS = GLenum::GL_LINEAR_DETAIL_COLOR_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_SHARPEN_SGIS = GLenum::GL_LINEAR_SHARPEN_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_SHARPEN_ALPHA_SGIS = GLenum::GL_LINEAR_SHARPEN_ALPHA_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_SHARPEN_COLOR_SGIS = GLenum::GL_LINEAR_SHARPEN_COLOR_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_FILTER4_SGIS = GLenum::GL_FILTER4_SGIS; // reuse TextureFilterFuncSGIS

// TextureMinFilter

// GLBINDING_CONSTEXPR static const GLenum GL_NEAREST = GLenum::GL_NEAREST; // reuse BlitFramebufferFilter
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR; // reuse BlitFramebufferFilter
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_MIPMAP_NEAREST = GLenum::GL_NEAREST_MIPMAP_NEAREST;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_MIPMAP_NEAREST = GLenum::GL_LINEAR_MIPMAP_NEAREST;
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_MIPMAP_LINEAR = GLenum::GL_NEAREST_MIPMAP_LINEAR;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_MIPMAP_LINEAR = GLenum::GL_LINEAR_MIPMAP_LINEAR;
// GLBINDING_CONSTEXPR static const GLenum GL_FILTER4_SGIS = GLenum::GL_FILTER4_SGIS; // reuse TextureFilterFuncSGIS
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_CLIPMAP_LINEAR_SGIX = GLenum::GL_LINEAR_CLIPMAP_LINEAR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_CLIPMAP_NEAREST_SGIX = GLenum::GL_NEAREST_CLIPMAP_NEAREST_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_CLIPMAP_LINEAR_SGIX = GLenum::GL_NEAREST_CLIPMAP_LINEAR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_CLIPMAP_NEAREST_SGIX = GLenum::GL_LINEAR_CLIPMAP_NEAREST_SGIX;

// TextureParameterName

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WIDTH = GLenum::GL_TEXTURE_WIDTH; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_HEIGHT = GLenum::GL_TEXTURE_HEIGHT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPONENTS = GLenum::GL_TEXTURE_COMPONENTS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTERNAL_FORMAT = GLenum::GL_TEXTURE_INTERNAL_FORMAT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_COLOR = GLenum::GL_TEXTURE_BORDER_COLOR; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER = GLenum::GL_TEXTURE_BORDER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_FILTER = GLenum::GL_TEXTURE_MAG_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_FILTER = GLenum::GL_TEXTURE_MIN_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_S = GLenum::GL_TEXTURE_WRAP_S; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_T = GLenum::GL_TEXTURE_WRAP_T; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_SIZE = GLenum::GL_TEXTURE_RED_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_SIZE = GLenum::GL_TEXTURE_GREEN_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_SIZE = GLenum::GL_TEXTURE_BLUE_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_SIZE = GLenum::GL_TEXTURE_ALPHA_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_SIZE = GLenum::GL_TEXTURE_LUMINANCE_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_SIZE = GLenum::GL_TEXTURE_INTENSITY_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRIORITY = GLenum::GL_TEXTURE_PRIORITY; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRIORITY_EXT = GLenum::GL_TEXTURE_PRIORITY_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RESIDENT = GLenum::GL_TEXTURE_RESIDENT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_EXT = GLenum::GL_TEXTURE_DEPTH_EXT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R = GLenum::GL_TEXTURE_WRAP_R; // reuse SamplerParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R_EXT = GLenum::GL_TEXTURE_WRAP_R_EXT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_LEVEL_SGIS = GLenum::GL_DETAIL_TEXTURE_LEVEL_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_MODE_SGIS = GLenum::GL_DETAIL_TEXTURE_MODE_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SHADOW_AMBIENT_SGIX = GLenum::GL_SHADOW_AMBIENT_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DUAL_TEXTURE_SELECT_SGIS = GLenum::GL_DUAL_TEXTURE_SELECT_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_QUAD_TEXTURE_SELECT_SGIS = GLenum::GL_QUAD_TEXTURE_SELECT_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4DSIZE_SGIS = GLenum::GL_TEXTURE_4DSIZE_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_Q_SGIS = GLenum::GL_TEXTURE_WRAP_Q_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD = GLenum::GL_TEXTURE_MIN_LOD; // reuse SamplerParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD_SGIS = GLenum::GL_TEXTURE_MIN_LOD_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD = GLenum::GL_TEXTURE_MAX_LOD; // reuse SamplerParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD_SGIS = GLenum::GL_TEXTURE_MAX_LOD_SGIS; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BASE_LEVEL = GLenum::GL_TEXTURE_BASE_LEVEL;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BASE_LEVEL_SGIS = GLenum::GL_TEXTURE_BASE_LEVEL_SGIS; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LEVEL = GLenum::GL_TEXTURE_MAX_LEVEL;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LEVEL_SGIS = GLenum::GL_TEXTURE_MAX_LEVEL_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER4_SIZE_SGIS = GLenum::GL_TEXTURE_FILTER4_SIZE_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_CENTER_SGIX = GLenum::GL_TEXTURE_CLIPMAP_CENTER_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_FRAME_SGIX = GLenum::GL_TEXTURE_CLIPMAP_FRAME_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_OFFSET_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_DEPTH_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_BIAS_SGIX = GLenum::GL_POST_TEXTURE_FILTER_BIAS_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_SCALE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_SCALE_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_S_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_S_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_T_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_T_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_R_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_R_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP = GLenum::GL_GENERATE_MIPMAP; // reuse InternalFormatPName
// GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_SGIS = GLenum::GL_GENERATE_MIPMAP_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_SGIX = GLenum::GL_TEXTURE_COMPARE_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_OPERATOR_SGIX = GLenum::GL_TEXTURE_COMPARE_OPERATOR_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LEQUAL_R_SGIX = GLenum::GL_TEXTURE_LEQUAL_R_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEQUAL_R_SGIX = GLenum::GL_TEXTURE_GEQUAL_R_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_S_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_S_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_T_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_T_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_R_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_R_SGIX; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS = GLenum::GL_TEXTURE_LOD_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_MODE = GLenum::GL_TEXTURE_COMPARE_MODE; // reuse SamplerParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FUNC = GLenum::GL_TEXTURE_COMPARE_FUNC; // reuse SamplerParameterName
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_R = GLenum::GL_TEXTURE_SWIZZLE_R;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_G = GLenum::GL_TEXTURE_SWIZZLE_G;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_B = GLenum::GL_TEXTURE_SWIZZLE_B;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_A = GLenum::GL_TEXTURE_SWIZZLE_A;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_RGBA = GLenum::GL_TEXTURE_SWIZZLE_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_TEXTURE_MODE = GLenum::GL_DEPTH_STENCIL_TEXTURE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_TILING_EXT = GLenum::GL_TEXTURE_TILING_EXT;

// TextureTarget

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D = GLenum::GL_PROXY_TEXTURE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_EXT = GLenum::GL_PROXY_TEXTURE_1D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D = GLenum::GL_PROXY_TEXTURE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_EXT = GLenum::GL_PROXY_TEXTURE_2D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D = GLenum::GL_TEXTURE_3D;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_EXT = GLenum::GL_TEXTURE_3D_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_3D = GLenum::GL_PROXY_TEXTURE_3D;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_3D_EXT = GLenum::GL_PROXY_TEXTURE_3D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_2D_SGIS = GLenum::GL_DETAIL_TEXTURE_2D_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_SGIS = GLenum::GL_TEXTURE_4D_SGIS; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_4D_SGIS = GLenum::GL_PROXY_TEXTURE_4D_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE = GLenum::GL_TEXTURE_RECTANGLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_RECTANGLE = GLenum::GL_PROXY_TEXTURE_RECTANGLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_RECTANGLE_ARB = GLenum::GL_PROXY_TEXTURE_RECTANGLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_RECTANGLE_NV = GLenum::GL_PROXY_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP = GLenum::GL_TEXTURE_CUBE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_X = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_X = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Y = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Z = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP = GLenum::GL_PROXY_TEXTURE_CUBE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_ARB = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_EXT = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_ARRAY = GLenum::GL_TEXTURE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_ARRAY = GLenum::GL_PROXY_TEXTURE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_ARRAY_EXT = GLenum::GL_PROXY_TEXTURE_1D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_ARRAY = GLenum::GL_TEXTURE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_ARRAY = GLenum::GL_PROXY_TEXTURE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_ARRAY_EXT = GLenum::GL_PROXY_TEXTURE_2D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARRAY = GLenum::GL_TEXTURE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARRAY_ARB = GLenum::GL_TEXTURE_CUBE_MAP_ARRAY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_MULTISAMPLE = GLenum::GL_TEXTURE_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_MULTISAMPLE = GLenum::GL_PROXY_TEXTURE_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_MULTISAMPLE_ARRAY = GLenum::GL_TEXTURE_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = GLenum::GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY;

// TextureUnit

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE0 = GLenum::GL_TEXTURE0;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE1 = GLenum::GL_TEXTURE1;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE2 = GLenum::GL_TEXTURE2;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE3 = GLenum::GL_TEXTURE3;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE4 = GLenum::GL_TEXTURE4;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE5 = GLenum::GL_TEXTURE5;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE6 = GLenum::GL_TEXTURE6;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE7 = GLenum::GL_TEXTURE7;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE8 = GLenum::GL_TEXTURE8;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE9 = GLenum::GL_TEXTURE9;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE10 = GLenum::GL_TEXTURE10;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE11 = GLenum::GL_TEXTURE11;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE12 = GLenum::GL_TEXTURE12;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE13 = GLenum::GL_TEXTURE13;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE14 = GLenum::GL_TEXTURE14;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE15 = GLenum::GL_TEXTURE15;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE16 = GLenum::GL_TEXTURE16;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE17 = GLenum::GL_TEXTURE17;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE18 = GLenum::GL_TEXTURE18;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE19 = GLenum::GL_TEXTURE19;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE20 = GLenum::GL_TEXTURE20;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE21 = GLenum::GL_TEXTURE21;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE22 = GLenum::GL_TEXTURE22;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE23 = GLenum::GL_TEXTURE23;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE24 = GLenum::GL_TEXTURE24;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE25 = GLenum::GL_TEXTURE25;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE26 = GLenum::GL_TEXTURE26;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE27 = GLenum::GL_TEXTURE27;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE28 = GLenum::GL_TEXTURE28;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE29 = GLenum::GL_TEXTURE29;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE30 = GLenum::GL_TEXTURE30;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE31 = GLenum::GL_TEXTURE31;

// TextureWrapMode

GLBINDING_CONSTEXPR static const GLenum GL_CLAMP = GLenum::GL_CLAMP;
GLBINDING_CONSTEXPR static const GLenum GL_REPEAT = GLenum::GL_REPEAT;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_BORDER = GLenum::GL_CLAMP_TO_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_BORDER_ARB = GLenum::GL_CLAMP_TO_BORDER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_BORDER_SGIS = GLenum::GL_CLAMP_TO_BORDER_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_EDGE = GLenum::GL_CLAMP_TO_EDGE;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_EDGE_SGIS = GLenum::GL_CLAMP_TO_EDGE_SGIS;

// TransformFeedbackPName

GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_START = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_START;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_PAUSED = GLenum::GL_TRANSFORM_FEEDBACK_PAUSED;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_ACTIVE = GLenum::GL_TRANSFORM_FEEDBACK_ACTIVE;

// TypeEnum

GLBINDING_CONSTEXPR static const GLenum GL_QUERY_WAIT = GLenum::GL_QUERY_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_NO_WAIT = GLenum::GL_QUERY_NO_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BY_REGION_WAIT = GLenum::GL_QUERY_BY_REGION_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BY_REGION_NO_WAIT = GLenum::GL_QUERY_BY_REGION_NO_WAIT;

// UniformBlockPName

GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_BINDING = GLenum::GL_UNIFORM_BLOCK_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_DATA_SIZE = GLenum::GL_UNIFORM_BLOCK_DATA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_NAME_LENGTH = GLenum::GL_UNIFORM_BLOCK_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = GLenum::GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = GLenum::GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER;

// UniformPName

GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_TYPE = GLenum::GL_UNIFORM_TYPE;
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_SIZE = GLenum::GL_UNIFORM_SIZE; // reuse SubroutineParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_NAME_LENGTH = GLenum::GL_UNIFORM_NAME_LENGTH; // reuse SubroutineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK_INDEX = GLenum::GL_UNIFORM_BLOCK_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_OFFSET = GLenum::GL_UNIFORM_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_ARRAY_STRIDE = GLenum::GL_UNIFORM_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_MATRIX_STRIDE = GLenum::GL_UNIFORM_MATRIX_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_IS_ROW_MAJOR = GLenum::GL_UNIFORM_IS_ROW_MAJOR;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = GLenum::GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX;

// VertexArrayPName

GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_RELATIVE_OFFSET = GLenum::GL_VERTEX_ATTRIB_RELATIVE_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_ENABLED = GLenum::GL_VERTEX_ATTRIB_ARRAY_ENABLED;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_SIZE = GLenum::GL_VERTEX_ATTRIB_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_STRIDE = GLenum::GL_VERTEX_ATTRIB_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_TYPE = GLenum::GL_VERTEX_ATTRIB_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_LONG = GLenum::GL_VERTEX_ATTRIB_ARRAY_LONG;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = GLenum::GL_VERTEX_ATTRIB_ARRAY_NORMALIZED;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_INTEGER = GLenum::GL_VERTEX_ATTRIB_ARRAY_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_DIVISOR = GLenum::GL_VERTEX_ATTRIB_ARRAY_DIVISOR;

// VertexAttribEnum

// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_ENABLED = GLenum::GL_VERTEX_ATTRIB_ARRAY_ENABLED; // reuse VertexArrayPName
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_SIZE = GLenum::GL_VERTEX_ATTRIB_ARRAY_SIZE; // reuse VertexArrayPName
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_STRIDE = GLenum::GL_VERTEX_ATTRIB_ARRAY_STRIDE; // reuse VertexArrayPName
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_TYPE = GLenum::GL_VERTEX_ATTRIB_ARRAY_TYPE; // reuse VertexArrayPName
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_VERTEX_ATTRIB = GLenum::GL_CURRENT_VERTEX_ATTRIB;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = GLenum::GL_VERTEX_ATTRIB_ARRAY_NORMALIZED; // reuse VertexArrayPName
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = GLenum::GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_INTEGER = GLenum::GL_VERTEX_ATTRIB_ARRAY_INTEGER; // reuse VertexArrayPName
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_DIVISOR = GLenum::GL_VERTEX_ATTRIB_ARRAY_DIVISOR; // reuse VertexArrayPName

// VertexAttribPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType
GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT = GLenum::GL_HALF_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_FIXED = GLenum::GL_FIXED;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_2_10_10_10_REV = GLenum::GL_UNSIGNED_INT_2_10_10_10_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10F_11F_11F_REV = GLenum::GL_UNSIGNED_INT_10F_11F_11F_REV;
GLBINDING_CONSTEXPR static const GLenum GL_INT_2_10_10_10_REV = GLenum::GL_INT_2_10_10_10_REV;

// VertexAttribType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT = GLenum::GL_HALF_FLOAT; // reuse VertexAttribPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FIXED = GLenum::GL_FIXED; // reuse VertexAttribPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_2_10_10_10_REV = GLenum::GL_UNSIGNED_INT_2_10_10_10_REV; // reuse VertexAttribPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10F_11F_11F_REV = GLenum::GL_UNSIGNED_INT_10F_11F_11F_REV; // reuse VertexAttribPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT_2_10_10_10_REV = GLenum::GL_INT_2_10_10_10_REV; // reuse VertexAttribPointerType

// VertexBufferObjectParameter

GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_IMMUTABLE_STORAGE = GLenum::GL_BUFFER_IMMUTABLE_STORAGE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_STORAGE_FLAGS = GLenum::GL_BUFFER_STORAGE_FLAGS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_SIZE = GLenum::GL_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_USAGE = GLenum::GL_BUFFER_USAGE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_ACCESS = GLenum::GL_BUFFER_ACCESS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAPPED = GLenum::GL_BUFFER_MAPPED;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_ACCESS_FLAGS = GLenum::GL_BUFFER_ACCESS_FLAGS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_LENGTH = GLenum::GL_BUFFER_MAP_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_OFFSET = GLenum::GL_BUFFER_MAP_OFFSET;

// VertexBufferObjectUsage

// GLBINDING_CONSTEXPR static const GLenum GL_STREAM_DRAW = GLenum::GL_STREAM_DRAW; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_STREAM_READ = GLenum::GL_STREAM_READ; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_STREAM_COPY = GLenum::GL_STREAM_COPY; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_STATIC_DRAW = GLenum::GL_STATIC_DRAW; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_STATIC_READ = GLenum::GL_STATIC_READ; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_STATIC_COPY = GLenum::GL_STATIC_COPY; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_DRAW = GLenum::GL_DYNAMIC_DRAW; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_READ = GLenum::GL_DYNAMIC_READ; // reuse BufferUsageARB
// GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_COPY = GLenum::GL_DYNAMIC_COPY; // reuse BufferUsageARB

// VertexPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse ColorPointerType

// VertexProvokingMode

GLBINDING_CONSTEXPR static const GLenum GL_FIRST_VERTEX_CONVENTION = GLenum::GL_FIRST_VERTEX_CONVENTION;
GLBINDING_CONSTEXPR static const GLenum GL_LAST_VERTEX_CONVENTION = GLenum::GL_LAST_VERTEX_CONVENTION;

// __UNGROUPED__

GLBINDING_CONSTEXPR static const GLenum GL_NEXT_BUFFER_NV = GLenum::GL_NEXT_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS4_NV = GLenum::GL_SKIP_COMPONENTS4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS3_NV = GLenum::GL_SKIP_COMPONENTS3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS2_NV = GLenum::GL_SKIP_COMPONENTS2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS1_NV = GLenum::GL_SKIP_COMPONENTS1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CLOSE_PATH_NV = GLenum::GL_CLOSE_PATH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TERMINATE_SEQUENCE_COMMAND_NV = GLenum::GL_TERMINATE_SEQUENCE_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_NOP_COMMAND_NV = GLenum::GL_NOP_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RESTART_SUN = GLenum::GL_RESTART_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ELEMENTS_COMMAND_NV = GLenum::GL_DRAW_ELEMENTS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_MIDDLE_SUN = GLenum::GL_REPLACE_MIDDLE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ARRAYS_COMMAND_NV = GLenum::GL_DRAW_ARRAYS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_OLDEST_SUN = GLenum::GL_REPLACE_OLDEST_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = GLenum::GL_DRAW_ELEMENTS_STRIP_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ARRAYS_STRIP_COMMAND_NV = GLenum::GL_DRAW_ARRAYS_STRIP_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = GLenum::GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = GLenum::GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ADDRESS_COMMAND_NV = GLenum::GL_ELEMENT_ADDRESS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIBUTE_ADDRESS_COMMAND_NV = GLenum::GL_ATTRIBUTE_ADDRESS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_ADDRESS_COMMAND_NV = GLenum::GL_UNIFORM_ADDRESS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_COLOR_COMMAND_NV = GLenum::GL_BLEND_COLOR_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_REF_COMMAND_NV = GLenum::GL_STENCIL_REF_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH_COMMAND_NV = GLenum::GL_LINE_WIDTH_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_COMMAND_NV = GLenum::GL_POLYGON_OFFSET_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_REF_COMMAND_NV = GLenum::GL_ALPHA_REF_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_COMMAND_NV = GLenum::GL_VIEWPORT_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_COMMAND_NV = GLenum::GL_SCISSOR_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_FACE_COMMAND_NV = GLenum::GL_FRONT_FACE_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MOVE_TO_NV = GLenum::GL_MOVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_MOVE_TO_NV = GLenum::GL_RELATIVE_MOVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_TO_NV = GLenum::GL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LINE_TO_NV = GLenum::GL_RELATIVE_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_LOST = GLenum::GL_CONTEXT_LOST;
GLBINDING_CONSTEXPR static const GLenum GL_HORIZONTAL_LINE_TO_NV = GLenum::GL_HORIZONTAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_HORIZONTAL_LINE_TO_NV = GLenum::GL_RELATIVE_HORIZONTAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTICAL_LINE_TO_NV = GLenum::GL_VERTICAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_VERTICAL_LINE_TO_NV = GLenum::GL_RELATIVE_VERTICAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_QUADRATIC_CURVE_TO_NV = GLenum::GL_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_QUADRATIC_CURVE_TO_NV = GLenum::GL_RELATIVE_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MODELVIEW_STACK_DEPTH_NV = GLenum::GL_PATH_MODELVIEW_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_PROJECTION_STACK_DEPTH_NV = GLenum::GL_PATH_PROJECTION_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MODELVIEW_MATRIX_NV = GLenum::GL_PATH_MODELVIEW_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_PROJECTION_MATRIX_NV = GLenum::GL_PATH_PROJECTION_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_CURVE_TO_NV = GLenum::GL_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_CUBIC_CURVE_TO_NV = GLenum::GL_RELATIVE_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = GLenum::GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = GLenum::GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_QUADRATIC_CURVE_TO_NV = GLenum::GL_SMOOTH_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = GLenum::GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_CUBIC_CURVE_TO_NV = GLenum::GL_SMOOTH_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_TARGET = GLenum::GL_TEXTURE_TARGET;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = GLenum::GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMALL_CCW_ARC_TO_NV = GLenum::GL_SMALL_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMALL_CCW_ARC_TO_NV = GLenum::GL_RELATIVE_SMALL_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMALL_CW_ARC_TO_NV = GLenum::GL_SMALL_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_2_BYTES_NV = GLenum::GL_2_BYTES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_3_BYTES_NV = GLenum::GL_3_BYTES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_4_BYTES_NV = GLenum::GL_4_BYTES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_APPLE = GLenum::GL_HALF_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT_ARB = GLenum::GL_HALF_FLOAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT_NV = GLenum::GL_HALF_FLOAT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FIXED_OES = GLenum::GL_FIXED_OES;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_ARB = GLenum::GL_INT64_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_NV = GLenum::GL_INT64_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_ARB = GLenum::GL_UNSIGNED_INT64_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_NV = GLenum::GL_UNSIGNED_INT64_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMALL_CW_ARC_TO_NV = GLenum::GL_RELATIVE_SMALL_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_XOR_NV = GLenum::GL_XOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LARGE_CCW_ARC_TO_NV = GLenum::GL_LARGE_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LARGE_CCW_ARC_TO_NV = GLenum::GL_RELATIVE_LARGE_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_ARB = GLenum::GL_MODELVIEW0_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MODELVIEW_NV = GLenum::GL_PATH_MODELVIEW_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_PROJECTION_NV = GLenum::GL_PATH_PROJECTION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LARGE_CW_ARC_TO_NV = GLenum::GL_LARGE_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LARGE_CW_ARC_TO_NV = GLenum::GL_RELATIVE_LARGE_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RED_NV = GLenum::GL_RED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_NV = GLenum::GL_GREEN_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_NV = GLenum::GL_BLUE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RASTER_POSITION_UNCLIPPED_IBM = GLenum::GL_RASTER_POSITION_UNCLIPPED_IBM;
GLBINDING_CONSTEXPR static const GLenum GL_CONIC_CURVE_TO_NV = GLenum::GL_CONIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_NATIVE_GRAPHICS_HANDLE_PGI = GLenum::GL_NATIVE_GRAPHICS_HANDLE_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_CONIC_CURVE_TO_NV = GLenum::GL_RELATIVE_CONIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINEAR_NV = GLenum::GL_EYE_LINEAR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINEAR_NV = GLenum::GL_OBJECT_LINEAR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR_EXT = GLenum::GL_CONSTANT_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_COLOR_EXT = GLenum::GL_ONE_MINUS_CONSTANT_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ALPHA_EXT = GLenum::GL_CONSTANT_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_ALPHA_EXT = GLenum::GL_ONE_MINUS_CONSTANT_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_COLOR = GLenum::GL_BLEND_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_MIN = GLenum::GL_MIN;
GLBINDING_CONSTEXPR static const GLenum GL_MAX = GLenum::GL_MAX;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION = GLenum::GL_BLEND_EQUATION;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_RGB = GLenum::GL_BLEND_EQUATION_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_RGB_EXT = GLenum::GL_BLEND_EQUATION_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_EXT = GLenum::GL_POLYGON_OFFSET_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FACTOR_EXT = GLenum::GL_POLYGON_OFFSET_FACTOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RESCALE_NORMAL = GLenum::GL_RESCALE_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA4_EXT = GLenum::GL_ALPHA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8_EXT = GLenum::GL_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA12_EXT = GLenum::GL_ALPHA12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16_EXT = GLenum::GL_ALPHA16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_EXT = GLenum::GL_LUMINANCE4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_EXT = GLenum::GL_LUMINANCE8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_EXT = GLenum::GL_LUMINANCE12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_EXT = GLenum::GL_LUMINANCE16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_ALPHA4_EXT = GLenum::GL_LUMINANCE4_ALPHA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE6_ALPHA2_EXT = GLenum::GL_LUMINANCE6_ALPHA2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_ALPHA8_EXT = GLenum::GL_LUMINANCE8_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA4_EXT = GLenum::GL_LUMINANCE12_ALPHA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA12_EXT = GLenum::GL_LUMINANCE12_ALPHA12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_ALPHA16_EXT = GLenum::GL_LUMINANCE16_ALPHA16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY_EXT = GLenum::GL_INTENSITY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY4_EXT = GLenum::GL_INTENSITY4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8_EXT = GLenum::GL_INTENSITY8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY12_EXT = GLenum::GL_INTENSITY12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16_EXT = GLenum::GL_INTENSITY16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA2 = GLenum::GL_RGBA2;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA2_EXT = GLenum::GL_RGBA2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_SIZE_EXT = GLenum::GL_TEXTURE_RED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_SIZE_EXT = GLenum::GL_TEXTURE_GREEN_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_SIZE_EXT = GLenum::GL_TEXTURE_BLUE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_SIZE_EXT = GLenum::GL_TEXTURE_ALPHA_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_SIZE_EXT = GLenum::GL_TEXTURE_LUMINANCE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_SIZE_EXT = GLenum::GL_TEXTURE_INTENSITY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RESIDENT_EXT = GLenum::GL_TEXTURE_RESIDENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_BINDING_EXT = GLenum::GL_TEXTURE_1D_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_BINDING_EXT = GLenum::GL_TEXTURE_2D_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH = GLenum::GL_TEXTURE_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_3D_TEXTURE_SIZE = GLenum::GL_MAX_3D_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_EXT = GLenum::GL_VERTEX_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_EXT = GLenum::GL_NORMAL_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_EXT = GLenum::GL_COLOR_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_EXT = GLenum::GL_INDEX_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_EXT = GLenum::GL_EDGE_FLAG_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_SIZE_EXT = GLenum::GL_VERTEX_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_TYPE_EXT = GLenum::GL_VERTEX_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_STRIDE_EXT = GLenum::GL_VERTEX_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_TYPE_EXT = GLenum::GL_NORMAL_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_STRIDE_EXT = GLenum::GL_NORMAL_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_SIZE_EXT = GLenum::GL_COLOR_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_TYPE_EXT = GLenum::GL_COLOR_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_STRIDE_EXT = GLenum::GL_COLOR_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_TYPE_EXT = GLenum::GL_INDEX_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_STRIDE_EXT = GLenum::GL_INDEX_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_SIZE_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_TYPE_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_STRIDE_EXT = GLenum::GL_EDGE_FLAG_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE = GLenum::GL_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_ARB = GLenum::GL_MULTISAMPLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_EXT = GLenum::GL_MULTISAMPLE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_COVERAGE = GLenum::GL_SAMPLE_ALPHA_TO_COVERAGE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = GLenum::GL_SAMPLE_ALPHA_TO_COVERAGE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_MASK_EXT = GLenum::GL_SAMPLE_ALPHA_TO_MASK_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE = GLenum::GL_SAMPLE_ALPHA_TO_ONE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_ARB = GLenum::GL_SAMPLE_ALPHA_TO_ONE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_EXT = GLenum::GL_SAMPLE_ALPHA_TO_ONE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE = GLenum::GL_SAMPLE_COVERAGE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_ARB = GLenum::GL_SAMPLE_COVERAGE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_EXT = GLenum::GL_SAMPLE_MASK_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_ARB = GLenum::GL_SAMPLE_BUFFERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_EXT = GLenum::GL_SAMPLE_BUFFERS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_ARB = GLenum::GL_SAMPLES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_EXT = GLenum::GL_SAMPLES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_VALUE = GLenum::GL_SAMPLE_COVERAGE_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_VALUE_ARB = GLenum::GL_SAMPLE_COVERAGE_VALUE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_VALUE_EXT = GLenum::GL_SAMPLE_MASK_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_INVERT = GLenum::GL_SAMPLE_COVERAGE_INVERT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_INVERT_ARB = GLenum::GL_SAMPLE_COVERAGE_INVERT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_INVERT_EXT = GLenum::GL_SAMPLE_MASK_INVERT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_PATTERN_EXT = GLenum::GL_SAMPLE_PATTERN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX = GLenum::GL_COLOR_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX_STACK_DEPTH = GLenum::GL_COLOR_MATRIX_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_MATRIX_STACK_DEPTH = GLenum::GL_MAX_COLOR_MATRIX_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = GLenum::GL_TEXTURE_COMPARE_FAIL_VALUE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_RGB = GLenum::GL_BLEND_DST_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_RGB_EXT = GLenum::GL_BLEND_DST_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_RGB = GLenum::GL_BLEND_SRC_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_RGB_EXT = GLenum::GL_BLEND_SRC_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_ALPHA = GLenum::GL_BLEND_DST_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_ALPHA_EXT = GLenum::GL_BLEND_DST_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_ALPHA = GLenum::GL_BLEND_SRC_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_ALPHA_EXT = GLenum::GL_BLEND_SRC_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_EXT = GLenum::GL_422_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_REV_EXT = GLenum::GL_422_REV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_AVERAGE_EXT = GLenum::GL_422_AVERAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_REV_AVERAGE_EXT = GLenum::GL_422_REV_AVERAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BGR = GLenum::GL_BGR;
GLBINDING_CONSTEXPR static const GLenum GL_BGR_EXT = GLenum::GL_BGR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA = GLenum::GL_BGRA;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA_EXT = GLenum::GL_BGRA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX1_EXT = GLenum::GL_COLOR_INDEX1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX2_EXT = GLenum::GL_COLOR_INDEX2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX4_EXT = GLenum::GL_COLOR_INDEX4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX8_EXT = GLenum::GL_COLOR_INDEX8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX12_EXT = GLenum::GL_COLOR_INDEX12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX16_EXT = GLenum::GL_COLOR_INDEX16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_VERTICES = GLenum::GL_MAX_ELEMENTS_VERTICES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_VERTICES_EXT = GLenum::GL_MAX_ELEMENTS_VERTICES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_INDICES = GLenum::GL_MAX_ELEMENTS_INDICES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_INDICES_EXT = GLenum::GL_MAX_ELEMENTS_INDICES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PHONG_WIN = GLenum::GL_PHONG_WIN;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_SPECULAR_TEXTURE_WIN = GLenum::GL_FOG_SPECULAR_TEXTURE_WIN;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INDEX_SIZE_EXT = GLenum::GL_TEXTURE_INDEX_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER = GLenum::GL_PARAMETER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER_ARB = GLenum::GL_PARAMETER_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER_BINDING = GLenum::GL_PARAMETER_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER_BINDING_ARB = GLenum::GL_PARAMETER_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_AXIAL_SGIX = GLenum::GL_SPRITE_AXIAL_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_OBJECT_ALIGNED_SGIX = GLenum::GL_SPRITE_OBJECT_ALIGNED_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_EYE_ALIGNED_SGIX = GLenum::GL_SPRITE_EYE_ALIGNED_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_IGNORE_BORDER_HP = GLenum::GL_IGNORE_BORDER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_BORDER = GLenum::GL_CONSTANT_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_BORDER_HP = GLenum::GL_CONSTANT_BORDER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_REPLICATE_BORDER = GLenum::GL_REPLICATE_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_REPLICATE_BORDER_HP = GLenum::GL_REPLICATE_BORDER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_COLOR_HP = GLenum::GL_CONVOLUTION_BORDER_COLOR_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_SCALE_X_HP = GLenum::GL_IMAGE_SCALE_X_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_SCALE_Y_HP = GLenum::GL_IMAGE_SCALE_Y_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TRANSLATE_X_HP = GLenum::GL_IMAGE_TRANSLATE_X_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TRANSLATE_Y_HP = GLenum::GL_IMAGE_TRANSLATE_Y_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_ROTATE_ANGLE_HP = GLenum::GL_IMAGE_ROTATE_ANGLE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_ROTATE_ORIGIN_X_HP = GLenum::GL_IMAGE_ROTATE_ORIGIN_X_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_ROTATE_ORIGIN_Y_HP = GLenum::GL_IMAGE_ROTATE_ORIGIN_Y_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_MAG_FILTER_HP = GLenum::GL_IMAGE_MAG_FILTER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_MIN_FILTER_HP = GLenum::GL_IMAGE_MIN_FILTER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CUBIC_WEIGHT_HP = GLenum::GL_IMAGE_CUBIC_WEIGHT_HP;
GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_HP = GLenum::GL_CUBIC_HP;
GLBINDING_CONSTEXPR static const GLenum GL_AVERAGE_HP = GLenum::GL_AVERAGE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TRANSFORM_2D_HP = GLenum::GL_IMAGE_TRANSFORM_2D_HP;
GLBINDING_CONSTEXPR static const GLenum GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = GLenum::GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = GLenum::GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_OCCLUSION_TEST_HP = GLenum::GL_OCCLUSION_TEST_HP;
GLBINDING_CONSTEXPR static const GLenum GL_OCCLUSION_TEST_RESULT_HP = GLenum::GL_OCCLUSION_TEST_RESULT_HP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LIGHTING_MODE_HP = GLenum::GL_TEXTURE_LIGHTING_MODE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_POST_SPECULAR_HP = GLenum::GL_TEXTURE_POST_SPECULAR_HP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRE_SPECULAR_HP = GLenum::GL_TEXTURE_PRE_SPECULAR_HP;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEFORMATION_ORDER_SGIX = GLenum::GL_MAX_DEFORMATION_ORDER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24 = GLenum::GL_DEPTH_COMPONENT24;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32 = GLenum::GL_DEPTH_COMPONENT32;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = GLenum::GL_ARRAY_ELEMENT_LOCK_FIRST_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = GLenum::GL_ARRAY_ELEMENT_LOCK_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_VERTEX_EXT = GLenum::GL_CULL_VERTEX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_VERTEX_EYE_POSITION_EXT = GLenum::GL_CULL_VERTEX_EYE_POSITION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_VERTEX_OBJECT_POSITION_EXT = GLenum::GL_CULL_VERTEX_OBJECT_POSITION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_V2F_EXT = GLenum::GL_IUI_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_V3F_EXT = GLenum::GL_IUI_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_N3F_V2F_EXT = GLenum::GL_IUI_N3F_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_N3F_V3F_EXT = GLenum::GL_IUI_N3F_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_V2F_EXT = GLenum::GL_T2F_IUI_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_V3F_EXT = GLenum::GL_T2F_IUI_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_N3F_V2F_EXT = GLenum::GL_T2F_IUI_N3F_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_N3F_V3F_EXT = GLenum::GL_T2F_IUI_N3F_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_TEST_EXT = GLenum::GL_INDEX_TEST_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_TEST_FUNC_EXT = GLenum::GL_INDEX_TEST_FUNC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_TEST_REF_EXT = GLenum::GL_INDEX_TEST_REF_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MATERIAL_EXT = GLenum::GL_INDEX_MATERIAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MATERIAL_PARAMETER_EXT = GLenum::GL_INDEX_MATERIAL_PARAMETER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MATERIAL_FACE_EXT = GLenum::GL_INDEX_MATERIAL_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_WRAP_BORDER_SUN = GLenum::GL_WRAP_BORDER_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CONSTANT_DATA_SUNX = GLenum::GL_UNPACK_CONSTANT_DATA_SUNX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CONSTANT_DATA_SUNX = GLenum::GL_TEXTURE_CONSTANT_DATA_SUNX;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_LIST_SUN = GLenum::GL_TRIANGLE_LIST_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_SUN = GLenum::GL_REPLACEMENT_CODE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_GLOBAL_ALPHA_SUN = GLenum::GL_GLOBAL_ALPHA_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_GLOBAL_ALPHA_FACTOR_SUN = GLenum::GL_GLOBAL_ALPHA_FACTOR_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_WRITEMASK_SGIS = GLenum::GL_TEXTURE_COLOR_WRITEMASK_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXT_FRAGMENT_SHADER_ATI = GLenum::GL_TEXT_FRAGMENT_SHADER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT = GLenum::GL_FRAMEBUFFER_DEFAULT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_ATTACHMENT = GLenum::GL_DEPTH_STENCIL_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_MAJOR_VERSION = GLenum::GL_MAJOR_VERSION;
GLBINDING_CONSTEXPR static const GLenum GL_MINOR_VERSION = GLenum::GL_MINOR_VERSION;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_EXTENSIONS = GLenum::GL_NUM_EXTENSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_FLAGS = GLenum::GL_CONTEXT_FLAGS;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = GLenum::GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX = GLenum::GL_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_RG_INTEGER = GLenum::GL_RG_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_CL_EVENT_ARB = GLenum::GL_SYNC_CL_EVENT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_CL_EVENT_COMPLETE_ARB = GLenum::GL_SYNC_CL_EVENT_COMPLETE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_OUTPUT_SYNCHRONOUS = GLenum::GL_DEBUG_OUTPUT_SYNCHRONOUS;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = GLenum::GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = GLenum::GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = GLenum::GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_FUNCTION_ARB = GLenum::GL_DEBUG_CALLBACK_FUNCTION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_USER_PARAM_ARB = GLenum::GL_DEBUG_CALLBACK_USER_PARAM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_API_ARB = GLenum::GL_DEBUG_SOURCE_API_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = GLenum::GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = GLenum::GL_DEBUG_SOURCE_SHADER_COMPILER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_THIRD_PARTY_ARB = GLenum::GL_DEBUG_SOURCE_THIRD_PARTY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_APPLICATION_ARB = GLenum::GL_DEBUG_SOURCE_APPLICATION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_OTHER_ARB = GLenum::GL_DEBUG_SOURCE_OTHER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_ERROR_ARB = GLenum::GL_DEBUG_TYPE_ERROR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = GLenum::GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = GLenum::GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PORTABILITY_ARB = GLenum::GL_DEBUG_TYPE_PORTABILITY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PERFORMANCE_ARB = GLenum::GL_DEBUG_TYPE_PERFORMANCE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_OTHER_ARB = GLenum::GL_DEBUG_TYPE_OTHER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LOSE_CONTEXT_ON_RESET = GLenum::GL_LOSE_CONTEXT_ON_RESET;
GLBINDING_CONSTEXPR static const GLenum GL_LOSE_CONTEXT_ON_RESET_ARB = GLenum::GL_LOSE_CONTEXT_ON_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GUILTY_CONTEXT_RESET_ARB = GLenum::GL_GUILTY_CONTEXT_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INNOCENT_CONTEXT_RESET_ARB = GLenum::GL_INNOCENT_CONTEXT_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNKNOWN_CONTEXT_RESET_ARB = GLenum::GL_UNKNOWN_CONTEXT_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RESET_NOTIFICATION_STRATEGY = GLenum::GL_RESET_NOTIFICATION_STRATEGY;
GLBINDING_CONSTEXPR static const GLenum GL_RESET_NOTIFICATION_STRATEGY_ARB = GLenum::GL_RESET_NOTIFICATION_STRATEGY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE_BINDING = GLenum::GL_PROGRAM_PIPELINE_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VIEWPORTS = GLenum::GL_MAX_VIEWPORTS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_SUBPIXEL_BITS = GLenum::GL_VIEWPORT_SUBPIXEL_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_BOUNDS_RANGE = GLenum::GL_VIEWPORT_BOUNDS_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_LAYER_PROVOKING_VERTEX = GLenum::GL_LAYER_PROVOKING_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_INDEX_PROVOKING_VERTEX = GLenum::GL_VIEWPORT_INDEX_PROVOKING_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_UNDEFINED_VERTEX = GLenum::GL_UNDEFINED_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_NO_RESET_NOTIFICATION = GLenum::GL_NO_RESET_NOTIFICATION;
GLBINDING_CONSTEXPR static const GLenum GL_NO_RESET_NOTIFICATION_ARB = GLenum::GL_NO_RESET_NOTIFICATION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = GLenum::GL_MAX_COMPUTE_SHARED_MEMORY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMPUTE_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = GLenum::GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_ATOMIC_COUNTERS = GLenum::GL_MAX_COMPUTE_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_NOTIFICATION = GLenum::GL_DEBUG_SEVERITY_NOTIFICATION;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEBUG_GROUP_STACK_DEPTH = GLenum::GL_MAX_DEBUG_GROUP_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_GROUP_STACK_DEPTH = GLenum::GL_DEBUG_GROUP_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_UNIFORM_LOCATIONS = GLenum::GL_MAX_UNIFORM_LOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_DIMENSIONS = GLenum::GL_MAX_COMBINED_DIMENSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENTS = GLenum::GL_DEPTH_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_COMPONENTS = GLenum::GL_STENCIL_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MANUAL_GENERATE_MIPMAP = GLenum::GL_MANUAL_GENERATE_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_DECODE_ARB = GLenum::GL_SRGB_DECODE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FULL_SUPPORT = GLenum::GL_FULL_SUPPORT;
GLBINDING_CONSTEXPR static const GLenum GL_CAVEAT_SUPPORT = GLenum::GL_CAVEAT_SUPPORT;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_4_X_32 = GLenum::GL_IMAGE_CLASS_4_X_32;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_2_X_32 = GLenum::GL_IMAGE_CLASS_2_X_32;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_1_X_32 = GLenum::GL_IMAGE_CLASS_1_X_32;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_4_X_16 = GLenum::GL_IMAGE_CLASS_4_X_16;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_2_X_16 = GLenum::GL_IMAGE_CLASS_2_X_16;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_1_X_16 = GLenum::GL_IMAGE_CLASS_1_X_16;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_4_X_8 = GLenum::GL_IMAGE_CLASS_4_X_8;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_2_X_8 = GLenum::GL_IMAGE_CLASS_2_X_8;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_1_X_8 = GLenum::GL_IMAGE_CLASS_1_X_8;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_11_11_10 = GLenum::GL_IMAGE_CLASS_11_11_10;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_10_10_10_2 = GLenum::GL_IMAGE_CLASS_10_10_10_2;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_128_BITS = GLenum::GL_VIEW_CLASS_128_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_96_BITS = GLenum::GL_VIEW_CLASS_96_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_64_BITS = GLenum::GL_VIEW_CLASS_64_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_48_BITS = GLenum::GL_VIEW_CLASS_48_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_32_BITS = GLenum::GL_VIEW_CLASS_32_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_24_BITS = GLenum::GL_VIEW_CLASS_24_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_16_BITS = GLenum::GL_VIEW_CLASS_16_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_8_BITS = GLenum::GL_VIEW_CLASS_8_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT1_RGB = GLenum::GL_VIEW_CLASS_S3TC_DXT1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT1_RGBA = GLenum::GL_VIEW_CLASS_S3TC_DXT1_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT3_RGBA = GLenum::GL_VIEW_CLASS_S3TC_DXT3_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT5_RGBA = GLenum::GL_VIEW_CLASS_S3TC_DXT5_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_RGTC1_RED = GLenum::GL_VIEW_CLASS_RGTC1_RED;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_RGTC2_RG = GLenum::GL_VIEW_CLASS_RGTC2_RG;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_BPTC_UNORM = GLenum::GL_VIEW_CLASS_BPTC_UNORM;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_BPTC_FLOAT = GLenum::GL_VIEW_CLASS_BPTC_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_BINDING = GLenum::GL_VERTEX_ATTRIB_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BINDING_DIVISOR = GLenum::GL_VERTEX_BINDING_DIVISOR;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BINDING_OFFSET = GLenum::GL_VERTEX_BINDING_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BINDING_STRIDE = GLenum::GL_VERTEX_BINDING_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = GLenum::GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIB_BINDINGS = GLenum::GL_MAX_VERTEX_ATTRIB_BINDINGS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_MIN_LEVEL = GLenum::GL_TEXTURE_VIEW_MIN_LEVEL;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_NUM_LEVELS = GLenum::GL_TEXTURE_VIEW_NUM_LEVELS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_MIN_LAYER = GLenum::GL_TEXTURE_VIEW_MIN_LAYER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_NUM_LAYERS = GLenum::GL_TEXTURE_VIEW_NUM_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_IMMUTABLE_LEVELS = GLenum::GL_TEXTURE_IMMUTABLE_LEVELS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIB_STRIDE = GLenum::GL_MAX_VERTEX_ATTRIB_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_DISPLAY_LIST = GLenum::GL_DISPLAY_LIST;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LABEL_LENGTH = GLenum::GL_MAX_LABEL_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_SHADING_LANGUAGE_VERSIONS = GLenum::GL_NUM_SHADING_LANGUAGE_VERSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_OVERFLOW = GLenum::GL_TRANSFORM_FEEDBACK_OVERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB = GLenum::GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW = GLenum::GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = GLenum::GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTICES_SUBMITTED = GLenum::GL_VERTICES_SUBMITTED;
GLBINDING_CONSTEXPR static const GLenum GL_VERTICES_SUBMITTED_ARB = GLenum::GL_VERTICES_SUBMITTED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_SUBMITTED = GLenum::GL_PRIMITIVES_SUBMITTED;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_SUBMITTED_ARB = GLenum::GL_PRIMITIVES_SUBMITTED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_INVOCATIONS = GLenum::GL_VERTEX_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_INVOCATIONS_ARB = GLenum::GL_VERTEX_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER_PATCHES = GLenum::GL_TESS_CONTROL_SHADER_PATCHES;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER_PATCHES_ARB = GLenum::GL_TESS_CONTROL_SHADER_PATCHES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER_INVOCATIONS = GLenum::GL_TESS_EVALUATION_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = GLenum::GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED = GLenum::GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = GLenum::GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_INVOCATIONS = GLenum::GL_FRAGMENT_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_INVOCATIONS_ARB = GLenum::GL_FRAGMENT_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SHADER_INVOCATIONS = GLenum::GL_COMPUTE_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SHADER_INVOCATIONS_ARB = GLenum::GL_COMPUTE_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_INPUT_PRIMITIVES = GLenum::GL_CLIPPING_INPUT_PRIMITIVES;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_INPUT_PRIMITIVES_ARB = GLenum::GL_CLIPPING_INPUT_PRIMITIVES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_OUTPUT_PRIMITIVES = GLenum::GL_CLIPPING_OUTPUT_PRIMITIVES;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_OUTPUT_PRIMITIVES_ARB = GLenum::GL_CLIPPING_OUTPUT_PRIMITIVES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SPARSE_BUFFER_PAGE_SIZE_ARB = GLenum::GL_SPARSE_BUFFER_PAGE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CULL_DISTANCES = GLenum::GL_MAX_CULL_DISTANCES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = GLenum::GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_RELEASE_BEHAVIOR = GLenum::GL_CONTEXT_RELEASE_BEHAVIOR;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = GLenum::GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCB_SGIX = GLenum::GL_YCRCB_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCBA_SGIX = GLenum::GL_YCRCBA_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TRANSFORM_2D_EXT = GLenum::GL_PIXEL_TRANSFORM_2D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAG_FILTER_EXT = GLenum::GL_PIXEL_MAG_FILTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MIN_FILTER_EXT = GLenum::GL_PIXEL_MIN_FILTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_CUBIC_WEIGHT_EXT = GLenum::GL_PIXEL_CUBIC_WEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_EXT = GLenum::GL_CUBIC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_AVERAGE_EXT = GLenum::GL_AVERAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = GLenum::GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = GLenum::GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TRANSFORM_2D_MATRIX_EXT = GLenum::GL_PIXEL_TRANSFORM_2D_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_MATERIAL_EXT = GLenum::GL_FRAGMENT_MATERIAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_NORMAL_EXT = GLenum::GL_FRAGMENT_NORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_EXT = GLenum::GL_FRAGMENT_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ATTENUATION_EXT = GLenum::GL_ATTENUATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADOW_ATTENUATION_EXT = GLenum::GL_SHADOW_ATTENUATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_APPLICATION_MODE_EXT = GLenum::GL_TEXTURE_APPLICATION_MODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LIGHT_EXT = GLenum::GL_TEXTURE_LIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MATERIAL_FACE_EXT = GLenum::GL_TEXTURE_MATERIAL_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MATERIAL_PARAMETER_EXT = GLenum::GL_TEXTURE_MATERIAL_PARAMETER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_GROUP_COLOR_SGIS = GLenum::GL_PIXEL_GROUP_COLOR_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE_2_3_3_REV = GLenum::GL_UNSIGNED_BYTE_2_3_3_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_6_5 = GLenum::GL_UNSIGNED_SHORT_5_6_5;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_6_5_REV = GLenum::GL_UNSIGNED_SHORT_5_6_5_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_4_4_4_4_REV = GLenum::GL_UNSIGNED_SHORT_4_4_4_4_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_1_5_5_5_REV = GLenum::GL_UNSIGNED_SHORT_1_5_5_5_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_8_8_REV = GLenum::GL_UNSIGNED_INT_8_8_8_8_REV;
GLBINDING_CONSTEXPR static const GLenum GL_MIRRORED_REPEAT = GLenum::GL_MIRRORED_REPEAT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRRORED_REPEAT_ARB = GLenum::GL_MIRRORED_REPEAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MIRRORED_REPEAT_IBM = GLenum::GL_MIRRORED_REPEAT_IBM;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_S3TC = GLenum::GL_RGB_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGB4_S3TC = GLenum::GL_RGB4_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_S3TC = GLenum::GL_RGBA_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_S3TC = GLenum::GL_RGBA4_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_DXT5_S3TC = GLenum::GL_RGBA_DXT5_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_DXT5_S3TC = GLenum::GL_RGBA4_DXT5_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_PARALLEL_ARRAYS_INTEL = GLenum::GL_PARALLEL_ARRAYS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_PERFQUERY_DONOT_FLUSH_INTEL = GLenum::GL_PERFQUERY_DONOT_FLUSH_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_PERFQUERY_FLUSH_INTEL = GLenum::GL_PERFQUERY_FLUSH_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_PERFQUERY_WAIT_INTEL = GLenum::GL_PERFQUERY_WAIT_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_BLACKHOLE_RENDER_INTEL = GLenum::GL_BLACKHOLE_RENDER_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_CONSERVATIVE_RASTERIZATION_INTEL = GLenum::GL_CONSERVATIVE_RASTERIZATION_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MEMORY_LAYOUT_INTEL = GLenum::GL_TEXTURE_MEMORY_LAYOUT_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_NORMAL_SGIX = GLenum::GL_CURRENT_RASTER_NORMAL_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_EXT = GLenum::GL_TANGENT_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_EXT = GLenum::GL_BINORMAL_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_TANGENT_EXT = GLenum::GL_CURRENT_TANGENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_BINORMAL_EXT = GLenum::GL_CURRENT_BINORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_TYPE_EXT = GLenum::GL_TANGENT_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_STRIDE_EXT = GLenum::GL_TANGENT_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_TYPE_EXT = GLenum::GL_BINORMAL_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_STRIDE_EXT = GLenum::GL_BINORMAL_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_POINTER_EXT = GLenum::GL_TANGENT_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_POINTER_EXT = GLenum::GL_BINORMAL_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TANGENT_EXT = GLenum::GL_MAP1_TANGENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TANGENT_EXT = GLenum::GL_MAP2_TANGENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_BINORMAL_EXT = GLenum::GL_MAP1_BINORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_BINORMAL_EXT = GLenum::GL_MAP2_BINORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_SOURCE = GLenum::GL_FOG_COORDINATE_SOURCE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_SOURCE_EXT = GLenum::GL_FOG_COORDINATE_SOURCE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD = GLenum::GL_FOG_COORD;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE = GLenum::GL_FOG_COORDINATE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_EXT = GLenum::GL_FOG_COORDINATE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_DEPTH = GLenum::GL_FRAGMENT_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_DEPTH_EXT = GLenum::GL_FRAGMENT_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_FOG_COORD = GLenum::GL_CURRENT_FOG_COORD;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_FOG_COORDINATE = GLenum::GL_CURRENT_FOG_COORDINATE;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_FOG_COORDINATE_EXT = GLenum::GL_CURRENT_FOG_COORDINATE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_TYPE = GLenum::GL_FOG_COORDINATE_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_TYPE_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_TYPE = GLenum::GL_FOG_COORD_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_STRIDE = GLenum::GL_FOG_COORDINATE_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_STRIDE = GLenum::GL_FOG_COORD_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_POINTER = GLenum::GL_FOG_COORDINATE_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_POINTER_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_POINTER = GLenum::GL_FOG_COORD_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY = GLenum::GL_FOG_COORDINATE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY = GLenum::GL_FOG_COORD_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM = GLenum::GL_COLOR_SUM;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM_ARB = GLenum::GL_COLOR_SUM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM_EXT = GLenum::GL_COLOR_SUM_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_SECONDARY_COLOR = GLenum::GL_CURRENT_SECONDARY_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_SECONDARY_COLOR_EXT = GLenum::GL_CURRENT_SECONDARY_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_SIZE = GLenum::GL_SECONDARY_COLOR_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_TYPE = GLenum::GL_SECONDARY_COLOR_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_STRIDE = GLenum::GL_SECONDARY_COLOR_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_POINTER = GLenum::GL_SECONDARY_COLOR_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY = GLenum::GL_SECONDARY_COLOR_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_SECONDARY_COLOR = GLenum::GL_CURRENT_RASTER_SECONDARY_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SCREEN_COORDINATES_REND = GLenum::GL_SCREEN_COORDINATES_REND;
GLBINDING_CONSTEXPR static const GLenum GL_INVERTED_SCREEN_W_REND = GLenum::GL_INVERTED_SCREEN_W_REND;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE0_ARB = GLenum::GL_TEXTURE0_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE1_ARB = GLenum::GL_TEXTURE1_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE2_ARB = GLenum::GL_TEXTURE2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE3_ARB = GLenum::GL_TEXTURE3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE4_ARB = GLenum::GL_TEXTURE4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE5_ARB = GLenum::GL_TEXTURE5_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE6_ARB = GLenum::GL_TEXTURE6_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE7_ARB = GLenum::GL_TEXTURE7_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE8_ARB = GLenum::GL_TEXTURE8_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE9_ARB = GLenum::GL_TEXTURE9_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE10_ARB = GLenum::GL_TEXTURE10_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE11_ARB = GLenum::GL_TEXTURE11_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE12_ARB = GLenum::GL_TEXTURE12_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE13_ARB = GLenum::GL_TEXTURE13_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE14_ARB = GLenum::GL_TEXTURE14_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE15_ARB = GLenum::GL_TEXTURE15_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE16_ARB = GLenum::GL_TEXTURE16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE17_ARB = GLenum::GL_TEXTURE17_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE18_ARB = GLenum::GL_TEXTURE18_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE19_ARB = GLenum::GL_TEXTURE19_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE20_ARB = GLenum::GL_TEXTURE20_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE21_ARB = GLenum::GL_TEXTURE21_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE22_ARB = GLenum::GL_TEXTURE22_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE23_ARB = GLenum::GL_TEXTURE23_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE24_ARB = GLenum::GL_TEXTURE24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE25_ARB = GLenum::GL_TEXTURE25_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE26_ARB = GLenum::GL_TEXTURE26_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE27_ARB = GLenum::GL_TEXTURE27_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE28_ARB = GLenum::GL_TEXTURE28_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE29_ARB = GLenum::GL_TEXTURE29_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE30_ARB = GLenum::GL_TEXTURE30_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE31_ARB = GLenum::GL_TEXTURE31_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_TEXTURE = GLenum::GL_ACTIVE_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_TEXTURE_ARB = GLenum::GL_ACTIVE_TEXTURE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLIENT_ACTIVE_TEXTURE = GLenum::GL_CLIENT_ACTIVE_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_CLIENT_ACTIVE_TEXTURE_ARB = GLenum::GL_CLIENT_ACTIVE_TEXTURE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_UNITS = GLenum::GL_MAX_TEXTURE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_UNITS_ARB = GLenum::GL_MAX_TEXTURE_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = GLenum::GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_MODELVIEW_MATRIX = GLenum::GL_TRANSPOSE_MODELVIEW_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = GLenum::GL_TRANSPOSE_MODELVIEW_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = GLenum::GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_PROJECTION_MATRIX = GLenum::GL_TRANSPOSE_PROJECTION_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_PROJECTION_MATRIX_ARB = GLenum::GL_TRANSPOSE_PROJECTION_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_TEXTURE_MATRIX = GLenum::GL_TRANSPOSE_TEXTURE_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_TEXTURE_MATRIX_ARB = GLenum::GL_TRANSPOSE_TEXTURE_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_COLOR_MATRIX = GLenum::GL_TRANSPOSE_COLOR_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_COLOR_MATRIX_ARB = GLenum::GL_TRANSPOSE_COLOR_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SUBTRACT = GLenum::GL_SUBTRACT;
GLBINDING_CONSTEXPR static const GLenum GL_SUBTRACT_ARB = GLenum::GL_SUBTRACT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RENDERBUFFER_SIZE = GLenum::GL_MAX_RENDERBUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RENDERBUFFER_SIZE_EXT = GLenum::GL_MAX_RENDERBUFFER_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_ALPHA = GLenum::GL_COMPRESSED_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_ALPHA_ARB = GLenum::GL_COMPRESSED_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE = GLenum::GL_COMPRESSED_LUMINANCE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ARB = GLenum::GL_COMPRESSED_LUMINANCE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ALPHA = GLenum::GL_COMPRESSED_LUMINANCE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ALPHA_ARB = GLenum::GL_COMPRESSED_LUMINANCE_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_INTENSITY = GLenum::GL_COMPRESSED_INTENSITY;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_INTENSITY_ARB = GLenum::GL_COMPRESSED_INTENSITY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_ARB = GLenum::GL_COMPRESSED_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ARB = GLenum::GL_COMPRESSED_RGBA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ALL_COMPLETED_NV = GLenum::GL_ALL_COMPLETED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FENCE_STATUS_NV = GLenum::GL_FENCE_STATUS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FENCE_CONDITION_NV = GLenum::GL_FENCE_CONDITION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE_ARB = GLenum::GL_TEXTURE_RECTANGLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE_NV = GLenum::GL_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_RECTANGLE = GLenum::GL_TEXTURE_BINDING_RECTANGLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_RECTANGLE_ARB = GLenum::GL_TEXTURE_BINDING_RECTANGLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_RECTANGLE_NV = GLenum::GL_TEXTURE_BINDING_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RECTANGLE_TEXTURE_SIZE = GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_24_8 = GLenum::GL_UNSIGNED_INT_24_8;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_24_8_EXT = GLenum::GL_UNSIGNED_INT_24_8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_24_8_NV = GLenum::GL_UNSIGNED_INT_24_8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_LOD_BIAS = GLenum::GL_MAX_TEXTURE_LOD_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_LOD_BIAS_EXT = GLenum::GL_MAX_TEXTURE_LOD_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_ANISOTROPY = GLenum::GL_TEXTURE_MAX_ANISOTROPY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_ANISOTROPY_EXT = GLenum::GL_TEXTURE_MAX_ANISOTROPY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_MAX_ANISOTROPY = GLenum::GL_MAX_TEXTURE_MAX_ANISOTROPY;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = GLenum::GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER_CONTROL = GLenum::GL_TEXTURE_FILTER_CONTROL;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER_CONTROL_EXT = GLenum::GL_TEXTURE_FILTER_CONTROL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_EXT = GLenum::GL_TEXTURE_LOD_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_STACK_DEPTH_EXT = GLenum::GL_MODELVIEW1_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE4_NV = GLenum::GL_COMBINE4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SHININESS_NV = GLenum::GL_MAX_SHININESS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SPOT_EXPONENT_NV = GLenum::GL_MAX_SPOT_EXPONENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_MATRIX_EXT = GLenum::GL_MODELVIEW1_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INCR_WRAP = GLenum::GL_INCR_WRAP;
GLBINDING_CONSTEXPR static const GLenum GL_INCR_WRAP_EXT = GLenum::GL_INCR_WRAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DECR_WRAP = GLenum::GL_DECR_WRAP;
GLBINDING_CONSTEXPR static const GLenum GL_DECR_WRAP_EXT = GLenum::GL_DECR_WRAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHTING_EXT = GLenum::GL_VERTEX_WEIGHTING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_ARB = GLenum::GL_MODELVIEW1_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_EXT = GLenum::GL_MODELVIEW1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_VERTEX_WEIGHT_EXT = GLenum::GL_CURRENT_VERTEX_WEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP = GLenum::GL_NORMAL_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP_ARB = GLenum::GL_NORMAL_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP_EXT = GLenum::GL_NORMAL_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP_NV = GLenum::GL_NORMAL_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP = GLenum::GL_REFLECTION_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP_ARB = GLenum::GL_REFLECTION_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP_EXT = GLenum::GL_REFLECTION_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP_NV = GLenum::GL_REFLECTION_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARB = GLenum::GL_TEXTURE_CUBE_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_EXT = GLenum::GL_TEXTURE_CUBE_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_CUBE_MAP = GLenum::GL_TEXTURE_BINDING_CUBE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_CUBE_MAP_ARB = GLenum::GL_TEXTURE_BINDING_CUBE_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_CUBE_MAP_EXT = GLenum::GL_TEXTURE_BINDING_CUBE_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CUBE_MAP_TEXTURE_SIZE = GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_APPLE = GLenum::GL_VERTEX_ARRAY_RANGE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_NV = GLenum::GL_VERTEX_ARRAY_RANGE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = GLenum::GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_LENGTH_NV = GLenum::GL_VERTEX_ARRAY_RANGE_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_VALID_NV = GLenum::GL_VERTEX_ARRAY_RANGE_VALID_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = GLenum::GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = GLenum::GL_VERTEX_ARRAY_RANGE_POINTER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_POINTER_NV = GLenum::GL_VERTEX_ARRAY_RANGE_POINTER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_REGISTER_COMBINERS_NV = GLenum::GL_REGISTER_COMBINERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_A_NV = GLenum::GL_VARIABLE_A_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_B_NV = GLenum::GL_VARIABLE_B_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_C_NV = GLenum::GL_VARIABLE_C_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_D_NV = GLenum::GL_VARIABLE_D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_E_NV = GLenum::GL_VARIABLE_E_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_F_NV = GLenum::GL_VARIABLE_F_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_G_NV = GLenum::GL_VARIABLE_G_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR0_NV = GLenum::GL_CONSTANT_COLOR0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR1_NV = GLenum::GL_CONSTANT_COLOR1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SPARE0_NV = GLenum::GL_SPARE0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SPARE1_NV = GLenum::GL_SPARE1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DISCARD_NV = GLenum::GL_DISCARD_NV;
GLBINDING_CONSTEXPR static const GLenum GL_E_TIMES_F_NV = GLenum::GL_E_TIMES_F_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SPARE0_PLUS_SECONDARY_COLOR_NV = GLenum::GL_SPARE0_PLUS_SECONDARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = GLenum::GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PER_STAGE_CONSTANTS_NV = GLenum::GL_PER_STAGE_CONSTANTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_IDENTITY_NV = GLenum::GL_UNSIGNED_IDENTITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INVERT_NV = GLenum::GL_UNSIGNED_INVERT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EXPAND_NORMAL_NV = GLenum::GL_EXPAND_NORMAL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EXPAND_NEGATE_NV = GLenum::GL_EXPAND_NEGATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_BIAS_NORMAL_NV = GLenum::GL_HALF_BIAS_NORMAL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_BIAS_NEGATE_NV = GLenum::GL_HALF_BIAS_NEGATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_IDENTITY_NV = GLenum::GL_SIGNED_IDENTITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_NEGATE_NV = GLenum::GL_SIGNED_NEGATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCALE_BY_TWO_NV = GLenum::GL_SCALE_BY_TWO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCALE_BY_FOUR_NV = GLenum::GL_SCALE_BY_FOUR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCALE_BY_ONE_HALF_NV = GLenum::GL_SCALE_BY_ONE_HALF_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = GLenum::GL_BIAS_BY_NEGATIVE_ONE_HALF_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_INPUT_NV = GLenum::GL_COMBINER_INPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_MAPPING_NV = GLenum::GL_COMBINER_MAPPING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_COMPONENT_USAGE_NV = GLenum::GL_COMBINER_COMPONENT_USAGE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_AB_DOT_PRODUCT_NV = GLenum::GL_COMBINER_AB_DOT_PRODUCT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_CD_DOT_PRODUCT_NV = GLenum::GL_COMBINER_CD_DOT_PRODUCT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_MUX_SUM_NV = GLenum::GL_COMBINER_MUX_SUM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_SCALE_NV = GLenum::GL_COMBINER_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_BIAS_NV = GLenum::GL_COMBINER_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_AB_OUTPUT_NV = GLenum::GL_COMBINER_AB_OUTPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_CD_OUTPUT_NV = GLenum::GL_COMBINER_CD_OUTPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_SUM_OUTPUT_NV = GLenum::GL_COMBINER_SUM_OUTPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GENERAL_COMBINERS_NV = GLenum::GL_MAX_GENERAL_COMBINERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_GENERAL_COMBINERS_NV = GLenum::GL_NUM_GENERAL_COMBINERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM_CLAMP_NV = GLenum::GL_COLOR_SUM_CLAMP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER0_NV = GLenum::GL_COMBINER0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER1_NV = GLenum::GL_COMBINER1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER2_NV = GLenum::GL_COMBINER2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER3_NV = GLenum::GL_COMBINER3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER4_NV = GLenum::GL_COMBINER4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER5_NV = GLenum::GL_COMBINER5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER6_NV = GLenum::GL_COMBINER6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER7_NV = GLenum::GL_COMBINER7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_NV = GLenum::GL_PRIMITIVE_RESTART_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_INDEX_NV = GLenum::GL_PRIMITIVE_RESTART_INDEX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_DISTANCE_MODE_NV = GLenum::GL_FOG_DISTANCE_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_RADIAL_NV = GLenum::GL_EYE_RADIAL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_PLANE_ABSOLUTE_NV = GLenum::GL_EYE_PLANE_ABSOLUTE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EMBOSS_LIGHT_NV = GLenum::GL_EMBOSS_LIGHT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EMBOSS_CONSTANT_NV = GLenum::GL_EMBOSS_CONSTANT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EMBOSS_MAP_NV = GLenum::GL_EMBOSS_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RED_MIN_CLAMP_INGR = GLenum::GL_RED_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_MIN_CLAMP_INGR = GLenum::GL_GREEN_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_MIN_CLAMP_INGR = GLenum::GL_BLUE_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MIN_CLAMP_INGR = GLenum::GL_ALPHA_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_RED_MAX_CLAMP_INGR = GLenum::GL_RED_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_MAX_CLAMP_INGR = GLenum::GL_GREEN_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_MAX_CLAMP_INGR = GLenum::GL_BLUE_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MAX_CLAMP_INGR = GLenum::GL_ALPHA_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_READ_INGR = GLenum::GL_INTERLACE_READ_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE = GLenum::GL_COMBINE;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ARB = GLenum::GL_COMBINE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_EXT = GLenum::GL_COMBINE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_RGB = GLenum::GL_COMBINE_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_RGB_ARB = GLenum::GL_COMBINE_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_RGB_EXT = GLenum::GL_COMBINE_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ALPHA = GLenum::GL_COMBINE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ALPHA_ARB = GLenum::GL_COMBINE_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ALPHA_EXT = GLenum::GL_COMBINE_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_SCALE = GLenum::GL_RGB_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_SCALE_ARB = GLenum::GL_RGB_SCALE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_SCALE_EXT = GLenum::GL_RGB_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_SIGNED = GLenum::GL_ADD_SIGNED;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_SIGNED_ARB = GLenum::GL_ADD_SIGNED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_SIGNED_EXT = GLenum::GL_ADD_SIGNED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTERPOLATE = GLenum::GL_INTERPOLATE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERPOLATE_ARB = GLenum::GL_INTERPOLATE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INTERPOLATE_EXT = GLenum::GL_INTERPOLATE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ARB = GLenum::GL_CONSTANT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_EXT = GLenum::GL_CONSTANT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_NV = GLenum::GL_CONSTANT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_ARB = GLenum::GL_PRIMARY_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_EXT = GLenum::GL_PRIMARY_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS = GLenum::GL_PREVIOUS;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS_ARB = GLenum::GL_PREVIOUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS_EXT = GLenum::GL_PREVIOUS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_RGB = GLenum::GL_SOURCE0_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_RGB_ARB = GLenum::GL_SOURCE0_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_RGB_EXT = GLenum::GL_SOURCE0_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC0_RGB = GLenum::GL_SRC0_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_RGB = GLenum::GL_SOURCE1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_RGB_ARB = GLenum::GL_SOURCE1_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_RGB_EXT = GLenum::GL_SOURCE1_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC1_RGB = GLenum::GL_SRC1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_RGB = GLenum::GL_SOURCE2_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_RGB_ARB = GLenum::GL_SOURCE2_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_RGB_EXT = GLenum::GL_SOURCE2_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC2_RGB = GLenum::GL_SRC2_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE3_RGB_NV = GLenum::GL_SOURCE3_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_ALPHA = GLenum::GL_SOURCE0_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_ALPHA_ARB = GLenum::GL_SOURCE0_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_ALPHA_EXT = GLenum::GL_SOURCE0_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC0_ALPHA = GLenum::GL_SRC0_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_ALPHA = GLenum::GL_SOURCE1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_ALPHA_ARB = GLenum::GL_SOURCE1_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_ALPHA_EXT = GLenum::GL_SOURCE1_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_ALPHA = GLenum::GL_SOURCE2_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_ALPHA_ARB = GLenum::GL_SOURCE2_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_ALPHA_EXT = GLenum::GL_SOURCE2_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC2_ALPHA = GLenum::GL_SRC2_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE3_ALPHA_NV = GLenum::GL_SOURCE3_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_RGB = GLenum::GL_OPERAND0_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_RGB_ARB = GLenum::GL_OPERAND0_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_RGB_EXT = GLenum::GL_OPERAND0_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_RGB = GLenum::GL_OPERAND1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_RGB_ARB = GLenum::GL_OPERAND1_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_RGB_EXT = GLenum::GL_OPERAND1_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_RGB = GLenum::GL_OPERAND2_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_RGB_ARB = GLenum::GL_OPERAND2_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_RGB_EXT = GLenum::GL_OPERAND2_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND3_RGB_NV = GLenum::GL_OPERAND3_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_ALPHA = GLenum::GL_OPERAND0_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_ALPHA_ARB = GLenum::GL_OPERAND0_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_ALPHA_EXT = GLenum::GL_OPERAND0_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_ALPHA = GLenum::GL_OPERAND1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_ALPHA_ARB = GLenum::GL_OPERAND1_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_ALPHA_EXT = GLenum::GL_OPERAND1_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_ALPHA = GLenum::GL_OPERAND2_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_ALPHA_ARB = GLenum::GL_OPERAND2_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_ALPHA_EXT = GLenum::GL_OPERAND2_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND3_ALPHA_NV = GLenum::GL_OPERAND3_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PERTURB_EXT = GLenum::GL_PERTURB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_NORMAL_EXT = GLenum::GL_TEXTURE_NORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = GLenum::GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CLIENT_STORAGE_APPLE = GLenum::GL_UNPACK_CLIENT_STORAGE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_OBJECT_APPLE = GLenum::GL_BUFFER_OBJECT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_STORAGE_CLIENT_APPLE = GLenum::GL_STORAGE_CLIENT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_BINDING = GLenum::GL_VERTEX_ARRAY_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_BINDING_APPLE = GLenum::GL_VERTEX_ARRAY_BINDING_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RANGE_LENGTH_APPLE = GLenum::GL_TEXTURE_RANGE_LENGTH_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RANGE_POINTER_APPLE = GLenum::GL_TEXTURE_RANGE_POINTER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_YCBCR_422_APPLE = GLenum::GL_YCBCR_422_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_APPLE = GLenum::GL_UNSIGNED_SHORT_8_8_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_MESA = GLenum::GL_UNSIGNED_SHORT_8_8_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_REV_APPLE = GLenum::GL_UNSIGNED_SHORT_8_8_REV_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_REV_MESA = GLenum::GL_UNSIGNED_SHORT_8_8_REV_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_STORAGE_PRIVATE_APPLE = GLenum::GL_STORAGE_PRIVATE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_STORAGE_CACHED_APPLE = GLenum::GL_STORAGE_CACHED_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_STORAGE_SHARED_APPLE = GLenum::GL_STORAGE_SHARED_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_V3F_SUN = GLenum::GL_R1UI_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_C4UB_V3F_SUN = GLenum::GL_R1UI_C4UB_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_C3F_V3F_SUN = GLenum::GL_R1UI_C3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_N3F_V3F_SUN = GLenum::GL_R1UI_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_C4F_N3F_V3F_SUN = GLenum::GL_R1UI_C4F_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_T2F_V3F_SUN = GLenum::GL_R1UI_T2F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_T2F_N3F_V3F_SUN = GLenum::GL_R1UI_T2F_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_T2F_C4F_N3F_V3F_SUN = GLenum::GL_R1UI_T2F_C4F_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_SLICE_ACCUM_SUN = GLenum::GL_SLICE_ACCUM_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_MESH_SUN = GLenum::GL_QUAD_MESH_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_MESH_SUN = GLenum::GL_TRIANGLE_MESH_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_ARB = GLenum::GL_VERTEX_PROGRAM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_NV = GLenum::GL_VERTEX_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STATE_PROGRAM_NV = GLenum::GL_VERTEX_STATE_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_SIZE_NV = GLenum::GL_ATTRIB_ARRAY_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_STRIDE_NV = GLenum::GL_ATTRIB_ARRAY_STRIDE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_TYPE_NV = GLenum::GL_ATTRIB_ARRAY_TYPE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_ATTRIB_NV = GLenum::GL_CURRENT_ATTRIB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_VERTEX_ATTRIB_ARB = GLenum::GL_CURRENT_VERTEX_ATTRIB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_LENGTH_ARB = GLenum::GL_PROGRAM_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_LENGTH_NV = GLenum::GL_PROGRAM_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_STRING_ARB = GLenum::GL_PROGRAM_STRING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_STRING_NV = GLenum::GL_PROGRAM_STRING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW_PROJECTION_NV = GLenum::GL_MODELVIEW_PROJECTION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_IDENTITY_NV = GLenum::GL_IDENTITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_INVERSE_NV = GLenum::GL_INVERSE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_NV = GLenum::GL_TRANSPOSE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_INVERSE_TRANSPOSE_NV = GLenum::GL_INVERSE_TRANSPOSE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = GLenum::GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = GLenum::GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_MATRICES_ARB = GLenum::GL_MAX_PROGRAM_MATRICES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRACK_MATRICES_NV = GLenum::GL_MAX_TRACK_MATRICES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX0_NV = GLenum::GL_MATRIX0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX1_NV = GLenum::GL_MATRIX1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX2_NV = GLenum::GL_MATRIX2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX3_NV = GLenum::GL_MATRIX3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX4_NV = GLenum::GL_MATRIX4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX5_NV = GLenum::GL_MATRIX5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX6_NV = GLenum::GL_MATRIX6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX7_NV = GLenum::GL_MATRIX7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_STACK_DEPTH_ARB = GLenum::GL_CURRENT_MATRIX_STACK_DEPTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_STACK_DEPTH_NV = GLenum::GL_CURRENT_MATRIX_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_ARB = GLenum::GL_CURRENT_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_NV = GLenum::GL_CURRENT_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE = GLenum::GL_PROGRAM_POINT_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE_ARB = GLenum::GL_PROGRAM_POINT_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE_EXT = GLenum::GL_PROGRAM_POINT_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_POINT_SIZE = GLenum::GL_VERTEX_PROGRAM_POINT_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_POINT_SIZE_ARB = GLenum::GL_VERTEX_PROGRAM_POINT_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_POINT_SIZE_NV = GLenum::GL_VERTEX_PROGRAM_POINT_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_TWO_SIDE = GLenum::GL_VERTEX_PROGRAM_TWO_SIDE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_TWO_SIDE_ARB = GLenum::GL_VERTEX_PROGRAM_TWO_SIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_TWO_SIDE_NV = GLenum::GL_VERTEX_PROGRAM_TWO_SIDE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PARAMETER_NV = GLenum::GL_PROGRAM_PARAMETER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_POINTER_NV = GLenum::GL_ATTRIB_ARRAY_POINTER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_POINTER = GLenum::GL_VERTEX_ATTRIB_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_TARGET_NV = GLenum::GL_PROGRAM_TARGET_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_RESIDENT_NV = GLenum::GL_PROGRAM_RESIDENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRACK_MATRIX_NV = GLenum::GL_TRACK_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRACK_MATRIX_TRANSFORM_NV = GLenum::GL_TRACK_MATRIX_TRANSFORM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_BINDING_NV = GLenum::GL_VERTEX_PROGRAM_BINDING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ERROR_POSITION_ARB = GLenum::GL_PROGRAM_ERROR_POSITION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ERROR_POSITION_NV = GLenum::GL_PROGRAM_ERROR_POSITION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_RECTANGLE_NV = GLenum::GL_OFFSET_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = GLenum::GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_CLAMP = GLenum::GL_DEPTH_CLAMP;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_CLAMP_NV = GLenum::GL_DEPTH_CLAMP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY0_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY1_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY2_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY3_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY4_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY5_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY6_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY7_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY8_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY9_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY9_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY10_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY10_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY11_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY11_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY12_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY12_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY13_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY13_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY14_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY14_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY15_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY15_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB0_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB0_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB1_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB1_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB2_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB2_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB3_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB3_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB4_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB4_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB5_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB5_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB6_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB6_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB7_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB7_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB8_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB8_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB9_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB9_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB10_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB10_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB11_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB11_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB12_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB12_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB13_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB13_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB14_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB14_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB15_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB15_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB0_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB0_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB1_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB1_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB2_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB2_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB3_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB3_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB4_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB4_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB5_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB5_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB6_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB6_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB7_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB7_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINDING_ARB = GLenum::GL_PROGRAM_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB8_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB8_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB9_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB9_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB10_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB10_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB11_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB11_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB12_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB12_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB13_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB13_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB14_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB14_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB15_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB15_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_IMAGE_SIZE = GLenum::GL_TEXTURE_COMPRESSED_IMAGE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = GLenum::GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_ARB = GLenum::GL_TEXTURE_COMPRESSED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPRESSED_TEXTURE_FORMATS = GLenum::GL_NUM_COMPRESSED_TEXTURE_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = GLenum::GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_TEXTURE_FORMATS = GLenum::GL_COMPRESSED_TEXTURE_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_TEXTURE_FORMATS_ARB = GLenum::GL_COMPRESSED_TEXTURE_FORMATS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNITS_ARB = GLenum::GL_MAX_VERTEX_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_VERTEX_UNITS_ARB = GLenum::GL_ACTIVE_VERTEX_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_SUM_UNITY_ARB = GLenum::GL_WEIGHT_SUM_UNITY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BLEND_ARB = GLenum::GL_VERTEX_BLEND_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_WEIGHT_ARB = GLenum::GL_CURRENT_WEIGHT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_TYPE_ARB = GLenum::GL_WEIGHT_ARRAY_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_STRIDE_ARB = GLenum::GL_WEIGHT_ARRAY_STRIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_SIZE_ARB = GLenum::GL_WEIGHT_ARRAY_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_POINTER_ARB = GLenum::GL_WEIGHT_ARRAY_POINTER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_ARB = GLenum::GL_WEIGHT_ARRAY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGB = GLenum::GL_DOT3_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGB_ARB = GLenum::GL_DOT3_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGBA = GLenum::GL_DOT3_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGBA_ARB = GLenum::GL_DOT3_RGBA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_FXT1_3DFX = GLenum::GL_COMPRESSED_RGB_FXT1_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_FXT1_3DFX = GLenum::GL_COMPRESSED_RGBA_FXT1_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_3DFX = GLenum::GL_MULTISAMPLE_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_3DFX = GLenum::GL_SAMPLE_BUFFERS_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_3DFX = GLenum::GL_SAMPLES_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_2D_NV = GLenum::GL_EVAL_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_TRIANGULAR_2D_NV = GLenum::GL_EVAL_TRIANGULAR_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_TESSELLATION_NV = GLenum::GL_MAP_TESSELLATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_ATTRIB_U_ORDER_NV = GLenum::GL_MAP_ATTRIB_U_ORDER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_ATTRIB_V_ORDER_NV = GLenum::GL_MAP_ATTRIB_V_ORDER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_FRACTIONAL_TESSELLATION_NV = GLenum::GL_EVAL_FRACTIONAL_TESSELLATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB0_NV = GLenum::GL_EVAL_VERTEX_ATTRIB0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB1_NV = GLenum::GL_EVAL_VERTEX_ATTRIB1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB2_NV = GLenum::GL_EVAL_VERTEX_ATTRIB2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB3_NV = GLenum::GL_EVAL_VERTEX_ATTRIB3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB4_NV = GLenum::GL_EVAL_VERTEX_ATTRIB4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB5_NV = GLenum::GL_EVAL_VERTEX_ATTRIB5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB6_NV = GLenum::GL_EVAL_VERTEX_ATTRIB6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB7_NV = GLenum::GL_EVAL_VERTEX_ATTRIB7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB8_NV = GLenum::GL_EVAL_VERTEX_ATTRIB8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB9_NV = GLenum::GL_EVAL_VERTEX_ATTRIB9_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB10_NV = GLenum::GL_EVAL_VERTEX_ATTRIB10_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB11_NV = GLenum::GL_EVAL_VERTEX_ATTRIB11_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB12_NV = GLenum::GL_EVAL_VERTEX_ATTRIB12_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB13_NV = GLenum::GL_EVAL_VERTEX_ATTRIB13_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB14_NV = GLenum::GL_EVAL_VERTEX_ATTRIB14_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB15_NV = GLenum::GL_EVAL_VERTEX_ATTRIB15_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_MAP_TESSELLATION_NV = GLenum::GL_MAX_MAP_TESSELLATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RATIONAL_EVAL_ORDER_NV = GLenum::GL_MAX_RATIONAL_EVAL_ORDER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_PATCH_ATTRIBS_NV = GLenum::GL_MAX_PROGRAM_PATCH_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = GLenum::GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_S8_S8_8_8_NV = GLenum::GL_UNSIGNED_INT_S8_S8_8_8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = GLenum::GL_UNSIGNED_INT_8_8_S8_S8_REV_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_MAG_INTENSITY_NV = GLenum::GL_DSDT_MAG_INTENSITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_CONSISTENT_NV = GLenum::GL_SHADER_CONSISTENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SHADER_NV = GLenum::GL_TEXTURE_SHADER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_OPERATION_NV = GLenum::GL_SHADER_OPERATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_MODES_NV = GLenum::GL_CULL_MODES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_MATRIX_NV = GLenum::GL_OFFSET_TEXTURE_2D_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_MATRIX_NV = GLenum::GL_OFFSET_TEXTURE_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_SCALE_NV = GLenum::GL_OFFSET_TEXTURE_2D_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_SCALE_NV = GLenum::GL_OFFSET_TEXTURE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_BIAS_NV = GLenum::GL_OFFSET_TEXTURE_2D_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_BIAS_NV = GLenum::GL_OFFSET_TEXTURE_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS_TEXTURE_INPUT_NV = GLenum::GL_PREVIOUS_TEXTURE_INPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONST_EYE_NV = GLenum::GL_CONST_EYE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PASS_THROUGH_NV = GLenum::GL_PASS_THROUGH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_FRAGMENT_NV = GLenum::GL_CULL_FRAGMENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_NV = GLenum::GL_OFFSET_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_AR_TEXTURE_2D_NV = GLenum::GL_DEPENDENT_AR_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_GB_TEXTURE_2D_NV = GLenum::GL_DEPENDENT_GB_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SURFACE_STATE_NV = GLenum::GL_SURFACE_STATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_NV = GLenum::GL_DOT_PRODUCT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_DEPTH_REPLACE_NV = GLenum::GL_DOT_PRODUCT_DEPTH_REPLACE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_2D_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_3D_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HILO_NV = GLenum::GL_HILO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_NV = GLenum::GL_DSDT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_MAG_NV = GLenum::GL_DSDT_MAG_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_MAG_VIB_NV = GLenum::GL_DSDT_MAG_VIB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HILO16_NV = GLenum::GL_HILO16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_HILO_NV = GLenum::GL_SIGNED_HILO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_HILO16_NV = GLenum::GL_SIGNED_HILO16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGBA_NV = GLenum::GL_SIGNED_RGBA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGBA8_NV = GLenum::GL_SIGNED_RGBA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SURFACE_REGISTERED_NV = GLenum::GL_SURFACE_REGISTERED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB_NV = GLenum::GL_SIGNED_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB8_NV = GLenum::GL_SIGNED_RGB8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SURFACE_MAPPED_NV = GLenum::GL_SURFACE_MAPPED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE_NV = GLenum::GL_SIGNED_LUMINANCE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE8_NV = GLenum::GL_SIGNED_LUMINANCE8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE_ALPHA_NV = GLenum::GL_SIGNED_LUMINANCE_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE8_ALPHA8_NV = GLenum::GL_SIGNED_LUMINANCE8_ALPHA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_ALPHA_NV = GLenum::GL_SIGNED_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_ALPHA8_NV = GLenum::GL_SIGNED_ALPHA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_INTENSITY_NV = GLenum::GL_SIGNED_INTENSITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_INTENSITY8_NV = GLenum::GL_SIGNED_INTENSITY8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT8_NV = GLenum::GL_DSDT8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT8_MAG8_NV = GLenum::GL_DSDT8_MAG8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT8_MAG8_INTENSITY8_NV = GLenum::GL_DSDT8_MAG8_INTENSITY8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = GLenum::GL_SIGNED_RGB_UNSIGNED_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = GLenum::GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HI_SCALE_NV = GLenum::GL_HI_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LO_SCALE_NV = GLenum::GL_LO_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DS_SCALE_NV = GLenum::GL_DS_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DT_SCALE_NV = GLenum::GL_DT_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAGNITUDE_SCALE_NV = GLenum::GL_MAGNITUDE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VIBRANCE_SCALE_NV = GLenum::GL_VIBRANCE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HI_BIAS_NV = GLenum::GL_HI_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LO_BIAS_NV = GLenum::GL_LO_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DS_BIAS_NV = GLenum::GL_DS_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DT_BIAS_NV = GLenum::GL_DT_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAGNITUDE_BIAS_NV = GLenum::GL_MAGNITUDE_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VIBRANCE_BIAS_NV = GLenum::GL_VIBRANCE_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_VALUES_NV = GLenum::GL_TEXTURE_BORDER_VALUES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_HI_SIZE_NV = GLenum::GL_TEXTURE_HI_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LO_SIZE_NV = GLenum::GL_TEXTURE_LO_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DS_SIZE_NV = GLenum::GL_TEXTURE_DS_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DT_SIZE_NV = GLenum::GL_TEXTURE_DT_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_SIZE_NV = GLenum::GL_TEXTURE_MAG_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW2_ARB = GLenum::GL_MODELVIEW2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW3_ARB = GLenum::GL_MODELVIEW3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW4_ARB = GLenum::GL_MODELVIEW4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW5_ARB = GLenum::GL_MODELVIEW5_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW6_ARB = GLenum::GL_MODELVIEW6_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW7_ARB = GLenum::GL_MODELVIEW7_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW8_ARB = GLenum::GL_MODELVIEW8_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW9_ARB = GLenum::GL_MODELVIEW9_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW10_ARB = GLenum::GL_MODELVIEW10_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW11_ARB = GLenum::GL_MODELVIEW11_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW12_ARB = GLenum::GL_MODELVIEW12_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW13_ARB = GLenum::GL_MODELVIEW13_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW14_ARB = GLenum::GL_MODELVIEW14_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW15_ARB = GLenum::GL_MODELVIEW15_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW16_ARB = GLenum::GL_MODELVIEW16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW17_ARB = GLenum::GL_MODELVIEW17_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW18_ARB = GLenum::GL_MODELVIEW18_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW19_ARB = GLenum::GL_MODELVIEW19_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW20_ARB = GLenum::GL_MODELVIEW20_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW21_ARB = GLenum::GL_MODELVIEW21_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW22_ARB = GLenum::GL_MODELVIEW22_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW23_ARB = GLenum::GL_MODELVIEW23_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW24_ARB = GLenum::GL_MODELVIEW24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW25_ARB = GLenum::GL_MODELVIEW25_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW26_ARB = GLenum::GL_MODELVIEW26_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW27_ARB = GLenum::GL_MODELVIEW27_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW28_ARB = GLenum::GL_MODELVIEW28_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW29_ARB = GLenum::GL_MODELVIEW29_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW30_ARB = GLenum::GL_MODELVIEW30_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW31_ARB = GLenum::GL_MODELVIEW31_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGB_EXT = GLenum::GL_DOT3_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGBA_EXT = GLenum::GL_DOT3_RGBA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_ATI = GLenum::GL_MIRROR_CLAMP_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_EXT = GLenum::GL_MIRROR_CLAMP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_EDGE = GLenum::GL_MIRROR_CLAMP_TO_EDGE;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_EDGE_ATI = GLenum::GL_MIRROR_CLAMP_TO_EDGE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_EDGE_EXT = GLenum::GL_MIRROR_CLAMP_TO_EDGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE_ADD_ATI = GLenum::GL_MODULATE_ADD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE_SIGNED_ADD_ATI = GLenum::GL_MODULATE_SIGNED_ADD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE_SUBTRACT_ATI = GLenum::GL_MODULATE_SUBTRACT_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SET_AMD = GLenum::GL_SET_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_VALUE_AMD = GLenum::GL_REPLACE_VALUE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_OP_VALUE_AMD = GLenum::GL_STENCIL_OP_VALUE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_OP_VALUE_AMD = GLenum::GL_STENCIL_BACK_OP_VALUE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_OCCLUSION_QUERY_EVENT_MASK_AMD = GLenum::GL_OCCLUSION_QUERY_EVENT_MASK_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_YCBCR_MESA = GLenum::GL_YCBCR_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_INVERT_MESA = GLenum::GL_PACK_INVERT_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_STACK_MESAX = GLenum::GL_TEXTURE_1D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_STACK_MESAX = GLenum::GL_TEXTURE_2D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_STACK_MESAX = GLenum::GL_PROXY_TEXTURE_1D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_STACK_MESAX = GLenum::GL_PROXY_TEXTURE_2D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_STACK_BINDING_MESAX = GLenum::GL_TEXTURE_1D_STACK_BINDING_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_STACK_BINDING_MESAX = GLenum::GL_TEXTURE_2D_STACK_BINDING_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_FORMAT_MESA = GLenum::GL_PROGRAM_BINARY_FORMAT_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_ATI = GLenum::GL_STATIC_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_ATI = GLenum::GL_DYNAMIC_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PRESERVE_ATI = GLenum::GL_PRESERVE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DISCARD_ATI = GLenum::GL_DISCARD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_SIZE_ARB = GLenum::GL_BUFFER_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_BUFFER_SIZE_ATI = GLenum::GL_OBJECT_BUFFER_SIZE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_USAGE_ARB = GLenum::GL_BUFFER_USAGE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_BUFFER_USAGE_ATI = GLenum::GL_OBJECT_BUFFER_USAGE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_OBJECT_BUFFER_ATI = GLenum::GL_ARRAY_OBJECT_BUFFER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_OBJECT_OFFSET_ATI = GLenum::GL_ARRAY_OBJECT_OFFSET_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_ATI = GLenum::GL_ELEMENT_ARRAY_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_TYPE_ATI = GLenum::GL_ELEMENT_ARRAY_TYPE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_POINTER_ATI = GLenum::GL_ELEMENT_ARRAY_POINTER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_STREAMS_ATI = GLenum::GL_MAX_VERTEX_STREAMS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM0_ATI = GLenum::GL_VERTEX_STREAM0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM1_ATI = GLenum::GL_VERTEX_STREAM1_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM2_ATI = GLenum::GL_VERTEX_STREAM2_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM3_ATI = GLenum::GL_VERTEX_STREAM3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM4_ATI = GLenum::GL_VERTEX_STREAM4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM5_ATI = GLenum::GL_VERTEX_STREAM5_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM6_ATI = GLenum::GL_VERTEX_STREAM6_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STREAM7_ATI = GLenum::GL_VERTEX_STREAM7_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SOURCE_ATI = GLenum::GL_VERTEX_SOURCE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ROT_MATRIX_ATI = GLenum::GL_BUMP_ROT_MATRIX_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ROT_MATRIX_SIZE_ATI = GLenum::GL_BUMP_ROT_MATRIX_SIZE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_NUM_TEX_UNITS_ATI = GLenum::GL_BUMP_NUM_TEX_UNITS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_TEX_UNITS_ATI = GLenum::GL_BUMP_TEX_UNITS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DUDV_ATI = GLenum::GL_DUDV_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DU8DV8_ATI = GLenum::GL_DU8DV8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ENVMAP_ATI = GLenum::GL_BUMP_ENVMAP_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_TARGET_ATI = GLenum::GL_BUMP_TARGET_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_EXT = GLenum::GL_VERTEX_SHADER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_BINDING_EXT = GLenum::GL_VERTEX_SHADER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_INDEX_EXT = GLenum::GL_OP_INDEX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_NEGATE_EXT = GLenum::GL_OP_NEGATE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_DOT3_EXT = GLenum::GL_OP_DOT3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_DOT4_EXT = GLenum::GL_OP_DOT4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_MUL_EXT = GLenum::GL_OP_MUL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_ADD_EXT = GLenum::GL_OP_ADD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_MADD_EXT = GLenum::GL_OP_MADD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_FRAC_EXT = GLenum::GL_OP_FRAC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_MAX_EXT = GLenum::GL_OP_MAX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_MIN_EXT = GLenum::GL_OP_MIN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_SET_GE_EXT = GLenum::GL_OP_SET_GE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_SET_LT_EXT = GLenum::GL_OP_SET_LT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_CLAMP_EXT = GLenum::GL_OP_CLAMP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_FLOOR_EXT = GLenum::GL_OP_FLOOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_ROUND_EXT = GLenum::GL_OP_ROUND_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_EXP_BASE_2_EXT = GLenum::GL_OP_EXP_BASE_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_LOG_BASE_2_EXT = GLenum::GL_OP_LOG_BASE_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_POWER_EXT = GLenum::GL_OP_POWER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_RECIP_EXT = GLenum::GL_OP_RECIP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_RECIP_SQRT_EXT = GLenum::GL_OP_RECIP_SQRT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_SUB_EXT = GLenum::GL_OP_SUB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_CROSS_PRODUCT_EXT = GLenum::GL_OP_CROSS_PRODUCT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_MULTIPLY_MATRIX_EXT = GLenum::GL_OP_MULTIPLY_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OP_MOV_EXT = GLenum::GL_OP_MOV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_VERTEX_EXT = GLenum::GL_OUTPUT_VERTEX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_COLOR0_EXT = GLenum::GL_OUTPUT_COLOR0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_COLOR1_EXT = GLenum::GL_OUTPUT_COLOR1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD0_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD1_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD2_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD3_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD4_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD5_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD6_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD6_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD7_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD7_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD8_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD9_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD9_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD10_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD10_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD11_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD11_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD12_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD13_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD13_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD14_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD14_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD15_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD15_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD16_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD17_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD17_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD18_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD18_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD19_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD19_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD20_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD20_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD21_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD21_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD22_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD22_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD23_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD23_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD24_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD24_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD25_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD25_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD26_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD26_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD27_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD27_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD28_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD28_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD29_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD29_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD30_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD30_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD31_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD31_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_FOG_EXT = GLenum::GL_OUTPUT_FOG_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SCALAR_EXT = GLenum::GL_SCALAR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VECTOR_EXT = GLenum::GL_VECTOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_EXT = GLenum::GL_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_EXT = GLenum::GL_VARIANT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INVARIANT_EXT = GLenum::GL_INVARIANT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LOCAL_CONSTANT_EXT = GLenum::GL_LOCAL_CONSTANT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LOCAL_EXT = GLenum::GL_LOCAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = GLenum::GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_VARIANTS_EXT = GLenum::GL_MAX_VERTEX_SHADER_VARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = GLenum::GL_MAX_VERTEX_SHADER_INVARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = GLenum::GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_LOCALS_EXT = GLenum::GL_MAX_VERTEX_SHADER_LOCALS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_INSTRUCTIONS_EXT = GLenum::GL_VERTEX_SHADER_INSTRUCTIONS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_VARIANTS_EXT = GLenum::GL_VERTEX_SHADER_VARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_INVARIANTS_EXT = GLenum::GL_VERTEX_SHADER_INVARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = GLenum::GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_LOCALS_EXT = GLenum::GL_VERTEX_SHADER_LOCALS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_OPTIMIZED_EXT = GLenum::GL_VERTEX_SHADER_OPTIMIZED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_X_EXT = GLenum::GL_X_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_Y_EXT = GLenum::GL_Y_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_Z_EXT = GLenum::GL_Z_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_W_EXT = GLenum::GL_W_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_X_EXT = GLenum::GL_NEGATIVE_X_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_Y_EXT = GLenum::GL_NEGATIVE_Y_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_Z_EXT = GLenum::GL_NEGATIVE_Z_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_W_EXT = GLenum::GL_NEGATIVE_W_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ZERO_EXT = GLenum::GL_ZERO_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_EXT = GLenum::GL_ONE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_ONE_EXT = GLenum::GL_NEGATIVE_ONE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMALIZED_RANGE_EXT = GLenum::GL_NORMALIZED_RANGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FULL_RANGE_EXT = GLenum::GL_FULL_RANGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_VERTEX_EXT = GLenum::GL_CURRENT_VERTEX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MVP_MATRIX_EXT = GLenum::GL_MVP_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_VALUE_EXT = GLenum::GL_VARIANT_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_DATATYPE_EXT = GLenum::GL_VARIANT_DATATYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_ARRAY_STRIDE_EXT = GLenum::GL_VARIANT_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_ARRAY_TYPE_EXT = GLenum::GL_VARIANT_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_ARRAY_EXT = GLenum::GL_VARIANT_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_ARRAY_POINTER_EXT = GLenum::GL_VARIANT_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INVARIANT_VALUE_EXT = GLenum::GL_INVARIANT_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INVARIANT_DATATYPE_EXT = GLenum::GL_INVARIANT_DATATYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LOCAL_CONSTANT_VALUE_EXT = GLenum::GL_LOCAL_CONSTANT_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LOCAL_CONSTANT_DATATYPE_EXT = GLenum::GL_LOCAL_CONSTANT_DATATYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_ATI = GLenum::GL_PN_TRIANGLES_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = GLenum::GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_POINT_MODE_ATI = GLenum::GL_PN_TRIANGLES_POINT_MODE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_NORMAL_MODE_ATI = GLenum::GL_PN_TRIANGLES_NORMAL_MODE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = GLenum::GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = GLenum::GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = GLenum::GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = GLenum::GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = GLenum::GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VBO_FREE_MEMORY_ATI = GLenum::GL_VBO_FREE_MEMORY_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FREE_MEMORY_ATI = GLenum::GL_TEXTURE_FREE_MEMORY_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_FREE_MEMORY_ATI = GLenum::GL_RENDERBUFFER_FREE_MEMORY_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_PROGRAM_BINARY_FORMATS = GLenum::GL_NUM_PROGRAM_BINARY_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_FORMATS = GLenum::GL_PROGRAM_BINARY_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_FUNC = GLenum::GL_STENCIL_BACK_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_FUNC_ATI = GLenum::GL_STENCIL_BACK_FUNC_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_FAIL = GLenum::GL_STENCIL_BACK_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_FAIL_ATI = GLenum::GL_STENCIL_BACK_FAIL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_PASS_DEPTH_FAIL = GLenum::GL_STENCIL_BACK_PASS_DEPTH_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = GLenum::GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_PASS_DEPTH_PASS = GLenum::GL_STENCIL_BACK_PASS_DEPTH_PASS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = GLenum::GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_PROGRAM_ARB = GLenum::GL_FRAGMENT_PROGRAM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ALU_INSTRUCTIONS_ARB = GLenum::GL_PROGRAM_ALU_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_TEX_INSTRUCTIONS_ARB = GLenum::GL_PROGRAM_TEX_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_TEX_INDIRECTIONS_ARB = GLenum::GL_PROGRAM_TEX_INDIRECTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = GLenum::GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = GLenum::GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = GLenum::GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = GLenum::GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = GLenum::GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = GLenum::GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_FLOAT32_APPLE = GLenum::GL_RGBA_FLOAT32_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_FLOAT32_ATI = GLenum::GL_RGBA_FLOAT32_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32F = GLenum::GL_RGB32F;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32F_ARB = GLenum::GL_RGB32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_FLOAT32_APPLE = GLenum::GL_RGB_FLOAT32_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_FLOAT32_ATI = GLenum::GL_RGB_FLOAT32_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32F_ARB = GLenum::GL_ALPHA32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_FLOAT32_APPLE = GLenum::GL_ALPHA_FLOAT32_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_FLOAT32_ATI = GLenum::GL_ALPHA_FLOAT32_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32F_ARB = GLenum::GL_INTENSITY32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY_FLOAT32_APPLE = GLenum::GL_INTENSITY_FLOAT32_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY_FLOAT32_ATI = GLenum::GL_INTENSITY_FLOAT32_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32F_ARB = GLenum::GL_LUMINANCE32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_FLOAT32_APPLE = GLenum::GL_LUMINANCE_FLOAT32_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_FLOAT32_ATI = GLenum::GL_LUMINANCE_FLOAT32_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32F_ARB = GLenum::GL_LUMINANCE_ALPHA32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA_FLOAT32_APPLE = GLenum::GL_LUMINANCE_ALPHA_FLOAT32_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA_FLOAT32_ATI = GLenum::GL_LUMINANCE_ALPHA_FLOAT32_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_FLOAT16_APPLE = GLenum::GL_RGBA_FLOAT16_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_FLOAT16_ATI = GLenum::GL_RGBA_FLOAT16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_FLOAT16_APPLE = GLenum::GL_RGB_FLOAT16_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_FLOAT16_ATI = GLenum::GL_RGB_FLOAT16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16F_ARB = GLenum::GL_ALPHA16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_FLOAT16_APPLE = GLenum::GL_ALPHA_FLOAT16_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_FLOAT16_ATI = GLenum::GL_ALPHA_FLOAT16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16F_ARB = GLenum::GL_INTENSITY16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY_FLOAT16_APPLE = GLenum::GL_INTENSITY_FLOAT16_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY_FLOAT16_ATI = GLenum::GL_INTENSITY_FLOAT16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16F_ARB = GLenum::GL_LUMINANCE16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_FLOAT16_APPLE = GLenum::GL_LUMINANCE_FLOAT16_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_FLOAT16_ATI = GLenum::GL_LUMINANCE_FLOAT16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16F_ARB = GLenum::GL_LUMINANCE_ALPHA16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA_FLOAT16_APPLE = GLenum::GL_LUMINANCE_ALPHA_FLOAT16_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA_FLOAT16_ATI = GLenum::GL_LUMINANCE_ALPHA_FLOAT16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_FLOAT_MODE_ARB = GLenum::GL_RGBA_FLOAT_MODE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_FLOAT_MODE_ATI = GLenum::GL_RGBA_FLOAT_MODE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DRAW_BUFFERS = GLenum::GL_MAX_DRAW_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DRAW_BUFFERS_ARB = GLenum::GL_MAX_DRAW_BUFFERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DRAW_BUFFERS_ATI = GLenum::GL_MAX_DRAW_BUFFERS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER0 = GLenum::GL_DRAW_BUFFER0;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER0_ARB = GLenum::GL_DRAW_BUFFER0_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER0_ATI = GLenum::GL_DRAW_BUFFER0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER1 = GLenum::GL_DRAW_BUFFER1;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER1_ARB = GLenum::GL_DRAW_BUFFER1_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER1_ATI = GLenum::GL_DRAW_BUFFER1_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER2 = GLenum::GL_DRAW_BUFFER2;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER2_ARB = GLenum::GL_DRAW_BUFFER2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER2_ATI = GLenum::GL_DRAW_BUFFER2_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER3 = GLenum::GL_DRAW_BUFFER3;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER3_ARB = GLenum::GL_DRAW_BUFFER3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER3_ATI = GLenum::GL_DRAW_BUFFER3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER4 = GLenum::GL_DRAW_BUFFER4;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER4_ARB = GLenum::GL_DRAW_BUFFER4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER4_ATI = GLenum::GL_DRAW_BUFFER4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER5 = GLenum::GL_DRAW_BUFFER5;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER5_ARB = GLenum::GL_DRAW_BUFFER5_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER5_ATI = GLenum::GL_DRAW_BUFFER5_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER6 = GLenum::GL_DRAW_BUFFER6;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER6_ARB = GLenum::GL_DRAW_BUFFER6_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER6_ATI = GLenum::GL_DRAW_BUFFER6_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER7 = GLenum::GL_DRAW_BUFFER7;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER7_ARB = GLenum::GL_DRAW_BUFFER7_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER7_ATI = GLenum::GL_DRAW_BUFFER7_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER8 = GLenum::GL_DRAW_BUFFER8;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER8_ARB = GLenum::GL_DRAW_BUFFER8_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER8_ATI = GLenum::GL_DRAW_BUFFER8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER9 = GLenum::GL_DRAW_BUFFER9;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER9_ARB = GLenum::GL_DRAW_BUFFER9_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER9_ATI = GLenum::GL_DRAW_BUFFER9_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER10 = GLenum::GL_DRAW_BUFFER10;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER10_ARB = GLenum::GL_DRAW_BUFFER10_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER10_ATI = GLenum::GL_DRAW_BUFFER10_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER11 = GLenum::GL_DRAW_BUFFER11;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER11_ARB = GLenum::GL_DRAW_BUFFER11_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER11_ATI = GLenum::GL_DRAW_BUFFER11_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER12 = GLenum::GL_DRAW_BUFFER12;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER12_ARB = GLenum::GL_DRAW_BUFFER12_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER12_ATI = GLenum::GL_DRAW_BUFFER12_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER13 = GLenum::GL_DRAW_BUFFER13;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER13_ARB = GLenum::GL_DRAW_BUFFER13_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER13_ATI = GLenum::GL_DRAW_BUFFER13_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER14 = GLenum::GL_DRAW_BUFFER14;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER14_ARB = GLenum::GL_DRAW_BUFFER14_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER14_ATI = GLenum::GL_DRAW_BUFFER14_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER15 = GLenum::GL_DRAW_BUFFER15;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER15_ARB = GLenum::GL_DRAW_BUFFER15_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER15_ATI = GLenum::GL_DRAW_BUFFER15_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = GLenum::GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_ALPHA = GLenum::GL_BLEND_EQUATION_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_ALPHA_EXT = GLenum::GL_BLEND_EQUATION_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SUBSAMPLE_DISTANCE_AMD = GLenum::GL_SUBSAMPLE_DISTANCE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_PALETTE_ARB = GLenum::GL_MATRIX_PALETTE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = GLenum::GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PALETTE_MATRICES_ARB = GLenum::GL_MAX_PALETTE_MATRICES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_PALETTE_MATRIX_ARB = GLenum::GL_CURRENT_PALETTE_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_INDEX_ARRAY_ARB = GLenum::GL_MATRIX_INDEX_ARRAY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_INDEX_ARB = GLenum::GL_CURRENT_MATRIX_INDEX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_INDEX_ARRAY_SIZE_ARB = GLenum::GL_MATRIX_INDEX_ARRAY_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_INDEX_ARRAY_TYPE_ARB = GLenum::GL_MATRIX_INDEX_ARRAY_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = GLenum::GL_MATRIX_INDEX_ARRAY_STRIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_INDEX_ARRAY_POINTER_ARB = GLenum::GL_MATRIX_INDEX_ARRAY_POINTER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_SIZE = GLenum::GL_TEXTURE_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_SIZE_ARB = GLenum::GL_TEXTURE_DEPTH_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_TEXTURE_MODE = GLenum::GL_DEPTH_TEXTURE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_TEXTURE_MODE_ARB = GLenum::GL_DEPTH_TEXTURE_MODE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_MODE_ARB = GLenum::GL_TEXTURE_COMPARE_MODE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FUNC_ARB = GLenum::GL_TEXTURE_COMPARE_FUNC_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT = GLenum::GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPARE_REF_TO_TEXTURE = GLenum::GL_COMPARE_REF_TO_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPARE_R_TO_TEXTURE = GLenum::GL_COMPARE_R_TO_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPARE_R_TO_TEXTURE_ARB = GLenum::GL_COMPARE_R_TO_TEXTURE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_SEAMLESS = GLenum::GL_TEXTURE_CUBE_MAP_SEAMLESS;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_HILO_TEXTURE_2D_NV = GLenum::GL_OFFSET_HILO_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = GLenum::GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = GLenum::GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = GLenum::GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_HILO_TEXTURE_2D_NV = GLenum::GL_DEPENDENT_HILO_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_RGB_TEXTURE_3D_NV = GLenum::GL_DEPENDENT_RGB_TEXTURE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = GLenum::GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_PASS_THROUGH_NV = GLenum::GL_DOT_PRODUCT_PASS_THROUGH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_1D_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_1D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = GLenum::GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HILO8_NV = GLenum::GL_HILO8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_HILO8_NV = GLenum::GL_SIGNED_HILO8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FORCE_BLUE_TO_ONE_NV = GLenum::GL_FORCE_BLUE_TO_ONE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SPRITE = GLenum::GL_POINT_SPRITE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SPRITE_ARB = GLenum::GL_POINT_SPRITE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SPRITE_NV = GLenum::GL_POINT_SPRITE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COORD_REPLACE = GLenum::GL_COORD_REPLACE;
GLBINDING_CONSTEXPR static const GLenum GL_COORD_REPLACE_ARB = GLenum::GL_COORD_REPLACE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COORD_REPLACE_NV = GLenum::GL_COORD_REPLACE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SPRITE_R_MODE_NV = GLenum::GL_POINT_SPRITE_R_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_COUNTER_BITS_NV = GLenum::GL_PIXEL_COUNTER_BITS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_COUNTER_BITS_ARB = GLenum::GL_QUERY_COUNTER_BITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_OCCLUSION_QUERY_ID_NV = GLenum::GL_CURRENT_OCCLUSION_QUERY_ID_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_QUERY_ARB = GLenum::GL_CURRENT_QUERY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_COUNT_NV = GLenum::GL_PIXEL_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT_ARB = GLenum::GL_QUERY_RESULT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_COUNT_AVAILABLE_NV = GLenum::GL_PIXEL_COUNT_AVAILABLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT_AVAILABLE_ARB = GLenum::GL_QUERY_RESULT_AVAILABLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = GLenum::GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIBS = GLenum::GL_MAX_VERTEX_ATTRIBS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIBS_ARB = GLenum::GL_MAX_VERTEX_ATTRIBS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = GLenum::GL_MAX_TESS_CONTROL_INPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = GLenum::GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_TO_RGBA_NV = GLenum::GL_DEPTH_STENCIL_TO_RGBA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_TO_BGRA_NV = GLenum::GL_DEPTH_STENCIL_TO_BGRA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_PROGRAM_NV = GLenum::GL_FRAGMENT_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_COORDS = GLenum::GL_MAX_TEXTURE_COORDS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_COORDS_ARB = GLenum::GL_MAX_TEXTURE_COORDS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_COORDS_NV = GLenum::GL_MAX_TEXTURE_COORDS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_IMAGE_UNITS_ARB = GLenum::GL_MAX_TEXTURE_IMAGE_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_IMAGE_UNITS_NV = GLenum::GL_MAX_TEXTURE_IMAGE_UNITS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_PROGRAM_BINDING_NV = GLenum::GL_FRAGMENT_PROGRAM_BINDING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ERROR_STRING_ARB = GLenum::GL_PROGRAM_ERROR_STRING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ERROR_STRING_NV = GLenum::GL_PROGRAM_ERROR_STRING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_FORMAT_ASCII_ARB = GLenum::GL_PROGRAM_FORMAT_ASCII_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_FORMAT_ARB = GLenum::GL_PROGRAM_FORMAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_PIXEL_DATA_RANGE_NV = GLenum::GL_WRITE_PIXEL_DATA_RANGE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXEL_DATA_RANGE_NV = GLenum::GL_READ_PIXEL_DATA_RANGE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = GLenum::GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = GLenum::GL_READ_PIXEL_DATA_RANGE_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = GLenum::GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXEL_DATA_RANGE_POINTER_NV = GLenum::GL_READ_PIXEL_DATA_RANGE_POINTER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_INVOCATIONS = GLenum::GL_GEOMETRY_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_R_NV = GLenum::GL_FLOAT_R_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RG_NV = GLenum::GL_FLOAT_RG_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGB_NV = GLenum::GL_FLOAT_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGBA_NV = GLenum::GL_FLOAT_RGBA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_R16_NV = GLenum::GL_FLOAT_R16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_R32_NV = GLenum::GL_FLOAT_R32_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RG16_NV = GLenum::GL_FLOAT_RG16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RG32_NV = GLenum::GL_FLOAT_RG32_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGB16_NV = GLenum::GL_FLOAT_RGB16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGB32_NV = GLenum::GL_FLOAT_RGB32_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGBA16_NV = GLenum::GL_FLOAT_RGBA16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGBA32_NV = GLenum::GL_FLOAT_RGBA32_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FLOAT_COMPONENTS_NV = GLenum::GL_TEXTURE_FLOAT_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_CLEAR_COLOR_VALUE_NV = GLenum::GL_FLOAT_CLEAR_COLOR_VALUE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_RGBA_MODE_NV = GLenum::GL_FLOAT_RGBA_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = GLenum::GL_TEXTURE_UNSIGNED_REMAP_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BOUNDS_TEST_EXT = GLenum::GL_DEPTH_BOUNDS_TEST_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BOUNDS_EXT = GLenum::GL_DEPTH_BOUNDS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER_ARB = GLenum::GL_ARRAY_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER_ARB = GLenum::GL_ELEMENT_ARRAY_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER_BINDING = GLenum::GL_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER_BINDING = GLenum::GL_ELEMENT_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_BUFFER_BINDING = GLenum::GL_VERTEX_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_VERTEX_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_BUFFER_BINDING = GLenum::GL_NORMAL_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_NORMAL_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_BUFFER_BINDING = GLenum::GL_COLOR_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_COLOR_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_BUFFER_BINDING = GLenum::GL_INDEX_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_INDEX_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = GLenum::GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = GLenum::GL_EDGE_FLAG_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = GLenum::GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = GLenum::GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_BUFFER_BINDING = GLenum::GL_FOG_COORD_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_BUFFER_BINDING = GLenum::GL_WEIGHT_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_INSTRUCTIONS_ARB = GLenum::GL_PROGRAM_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_INSTRUCTIONS_ARB = GLenum::GL_MAX_PROGRAM_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = GLenum::GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_TEMPORARIES_ARB = GLenum::GL_PROGRAM_TEMPORARIES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEMPORARIES_ARB = GLenum::GL_MAX_PROGRAM_TEMPORARIES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_TEMPORARIES_ARB = GLenum::GL_PROGRAM_NATIVE_TEMPORARIES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PARAMETERS_ARB = GLenum::GL_PROGRAM_PARAMETERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_PARAMETERS_ARB = GLenum::GL_MAX_PROGRAM_PARAMETERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_PARAMETERS_ARB = GLenum::GL_PROGRAM_NATIVE_PARAMETERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ATTRIBS_ARB = GLenum::GL_PROGRAM_ATTRIBS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_ATTRIBS_ARB = GLenum::GL_MAX_PROGRAM_ATTRIBS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_ATTRIBS_ARB = GLenum::GL_PROGRAM_NATIVE_ATTRIBS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ADDRESS_REGISTERS_ARB = GLenum::GL_PROGRAM_ADDRESS_REGISTERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = GLenum::GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = GLenum::GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = GLenum::GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = GLenum::GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = GLenum::GL_MAX_PROGRAM_ENV_PARAMETERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = GLenum::GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_CURRENT_MATRIX_ARB = GLenum::GL_TRANSPOSE_CURRENT_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_READ_ONLY_ARB = GLenum::GL_READ_ONLY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_ONLY_ARB = GLenum::GL_WRITE_ONLY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_READ_WRITE_ARB = GLenum::GL_READ_WRITE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_ACCESS_ARB = GLenum::GL_BUFFER_ACCESS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAPPED_ARB = GLenum::GL_BUFFER_MAPPED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_POINTER = GLenum::GL_BUFFER_MAP_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_POINTER_ARB = GLenum::GL_BUFFER_MAP_POINTER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_DISCARD_NV = GLenum::GL_WRITE_DISCARD_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TIME_ELAPSED_EXT = GLenum::GL_TIME_ELAPSED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX0_ARB = GLenum::GL_MATRIX0_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX1_ARB = GLenum::GL_MATRIX1_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX2_ARB = GLenum::GL_MATRIX2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX3_ARB = GLenum::GL_MATRIX3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX4_ARB = GLenum::GL_MATRIX4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX5_ARB = GLenum::GL_MATRIX5_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX6_ARB = GLenum::GL_MATRIX6_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX7_ARB = GLenum::GL_MATRIX7_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX8_ARB = GLenum::GL_MATRIX8_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX9_ARB = GLenum::GL_MATRIX9_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX10_ARB = GLenum::GL_MATRIX10_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX11_ARB = GLenum::GL_MATRIX11_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX12_ARB = GLenum::GL_MATRIX12_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX13_ARB = GLenum::GL_MATRIX13_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX14_ARB = GLenum::GL_MATRIX14_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX15_ARB = GLenum::GL_MATRIX15_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX16_ARB = GLenum::GL_MATRIX16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX17_ARB = GLenum::GL_MATRIX17_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX18_ARB = GLenum::GL_MATRIX18_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX19_ARB = GLenum::GL_MATRIX19_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX20_ARB = GLenum::GL_MATRIX20_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX21_ARB = GLenum::GL_MATRIX21_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX22_ARB = GLenum::GL_MATRIX22_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX23_ARB = GLenum::GL_MATRIX23_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX24_ARB = GLenum::GL_MATRIX24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX25_ARB = GLenum::GL_MATRIX25_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX26_ARB = GLenum::GL_MATRIX26_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX27_ARB = GLenum::GL_MATRIX27_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX28_ARB = GLenum::GL_MATRIX28_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX29_ARB = GLenum::GL_MATRIX29_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX30_ARB = GLenum::GL_MATRIX30_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX31_ARB = GLenum::GL_MATRIX31_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_DRAW_ARB = GLenum::GL_STREAM_DRAW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_READ_ARB = GLenum::GL_STREAM_READ_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_COPY_ARB = GLenum::GL_STREAM_COPY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_DRAW_ARB = GLenum::GL_STATIC_DRAW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_READ_ARB = GLenum::GL_STATIC_READ_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_COPY_ARB = GLenum::GL_STATIC_COPY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_DRAW_ARB = GLenum::GL_DYNAMIC_DRAW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_READ_ARB = GLenum::GL_DYNAMIC_READ_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_COPY_ARB = GLenum::GL_DYNAMIC_COPY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER_ARB = GLenum::GL_PIXEL_PACK_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER_EXT = GLenum::GL_PIXEL_PACK_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER_ARB = GLenum::GL_PIXEL_UNPACK_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER_EXT = GLenum::GL_PIXEL_UNPACK_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER_BINDING = GLenum::GL_PIXEL_PACK_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER_BINDING_ARB = GLenum::GL_PIXEL_PACK_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER_BINDING_EXT = GLenum::GL_PIXEL_PACK_BUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER_BINDING = GLenum::GL_PIXEL_UNPACK_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = GLenum::GL_PIXEL_UNPACK_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER_BINDING_EXT = GLenum::GL_PIXEL_UNPACK_BUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_STENCIL_SIZE = GLenum::GL_TEXTURE_STENCIL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_STENCIL_SIZE_EXT = GLenum::GL_TEXTURE_STENCIL_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_TAG_BITS_EXT = GLenum::GL_STENCIL_TAG_BITS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_CLEAR_TAG_VALUE_EXT = GLenum::GL_STENCIL_CLEAR_TAG_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = GLenum::GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_CALL_DEPTH_NV = GLenum::GL_MAX_PROGRAM_CALL_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_IF_DEPTH_NV = GLenum::GL_MAX_PROGRAM_IF_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_LOOP_DEPTH_NV = GLenum::GL_MAX_PROGRAM_LOOP_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_LOOP_COUNT_NV = GLenum::GL_MAX_PROGRAM_LOOP_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = GLenum::GL_MAX_DUAL_SOURCE_DRAW_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT = GLenum::GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ARRAY_TEXTURE_LAYERS = GLenum::GL_MAX_ARRAY_TEXTURE_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ARRAY_TEXTURE_LAYERS_EXT = GLenum::GL_MAX_ARRAY_TEXTURE_LAYERS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_PROGRAM_TEXEL_OFFSET = GLenum::GL_MIN_PROGRAM_TEXEL_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_PROGRAM_TEXEL_OFFSET_EXT = GLenum::GL_MIN_PROGRAM_TEXEL_OFFSET_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_PROGRAM_TEXEL_OFFSET_NV = GLenum::GL_MIN_PROGRAM_TEXEL_OFFSET_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEXEL_OFFSET = GLenum::GL_MAX_PROGRAM_TEXEL_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEXEL_OFFSET_EXT = GLenum::GL_MAX_PROGRAM_TEXEL_OFFSET_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEXEL_OFFSET_NV = GLenum::GL_MAX_PROGRAM_TEXEL_OFFSET_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ATTRIB_COMPONENTS_NV = GLenum::GL_PROGRAM_ATTRIB_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_RESULT_COMPONENTS_NV = GLenum::GL_PROGRAM_RESULT_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = GLenum::GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_RESULT_COMPONENTS_NV = GLenum::GL_MAX_PROGRAM_RESULT_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_TEST_TWO_SIDE_EXT = GLenum::GL_STENCIL_TEST_TWO_SIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_STENCIL_FACE_EXT = GLenum::GL_ACTIVE_STENCIL_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_BORDER_EXT = GLenum::GL_MIRROR_CLAMP_TO_BORDER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_PASSED_ARB = GLenum::GL_SAMPLES_PASSED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_BINDING = GLenum::GL_SAMPLER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_VERTEX_COLOR = GLenum::GL_CLAMP_VERTEX_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_VERTEX_COLOR_ARB = GLenum::GL_CLAMP_VERTEX_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_FRAGMENT_COLOR = GLenum::GL_CLAMP_FRAGMENT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_FRAGMENT_COLOR_ARB = GLenum::GL_CLAMP_FRAGMENT_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_READ_COLOR = GLenum::GL_CLAMP_READ_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_READ_COLOR_ARB = GLenum::GL_CLAMP_READ_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FIXED_ONLY = GLenum::GL_FIXED_ONLY;
GLBINDING_CONSTEXPR static const GLenum GL_FIXED_ONLY_ARB = GLenum::GL_FIXED_ONLY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_PROGRAM_NV = GLenum::GL_TESS_CONTROL_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_PROGRAM_NV = GLenum::GL_TESS_EVALUATION_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_ATI = GLenum::GL_FRAGMENT_SHADER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_0_ATI = GLenum::GL_REG_0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_1_ATI = GLenum::GL_REG_1_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_2_ATI = GLenum::GL_REG_2_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_3_ATI = GLenum::GL_REG_3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_4_ATI = GLenum::GL_REG_4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_5_ATI = GLenum::GL_REG_5_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_6_ATI = GLenum::GL_REG_6_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_7_ATI = GLenum::GL_REG_7_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_8_ATI = GLenum::GL_REG_8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_9_ATI = GLenum::GL_REG_9_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_10_ATI = GLenum::GL_REG_10_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_11_ATI = GLenum::GL_REG_11_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_12_ATI = GLenum::GL_REG_12_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_13_ATI = GLenum::GL_REG_13_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_14_ATI = GLenum::GL_REG_14_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_15_ATI = GLenum::GL_REG_15_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_16_ATI = GLenum::GL_REG_16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_17_ATI = GLenum::GL_REG_17_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_18_ATI = GLenum::GL_REG_18_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_19_ATI = GLenum::GL_REG_19_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_20_ATI = GLenum::GL_REG_20_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_21_ATI = GLenum::GL_REG_21_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_22_ATI = GLenum::GL_REG_22_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_23_ATI = GLenum::GL_REG_23_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_24_ATI = GLenum::GL_REG_24_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_25_ATI = GLenum::GL_REG_25_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_26_ATI = GLenum::GL_REG_26_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_27_ATI = GLenum::GL_REG_27_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_28_ATI = GLenum::GL_REG_28_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_29_ATI = GLenum::GL_REG_29_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_30_ATI = GLenum::GL_REG_30_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_31_ATI = GLenum::GL_REG_31_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_0_ATI = GLenum::GL_CON_0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_1_ATI = GLenum::GL_CON_1_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_2_ATI = GLenum::GL_CON_2_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_3_ATI = GLenum::GL_CON_3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_4_ATI = GLenum::GL_CON_4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_5_ATI = GLenum::GL_CON_5_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_6_ATI = GLenum::GL_CON_6_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_7_ATI = GLenum::GL_CON_7_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_8_ATI = GLenum::GL_CON_8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_9_ATI = GLenum::GL_CON_9_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_10_ATI = GLenum::GL_CON_10_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_11_ATI = GLenum::GL_CON_11_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_12_ATI = GLenum::GL_CON_12_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_13_ATI = GLenum::GL_CON_13_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_14_ATI = GLenum::GL_CON_14_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_15_ATI = GLenum::GL_CON_15_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_16_ATI = GLenum::GL_CON_16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_17_ATI = GLenum::GL_CON_17_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_18_ATI = GLenum::GL_CON_18_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_19_ATI = GLenum::GL_CON_19_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_20_ATI = GLenum::GL_CON_20_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_21_ATI = GLenum::GL_CON_21_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_22_ATI = GLenum::GL_CON_22_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_23_ATI = GLenum::GL_CON_23_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_24_ATI = GLenum::GL_CON_24_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_25_ATI = GLenum::GL_CON_25_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_26_ATI = GLenum::GL_CON_26_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_27_ATI = GLenum::GL_CON_27_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_28_ATI = GLenum::GL_CON_28_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_29_ATI = GLenum::GL_CON_29_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_30_ATI = GLenum::GL_CON_30_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_31_ATI = GLenum::GL_CON_31_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_INTERPOLATOR_ATI = GLenum::GL_SECONDARY_INTERPOLATOR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_FRAGMENT_REGISTERS_ATI = GLenum::GL_NUM_FRAGMENT_REGISTERS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_FRAGMENT_CONSTANTS_ATI = GLenum::GL_NUM_FRAGMENT_CONSTANTS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_PASSES_ATI = GLenum::GL_NUM_PASSES_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_INSTRUCTIONS_PER_PASS_ATI = GLenum::GL_NUM_INSTRUCTIONS_PER_PASS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_INSTRUCTIONS_TOTAL_ATI = GLenum::GL_NUM_INSTRUCTIONS_TOTAL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = GLenum::GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_LOOPBACK_COMPONENTS_ATI = GLenum::GL_NUM_LOOPBACK_COMPONENTS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ALPHA_PAIRING_ATI = GLenum::GL_COLOR_ALPHA_PAIRING_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STR_ATI = GLenum::GL_SWIZZLE_STR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STQ_ATI = GLenum::GL_SWIZZLE_STQ_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STR_DR_ATI = GLenum::GL_SWIZZLE_STR_DR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STQ_DQ_ATI = GLenum::GL_SWIZZLE_STQ_DQ_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STRQ_ATI = GLenum::GL_SWIZZLE_STRQ_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STRQ_DQ_ATI = GLenum::GL_SWIZZLE_STRQ_DQ_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_OML = GLenum::GL_INTERLACE_OML;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_READ_OML = GLenum::GL_INTERLACE_READ_OML;
GLBINDING_CONSTEXPR static const GLenum GL_FORMAT_SUBSAMPLE_24_24_OML = GLenum::GL_FORMAT_SUBSAMPLE_24_24_OML;
GLBINDING_CONSTEXPR static const GLenum GL_FORMAT_SUBSAMPLE_244_244_OML = GLenum::GL_FORMAT_SUBSAMPLE_244_244_OML;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_REPLICATE_OML = GLenum::GL_RESAMPLE_REPLICATE_OML;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_ZERO_FILL_OML = GLenum::GL_RESAMPLE_ZERO_FILL_OML;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_AVERAGE_OML = GLenum::GL_RESAMPLE_AVERAGE_OML;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_DECIMATE_OML = GLenum::GL_RESAMPLE_DECIMATE_OML;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP1_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP1_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP2_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP2_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = GLenum::GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_PIXELS_APPLE = GLenum::GL_DRAW_PIXELS_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_FENCE_APPLE = GLenum::GL_FENCE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_APPLE = GLenum::GL_ELEMENT_ARRAY_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_TYPE_APPLE = GLenum::GL_ELEMENT_ARRAY_TYPE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_POINTER_APPLE = GLenum::GL_ELEMENT_ARRAY_POINTER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_FLOAT_APPLE = GLenum::GL_COLOR_FLOAT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_SERIALIZED_MODIFY_APPLE = GLenum::GL_BUFFER_SERIALIZED_MODIFY_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_FLUSHING_UNMAP_APPLE = GLenum::GL_BUFFER_FLUSHING_UNMAP_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_AUX_DEPTH_STENCIL_APPLE = GLenum::GL_AUX_DEPTH_STENCIL_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_ROW_BYTES_APPLE = GLenum::GL_PACK_ROW_BYTES_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ROW_BYTES_APPLE = GLenum::GL_UNPACK_ROW_BYTES_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RELEASED_APPLE = GLenum::GL_RELEASED_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VOLATILE_APPLE = GLenum::GL_VOLATILE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RETAINED_APPLE = GLenum::GL_RETAINED_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNDEFINED_APPLE = GLenum::GL_UNDEFINED_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_PURGEABLE_APPLE = GLenum::GL_PURGEABLE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_422_APPLE = GLenum::GL_RGB_422_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_BINDING = GLenum::GL_UNIFORM_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_START = GLenum::GL_UNIFORM_BUFFER_START;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_SIZE = GLenum::GL_UNIFORM_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNIFORM_BLOCKS = GLenum::GL_MAX_VERTEX_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_UNIFORM_BLOCKS = GLenum::GL_MAX_GEOMETRY_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_UNIFORM_BLOCKS = GLenum::GL_MAX_FRAGMENT_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_UNIFORM_BLOCKS = GLenum::GL_MAX_COMBINED_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_UNIFORM_BUFFER_BINDINGS = GLenum::GL_MAX_UNIFORM_BUFFER_BINDINGS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_UNIFORM_BLOCK_SIZE = GLenum::GL_MAX_UNIFORM_BLOCK_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = GLenum::GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SRGB_DECODE_EXT = GLenum::GL_TEXTURE_SRGB_DECODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DECODE_EXT = GLenum::GL_DECODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_DECODE_EXT = GLenum::GL_SKIP_DECODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE_OBJECT_EXT = GLenum::GL_PROGRAM_PIPELINE_OBJECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_RAW_422_APPLE = GLenum::GL_RGB_RAW_422_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = GLenum::GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_OBJECT_ARB = GLenum::GL_PROGRAM_OBJECT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_OBJECT_EXT = GLenum::GL_PROGRAM_OBJECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_OBJECT_ARB = GLenum::GL_SHADER_OBJECT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_OBJECT_EXT = GLenum::GL_SHADER_OBJECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = GLenum::GL_MAX_FRAGMENT_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = GLenum::GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNIFORM_COMPONENTS = GLenum::GL_MAX_VERTEX_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = GLenum::GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_COMPONENTS = GLenum::GL_MAX_VARYING_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_COMPONENTS_EXT = GLenum::GL_MAX_VARYING_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_FLOATS = GLenum::GL_MAX_VARYING_FLOATS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_FLOATS_ARB = GLenum::GL_MAX_VARYING_FLOATS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = GLenum::GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = GLenum::GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_TYPE_ARB = GLenum::GL_OBJECT_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_SUBTYPE_ARB = GLenum::GL_OBJECT_SUBTYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_DELETE_STATUS_ARB = GLenum::GL_OBJECT_DELETE_STATUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_COMPILE_STATUS_ARB = GLenum::GL_OBJECT_COMPILE_STATUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINK_STATUS_ARB = GLenum::GL_OBJECT_LINK_STATUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_VALIDATE_STATUS_ARB = GLenum::GL_OBJECT_VALIDATE_STATUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_INFO_LOG_LENGTH_ARB = GLenum::GL_OBJECT_INFO_LOG_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_ATTACHED_OBJECTS_ARB = GLenum::GL_OBJECT_ATTACHED_OBJECTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_ACTIVE_UNIFORMS_ARB = GLenum::GL_OBJECT_ACTIVE_UNIFORMS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = GLenum::GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = GLenum::GL_OBJECT_SHADER_SOURCE_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = GLenum::GL_OBJECT_ACTIVE_ATTRIBUTES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = GLenum::GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SHADING_LANGUAGE_VERSION_ARB = GLenum::GL_SHADING_LANGUAGE_VERSION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_PROGRAM_EXT = GLenum::GL_ACTIVE_PROGRAM_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_PROGRAM = GLenum::GL_CURRENT_PROGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE4_RGB8_OES = GLenum::GL_PALETTE4_RGB8_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE4_RGBA8_OES = GLenum::GL_PALETTE4_RGBA8_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE4_R5_G6_B5_OES = GLenum::GL_PALETTE4_R5_G6_B5_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE4_RGBA4_OES = GLenum::GL_PALETTE4_RGBA4_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE4_RGB5_A1_OES = GLenum::GL_PALETTE4_RGB5_A1_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE8_RGB8_OES = GLenum::GL_PALETTE8_RGB8_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE8_RGBA8_OES = GLenum::GL_PALETTE8_RGBA8_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE8_R5_G6_B5_OES = GLenum::GL_PALETTE8_R5_G6_B5_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE8_RGBA4_OES = GLenum::GL_PALETTE8_RGBA4_OES;
GLBINDING_CONSTEXPR static const GLenum GL_PALETTE8_RGB5_A1_OES = GLenum::GL_PALETTE8_RGB5_A1_OES;
GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_TYPE_OES = GLenum::GL_IMPLEMENTATION_COLOR_READ_TYPE_OES;
GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES = GLenum::GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES;
GLBINDING_CONSTEXPR static const GLenum GL_TILE_RASTER_ORDER_FIXED_MESA = GLenum::GL_TILE_RASTER_ORDER_FIXED_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_TILE_RASTER_ORDER_INCREASING_X_MESA = GLenum::GL_TILE_RASTER_ORDER_INCREASING_X_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_TILE_RASTER_ORDER_INCREASING_Y_MESA = GLenum::GL_TILE_RASTER_ORDER_INCREASING_Y_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_COUNTER_TYPE_AMD = GLenum::GL_COUNTER_TYPE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_COUNTER_RANGE_AMD = GLenum::GL_COUNTER_RANGE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_AMD = GLenum::GL_UNSIGNED_INT64_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_PERCENTAGE_AMD = GLenum::GL_PERCENTAGE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_PERFMON_RESULT_AVAILABLE_AMD = GLenum::GL_PERFMON_RESULT_AVAILABLE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_PERFMON_RESULT_SIZE_AMD = GLenum::GL_PERFMON_RESULT_SIZE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_PERFMON_RESULT_AMD = GLenum::GL_PERFMON_RESULT_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_TYPE = GLenum::GL_TEXTURE_RED_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_TYPE_ARB = GLenum::GL_TEXTURE_RED_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_TYPE = GLenum::GL_TEXTURE_GREEN_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_TYPE_ARB = GLenum::GL_TEXTURE_GREEN_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_TYPE = GLenum::GL_TEXTURE_BLUE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_TYPE_ARB = GLenum::GL_TEXTURE_BLUE_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_TYPE = GLenum::GL_TEXTURE_ALPHA_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_TYPE_ARB = GLenum::GL_TEXTURE_ALPHA_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_TYPE = GLenum::GL_TEXTURE_LUMINANCE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_TYPE_ARB = GLenum::GL_TEXTURE_LUMINANCE_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_TYPE = GLenum::GL_TEXTURE_INTENSITY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_TYPE_ARB = GLenum::GL_TEXTURE_INTENSITY_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_TYPE = GLenum::GL_TEXTURE_DEPTH_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_TYPE_ARB = GLenum::GL_TEXTURE_DEPTH_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_NORMALIZED = GLenum::GL_UNSIGNED_NORMALIZED;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_NORMALIZED_ARB = GLenum::GL_UNSIGNED_NORMALIZED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_ARRAY_EXT = GLenum::GL_TEXTURE_1D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_ARRAY_EXT = GLenum::GL_TEXTURE_2D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_1D_ARRAY = GLenum::GL_TEXTURE_BINDING_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_1D_ARRAY_EXT = GLenum::GL_TEXTURE_BINDING_1D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D_ARRAY = GLenum::GL_TEXTURE_BINDING_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D_ARRAY_EXT = GLenum::GL_TEXTURE_BINDING_2D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_PROGRAM_NV = GLenum::GL_GEOMETRY_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_OUTPUT_VERTICES_NV = GLenum::GL_MAX_PROGRAM_OUTPUT_VERTICES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = GLenum::GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = GLenum::GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = GLenum::GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_ARB = GLenum::GL_TEXTURE_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_BINDING = GLenum::GL_TEXTURE_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_EXT = GLenum::GL_TEXTURE_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_BUFFER_SIZE = GLenum::GL_MAX_TEXTURE_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_BUFFER_SIZE_ARB = GLenum::GL_MAX_TEXTURE_BUFFER_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_BUFFER_SIZE_EXT = GLenum::GL_MAX_TEXTURE_BUFFER_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_BUFFER = GLenum::GL_TEXTURE_BINDING_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_BUFFER_ARB = GLenum::GL_TEXTURE_BINDING_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_BUFFER_EXT = GLenum::GL_TEXTURE_BINDING_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_DATA_STORE_BINDING = GLenum::GL_TEXTURE_BUFFER_DATA_STORE_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = GLenum::GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = GLenum::GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_FORMAT_ARB = GLenum::GL_TEXTURE_BUFFER_FORMAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_FORMAT_EXT = GLenum::GL_TEXTURE_BUFFER_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_SHADING = GLenum::GL_SAMPLE_SHADING;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_SHADING_ARB = GLenum::GL_SAMPLE_SHADING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_SAMPLE_SHADING_VALUE = GLenum::GL_MIN_SAMPLE_SHADING_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_SAMPLE_SHADING_VALUE_ARB = GLenum::GL_MIN_SAMPLE_SHADING_VALUE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10F_11F_11F_REV_EXT = GLenum::GL_UNSIGNED_INT_10F_11F_11F_REV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_SIGNED_COMPONENTS_EXT = GLenum::GL_RGBA_SIGNED_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_5_9_9_9_REV = GLenum::GL_UNSIGNED_INT_5_9_9_9_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_5_9_9_9_REV_EXT = GLenum::GL_UNSIGNED_INT_5_9_9_9_REV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SHARED_SIZE = GLenum::GL_TEXTURE_SHARED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SHARED_SIZE_EXT = GLenum::GL_TEXTURE_SHARED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE_ALPHA = GLenum::GL_SLUMINANCE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE_ALPHA_EXT = GLenum::GL_SLUMINANCE_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE8_ALPHA8 = GLenum::GL_SLUMINANCE8_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE8_ALPHA8_EXT = GLenum::GL_SLUMINANCE8_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE = GLenum::GL_SLUMINANCE;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE_EXT = GLenum::GL_SLUMINANCE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE8 = GLenum::GL_SLUMINANCE8;
GLBINDING_CONSTEXPR static const GLenum GL_SLUMINANCE8_EXT = GLenum::GL_SLUMINANCE8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_EXT = GLenum::GL_COMPRESSED_SRGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SLUMINANCE = GLenum::GL_COMPRESSED_SLUMINANCE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SLUMINANCE_EXT = GLenum::GL_COMPRESSED_SLUMINANCE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SLUMINANCE_ALPHA = GLenum::GL_COMPRESSED_SLUMINANCE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SLUMINANCE_ALPHA_EXT = GLenum::GL_COMPRESSED_SLUMINANCE_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_LATC1_EXT = GLenum::GL_COMPRESSED_LUMINANCE_LATC1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = GLenum::GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = GLenum::GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = GLenum::GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = GLenum::GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = GLenum::GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = GLenum::GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_PRIMARY_COLOR_NV = GLenum::GL_BACK_PRIMARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_SECONDARY_COLOR_NV = GLenum::GL_BACK_SECONDARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_NV = GLenum::GL_TEXTURE_COORD_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE_NV = GLenum::GL_CLIP_DISTANCE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ID_NV = GLenum::GL_VERTEX_ID_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_ID_NV = GLenum::GL_PRIMITIVE_ID_NV;
GLBINDING_CONSTEXPR static const GLenum GL_GENERIC_ATTRIB_NV = GLenum::GL_GENERIC_ATTRIB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = GLenum::GL_TRANSFORM_FEEDBACK_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_VARYINGS_NV = GLenum::GL_ACTIVE_VARYINGS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_VARYING_MAX_LENGTH_NV = GLenum::GL_ACTIVE_VARYING_MAX_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = GLenum::GL_TRANSFORM_FEEDBACK_VARYINGS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYINGS_NV = GLenum::GL_TRANSFORM_FEEDBACK_VARYINGS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_START_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_RECORD_NV = GLenum::GL_TRANSFORM_FEEDBACK_RECORD_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_GENERATED_EXT = GLenum::GL_PRIMITIVES_GENERATED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_GENERATED_NV = GLenum::GL_PRIMITIVES_GENERATED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = GLenum::GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = GLenum::GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RASTERIZER_DISCARD = GLenum::GL_RASTERIZER_DISCARD;
GLBINDING_CONSTEXPR static const GLenum GL_RASTERIZER_DISCARD_EXT = GLenum::GL_RASTERIZER_DISCARD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RASTERIZER_DISCARD_NV = GLenum::GL_RASTERIZER_DISCARD_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = GLenum::GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = GLenum::GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = GLenum::GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLEAVED_ATTRIBS = GLenum::GL_INTERLEAVED_ATTRIBS;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLEAVED_ATTRIBS_EXT = GLenum::GL_INTERLEAVED_ATTRIBS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLEAVED_ATTRIBS_NV = GLenum::GL_INTERLEAVED_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_ATTRIBS = GLenum::GL_SEPARATE_ATTRIBS;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_ATTRIBS_EXT = GLenum::GL_SEPARATE_ATTRIBS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_ATTRIBS_NV = GLenum::GL_SEPARATE_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_EXT = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_NV = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SPRITE_COORD_ORIGIN = GLenum::GL_POINT_SPRITE_COORD_ORIGIN;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_REF = GLenum::GL_STENCIL_BACK_REF;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_VALUE_MASK = GLenum::GL_STENCIL_BACK_VALUE_MASK;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_WRITEMASK = GLenum::GL_STENCIL_BACK_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER_BINDING = GLenum::GL_DRAW_FRAMEBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER_BINDING_EXT = GLenum::GL_DRAW_FRAMEBUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_BINDING = GLenum::GL_FRAMEBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_BINDING_EXT = GLenum::GL_FRAMEBUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BINDING = GLenum::GL_RENDERBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BINDING_EXT = GLenum::GL_RENDERBUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER_EXT = GLenum::GL_READ_FRAMEBUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER_EXT = GLenum::GL_DRAW_FRAMEBUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER_BINDING = GLenum::GL_READ_FRAMEBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER_BINDING_EXT = GLenum::GL_READ_FRAMEBUFFER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = GLenum::GL_RENDERBUFFER_COVERAGE_SAMPLES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_SAMPLES_EXT = GLenum::GL_RENDERBUFFER_SAMPLES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_COMPLETE_EXT = GLenum::GL_FRAMEBUFFER_COMPLETE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_UNSUPPORTED_EXT = GLenum::GL_FRAMEBUFFER_UNSUPPORTED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_ATTACHMENT = GLenum::GL_STENCIL_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_ATTACHMENT_EXT = GLenum::GL_STENCIL_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_EXT = GLenum::GL_FRAMEBUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_EXT = GLenum::GL_RENDERBUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_WIDTH_EXT = GLenum::GL_RENDERBUFFER_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_HEIGHT_EXT = GLenum::GL_RENDERBUFFER_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = GLenum::GL_RENDERBUFFER_INTERNAL_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX1 = GLenum::GL_STENCIL_INDEX1;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX1_EXT = GLenum::GL_STENCIL_INDEX1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX4 = GLenum::GL_STENCIL_INDEX4;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX4_EXT = GLenum::GL_STENCIL_INDEX4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX8 = GLenum::GL_STENCIL_INDEX8;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX8_EXT = GLenum::GL_STENCIL_INDEX8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX16 = GLenum::GL_STENCIL_INDEX16;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX16_EXT = GLenum::GL_STENCIL_INDEX16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_RED_SIZE_EXT = GLenum::GL_RENDERBUFFER_RED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_GREEN_SIZE_EXT = GLenum::GL_RENDERBUFFER_GREEN_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BLUE_SIZE_EXT = GLenum::GL_RENDERBUFFER_BLUE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_ALPHA_SIZE_EXT = GLenum::GL_RENDERBUFFER_ALPHA_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_DEPTH_SIZE_EXT = GLenum::GL_RENDERBUFFER_DEPTH_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_STENCIL_SIZE_EXT = GLenum::GL_RENDERBUFFER_STENCIL_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SAMPLES = GLenum::GL_MAX_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SAMPLES_EXT = GLenum::GL_MAX_SAMPLES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB565 = GLenum::GL_RGB565;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_FIXED_INDEX = GLenum::GL_PRIMITIVE_RESTART_FIXED_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENT_INDEX = GLenum::GL_MAX_ELEMENT_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32UI_EXT = GLenum::GL_RGBA32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32UI_EXT = GLenum::GL_RGB32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32UI_EXT = GLenum::GL_ALPHA32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32UI_EXT = GLenum::GL_INTENSITY32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32UI_EXT = GLenum::GL_LUMINANCE32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32UI_EXT = GLenum::GL_LUMINANCE_ALPHA32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16UI_EXT = GLenum::GL_RGBA16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16UI_EXT = GLenum::GL_RGB16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16UI_EXT = GLenum::GL_ALPHA16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16UI_EXT = GLenum::GL_INTENSITY16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16UI_EXT = GLenum::GL_LUMINANCE16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16UI_EXT = GLenum::GL_LUMINANCE_ALPHA16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8UI_EXT = GLenum::GL_RGBA8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8UI_EXT = GLenum::GL_RGB8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8UI_EXT = GLenum::GL_ALPHA8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8UI_EXT = GLenum::GL_INTENSITY8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8UI_EXT = GLenum::GL_LUMINANCE8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA8UI_EXT = GLenum::GL_LUMINANCE_ALPHA8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32I_EXT = GLenum::GL_RGBA32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32I_EXT = GLenum::GL_RGB32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32I_EXT = GLenum::GL_ALPHA32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32I_EXT = GLenum::GL_INTENSITY32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32I_EXT = GLenum::GL_LUMINANCE32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32I_EXT = GLenum::GL_LUMINANCE_ALPHA32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16I_EXT = GLenum::GL_RGBA16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16I_EXT = GLenum::GL_RGB16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16I_EXT = GLenum::GL_ALPHA16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16I_EXT = GLenum::GL_INTENSITY16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16I_EXT = GLenum::GL_LUMINANCE16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16I_EXT = GLenum::GL_LUMINANCE_ALPHA16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8I_EXT = GLenum::GL_RGBA8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8I_EXT = GLenum::GL_RGB8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8I_EXT = GLenum::GL_ALPHA8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8I_EXT = GLenum::GL_INTENSITY8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8I_EXT = GLenum::GL_LUMINANCE8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA8I_EXT = GLenum::GL_LUMINANCE_ALPHA8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RED_INTEGER = GLenum::GL_RED_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_RED_INTEGER_EXT = GLenum::GL_RED_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_INTEGER = GLenum::GL_GREEN_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_INTEGER_EXT = GLenum::GL_GREEN_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_INTEGER = GLenum::GL_BLUE_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_INTEGER_EXT = GLenum::GL_BLUE_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_INTEGER = GLenum::GL_ALPHA_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_INTEGER_EXT = GLenum::GL_ALPHA_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_INTEGER = GLenum::GL_RGB_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_INTEGER_EXT = GLenum::GL_RGB_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_INTEGER = GLenum::GL_RGBA_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_INTEGER_EXT = GLenum::GL_RGBA_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BGR_INTEGER = GLenum::GL_BGR_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_BGR_INTEGER_EXT = GLenum::GL_BGR_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA_INTEGER = GLenum::GL_BGRA_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA_INTEGER_EXT = GLenum::GL_BGRA_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_INTEGER_EXT = GLenum::GL_LUMINANCE_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA_INTEGER_EXT = GLenum::GL_LUMINANCE_ALPHA_INTEGER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_INTEGER_MODE_EXT = GLenum::GL_RGBA_INTEGER_MODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = GLenum::GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = GLenum::GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = GLenum::GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = GLenum::GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = GLenum::GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV = GLenum::GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_GENERIC_RESULTS_NV = GLenum::GL_MAX_PROGRAM_GENERIC_RESULTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYER_NV = GLenum::GL_LAYER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_32_UNSIGNED_INT_24_8_REV = GLenum::GL_FLOAT_32_UNSIGNED_INT_24_8_REV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = GLenum::GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_INCLUDE_ARB = GLenum::GL_SHADER_INCLUDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BUFFER_FLOAT_MODE_NV = GLenum::GL_DEPTH_BUFFER_FLOAT_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_SRGB = GLenum::GL_FRAMEBUFFER_SRGB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_SRGB_EXT = GLenum::GL_FRAMEBUFFER_SRGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_SRGB_CAPABLE_EXT = GLenum::GL_FRAMEBUFFER_SRGB_CAPABLE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_GREEN_RGTC2_EXT = GLenum::GL_COMPRESSED_RED_GREEN_RGTC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = GLenum::GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARRAY = GLenum::GL_SAMPLER_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARRAY_EXT = GLenum::GL_SAMPLER_1D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARRAY = GLenum::GL_SAMPLER_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARRAY_EXT = GLenum::GL_SAMPLER_2D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_BUFFER = GLenum::GL_SAMPLER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_BUFFER_EXT = GLenum::GL_SAMPLER_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARRAY_SHADOW = GLenum::GL_SAMPLER_1D_ARRAY_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARRAY_SHADOW_EXT = GLenum::GL_SAMPLER_1D_ARRAY_SHADOW_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARRAY_SHADOW = GLenum::GL_SAMPLER_2D_ARRAY_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARRAY_SHADOW_EXT = GLenum::GL_SAMPLER_2D_ARRAY_SHADOW_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_SHADOW = GLenum::GL_SAMPLER_CUBE_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_SHADOW_EXT = GLenum::GL_SAMPLER_CUBE_SHADOW_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC2 = GLenum::GL_UNSIGNED_INT_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC2_EXT = GLenum::GL_UNSIGNED_INT_VEC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC3 = GLenum::GL_UNSIGNED_INT_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC3_EXT = GLenum::GL_UNSIGNED_INT_VEC3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC4 = GLenum::GL_UNSIGNED_INT_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC4_EXT = GLenum::GL_UNSIGNED_INT_VEC4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_1D = GLenum::GL_INT_SAMPLER_1D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_1D_EXT = GLenum::GL_INT_SAMPLER_1D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D = GLenum::GL_INT_SAMPLER_2D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_EXT = GLenum::GL_INT_SAMPLER_2D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_3D = GLenum::GL_INT_SAMPLER_3D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_3D_EXT = GLenum::GL_INT_SAMPLER_3D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_CUBE = GLenum::GL_INT_SAMPLER_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_CUBE_EXT = GLenum::GL_INT_SAMPLER_CUBE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_RECT = GLenum::GL_INT_SAMPLER_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_RECT_EXT = GLenum::GL_INT_SAMPLER_2D_RECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_1D_ARRAY = GLenum::GL_INT_SAMPLER_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_1D_ARRAY_EXT = GLenum::GL_INT_SAMPLER_1D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_ARRAY = GLenum::GL_INT_SAMPLER_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_ARRAY_EXT = GLenum::GL_INT_SAMPLER_2D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_BUFFER = GLenum::GL_INT_SAMPLER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_BUFFER_EXT = GLenum::GL_INT_SAMPLER_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_1D = GLenum::GL_UNSIGNED_INT_SAMPLER_1D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_1D_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_1D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D = GLenum::GL_UNSIGNED_INT_SAMPLER_2D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_3D = GLenum::GL_UNSIGNED_INT_SAMPLER_3D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_3D_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_3D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_CUBE = GLenum::GL_UNSIGNED_INT_SAMPLER_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_CUBE_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_CUBE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_RECT = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = GLenum::GL_UNSIGNED_INT_SAMPLER_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_BUFFER = GLenum::GL_UNSIGNED_INT_SAMPLER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT = GLenum::GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_ARB = GLenum::GL_GEOMETRY_SHADER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_EXT = GLenum::GL_GEOMETRY_SHADER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_VERTICES_OUT_ARB = GLenum::GL_GEOMETRY_VERTICES_OUT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_VERTICES_OUT_EXT = GLenum::GL_GEOMETRY_VERTICES_OUT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_INPUT_TYPE_ARB = GLenum::GL_GEOMETRY_INPUT_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_INPUT_TYPE_EXT = GLenum::GL_GEOMETRY_INPUT_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_OUTPUT_TYPE_ARB = GLenum::GL_GEOMETRY_OUTPUT_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_OUTPUT_TYPE_EXT = GLenum::GL_GEOMETRY_OUTPUT_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = GLenum::GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT = GLenum::GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = GLenum::GL_MAX_VERTEX_VARYING_COMPONENTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_VARYING_COMPONENTS_EXT = GLenum::GL_MAX_VERTEX_VARYING_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = GLenum::GL_MAX_GEOMETRY_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = GLenum::GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = GLenum::GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_OUTPUT_VERTICES = GLenum::GL_MAX_GEOMETRY_OUTPUT_VERTICES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = GLenum::GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = GLenum::GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = GLenum::GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = GLenum::GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = GLenum::GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = GLenum::GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = GLenum::GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = GLenum::GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SUBROUTINES = GLenum::GL_MAX_SUBROUTINES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = GLenum::GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_NAMED_STRING_LENGTH_ARB = GLenum::GL_NAMED_STRING_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NAMED_STRING_TYPE_ARB = GLenum::GL_NAMED_STRING_TYPE_ARB;
GLBINDING_CO