/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns;

import java.awt.Image;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.plugin.manipulators.ui.GeneralNumberListStatisticsReportUI;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NumberColumnStatisticsReport
implements AttributeColumnsManipulator {
    public void execute(Table table, Column column) {
    }

    public String getName() {
        return this.getMessage("NumberColumnStatisticsReport.name");
    }

    public String getDescription() {
        return this.getMessage("NumberColumnStatisticsReport.description");
    }

    public boolean canManipulateColumn(Table table, Column column) {
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        return AttributeUtils.isNumberType((Class)column.getTypeClass()) && ac.getTableRowsCount(table) > 0;
    }

    public AttributeColumnsManipulatorUI getUI(Table table, Column column) {
        return new GeneralNumberListStatisticsReportUI(this.getColumnNumbers(table, column), column.getTitle(), this.getName());
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 100;
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/gephi/datalab/plugin/manipulators/resources/statistics.png");
    }

    public Number[] getColumnNumbers(Table table, Column column) {
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        Number[] columnNumbers = ac.getColumnNumbers(table, column);
        return columnNumbers;
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(NumberColumnStatisticsReport.class, (String)resName);
    }
}

