/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.util.ArrayList;
import java.util.Collection;
import org.gephi.appearance.PartitionImpl;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;

public class EdgeTypePartitionImpl
extends PartitionImpl {
    protected final Graph graph;
    protected final GraphModel model;

    public EdgeTypePartitionImpl(Graph graph) {
        this.graph = graph;
        this.model = graph.getModel();
    }

    @Override
    protected void refresh() {
    }

    @Override
    public Collection getValues() {
        Object[] labels = this.model.getEdgeTypeLabels();
        ArrayList<Object> col = new ArrayList<Object>(labels.length);
        for (Object l : labels) {
            if (l == null && this.graph.getEdgeCount(0) == 0) continue;
            col.add(l);
        }
        return col;
    }

    @Override
    public Object getValue(Element element, Graph gr) {
        return ((Edge)element).getTypeLabel();
    }

    @Override
    public int getElementCount() {
        return this.graph.getEdgeCount();
    }

    @Override
    public int count(Object value) {
        return this.graph.getEdgeCount(this.model.getEdgeType(value));
    }

    @Override
    public float percentage(Object value) {
        int count = this.count(value);
        return (float)count / (float)this.graph.getEdgeCount();
    }

    @Override
    public int size() {
        int size = this.model.getEdgeTypeCount();
        return this.graph.getEdgeCount(0) == 0 ? size - 1 : size;
    }

    @Override
    public Column getColumn() {
        return null;
    }
}

