/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;

public class DefaultTaskOutputCachingState
implements TaskOutputCachingState {
    private final String disabledReason;
    private final TaskOutputCachingDisabledReasonCategory disabledReasonCategory;

    public static TaskOutputCachingState enabled() {
        return new DefaultTaskOutputCachingState(null, null);
    }

    public static TaskOutputCachingState disabled(TaskOutputCachingDisabledReasonCategory disabledReasonCategory, String disabledReason) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)disabledReason) ? 1 : 0) != 0, (Object)"disabledReason must be set if task output caching is disabled");
        Preconditions.checkNotNull((Object)((Object)disabledReasonCategory), (Object)"disabledReasonCategory must be set if task output caching is disabled");
        return new DefaultTaskOutputCachingState(disabledReasonCategory, disabledReason);
    }

    private DefaultTaskOutputCachingState(TaskOutputCachingDisabledReasonCategory disabledReasonCategory, String disabledReason) {
        this.disabledReasonCategory = disabledReasonCategory;
        this.disabledReason = disabledReason;
    }

    @Override
    public boolean isEnabled() {
        return this.disabledReason == null;
    }

    @Override
    @Nullable
    public String getDisabledReason() {
        return this.disabledReason;
    }

    @Override
    @Nullable
    public TaskOutputCachingDisabledReasonCategory getDisabledReasonCategory() {
        return this.disabledReasonCategory;
    }

    public String toString() {
        return "DefaultTaskOutputCachingState{disabledReason='" + this.disabledReason + '\'' + ", disabledReasonCategory=" + (Object)((Object)this.disabledReasonCategory) + '}';
    }
}

