/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "generateParameterNameInAssertion", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "throwErrorFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "ir.backend.common"})
public final class LateinitLowering
implements FileLoweringPass {
    private final IrSimpleFunction throwErrorFunction;
    @NotNull
    private final CommonBackendContext context;
    private final boolean generateParameterNameInAssertion;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ LateinitLowering this$0;

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                if (declaration.isLateinit() && Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) ^ true) {
                    IrField irField = declaration.getBackingField();
                    if (irField == null) {
                        Intrinsics.throwNpe();
                    }
                    IrSimpleFunction irSimpleFunction = declaration.getGetter();
                    if (irSimpleFunction == null) {
                        Intrinsics.throwNpe();
                    }
                    this.transformGetter(irField, irSimpleFunction);
                }
                return declaration;
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration) {
                IrVariable irVariable;
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                if (!declaration.isLateinit()) {
                    return declaration;
                }
                IrVariable $receiver = irVariable = declaration;
                $receiver.setInitializer(IrConstImpl.Companion.constNull($receiver.getStartOffset(), $receiver.getEndOffset(), $receiver.getType()));
                return declaration;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                DeclarationIrBuilder irBuilder;
                DeclarationIrBuilder declarationIrBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                if (!(irValueDeclaration instanceof IrVariable)) {
                    irValueDeclaration = null;
                }
                IrVariable irVariable = (IrVariable)irValueDeclaration;
                if (irVariable == null) {
                    return expression2;
                }
                IrVariable irVar = irVariable;
                if (!irVar.isLateinit()) {
                    return expression2;
                }
                IrDeclarationParent irDeclarationParent = irVar.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                }
                IrSymbolOwner parent2 = (IrSymbolOwner)((Object)irDeclarationParent);
                DeclarationIrBuilder $receiver = declarationIrBuilder = (irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), parent2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset()));
                IrBuilderWithScope irBuilderWithScope = $receiver;
                IrType irType = expression2.getType();
                IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($receiver, ExpressionHelpersKt.irGet($receiver, irVar));
                IrBuilderWithScope irBuilderWithScope2 = $receiver;
                String string = irVar.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"irVar.name.asString()");
                return ExpressionHelpersKt.irIfThenElse(irBuilderWithScope, irType, irExpression, LateinitLowering.access$throwUninitializedPropertyAccessException(this.this$0, irBuilderWithScope2, string), ExpressionHelpersKt.irGet($receiver, irVar));
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.this$0.getContext().getIr().getSymbols().getLateinitIsInitializedPropertyGetter()) ^ true) {
                    return expression2;
                }
                IrExpression irExpression = expression2.getExtensionReceiver();
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrPropertyReference");
                }
                IrPropertyReference receiver2 = (IrPropertyReference)irExpression;
                Object object = receiver2.getGetter();
                IrProperty irProperty = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = IrUtilsKt.resolveFakeOverride((IrSimpleFunction)object)) != null ? object.getCorrespondingProperty() : null;
                if (irProperty == null) {
                    Intrinsics.throwNpe();
                }
                Object object2 = irProperty;
                IrProperty it = object2;
                boolean bl = it.isLateinit();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrProperty property = object2;
                Object $receiver = object2 = expression2;
                $receiver = object2 = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), $receiver.getSymbol(), $receiver.getStartOffset(), $receiver.getEndOffset());
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$receiver;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$receiver;
                IrExpression irExpression2 = receiver2.getDispatchReceiver();
                IrField irField = property.getBackingField();
                if (irField == null) {
                    Intrinsics.throwNpe();
                }
                return ExpressionHelpersKt.irNotEquals(irBuilderWithScope, ExpressionHelpersKt.irGetField(irBuilderWithScope2, irExpression2, irField), ExpressionHelpersKt.irNull((IrBuilderWithScope)$receiver));
            }

            private final void transformGetter(IrField backingField2, IrFunction getter2) {
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                DeclarationIrBuilder declarationIrBuilder;
                boolean bl;
                IrType type2 = backingField2.getType();
                boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType(type2);
                if (_Assertions.ENABLED && !bl) {
                    String string = "'lateinit' modifier is not allowed on primitive types";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int startOffset = getter2.getStartOffset();
                int endOffset = getter2.getEndOffset();
                DeclarationIrBuilder $receiver = declarationIrBuilder = (irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), getter2.getSymbol(), startOffset, endOffset));
                IrBlockBodyImpl body = new IrBlockBodyImpl(startOffset, endOffset);
                Scope scope = $receiver.getScope();
                IrBuilderWithScope irBuilderWithScope = $receiver;
                IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2 = irValueParameter;
                    IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                    Scope scope2 = scope;
                    IrValueParameter it = irValueParameter2;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($receiver, it);
                    scope = scope2;
                    irBuilderWithScope = irBuilderWithScope2;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                IrVariable resultVar = Scope.createTemporaryVariable$default(scope, ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, backingField2), null, false, null, null, null, 62, null);
                resultVar.setParent(getter2);
                body.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope3 = $receiver;
                IrType irType = $receiver.getContext().getIrBuiltIns().getNothingType();
                IrExpression irExpression = ExpressionHelpersKt.irNotEquals($receiver, ExpressionHelpersKt.irGet($receiver, resultVar), ExpressionHelpersKt.irNull($receiver));
                IrExpression irExpression2 = ExpressionHelpersKt.irReturn($receiver, ExpressionHelpersKt.irGet($receiver, resultVar));
                IrBuilderWithScope irBuilderWithScope4 = $receiver;
                String string = backingField2.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"backingField.name.asString()");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse(irBuilderWithScope3, irType, irExpression, irExpression2, LateinitLowering.access$throwUninitializedPropertyAccessException(this.this$0, irBuilderWithScope4, string));
                body.getStatements().add(throwIfNull);
                getter2.setBody(body);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final IrCall throwUninitializedPropertyAccessException(@NotNull IrBuilderWithScope $receiver, String name) {
        IrCall irCall;
        IrCall $receiver2 = irCall = ExpressionHelpersKt.irCall($receiver, this.throwErrorFunction);
        if (this.generateParameterNameInAssertion) {
            $receiver2.putValueArgument(0, IrConstImpl.Companion.string(-1, -1, $receiver.getContext().getIrBuiltIns().getStringType(), name));
        }
        return irCall;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public LateinitLowering(@NotNull CommonBackendContext context, boolean generateParameterNameInAssertion) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.generateParameterNameInAssertion = generateParameterNameInAssertion;
        this.throwErrorFunction = (IrSimpleFunction)this.context.getIr().getSymbols().getThrowUninitializedPropertyAccessException().getOwner();
    }

    public /* synthetic */ LateinitLowering(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    public static final /* synthetic */ IrCall access$throwUninitializedPropertyAccessException(LateinitLowering $this, IrBuilderWithScope $receiver, String name) {
        return $this.throwUninitializedPropertyAccessException($receiver, name);
    }
}

