/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreBundle;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyVariantReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceBase;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiJavaModuleReference
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement> {
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_COMPLETE = Key.create("java.module.ref.text.resolve.complete");
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_INCOMPLETE = Key.create("java.module.ref.text.resolve.incomplete");

    public PsiJavaModuleReference(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(0);
        }
        super(element, new TextRange(0, element.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newName2) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element;
        if (newName2 == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(3);
        }
        if ((element = (PsiJavaModuleReferenceElement)this.getElement()) instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaCoreBundle.message("psi.error.attempt.to.edit.class.file", element.getContainingFile()));
        }
        PsiJavaModuleReferenceElement newElement = PsiElementFactory.SERVICE.getInstance(element.getProject()).createModuleReferenceFromText(newName2);
        return element.replace(newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiJavaModule resolve(@Nullable PsiJavaModuleReferenceElement refElement) {
        PsiElement result2;
        PsiPolyVariantReference ref;
        if (refElement != null && (ref = refElement.getReference()) != null && (result2 = ref.resolve()) instanceof PsiJavaModule) {
            return (PsiJavaModule)result2;
        }
        return null;
    }

    @Nullable
    public static PsiJavaModule resolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        Collection<PsiJavaModule> modules;
        if (refOwner == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(4);
        }
        return (modules = PsiJavaModuleReference.multiResolve(refOwner, refText, incompleteCode)).size() == 1 ? modules.iterator().next() : null;
    }

    @NotNull
    public static Collection<PsiJavaModule> multiResolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        if (refOwner == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty(refText)) {
            List<PsiJavaModule> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiJavaModuleReference.$$$reportNull$$$0(6);
            }
            return list2;
        }
        CachedValuesManager manager = CachedValuesManager.getManager(refOwner.getProject());
        Key key = incompleteCode ? K_INCOMPLETE : K_COMPLETE;
        Collection collection = (Collection)manager.getCachedValue(refOwner, key, () -> {
            if (refOwner == null) {
                PsiJavaModuleReference.$$$reportNull$$$0(8);
            }
            Collection modules = Resolver.findModules(refOwner.getContainingFile(), refText, incompleteCode);
            return CachedValueProvider.Result.create(modules, PsiJavaModuleReference.cacheDependency());
        }, false);
        if (collection == null) {
            PsiJavaModuleReference.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static Object cacheDependency() {
        return PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$multiResolve$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReference> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReference> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReference reference, boolean incompleteCode) {
            PsiJavaModule module2;
            if (reference == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            PsiJavaModuleReferenceElement refElement = (PsiJavaModuleReferenceElement)reference.getElement();
            PsiFile file2 = refElement.getContainingFile();
            String moduleName = reference.getCanonicalText();
            if (file2 instanceof PsiJavaFile && (module2 = ((PsiJavaFile)file2).getModuleDeclaration()) != null && module2.getName().equals(moduleName)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(module2)};
                if (resolveResultArray == null) {
                    Resolver.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            boolean global = incompleteCode || refElement.getParent() instanceof PsiPackageAccessibilityStatement;
            Collection<PsiJavaModule> modules = Resolver.findModules(file2, moduleName, global);
            if (!modules.isEmpty()) {
                ResolveResult[] result2 = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module3 : modules) {
                    result2[i++] = new PsiElementResolveResult(module3);
                }
                if (result2 == null) {
                    Resolver.$$$reportNull$$$0(2);
                }
                return result2;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static Collection<PsiJavaModule> findModules(PsiFile file2, String moduleName, boolean global) {
            Project project = file2.getProject();
            GlobalSearchScope scope = global ? GlobalSearchScope.allScope(project) : file2.getResolveScope();
            return JavaFileManager.getInstance(project).findModules(moduleName, scope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

