/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.download;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.osmand.AndroidUtils;
import net.osmand.map.OsmandRegions;
import net.osmand.plus.Version;
import net.osmand.plus.download.IndexItem;
import net.osmand.plus.helpers.FileNameTranslationHelper;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;
import org.xmlpull.v1.XmlPullParser;

public class DownloadActivityType {
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy", Locale.US);
    private static Map<String, DownloadActivityType> byTag = new HashMap<String, DownloadActivityType>();
    public static final DownloadActivityType NORMAL_FILE = new DownloadActivityType(143, "map", 10);
    public static final DownloadActivityType VOICE_FILE = new DownloadActivityType(615, R.drawable.ic_action_volume_up, "voice", 20);
    public static final DownloadActivityType ROADS_FILE = new DownloadActivityType(144, "road_map", 30);
    public static final DownloadActivityType SRTM_COUNTRY_FILE = new DownloadActivityType(1060, R.drawable.ic_plugin_srtm, "srtm_map", 40);
    public static final DownloadActivityType HILLSHADE_FILE = new DownloadActivityType(128, R.drawable.ic_action_hillshade_dark, "hillshade", 50);
    public static final DownloadActivityType WIKIPEDIA_FILE = new DownloadActivityType(1760, R.drawable.ic_plugin_wikipedia, "wikimap", 60);
    public static final DownloadActivityType LIVE_UPDATES_FILE = new DownloadActivityType(1830, "live_updates", 70);
    private final int stringResource;
    private final int iconResource;
    private String tag;
    private int orderIndex;

    public DownloadActivityType(int stringResource, int iconResource, String tag, int orderIndex) {
        this.stringResource = stringResource;
        this.tag = tag;
        this.orderIndex = orderIndex;
        byTag.put(tag, this);
        this.iconResource = iconResource;
    }

    public DownloadActivityType(int stringResource, String tag, int orderIndex) {
        this.stringResource = stringResource;
        this.tag = tag;
        this.orderIndex = orderIndex;
        byTag.put(tag, this);
        this.iconResource = R.drawable.ic_map;
    }

    public int getStringResource() {
        return this.stringResource;
    }

    public int getIconResource() {
        return this.iconResource;
    }

    public String getTag() {
        return this.tag;
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public static boolean isCountedInDownloads(IndexItem es) {
        DownloadActivityType tp = es.getType();
        return (tp == NORMAL_FILE || tp == ROADS_FILE) && !es.extra;
    }

    public String getString(OsmWindow c) {
        return c.getString(this.stringResource);
    }

    public static DownloadActivityType getIndexType(String tagName) {
        return byTag.get(tagName);
    }

    protected static String addVersionToExt(String ext, int version) {
        return "_" + version + ext;
    }

    public boolean isAccepted(String fileName) {
        if (NORMAL_FILE == this) {
            return fileName.endsWith(DownloadActivityType.addVersionToExt(".obf.zip", 2)) || fileName.endsWith(".extra.zip") || fileName.endsWith(".sqlitedb");
        }
        if (ROADS_FILE == this) {
            return fileName.endsWith(DownloadActivityType.addVersionToExt(".road.obf.zip", 2));
        }
        if (VOICE_FILE == this) {
            return fileName.endsWith(DownloadActivityType.addVersionToExt(".voice.zip", 0));
        }
        if (WIKIPEDIA_FILE == this) {
            return fileName.endsWith(DownloadActivityType.addVersionToExt(".wiki.obf.zip", 2));
        }
        if (SRTM_COUNTRY_FILE == this) {
            return fileName.endsWith(DownloadActivityType.addVersionToExt(".srtm.obf.zip", 2));
        }
        if (HILLSHADE_FILE == this) {
            return fileName.endsWith(".sqlitedb");
        }
        return false;
    }

    public File getDownloadFolder(OsmWindow ctx, IndexItem indexItem) {
        if (NORMAL_FILE == this) {
            if (indexItem.fileName.endsWith(".sqlitedb")) {
                return ctx.getAppPath("tiles/");
            }
            return ctx.getAppPath("");
        }
        if (VOICE_FILE == this) {
            return ctx.getAppPath("voice/");
        }
        if (ROADS_FILE == this) {
            return ctx.getAppPath("roads/");
        }
        if (SRTM_COUNTRY_FILE == this) {
            return ctx.getAppPath("srtm/");
        }
        if (WIKIPEDIA_FILE == this) {
            return ctx.getAppPath("wiki/");
        }
        if (LIVE_UPDATES_FILE == this) {
            return ctx.getAppPath("live/");
        }
        if (HILLSHADE_FILE == this) {
            return ctx.getAppPath("tiles/");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isZipStream(OsmWindow ctx, IndexItem indexItem) {
        return HILLSHADE_FILE != this;
    }

    public boolean isZipFolder(OsmWindow ctx, IndexItem indexItem) {
        return this == VOICE_FILE;
    }

    public boolean preventMediaIndexing(OsmWindow ctx, IndexItem indexItem) {
        return this == VOICE_FILE && indexItem.fileName.endsWith(".voice.zip");
    }

    public String getUnzipExtension(OsmWindow ctx, IndexItem indexItem) {
        if (NORMAL_FILE == this) {
            if (indexItem.fileName.endsWith(".obf.zip")) {
                return ".obf";
            }
            if (indexItem.fileName.endsWith(".obf.zip")) {
                return ".obf";
            }
            if (indexItem.fileName.endsWith(".extra.zip")) {
                return ".extra";
            }
            if (indexItem.fileName.endsWith(".sqlitedb")) {
                return ".sqlitedb";
            }
            if (indexItem.fileName.endsWith("voice.zip")) {
                return "";
            }
        } else {
            if (ROADS_FILE == this) {
                return ".road.obf";
            }
            if (VOICE_FILE == this) {
                return "";
            }
            if (SRTM_COUNTRY_FILE == this) {
                return ".srtm.obf";
            }
            if (WIKIPEDIA_FILE == this) {
                return ".wiki.obf";
            }
            if (LIVE_UPDATES_FILE == this) {
                return ".obf";
            }
            if (HILLSHADE_FILE == this) {
                return ".sqlitedb";
            }
        }
        throw new UnsupportedOperationException();
    }

    public String getUrlSuffix(OsmWindow ctx) {
        if (this == ROADS_FILE) {
            return "&road=yes";
        }
        if (this == LIVE_UPDATES_FILE) {
            return "&osmc=yes";
        }
        if (this == SRTM_COUNTRY_FILE) {
            return "&srtmcountry=yes";
        }
        if (this == WIKIPEDIA_FILE) {
            return "&wiki=yes";
        }
        if (this == HILLSHADE_FILE) {
            return "&hillshade=yes";
        }
        return "";
    }

    public String getBaseUrl(OsmWindow ctx, String fileName) {
        return "http://download.osmand.net/download?event=2&" + Version.getVersionAsURLParam(ctx) + "&file=" + this.encode(fileName);
    }

    protected String encode(String fileName) {
        try {
            return URLEncoder.encode(fileName, "UTF-8");
        }
        catch (IOException e) {
            return fileName;
        }
    }

    public IndexItem parseIndexItem(OsmWindow ctx, XmlPullParser parser) {
        String name = parser.getAttributeValue(null, "name");
        if (!this.isAccepted(name)) {
            return null;
        }
        String size = parser.getAttributeValue(null, "size");
        String description = parser.getAttributeValue(null, "description");
        long containerSize = Algorithms.parseLongSilently(parser.getAttributeValue(null, "containerSize"), 0L);
        long contentSize = Algorithms.parseLongSilently(parser.getAttributeValue(null, "contentSize"), 0L);
        long timestamp = Algorithms.parseLongSilently(parser.getAttributeValue(null, "timestamp"), 0L);
        IndexItem it = new IndexItem(name, description, timestamp, size, contentSize, containerSize, this);
        boolean bl = FileNameTranslationHelper.getStandardMapName(ctx, it.getBasename().toLowerCase()) != null;
        it.extra = bl;
        return it;
    }

    protected static String reparseDate(OsmWindow ctx, String date) {
        try {
            Date d = simpleDateFormat.parse(date);
            return AndroidUtils.formatDate(d.getTime());
        }
        catch (ParseException e) {
            return date;
        }
    }

    public String getVisibleDescription(IndexItem indexItem, OsmWindow ctx) {
        if (this == SRTM_COUNTRY_FILE) {
            return ctx.getString(1060);
        }
        if (this == WIKIPEDIA_FILE) {
            return ctx.getString(1752);
        }
        if (this == ROADS_FILE) {
            return ctx.getString(142);
        }
        return "";
    }

    public String getVisibleName(IndexItem indexItem, OsmWindow ctx, OsmandRegions osmandRegions, boolean includingParent) {
        if (this == VOICE_FILE) {
            String fileName = indexItem.fileName;
            if (fileName.endsWith(".voice.zip")) {
                return FileNameTranslationHelper.getVoiceName(ctx, this.getBasename(indexItem));
            }
            if (fileName.endsWith(".ttsvoice.zip")) {
                return FileNameTranslationHelper.getVoiceName(ctx, this.getBasename(indexItem));
            }
            return this.getBasename(indexItem);
        }
        String basename = this.getBasename(indexItem);
        if (basename.endsWith("_wiki")) {
            return FileNameTranslationHelper.getWikiName(ctx, basename);
        }
        String lc = basename.toLowerCase();
        String std = FileNameTranslationHelper.getStandardMapName(ctx, lc);
        if (std != null) {
            return std;
        }
        if (basename.contains("addresses-nationwide")) {
            int ind = basename.indexOf("addresses-nationwide");
            String downloadName = basename.substring(0, ind - 1) + basename.substring(ind + "addresses-nationwide".length());
            return osmandRegions.getLocaleName(downloadName, includingParent) + " " + ctx.getString(320);
        }
        return osmandRegions.getLocaleName(basename, includingParent);
    }

    public String getTargetFileName(IndexItem item) {
        String fileName = item.fileName;
        if (this == VOICE_FILE) {
            int l = fileName.lastIndexOf(95);
            if (l == -1) {
                l = fileName.length();
            }
            return fileName.substring(0, l);
        }
        if (this == HILLSHADE_FILE) {
            return fileName.replace('_', ' ');
        }
        if (this == LIVE_UPDATES_FILE) {
            int l = fileName.lastIndexOf(46);
            if (l == -1) {
                l = fileName.length();
            }
            return fileName.substring(0, l) + ".obf";
        }
        if (fileName.endsWith(".obf") || fileName.endsWith(".obf.zip")) {
            int l = fileName.lastIndexOf(95);
            if (l == -1) {
                l = fileName.length();
            }
            String baseNameWithoutVersion = fileName.substring(0, l);
            if (this == SRTM_COUNTRY_FILE) {
                return baseNameWithoutVersion + ".srtm.obf";
            }
            if (this == WIKIPEDIA_FILE) {
                return baseNameWithoutVersion + ".wiki.obf";
            }
            if (this == ROADS_FILE) {
                return baseNameWithoutVersion + ".road.obf";
            }
            baseNameWithoutVersion = baseNameWithoutVersion + ".obf";
            return baseNameWithoutVersion;
        }
        if (fileName.endsWith(".sqlitedb")) {
            return fileName.replace('_', ' ');
        }
        if (fileName.endsWith(".extra.zip")) {
            return fileName.substring(0, fileName.length() - ".extra.zip".length()) + ".extra";
        }
        return fileName;
    }

    public String getBasename(IndexItem indexItem) {
        String fileName = indexItem.fileName;
        if (fileName.endsWith(".extra.zip")) {
            return fileName.substring(0, fileName.length() - ".extra.zip".length());
        }
        if (this == HILLSHADE_FILE) {
            return fileName.substring(0, fileName.length() - ".sqlitedb".length()).replace("Hillshade_", "");
        }
        if (fileName.endsWith(".sqlitedb")) {
            return fileName.substring(0, fileName.length() - ".sqlitedb".length());
        }
        if (this == VOICE_FILE) {
            int l = fileName.lastIndexOf(95);
            if (l == -1) {
                l = fileName.length();
            }
            return fileName.substring(0, l);
        }
        if (this == LIVE_UPDATES_FILE) {
            if (fileName.indexOf(46) > 0) {
                return fileName.substring(0, fileName.indexOf(46));
            }
            return fileName;
        }
        int ls = fileName.lastIndexOf(95);
        if (ls >= 0) {
            return fileName.substring(0, ls);
        }
        if (fileName.indexOf(46) > 0) {
            return fileName.substring(0, fileName.indexOf(46));
        }
        return fileName;
    }
}

