/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.data.RotatedTileBox;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.plus.views.OsmandMapLayer;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.ISelectionInterface;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.Paint;
import org.apache.commons.logging.Log;

public class DrawPolylineLayer
extends OsmandMapLayer
implements ISelectionInterface,
DirectOffroadLayer,
IContextMenuProvider {
    private static final int SELECTION_RADIUS = 20;
    private static final Log log = PlatformUtil.getLog(DrawPolylineLayer.class);
    private static final String POLYLINES_STORAGE = "POLYLINES_STORAGE";
    private OsmBitmapPanel mDrawPanel;
    private Paint area;
    private Paint areaSelected;
    private Polylines mPolylines = new Polylines();
    private int mSelectedIndex = -1;

    public Polyline getSelectedPolyline() {
        if (this.checkIndex()) {
            return this.mPolylines.get(this.mSelectedIndex);
        }
        return null;
    }

    public boolean checkIndex() {
        return this.mSelectedIndex >= 0 && this.mSelectedIndex < this.mPolylines.size();
    }

    public DrawPolylineLayer(OsmBitmapPanel pOsmBitmapPanel) {
        this.mDrawPanel = pOsmBitmapPanel;
    }

    @Override
    public void initLayer(OsmBitmapPanel pView) {
        Object storage;
        this.area = new Paint();
        this.area.setColor(this.mDrawPanel.getResources().getColor(R.color.region_downloading));
        this.area.setStrokeWidth(2.0f * this.mDrawPanel.getScaleCoefficient());
        this.areaSelected = new Paint();
        this.areaSelected.setColor(this.mDrawPanel.getResources().getColor(R.color.region_downloading));
        this.areaSelected.setStrokeWidth(4.0f * this.mDrawPanel.getScaleCoefficient());
        String storageResult = (String)pView.getContext().getOffroadProperties().get(POLYLINES_STORAGE);
        if (storageResult != null && (storage = OsmWindow.unmarshall(storageResult, this.getStorageClasses())) instanceof Polylines) {
            Polylines polylines;
            this.mPolylines = polylines = (Polylines)storage;
        }
    }

    @Override
    public void onDraw(Graphics2D pCanvas, RotatedTileBox pTileBox, OsmandMapLayer.DrawSettings pSettings) {
        Polyline selPolyline = this.getSelectedPolyline();
        for (Polyline polyline : this.mPolylines.getPolylineItems()) {
            if (selPolyline == polyline) {
                this.areaSelected.updateGraphics(pCanvas);
            } else {
                this.area.updateGraphics(pCanvas);
            }
            for (int i = 0; i < polyline.size(); ++i) {
                LatLon point = polyline.get(i);
                int locationX1 = (int)pTileBox.getPixXFromLatLon(point);
                int locationY1 = (int)pTileBox.getPixYFromLatLon(point);
                if (i < polyline.size() - 1) {
                    LatLon nextPoint = polyline.get(i + 1);
                    int locationX2 = (int)pTileBox.getPixXFromLatLon(nextPoint);
                    int locationY2 = (int)pTileBox.getPixYFromLatLon(nextPoint);
                    pCanvas.drawLine(locationX1, locationY1, locationX2, locationY2);
                }
                if (selPolyline != polyline) continue;
                int circleRadius = (int)(8.0f * this.mDrawPanel.getScaleCoefficient());
                pCanvas.fillOval(locationX1 - circleRadius, locationY1 - circleRadius, 2 * circleRadius, 2 * circleRadius);
            }
        }
    }

    @Override
    public void destroyLayer() {
        String res = OsmWindow.marshall(this.mPolylines, this.getStorageClasses());
        log.info((Object)("Storage: " + res));
        OsmWindow.getInstance().getOffroadProperties().put(POLYLINES_STORAGE, res);
    }

    public Class[] getStorageClasses() {
        return new Class[]{Polyline.class, LatLon.class, Polylines.class};
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }

    @Override
    public String getObjectDescription(Object pO) {
        return null;
    }

    @Override
    public PointDescription getObjectName(Object pO) {
        return null;
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public boolean isObjectClickable(Object pO) {
        return false;
    }

    @Override
    public void collectObjectsFromPoint(Point2D pPoint, RotatedTileBox pTileBox, List<Object> pRes) {
        Point pDest = this.convertToPoint(pPoint);
        for (Polyline polyline : this.mPolylines.getPolylineItems()) {
            if (!(polyline.getDistance(pDest, this.mDrawPanel) < 20.0)) continue;
            pRes.add(polyline);
        }
    }

    public Point convertToPoint(Point2D pPoint) {
        return new Point((int)pPoint.getX(), (int)pPoint.getY());
    }

    @Override
    public LatLon getObjectLocation(Object pO) {
        return null;
    }

    public void addPolylinePoint(Point pPoint) {
        Polyline polyline = this.getSelectedPolyline();
        if (polyline == null) {
            polyline = new Polyline();
            this.mPolylines.add(polyline);
            this.mSelectedIndex = this.mPolylines.size() - 1;
        }
        if (polyline.isEmpty()) {
            LatLon cursorPosition = this.mDrawPanel.getCursorPosition();
            if (cursorPosition == null) {
                return;
            }
            polyline.add(cursorPosition);
        }
        polyline.add(this.mDrawPanel.getLatLon(pPoint));
    }

    public void endPolyline() {
        this.mSelectedIndex = -1;
    }

    @Override
    public boolean isSelection(Point pDest) {
        for (Polyline polyline : this.mPolylines.getPolylineItems()) {
            if (!(polyline.getDistance(pDest, this.mDrawPanel) < 20.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelection(Point pDest) {
        int i = 0;
        for (Polyline polyline : this.mPolylines.getPolylineItems()) {
            if (polyline.getDistance(pDest, this.mDrawPanel) < 20.0) {
                this.mSelectedIndex = i;
                return;
            }
            ++i;
        }
    }

    @Override
    public ISelectionInterface.IDragInformation isDragPoint(Point pLastDragPoint, Point pPoint) {
        if (!this.checkIndex()) {
            return null;
        }
        EdgeDistance distanceToEdges = this.mPolylines.get(this.mSelectedIndex).getDistanceToEdges(pPoint, this.mDrawPanel);
        if (distanceToEdges.distance < 20.0) {
            PolylinePointDragInformation info = new PolylinePointDragInformation();
            info.mPolyline = distanceToEdges.mPolyline;
            info.mIndex = distanceToEdges.index;
            return info;
        }
        return null;
    }

    @Override
    public void drag(Point pNewPoint, ISelectionInterface.IDragInformation pInfo) {
        if (!this.checkIndex()) {
            return;
        }
        if (pInfo instanceof PolylinePointDragInformation) {
            PolylinePointDragInformation polyInfo = (PolylinePointDragInformation)pInfo;
            int indexOf = polyInfo.mIndex;
            Polyline polyline = polyInfo.mPolyline;
            if (indexOf < polyline.size()) {
                polyline.set(indexOf, this.mDrawPanel.getLatLon(pNewPoint));
            }
        }
    }

    public void remove(Polyline pPolyline) {
        Polyline sel = null;
        if (this.checkIndex()) {
            sel = this.mPolylines.get(this.mSelectedIndex);
        }
        this.mPolylines.remove(pPolyline);
        this.mSelectedIndex = sel != null && this.mPolylines.contains(sel) ? this.mPolylines.indexOf(sel) : -1;
    }

    @XmlRootElement
    public static class Polyline {
        private Vector<LatLon> mCoordinates = new Vector();

        public LatLon set(int pIndex, LatLon pElement) {
            return this.mCoordinates.set(pIndex, pElement);
        }

        public boolean contains(Object pO) {
            return this.mCoordinates.contains(pO);
        }

        public int indexOf(Object pO) {
            return this.mCoordinates.indexOf(pO);
        }

        public boolean remove(Object pO) {
            return this.mCoordinates.remove(pO);
        }

        public int size() {
            return this.mCoordinates.size();
        }

        public boolean isEmpty() {
            return this.mCoordinates.isEmpty();
        }

        public LatLon get(int pIndex) {
            return this.mCoordinates.get(pIndex);
        }

        public boolean add(LatLon pE) {
            return this.mCoordinates.add(pE);
        }

        @XmlElement(name="latlon")
        public Vector<LatLon> getCoordinates() {
            return this.mCoordinates;
        }

        public void setCoordinates(Vector<LatLon> pItems) {
            this.mCoordinates = pItems;
        }

        public EdgeDistance getDistanceToEdges(Point pDest, OsmBitmapPanel pDrawPanel) {
            double minDist = Double.MAX_VALUE;
            Point minPointP = null;
            int index = 0;
            int minIndex = -1;
            for (LatLon latLonP : this.getCoordinates()) {
                Point pointP = pDrawPanel.getPoint(latLonP);
                double dist = pDest.distance(pointP);
                if (dist < minDist) {
                    minIndex = index;
                    minDist = dist;
                    minPointP = pointP;
                }
                ++index;
            }
            EdgeDistance ret = new EdgeDistance(minDist, this, minIndex, minPointP);
            return ret;
        }

        public double getDistance(Point pDest, OsmBitmapPanel pDrawPanel) {
            double minDist = Double.MAX_VALUE;
            Point lastPointInLine = null;
            for (LatLon latLonP : this.getCoordinates()) {
                Point pointP = pDrawPanel.getPoint(latLonP);
                if (lastPointInLine != null) {
                    minDist = Math.min(this.getDistance(pDest, pointP, lastPointInLine), minDist);
                }
                lastPointInLine = pointP;
            }
            return minDist;
        }

        public double getDistance(Point pDest, Point pointA, Point pointB) {
            float yy;
            float xx;
            float x1 = pointA.x;
            float y1 = pointA.y;
            float x2 = pointB.x;
            float y2 = pointB.y;
            float x = pDest.x;
            float y = pDest.y;
            float A = x - x1;
            float B = y - y1;
            float C = x2 - x1;
            float D = y2 - y1;
            float dot = A * C + B * D;
            float len_sq = C * C + D * D;
            float param = -1.0f;
            if (len_sq != 0.0f) {
                param = dot / len_sq;
            }
            if (param < 0.0f) {
                xx = x1;
                yy = y1;
            } else if (param > 1.0f) {
                xx = x2;
                yy = y2;
            } else {
                xx = x1 + param * C;
                yy = y1 + param * D;
            }
            float dx = x - xx;
            float dy = y - yy;
            return Math.sqrt(dx * dx + dy * dy);
        }

        public double calculateArea() {
            Vector<Node> v = new Vector<Node>();
            for (LatLon latLon : this.getCoordinates()) {
                v.add(new Node(latLon.getLatitude(), latLon.getLongitude(), 1L));
            }
            return OsmMapUtils.getArea(v);
        }

        public float calculateLength() {
            float polyDist = 0.0f;
            for (int i = 0; i < this.size(); ++i) {
                LatLon pos = this.get(i);
                if (i + 1 >= this.size()) continue;
                LatLon pos2 = this.get(i + 1);
                polyDist = (float)((double)polyDist + MapUtils.getDistance(pos, pos2));
            }
            polyDist = (float)((double)polyDist / 1000.0);
            return polyDist;
        }
    }

    @XmlRootElement
    public static class Polylines {
        private Vector<Polyline> mPolylineItems = new Vector();

        public boolean contains(Object pO) {
            return this.mPolylineItems.contains(pO);
        }

        public int indexOf(Object pO) {
            return this.mPolylineItems.indexOf(pO);
        }

        public boolean remove(Object pO) {
            return this.mPolylineItems.remove(pO);
        }

        public int size() {
            return this.mPolylineItems.size();
        }

        public boolean isEmpty() {
            return this.mPolylineItems.isEmpty();
        }

        public Polyline get(int pIndex) {
            return this.mPolylineItems.get(pIndex);
        }

        public boolean add(Polyline pE) {
            return this.mPolylineItems.add(pE);
        }

        @XmlElement(name="polyline")
        public Vector<Polyline> getPolylineItems() {
            return this.mPolylineItems;
        }

        public void setPolylineItems(Vector<Polyline> pItems) {
            this.mPolylineItems = pItems;
        }
    }

    public static class EdgeDistance {
        double distance;
        Polyline mPolyline;
        int index;
        private Point mPointP;

        public EdgeDistance(double pDistance, Polyline pPolyline, int pIndex, Point pPointP) {
            this.distance = pDistance;
            this.mPolyline = pPolyline;
            this.index = pIndex;
            this.mPointP = pPointP;
        }

        public String toString() {
            return "EdgeDistance [distance=" + this.distance + ", mPolyline=" + this.mPolyline + ", index=" + this.index + ", mPointP=" + this.mPointP + "]";
        }
    }

    private static class PolylinePointDragInformation
    implements ISelectionInterface.IDragInformation {
        public Polyline mPolyline;
        public int mIndex;

        private PolylinePointDragInformation() {
        }
    }
}

