/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.osmand.IProgress;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.ValueHolder;
import net.osmand.data.Amenity;
import net.osmand.data.FavouritePoint;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.data.MapObject;
import net.osmand.data.PointDescription;
import net.osmand.data.RotatedTileBox;
import net.osmand.map.OsmandRegions;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiType;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.FavouritesDbHelper;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.GeocodingLookupService;
import net.osmand.plus.GpxSelectionHelper;
import net.osmand.plus.MapMarkersHelper;
import net.osmand.plus.OsmAndLocationProvider;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.plus.activities.SavingTrackHelper;
import net.osmand.plus.api.SQLiteAPI;
import net.osmand.plus.inapp.util.Base64;
import net.osmand.plus.inapp.util.Base64DecoderException;
import net.osmand.plus.poi.PoiFiltersHelper;
import net.osmand.plus.poi.PoiUIFilter;
import net.osmand.plus.render.MapRenderRepositories;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.plus.render.RendererRegistry;
import net.osmand.plus.render.RenderingIcons;
import net.osmand.plus.resources.ResourceManager;
import net.osmand.plus.routing.RouteCalculationResult;
import net.osmand.plus.routing.RouteDirectionInfo;
import net.osmand.plus.routing.RouteProvider;
import net.osmand.plus.routing.RoutingHelper;
import net.osmand.plus.views.DrawPolylineLayer;
import net.osmand.plus.views.POIMapLayer;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.router.GeneralRouter;
import net.osmand.router.RoutingConfiguration;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.GeoServer;
import net.sourceforge.offroad.OffRoadSettings;
import net.sourceforge.offroad.ProxyAuthenticator;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.actions.AboutDialogAction;
import net.sourceforge.offroad.actions.AddFavoriteAction;
import net.sourceforge.offroad.actions.ChangeIconSizeAction;
import net.sourceforge.offroad.actions.ChooseApplicationModeAction;
import net.sourceforge.offroad.actions.ChooseRendererAction;
import net.sourceforge.offroad.actions.ChooseRouteServiceAction;
import net.sourceforge.offroad.actions.ClearRouteAction;
import net.sourceforge.offroad.actions.CopyLocationToClipboardAction;
import net.sourceforge.offroad.actions.DeleteFavoriteAction;
import net.sourceforge.offroad.actions.DirectSearchAction;
import net.sourceforge.offroad.actions.DownloadAction;
import net.sourceforge.offroad.actions.ExportRouteAction;
import net.sourceforge.offroad.actions.ExportTracksAction;
import net.sourceforge.offroad.actions.GpxImportAction;
import net.sourceforge.offroad.actions.NavigationBackAction;
import net.sourceforge.offroad.actions.NavigationForwardAction;
import net.sourceforge.offroad.actions.NavigationRotationAction;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.actions.PoiFilterAction;
import net.sourceforge.offroad.actions.PointNavigationAction;
import net.sourceforge.offroad.actions.RemovePolylineAction;
import net.sourceforge.offroad.actions.RouteAction;
import net.sourceforge.offroad.actions.SearchAddressAction;
import net.sourceforge.offroad.actions.SelectTrackAction;
import net.sourceforge.offroad.actions.SetCursorRadiusAction;
import net.sourceforge.offroad.actions.SetRenderingRule;
import net.sourceforge.offroad.actions.ShowFavoriteAction;
import net.sourceforge.offroad.actions.ShowRouteDetailsAction;
import net.sourceforge.offroad.actions.ShowTargetPointAction;
import net.sourceforge.offroad.actions.ShowTrackDetailsAction;
import net.sourceforge.offroad.actions.ShowWikipediaAction;
import net.sourceforge.offroad.data.LocationAsMapObject;
import net.sourceforge.offroad.data.QuadRectExtendable;
import net.sourceforge.offroad.data.SQLiteImpl;
import net.sourceforge.offroad.data.persistence.ComponentLocationStorage;
import net.sourceforge.offroad.data.persistence.OsmWindowLocationStorage;
import net.sourceforge.offroad.res.OffRoadResources;
import net.sourceforge.offroad.res.ResourceTest;
import net.sourceforge.offroad.res.Resources;
import net.sourceforge.offroad.ui.AmenityTablePanel;
import net.sourceforge.offroad.ui.AmenityTableUpdateThread;
import net.sourceforge.offroad.ui.BlindIcon;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OffRoadPopupMenuListener;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.OsmBitmapPanelMouseAdapter;
import net.sourceforge.offroad.ui.PoiFilterRenderer;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class OsmWindow
implements RoutingHelper.IRouteInformationListener {
    private static final Log log = PlatformUtil.getLog(OsmWindow.class);
    public static final int MAX_ZOOM = 22;
    public static final String RENDERING_STYLES_DIR = "rendering_styles/";
    private static final String OSMAND_ICONS_DIR = "rendering_styles/style-icons/drawable-";
    public static final String IMAGE_PATH = "drawable-";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_IS_AUTHENTICATED = "proxy.is_authenticated";
    public static final String PROXY_USE_SETTINGS = "proxy.use_settings";
    public static final String PROXY_EXCEPTION = "proxy.exception";
    private static final String OFFROAD_PROPERTIES = "offroad";
    public static final int MIN_ZOOM = 1;
    private static final String MODE_WORLD_WRITEABLE = "mode_world_writeable";
    private static final String VECTOR_INDEXES_CHECK = "vector_indexes_check";
    public static final String OSMAND_ICONS_DIR_PREFIX = "osmand_icons_dir_prefix";
    public static final String OSMAND_ICONS_DIR_DEFAULT_PREFIX = "hdpi";
    private static final String[] sOsmandIconsPrefixes = new String[]{"mdpi", "hdpi", "xhdpi", "xxhdpi"};
    private static OsmWindow sInstance = null;
    private ResourceManager mResourceManager;
    private OffRoadSettings settings = new OffRoadSettings(this);
    private OsmandSettings prefs = new OsmandSettings(this, this.settings);
    private Properties mOffroadProperties = (Properties)this.settings.getPreferenceObject("offroad");
    private R.string mStrings;
    private OsmandRegions mRegions;
    private OsmBitmapPanel mDrawPanel;
    private OsmBitmapPanelMouseAdapter mAdapter;
    private JFrame mFrame;
    private JLabel mStatusLabel;
    private JLabel mRouteProgressStatus;
    private JProgressBar mRouteProgressBar;
    private Timer mMouseMoveTimer;
    private GeoServer mGeoServer;
    public int widthPixels;
    public float density;
    public int heightPixels;
    private RendererRegistry mRendererRegistry;
    private TargetPointsHelper mTargetPointsHelper;
    private RoutingHelper mRoutingHelper;
    private GeocodingLookupService mGeocodingLookupService;
    private MapPoiTypes mMapPoiTypes;
    private int mDontUpdateStatusLabelCounter;
    private Resources mResourceStrings;
    private PropertyResourceBundle mOffroadResources;
    private Vector<MapPointStorage> mPointStorage = new Vector();
    private int mPointStorageIndex = -1;
    private JPanel mStatusBar;
    private PoiFiltersHelper mPoiFilters;
    private AmenityTablePanel mAmenityTable;
    private MapMarkersHelper mMapMarkersHelper;
    private JToolBar mToolBar;
    private JTextField mSearchTextField;
    private JComboBox<PoiUIFilter> mComboBox;
    private DefaultComboBoxModel<PoiUIFilter> mComboBoxModel;
    private boolean mSearchBarVisible = true;
    Vector<CursorPositionListener> mCursorPositionListeners = new Vector();
    private PoiUIFilter mCurrentPoiFilter;
    private SQLiteImpl mSqLiteImpl;
    private FavouritesDbHelper mFavorites;
    private OsmAndLocationProvider mOsmAndLocationProvider;
    private JSplitPane mSplitPane;
    private OffRoadResources mOffRoadResources;
    private GpxSelectionHelper mGpxSelectionHelper;
    private SavingTrackHelper mSavingTrackHelper;
    private VersionInfo mVersionInfo;
    private SearchType mSearchType = SearchType.AMENITY;
    private List<MapObject> mRouteResult = new Vector<MapObject>();
    private JMenuItem mAddFavourite;
    private JMenuItem mSelectTrack;
    private HashMap<String, BufferedImage> mBufferedImageCache = new HashMap();
    private JTextField mDirectSearchTextField;
    public DirectSearchAction mDirectSearchAction;
    private JPanel mDirectSearchPanel;
    private JCheckBox mDirectSearchFuzzy;
    private JButton mDirectSearchBackward;
    private JButton mDirectSearchForward;
    private JButton mDirectSearchClose;
    private boolean mDirectSearchVisible;

    public void createAndShowUI() {
        this.mDirectSearchTextField = new JTextField(this.getOffRoadString("offroad.DirectSearchText"));
        this.mDirectSearchFuzzy = new JCheckBox(this.getOffRoadString("offroad.fuzzy_search"));
        this.mDirectSearchFuzzy.setFocusable(false);
        this.mDirectSearchClose = new JButton(new ImageIcon(this.readImageInternally("button_cancel.png")));
        this.mDirectSearchBackward = new JButton(new ImageIcon(this.readImageInternally("up.png")));
        this.mDirectSearchForward = new JButton(new ImageIcon(this.readImageInternally("down.png")));
        this.mDirectSearchAction = new DirectSearchAction(this, this.mDirectSearchTextField, this.mDirectSearchFuzzy, this.mDirectSearchBackward, this.mDirectSearchForward, this.mDirectSearchClose);
        this.mDirectSearchClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                OsmWindow.this.mStatusBar.remove(OsmWindow.this.mDirectSearchPanel);
                OsmWindow.this.mDirectSearchVisible = false;
                OsmWindow.this.mFrame.revalidate();
            }
        });
        this.mDrawPanel = new OsmBitmapPanel(this);
        this.mAdapter = new OsmBitmapPanelMouseAdapter(this.mDrawPanel);
        this.mDrawPanel.addMouseListener(this.mAdapter);
        this.mDrawPanel.addMouseMotionListener(this.mAdapter);
        this.mDrawPanel.addMouseWheelListener(this.mAdapter);
        this.mStatusLabel = new JLabel("!");
        this.mStatusLabel.setPreferredSize(this.mStatusLabel.getPreferredSize());
        this.mRouteProgressBar = new JProgressBar();
        this.mRouteProgressBar.setMaximum(100);
        this.mRouteProgressBar.setStringPainted(true);
        this.mRouteProgressBar.setVisible(false);
        this.mRouteProgressStatus = new JLabel("!");
        this.mDirectSearchPanel = new JPanel();
        this.mDirectSearchPanel.setLayout(new GridBagLayout());
        int x = 0;
        this.mDirectSearchPanel.add((Component)this.mDirectSearchClose, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mDirectSearchPanel.add((Component)this.mDirectSearchTextField, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mDirectSearchPanel.add((Component)this.mDirectSearchBackward, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mDirectSearchPanel.add((Component)this.mDirectSearchForward, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mDirectSearchPanel.add((Component)this.mDirectSearchFuzzy, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.adaptMenuMnemonics(this.mDirectSearchPanel.getComponents());
        this.mStatusBar = new JPanel();
        this.mStatusBar.setLayout(new GridBagLayout());
        x = 0;
        this.mStatusBar.add((Component)this.mStatusLabel, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mDirectSearchVisible = false;
        int n = ++x;
        this.mStatusBar.add((Component)this.mRouteProgressStatus, new GridBagConstraints(n, 0, 1, 1, 0.0, 1.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        int n2 = ++x;
        ++x;
        this.mStatusBar.add((Component)this.mRouteProgressBar, new GridBagConstraints(n2, 0, 1, 1, 1.0, 1.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mMouseMoveTimer = new Timer(500, new StatusLabelAction());
        this.mMouseMoveTimer.setRepeats(true);
        this.mMouseMoveTimer.start();
        this.mToolBar = new JToolBar(0);
        this.mToolBar.setLayout(new GridBagLayout());
        this.mToolBar.add((Component)new JLabel(this.getOffRoadString("offroad.search")), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mSearchTextField = new JTextField();
        this.mSearchTextField.getInputMap().put(KeyStroke.getKeyStroke("control LEFT"), "none");
        this.mSearchTextField.getInputMap().put(KeyStroke.getKeyStroke("control RIGHT"), "none");
        this.mSearchTextField.setText(this.getSettings().SELECTED_POI_FILTER_STRING_FOR_MAP.get());
        this.mAmenityTable = new AmenityTablePanel(this);
        this.getSearchTextField().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                OsmWindow.this.setPoiFilter(OsmWindow.this.getCurrentPoiUIFilter(), OsmWindow.this.getSearchTextField().getText());
            }
        });
        this.getSearchTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent pE) {
            }

            @Override
            public void keyReleased(KeyEvent pE) {
            }

            @Override
            public void keyPressed(KeyEvent pE) {
                if (!pE.isControlDown()) {
                    return;
                }
                switch (pE.getKeyCode()) {
                    case 38: {
                        if (OsmWindow.this.mComboBox.getSelectedIndex() > 0) {
                            OsmWindow.this.mComboBox.setSelectedIndex(OsmWindow.this.mComboBox.getSelectedIndex() - 1);
                        }
                        pE.consume();
                        return;
                    }
                    case 40: {
                        if (OsmWindow.this.mComboBox.getSelectedIndex() < OsmWindow.this.mComboBox.getItemCount() - 1) {
                            OsmWindow.this.mComboBox.setSelectedIndex(OsmWindow.this.mComboBox.getSelectedIndex() + 1);
                        }
                        pE.consume();
                        return;
                    }
                }
            }
        });
        this.mToolBar.add((Component)this.getSearchTextField(), new GridBagConstraints(1, 0, 1, 1, 3.0, 1.0, 17, 1, new Insets(10, 0, 10, 0), 0, 0));
        this.mComboBox = new JComboBox();
        this.mComboBoxModel = new DefaultComboBoxModel();
        this.mCurrentPoiFilter = this.mPoiFilters.getSearchByNamePOIFilter();
        this.mComboBoxModel.addElement(this.mPoiFilters.getSearchByNamePOIFilter());
        this.mComboBoxModel.addElement(this.mPoiFilters.getNominatimAddressFilter());
        this.mComboBoxModel.addElement(this.mPoiFilters.getNominatimPOIFilter());
        for (PoiUIFilter filter : this.mPoiFilters.getTopDefinedPoiFilters()) {
            this.mComboBoxModel.addElement(filter);
        }
        this.mComboBox.setModel(this.mComboBoxModel);
        this.mComboBox.setFocusable(false);
        this.mComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                if (OsmWindow.this.mComboBox.getSelectedIndex() >= 0) {
                    OsmWindow.this.mCurrentPoiFilter = (PoiUIFilter)OsmWindow.this.mComboBoxModel.getElementAt(OsmWindow.this.mComboBox.getSelectedIndex());
                }
            }
        });
        this.mComboBox.setRenderer(new PoiFilterRenderer());
        this.mToolBar.add(this.mComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mFrame = new JFrame(this.getOffRoadString("offroad.string4"));
        this.mFrame.setIconImage(this.readImageInternally("offroad_icon.png"));
        this.mFrame.getContentPane().setLayout(new BorderLayout());
        this.mFrame.getContentPane().add((Component)this.mToolBar, "North");
        this.mSplitPane = new JSplitPane(1, this.mAmenityTable, this.mDrawPanel);
        this.mFrame.getContentPane().add(this.mSplitPane);
        this.mFrame.getContentPane().add((Component)this.mStatusBar, "South");
        this.mFrame.setDefaultCloseOperation(0);
        this.mFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                OsmWindow.this.closeWindow();
            }
        });
        this.mFrame.setResizable(true);
        this.mDrawPanel.addComponentListener(this.mAdapter);
        JMenuBar menubar = new JMenuBar();
        JMenu jFileMenu = new JMenu(this.getOffRoadString("offroad.string5"));
        JMenuItem saveItem = new JMenuItem(this.getOffRoadString("offroad.string6"));
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                JFileChooser chooser = new JFileChooser();
                int showSaveDialog = chooser.showSaveDialog(OsmWindow.this.mFrame);
                if (showSaveDialog == 0) {
                    OsmWindow.this.mDrawPanel.saveImage(chooser.getSelectedFile());
                }
            }
        });
        jFileMenu.add(saveItem);
        JMenuItem importGpxItem = new JMenuItem(this.getOffRoadString("offroad.import_gpx"));
        importGpxItem.addActionListener(new GpxImportAction(this));
        jFileMenu.add(importGpxItem);
        this.addToMenu(jFileMenu, "offroad.export_route", new ExportRouteAction(this), null);
        this.addToMenu(jFileMenu, "offroad.export_tracks", new ExportTracksAction(this), null);
        this.addToMenu(jFileMenu, "offroad.copy_location", new CopyLocationToClipboardAction(this), "alt C");
        this.addToMenu(jFileMenu, "offroad.exit", item -> this.closeWindow(), "control Q");
        menubar.add(jFileMenu);
        JMenu jSearchMenu = new JMenu(this.getOffRoadString("offroad.string7"));
        JMenuItem findItem = new JMenuItem(this.getOffRoadString("offroad.string8"));
        findItem.addActionListener(new SearchAddressAction(this));
        findItem.setAccelerator(KeyStroke.getKeyStroke("control F"));
        jSearchMenu.add(findItem);
        JMenuItem gotoSearchFieldItem = new JMenuItem(this.getOffRoadString("offroad.gotoSearchField"));
        gotoSearchFieldItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                OsmWindow.this.getSearchTextField().selectAll();
                OsmWindow.this.getSearchTextField().requestFocus();
            }
        });
        gotoSearchFieldItem.setAccelerator(KeyStroke.getKeyStroke("control K"));
        jSearchMenu.add(gotoSearchFieldItem);
        this.addToMenu(jSearchMenu, null, this.mDirectSearchAction, "control shift F");
        menubar.add(jSearchMenu);
        JMenu jDownloadMenu = new JMenu(this.getOffRoadString("offroad.download"));
        JMenuItem lDownloadItem = new JMenuItem(this.getOffRoadString("offroad.string11"));
        lDownloadItem.addActionListener(new DownloadAction(this));
        lDownloadItem.setAccelerator(KeyStroke.getKeyStroke("control G"));
        jDownloadMenu.add(lDownloadItem);
        menubar.add(jDownloadMenu);
        JMenu jViewMenu = new JMenu(this.getOffRoadString("offroad.view"));
        JMenuItem lViewItem = new JMenuItem(this.getOffRoadString("offroad.toggle_search"));
        lViewItem.addActionListener(item -> this.toggleSearchBar());
        lViewItem.setAccelerator(KeyStroke.getKeyStroke("F11"));
        jViewMenu.add(lViewItem);
        jViewMenu.add(new JMenuItem(new SetCursorRadiusAction(this, "offroad.cursor_radius_1km", 1000.0)));
        jViewMenu.add(new JMenuItem(new SetCursorRadiusAction(this, "offroad.cursor_radius_2km", 2000.0)));
        jViewMenu.add(new JMenuItem(new SetCursorRadiusAction(this, "offroad.cursor_radius_5km", 5000.0)));
        jViewMenu.add(new JMenuItem(new SetCursorRadiusAction(this, "offroad.remove_cursor_radius", 0.0)));
        jViewMenu.add(new JSeparator());
        JMenu jApplicationModeMenu = new JMenu(this.getString("app_modes_choose"));
        jApplicationModeMenu.add(new OffRoadAction.OffRoadMenuItem(new ChooseApplicationModeAction(this, ApplicationMode.DEFAULT), jApplicationModeMenu));
        jApplicationModeMenu.add(new OffRoadAction.OffRoadMenuItem(new ChooseApplicationModeAction(this, ApplicationMode.CAR), jApplicationModeMenu));
        jApplicationModeMenu.add(new OffRoadAction.OffRoadMenuItem(new ChooseApplicationModeAction(this, ApplicationMode.BICYCLE), jApplicationModeMenu));
        jApplicationModeMenu.add(new OffRoadAction.OffRoadMenuItem(new ChooseApplicationModeAction(this, ApplicationMode.PEDESTRIAN), jApplicationModeMenu));
        jViewMenu.add(jApplicationModeMenu);
        JMenu jRendererMenu = new JMenu(this.getOffRoadString("offroad.renderer"));
        for (String renderer : this.getRendererRegistry().getRendererNames()) {
            lViewItem = new OffRoadAction.OffRoadMenuItem(new ChooseRendererAction(this, this.getOffRoadString("offroad.renderer_" + renderer.replaceAll("[^a-zA-Z]", "_")), null, renderer), jRendererMenu);
            jRendererMenu.add(lViewItem);
        }
        jViewMenu.add(jRendererMenu);
        JMenu jRenderPropertiesMenu = new JMenu(this.getString("map_widget_renderer"));
        HashMap<String, JMenu> categoryMenus = new HashMap<String, JMenu>();
        for (RenderingRuleProperty customProp : this.getRenderingRulesStorage().PROPS.getCustomRules()) {
            if (!customProp.isBoolean() || customProp.getCategory() == null) continue;
            if (!categoryMenus.containsKey(customProp.getCategory())) {
                JMenu jMenu = new JMenu(this.getString("rendering_category_" + customProp.getCategory()));
                jRenderPropertiesMenu.add(jMenu);
                categoryMenus.put(customProp.getCategory(), jMenu);
            }
            OsmandSettings.CommonPreference<Boolean> pref = this.prefs.getCustomRenderBooleanProperty(customProp.getAttrName());
            log.debug((Object)("PROP: " + customProp.getAttrName() + ", " + customProp.getCategory() + "=" + pref.get()));
            JMenu jMenu = (JMenu)categoryMenus.get(customProp.getCategory());
            OffRoadAction.OffRoadMenuItem item2 = new OffRoadAction.OffRoadMenuItem(new SetRenderingRule(this, customProp), jMenu);
            jMenu.add(item2);
        }
        jViewMenu.add(jRenderPropertiesMenu);
        JMenu jIconSizePropertiesMenu = new JMenu(this.getOffRoadString("offroad.icons_size_menu"));
        for (int i = 0; i < sOsmandIconsPrefixes.length; ++i) {
            String prefix = sOsmandIconsPrefixes[i];
            OffRoadAction.OffRoadMenuItem item3 = new OffRoadAction.OffRoadMenuItem(new ChangeIconSizeAction(this, prefix), jIconSizePropertiesMenu);
            jIconSizePropertiesMenu.add(item3);
        }
        jViewMenu.add(jIconSizePropertiesMenu);
        menubar.add(jViewMenu);
        JMenu jNavigationMenu = new JMenu(this.getOffRoadString("offroad.navigation"));
        this.addToMenu(jNavigationMenu, null, new RouteAction(this, ApplicationMode.CAR), "F1");
        this.addToMenu(jNavigationMenu, null, new RouteAction(this, ApplicationMode.BICYCLE), "F2");
        this.addToMenu(jNavigationMenu, null, new RouteAction(this, ApplicationMode.PEDESTRIAN), "F3");
        jNavigationMenu.add(new JSeparator());
        this.addToMenu(jNavigationMenu, "offroad.go_source", new ShowTargetPointAction(this, t -> t.getPointToStart()), "control HOME");
        this.addToMenu(jNavigationMenu, "offroad.go_dest", new ShowTargetPointAction(this, t -> t.getPointToNavigate()), "control END");
        jNavigationMenu.add(new JSeparator());
        jNavigationMenu.add(new JMenuItem(new ClearRouteAction(this)));
        PointNavigationAction clearIntermediatePointsAction = new PointNavigationAction(this, "offroad.clear_intermediate_points", new PointNavigationAction.HelperAction(){

            @Override
            public void act(TargetPointsHelper pHelper, LatLon pPosition) {
                while (!pHelper.getIntermediatePoints().isEmpty()) {
                    pHelper.removeWayPoint(false, 0);
                }
            }
        });
        PointNavigationAction clearAllPointsAction = new PointNavigationAction(this, "offroad.clear_all_points", (helper, pos) -> helper.removeAllWayPoints(false, false));
        jNavigationMenu.add(clearIntermediatePointsAction);
        jNavigationMenu.add(clearAllPointsAction);
        jNavigationMenu.add(new JSeparator());
        JMenu lRoutingServiceMenu = new JMenu(this.getOffRoadString("offroad.routing_service"));
        for (int i = 0; i < RouteProvider.RouteService.values().length; ++i) {
            RouteProvider.RouteService service = RouteProvider.RouteService.values()[i];
            if (!service.isAvailable(this)) continue;
            OffRoadAction.OffRoadMenuItem lRoutingServiceItem = new OffRoadAction.OffRoadMenuItem(new ChooseRouteServiceAction(this, service), lRoutingServiceMenu);
            lRoutingServiceMenu.add(lRoutingServiceItem);
        }
        jNavigationMenu.add(lRoutingServiceMenu);
        jNavigationMenu.add(new JSeparator());
        this.addToMenu(jNavigationMenu, "offroad.up", item -> this.mDrawPanel.moveImageAnimatedInPercentage(0.0f, -0.33333334f), "control UP");
        this.addToMenu(jNavigationMenu, "offroad.down", item -> this.mDrawPanel.moveImageAnimatedInPercentage(0.0f, 0.33333334f), "control DOWN");
        this.addToMenu(jNavigationMenu, "offroad.left", item -> this.mDrawPanel.moveImageAnimatedInPercentage(-0.33333334f, 0.0f), "control LEFT");
        this.addToMenu(jNavigationMenu, "offroad.right", item -> this.mDrawPanel.moveImageAnimatedInPercentage(0.33333334f, 0.0f), "control RIGHT");
        jNavigationMenu.add(new JSeparator());
        this.addToMenu(jNavigationMenu, "offroad.zoomin", item -> this.mAdapter.addWheelEvent(-1, this.mDrawPanel.copyCurrentTileBox()), "control PLUS");
        this.addToMenu(jNavigationMenu, "offroad.zoomout", item -> this.mAdapter.addWheelEvent(1, this.mDrawPanel.copyCurrentTileBox()), "control MINUS");
        jNavigationMenu.add(new JSeparator());
        this.addToMenu(jNavigationMenu, "offroad.back", new NavigationBackAction(this), "alt LEFT");
        this.addToMenu(jNavigationMenu, "offroad.forward", new NavigationForwardAction(this), "alt RIGHT");
        jNavigationMenu.add(new JSeparator());
        this.addToMenu(jNavigationMenu, "offroad.reset_north", new NavigationRotationAction(this).setAbsolute(0.0), "alt HOME");
        this.addToMenu(jNavigationMenu, "offroad.increase_rotation", new NavigationRotationAction(this).setIncrement(30.0), "alt PAGE_UP");
        this.addToMenu(jNavigationMenu, "offroad.decrease_rotation", new NavigationRotationAction(this).setIncrement(-30.0), "alt PAGE_DOWN");
        menubar.add(jNavigationMenu);
        JMenu jPointOfInterestMenu = new JMenu(this.getOffRoadString("offroad.PointOfInterest"));
        OffRoadAction.OffRoadMenuItem lPointOfInterestOffItem = new OffRoadAction.OffRoadMenuItem(new PoiFilterAction(this, null, true), jPointOfInterestMenu);
        jPointOfInterestMenu.add(lPointOfInterestOffItem);
        for (PoiUIFilter filter : this.mPoiFilters.getTopDefinedPoiFilters()) {
            OffRoadAction.OffRoadMenuItem lPointOfInterestItem = new OffRoadAction.OffRoadMenuItem(new PoiFilterAction(this, filter, false), jPointOfInterestMenu);
            jPointOfInterestMenu.add(lPointOfInterestItem);
        }
        menubar.add(jPointOfInterestMenu);
        final JMenu jFavoritesMenu = new JMenu(this.getOffRoadString("offroad.Favorites"));
        this.mAddFavourite = new JMenuItem(new AddFavoriteAction(this, this.getOffRoadString("offroad.addFavorite"), null, null));
        this.mAddFavourite.setAccelerator(KeyStroke.getKeyStroke("control D"));
        this.mSelectTrack = new JMenuItem(new SelectTrackAction(this, this.getOffRoadString("offroad.selectTrack")));
        this.mSelectTrack.setAccelerator(KeyStroke.getKeyStroke("control T"));
        jFavoritesMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent pE) {
                jFavoritesMenu.removeAll();
                jFavoritesMenu.add(OsmWindow.this.mAddFavourite);
                for (FavouritesDbHelper.FavoriteGroup fg : OsmWindow.this.getFavorites().getFavoriteGroups()) {
                    JMenu groupMenu = new JMenu(fg.name);
                    for (FavouritePoint fp : fg.points) {
                        JMenuItem lFavoritesItem = new JMenuItem(new ShowFavoriteAction(OsmWindow.this, fp));
                        groupMenu.add(lFavoritesItem);
                    }
                    jFavoritesMenu.add(groupMenu);
                }
                jFavoritesMenu.add(OsmWindow.this.mSelectTrack);
            }

            @Override
            public void menuDeselected(MenuEvent pE) {
            }

            @Override
            public void menuCanceled(MenuEvent pE) {
            }
        });
        menubar.add(jFavoritesMenu);
        JMenu jHelpMenu = new JMenu(this.getOffRoadString("offroad.Help"));
        this.addToMenu(jHelpMenu, "offroad.about", new AboutDialogAction(this), null);
        menubar.add(jHelpMenu);
        this.adaptMenuMnemonics(menubar.getComponents());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new PointNavigationAction(this, "offroad.set_start_point", (helper, pos) -> helper.setStartPoint(pos, false, null))));
        popupMenu.add(new JMenuItem(new PointNavigationAction(this, "offroad.set_intermediate_point", (helper, pos) -> helper.navigateToPoint(pos, false, helper.getIntermediatePoints().size()))));
        popupMenu.add(new JMenuItem(new PointNavigationAction(this, "offroad.set_destination_point", (helper, pos) -> helper.navigateToPoint(pos, false, -1))));
        popupMenu.add(new JSeparator());
        popupMenu.add(new JMenuItem(clearIntermediatePointsAction));
        popupMenu.add(new JMenuItem(clearAllPointsAction));
        popupMenu.add(new JMenuItem(new SetCursorRadiusAction(this, "offroad.set_cursor_radius", -1.0)));
        popupMenu.add(new JMenuItem(new SetCursorRadiusAction(this, "offroad.remove_cursor_radius", 0.0)));
        this.mDrawPanel.setComponentPopupMenu(popupMenu);
        popupMenu.addPopupMenuListener(new OffRoadPopupMenuListener(this, popupMenu));
        this.mFrame.setJMenuBar(menubar);
        this.mDrawPanel.init();
        this.mFrame.pack();
        final OsmWindowLocationStorage storage = (OsmWindowLocationStorage)ComponentLocationStorage.decorateDialog(this, this.mFrame, this.getClass().getName());
        if (storage != null) {
            this.mFrame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent pE) {
                    int splitPanePosition = storage.getSplitLocation();
                    int lastSplitPanePosition = storage.getSplitLocation();
                    if (OsmWindow.this.mSplitPane != null && splitPanePosition != -1 && lastSplitPanePosition != -1) {
                        OsmWindow.this.mSplitPane.setDividerLocation(splitPanePosition);
                        OsmWindow.this.mSplitPane.setLastDividerLocation(lastSplitPanePosition);
                    }
                    OsmWindow.this.mFrame.removeComponentListener(this);
                }
            });
        }
        this.mFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                OsmWindow.this.mFrame.removeComponentListener(this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OsmWindow.this.checkMaps();
                    }
                });
            }
        });
        this.mFrame.setVisible(true);
    }

    public void showDirectSearch() {
        if (!this.mDirectSearchVisible) {
            this.mStatusBar.add((Component)this.mDirectSearchPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.mFrame.revalidate();
            this.mDirectSearchVisible = true;
            this.mDirectSearchTextField.selectAll();
        }
    }

    public void checkMaps() {
        MapRenderRepositories maps = this.getRenderer();
        boolean check = "true".equals(this.getOffroadProperties().getProperty(VECTOR_INDEXES_CHECK, "true"));
        if (check && !maps.basemapExists()) {
            int result = JOptionPane.showConfirmDialog(this.mFrame, this.getString(419), this.getString(123), 1, 3, null);
            if (result == 2) {
                return;
            }
            if (result == 1) {
                this.getOffroadProperties().setProperty(VECTOR_INDEXES_CHECK, "false");
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadAction downloadAction = new DownloadAction(OsmWindow.getInstance(), "world_basemap");
                    downloadAction.actionPerformed(null);
                }
            });
        }
    }

    private void adaptMenuMnemonics(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (comp instanceof AbstractButton) {
                AbstractButton but = (AbstractButton)comp;
                this.setMnemonic(but);
            }
            if (!(comp instanceof JMenu)) continue;
            JMenu cont = (JMenu)comp;
            this.adaptMenuMnemonics(cont.getPopupMenu().getComponents());
        }
    }

    public static boolean isMacOsX() {
        boolean underMac = false;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            underMac = true;
        }
        return underMac;
    }

    private void setMnemonic(AbstractButton item) {
        char charAfterMnemoSign;
        String rawLabel = item.getText();
        item.setText(rawLabel.replaceFirst("&([^ ])", "$1"));
        int mnemoSignIndex = rawLabel.indexOf("&");
        if (mnemoSignIndex >= 0 && mnemoSignIndex + 1 < rawLabel.length() && (charAfterMnemoSign = rawLabel.charAt(mnemoSignIndex + 1)) != ' ' && !OsmWindow.isMacOsX()) {
            item.setMnemonic(charAfterMnemoSign);
            item.setDisplayedMnemonicIndex(mnemoSignIndex);
        }
    }

    void addToMenu(JMenu jNavigationMenu, String name, ActionListener action, String keyStroke) {
        String actionName;
        String string2 = actionName = name != null ? this.getOffRoadString(name) : "UNKNOWN";
        if (name == null && action instanceof AbstractAction) {
            AbstractAction abstractAction = (AbstractAction)action;
            actionName = (String)abstractAction.getValue("Name");
        }
        JMenuItem navigationBackItem = new JMenuItem(actionName);
        navigationBackItem.addActionListener(action);
        if (keyStroke != null) {
            navigationBackItem.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
        }
        jNavigationMenu.add(navigationBackItem);
    }

    public void startServer() {
        String portFile = this.getAppPath("port.txt").getAbsolutePath();
        if (portFile == null) {
            return;
        }
        this.mGeoServer = new GeoServer(portFile, this);
        this.mGeoServer.start();
    }

    public String getOffRoadString(String pString) {
        if (this.mOffroadResources.containsKey(pString)) {
            return this.mOffroadResources.getString(pString);
        }
        log.error((Object)("TRANSLATE ME: " + pString));
        return "TRANSLATE_ME:" + pString;
    }

    public OsmBitmapPanel getDrawPanel() {
        return this.mDrawPanel;
    }

    public static void main(String[] args) throws XmlPullParserException, IOException {
        final OsmWindow win = OsmWindow.getInstance();
        VersionInfo version = win.getVersion();
        log.info((Object)("Version: " + version.version + ", hash=" + version.hash));
        win.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                win.createAndShowUI();
            }
        });
    }

    protected void saveSettings() {
        RotatedTileBox tileBox = this.mDrawPanel.copyCurrentTileBox();
        this.prefs.setLastKnownMapLocation(tileBox.getLatitude(), tileBox.getLongitude());
        this.prefs.setLastKnownMapZoom(tileBox.getZoom());
        this.getSettings().SELECTED_POI_FILTER_STRING_FOR_MAP.set(this.mSearchTextField.getText());
        OsmWindowLocationStorage storage = new OsmWindowLocationStorage();
        storage.setSplitLocation(this.mSplitPane.getDividerLocation());
        ComponentLocationStorage.storeDialogPositions(this, this.mFrame, storage, this.getClass().getName());
        this.settings.save();
    }

    public OsmWindow() {
        this.initStrings();
        this.setupProxy();
        this.prefs.APPLICATION_MODE.set(ApplicationMode.DEFAULT);
        this.prefs.MAP_PREFERRED_LOCALE.set(this.getLanguage());
        this.prefs.PREFERRED_LOCALE.set(this.getLanguage());
        this.mStrings = new R.string();
    }

    private void init() throws XmlPullParserException, IOException {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.widthPixels = size.width;
        this.heightPixels = size.height;
        this.density = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0f;
        this.mOsmAndLocationProvider = new OsmAndLocationProvider(this);
        this.mRegions = new OsmandRegions();
        this.mResourceManager = new ResourceManager(this);
        this.mResourceManager.indexingMaps(IProgress.EMPTY_PROGRESS);
        if (System.getProperty("HIDPI") != null) {
            log.info((Object)"Option HIDPI found");
            OsmWindow.scaleAllFonts(1.3f * this.density);
        } else {
            OsmWindow.scaleAllFonts(this.density);
        }
        this.startServer();
        this.mRendererRegistry = new RendererRegistry(this);
        this.mRendererRegistry.initRenderers(IProgress.EMPTY_PROGRESS);
        this.mRoutingHelper = new RoutingHelper(this);
        this.getRoutingHelper().addListener(this);
        this.mGeocodingLookupService = new GeocodingLookupService(this);
        this.mTargetPointsHelper = new TargetPointsHelper(this);
        this.mPoiFilters = new PoiFiltersHelper(this);
        this.mMapPoiTypes = MapPoiTypes.getDefault();
        this.mMapPoiTypes.setPoiTranslator(new MapPoiTypes.PoiTranslator(){

            @Override
            public String getTranslation(AbstractPoiType type) {
                if (type.getBaseLangType() != null) {
                    return this.getTranslation(type.getBaseLangType()) + " (" + OsmWindow.this.getLangTranslation(type.getLang()).toLowerCase() + ")";
                }
                return OsmWindow.this.getString("poi_" + type.getIconKeyName());
            }
        });
        this.mMapMarkersHelper = new MapMarkersHelper(this);
    }

    private void initStrings() {
        String ct = this.getCountry();
        this.loadStrings(ct, "strings.xml");
        this.loadStrings(ct, "phrases.xml");
        try {
            this.mOffroadResources = this.getLanguageResources(ct);
            if (this.mOffroadResources == null) {
                this.mOffroadResources = this.getLanguageResources("en");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupProxy() {
        Properties props = (Properties)this.settings.getPreferenceObject(OFFROAD_PROPERTIES);
        if ("true".equals(this.settings.getString(props, PROXY_USE_SETTINGS, ""))) {
            if ("true".equals(this.settings.getString(props, PROXY_IS_AUTHENTICATED, ""))) {
                try {
                    Authenticator.setDefault(new ProxyAuthenticator(this.settings.getString(props, PROXY_USER, ""), new String(Base64.decode(this.settings.getString(props, PROXY_PASSWORD, "")))));
                }
                catch (Base64DecoderException e) {
                    e.printStackTrace();
                }
            }
            System.setProperty("http.proxyHost", this.settings.getString(props, PROXY_HOST, ""));
            System.setProperty("http.proxyPort", this.settings.getString(props, PROXY_PORT, ""));
            System.setProperty("https.proxyHost", this.settings.getString(props, PROXY_HOST, ""));
            System.setProperty("https.proxyPort", this.settings.getString(props, PROXY_PORT, ""));
            System.setProperty("http.nonProxyHosts", this.settings.getString(props, PROXY_EXCEPTION, ""));
        }
    }

    private void loadStrings(String ct, String fileName) {
        Resources resourceStrings;
        InputStream is = this.getResource("res/values-" + ct + "/" + fileName);
        if (is == null) {
            is = this.getResource("res/values/" + fileName);
        }
        log.info((Object)("Trying to load resources " + is));
        try {
            JAXBContext jc = JAXBContext.newInstance((String)ResourceTest.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            resourceStrings = (Resources)u.unmarshal(is);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            resourceStrings = new Resources();
        }
        if (this.mResourceStrings == null) {
            this.mResourceStrings = new Resources();
        }
        this.mResourceStrings.getString().addAll(resourceStrings.getString());
    }

    private PropertyResourceBundle getLanguageResources(String lang) throws IOException {
        InputStream is = this.getResource("res/OffRoad_Resources_" + lang + ".properties");
        if (is == null) {
            return null;
        }
        PropertyResourceBundle bundle = new PropertyResourceBundle(is);
        is.close();
        return bundle;
    }

    public VersionInfo getVersion() {
        if (this.mVersionInfo == null) {
            try {
                this.mVersionInfo = new VersionInfo("x.x.x", "0815");
                InputStream is = this.getResource("version.properties");
                if (is == null) {
                    return this.mVersionInfo;
                }
                PropertyResourceBundle bundle = new PropertyResourceBundle(is);
                is.close();
                this.mVersionInfo = new VersionInfo(bundle.getString("version"), bundle.getString("hash"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.mVersionInfo;
    }

    public String getLangTranslation(String l) {
        return this.getString("lang_" + l);
    }

    public static void scaleAllFonts(float pScale) {
        log.info((Object)("Scaling fonts with scale " + pScale));
        for (Object next : UIManager.getLookAndFeelDefaults().keySet()) {
            String key;
            if (!(next instanceof String) || !(key = (String)next).endsWith(".font")) continue;
            Font font = UIManager.getFont(key);
            Font biggerFont = font.deriveFont(pScale * font.getSize2D());
            UIManager.put(key, biggerFont);
        }
    }

    public OsmandRenderer.RenderingResult loadMGap(Graphics2D pG2, RotatedTileBox pTileRect, OsmBitmapPanel.IntermediateImageListener pListener) {
        return this.getRenderer().loadMGap(pG2, pTileRect, this.getRenderingRulesStorage(), pListener);
    }

    public MapRenderRepositories getRenderer() {
        return this.mResourceManager.getRenderer();
    }

    public static void printClassPath() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)cl).getURLs();
            System.out.println("Classpath:");
            for (URL url : urls) {
                System.out.println(url.getFile());
            }
        } else {
            System.out.println("Can' determine classpath for classloader " + cl);
        }
    }

    public InputStream getResource(String pIndex) {
        if (pIndex != null) {
            String name = pIndex;
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is == null) {
                name = "/" + pIndex;
                is = this.getClass().getResourceAsStream(name);
                if (is == null) {
                    System.err.println("ERROR: Resource not found: " + pIndex);
                    OsmWindow.printClassPath();
                } else {
                    System.err.println("WARNING: Found path as " + name + " instead of " + pIndex);
                }
            }
            return is;
        }
        return null;
    }

    public BufferedImage getBitmap(MapObject obj) {
        BufferedImage bmp = null;
        if (obj instanceof Amenity) {
            Amenity o = (Amenity)obj;
            String id2 = null;
            PoiType st = o.getType().getPoiTypeByKeyName(o.getSubType());
            if (st != null) {
                if (RenderingIcons.containsSmallIcon(st.getIconKeyName())) {
                    id2 = st.getIconKeyName();
                } else if (RenderingIcons.containsSmallIcon(st.getOsmTag() + "_" + st.getOsmValue())) {
                    id2 = st.getOsmTag() + "_" + st.getOsmValue();
                }
            }
            if (id2 != null) {
                bmp = RenderingIcons.getIcon(id2, false);
            }
        }
        return bmp;
    }

    public File getAppPath(String pIndex) {
        if (pIndex == null) {
            pIndex = "";
        }
        String pathname = OsmWindow.getAppPathName(pIndex);
        log.info((Object)("Searching for " + pathname));
        return new File(pathname);
    }

    public static String getAppPathName(String pIndex) {
        String pathname = System.getProperty("user.home") + File.separator + ".OffRoad" + File.separator + pIndex;
        return pathname;
    }

    public OsmandSettings getSettings() {
        return this.prefs;
    }

    public String getString(int pKey) {
        String stringKey = this.mStrings.hash.get(pKey);
        return this.getString(stringKey);
    }

    public String getString(String stringKey) {
        for (Resources.String str : this.mResourceStrings.getString()) {
            if (str.getName() == null || !str.getName().equals(stringKey)) continue;
            log.debug((Object)("String " + stringKey + "=" + str.getValue()));
            return str.getValue();
        }
        log.error((Object)("String key " + stringKey + " not found!"));
        return stringKey;
    }

    public static OsmWindow getInstance() {
        if (sInstance == null) {
            sInstance = new OsmWindow();
        }
        return sInstance;
    }

    public OsmandRegions getRegions() {
        return this.mRegions;
    }

    public ResourceManager getResourceManager() {
        return this.mResourceManager;
    }

    public Frame getWindow() {
        return this.mFrame;
    }

    public void move(LatLon pLocation, QuadRectExtendable pQuadRectExtendable) {
        RotatedTileBox ctb = this.mDrawPanel.copyCurrentTileBox();
        QuadRectExtendable joint = new QuadRectExtendable(ctb.getCenterLatLon());
        if (pQuadRectExtendable != null) {
            joint.insert(pQuadRectExtendable.getTopLeft());
            joint.insert(pQuadRectExtendable.getBottomRight());
        }
        RotatedTileBox cameraTileBox = this.getCommonTileBox(pLocation, joint);
        RotatedTileBox tileBox = this.mDrawPanel.copyCurrentTileBox();
        tileBox.setLatLonCenter(pLocation.getLatitude(), pLocation.getLongitude());
        tileBox = this.getCommonTileBox(tileBox, pLocation, pQuadRectExtendable);
        this.moveAnimated(cameraTileBox, ctb, ctb.getCenterLatLon());
        this.moveAnimated(tileBox, cameraTileBox, pLocation);
        this.setCursorPosition(pLocation);
    }

    public void moveAnimated(RotatedTileBox pNextTileBox, RotatedTileBox pCurrentTileBox, LatLon pLocation) {
        if (pNextTileBox.getZoom() == pCurrentTileBox.getZoom()) {
            Point delta = pCurrentTileBox.getPoint(pNextTileBox.getLeftTopLatLon());
            this.mDrawPanel.moveAnimated(delta.x, delta.y, pNextTileBox);
        } else {
            this.mDrawPanel.zoomChange(pNextTileBox.getZoom() - pCurrentTileBox.getZoom(), pCurrentTileBox.getPoint(pLocation));
        }
    }

    protected RotatedTileBox getCommonTileBox(LatLon pLocation, QuadRectExtendable pQuadRectExtendable) {
        RotatedTileBox tileBox = this.mDrawPanel.copyCurrentTileBox();
        tileBox.setZoom(22);
        return this.getCommonTileBox(tileBox, pLocation, pQuadRectExtendable);
    }

    protected RotatedTileBox getCommonTileBox(RotatedTileBox pTileBox, LatLon pLocation, QuadRectExtendable pQuadRectExtendable) {
        if (pQuadRectExtendable != null) {
            this.zoomOutUntilFits(pTileBox, pQuadRectExtendable.getTopLeft());
            this.zoomOutUntilFits(pTileBox, pQuadRectExtendable.getBottomRight());
        }
        this.zoomOutUntilFits(pTileBox, pLocation);
        return pTileBox;
    }

    public void zoomOutUntilFits(RotatedTileBox tileBox, LatLon latlon) {
        while (!tileBox.containsLatLon(latlon)) {
            tileBox.setZoom(tileBox.getZoom() - 1);
        }
    }

    public void setWaitingCursor(boolean waiting) {
        Component glassPane = this.mFrame.getRootPane().getGlassPane();
        if (waiting) {
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        } else {
            glassPane.setCursor(Cursor.getPredefinedCursor(0));
            glassPane.setVisible(false);
        }
    }

    public RendererRegistry getRendererRegistry() {
        return this.mRendererRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingConfiguration.Builder getDefaultRoutingConfig() {
        long tm = System.currentTimeMillis();
        InputStream routingXml = this.getResource("routing.xml");
        if (routingXml != null) {
            try {
                RoutingConfiguration.Builder builder = RoutingConfiguration.parseFromInputStream(routingXml);
                return builder;
            }
            catch (IOException | XmlPullParserException e) {
                throw new IllegalStateException(e);
            }
        }
        System.err.println("Routing configuration not found!");
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        return builder;
        finally {
            long te = System.currentTimeMillis();
            if (te - tm > 30L) {
                System.err.println("Defalt routing config init took " + (te - tm) + " ms");
            }
        }
    }

    public static GeneralRouter getRouter(RoutingConfiguration.Builder builder, ApplicationMode am) {
        GeneralRouter router = builder.getRouter(am.getStringKey());
        if (router == null && am.getParent() != null) {
            router = builder.getRouter(am.getParent().getStringKey());
        }
        return router;
    }

    public String getString(int pKey, Object ... pObj) {
        return MessageFormat.format(this.getString(pKey), pObj);
    }

    public String getOffRoadString(String pKey, Object ... pObj) {
        return MessageFormat.format(this.getOffRoadString(pKey), pObj);
    }

    public TargetPointsHelper getTargetPointsHelper() {
        return this.mTargetPointsHelper;
    }

    public MapMarkersHelper getMapMarkersHelper() {
        return this.mMapMarkersHelper;
    }

    public RoutingHelper getRoutingHelper() {
        return this.mRoutingHelper;
    }

    public GeocodingLookupService getGeocodingLookupService() {
        return this.mGeocodingLookupService;
    }

    public OsmAndLocationProvider getLocationProvider() {
        return this.mOsmAndLocationProvider;
    }

    public MapPoiTypes getPoiTypes() {
        return this.mMapPoiTypes;
    }

    public MouseEvent getLastMouseEvent() {
        return this.mAdapter.getMouseEvent();
    }

    public RenderingRulesStorage getRenderingRulesStorage() {
        RenderingRulesStorage storage = this.mRendererRegistry.getCurrentSelectedRenderer();
        return storage;
    }

    public void showToastMessage(String pMsg) {
        this.mStatusLabel.setText(pMsg);
        this.mDontUpdateStatusLabelCounter = 4;
    }

    public void runInUIThread(Runnable pRunnable) {
        SwingUtilities.invokeLater(pRunnable);
    }

    public void addPoint(LatLon pPoint) {
        MapPointStorage storage = new MapPointStorage(pPoint, this.getZoom());
        if (this.mPointStorageIndex != this.mPointStorage.size() - 1) {
            for (int i = this.mPointStorageIndex + 1; i < this.mPointStorage.size(); ++i) {
                this.mPointStorage.remove(i);
            }
        }
        this.mPointStorage.add(storage);
        this.mPointStorageIndex = this.mPointStorage.size() - 1;
    }

    public int getZoom() {
        return this.getDrawPanel().copyCurrentTileBox().getZoom();
    }

    public void back() {
        if (this.mPointStorage.isEmpty()) {
            return;
        }
        if (this.mPointStorageIndex <= 0 || this.mPointStorageIndex >= this.mPointStorage.size()) {
            return;
        }
        --this.mPointStorageIndex;
        MapPointStorage pointStorage = this.mPointStorage.get(this.mPointStorageIndex);
        this.mDrawPanel.move(pointStorage.mPoint, pointStorage.mZoom);
        this.mDrawPanel.setCursor(pointStorage.mPoint);
    }

    public void forward() {
        if (this.mPointStorage.isEmpty()) {
            return;
        }
        if (this.mPointStorageIndex < 0 || this.mPointStorageIndex >= this.mPointStorage.size() - 1) {
            return;
        }
        ++this.mPointStorageIndex;
        MapPointStorage pointStorage = this.mPointStorage.get(this.mPointStorageIndex);
        this.mDrawPanel.move(pointStorage.mPoint, pointStorage.mZoom);
        this.mDrawPanel.setCursor(pointStorage.mPoint);
    }

    public void addCursorPositionListener(CursorPositionListener pListener) {
        this.mCursorPositionListeners.add(pListener);
    }

    public void removeCursorPositionListener(CursorPositionListener pListener) {
        this.mCursorPositionListeners.remove(pListener);
    }

    public void setCursorPosition(Point pPoint) {
        this.mDrawPanel.setCursor(pPoint);
        this.setCursorPosition(this.mDrawPanel.getCursorPosition());
    }

    public void setCursorPosition(LatLon pLoc) {
        this.mDrawPanel.setCursor(pLoc);
        this.addPoint(pLoc);
        this.queueAmenityTableUpdate(pLoc);
        for (CursorPositionListener listener : this.mCursorPositionListeners) {
            listener.cursorPositionChanged(pLoc);
        }
    }

    private void queueAmenityTableUpdate(LatLon pLoc) {
        this.getDrawPanel().queue(new AmenityTableUpdateThread(this.getDrawPanel(), pLoc, this.mAmenityTable));
    }

    public void runInUIThread(final Runnable pRunnable, int pDelay) {
        Timer timer = new Timer(pDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                pRunnable.run();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void setProgress(int pPercent) {
        if (pPercent < 100) {
            this.mRouteProgressBar.setVisible(true);
            this.mRouteProgressBar.setValue(pPercent);
        } else {
            this.mRouteProgressBar.setVisible(false);
        }
    }

    public void setStatus(String pStatus) {
        this.mRouteProgressStatus.setText(pStatus);
    }

    public String getLanguage() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage().toLowerCase();
    }

    public String getCountry() {
        Locale locale = Locale.getDefault();
        String ct = locale.getCountry().toLowerCase();
        return ct;
    }

    public PoiFiltersHelper getPoiFilters() {
        return this.mPoiFilters;
    }

    public void showWikipedia(String pContent, String pTitle, String pArticle) {
        ShowWikipediaAction action = new ShowWikipediaAction(this, pContent, pTitle, pArticle);
        action.actionPerformed(null);
    }

    public LatLon getCursorPosition() {
        LatLon cursorPosition = this.mDrawPanel.getCursorPosition();
        if (cursorPosition == null) {
            cursorPosition = this.getCenterPosition();
            this.setCursorPosition(cursorPosition);
        }
        return cursorPosition;
    }

    public LatLon getMouseLocation() {
        MouseEvent lastMouseEvent = this.getLastMouseEvent();
        Point destination = lastMouseEvent == null ? new Point(0, 0) : lastMouseEvent.getPoint();
        LatLon destLatLon = this.mDrawPanel.copyCurrentTileBox().getLatLonFromPixel(destination.x, destination.y);
        return destLatLon;
    }

    public PoiUIFilter getCurrentPoiUIFilter() {
        return this.mCurrentPoiFilter;
    }

    public LatLon getCenterPosition() {
        return this.mDrawPanel.copyCurrentTileBox().getCenterLatLon();
    }

    public void setPoiFilter(PoiUIFilter filter, String pFilterText) {
        String filterId = null;
        if (filter != null) {
            filterId = filter.getFilterId();
        }
        this.getSettings().SELECTED_POI_FILTER_FOR_MAP.set(filterId);
        this.getSettings().SELECTED_POI_FILTER_STRING_FOR_MAP.set(pFilterText);
        this.setWaitingCursor(true);
        this.mAmenityTable.setSearchResult(this.getSearchResult());
        this.setSearchType(SearchType.AMENITY);
        this.setWaitingCursor(false);
        this.getDrawPanel().refreshMap();
    }

    public List<MapObject> getSearchResult() {
        Vector<MapObject> result = new Vector<MapObject>();
        String filterId = this.getSettings().SELECTED_POI_FILTER_FOR_MAP.get();
        switch (this.mSearchType) {
            case AMENITY: {
                if (filterId == null) break;
                PoiUIFilter filter = this.getPoiFilters().getFilterById(filterId);
                String filterString = this.getSettings().SELECTED_POI_FILTER_STRING_FOR_MAP.get();
                if (filterString != null && !filterString.isEmpty()) {
                    filter.setFilterByName(filterString);
                }
                LatLon latLon = this.getCursorPosition();
                result.addAll(filter.initializeNewSearch(latLon.getLatitude(), latLon.getLongitude(), -1, new ResultMatcher<Amenity>(){

                    @Override
                    public boolean publish(Amenity pObject) {
                        log.debug((Object)("Adding " + pObject.getName(OsmWindow.this.getLanguage())));
                        return true;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                }));
                break;
            }
            case ROUTE: {
                result.addAll(this.mRouteResult);
            }
        }
        return result;
    }

    public JTextField getSearchTextField() {
        return this.mSearchTextField;
    }

    void toggleSearchBar() {
        if (this.mSearchBarVisible) {
            this.mFrame.getContentPane().remove(this.mToolBar);
            this.mSplitPane.setDividerLocation(0);
        } else {
            this.mFrame.getContentPane().add((Component)this.mToolBar, "North");
        }
        this.mSearchBarVisible = !this.mSearchBarVisible;
        this.mFrame.revalidate();
        this.mDrawPanel.requestFocus();
    }

    public SQLiteAPI getSQLiteAPI() {
        if (this.mSqLiteImpl == null) {
            this.mSqLiteImpl = new SQLiteImpl(this);
        }
        return this.mSqLiteImpl;
    }

    public File getDatabasePath(String pFavouriteDbName) {
        return this.getAppPath(pFavouriteDbName);
    }

    public File getFileStreamPath(String pFileToBackup) {
        return this.getAppPath(pFileToBackup);
    }

    public FavouritesDbHelper getFavorites() {
        if (this.mFavorites == null) {
            this.mFavorites = new FavouritesDbHelper(this);
            this.mFavorites.loadFavorites();
        }
        return this.mFavorites;
    }

    public Properties getOffroadProperties() {
        return this.mOffroadProperties;
    }

    public OffRoadResources getResources() {
        if (this.mOffRoadResources == null) {
            this.mOffRoadResources = new OffRoadResources(this);
        }
        return this.mOffRoadResources;
    }

    public GpxSelectionHelper getSelectedGpxHelper() {
        if (this.mGpxSelectionHelper == null) {
            this.mGpxSelectionHelper = new GpxSelectionHelper(this, this.getSavingTrackHelper());
            this.mGpxSelectionHelper.loadGPXTracks(IProgress.EMPTY_PROGRESS);
        }
        return this.mGpxSelectionHelper;
    }

    protected SavingTrackHelper getSavingTrackHelper() {
        if (this.mSavingTrackHelper == null) {
            this.mSavingTrackHelper = new SavingTrackHelper(this);
        }
        return this.mSavingTrackHelper;
    }

    private void closeWindow() {
        this.mDrawPanel.removeAllLayers();
        this.saveSettings();
        this.mFrame.dispose();
        System.exit(0);
    }

    public BufferedImage readImage(String image) {
        if (this.mBufferedImageCache.containsKey(image)) {
            return this.mBufferedImageCache.get(image);
        }
        String path = IMAGE_PATH + this.getIconSize() + "/" + image + ".png";
        BufferedImage res = this.readImageInternally(path);
        this.mBufferedImageCache.put(image, res);
        return res;
    }

    protected BufferedImage readImageInternally(String path) {
        BufferedImage res = null;
        try {
            InputStream resource = this.getResource(path);
            if (resource == null) {
                log.error((Object)("Resource " + path + " not found!"));
                return null;
            }
            res = ImageIO.read(resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public void setRouteCalculated() {
        RouteCalculationResult route = this.getRoutingHelper().getRoute();
        List<RouteDirectionInfo> currentRoute = route.getRouteDirections();
        List<Location> locations = route.getImmutableAllLocations();
        Vector<MapObject> routeResult = new Vector<MapObject>();
        for (RouteDirectionInfo directionInfo : currentRoute) {
            routeResult.add(new LocationAsMapObject(locations.get(directionInfo.routePointOffset), directionInfo.getDescriptionRoutePart(), route.getDistanceToPoint(directionInfo.routePointOffset)));
        }
        this.mRouteResult = routeResult;
        this.setSearchType(SearchType.ROUTE);
    }

    private void setSearchType(SearchType pSearchType) {
        this.mSearchType = pSearchType;
        this.queueAmenityTableUpdate(null);
    }

    @Override
    public void newRouteIsCalculated(boolean pNewRoute, ValueHolder<Boolean> pShowToast) {
        float dist = (float)this.getRoutingHelper().getRoute().getWholeDistance() / 1000.0f;
        this.setStatus(this.getOffRoadString("offroad.routing_finished", Float.valueOf(dist)));
        this.setRouteCalculated();
        this.getDrawPanel().drawLater();
    }

    @Override
    public void routeWasCancelled() {
        this.getDrawPanel().drawLater();
    }

    @Override
    public void routeWasFinished() {
    }

    public JMenuItem createJMenuItemForObject(IContextMenuProvider provider, Object am) {
        PointDescription pointDescription = provider.getObjectName(am);
        String name = "UNKNOWN";
        if (pointDescription != null) {
            name = pointDescription.getName();
        }
        String description = provider.getObjectDescription(am);
        Icon icon = null;
        if (am instanceof MapObject) {
            MapObject mapObject = (MapObject)am;
            icon = this.getImageIcon(mapObject);
        }
        JMenuItem item = new JMenuItem(name, icon);
        item.setToolTipText(description);
        return item;
    }

    public Icon getImageIcon(MapObject am) {
        BufferedImage bitmap = this.getBitmap(am);
        if (bitmap != null) {
            return new ImageIcon(bitmap);
        }
        return new BlindIcon(20);
    }

    public List<JMenuItem> getContextActionsForObject(IContextMenuProvider pProvider, Object pAm) {
        LocationPoint targetPoint;
        JMenuItem item;
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        if (pAm instanceof Amenity) {
            final Amenity am = (Amenity)pAm;
            JMenuItem item2 = this.createJMenuItemForObject(pProvider, pAm);
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent pE) {
                    if (am.getType().isWiki()) {
                        POIMapLayer.showWikipediaDialog(OsmWindow.this, OsmWindow.this, am);
                    } else {
                        String locationName = PointDescription.getLocationName(OsmWindow.this, am.getLocation().getLatitude(), am.getLocation().getLongitude(), true);
                        POIMapLayer.showDescriptionDialog(OsmWindow.this, OsmWindow.getInstance(), am.getAdditionalInfo().toString(), am.getName(OsmWindow.this.getLanguage()));
                    }
                }
            });
            result.add(item2);
        }
        if (pAm instanceof FavouritePoint) {
            FavouritePoint point = (FavouritePoint)pAm;
            final String editString = this.getOffRoadString("offroad.editFavourite", point.getName(), point.getCategory());
            item = new JMenuItem(new AddFavoriteAction(this, editString, null, point){

                @Override
                protected String getWindowTitle() {
                    return editString;
                }
            });
            result.add(item);
            item = new JMenuItem(new DeleteFavoriteAction(this, this.getOffRoadString("offroad.deleteFavourite", point.getName(), point.getCategory()), null, point));
            result.add(item);
        }
        if (pAm instanceof TargetPointsHelper.TargetPoint) {
            targetPoint = (TargetPointsHelper.TargetPoint)pAm;
            PointNavigationAction removePointAction = new PointNavigationAction(this, "offroad.remove_navigation_point", new PointNavigationAction.HelperAction((TargetPointsHelper.TargetPoint)targetPoint){
                final /* synthetic */ TargetPointsHelper.TargetPoint val$targetPoint;
                {
                    this.val$targetPoint = targetPoint;
                }

                @Override
                public void act(TargetPointsHelper pHelper, LatLon pPosition) {
                    int index;
                    if (this.val$targetPoint == pHelper.getPointToStart()) {
                        pHelper.clearStartPoint(false);
                    }
                    if (this.val$targetPoint == pHelper.getPointToNavigate()) {
                        pHelper.clearPointToNavigate(false);
                    }
                    if ((index = pHelper.getIntermediatePoints().indexOf(this.val$targetPoint)) >= 0) {
                        pHelper.removeWayPoint(false, index);
                    }
                }
            });
            item = new JMenuItem(removePointAction);
            result.add(item);
        }
        if (pAm instanceof GPXUtilities.WptPt) {
            targetPoint = (GPXUtilities.WptPt)pAm;
        }
        if (pAm instanceof GpxSelectionHelper.SelectedGpxFile) {
            GpxSelectionHelper.SelectedGpxFile sgf = (GpxSelectionHelper.SelectedGpxFile)pAm;
            JMenuItem trackInfoItem = new JMenuItem(new ShowTrackDetailsAction(this, sgf.getGpxFile()));
            result.add(trackInfoItem);
        }
        if (pAm instanceof RouteCalculationResult) {
            RouteCalculationResult rcr = (RouteCalculationResult)pAm;
            JMenuItem routeInfoItem = new JMenuItem(new ShowRouteDetailsAction(this, rcr));
            result.add(routeInfoItem);
        }
        if (pAm instanceof DrawPolylineLayer.Polyline) {
            DrawPolylineLayer.Polyline polyline = (DrawPolylineLayer.Polyline)pAm;
            JMenuItem remPolyAction = new JMenuItem(new RemovePolylineAction(this, polyline));
            result.add(remPolyAction);
        }
        return result;
    }

    public String getOsmandIconsDir() {
        return OSMAND_ICONS_DIR + this.getIconSize() + "/";
    }

    public String getIconSize() {
        return this.getOffroadProperties().getProperty(OSMAND_ICONS_DIR_PREFIX, OSMAND_ICONS_DIR_DEFAULT_PREFIX);
    }

    public void openDocument(URL url) throws Exception {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = new URI(url.toString().replaceAll("^file:////", "file://"));
                desktop.browse(uri);
            }
            catch (Exception e) {
                log.fatal((Object)("Caught: " + e), (Throwable)e);
            }
        }
    }

    public DrawPolylineLayer getPolylineLayer() {
        return this.mDrawPanel.getPolylineLayer();
    }

    public static String marshall(Object pStorage, Class[] pClasses) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])pClasses, null);
            Marshaller m = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            m.marshal(pStorage, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object unmarshall(String pInput, Class[] pClasses) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])pClasses, null);
            Unmarshaller m = jaxbContext.createUnmarshaller();
            return m.unmarshal((Reader)new StringReader(pInput));
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static interface CursorPositionListener {
        public void cursorPositionChanged(LatLon var1);
    }

    public class StatusLabelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent pE) {
            if (OsmWindow.this.mDontUpdateStatusLabelCounter > 0) {
                OsmWindow.this.mDontUpdateStatusLabelCounter--;
                return;
            }
            MouseEvent e = OsmWindow.this.getLastMouseEvent();
            LatLon cursorPosition = OsmWindow.this.mDrawPanel.getCursorPosition();
            if (e == null || cursorPosition == null) {
                OsmWindow.this.mStatusLabel.setText("");
                return;
            }
            LatLon mousePosition = OsmWindow.this.mDrawPanel.copyCurrentTileBox().getLatLonFromPixel(e.getX(), e.getY());
            double distance = MapUtils.getDistance(mousePosition, cursorPosition) / 1000.0;
            DrawPolylineLayer.Polyline selectedPolyline = OsmWindow.this.mDrawPanel.getPolylineLayer().getSelectedPolyline();
            double polyDist = 0.0;
            double polyArea = 0.0;
            if (selectedPolyline != null) {
                polyDist = selectedPolyline.calculateLength();
                polyArea = selectedPolyline.calculateArea();
            }
            Object[] messageArguments = new Object[]{new Double(distance), new Double(cursorPosition.getLatitude()), new Double(cursorPosition.getLongitude())};
            Object[] polyArguments = new Object[]{polyDist, polyArea};
            MessageFormat formatter = new MessageFormat(OsmWindow.this.getOffRoadString("offroad.string47"));
            String message = formatter.format(messageArguments);
            if (polyDist != 0.0 || polyArea != 0.0) {
                formatter = new MessageFormat(OsmWindow.this.getOffRoadString("offroad.string47.poly"));
                message = message + " " + formatter.format(polyArguments);
            }
            OsmWindow.this.mStatusLabel.setText(message);
        }
    }

    public static class VersionInfo {
        public String version;
        public String hash;

        public VersionInfo(String pVersion, String pHash) {
            this.version = pVersion;
            this.hash = pHash;
        }
    }

    private static enum SearchType {
        AMENITY,
        ROUTE;

    }

    public class MapPointStorage {
        private LatLon mPoint;
        private int mZoom;

        public MapPointStorage(LatLon pPoint, int pZoom) {
            this.mPoint = pPoint;
            this.mZoom = pZoom;
        }
    }
}

