/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.protege.editor.core.log.LogLevel;
import org.protege.editor.core.log.LogRecord;
import org.protege.editor.core.log.LogRecordElement;

public class LogRecordRenderer
implements ListCellRenderer<LogRecordElement> {
    private static final Color ERROR_COLOR = new Color(220, 0, 0);
    private static final Color WARNING_COLOR = new Color(255, 135, 0);
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private static final Border border = BorderFactory.createEmptyBorder(2, 0, 2, 0);

    @Override
    public Component getListCellRendererComponent(JList<? extends LogRecordElement> list, LogRecordElement element, int index, boolean isSelected, boolean cellHasFocus) {
        LogRecord record = element.getLogRecord();
        JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, record, index, isSelected, cellHasFocus);
        String formattedText = this.getFormattedText(record);
        label.setText(formattedText);
        if (!isSelected) {
            if (record.getFormattedMessage().startsWith("---") && record.getFormattedMessage().endsWith("---")) {
                label.setForeground(Color.GRAY);
            } else if (record.getLogLevel() == LogLevel.ERROR) {
                label.setForeground(ERROR_COLOR);
            } else if (record.getLogLevel() == LogLevel.WARN) {
                label.setForeground(WARNING_COLOR);
            } else if (record.getLogLevel() == LogLevel.DEBUG) {
                label.setForeground(Color.LIGHT_GRAY);
            }
        }
        label.setBorder(border);
        return label;
    }

    private String getFormattedText(LogRecord record) {
        String firstLine = String.format("%7s  %s  %s", new Object[]{record.getLogLevel(), this.getTimestampRendering(record.getTimestamp()), record.getFormattedMessage()});
        if (record.getThrowableInfo().isPresent()) {
            return firstLine + " (See log file for more details)";
        }
        return firstLine;
    }

    private String getTimestampRendering(long timestamp) {
        Date date = new Date(timestamp);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.format("%02d:%02d:%02d", calendar.get(11), calendar.get(12), calendar.get(13));
    }
}

