/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImplWithoutEntityAndAnonCaching;

public abstract class OWLIndividualRelationshipAxiomImpl<P extends OWLPropertyExpression, O extends OWLPropertyAssertionObject>
extends OWLLogicalAxiomImplWithoutEntityAndAnonCaching
implements OWLPropertyAssertionAxiom<P, O> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLIndividual subject;
    @Nonnull
    private final P property;
    @Nonnull
    private final O o;

    public OWLIndividualRelationshipAxiomImpl(@Nonnull OWLIndividual subject, @Nonnull P property, @Nonnull O object, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subject = OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        this.property = (OWLPropertyExpression)OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        this.o = (OWLPropertyAssertionObject)OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        if (this.getSubject().isNamed()) {
            entities.add(this.getSubject().asOWLNamedIndividual());
        }
        this.addSignatureEntitiesToSetForValue(entities, this.getProperty());
        this.addSignatureEntitiesToSetForValue(entities, (HasSignature)this.getObject());
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        if (this.getSubject().isAnonymous()) {
            anons.add(this.getSubject().asOWLAnonymousIndividual());
        }
        this.addAnonymousIndividualsToSetForValue(anons, this.getProperty());
        this.addAnonymousIndividualsToSetForValue(anons, (HasAnonymousIndividuals)this.getObject());
    }

    @Override
    public OWLIndividual getSubject() {
        return this.subject;
    }

    @Override
    public P getProperty() {
        return this.property;
    }

    @Override
    public O getObject() {
        return this.o;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLPropertyAssertionAxiom)) {
            return false;
        }
        OWLPropertyAssertionAxiom other = (OWLPropertyAssertionAxiom)obj;
        return other.getSubject().equals(this.subject) && other.getProperty().equals(this.property) && other.getObject().equals(this.o);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLPropertyAssertionAxiom other = (OWLPropertyAssertionAxiom)object;
        int diff = this.subject.compareTo(other.getSubject());
        if (diff != 0) {
            return diff;
        }
        diff = this.property.compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return this.o.compareTo(other.getObject());
    }
}

