#ifndef _EFL_PAGE_TRANSITION_EO_H_
#define _EFL_PAGE_TRANSITION_EO_H_

#ifndef _EFL_PAGE_TRANSITION_EO_CLASS_TYPE
#define _EFL_PAGE_TRANSITION_EO_CLASS_TYPE

typedef Eo Efl_Page_Transition;

#endif

#ifndef _EFL_PAGE_TRANSITION_EO_TYPES
#define _EFL_PAGE_TRANSITION_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Page transition for @ref Efl_Ui_Pager
 *
 * A page transition is essential to @ref Efl_Ui_Pager object and invoked
 * whenever pages are rearranged or scrolled (see @ref Efl_Ui_Pager).
 *
 * @ingroup Efl_Page_Transition
 */
#define EFL_PAGE_TRANSITION_CLASS efl_page_transition_class_get()

EWAPI const Efl_Class *efl_page_transition_class_get(void);

/**
 * @brief set object
 *
 * @param[in] obj The object.
 * @param[in] pager pager object
 * @param[in] group a dummy object for layer adjustment
 *
 * @ingroup Efl_Page_Transition
 */
EOAPI void efl_page_transition_bind(Eo *obj, Efl_Ui_Pager *pager, Efl_Canvas_Group *group);
#endif /* EFL_BETA_API_SUPPORT */

#endif
