#ifndef _EFL_UI_FLIP_EO_LEGACY_H_
#define _EFL_UI_FLIP_EO_LEGACY_H_

#ifndef _EFL_UI_FLIP_EO_CLASS_TYPE
#define _EFL_UI_FLIP_EO_CLASS_TYPE

typedef Eo Efl_Ui_Flip;

#endif

#ifndef _EFL_UI_FLIP_EO_TYPES
#define _EFL_UI_FLIP_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Efl UI flip mode
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_FLIP_MODE_ROTATE_Y_CENTER_AXIS = 0, /**< Rotate Y center axis flip mode
                                              */
  EFL_UI_FLIP_MODE_ROTATE_X_CENTER_AXIS, /**< Rotate X center axis flip mode */
  EFL_UI_FLIP_MODE_ROTATE_XZ_CENTER_AXIS, /**< Rotate XZ center axis flip mode
                                           */
  EFL_UI_FLIP_MODE_ROTATE_YZ_CENTER_AXIS, /**< Rotate YZ center axis flip mode
                                           */
  EFL_UI_FLIP_MODE_CUBE_LEFT, /**< Cube left flip mode */
  EFL_UI_FLIP_MODE_CUBE_RIGHT, /**< Cube right flip mode */
  EFL_UI_FLIP_MODE_CUBE_UP, /**< Cube up flip mode */
  EFL_UI_FLIP_MODE_CUBE_DOWN, /**< Cube down flip mode */
  EFL_UI_FLIP_MODE_PAGE_LEFT, /**< Page left flip mode */
  EFL_UI_FLIP_MODE_PAGE_RIGHT, /**< Page right flip mode */
  EFL_UI_FLIP_MODE_PAGE_UP, /**< Page up flip mode */
  EFL_UI_FLIP_MODE_PAGE_DOWN, /**< Page down flip mode */
  EFL_UI_FLIP_MODE_CROSS_FADE /**< Cross fade flip mode */
} Efl_Ui_Flip_Mode;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Efl UI flip interaction
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_FLIP_INTERACTION_NONE = 0, /**< No interaction */
  EFL_UI_FLIP_INTERACTION_ROTATE, /**< Rotate interaction */
  EFL_UI_FLIP_INTERACTION_CUBE, /**< Cube interaction */
  EFL_UI_FLIP_INTERACTION_PAGE /**< Page interaction */
} Efl_Ui_Flip_Interaction;
#endif /* EFL_BETA_API_SUPPORT */


#endif

#endif
