/**
 * @file
 * A Backbone View that provides the aural view of a contextual link.
 */

(function(Drupal, Backbone) {
  Drupal.contextual.AuralView = Backbone.View.extend(
    /** @lends Drupal.contextual.AuralView# */ {
      /**
       * Renders the aural view of a contextual link (i.e. screen reader support).
       *
       * @constructs
       *
       * @augments Backbone.View
       *
       * @param {object} options
       *   Options for the view.
       */
      initialize(options) {
        this.options = options;

        this.listenTo(this.model, 'change', this.render);

        // Use aria-role form so that the number of items in the list is spoken.
        this.$el.attr('role', 'form');

        // Initial render.
        this.render();
      },

      /**
       * @inheritdoc
       */
      render() {
        const isOpen = this.model.get('isOpen');

        // Set the hidden property of the links.
        this.$el.find('.contextual-links').prop('hidden', !isOpen);

        // Update the view of the trigger.
        this.$el
          .find('.trigger')
          .text(
            Drupal.t('@action @title configuration options', {
              '@action': !isOpen
                ? this.options.strings.open
                : this.options.strings.close,
              '@title': this.model.get('title'),
            }),
          )
          .attr('aria-pressed', isOpen);
      },
    },
  );
})(Drupal, Backbone);
