/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;

public final class GeoPoint
implements ToXContentFragment {
    private double lat;
    private double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint(GeoPoint template) {
        this(template.getLat(), template.getLon());
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        return this.resetFromString(value, false);
    }

    public GeoPoint resetFromString(String value, boolean ignoreZValue) {
        if (value.contains(",")) {
            return this.resetFromCoordinates(value, ignoreZValue);
        }
        return this.resetFromGeoHash(value);
    }

    public GeoPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double lon;
        double lat;
        String[] vals = value.split(",");
        if (vals.length > 3) {
            throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", vals.length);
        }
        try {
            lat = Double.parseDouble(vals[0].trim());
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("latitude must be a number", new Object[0]);
        }
        try {
            lon = Double.parseDouble(vals[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("longitude must be a number", new Object[0]);
        }
        if (vals.length > 2) {
            GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
        }
        return this.reset(lat, lon);
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = GeoHashUtils.decodeLongitude(hash);
        this.lat = GeoHashUtils.decodeLatitude(hash);
        return this;
    }

    public GeoPoint resetFromIndexableField(IndexableField field) {
        if (field instanceof LatLonPoint) {
            BytesRef br = field.binaryValue();
            byte[] bytes = Arrays.copyOfRange(br.bytes, br.offset, br.length);
            return this.reset(GeoEncodingUtils.decodeLatitude((byte[])bytes, (int)0), GeoEncodingUtils.decodeLongitude((byte[])bytes, (int)4));
        }
        if (field instanceof LatLonDocValuesField) {
            long encoded = (Long)field.numericValue();
            return this.reset(GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))), GeoEncodingUtils.decodeLongitude((int)((int)encoded)));
        }
        return this.resetFromIndexHash(Long.parseLong(field.stringValue()));
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash;
        try {
            hash = GeoHashUtils.mortonEncode(geohash);
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticsearchParseException(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        return this.reset(GeoHashUtils.decodeLatitude(hash), GeoHashUtils.decodeLongitude(hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop((long)(geohashLong >>> 4 << level * 5 + 2)));
    }

    public double lat() {
        return this.lat;
    }

    public double getLat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double getLon() {
        return this.lon;
    }

    public String geohash() {
        return GeoHashUtils.stringEncode(this.lon, this.lat);
    }

    public String getGeohash() {
        return GeoHashUtils.stringEncode(this.lon, this.lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public static GeoPoint parseFromLatLon(String latLon) {
        GeoPoint point = new GeoPoint(latLon);
        return point;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.latlon(this.lat, this.lon);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [{}] parameter is [{}]", zValue, GeoPointFieldMapper.Names.IGNORE_Z_VALUE, ignoreZValue);
        }
        return zValue;
    }
}

