/*
 * Decompiled with CFR 0.152.
 */
package logger;

import firrtl.ExecutionOptionsManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import logger.LazyLogging;
import logger.LogLevel$;
import logger.Logger;
import logger.LoggerState;
import scala.Array$;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.AbstractTraversable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

public final class Logger$ {
    public static Logger$ MODULE$;
    private final DynamicVariable<Option<LoggerState>> updatableLoggerState;

    static {
        new Logger$();
    }

    private DynamicVariable<Option<LoggerState>> updatableLoggerState() {
        return this.updatableLoggerState;
    }

    private LoggerState state() {
        return this.updatableLoggerState().value().get();
    }

    public <A> A makeScope(ExecutionOptionsManager manager, Function0<A> codeBlock) {
        LoggerState loggerState;
        LoggerState newRunState = (LoggerState)this.updatableLoggerState().value().getOrElse((Function0<LoggerState> & Serializable & scala.Serializable)() -> new LoggerState());
        if (newRunState.fromInvoke()) {
            loggerState = newRunState;
        } else {
            LoggerState forcedNewRunState = new LoggerState();
            forcedNewRunState.fromInvoke_$eq(true);
            loggerState = forcedNewRunState;
        }
        LoggerState runState = loggerState;
        return (A)this.updatableLoggerState().withValue(new Some<LoggerState>(runState), (Function0<Object> & Serializable & scala.Serializable)() -> {
            MODULE$.setOptions(manager);
            return codeBlock.apply();
        });
    }

    public <A> A makeScope(String[] args, Function0<A> codeBlock) {
        ExecutionOptionsManager executionOptionsManager = new ExecutionOptionsManager("logger");
        if (!executionOptionsManager.parse(args)) {
            throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"logger invoke failed to parse args ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(", ")})));
        }
        return this.makeScope(executionOptionsManager, codeBlock);
    }

    public <A> String[] makeScope$default$1() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    private Option<Object> testPackageNameMatch(String className, Enumeration.Value level) {
        Enumeration.Value levelForThisClassName;
        HashMap<String, Enumeration.Value> classLevels = this.state().classLevels();
        if (classLevels.isEmpty()) {
            return None$.MODULE$;
        }
        Enumeration.Value value = levelForThisClassName = (Enumeration.Value)this.state().classToLevelCache().getOrElse(className, (Function0<Enumeration.Value> & Serializable & scala.Serializable)() -> {
            void var3_3;
            block0: {
                Enumeration.Value levelSpecified;
                List<Object> packageNameList = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])className.split("\\."))).toList();
                Enumeration.Value value = levelSpecified = Logger$.matchPathToFindLevel$1(packageNameList, classLevels);
                Enumeration.Value value2 = LogLevel$.MODULE$.None();
                if (!(value == null ? value2 != null : !((Object)value).equals(value2))) break block0;
                MODULE$.state().classToLevelCache().update(className, levelSpecified);
            }
            return var3_3;
        });
        Enumeration.Value value2 = LogLevel$.MODULE$.None();
        return (value == null ? value2 != null : !((Object)value).equals(value2)) ? new Some<Boolean>(BoxesRunTime.boxToBoolean(levelForThisClassName.$greater$eq(level))) : None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public void logger$Logger$$showMessage(Enumeration.Value level, String className, Function0<String> message) {
        block3: {
            block5: {
                block6: {
                    block4: {
                        block2: {
                            var5_4 = false;
                            var6_5 = null;
                            var7_6 = this.testPackageNameMatch(className, level);
                            if (!(var7_6 instanceof Some)) break block2;
                            var5_4 = true;
                            var6_5 = (Some)var7_6;
                            var8_7 = BoxesRunTime.unboxToBoolean(var6_5.value());
                            if (!var8_7) break block2;
                            this.logIt$1(level, className, message);
                            var4_8 = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!var5_4 || (var9_11 = BoxesRunTime.unboxToBoolean(var6_5.value()))) break block4;
                        var4_9 = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!None$.MODULE$.equals(var7_6)) break block5;
                    v0 = this.state().globalLevel();
                    var10_12 = LogLevel$.MODULE$.None();
                    if (v0 != null ? v0.equals(var10_12) == false : var10_12 != null) break block6;
                    v1 = level;
                    var11_13 = LogLevel$.MODULE$.Error();
                    if (!(v1 == null ? var11_13 != null : v1.equals(var11_13) == false)) ** GOTO lbl-1000
                }
                v2 = this.state().globalLevel();
                var12_14 = LogLevel$.MODULE$.None();
                if ((v2 == null ? var12_14 != null : v2.equals(var12_14) == false) && this.state().globalLevel().$greater$eq(level)) lbl-1000:
                // 2 sources

                {
                    this.logIt$1(level, className, message);
                    v3 = BoxedUnit.UNIT;
                } else {
                    v3 = BoxedUnit.UNIT;
                }
                var4_10 = v3;
                break block3;
            }
            throw new MatchError(var7_6);
        }
    }

    public Enumeration.Value getGlobalLevel() {
        return this.state().globalLevel();
    }

    public void reset() {
        this.state().classLevels().clear();
        this.clearCache();
        this.state().logClassNames_$eq(false);
        this.state().globalLevel_$eq(LogLevel$.MODULE$.Error());
        this.state().stream_$eq(System.out);
    }

    private void clearCache() {
        this.state().classToLevelCache().clear();
    }

    public void setLevel(Enumeration.Value level) {
        this.state().globalLevel_$eq(level);
    }

    public void setLevel(String classOrPackageName, Enumeration.Value level) {
        this.clearCache();
        this.state().classLevels().update(classOrPackageName, level);
    }

    public void setLevel(Class<? extends LazyLogging> classType, Enumeration.Value level) {
        this.clearCache();
        String name = classType.getCanonicalName();
        this.state().classLevels().update(name, level);
    }

    public void clearStringBuffer() {
        Option<Logger.OutputCaptor> option = this.state().stringBufferOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Logger.OutputCaptor x = (Logger.OutputCaptor)some.value();
            x.byteArrayOutputStream().reset();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void setOutput(String fileName) {
        this.state().stream_$eq(new PrintStream(new FileOutputStream(new File(fileName))));
    }

    public void setOutput(PrintStream stream) {
        this.state().stream_$eq(stream);
    }

    public void setConsole() {
        this.state().stream_$eq(Console$.MODULE$.out());
    }

    public void setClassLogLevels(Map<String, Enumeration.Value> namesToLevel) {
        this.clearCache();
        this.state().classLevels().$plus$plus$eq(namesToLevel);
    }

    /*
     * Unable to fully structure code
     */
    public void setOptions(ExecutionOptionsManager optionsManager) {
        block4: {
            block5: {
                block3: {
                    commonOptions = optionsManager.commonOptions();
                    v0 = this.state();
                    var4_3 = new Tuple2<Enumeration.Value, Enumeration.Value>(this.state().globalLevel(), commonOptions.globalLogLevel());
                    if (var4_3 == null) break block3;
                    var5_4 = var4_3._1();
                    var6_5 = var4_3._2();
                    v1 = LogLevel$.MODULE$.None();
                    var7_6 = var5_4;
                    if (v1 != null ? v1.equals(var7_6) == false : var7_6 != null) break block3;
                    v2 = LogLevel$.MODULE$.None();
                    var8_7 = var6_5;
                    if (v2 != null ? v2.equals(var8_7) == false : var8_7 != null) break block3;
                    var2_8 = LogLevel$.MODULE$.None();
                    break block4;
                }
                if (var4_3 == null) break block5;
                x = var4_3._1();
                var10_10 = var4_3._2();
                v3 = LogLevel$.MODULE$.None();
                var11_11 = var10_10;
                if (v3 != null ? v3.equals(var11_11) == false : var11_11 != null) break block5;
                var2_8 = x;
                break block4;
            }
            if (var4_3 == null) ** GOTO lbl-1000
            var12_12 = var4_3._1();
            x = var4_3._2();
            v4 = LogLevel$.MODULE$.None();
            var14_14 = var12_12;
            if (!(v4 != null ? v4.equals(var14_14) == false : var14_14 != null)) {
                var2_8 = x;
            } else lbl-1000:
            // 2 sources

            {
                var2_8 = var4_3 != null ? (x = var4_3._2()) : LogLevel$.MODULE$.Error();
            }
        }
        v0.globalLevel_$eq(var2_8);
        this.setClassLogLevels(commonOptions.classLogLevels());
        if (commonOptions.logToFile()) {
            this.setOutput(commonOptions.getLogFileName(optionsManager));
        }
        this.state().logClassNames_$eq(commonOptions.logClassNames());
    }

    /*
     * WARNING - void declaration
     */
    private static final Enumeration.Value matchPathToFindLevel$1(List packageList, HashMap classLevels$1) {
        Enumeration.Value value;
        if (packageList.isEmpty()) {
            value = LogLevel$.MODULE$.None();
        } else {
            void var3_3;
            String partialName = packageList.mkString(".");
            Enumeration.Value level = (Enumeration.Value)classLevels$1.getOrElse(partialName, (Function0<Enumeration.Value> & Serializable & scala.Serializable)() -> Logger$.matchPathToFindLevel$1((List)((List)((AbstractTraversable)packageList.reverse()).tail()).reverse(), classLevels$1));
            value = var3_3;
        }
        return value;
    }

    private final void logIt$1(Enumeration.Value level$1, String className$2, Function0 message$1) {
        if (this.state().logClassNames()) {
            this.state().stream().println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ":", "] ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{level$1, className$2, message$1.apply()})));
        } else {
            this.state().stream().println((String)message$1.apply());
        }
    }

    private Logger$() {
        MODULE$ = this;
        this.updatableLoggerState = new DynamicVariable<Some<LoggerState>>(new Some<LoggerState>(new LoggerState()));
    }
}

