/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.base.Optional;
import org.gradle.model.ModelElement;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

public class ModelElementProjection
extends TypeCompatibilityModelProjectionSupport<ModelElement> {
    private static final ModelType<ModelElement> MODEL_ELEMENT_MODEL_TYPE = ModelType.of(ModelElement.class);
    private final ModelType<?> publicType;

    public ModelElementProjection(ModelType<?> publicType) {
        super(MODEL_ELEMENT_MODEL_TYPE);
        this.publicType = publicType;
    }

    @Override
    protected ModelView<ModelElement> toView(final MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
        return InstanceModelView.of(modelNode.getPath(), MODEL_ELEMENT_MODEL_TYPE, new ModelElement(){

            public String toString() {
                return this.getDisplayName();
            }

            @Override
            public String getName() {
                return modelNode.getPath().getName();
            }

            @Override
            public String getDisplayName() {
                return ModelElementProjection.this.publicType.getDisplayName() + " '" + modelNode.getPath() + "'";
            }
        });
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode mutableModelNode) {
        return Optional.absent();
    }
}

