/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import jspecview.common.PanelData;
import jspecview.common.ScriptToken;

public class Parameters {
    public String name;
    public double integralMinY = 0.1;
    public double integralRange = 50.0;
    public double integralOffset = 30.0;
    public boolean integralDrawAll = false;
    public double viewOffset = 0.0;
    public double peakListThreshold = Double.NaN;
    public String peakListInterpolation = "parabolic";
    public int precision = 2;
    protected Map<ScriptToken, Boolean> htBooleans = new Hashtable<ScriptToken, Boolean>();

    public Parameters() {
        this.setBoolean(ScriptToken.TITLEON, true);
        this.setBoolean(ScriptToken.ENABLEZOOM, true);
        this.setBoolean(ScriptToken.DISPLAY2D, true);
        this.setBoolean(ScriptToken.COORDINATESON, true);
        this.setBoolean(ScriptToken.PEAKTABSON, true);
        this.setBoolean(ScriptToken.GRIDON, true);
        this.setBoolean(ScriptToken.XSCALEON, true);
        this.setBoolean(ScriptToken.YSCALEON, true);
        this.setBoolean(ScriptToken.XUNITSON, true);
        this.setBoolean(ScriptToken.YUNITSON, true);
    }

    public Parameters setName(String string) {
        this.name = string;
        return this;
    }

    public Map<ScriptToken, Boolean> getBooleans() {
        return this.htBooleans;
    }

    public boolean setBoolean(ScriptToken scriptToken, boolean bl) {
        this.htBooleans.put(scriptToken, bl);
        return bl;
    }

    public boolean getBoolean(ScriptToken scriptToken) {
        return Boolean.TRUE == this.htBooleans.get((Object)scriptToken);
    }

    public static boolean isTrue(String string) {
        return string.length() == 0 || Boolean.parseBoolean(string);
    }

    public static Boolean getTFToggle(String string) {
        return string.equalsIgnoreCase("TOGGLE") ? null : (Parameters.isTrue(string) ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setP(PanelData panelData, ScriptToken scriptToken, String string) {
        switch (scriptToken) {
            default: {
                return;
            }
            case COORDINATESON: 
            case DISPLAY1D: 
            case DISPLAY2D: 
            case ENABLEZOOM: 
            case GRIDON: 
            case PEAKTABSON: 
            case REVERSEPLOT: 
            case TITLEON: 
            case TITLEBOLDON: 
            case XSCALEON: 
            case XUNITSON: 
            case YSCALEON: 
            case YUNITSON: 
        }
        Boolean bl = Parameters.getTFToggle(string);
        if (bl != null) {
            this.setBoolean(scriptToken, bl);
        } else {
            if (panelData == null) {
                return;
            }
            boolean bl2 = !panelData.getBoolean(scriptToken);
            switch (scriptToken) {
                default: {
                    break;
                }
                case XSCALEON: {
                    this.setBoolean(ScriptToken.XUNITSON, bl2);
                    panelData.setBoolean(ScriptToken.XUNITSON, bl2);
                    break;
                }
                case YSCALEON: {
                    this.setBoolean(ScriptToken.YUNITSON, bl2);
                    panelData.setBoolean(ScriptToken.YUNITSON, bl2);
                }
            }
            this.setBoolean(scriptToken, bl2);
        }
        if (panelData == null) {
            return;
        }
        panelData.setBooleans(this, scriptToken);
    }

    public static boolean isMatch(String string, String string2) {
        return string == null || string2.equalsIgnoreCase(string);
    }

    public static void putInfo(String string, Map<String, Object> map, String string2, Object object) {
        if (object != null && Parameters.isMatch(string, string2)) {
            map.put(string == null ? string2 : string, object);
        }
    }
}

