/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.PeriodicVolumeFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

class VaspChgcarReader
extends PeriodicVolumeFileReader {
    private float volume;
    private int pt;
    private int nPerLine;

    VaspChgcarReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
        this.isPeriodic = true;
        this.isProgressive = false;
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("Vasp CHGCAR format\n\n\n");
        this.rd();
        float f = this.parseFloatStr(this.rd());
        float[] fArray = new float[15];
        fArray[0] = -1.0f;
        int n = 0;
        int n2 = 6;
        while (n < 3) {
            int n3 = n2++;
            float f2 = this.parseFloatStr(this.rd()) * f;
            fArray[n3] = f2;
            int n4 = n2++;
            float f3 = this.parseFloat() * f;
            fArray[n4] = f3;
            int n5 = n2++;
            float f4 = this.parseFloat() * f;
            fArray[n5] = f4;
            this.volumetricVectors[n].set(f2, f3, f4);
            ++n;
        }
        this.volume = (float)SimpleUnitCell.newA((float[])fArray).volume;
        while (this.rd().length() > 2) {
        }
        this.rd();
        String[] stringArray = this.getTokens();
        n2 = 0;
        while (n2 < 3) {
            this.voxelCounts[n2] = this.parseIntStr(stringArray[n2]) + 1;
            this.volumetricVectors[n2].scale(1.0f / (float)(this.voxelCounts[n2] - 1));
            if (this.isAnisotropic) {
                this.setVectorAnisotropy(this.volumetricVectors[n2]);
            }
            ++n2;
        }
        this.swapXZ();
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            this.params.cutoff = 0.5f;
            Logger.info("Cutoff set to " + this.params.cutoff);
        }
    }

    @Override
    protected float nextVoxel() throws Exception {
        if (this.pt++ % this.nPerLine == 0 && this.nData > 0) {
            this.rd();
            this.next[0] = 0;
        }
        return this.parseFloat() / this.volume;
    }

    @Override
    protected void getPeriodicVoxels() throws Exception {
        int n = this.voxelCounts[0] - 1;
        int n2 = this.voxelCounts[1] - 1;
        int n3 = this.voxelCounts[2] - 1;
        boolean bl = this.nSkipX > 0;
        this.nPerLine = PT.countTokens(this.rd(), 0);
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n3) {
                    this.voxelData[n4][n5][n6] = this.recordData(this.nextVoxel());
                    if (bl) {
                        int n7 = this.nSkipX;
                        while (--n7 >= 0) {
                            this.nextVoxel();
                        }
                    }
                    ++n6;
                }
                if (bl) {
                    n6 = this.nSkipY;
                    while (--n6 >= 0) {
                        this.nextVoxel();
                    }
                }
                ++n5;
            }
            if (bl) {
                n5 = this.nSkipZ;
                while (--n5 >= 0) {
                    this.nextVoxel();
                }
            }
            ++n4;
        }
    }
}

