/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.parser.m2.PomWriterOptions;
import org.apache.ivy.util.ConfigurationUtils;

public final class PomModuleDescriptorWriter {
    private static final String SKIP_LINE = "SKIP_LINE";
    private static final PomWriterOptions.ConfigurationScopeMapping DEFAULT_MAPPING = new PomWriterOptions.ConfigurationScopeMapping(new HashMap(){
        {
            this.put("compile", "compile");
            this.put("runtime", "runtime");
            this.put("provided", "provided");
            this.put("test", "test");
            this.put("system", "system");
        }
    });

    private PomModuleDescriptorWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ModuleDescriptor moduleDescriptor, File file, PomWriterOptions pomWriterOptions) throws IOException {
        LineNumberReader lineNumberReader = pomWriterOptions.getTemplate() == null ? new LineNumberReader(new InputStreamReader(PomModuleDescriptorWriter.class.getResourceAsStream("pom.template"))) : new LineNumberReader(new InputStreamReader(new FileInputStream(pomWriterOptions.getTemplate())));
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            IvySettings ivySettings = IvyContext.getContext().getSettings();
            IvyVariableContainerWrapper ivyVariableContainerWrapper = new IvyVariableContainerWrapper(ivySettings.getVariableContainer());
            ivyVariableContainerWrapper.setVariable("ivy.pom.license", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.header", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.groupId", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.artifactId", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.version", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.packaging", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.name", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.description", SKIP_LINE, true);
            ivyVariableContainerWrapper.setVariable("ivy.pom.url", SKIP_LINE, true);
            if (pomWriterOptions.getLicenseHeader() != null) {
                ivyVariableContainerWrapper.setVariable("ivy.pom.license", pomWriterOptions.getLicenseHeader(), true);
            }
            if (pomWriterOptions.isPrintIvyInfo()) {
                String string = "<!--\n   Apache Maven 2 POM generated by Apache Ivy\n   " + Ivy.getIvyHomeURL() + "\n   Apache Ivy version: " + Ivy.getIvyVersion() + " " + Ivy.getIvyDate() + "\n-->";
                ivyVariableContainerWrapper.setVariable("ivy.pom.header", string, true);
            }
            PomModuleDescriptorWriter.setModuleVariables(moduleDescriptor, ivyVariableContainerWrapper, pomWriterOptions);
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            String string = lineNumberReader.readLine();
            while (string != null) {
                if ((string = IvyPatternHelper.substituteVariables(string, ivyVariableContainerWrapper)).indexOf(SKIP_LINE) != -1) {
                    string = lineNumberReader.readLine();
                    continue;
                }
                if (string.trim().length() == 0) {
                    printWriter.println(string);
                    string = lineNumberReader.readLine();
                    continue;
                }
                n = n2;
                n2 = string.indexOf(60);
                if (!bl && string.indexOf("</dependencies>") != -1) {
                    PomModuleDescriptorWriter.printDependencies(moduleDescriptor, printWriter, pomWriterOptions, n2, false);
                    bl = true;
                }
                if (!bl && string.indexOf("</project>") != -1) {
                    PomModuleDescriptorWriter.printDependencies(moduleDescriptor, printWriter, pomWriterOptions, n, true);
                    bl = true;
                }
                printWriter.println(string);
                string = lineNumberReader.readLine();
            }
        }
        finally {
            lineNumberReader.close();
            printWriter.close();
        }
    }

    private static void setModuleVariables(ModuleDescriptor moduleDescriptor, IvyVariableContainer ivyVariableContainer, PomWriterOptions pomWriterOptions) {
        String string;
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
        ivyVariableContainer.setVariable("ivy.pom.groupId", moduleRevisionId.getOrganisation(), true);
        String string2 = pomWriterOptions.getArtifactName();
        if (string2 == null) {
            string2 = moduleRevisionId.getName();
        }
        if ((string = pomWriterOptions.getArtifactPackaging()) == null) {
            Artifact artifact = PomModuleDescriptorWriter.findArtifact(moduleDescriptor, string2);
            string = artifact == null ? "pom" : artifact.getType();
        }
        ivyVariableContainer.setVariable("ivy.pom.artifactId", string2, true);
        ivyVariableContainer.setVariable("ivy.pom.packaging", string, true);
        if (moduleRevisionId.getRevision() != null) {
            ivyVariableContainer.setVariable("ivy.pom.version", moduleRevisionId.getRevision(), true);
        }
        if (pomWriterOptions.getDescription() != null) {
            ivyVariableContainer.setVariable("ivy.pom.description", pomWriterOptions.getDescription(), true);
        }
        if (moduleDescriptor.getHomePage() != null) {
            ivyVariableContainer.setVariable("ivy.pom.url", moduleDescriptor.getHomePage(), true);
        }
    }

    private static Artifact findArtifact(ModuleDescriptor moduleDescriptor, String string) {
        Artifact[] artifactArray = moduleDescriptor.getAllArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            if (!artifactArray[i].getName().equals(string) || artifactArray[i].getAttribute("classifier") != null) continue;
            return artifactArray[i];
        }
        return null;
    }

    private static void indent(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print(' ');
        }
    }

    private static void printDependencies(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, PomWriterOptions pomWriterOptions, int n, boolean bl) {
        List list = pomWriterOptions.getExtraDependencies();
        DependencyDescriptor[] dependencyDescriptorArray = PomModuleDescriptorWriter.getDependencies(moduleDescriptor, pomWriterOptions);
        if (!list.isEmpty() || dependencyDescriptorArray.length > 0) {
            ExcludeRule[] excludeRuleArray;
            Object object;
            if (bl) {
                PomModuleDescriptorWriter.indent(printWriter, n);
                printWriter.println("<dependencies>");
            }
            for (PomWriterOptions.ExtraDependency extraDependency : list) {
                object = extraDependency.getGroup();
                if (object == null) {
                    object = moduleDescriptor.getModuleRevisionId().getOrganisation();
                }
                if ((excludeRuleArray = extraDependency.getVersion()) == null) {
                    excludeRuleArray = moduleDescriptor.getModuleRevisionId().getRevision();
                }
                PomModuleDescriptorWriter.printDependency(printWriter, n, (String)object, extraDependency.getArtifact(), (String)excludeRuleArray, extraDependency.getType(), extraDependency.getClassifier(), extraDependency.getScope(), extraDependency.isOptional(), null);
            }
            Object object2 = pomWriterOptions.getMapping();
            if (object2 == null) {
                object2 = DEFAULT_MAPPING;
            }
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray;
                object = dependencyDescriptorArray[i].getDependencyRevisionId();
                excludeRuleArray = null;
                if (dependencyDescriptorArray[i].canExclude()) {
                    excludeRuleArray = dependencyDescriptorArray[i].getAllExcludeRules();
                }
                if ((dependencyArtifactDescriptorArray = dependencyDescriptorArray[i].getAllDependencyArtifacts()).length > 0) {
                    for (int j = 0; j < dependencyArtifactDescriptorArray.length; ++j) {
                        String string = dependencyArtifactDescriptorArray[j].getType();
                        String string2 = dependencyArtifactDescriptorArray[j].getExtraAttribute("classifier");
                        String string3 = ((PomWriterOptions.ConfigurationScopeMapping)object2).getScope(dependencyDescriptorArray[i].getModuleConfigurations());
                        boolean bl2 = ((PomWriterOptions.ConfigurationScopeMapping)object2).isOptional(dependencyDescriptorArray[i].getModuleConfigurations());
                        PomModuleDescriptorWriter.printDependency(printWriter, n, ((ModuleRevisionId)object).getOrganisation(), ((ModuleRevisionId)object).getName(), ((ModuleRevisionId)object).getRevision(), string, string2, string3, bl2, excludeRuleArray);
                    }
                    continue;
                }
                String string = ((PomWriterOptions.ConfigurationScopeMapping)object2).getScope(dependencyDescriptorArray[i].getModuleConfigurations());
                boolean bl3 = ((PomWriterOptions.ConfigurationScopeMapping)object2).isOptional(dependencyDescriptorArray[i].getModuleConfigurations());
                PomModuleDescriptorWriter.printDependency(printWriter, n, ((ModuleRevisionId)object).getOrganisation(), ((ModuleRevisionId)object).getName(), ((ModuleRevisionId)object).getRevision(), null, null, string, bl3, excludeRuleArray);
            }
            if (bl) {
                PomModuleDescriptorWriter.indent(printWriter, n);
                printWriter.println("</dependencies>");
            }
        }
    }

    private static void printDependency(PrintWriter printWriter, int n, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, ExcludeRule[] excludeRuleArray) {
        PomModuleDescriptorWriter.indent(printWriter, n * 2);
        printWriter.println("<dependency>");
        PomModuleDescriptorWriter.indent(printWriter, n * 3);
        printWriter.println("<groupId>" + string + "</groupId>");
        PomModuleDescriptorWriter.indent(printWriter, n * 3);
        printWriter.println("<artifactId>" + string2 + "</artifactId>");
        PomModuleDescriptorWriter.indent(printWriter, n * 3);
        printWriter.println("<version>" + string3 + "</version>");
        if (string4 != null && !"jar".equals(string4)) {
            PomModuleDescriptorWriter.indent(printWriter, n * 3);
            printWriter.println("<type>" + string4 + "</type>");
        }
        if (string5 != null) {
            PomModuleDescriptorWriter.indent(printWriter, n * 3);
            printWriter.println("<classifier>" + string5 + "</classifier>");
        }
        if (string6 != null) {
            PomModuleDescriptorWriter.indent(printWriter, n * 3);
            printWriter.println("<scope>" + string6 + "</scope>");
        }
        if (bl) {
            PomModuleDescriptorWriter.indent(printWriter, n * 3);
            printWriter.println("<optional>true</optional>");
        }
        if (excludeRuleArray != null) {
            PomModuleDescriptorWriter.printExclusions(excludeRuleArray, printWriter, n);
        }
        PomModuleDescriptorWriter.indent(printWriter, n * 2);
        printWriter.println("</dependency>");
    }

    private static void printExclusions(ExcludeRule[] excludeRuleArray, PrintWriter printWriter, int n) {
        PomModuleDescriptorWriter.indent(printWriter, n * 3);
        printWriter.println("<exclusions>");
        for (int i = 0; i < excludeRuleArray.length; ++i) {
            PomModuleDescriptorWriter.indent(printWriter, n * 4);
            printWriter.println("<exclusion>");
            ExcludeRule excludeRule = excludeRuleArray[i];
            PomModuleDescriptorWriter.indent(printWriter, n * 5);
            printWriter.println("<groupId>" + excludeRule.getId().getModuleId().getOrganisation() + "</groupId>");
            PomModuleDescriptorWriter.indent(printWriter, n * 5);
            printWriter.println("<artifactId>" + excludeRule.getId().getModuleId().getName() + "</artifactId>");
            PomModuleDescriptorWriter.indent(printWriter, n * 4);
            printWriter.println("</exclusion>");
        }
        PomModuleDescriptorWriter.indent(printWriter, n * 3);
        printWriter.println("</exclusions>");
    }

    private static DependencyDescriptor[] getDependencies(ModuleDescriptor moduleDescriptor, PomWriterOptions pomWriterOptions) {
        String[] stringArray = ConfigurationUtils.replaceWildcards(pomWriterOptions.getConfs(), moduleDescriptor);
        ArrayList<DependencyDescriptor> arrayList = new ArrayList<DependencyDescriptor>();
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            String[] stringArray2 = dependencyDescriptorArray[i].getDependencyConfigurations(stringArray);
            if (stringArray2 == null || stringArray2.length <= 0) continue;
            arrayList.add(dependencyDescriptorArray[i]);
        }
        return arrayList.toArray(new DependencyDescriptor[arrayList.size()]);
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private final IvyVariableContainer variables;
        private Map localVariables = new HashMap();

        private IvyVariableContainerWrapper(IvyVariableContainer ivyVariableContainer) {
            this.variables = ivyVariableContainer;
        }

        @Override
        public void setVariable(String string, String string2, boolean bl) {
            this.localVariables.put(string, string2);
        }

        @Override
        public void setEnvironmentPrefix(String string) {
            this.variables.setEnvironmentPrefix(string);
        }

        @Override
        public String getVariable(String string) {
            String string2 = this.variables.getVariable(string);
            if (string2 == null) {
                string2 = (String)this.localVariables.get(string);
            }
            return string2;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

