/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.AddOnsTableModel;

public class InstalledAddOnsTableModel
extends AddOnsTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"", Constant.messages.getString("cfu.table.header.name"), Constant.messages.getString("cfu.table.header.desc"), Constant.messages.getString("cfu.table.header.update"), ""};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private AddOnCollection availableAddOns;

    public InstalledAddOnsTableModel(AddOnCollection installedAddOns) {
        super(installedAddOns, 3);
        for (AddOn addOn : installedAddOns.getAddOns()) {
            this.addAddOnWrapper(addOn, null);
        }
    }

    public void setAvailableAddOns(AddOnCollection availableAddOns) {
        this.availableAddOns = availableAddOns;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getRowCount() {
        return this.getAddOnWrappers().size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 || columnIndex == 4) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AddOnWrapper aow = this.getAddOnWrapper(rowIndex);
        switch (columnIndex) {
            case -1: {
                return aow;
            }
            case 0: {
                return aow.hasRunningIssues();
            }
            case 1: {
                return aow.getAddOn().getName();
            }
            case 2: {
                return aow.getAddOn().getDescription();
            }
            case 3: {
                int progress = aow.getProgress();
                if (aow.isFailed()) {
                    return Constant.messages.getString("cfu.table.label.failed");
                }
                if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == aow.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == aow.getInstallationStatus()) {
                    return Constant.messages.getString("cfu.table.label.restartRequired");
                }
                if (progress > 0) {
                    return progress + "%";
                }
                if (AddOnWrapper.Status.newVersion == aow.getStatus()) {
                    return Constant.messages.getString("cfu.table.label.update");
                }
                return "";
            }
            case 4: {
                return this.getAddOnWrapper(rowIndex).isEnabled();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 4) {
            return;
        }
        AddOnWrapper addOnWrapper = this.getAddOnWrapper(rowIndex);
        if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus()) {
            return;
        }
        if (aValue instanceof Boolean && addOnWrapper.getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING) {
            addOnWrapper.setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 4) {
            return false;
        }
        AddOnWrapper addOnWrapper = this.getAddOnWrapper(rowIndex);
        if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus()) {
            return false;
        }
        return addOnWrapper.getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING;
    }

    public boolean canUpdateSelected() {
        boolean enable = false;
        for (AddOnWrapper addon : this.getAddOnWrappers()) {
            if (!addon.isEnabled()) continue;
            if (AddOnWrapper.Status.newVersion == addon.getStatus()) {
                enable = true;
                continue;
            }
            return false;
        }
        return enable;
    }

    public boolean canUninstallSelected() {
        boolean enable = false;
        for (AddOnWrapper addon : this.getAddOnWrappers()) {
            if (!addon.isEnabled()) continue;
            return true;
        }
        return enable;
    }

    public void addOrRefreshAddOn(AddOn addOn) {
        for (int idx = 0; idx < this.getAddOnWrappers().size(); ++idx) {
            AddOnWrapper aow = this.getAddOnWrappers().get(idx);
            if (!addOn.isSameAddOn(this.getAddOnForDownload(aow))) continue;
            aow.setAddOn(addOn);
            this.fireTableRowsUpdated(idx, idx);
            this.refreshEntries();
            return;
        }
        this.addAddOnWrapper(addOn, null);
    }

    @Override
    protected boolean refreshEntry(AddOnWrapper aow, int row) {
        boolean changed = super.refreshEntry(aow, row);
        if (aow.getAddOnUpdate() != null) {
            changed |= this.refreshUpdateIssues(aow);
        }
        return changed;
    }

    @Override
    protected AddOnWrapper createAddOnWrapper(AddOn addOn, AddOnWrapper.Status status) {
        AddOn possibleUpdate;
        AddOnWrapper aow = super.createAddOnWrapper(addOn, status);
        if (this.availableAddOns != null && (possibleUpdate = this.availableAddOns.getAddOn(addOn.getId())) != null && possibleUpdate.isUpdateTo(aow.getAddOn())) {
            aow.setAddOnUpdate(possibleUpdate);
            this.refreshUpdateIssues(aow);
        }
        return aow;
    }

    private boolean refreshUpdateIssues(AddOnWrapper aow) {
        AddOn.AddOnRunRequirements reqs = aow.getAddOnUpdate().calculateRunRequirements(this.availableAddOns.getAddOns());
        String issues = this.getAddOnRunningIssues(reqs);
        aow.setUpdateIssues(issues, !reqs.hasExtensionsWithRunningIssues());
        return !issues.isEmpty();
    }

    public Set<AddOn> getSelectedUpdates() {
        HashSet<AddOn> selectedAddOns = new HashSet<AddOn>();
        for (AddOnWrapper aow : this.getAddOnWrappers()) {
            if (!aow.isEnabled() || aow.getAddOnUpdate() == null) continue;
            selectedAddOns.add(aow.getAddOnUpdate());
        }
        return selectedAddOns;
    }

    public Set<AddOn> getAllUpdates() {
        HashSet<AddOn> selectedAddOns = new HashSet<AddOn>();
        for (AddOnWrapper aow : this.getAddOnWrappers()) {
            if (aow.getAddOnUpdate() == null) continue;
            selectedAddOns.add(aow.getAddOnUpdate());
        }
        return selectedAddOns;
    }

    @Override
    protected AddOn getAddOnForDownload(AddOnWrapper aow) {
        if (aow.getAddOnUpdate() == null) {
            return aow.getAddOn();
        }
        return aow.getAddOnUpdate();
    }

    public List<AddOn> updateEntries() {
        if (this.availableAddOns == null) {
            return Collections.emptyList();
        }
        ArrayList<AddOn> addOnsNotInstalled = new ArrayList<AddOn>(this.availableAddOns.getAddOns());
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            boolean fireRowUpdate = false;
            boolean fireCellUpdate = false;
            AddOnWrapper aow = this.getAddOnWrappers().get(i);
            InstalledAddOnsTableModel.removeAddOn(addOnsNotInstalled, aow.getAddOn().getId());
            AddOn addOn = this.availableAddOns.getAddOn(aow.getAddOn().getId());
            if (addOn != null && addOn.isUpdateTo(aow.getAddOn())) {
                aow.setAddOnUpdate(addOn);
                this.refreshUpdateIssues(aow);
                fireRowUpdate = true;
            } else {
                aow.setStatus(null);
                fireCellUpdate = true;
            }
            if (aow.hasRunningIssues()) {
                fireRowUpdate = this.refreshRunningIssues(aow, i);
            }
            if (fireRowUpdate) {
                this.fireTableRowsUpdated(i, i);
                continue;
            }
            if (!fireCellUpdate) continue;
            this.fireTableCellUpdated(i, 3);
        }
        return addOnsNotInstalled;
    }

    public static void removeAddOn(List<AddOn> addOns, String id) {
        Iterator<AddOn> it = addOns.iterator();
        while (it.hasNext()) {
            AddOn addOn = it.next();
            if (!addOn.getId().equals(id)) continue;
            it.remove();
            return;
        }
    }

    @Override
    protected void restoreInstallationStatusFailedDownload(AddOnWrapper aow) {
        aow.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
    }

    @Override
    protected AddOn getMissingAddOn(String addOnId) {
        AddOn addOn = super.getMissingAddOn(addOnId);
        if (addOn != null) {
            return addOn;
        }
        if (this.availableAddOns != null) {
            return this.availableAddOns.getAddOn(addOnId);
        }
        return null;
    }
}

